-- MySQL dump 10.13  Distrib 8.3.0, for macos14.2 (arm64)
--
-- Host: 127.0.0.1    Database: shofy
-- ------------------------------------------------------
-- Server version	8.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'pw0llpKMIRBIwWFSlZrFBNLI4M2xVzKb',1,'2024-03-05 00:55:56','2024-03-05 00:55:56','2024-03-05 00:55:56');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'Ads 1','2029-03-05 00:00:00','not_set','UROL9F9ZZVAA','main/banners/1.jpg','/products',0,1,'published','2024-03-05 00:56:09','2024-03-05 00:56:09',1,NULL,NULL),(2,'Ads 2','2029-03-05 00:00:00','not_set','B30VDBKO7SBF','main/banners/2.jpg','/products',0,2,'published','2024-03-05 00:56:09','2024-03-05 00:56:09',1,NULL,NULL),(3,'Ads 3','2029-03-05 00:00:00','not_set','WXAUTIJV1QU0','fashion/banners/1.jpg','/products',0,3,'published','2024-03-05 00:56:09','2024-03-05 00:56:09',1,NULL,NULL),(4,'Ads 4','2029-03-05 00:00:00','not_set','7Z5RXBBWV7J2','fashion/banners/2.jpg','/products',0,4,'published','2024-03-05 00:56:09','2024-03-05 00:56:09',1,NULL,NULL),(5,'Ads 5','2029-03-05 00:00:00','not_set','JY08TDO8FG1E','fashion/banners/3.jpg','/products',0,5,'published','2024-03-05 00:56:09','2024-03-05 00:56:09',1,NULL,NULL),(6,'Ads 6','2029-03-05 00:00:00','not_set','VKJNCBIBQC1O','fashion/banners/4.jpg','/products',0,6,'published','2024-03-05 00:56:09','2024-03-05 00:56:09',1,NULL,NULL);
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Enjoy free shipping on all orders over $99! Shop now and save on delivery costs.',0,NULL,NULL,0,1,'2024-03-05 07:56:04',NULL,1,'2024-03-05 00:56:04','2024-03-05 00:56:04'),(2,'Announcement 2','Need assistance? Our customer support is available 24/7 to help you with any questions or concerns.',0,NULL,NULL,0,1,'2024-03-05 07:56:04',NULL,1,'2024-03-05 00:56:04','2024-03-05 00:56:04'),(3,'Announcement 3','Shop with confidence! We offer a hassle-free 30 days return service for your peace of mind.',0,NULL,NULL,0,1,'2024-03-05 07:56:04',NULL,1,'2024-03-05 00:56:04','2024-03-05 00:56:04');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Crisp Bread &amp; Cake',0,'Laborum ut commodi similique enim praesentium fuga. Tenetur modi est vel dignissimos molestiae facilis. Voluptatem sit magnam perferendis quis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2024-03-05 00:56:00','2024-03-05 00:56:00'),(2,'Fashion',0,'Libero et at ipsam ullam nihil est. Libero ratione et in accusantium voluptatum voluptas. Magnam consequuntur consequuntur dolorem maxime quis ipsam dignissimos. Illo aperiam quaerat aliquam.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:00','2024-03-05 00:56:00'),(3,'Electronic',0,'Ipsum exercitationem aut libero eaque similique. Delectus quasi perferendis dolor. Cum unde labore fugiat nam temporibus quisquam recusandae.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:00','2024-03-05 00:56:00'),(4,'Commercial',0,'Aut blanditiis aut repellendus. Culpa vitae modi expedita velit occaecati ad. Et animi consequatur itaque fugiat sequi.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:00','2024-03-05 00:56:00'),(5,'Organic Fruits',0,'Deserunt sunt facilis et quo. Aut et culpa velit voluptas rem harum culpa nobis. Nulla id illo ut suscipit culpa officiis eos. Expedita veritatis occaecati ad qui tempora aperiam.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:00','2024-03-05 00:56:00'),(6,'Ecological',0,'Quia et beatae aut earum. Odio quis cum et. Itaque et nam unde voluptas quo et. Sunt praesentium autem quia voluptatem aut et nobis dolore.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:56:00','2024-03-05 00:56:00');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Deonte Friesen Jr.','doris64@example.org','+1-442-353-0657','926 Alisa Highway\nNew Rowan, IL 47934-1228','Saepe soluta laborum est dignissimos molestias.','Saepe saepe neque corrupti ea culpa corrupti consequuntur. Beatae est ab quae. Ut magni cum sit voluptatum doloribus at expedita voluptas. Aspernatur rem facilis inventore natus consequuntur omnis consequatur laudantium. Ipsum et et sapiente eaque. Iure et ea harum atque. Culpa accusantium accusamus voluptatibus autem. Qui ut qui facere repellat nulla. Voluptatem dolorem natus harum et consequatur dolorum neque. Minima provident magnam non aliquam. Et eum molestias ullam.','unread','2024-03-05 00:55:59','2024-03-05 00:55:59'),(2,'Theodora Yundt','hagenes.yazmin@example.com','(629) 526-4718','65924 Lucinda Plains Apt. 587\nEast Lucie, GA 06514','Dolores quo vel ut consequatur.','Commodi est rem sit rerum est corrupti. Ipsam quia eum non autem blanditiis eius doloribus. Laboriosam sunt ut velit. Accusamus officiis nisi iure quia earum voluptatibus. Praesentium ratione sunt quis ducimus itaque. Delectus ab architecto quis ipsa. Facilis delectus adipisci autem quia qui. Fuga laborum incidunt provident voluptatem et rerum. Libero modi facilis aut cumque corrupti recusandae aut. Illum ea omnis sapiente.','unread','2024-03-05 00:55:59','2024-03-05 00:55:59'),(3,'Ellsworth Ledner','ratke.vada@example.net','267.571.5739','709 Larson Crescent Apt. 641\nEladiofort, NM 67235','Ut ad dolor et qui ut mollitia cumque.','Quas reprehenderit iste et dolores. Nobis laborum ratione cupiditate quis. Commodi vero sequi maxime illum et. Explicabo reprehenderit officia vel optio. Consequuntur maiores aut tempora quis libero aut. Aliquid nostrum quas est corporis distinctio quae nisi. Ipsam reiciendis odit quasi aut. Sit placeat eligendi rerum non. Eum atque est officia exercitationem asperiores tenetur.','read','2024-03-05 00:55:59','2024-03-05 00:55:59'),(4,'Miss Joy Bogan','elna52@example.com','+1-848-504-7706','81355 Adriel Greens\nLake Jaidenton, NH 96529-0357','Enim voluptatibus voluptates non.','Voluptatum sint alias animi et. Voluptatum iste minus necessitatibus odit optio numquam. Et ratione ea non doloremque. Asperiores consequuntur repellendus ea ut molestiae aut voluptatem. Dolor quas doloremque eum eos excepturi ut. Aliquam itaque incidunt quos id quo reprehenderit. In quis sunt quas modi rem velit.','read','2024-03-05 00:55:59','2024-03-05 00:55:59'),(5,'Ubaldo Rath','verner94@example.org','442.366.1174','64987 Klocko Alley\nNadiachester, UT 91479-9247','Quasi possimus quisquam rerum.','Dolorem ipsam laboriosam nostrum architecto nobis expedita. Aut ea perspiciatis nobis. Asperiores et aut sed itaque natus corporis. Suscipit est vel sit molestiae neque et qui rerum. Reprehenderit assumenda ducimus voluptatem eaque praesentium ea. Eum molestias voluptatem explicabo qui consequatur dolor. Dolorem distinctio vel harum similique quia.','unread','2024-03-05 00:55:59','2024-03-05 00:55:59'),(6,'Allene Blick','shaun.johnston@example.com','1-651-347-8876','5949 Oren Tunnel\nWest Duaneville, IN 87985','Velit quo rerum porro fugiat.','Aut deleniti occaecati commodi nam illo. Omnis velit iste perspiciatis incidunt omnis pariatur. Et sit unde eum exercitationem nihil itaque enim. Nihil omnis sint quasi autem rerum dolores iusto et. In blanditiis blanditiis aut ea exercitationem numquam. Amet cum natus numquam architecto fugit accusantium in voluptas. Quibusdam blanditiis quibusdam iusto inventore inventore pariatur.','read','2024-03-05 00:55:59','2024-03-05 00:55:59'),(7,'Noemy Tremblay','judy72@example.net','820-376-9142','515 Mitchell Pines Apt. 756\nPort Eusebioshire, OH 53250-7940','Molestiae in ab voluptate.','Perspiciatis suscipit rem a voluptas sapiente. Qui numquam nobis commodi nesciunt soluta laudantium. Adipisci voluptatum atque qui natus eligendi optio consectetur. Voluptatem autem sunt dolor sint non. In accusamus facilis ut expedita rerum delectus eos quis. Dolores omnis quasi non omnis. Minus voluptas et quia alias commodi maiores. Quidem dolores accusamus qui earum rerum vero eligendi. Ipsa et laboriosam dolorem laborum.','unread','2024-03-05 00:55:59','2024-03-05 00:55:59'),(8,'Tiffany Rogahn','shaylee21@example.org','+1-831-395-5787','2573 Leonor Isle\nLake Pinkie, NM 16714','Ut labore et atque aut facilis.','Voluptas quae sint eligendi aliquid doloribus. Dolores velit laborum saepe ab. Quo aut maiores tempora est laborum. Nesciunt provident ut voluptas recusandae repellendus nihil. Voluptate dolore fugit neque dolorem dolorem consequuntur quod aut. Qui eveniet iusto nihil officiis. Vitae rerum perferendis earum omnis. Laborum velit porro commodi non consequatur.','read','2024-03-05 00:55:59','2024-03-05 00:55:59'),(9,'Lenny Mosciski','proberts@example.org','907-669-9648','833 Richie Points\nKingbury, NY 90661','Rerum molestias in velit dolor iure quae.','Provident repudiandae soluta dicta aut quas natus enim quibusdam. Quo tempora ipsam quia et consequuntur cum. Impedit perspiciatis sequi nihil est vel. Magni architecto inventore dolorum laudantium consequatur placeat. Minima quis quidem est laudantium quia magni voluptates. Hic dolores eius illum doloribus. Ipsam et laboriosam esse libero.','unread','2024-03-05 00:55:59','2024-03-05 00:55:59'),(10,'Lera Jacobi','anastacio60@example.org','412-955-1708','231 Flo Haven Apt. 167\nConnellyton, ID 44775','Nam earum id neque cumque ipsam.','Et tempore voluptatum excepturi nisi illo temporibus. Qui veniam fugiat odit velit eos nostrum. Voluptas molestiae dignissimos et odio. Ut perspiciatis est hic et consequatur. Vel aspernatur non velit qui. A expedita repellat magni sed nesciunt nihil et nobis. Nihil provident voluptas dolores consectetur labore facere. Quis placeat beatae ex vel. Ut architecto voluptate in inventore adipisci natus dolor. Doloribus dolorem culpa voluptas voluptatem ut ut.','read','2024-03-05 00:55:59','2024-03-05 00:55:59');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'FoodPound','New Snacks Release',NULL,NULL,'published',0,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(2,'iTea JSC','Happy Tea 100% Organic. From $29.9',NULL,NULL,'published',1,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(3,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',2,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(4,'Shofy','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',3,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(5,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',4,1,'2024-03-05 00:55:56','2024-03-05 00:55:56');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(2,'EUR','€',0,2,1,0,0.84,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(3,'VND','₫',0,0,2,0,23203,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(4,'NGN','₦',1,2,2,0,895.52,'2024-03-05 00:55:56','2024-03-05 00:55:56');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Dawn Schmidt IV','customer@botble.com','+19854553047','LU','Virginia','Beattytown','8508 Deven Flats',1,1,'2024-03-05 00:55:57','2024-03-05 00:55:57','39516'),(2,'Dawn Schmidt IV','customer@botble.com','+18456474018','TT','Colorado','Kaylinshire','9698 Rippin Villages',1,0,'2024-03-05 00:55:57','2024-03-05 00:55:57','09787-9903'),(3,'Angeline Turcotte','vendor@botble.com','+13057884515','GM','Tennessee','North Adelinechester','26158 Ankunding Islands',2,1,'2024-03-05 00:55:57','2024-03-05 00:55:57','00560-3374'),(4,'Angeline Turcotte','vendor@botble.com','+16154255956','BL','Vermont','South Daytonburgh','21552 Batz Harbors',2,0,'2024-03-05 00:55:57','2024-03-05 00:55:57','08031'),(5,'Kaela Zemlak','edwardo.hirthe@example.net','+14357321567','GT','Montana','Keeganstad','496 Fay Mills',3,1,'2024-03-05 00:55:57','2024-03-05 00:55:57','63383'),(6,'Mr. Austen Dicki III','twest@example.com','+17194461476','ML','Michigan','New Hoyt','521 Schowalter Coves Apt. 739',4,1,'2024-03-05 00:55:58','2024-03-05 00:55:58','42330-1944'),(7,'Madisyn Gusikowski','bessie92@example.org','+18708329326','TJ','California','East Aliyah','63847 Auer Cliffs Apt. 059',5,1,'2024-03-05 00:55:58','2024-03-05 00:55:58','49077'),(8,'Ms. Danyka Kshlerin IV','kuhlman.berry@example.net','+16789131651','VU','Arkansas','North Trenton','9279 Jairo Mission Suite 943',6,1,'2024-03-05 00:55:58','2024-03-05 00:55:58','24621-0083'),(9,'Phyllis Connelly DVM','ona85@example.net','+15518352276','CA','South Carolina','Port Carrie','2789 Leslie Inlet Apt. 863',7,1,'2024-03-05 00:55:58','2024-03-05 00:55:58','99414-8353'),(10,'Angelita Dare','klocko.eli@example.net','+14155406880','PS','Kansas','West Alia','93960 Corkery Glens Apt. 526',8,1,'2024-03-05 00:55:59','2024-03-05 00:55:59','73111-3812'),(11,'Kristin Steuber','deanna63@example.org','+15748319854','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',9,1,'2024-03-05 00:55:59','2024-03-05 00:55:59','94755-0780'),(12,'Krystal Wunsch','jaeden.dach@example.org','+19063307387','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',10,1,'2024-03-05 00:55:59','2024-03-05 00:55:59','82821');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Dawn Schmidt IV','customer@botble.com','$2y$12$LWiUewOu8y93kOrI5DwHHOE/FmbxzYewnZZKJOiAlkW8IqFXhaNGS','main/customers/9.jpg','1996-02-17','+12834293111',NULL,'2024-03-05 00:55:57','2024-03-05 00:56:02','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(2,'Angeline Turcotte','vendor@botble.com','$2y$12$0nmDwavg8hx6IboVdaZUCerd8gqyFBjzMcwpelGay3cn2qQux6H1i','main/customers/2.jpg','2003-02-08','+16084812896',NULL,'2024-03-05 00:55:57','2024-03-05 00:56:02','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(3,'Kaela Zemlak','edwardo.hirthe@example.net','$2y$12$udWhhedj3jMJlgya9xarR.D9KSTlGwMzpTpb82w1HaiRRcuY7pA.O','main/customers/1.jpg','1984-02-08','+14022721500',NULL,'2024-03-05 00:55:57','2024-03-05 00:56:02','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(4,'Mr. Austen Dicki III','twest@example.com','$2y$12$uyvNftXIu/hc.Iw2u7fVoeMrC07lO3VHV.1l.3503az5d58UYOQka','main/customers/2.jpg','1996-02-11','+18382123399',NULL,'2024-03-05 00:55:58','2024-03-05 00:56:03','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(5,'Madisyn Gusikowski','bessie92@example.org','$2y$12$33VkI8Gf35H0lyfFgK6tOegkHEIYzjq/xAXazh8PTrjVcVaBPW6ey','main/customers/3.jpg','1981-02-08','+12563863491',NULL,'2024-03-05 00:55:58','2024-03-05 00:56:03','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(6,'Ms. Danyka Kshlerin IV','kuhlman.berry@example.net','$2y$12$iXQmlV5cHP4Mon7znkwVheSEA0FQQs/CRWI9zfOGkDOsLYYbZ6/wa','main/customers/4.jpg','1999-03-02','+16676440219',NULL,'2024-03-05 00:55:58','2024-03-05 00:56:03','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(7,'Phyllis Connelly DVM','ona85@example.net','$2y$12$oVWDkIPRrzMjz1HSsDhg8exXY7Xu9Om2RhknWTdZmjp3L/FgIUkky','main/customers/5.jpg','1980-02-04','+16023353420',NULL,'2024-03-05 00:55:58','2024-03-05 00:56:03','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(8,'Angelita Dare','klocko.eli@example.net','$2y$12$BFDZzqLvhwr4o6A1BV7QZexcNMvRK/I4Xyx/CvjOmoo.5pIdyxpq2','main/customers/6.jpg','2001-02-21','+14756732804',NULL,'2024-03-05 00:55:59','2024-03-05 00:56:04','2024-03-05 07:55:57',NULL,1,'2024-03-05 07:56:02','activated',NULL),(9,'Kristin Steuber','deanna63@example.org','$2y$12$7Ijv4ud2wX2QmMVSE9k0xeI4XtCd.WC.zuweW26j5fg4v2MsTHEci','main/customers/7.jpg','1987-03-01','+15403302537',NULL,'2024-03-05 00:55:59','2024-03-05 00:56:04','2024-03-05 07:55:57',NULL,0,NULL,'activated',NULL),(10,'Krystal Wunsch','jaeden.dach@example.org','$2y$12$eKKp0zpuguG8x02k4i6tPu74j35H.VLQbUtBiPR.XJ4F52EIOkh4e','main/customers/8.jpg','1990-02-18','+12796316650',NULL,'2024-03-05 00:55:59','2024-03-05 00:56:04','2024-03-05 07:55:57',NULL,0,NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','XBDKSWWO9FL4','2024-03-04 07:56:01',NULL,NULL,0,187,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(2,'Discount 2','6PLYXHYDBE3O','2024-03-04 07:56:01','2024-03-26 07:56:01',NULL,0,122,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(3,'Discount 3','PTT2B2FINVPT','2024-03-04 07:56:01','2024-03-30 07:56:01',NULL,0,570,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(4,'Discount 4','6RQVJU2ML6UL','2024-03-04 07:56:01',NULL,NULL,0,982,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(5,'Discount 5','Z721YQSAAF03','2024-03-04 07:56:01','2024-03-13 07:56:01',NULL,0,334,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(6,'Discount 6','YHTZPMAWZECK','2024-03-04 07:56:01','2024-03-25 07:56:01',NULL,0,9,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(7,'Discount 7','UHJ1UVEILWGV','2024-03-04 07:56:01','2024-03-15 07:56:01',NULL,0,752,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(8,'Discount 8','DAYWILIZQPEE','2024-03-04 07:56:01','2024-03-17 07:56:01',NULL,0,748,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(9,'Discount 9','S2BSJ1XUGLJZ','2024-03-04 07:56:01','2024-03-19 07:56:01',NULL,0,19,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL),(10,'Discount 10','V5TERJZFVYWJ','2024-03-04 07:56:01','2024-03-29 07:56:01',NULL,0,97,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL,NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,229.12,11,3),(1,2,414.4,10,1),(1,3,372,16,5),(1,4,664.56,14,5),(1,5,1178.4,8,3),(1,6,399.59,7,4),(1,7,789.96,6,1),(1,8,955.6019,18,5),(1,9,816.66,8,2),(1,10,482.08,15,3);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2024-03-25 00:00:00','published','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(1,2,'2 Year',10,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(1,3,'3 Year',20,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(2,4,'4GB',0,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(2,5,'8GB',10,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(2,6,'16GB',20,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(3,7,'Core i5',0,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(3,8,'Core i7',10,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(3,9,'Core i9',20,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(4,10,'128GB',0,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(4,11,'256GB',10,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(4,12,'512GB',20,9999,0,'2024-03-05 00:56:01','2024-03-05 00:56:01');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2024-03-05 00:56:01','2024-03-05 00:56:01');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
INSERT INTO `ec_invoice_items` VALUES (1,1,'Botble\\Ecommerce\\Models\\Product',92,'Printed Palazzo Pants',NULL,'fashion/products/product-4.png',1,2431.00,2431.00,0.00,0.00,2431.00,'{\"sku\":\"UO-150-A0\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-05 00:56:10','2024-03-05 00:56:10'),(2,2,'Botble\\Ecommerce\\Models\\Product',108,'Cropped Cable Knit Sweater',NULL,'fashion/products/product-4.png',1,2242.00,2242.00,0.00,0.00,2242.00,'{\"sku\":\"E2-121-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}','2024-03-05 00:56:10','2024-03-05 00:56:10'),(3,3,'Botble\\Ecommerce\\Models\\Product',56,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-1.png',3,1950.00,5850.00,0.00,0.00,5850.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:56:10','2024-03-05 00:56:10'),(4,3,'Botble\\Ecommerce\\Models\\Product',65,'Bohemian Fringe Handbag',NULL,'fashion/products/product-1.png',2,908.00,1816.00,0.00,0.00,1816.00,'{\"sku\":\"MD-111-A0-A3\",\"attributes\":\"(Color: Blue, Size: XL)\"}','2024-03-05 00:56:10','2024-03-05 00:56:10'),(5,4,'Botble\\Ecommerce\\Models\\Product',112,'Leopard Print Midi Skirt',NULL,'fashion/products/product-1.png',1,2304.00,2304.00,0.00,0.00,2304.00,'{\"sku\":\"AH-129-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}','2024-03-05 00:56:10','2024-03-05 00:56:10'),(6,5,'Botble\\Ecommerce\\Models\\Product',156,'Metallic Pleated Maxi Skirt',NULL,'fashion/products/product-8.png',2,1838.00,3676.00,0.00,0.00,3676.00,'{\"sku\":\"LW-200-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:10','2024-03-05 00:56:10'),(7,6,'Botble\\Ecommerce\\Models\\Product',64,'Bohemian Fringe Handbag',NULL,'fashion/products/product-7.png',1,908.00,908.00,0.00,0.00,908.00,'{\"sku\":\"MD-111-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-05 00:56:11','2024-03-05 00:56:11'),(8,7,'Botble\\Ecommerce\\Models\\Product',84,'Quilted Crossbody Bag',NULL,'fashion/products/product-7.png',2,800.00,1600.00,0.00,0.00,1600.00,'{\"sku\":\"JQ-195-A0-A1\",\"attributes\":\"(Size: L, Color: Brown)\"}','2024-03-05 00:56:11','2024-03-05 00:56:11'),(9,8,'Botble\\Ecommerce\\Models\\Product',141,'Embroidered Bomber Jacket',NULL,'fashion/products/product-1.png',3,309.00,927.00,0.00,0.00,927.00,'{\"sku\":\"LJ-162-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-05 00:56:11','2024-03-05 00:56:11'),(10,9,'Botble\\Ecommerce\\Models\\Product',44,'Vintage Denim Jacket',NULL,'fashion/products/product-4.png',2,716.00,1432.00,0.00,0.00,1432.00,'{\"sku\":\"PH-114-A0\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-05 00:56:11','2024-03-05 00:56:11'),(11,10,'Botble\\Ecommerce\\Models\\Product',103,'Suede Pointed-Toe Pumps',NULL,'fashion/products/product-1.png',1,1379.00,1379.00,0.00,0.00,1379.00,'{\"sku\":\"FR-144-A0\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-05 00:56:11','2024-03-05 00:56:11'),(12,11,'Botble\\Ecommerce\\Models\\Product',155,'Metallic Pleated Maxi Skirt',NULL,'fashion/products/product-7.png',1,1838.00,1838.00,0.00,0.00,1838.00,'{\"sku\":\"LW-200-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:12','2024-03-05 00:56:12'),(13,12,'Botble\\Ecommerce\\Models\\Product',58,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-4.png',3,1950.00,5850.00,0.00,0.00,5850.00,'{\"sku\":\"VD-173-A0-A4\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-05 00:56:12','2024-03-05 00:56:12'),(14,13,'Botble\\Ecommerce\\Models\\Product',82,'Velvet Evening Gown',NULL,'fashion/products/product-7.png',3,2071.00,6213.00,0.00,0.00,6213.00,'{\"sku\":\"VW-175-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-05 00:56:12','2024-03-05 00:56:12'),(15,14,'Botble\\Ecommerce\\Models\\Product',127,'Wide Brim Floppy Hat',NULL,'fashion/products/product-1.png',2,1376.00,2752.00,0.00,0.00,2752.00,'{\"sku\":\"EN-191-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-05 00:56:12','2024-03-05 00:56:12'),(16,15,'Botble\\Ecommerce\\Models\\Product',99,'Off-Shoulder Ruffle Top',NULL,'fashion/products/product-7.png',3,1722.00,5166.00,0.00,0.00,5166.00,'{\"sku\":\"UM-125-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-05 00:56:12','2024-03-05 00:56:12'),(17,16,'Botble\\Ecommerce\\Models\\Product',125,'Beaded Evening Clutch',NULL,'fashion/products/product-7.png',3,1512.00,4536.00,0.00,0.00,4536.00,'{\"sku\":\"TF-194-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:12','2024-03-05 00:56:12'),(18,17,'Botble\\Ecommerce\\Models\\Product',86,'Distressed Skinny Jeans (Digital)',NULL,'fashion/products/product-1.png',1,490.00,490.00,0.00,0.00,490.00,'{\"sku\":\"KJ-145-A0\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-05 00:56:13','2024-03-05 00:56:13'),(19,18,'Botble\\Ecommerce\\Models\\Product',109,'Cropped Cable Knit Sweater',NULL,'fashion/products/product-6.png',1,2242.00,2242.00,0.00,0.00,2242.00,'{\"sku\":\"E2-121-A0-A3\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:56:13','2024-03-05 00:56:13'),(20,19,'Botble\\Ecommerce\\Models\\Product',49,'Floral Maxi Dress',NULL,'fashion/products/product-6.png',2,518.00,1036.00,0.00,0.00,1036.00,'{\"sku\":\"NH-177-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-05 00:56:13','2024-03-05 00:56:13'),(21,19,'Botble\\Ecommerce\\Models\\Product',140,'Buckle Detail Ankle Booties',NULL,'fashion/products/product-6.png',3,532.00,1596.00,0.00,0.00,1596.00,'{\"sku\":\"AJ-168-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:13','2024-03-05 00:56:13'),(22,20,'Botble\\Ecommerce\\Models\\Product',122,'Ruffled Wrap Dress',NULL,'fashion/products/product-8.png',1,2098.00,2098.00,0.00,0.00,2098.00,'{\"sku\":\"Z1-112-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}','2024-03-05 00:56:13','2024-03-05 00:56:13'),(23,21,'Botble\\Ecommerce\\Models\\Product',149,'Chunky Knit Infinity Scarf (Digital)',NULL,'fashion/products/product-1.png',2,265.00,530.00,0.00,0.00,530.00,'{\"sku\":\"NW-108-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}','2024-03-05 00:56:13','2024-03-05 00:56:13'),(24,22,'Botble\\Ecommerce\\Models\\Product',47,'Vintage Denim Jacket',NULL,'fashion/products/product-7.png',3,716.00,2148.00,0.00,0.00,2148.00,'{\"sku\":\"PH-114-A0-A3\",\"attributes\":\"(Color: Blue, Size: M)\"}','2024-03-05 00:56:14','2024-03-05 00:56:14'),(25,23,'Botble\\Ecommerce\\Models\\Product',70,'High-Waisted Wide Leg Trousers',NULL,'fashion/products/product-6.png',3,1047.00,3141.00,0.00,0.00,3141.00,'{\"sku\":\"6Y-120-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}','2024-03-05 00:56:14','2024-03-05 00:56:14'),(26,24,'Botble\\Ecommerce\\Models\\Product',74,'Embroidered Boho Blouse',NULL,'fashion/products/product-8.png',2,1048.00,2096.00,0.00,0.00,2096.00,'{\"sku\":\"9Q-161-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-05 00:56:14','2024-03-05 00:56:14'),(27,25,'Botble\\Ecommerce\\Models\\Product',83,'Quilted Crossbody Bag',NULL,'fashion/products/product-1.png',1,800.00,800.00,0.00,0.00,800.00,'{\"sku\":\"JQ-195-A0\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-05 00:56:14','2024-03-05 00:56:14'),(28,26,'Botble\\Ecommerce\\Models\\Product',72,'Embroidered Boho Blouse',NULL,'fashion/products/product-7.png',3,1048.00,3144.00,0.00,0.00,3144.00,'{\"sku\":\"9Q-161-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-05 00:56:14','2024-03-05 00:56:14'),(29,27,'Botble\\Ecommerce\\Models\\Product',130,'Denim Overall Jumpsuit (Digital)',NULL,'fashion/products/product-4.png',1,682.00,682.00,0.00,0.00,682.00,'{\"sku\":\"CL-103-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}','2024-03-05 00:56:15','2024-03-05 00:56:15'),(30,28,'Botble\\Ecommerce\\Models\\Product',67,'Silk Scarf with Geometric Print (Digital)',NULL,'fashion/products/product-7.png',1,2497.00,2497.00,0.00,0.00,2497.00,'{\"sku\":\"07-101-A0\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-05 00:56:15','2024-03-05 00:56:15'),(31,29,'Botble\\Ecommerce\\Models\\Product',120,'Boho Fringed Kimono (Digital)',NULL,'fashion/products/product-5.png',1,1063.00,1063.00,0.00,0.00,1063.00,'{\"sku\":\"ZU-186-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:15','2024-03-05 00:56:15'),(32,30,'Botble\\Ecommerce\\Models\\Product',122,'Ruffled Wrap Dress',NULL,'fashion/products/product-8.png',2,2098.00,4196.00,0.00,0.00,4196.00,'{\"sku\":\"Z1-112-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}','2024-03-05 00:56:15','2024-03-05 00:56:15'),(33,31,'Botble\\Ecommerce\\Models\\Product',55,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-6.png',3,1950.00,5850.00,0.00,0.00,5850.00,'{\"sku\":\"VD-173-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-05 00:56:15','2024-03-05 00:56:15'),(34,32,'Botble\\Ecommerce\\Models\\Product',68,'Silk Scarf with Geometric Print (Digital)',NULL,'fashion/products/product-1.png',3,2497.00,7491.00,0.00,0.00,7491.00,'{\"sku\":\"07-101-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}','2024-03-05 00:56:15','2024-03-05 00:56:15'),(35,33,'Botble\\Ecommerce\\Models\\Product',82,'Velvet Evening Gown',NULL,'fashion/products/product-7.png',3,2071.00,6213.00,0.00,0.00,6213.00,'{\"sku\":\"VW-175-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-05 00:56:16','2024-03-05 00:56:16'),(36,34,'Botble\\Ecommerce\\Models\\Product',127,'Wide Brim Floppy Hat',NULL,'fashion/products/product-1.png',2,1376.00,2752.00,0.00,0.00,2752.00,'{\"sku\":\"EN-191-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-05 00:56:16','2024-03-05 00:56:16'),(37,35,'Botble\\Ecommerce\\Models\\Product',56,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-1.png',3,1950.00,5850.00,0.00,0.00,5850.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:56:16','2024-03-05 00:56:16'),(38,36,'Botble\\Ecommerce\\Models\\Product',148,'Chunky Knit Infinity Scarf (Digital)',NULL,'fashion/products/product-5.png',3,265.00,795.00,0.00,0.00,795.00,'{\"sku\":\"NW-108-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-05 00:56:16','2024-03-05 00:56:16'),(39,37,'Botble\\Ecommerce\\Models\\Product',45,'Vintage Denim Jacket',NULL,'fashion/products/product-5.png',2,716.00,1432.00,0.00,0.00,1432.00,'{\"sku\":\"PH-114-A0-A1\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-05 00:56:16','2024-03-05 00:56:16'),(40,38,'Botble\\Ecommerce\\Models\\Product',64,'Bohemian Fringe Handbag',NULL,'fashion/products/product-7.png',2,908.00,1816.00,0.00,0.00,1816.00,'{\"sku\":\"MD-111-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-05 00:56:16','2024-03-05 00:56:16'),(41,39,'Botble\\Ecommerce\\Models\\Product',88,'Distressed Skinny Jeans (Digital)',NULL,'fashion/products/product-6.png',3,490.00,1470.00,0.00,0.00,1470.00,'{\"sku\":\"KJ-145-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}','2024-03-05 00:56:17','2024-03-05 00:56:17'),(42,40,'Botble\\Ecommerce\\Models\\Product',136,'Velour Tracksuit Set',NULL,'fashion/products/product-2.png',1,2004.00,2004.00,0.00,0.00,2004.00,'{\"sku\":\"QJ-126-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-05 00:56:17','2024-03-05 00:56:17'),(43,41,'Botble\\Ecommerce\\Models\\Product',58,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-4.png',3,1950.00,5850.00,0.00,0.00,5850.00,'{\"sku\":\"VD-173-A0-A4\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-05 00:56:17','2024-03-05 00:56:17'),(44,41,'Botble\\Ecommerce\\Models\\Product',131,'Embellished Ballet Flats',NULL,'fashion/products/product-2.png',1,1465.00,1465.00,0.00,0.00,1465.00,'{\"sku\":\"VL-197-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}','2024-03-05 00:56:17','2024-03-05 00:56:17'),(45,42,'Botble\\Ecommerce\\Models\\Product',85,'Quilted Crossbody Bag',NULL,'fashion/products/product-4.png',3,800.00,2400.00,0.00,0.00,2400.00,'{\"sku\":\"JQ-195-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-05 00:56:17','2024-03-05 00:56:17'),(46,43,'Botble\\Ecommerce\\Models\\Product',132,'Pleated Midi Skirt',NULL,'fashion/products/product-8.png',1,1155.00,1155.00,0.00,0.00,1155.00,'{\"sku\":\"LC-188-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}','2024-03-05 00:56:17','2024-03-05 00:56:17'),(47,44,'Botble\\Ecommerce\\Models\\Product',56,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-1.png',2,1950.00,3900.00,0.00,0.00,3900.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:56:18','2024-03-05 00:56:18'),(48,45,'Botble\\Ecommerce\\Models\\Product',141,'Embroidered Bomber Jacket',NULL,'fashion/products/product-1.png',1,309.00,309.00,0.00,0.00,309.00,'{\"sku\":\"LJ-162-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-05 00:56:18','2024-03-05 00:56:18'),(49,46,'Botble\\Ecommerce\\Models\\Product',58,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-4.png',3,1950.00,5850.00,0.00,0.00,5850.00,'{\"sku\":\"VD-173-A0-A4\",\"attributes\":\"(Size: L, Color: Black)\"}','2024-03-05 00:56:18','2024-03-05 00:56:18'),(50,47,'Botble\\Ecommerce\\Models\\Product',75,'Statement Chunky Necklace',NULL,'fashion/products/product-5.png',1,306.00,306.00,0.00,0.00,306.00,'{\"sku\":\"YP-121-A0\",\"attributes\":\"(Color: Green, Size: M)\"}','2024-03-05 00:56:18','2024-03-05 00:56:18'),(51,48,'Botble\\Ecommerce\\Models\\Product',56,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-1.png',2,1950.00,3900.00,0.00,0.00,3900.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:56:18','2024-03-05 00:56:18'),(52,48,'Botble\\Ecommerce\\Models\\Product',66,'Bohemian Fringe Handbag',NULL,'fashion/products/product-4.png',3,908.00,2724.00,0.00,0.00,2724.00,'{\"sku\":\"MD-111-A0-A4\",\"attributes\":\"(Color: Green, Size: XXL)\"}','2024-03-05 00:56:18','2024-03-05 00:56:18'),(53,49,'Botble\\Ecommerce\\Models\\Product',107,'Cropped Cable Knit Sweater',NULL,'fashion/products/product-7.png',1,2242.00,2242.00,0.00,0.00,2242.00,'{\"sku\":\"E2-121-A0-A1\",\"attributes\":\"(Color: Blue, Size: XL)\"}','2024-03-05 00:56:18','2024-03-05 00:56:18'),(54,50,'Botble\\Ecommerce\\Models\\Product',120,'Boho Fringed Kimono (Digital)',NULL,'fashion/products/product-5.png',3,1063.00,3189.00,0.00,0.00,3189.00,'{\"sku\":\"ZU-186-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-05 00:56:19','2024-03-05 00:56:19'),(55,51,'Botble\\Ecommerce\\Models\\Product',139,'Buckle Detail Ankle Booties',NULL,'fashion/products/product-2.png',3,532.00,1596.00,0.00,0.00,1596.00,'{\"sku\":\"AJ-168-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}','2024-03-05 00:56:19','2024-03-05 00:56:19');
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
INSERT INTO `ec_invoices` VALUES (1,'Botble\\Ecommerce\\Models\\Order',1,'INV-1','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2431.00,0.00,0.00,0.00,'1','default',NULL,NULL,2431.00,NULL,1,'pending',NULL,'2024-02-29 00:56:10','2024-03-05 00:56:10'),(2,'Botble\\Ecommerce\\Models\\Order',2,'INV-2','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2242.00,0.00,0.00,0.00,'1','default',NULL,NULL,2242.00,NULL,2,'completed','2024-03-05 00:56:10','2024-02-29 00:56:10','2024-03-05 00:56:10'),(3,'Botble\\Ecommerce\\Models\\Order',3,'INV-3','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,7666.00,0.00,0.00,0.00,'1','default',NULL,NULL,7666.00,NULL,3,'pending',NULL,'2024-02-26 02:56:10','2024-03-05 00:56:10'),(4,'Botble\\Ecommerce\\Models\\Order',4,'INV-4','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2304.00,0.00,0.00,0.00,'1','default',NULL,NULL,2304.00,NULL,4,'completed','2024-03-05 00:56:10','2024-02-27 16:56:10','2024-03-05 00:56:10'),(5,'Botble\\Ecommerce\\Models\\Order',5,'INV-5','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,3676.00,0.00,0.00,0.00,'1','default',NULL,NULL,3676.00,NULL,5,'completed','2024-03-05 00:56:10','2024-02-18 04:56:10','2024-03-05 00:56:10'),(6,'Botble\\Ecommerce\\Models\\Order',6,'INV-6','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,908.00,0.00,0.00,0.00,'1','default',NULL,NULL,908.00,NULL,6,'pending',NULL,'2024-02-22 00:56:11','2024-03-05 00:56:11'),(7,'Botble\\Ecommerce\\Models\\Order',7,'INV-7','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,1600.00,0.00,0.00,0.00,'1','default',NULL,NULL,1600.00,NULL,7,'completed','2024-03-05 00:56:11','2024-02-29 12:56:11','2024-03-05 00:56:11'),(8,'Botble\\Ecommerce\\Models\\Order',8,'INV-8','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,927.00,0.00,0.00,0.00,'1','default',NULL,NULL,927.00,NULL,8,'completed','2024-03-05 00:56:11','2024-03-03 12:56:11','2024-03-05 00:56:11'),(9,'Botble\\Ecommerce\\Models\\Order',9,'INV-9','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,1432.00,0.00,0.00,0.00,'1','default',NULL,NULL,1432.00,NULL,9,'completed','2024-03-05 00:56:11','2024-02-29 18:56:11','2024-03-05 00:56:11'),(10,'Botble\\Ecommerce\\Models\\Order',10,'INV-10','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,1379.00,0.00,0.00,0.00,'1','default',NULL,NULL,1379.00,NULL,10,'completed','2024-03-05 00:56:11','2024-02-28 08:56:11','2024-03-05 00:56:11'),(11,'Botble\\Ecommerce\\Models\\Order',11,'INV-11','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,1838.00,0.00,0.00,0.00,'1','default',NULL,NULL,1838.00,NULL,11,'completed','2024-03-05 00:56:12','2024-02-29 18:56:12','2024-03-05 00:56:12'),(12,'Botble\\Ecommerce\\Models\\Order',12,'INV-12','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,5850.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5850.00,NULL,12,'completed','2024-03-05 00:56:12','2024-02-20 16:56:12','2024-03-05 00:56:12'),(13,'Botble\\Ecommerce\\Models\\Order',13,'INV-13','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,6213.00,0.00,0.00,0.00,'1','default',NULL,NULL,6213.00,NULL,13,'completed','2024-03-05 00:56:12','2024-03-03 16:56:12','2024-03-05 00:56:12'),(14,'Botble\\Ecommerce\\Models\\Order',14,'INV-14','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2752.00,0.00,0.00,0.00,'1','default',NULL,NULL,2752.00,NULL,14,'completed','2024-03-05 00:56:12','2024-02-23 08:56:12','2024-03-05 00:56:12'),(15,'Botble\\Ecommerce\\Models\\Order',15,'INV-15','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,5166.00,0.00,0.00,0.00,'1','default',NULL,NULL,5166.00,NULL,15,'completed','2024-03-05 00:56:12','2024-02-27 18:56:12','2024-03-05 00:56:12'),(16,'Botble\\Ecommerce\\Models\\Order',16,'INV-16','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,4536.00,0.00,0.00,0.00,'1','default',NULL,NULL,4536.00,NULL,16,'completed','2024-03-05 00:56:12','2024-02-26 12:56:12','2024-03-05 00:56:12'),(17,'Botble\\Ecommerce\\Models\\Order',17,'INV-17','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,490.00,0.00,0.00,0.00,NULL,'',NULL,NULL,490.00,NULL,17,'completed','2024-03-05 00:56:13','2024-03-02 16:56:13','2024-03-05 00:56:13'),(18,'Botble\\Ecommerce\\Models\\Order',18,'INV-18','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2242.00,0.00,0.00,0.00,'1','default',NULL,NULL,2242.00,NULL,18,'completed','2024-03-05 00:56:13','2024-03-03 20:56:13','2024-03-05 00:56:13'),(19,'Botble\\Ecommerce\\Models\\Order',19,'INV-19','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,2632.00,0.00,0.00,0.00,'1','default',NULL,NULL,2632.00,NULL,19,'completed','2024-03-05 00:56:13','2024-02-29 16:56:13','2024-03-05 00:56:13'),(20,'Botble\\Ecommerce\\Models\\Order',20,'INV-20','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,2098.00,0.00,0.00,0.00,'1','default',NULL,NULL,2098.00,NULL,20,'completed','2024-03-05 00:56:13','2024-02-25 08:56:13','2024-03-05 00:56:13'),(21,'Botble\\Ecommerce\\Models\\Order',21,'INV-21','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,530.00,0.00,0.00,0.00,NULL,'',NULL,NULL,530.00,NULL,21,'completed','2024-03-05 00:56:13','2024-02-28 14:56:13','2024-03-05 00:56:13'),(22,'Botble\\Ecommerce\\Models\\Order',22,'INV-22','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2148.00,0.00,0.00,0.00,'1','default',NULL,NULL,2148.00,NULL,22,'pending',NULL,'2024-02-24 00:56:14','2024-03-05 00:56:14'),(23,'Botble\\Ecommerce\\Models\\Order',23,'INV-23','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,3141.00,0.00,0.00,0.00,'1','default',NULL,NULL,3141.00,NULL,23,'pending',NULL,'2024-02-26 00:56:14','2024-03-05 00:56:14'),(24,'Botble\\Ecommerce\\Models\\Order',24,'INV-24','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,2096.00,0.00,0.00,0.00,'1','default',NULL,NULL,2096.00,NULL,24,'pending',NULL,'2024-02-25 18:56:14','2024-03-05 00:56:14'),(25,'Botble\\Ecommerce\\Models\\Order',25,'INV-25','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,800.00,0.00,0.00,0.00,'1','default',NULL,NULL,800.00,NULL,25,'completed','2024-03-05 00:56:14','2024-02-24 20:56:14','2024-03-05 00:56:14'),(26,'Botble\\Ecommerce\\Models\\Order',26,'INV-26','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,3144.00,0.00,0.00,0.00,'1','default',NULL,NULL,3144.00,NULL,26,'pending',NULL,'2024-02-25 16:56:14','2024-03-05 00:56:14'),(27,'Botble\\Ecommerce\\Models\\Order',27,'INV-27','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,682.00,0.00,0.00,0.00,NULL,'',NULL,NULL,682.00,NULL,27,'completed','2024-03-05 00:56:15','2024-02-27 08:56:15','2024-03-05 00:56:15'),(28,'Botble\\Ecommerce\\Models\\Order',28,'INV-28','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,2497.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2497.00,NULL,28,'pending',NULL,'2024-02-29 12:56:15','2024-03-05 00:56:15'),(29,'Botble\\Ecommerce\\Models\\Order',29,'INV-29','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,1063.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1063.00,NULL,29,'completed','2024-03-05 00:56:15','2024-03-03 12:56:15','2024-03-05 00:56:15'),(30,'Botble\\Ecommerce\\Models\\Order',30,'INV-30','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,4196.00,0.00,0.00,0.00,'1','default',NULL,NULL,4196.00,NULL,30,'pending',NULL,'2024-03-01 06:56:15','2024-03-05 00:56:15'),(31,'Botble\\Ecommerce\\Models\\Order',31,'INV-31','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,5850.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5850.00,NULL,31,'completed','2024-03-05 00:56:15','2024-02-28 16:56:15','2024-03-05 00:56:15'),(32,'Botble\\Ecommerce\\Models\\Order',32,'INV-32','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,7491.00,0.00,0.00,0.00,NULL,'',NULL,NULL,7491.00,NULL,32,'completed','2024-03-05 00:56:15','2024-03-01 00:56:15','2024-03-05 00:56:15'),(33,'Botble\\Ecommerce\\Models\\Order',33,'INV-33','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,6213.00,0.00,0.00,0.00,'1','default',NULL,NULL,6213.00,NULL,33,'completed','2024-03-05 00:56:16','2024-02-29 08:56:16','2024-03-05 00:56:16'),(34,'Botble\\Ecommerce\\Models\\Order',34,'INV-34','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,2752.00,0.00,0.00,0.00,'1','default',NULL,NULL,2752.00,NULL,34,'completed','2024-03-05 00:56:16','2024-02-28 00:56:16','2024-03-05 00:56:16'),(35,'Botble\\Ecommerce\\Models\\Order',35,'INV-35','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,5850.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5850.00,NULL,35,'completed','2024-03-05 00:56:16','2024-03-02 16:56:16','2024-03-05 00:56:16'),(36,'Botble\\Ecommerce\\Models\\Order',36,'INV-36','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,795.00,0.00,0.00,0.00,NULL,'',NULL,NULL,795.00,NULL,36,'completed','2024-03-05 00:56:16','2024-03-04 10:56:16','2024-03-05 00:56:16'),(37,'Botble\\Ecommerce\\Models\\Order',37,'INV-37','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,1432.00,0.00,0.00,0.00,'1','default',NULL,NULL,1432.00,NULL,37,'completed','2024-03-05 00:56:16','2024-03-01 12:56:16','2024-03-05 00:56:16'),(38,'Botble\\Ecommerce\\Models\\Order',38,'INV-38','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,1816.00,0.00,0.00,0.00,'1','default',NULL,NULL,1816.00,NULL,38,'completed','2024-03-05 00:56:16','2024-03-02 00:56:16','2024-03-05 00:56:16'),(39,'Botble\\Ecommerce\\Models\\Order',39,'INV-39','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,1470.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1470.00,NULL,39,'completed','2024-03-05 00:56:17','2024-03-03 00:56:17','2024-03-05 00:56:17'),(40,'Botble\\Ecommerce\\Models\\Order',40,'INV-40','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2004.00,0.00,0.00,0.00,'1','default',NULL,NULL,2004.00,NULL,40,'completed','2024-03-05 00:56:17','2024-03-04 00:56:17','2024-03-05 00:56:17'),(41,'Botble\\Ecommerce\\Models\\Order',41,'INV-41','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,7315.00,0.00,0.00,0.00,'1','default',NULL,NULL,7315.00,NULL,41,'completed','2024-03-05 00:56:17','2024-03-02 12:56:17','2024-03-05 00:56:17'),(42,'Botble\\Ecommerce\\Models\\Order',42,'INV-42','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,2400.00,0.00,0.00,0.00,'1','default',NULL,NULL,2400.00,NULL,42,'pending',NULL,'2024-03-03 18:56:17','2024-03-05 00:56:17'),(43,'Botble\\Ecommerce\\Models\\Order',43,'INV-43','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,1155.00,0.00,0.00,0.00,'1','default',NULL,NULL,1155.00,NULL,43,'pending',NULL,'2024-02-29 20:56:17','2024-03-05 00:56:17'),(44,'Botble\\Ecommerce\\Models\\Order',44,'INV-44','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,3900.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3900.00,NULL,44,'completed','2024-03-05 00:56:18','2024-03-01 16:56:17','2024-03-05 00:56:18'),(45,'Botble\\Ecommerce\\Models\\Order',45,'INV-45','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,309.00,0.00,0.00,0.00,'1','default',NULL,NULL,309.00,NULL,45,'pending',NULL,'2024-03-03 00:56:18','2024-03-05 00:56:18'),(46,'Botble\\Ecommerce\\Models\\Order',46,'INV-46','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,5850.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5850.00,NULL,46,'completed','2024-03-05 00:56:18','2024-03-03 12:56:18','2024-03-05 00:56:18'),(47,'Botble\\Ecommerce\\Models\\Order',47,'INV-47','Krystal Wunsch','',NULL,'jaeden.dach@example.org','+19063307387','75863 Gilberto Forges Suite 816, Arloberg, Vermont, AE',NULL,306.00,0.00,0.00,0.00,'1','default',NULL,NULL,306.00,NULL,47,'pending',NULL,'2024-03-03 12:56:18','2024-03-05 00:56:18'),(48,'Botble\\Ecommerce\\Models\\Order',48,'INV-48','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,6624.00,0.00,0.00,0.00,'1','default',NULL,NULL,6624.00,NULL,48,'pending',NULL,'2024-03-03 20:56:18','2024-03-05 00:56:18'),(49,'Botble\\Ecommerce\\Models\\Order',49,'INV-49','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,2242.00,0.00,0.00,0.00,'1','default',NULL,NULL,2242.00,NULL,49,'completed','2024-03-05 00:56:18','2024-03-04 14:56:18','2024-03-05 00:56:18'),(50,'Botble\\Ecommerce\\Models\\Order',50,'INV-50','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,3189.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3189.00,NULL,50,'completed','2024-03-05 00:56:19','2024-03-04 22:56:19','2024-03-05 00:56:19'),(51,'Botble\\Ecommerce\\Models\\Order',51,'INV-51','Kristin Steuber','',NULL,'deanna63@example.org','+15748319854','4443 Favian Meadow Apt. 625, Zenatown, Kansas, NE',NULL,1596.00,0.00,0.00,0.00,'1','default',NULL,NULL,1596.00,NULL,51,'pending',NULL,'2024-03-04 04:56:19','2024-03-05 00:56:19');
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',1,'94755-0780','shipping_address'),(2,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',2,'94755-0780','shipping_address'),(3,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',3,'94755-0780','shipping_address'),(4,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',4,'94755-0780','shipping_address'),(5,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',5,'94755-0780','shipping_address'),(6,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',6,'82821','shipping_address'),(7,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',7,'82821','shipping_address'),(8,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',8,'82821','shipping_address'),(9,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',9,'94755-0780','shipping_address'),(10,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',10,'94755-0780','shipping_address'),(11,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',11,'94755-0780','shipping_address'),(12,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',12,'94755-0780','shipping_address'),(13,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',13,'94755-0780','shipping_address'),(14,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',14,'94755-0780','shipping_address'),(15,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',15,'82821','shipping_address'),(16,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',16,'82821','shipping_address'),(17,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',17,'94755-0780','shipping_address'),(18,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',18,'94755-0780','shipping_address'),(19,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',19,'82821','shipping_address'),(20,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',20,'82821','shipping_address'),(21,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',21,'82821','shipping_address'),(22,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',22,'94755-0780','shipping_address'),(23,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',23,'94755-0780','shipping_address'),(24,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',24,'82821','shipping_address'),(25,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',25,'82821','shipping_address'),(26,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',26,'94755-0780','shipping_address'),(27,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',27,'94755-0780','shipping_address'),(28,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',28,'82821','shipping_address'),(29,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',29,'82821','shipping_address'),(30,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',30,'82821','shipping_address'),(31,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',31,'82821','shipping_address'),(32,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',32,'82821','shipping_address'),(33,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',33,'82821','shipping_address'),(34,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',34,'82821','shipping_address'),(35,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',35,'94755-0780','shipping_address'),(36,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',36,'94755-0780','shipping_address'),(37,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',37,'94755-0780','shipping_address'),(38,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',38,'94755-0780','shipping_address'),(39,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',39,'94755-0780','shipping_address'),(40,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',40,'94755-0780','shipping_address'),(41,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',41,'82821','shipping_address'),(42,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',42,'82821','shipping_address'),(43,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',43,'82821','shipping_address'),(44,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',44,'94755-0780','shipping_address'),(45,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',45,'94755-0780','shipping_address'),(46,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',46,'82821','shipping_address'),(47,'Krystal Wunsch','+19063307387','jaeden.dach@example.org','AE','Vermont','Arloberg','75863 Gilberto Forges Suite 816',47,'82821','shipping_address'),(48,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',48,'94755-0780','shipping_address'),(49,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',49,'94755-0780','shipping_address'),(50,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',50,'94755-0780','shipping_address'),(51,'Kristin Steuber','+15748319854','deanna63@example.org','NE','Kansas','Zenatown','4443 Favian Meadow Apt. 625',51,'94755-0780','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2024-02-29 00:56:10','2024-02-29 00:56:10'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2024-02-29 00:56:10','2024-02-29 00:56:10'),(3,'create_shipment','Created shipment for order',0,1,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(4,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2024-02-29 00:56:10','2024-02-29 00:56:10'),(5,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2024-02-29 00:56:10','2024-02-29 00:56:10'),(6,'confirm_payment','Payment was confirmed (amount $2,242.00) by %user_name%',0,2,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(7,'create_shipment','Created shipment for order',0,2,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(8,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(9,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2024-02-26 02:56:10','2024-02-26 02:56:10'),(10,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2024-02-26 02:56:10','2024-02-26 02:56:10'),(11,'create_shipment','Created shipment for order',0,3,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(12,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(13,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2024-02-27 16:56:10','2024-02-27 16:56:10'),(14,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2024-02-27 16:56:10','2024-02-27 16:56:10'),(15,'confirm_payment','Payment was confirmed (amount $2,304.00) by %user_name%',0,4,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(16,'create_shipment','Created shipment for order',0,4,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(17,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(18,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2024-02-18 04:56:10','2024-02-18 04:56:10'),(19,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2024-02-18 04:56:10','2024-02-18 04:56:10'),(20,'confirm_payment','Payment was confirmed (amount $3,676.00) by %user_name%',0,5,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10'),(21,'create_shipment','Created shipment for order',0,5,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(22,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2024-02-22 00:56:11','2024-02-22 00:56:11'),(23,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2024-02-22 00:56:11','2024-02-22 00:56:11'),(24,'create_shipment','Created shipment for order',0,6,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(25,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(26,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2024-02-29 12:56:11','2024-02-29 12:56:11'),(27,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2024-02-29 12:56:11','2024-02-29 12:56:11'),(28,'confirm_payment','Payment was confirmed (amount $1,600.00) by %user_name%',0,7,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(29,'create_shipment','Created shipment for order',0,7,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(30,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2024-03-03 12:56:11','2024-03-03 12:56:11'),(31,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2024-03-03 12:56:11','2024-03-03 12:56:11'),(32,'confirm_payment','Payment was confirmed (amount $927.00) by %user_name%',0,8,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(33,'create_shipment','Created shipment for order',0,8,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(34,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(35,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2024-02-29 18:56:11','2024-02-29 18:56:11'),(36,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2024-02-29 18:56:11','2024-02-29 18:56:11'),(37,'confirm_payment','Payment was confirmed (amount $1,432.00) by %user_name%',0,9,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(38,'create_shipment','Created shipment for order',0,9,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(39,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(40,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2024-02-28 08:56:11','2024-02-28 08:56:11'),(41,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2024-02-28 08:56:11','2024-02-28 08:56:11'),(42,'confirm_payment','Payment was confirmed (amount $1,379.00) by %user_name%',0,10,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11'),(43,'create_shipment','Created shipment for order',0,10,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(44,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,10,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(45,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2024-02-29 18:56:12','2024-02-29 18:56:12'),(46,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2024-02-29 18:56:12','2024-02-29 18:56:12'),(47,'confirm_payment','Payment was confirmed (amount $1,838.00) by %user_name%',0,11,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(48,'create_shipment','Created shipment for order',0,11,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(49,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(50,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2024-02-20 16:56:12','2024-02-20 16:56:12'),(51,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2024-02-20 16:56:12','2024-02-20 16:56:12'),(52,'confirm_payment','Payment was confirmed (amount $5,850.00) by %user_name%',0,12,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(53,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,12,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(54,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2024-03-03 16:56:12','2024-03-03 16:56:12'),(55,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2024-03-03 16:56:12','2024-03-03 16:56:12'),(56,'confirm_payment','Payment was confirmed (amount $6,213.00) by %user_name%',0,13,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(57,'create_shipment','Created shipment for order',0,13,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(58,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2024-02-23 08:56:12','2024-02-23 08:56:12'),(59,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2024-02-23 08:56:12','2024-02-23 08:56:12'),(60,'confirm_payment','Payment was confirmed (amount $2,752.00) by %user_name%',0,14,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(61,'create_shipment','Created shipment for order',0,14,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(62,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(63,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2024-02-27 18:56:12','2024-02-27 18:56:12'),(64,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2024-02-27 18:56:12','2024-02-27 18:56:12'),(65,'confirm_payment','Payment was confirmed (amount $5,166.00) by %user_name%',0,15,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(66,'create_shipment','Created shipment for order',0,15,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(67,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2024-02-26 12:56:12','2024-02-26 12:56:12'),(68,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2024-02-26 12:56:12','2024-02-26 12:56:12'),(69,'confirm_payment','Payment was confirmed (amount $4,536.00) by %user_name%',0,16,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12'),(70,'create_shipment','Created shipment for order',0,16,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(71,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2024-03-02 16:56:13','2024-03-02 16:56:13'),(72,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2024-03-02 16:56:13','2024-03-02 16:56:13'),(73,'confirm_payment','Payment was confirmed (amount $490.00) by %user_name%',0,17,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(74,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,17,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(75,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2024-03-03 20:56:13','2024-03-03 20:56:13'),(76,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2024-03-03 20:56:13','2024-03-03 20:56:13'),(77,'confirm_payment','Payment was confirmed (amount $2,242.00) by %user_name%',0,18,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(78,'create_shipment','Created shipment for order',0,18,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(79,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2024-02-29 16:56:13','2024-02-29 16:56:13'),(80,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2024-02-29 16:56:13','2024-02-29 16:56:13'),(81,'confirm_payment','Payment was confirmed (amount $2,632.00) by %user_name%',0,19,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(82,'create_shipment','Created shipment for order',0,19,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(83,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2024-02-25 08:56:13','2024-02-25 08:56:13'),(84,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2024-02-25 08:56:13','2024-02-25 08:56:13'),(85,'confirm_payment','Payment was confirmed (amount $2,098.00) by %user_name%',0,20,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(86,'create_shipment','Created shipment for order',0,20,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(87,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,20,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(88,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2024-02-28 14:56:13','2024-02-28 14:56:13'),(89,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2024-02-28 14:56:13','2024-02-28 14:56:13'),(90,'confirm_payment','Payment was confirmed (amount $530.00) by %user_name%',0,21,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13'),(91,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,21,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(92,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2024-02-24 00:56:14','2024-02-24 00:56:14'),(93,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2024-02-24 00:56:14','2024-02-24 00:56:14'),(94,'create_shipment','Created shipment for order',0,22,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(95,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,22,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(96,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2024-02-26 00:56:14','2024-02-26 00:56:14'),(97,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2024-02-26 00:56:14','2024-02-26 00:56:14'),(98,'create_shipment','Created shipment for order',0,23,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(99,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(100,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2024-02-25 18:56:14','2024-02-25 18:56:14'),(101,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2024-02-25 18:56:14','2024-02-25 18:56:14'),(102,'create_shipment','Created shipment for order',0,24,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(103,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2024-02-24 20:56:14','2024-02-24 20:56:14'),(104,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2024-02-24 20:56:14','2024-02-24 20:56:14'),(105,'confirm_payment','Payment was confirmed (amount $800.00) by %user_name%',0,25,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(106,'create_shipment','Created shipment for order',0,25,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(107,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,25,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(108,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2024-02-25 16:56:14','2024-02-25 16:56:14'),(109,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2024-02-25 16:56:14','2024-02-25 16:56:14'),(110,'create_shipment','Created shipment for order',0,26,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14'),(111,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2024-02-27 08:56:15','2024-02-27 08:56:15'),(112,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2024-02-27 08:56:15','2024-02-27 08:56:15'),(113,'confirm_payment','Payment was confirmed (amount $682.00) by %user_name%',0,27,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(114,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,27,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(115,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2024-02-29 12:56:15','2024-02-29 12:56:15'),(116,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2024-02-29 12:56:15','2024-02-29 12:56:15'),(117,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2024-03-03 12:56:15','2024-03-03 12:56:15'),(118,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2024-03-03 12:56:15','2024-03-03 12:56:15'),(119,'confirm_payment','Payment was confirmed (amount $1,063.00) by %user_name%',0,29,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(120,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,29,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(121,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2024-03-01 06:56:15','2024-03-01 06:56:15'),(122,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2024-03-01 06:56:15','2024-03-01 06:56:15'),(123,'create_shipment','Created shipment for order',0,30,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(124,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(125,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2024-02-28 16:56:15','2024-02-28 16:56:15'),(126,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2024-02-28 16:56:15','2024-02-28 16:56:15'),(127,'confirm_payment','Payment was confirmed (amount $5,850.00) by %user_name%',0,31,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(128,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,31,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(129,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2024-03-01 00:56:15','2024-03-01 00:56:15'),(130,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2024-03-01 00:56:15','2024-03-01 00:56:15'),(131,'confirm_payment','Payment was confirmed (amount $7,491.00) by %user_name%',0,32,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(132,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,32,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15'),(133,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2024-02-29 08:56:16','2024-02-29 08:56:16'),(134,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2024-02-29 08:56:16','2024-02-29 08:56:16'),(135,'confirm_payment','Payment was confirmed (amount $6,213.00) by %user_name%',0,33,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(136,'create_shipment','Created shipment for order',0,33,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(137,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2024-02-28 00:56:16','2024-02-28 00:56:16'),(138,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2024-02-28 00:56:16','2024-02-28 00:56:16'),(139,'confirm_payment','Payment was confirmed (amount $2,752.00) by %user_name%',0,34,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(140,'create_shipment','Created shipment for order',0,34,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(141,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,34,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(142,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2024-03-02 16:56:16','2024-03-02 16:56:16'),(143,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2024-03-02 16:56:16','2024-03-02 16:56:16'),(144,'confirm_payment','Payment was confirmed (amount $5,850.00) by %user_name%',0,35,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(145,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,35,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(146,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2024-03-04 10:56:16','2024-03-04 10:56:16'),(147,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2024-03-04 10:56:16','2024-03-04 10:56:16'),(148,'confirm_payment','Payment was confirmed (amount $795.00) by %user_name%',0,36,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(149,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,36,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(150,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2024-03-01 12:56:16','2024-03-01 12:56:16'),(151,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2024-03-01 12:56:16','2024-03-01 12:56:16'),(152,'confirm_payment','Payment was confirmed (amount $1,432.00) by %user_name%',0,37,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(153,'create_shipment','Created shipment for order',0,37,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(154,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2024-03-02 00:56:16','2024-03-02 00:56:16'),(155,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2024-03-02 00:56:16','2024-03-02 00:56:16'),(156,'confirm_payment','Payment was confirmed (amount $1,816.00) by %user_name%',0,38,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16'),(157,'create_shipment','Created shipment for order',0,38,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(158,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2024-03-03 00:56:17','2024-03-03 00:56:17'),(159,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2024-03-03 00:56:17','2024-03-03 00:56:17'),(160,'confirm_payment','Payment was confirmed (amount $1,470.00) by %user_name%',0,39,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(161,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,39,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(162,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2024-03-04 00:56:17','2024-03-04 00:56:17'),(163,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2024-03-04 00:56:17','2024-03-04 00:56:17'),(164,'confirm_payment','Payment was confirmed (amount $2,004.00) by %user_name%',0,40,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(165,'create_shipment','Created shipment for order',0,40,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(166,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(167,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2024-03-02 12:56:17','2024-03-02 12:56:17'),(168,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2024-03-02 12:56:17','2024-03-02 12:56:17'),(169,'confirm_payment','Payment was confirmed (amount $7,315.00) by %user_name%',0,41,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(170,'create_shipment','Created shipment for order',0,41,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(171,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,41,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(172,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2024-03-03 18:56:17','2024-03-03 18:56:17'),(173,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2024-03-03 18:56:17','2024-03-03 18:56:17'),(174,'create_shipment','Created shipment for order',0,42,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(175,'create_order_from_seeder','Order is created from the checkout page',NULL,43,NULL,'2024-02-29 20:56:17','2024-02-29 20:56:17'),(176,'confirm_order','Order was verified by %user_name%',0,43,NULL,'2024-02-29 20:56:17','2024-02-29 20:56:17'),(177,'create_shipment','Created shipment for order',0,43,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(178,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,43,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(179,'create_order_from_seeder','Order is created from the checkout page',NULL,44,NULL,'2024-03-01 16:56:17','2024-03-01 16:56:17'),(180,'confirm_order','Order was verified by %user_name%',0,44,NULL,'2024-03-01 16:56:17','2024-03-01 16:56:17'),(181,'confirm_payment','Payment was confirmed (amount $3,900.00) by %user_name%',0,44,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17'),(182,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,44,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(183,'create_order_from_seeder','Order is created from the checkout page',NULL,45,NULL,'2024-03-03 00:56:18','2024-03-03 00:56:18'),(184,'confirm_order','Order was verified by %user_name%',0,45,NULL,'2024-03-03 00:56:18','2024-03-03 00:56:18'),(185,'create_shipment','Created shipment for order',0,45,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(186,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,45,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(187,'create_order_from_seeder','Order is created from the checkout page',NULL,46,NULL,'2024-03-03 12:56:18','2024-03-03 12:56:18'),(188,'confirm_order','Order was verified by %user_name%',0,46,NULL,'2024-03-03 12:56:18','2024-03-03 12:56:18'),(189,'confirm_payment','Payment was confirmed (amount $5,850.00) by %user_name%',0,46,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(190,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,46,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(191,'create_order_from_seeder','Order is created from the checkout page',NULL,47,NULL,'2024-03-03 12:56:18','2024-03-03 12:56:18'),(192,'confirm_order','Order was verified by %user_name%',0,47,NULL,'2024-03-03 12:56:18','2024-03-03 12:56:18'),(193,'create_shipment','Created shipment for order',0,47,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(194,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,47,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(195,'create_order_from_seeder','Order is created from the checkout page',NULL,48,NULL,'2024-03-03 20:56:18','2024-03-03 20:56:18'),(196,'confirm_order','Order was verified by %user_name%',0,48,NULL,'2024-03-03 20:56:18','2024-03-03 20:56:18'),(197,'create_shipment','Created shipment for order',0,48,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(198,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,48,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(199,'create_order_from_seeder','Order is created from the checkout page',NULL,49,NULL,'2024-03-04 14:56:18','2024-03-04 14:56:18'),(200,'confirm_order','Order was verified by %user_name%',0,49,NULL,'2024-03-04 14:56:18','2024-03-04 14:56:18'),(201,'confirm_payment','Payment was confirmed (amount $2,242.00) by %user_name%',0,49,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18'),(202,'create_shipment','Created shipment for order',0,49,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19'),(203,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,49,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19'),(204,'create_order_from_seeder','Order is created from the checkout page',NULL,50,NULL,'2024-03-04 22:56:19','2024-03-04 22:56:19'),(205,'confirm_order','Order was verified by %user_name%',0,50,NULL,'2024-03-04 22:56:19','2024-03-04 22:56:19'),(206,'confirm_payment','Payment was confirmed (amount $3,189.00) by %user_name%',0,50,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19'),(207,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,50,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19'),(208,'create_order_from_seeder','Order is created from the checkout page',NULL,51,NULL,'2024-03-04 04:56:19','2024-03-04 04:56:19'),(209,'confirm_order','Order was verified by %user_name%',0,51,NULL,'2024-03-04 04:56:19','2024-03-04 04:56:19'),(210,'create_shipment','Created shipment for order',0,51,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19'),(211,'update_status','Order confirmed by %user_name%',0,2,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19'),(212,'update_status','Order confirmed by %user_name%',0,4,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19'),(213,'update_status','Order confirmed by %user_name%',0,8,NULL,'2024-03-05 00:56:20','2024-03-05 00:56:20'),(214,'update_status','Order confirmed by %user_name%',0,9,NULL,'2024-03-05 00:56:20','2024-03-05 00:56:20'),(215,'update_status','Order confirmed by %user_name%',0,10,NULL,'2024-03-05 00:56:21','2024-03-05 00:56:21'),(216,'update_status','Order confirmed by %user_name%',0,11,NULL,'2024-03-05 00:56:21','2024-03-05 00:56:21'),(217,'update_status','Order confirmed by %user_name%',0,14,NULL,'2024-03-05 00:56:22','2024-03-05 00:56:22'),(218,'update_status','Order confirmed by %user_name%',0,20,NULL,'2024-03-05 00:56:22','2024-03-05 00:56:22'),(219,'update_status','Order confirmed by %user_name%',0,25,NULL,'2024-03-05 00:56:23','2024-03-05 00:56:23'),(220,'update_status','Order confirmed by %user_name%',0,34,NULL,'2024-03-05 00:56:23','2024-03-05 00:56:23'),(221,'update_status','Order confirmed by %user_name%',0,40,NULL,'2024-03-05 00:56:24','2024-03-05 00:56:24'),(222,'update_status','Order confirmed by %user_name%',0,41,NULL,'2024-03-05 00:56:24','2024-03-05 00:56:24'),(223,'update_status','Order confirmed by %user_name%',0,49,NULL,'2024-03-05 00:56:25','2024-03-05 00:56:25');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,1,2431.00,0.00,'{\"sku\":\"UO-150-A0\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,92,'Printed Palazzo Pants','fashion/products/product-4.png',670.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','physical',0,NULL),(2,2,1,2242.00,0.00,'{\"sku\":\"E2-121-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}',NULL,108,'Cropped Cable Knit Sweater','fashion/products/product-4.png',804.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','physical',0,NULL),(3,3,3,1950.00,0.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,56,'Knit Turtleneck Sweater (Digital)','fashion/products/product-1.png',1728.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','digital',0,NULL),(4,3,2,908.00,0.00,'{\"sku\":\"MD-111-A0-A3\",\"attributes\":\"(Color: Blue, Size: XL)\"}',NULL,65,'Bohemian Fringe Handbag','fashion/products/product-1.png',1344.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','physical',0,NULL),(5,4,1,2304.00,0.00,'{\"sku\":\"AH-129-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}',NULL,112,'Leopard Print Midi Skirt','fashion/products/product-1.png',648.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','physical',0,NULL),(6,5,2,1838.00,0.00,'{\"sku\":\"LW-200-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,156,'Metallic Pleated Maxi Skirt','fashion/products/product-8.png',1726.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','physical',0,NULL),(7,6,1,908.00,0.00,'{\"sku\":\"MD-111-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,64,'Bohemian Fringe Handbag','fashion/products/product-7.png',672.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','physical',0,NULL),(8,7,2,800.00,0.00,'{\"sku\":\"JQ-195-A0-A1\",\"attributes\":\"(Size: L, Color: Brown)\"}',NULL,84,'Quilted Crossbody Bag','fashion/products/product-7.png',1388.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','physical',0,NULL),(9,8,3,309.00,0.00,'{\"sku\":\"LJ-162-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,141,'Embroidered Bomber Jacket','fashion/products/product-1.png',2004.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','physical',0,NULL),(10,9,2,716.00,0.00,'{\"sku\":\"PH-114-A0\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,44,'Vintage Denim Jacket','fashion/products/product-4.png',1756.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','physical',0,NULL),(11,10,1,1379.00,0.00,'{\"sku\":\"FR-144-A0\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,103,'Suede Pointed-Toe Pumps','fashion/products/product-1.png',722.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','physical',0,NULL),(12,11,1,1838.00,0.00,'{\"sku\":\"LW-200-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}',NULL,155,'Metallic Pleated Maxi Skirt','fashion/products/product-7.png',863.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','physical',0,NULL),(13,12,3,1950.00,0.00,'{\"sku\":\"VD-173-A0-A4\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,58,'Knit Turtleneck Sweater (Digital)','fashion/products/product-4.png',1728.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','digital',10,NULL),(14,13,3,2071.00,0.00,'{\"sku\":\"VW-175-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,82,'Velvet Evening Gown','fashion/products/product-7.png',1503.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','physical',0,NULL),(15,14,2,1376.00,0.00,'{\"sku\":\"EN-191-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,127,'Wide Brim Floppy Hat','fashion/products/product-1.png',1668.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','physical',0,NULL),(16,15,3,1722.00,0.00,'{\"sku\":\"UM-125-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,99,'Off-Shoulder Ruffle Top','fashion/products/product-7.png',1944.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','physical',0,NULL),(17,16,3,1512.00,0.00,'{\"sku\":\"TF-194-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,125,'Beaded Evening Clutch','fashion/products/product-7.png',2511.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','physical',0,NULL),(18,17,1,490.00,0.00,'{\"sku\":\"KJ-145-A0\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,86,'Distressed Skinny Jeans (Digital)','fashion/products/product-1.png',536.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','digital',6,NULL),(19,18,1,2242.00,0.00,'{\"sku\":\"E2-121-A0-A3\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,109,'Cropped Cable Knit Sweater','fashion/products/product-6.png',804.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','physical',0,NULL),(20,19,2,518.00,0.00,'{\"sku\":\"NH-177-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,49,'Floral Maxi Dress','fashion/products/product-6.png',1196.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','physical',0,NULL),(21,19,3,532.00,0.00,'{\"sku\":\"AJ-168-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,140,'Buckle Detail Ankle Booties','fashion/products/product-6.png',2334.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','physical',0,NULL),(22,20,1,2098.00,0.00,'{\"sku\":\"Z1-112-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}',NULL,122,'Ruffled Wrap Dress','fashion/products/product-8.png',541.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','physical',0,NULL),(23,21,2,265.00,0.00,'{\"sku\":\"NW-108-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}',NULL,149,'Chunky Knit Infinity Scarf (Digital)','fashion/products/product-1.png',1384.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','digital',10,NULL),(24,22,3,716.00,0.00,'{\"sku\":\"PH-114-A0-A3\",\"attributes\":\"(Color: Blue, Size: M)\"}',NULL,47,'Vintage Denim Jacket','fashion/products/product-7.png',2634.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','physical',0,NULL),(25,23,3,1047.00,0.00,'{\"sku\":\"6Y-120-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}',NULL,70,'High-Waisted Wide Leg Trousers','fashion/products/product-6.png',1713.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','physical',0,NULL),(26,24,2,1048.00,0.00,'{\"sku\":\"9Q-161-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,74,'Embroidered Boho Blouse','fashion/products/product-8.png',1564.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','physical',0,NULL),(27,25,1,800.00,0.00,'{\"sku\":\"JQ-195-A0\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,83,'Quilted Crossbody Bag','fashion/products/product-1.png',694.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','physical',0,NULL),(28,26,3,1048.00,0.00,'{\"sku\":\"9Q-161-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,72,'Embroidered Boho Blouse','fashion/products/product-7.png',2346.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','physical',0,NULL),(29,27,1,682.00,0.00,'{\"sku\":\"CL-103-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}',NULL,130,'Denim Overall Jumpsuit (Digital)','fashion/products/product-4.png',837.00,0,'2024-03-05 00:56:15','2024-03-05 00:56:15','digital',10,NULL),(30,28,1,2497.00,0.00,'{\"sku\":\"07-101-A0\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,67,'Silk Scarf with Geometric Print (Digital)','fashion/products/product-7.png',707.00,0,'2024-03-05 00:56:15','2024-03-05 00:56:15','digital',9,NULL),(31,29,1,1063.00,0.00,'{\"sku\":\"ZU-186-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,120,'Boho Fringed Kimono (Digital)','fashion/products/product-5.png',895.00,0,'2024-03-05 00:56:15','2024-03-05 00:56:15','digital',6,NULL),(32,30,2,2098.00,0.00,'{\"sku\":\"Z1-112-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}',NULL,122,'Ruffled Wrap Dress','fashion/products/product-8.png',1082.00,0,'2024-03-05 00:56:15','2024-03-05 00:56:15','physical',0,NULL),(33,31,3,1950.00,0.00,'{\"sku\":\"VD-173-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,55,'Knit Turtleneck Sweater (Digital)','fashion/products/product-6.png',1728.00,0,'2024-03-05 00:56:15','2024-03-05 00:56:15','digital',1,NULL),(34,32,3,2497.00,0.00,'{\"sku\":\"07-101-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}',NULL,68,'Silk Scarf with Geometric Print (Digital)','fashion/products/product-1.png',2121.00,0,'2024-03-05 00:56:15','2024-03-05 00:56:15','digital',8,NULL),(35,33,3,2071.00,0.00,'{\"sku\":\"VW-175-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,82,'Velvet Evening Gown','fashion/products/product-7.png',1503.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','physical',0,NULL),(36,34,2,1376.00,0.00,'{\"sku\":\"EN-191-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,127,'Wide Brim Floppy Hat','fashion/products/product-1.png',1668.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','physical',0,NULL),(37,35,3,1950.00,0.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,56,'Knit Turtleneck Sweater (Digital)','fashion/products/product-1.png',1728.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','digital',1,NULL),(38,36,3,265.00,0.00,'{\"sku\":\"NW-108-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,148,'Chunky Knit Infinity Scarf (Digital)','fashion/products/product-5.png',2076.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','digital',0,NULL),(39,37,2,716.00,0.00,'{\"sku\":\"PH-114-A0-A1\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,45,'Vintage Denim Jacket','fashion/products/product-5.png',1756.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','physical',0,NULL),(40,38,2,908.00,0.00,'{\"sku\":\"MD-111-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,64,'Bohemian Fringe Handbag','fashion/products/product-7.png',1344.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','physical',0,NULL),(41,39,3,490.00,0.00,'{\"sku\":\"KJ-145-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}',NULL,88,'Distressed Skinny Jeans (Digital)','fashion/products/product-6.png',1608.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','digital',5,NULL),(42,40,1,2004.00,0.00,'{\"sku\":\"QJ-126-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,136,'Velour Tracksuit Set','fashion/products/product-2.png',527.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','physical',0,NULL),(43,41,3,1950.00,0.00,'{\"sku\":\"VD-173-A0-A4\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,58,'Knit Turtleneck Sweater (Digital)','fashion/products/product-4.png',1728.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','digital',7,NULL),(44,41,1,1465.00,0.00,'{\"sku\":\"VL-197-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}',NULL,131,'Embellished Ballet Flats','fashion/products/product-2.png',580.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','physical',0,NULL),(45,42,3,800.00,0.00,'{\"sku\":\"JQ-195-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,85,'Quilted Crossbody Bag','fashion/products/product-4.png',2082.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','physical',0,NULL),(46,43,1,1155.00,0.00,'{\"sku\":\"LC-188-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}',NULL,132,'Pleated Midi Skirt','fashion/products/product-8.png',602.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','physical',0,NULL),(47,44,2,1950.00,0.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,56,'Knit Turtleneck Sweater (Digital)','fashion/products/product-1.png',1152.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','digital',5,NULL),(48,45,1,309.00,0.00,'{\"sku\":\"LJ-162-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,141,'Embroidered Bomber Jacket','fashion/products/product-1.png',668.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','physical',0,NULL),(49,46,3,1950.00,0.00,'{\"sku\":\"VD-173-A0-A4\",\"attributes\":\"(Size: L, Color: Black)\"}',NULL,58,'Knit Turtleneck Sweater (Digital)','fashion/products/product-4.png',1728.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','digital',9,NULL),(50,47,1,306.00,0.00,'{\"sku\":\"YP-121-A0\",\"attributes\":\"(Color: Green, Size: M)\"}',NULL,75,'Statement Chunky Necklace','fashion/products/product-5.png',691.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','physical',0,NULL),(51,48,2,1950.00,0.00,'{\"sku\":\"VD-173-A0-A2\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,56,'Knit Turtleneck Sweater (Digital)','fashion/products/product-1.png',1152.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','digital',6,NULL),(52,48,3,908.00,0.00,'{\"sku\":\"MD-111-A0-A4\",\"attributes\":\"(Color: Green, Size: XXL)\"}',NULL,66,'Bohemian Fringe Handbag','fashion/products/product-4.png',2016.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','physical',0,NULL),(53,49,1,2242.00,0.00,'{\"sku\":\"E2-121-A0-A1\",\"attributes\":\"(Color: Blue, Size: XL)\"}',NULL,107,'Cropped Cable Knit Sweater','fashion/products/product-7.png',804.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','physical',0,NULL),(54,50,3,1063.00,0.00,'{\"sku\":\"ZU-186-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,120,'Boho Fringed Kimono (Digital)','fashion/products/product-5.png',2685.00,0,'2024-03-05 00:56:19','2024-03-05 00:56:19','digital',10,NULL),(55,51,3,532.00,0.00,'{\"sku\":\"AJ-168-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}',NULL,139,'Buckle Detail Ankle Booties','fashion/products/product-2.png',2334.00,0,'2024-03-05 00:56:19','2024-03-05 00:56:19','physical',0,NULL);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `proof_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',9,'1','default','pending',2431.00,0.00,0.00,NULL,NULL,0.00,2431.00,1,NULL,1,NULL,'F8Mi9m5sYzCqhgvrHYGDJOyXDCPJd',1,'2024-02-29 00:56:10','2024-03-05 00:56:10',5,NULL),(2,'#10000002',9,'1','default','completed',2242.00,0.00,0.00,NULL,NULL,0.00,2242.00,1,NULL,1,'2024-03-05 00:56:19','WZWz63rQVyoBXAbcD1bYHV3beC1Ni',2,'2024-02-29 00:56:10','2024-03-05 00:56:19',8,NULL),(3,'#10000003',9,'1','default','completed',7666.00,0.00,0.00,NULL,NULL,0.00,7666.00,1,NULL,1,'2024-03-05 00:56:10','G9haFOhopMUh8YbH2WjK3ZfdUhTH3',3,'2024-02-26 02:56:10','2024-03-05 00:56:10',4,NULL),(4,'#10000004',9,'1','default','completed',2304.00,0.00,0.00,NULL,NULL,0.00,2304.00,1,NULL,1,'2024-03-05 00:56:19','eUyY1Bh5UH918G6mmHgNT4fNLpWSR',4,'2024-02-27 16:56:10','2024-03-05 00:56:19',1,NULL),(5,'#10000005',9,'1','default','pending',3676.00,0.00,0.00,NULL,NULL,0.00,3676.00,1,NULL,1,NULL,'hrdTPO1EKTMH8rzoHGFF6YI8Ocgku',5,'2024-02-18 04:56:10','2024-03-05 00:56:10',5,NULL),(6,'#10000006',10,'1','default','completed',908.00,0.00,0.00,NULL,NULL,0.00,908.00,1,NULL,1,'2024-03-05 00:56:11','cuzVoezLyT3flfzSn5Gop5ITkyFSA',6,'2024-02-22 00:56:11','2024-03-05 00:56:11',4,NULL),(7,'#10000007',10,'1','default','pending',1600.00,0.00,0.00,NULL,NULL,0.00,1600.00,1,NULL,1,NULL,'EpPzZNsM30JWxZQWwOXySe4dKkVkn',7,'2024-02-29 12:56:11','2024-03-05 00:56:11',3,NULL),(8,'#10000008',10,'1','default','completed',927.00,0.00,0.00,NULL,NULL,0.00,927.00,1,NULL,1,'2024-03-05 00:56:20','zP2TcjpfND9UvtfwekOgqaeJK6LK2',8,'2024-03-03 12:56:11','2024-03-05 00:56:20',6,NULL),(9,'#10000009',9,'1','default','completed',1432.00,0.00,0.00,NULL,NULL,0.00,1432.00,1,NULL,1,'2024-03-05 00:56:20','vRhYVXdQOiAttTwR3RopyeTST4ncb',9,'2024-02-29 18:56:11','2024-03-05 00:56:20',6,NULL),(10,'#10000010',9,'1','default','completed',1379.00,0.00,0.00,NULL,NULL,0.00,1379.00,1,NULL,1,'2024-03-05 00:56:21','7z9TBtmha6k6sXBsmyhTZX5N1fUeV',10,'2024-02-28 08:56:11','2024-03-05 00:56:21',4,NULL),(11,'#10000011',9,'1','default','completed',1838.00,0.00,0.00,NULL,NULL,0.00,1838.00,1,NULL,1,'2024-03-05 00:56:21','ebOD1oRC1IcUXTlBfZa6pNBrDLoUS',11,'2024-02-29 18:56:12','2024-03-05 00:56:21',5,NULL),(12,'#10000012',9,NULL,'','completed',5850.00,0.00,0.00,NULL,NULL,0.00,5850.00,1,NULL,1,'2024-03-05 00:56:12','OVg1X2wqKSlGfAafs3mQN0deGjOsE',12,'2024-02-20 16:56:12','2024-03-05 00:56:12',4,NULL),(13,'#10000013',9,'1','default','pending',6213.00,0.00,0.00,NULL,NULL,0.00,6213.00,1,NULL,1,NULL,'9PrBlpGBhWS7DNukckhMo3agyOAvp',13,'2024-03-03 16:56:12','2024-03-05 00:56:12',5,NULL),(14,'#10000014',9,'1','default','completed',2752.00,0.00,0.00,NULL,NULL,0.00,2752.00,1,NULL,1,'2024-03-05 00:56:22','WGpOCagncaU92SXvZdXFAI50IANZ1',14,'2024-02-23 08:56:12','2024-03-05 00:56:22',8,NULL),(15,'#10000015',10,'1','default','pending',5166.00,0.00,0.00,NULL,NULL,0.00,5166.00,1,NULL,1,NULL,'YxDGkZ090hsyAlecckEVVzlOUmJdE',15,'2024-02-27 18:56:12','2024-03-05 00:56:12',5,NULL),(16,'#10000016',10,'1','default','pending',4536.00,0.00,0.00,NULL,NULL,0.00,4536.00,1,NULL,1,NULL,'Q81yLy0dCSBMIpI1gpWTdOJUaVRws',16,'2024-02-26 12:56:12','2024-03-05 00:56:12',7,NULL),(17,'#10000017',9,NULL,'','completed',490.00,0.00,0.00,NULL,NULL,0.00,490.00,1,NULL,1,'2024-03-05 00:56:13','HLOGC40iCHEC4KKdqFQeNECwahU70',17,'2024-03-02 16:56:13','2024-03-05 00:56:13',2,NULL),(18,'#10000018',9,'1','default','pending',2242.00,0.00,0.00,NULL,NULL,0.00,2242.00,1,NULL,1,NULL,'8Q8YvgF10SU0X6Vr7O0sOvcGfEAlP',18,'2024-03-03 20:56:13','2024-03-05 00:56:13',8,NULL),(19,'#10000019',10,'1','default','pending',2632.00,0.00,0.00,NULL,NULL,0.00,2632.00,1,NULL,1,NULL,'6GKlduEOVQVBYP2O8jcSso8B2NFqK',19,'2024-02-29 16:56:13','2024-03-05 00:56:13',2,NULL),(20,'#10000020',10,'1','default','completed',2098.00,0.00,0.00,NULL,NULL,0.00,2098.00,1,NULL,1,'2024-03-05 00:56:22','GG12Ne20bLIpT9E2YePzu5NNlfv53',20,'2024-02-25 08:56:13','2024-03-05 00:56:22',4,NULL),(21,'#10000021',10,NULL,'','completed',530.00,0.00,0.00,NULL,NULL,0.00,530.00,1,NULL,1,'2024-03-05 00:56:14','VjkHRoh0X4o2SVZEngEbNO6RrcrLk',21,'2024-02-28 14:56:13','2024-03-05 00:56:14',3,NULL),(22,'#10000022',9,'1','default','completed',2148.00,0.00,0.00,NULL,NULL,0.00,2148.00,1,NULL,1,'2024-03-05 00:56:14','ZYRGmL2c0RQVKxruQdcaWeqyAavDw',22,'2024-02-24 00:56:14','2024-03-05 00:56:14',6,NULL),(23,'#10000023',9,'1','default','completed',3141.00,0.00,0.00,NULL,NULL,0.00,3141.00,1,NULL,1,'2024-03-05 00:56:14','yVElGVP5Dyq44R0v9Y5dOf6QOW5F5',23,'2024-02-26 00:56:14','2024-03-05 00:56:14',2,NULL),(24,'#10000024',10,'1','default','pending',2096.00,0.00,0.00,NULL,NULL,0.00,2096.00,1,NULL,1,NULL,'ldG3MqwhrDRA98pci3hpvwHqLMEKE',24,'2024-02-25 18:56:14','2024-03-05 00:56:14',7,NULL),(25,'#10000025',10,'1','default','completed',800.00,0.00,0.00,NULL,NULL,0.00,800.00,1,NULL,1,'2024-03-05 00:56:23','2TDUV3GuxcNf89KzTiYKaMHtnAh2J',25,'2024-02-24 20:56:14','2024-03-05 00:56:23',3,NULL),(26,'#10000026',9,'1','default','pending',3144.00,0.00,0.00,NULL,NULL,0.00,3144.00,1,NULL,1,NULL,'0x4kxDxUhVeiRPVUrHMx5xACtVlIM',26,'2024-02-25 16:56:14','2024-03-05 00:56:14',7,NULL),(27,'#10000027',9,NULL,'','completed',682.00,0.00,0.00,NULL,NULL,0.00,682.00,1,NULL,1,'2024-03-05 00:56:15','IvxRbvHDNxOe99DlnNgLseVUGaP6D',27,'2024-02-27 08:56:15','2024-03-05 00:56:15',5,NULL),(28,'#10000028',10,NULL,'','pending',2497.00,0.00,0.00,NULL,NULL,0.00,2497.00,1,NULL,1,NULL,'7FDCI0vjPHvhJ2H5FIITkpc8ocwQA',28,'2024-02-29 12:56:15','2024-03-05 00:56:15',7,NULL),(29,'#10000029',10,NULL,'','completed',1063.00,0.00,0.00,NULL,NULL,0.00,1063.00,1,NULL,1,'2024-03-05 00:56:15','2NR0evLlY3fZdGOuts4jUtrYGmzKD',29,'2024-03-03 12:56:15','2024-03-05 00:56:15',5,NULL),(30,'#10000030',10,'1','default','completed',4196.00,0.00,0.00,NULL,NULL,0.00,4196.00,1,NULL,1,'2024-03-05 00:56:15','TQGgjnwGjzPQzIroHwiYI8HQu541n',30,'2024-03-01 06:56:15','2024-03-05 00:56:15',4,NULL),(31,'#10000031',10,NULL,'','completed',5850.00,0.00,0.00,NULL,NULL,0.00,5850.00,1,NULL,1,'2024-03-05 00:56:15','CyhopiyhbTmcYQoV4z0hDnnuLff2e',31,'2024-02-28 16:56:15','2024-03-05 00:56:15',4,NULL),(32,'#10000032',10,NULL,'','completed',7491.00,0.00,0.00,NULL,NULL,0.00,7491.00,1,NULL,1,'2024-03-05 00:56:15','JtGA5la8KVitsJi31D5qf6MIF3BM9',32,'2024-03-01 00:56:15','2024-03-05 00:56:15',7,NULL),(33,'#10000033',10,'1','default','pending',6213.00,0.00,0.00,NULL,NULL,0.00,6213.00,1,NULL,1,NULL,'GCFnKNrT96izdBvxSodGer53ouKCM',33,'2024-02-29 08:56:16','2024-03-05 00:56:16',5,NULL),(34,'#10000034',10,'1','default','completed',2752.00,0.00,0.00,NULL,NULL,0.00,2752.00,1,NULL,1,'2024-03-05 00:56:23','rzkgmQmSqnClyuB3LBhuUiip1CFYu',34,'2024-02-28 00:56:16','2024-03-05 00:56:23',8,NULL),(35,'#10000035',9,NULL,'','completed',5850.00,0.00,0.00,NULL,NULL,0.00,5850.00,1,NULL,1,'2024-03-05 00:56:16','5iFZslOHZor0JYVrDhhHQEH24VIzj',35,'2024-03-02 16:56:16','2024-03-05 00:56:16',4,NULL),(36,'#10000036',9,NULL,'','completed',795.00,0.00,0.00,NULL,NULL,0.00,795.00,1,NULL,1,'2024-03-05 00:56:16','kBtHzdFH4J1qg1lwYVdGxsXWGiIig',36,'2024-03-04 10:56:16','2024-03-05 00:56:16',3,NULL),(37,'#10000037',9,'1','default','pending',1432.00,0.00,0.00,NULL,NULL,0.00,1432.00,1,NULL,1,NULL,'y5uvv5PLSGKCEmgsPTxDiNX98NY4y',37,'2024-03-01 12:56:16','2024-03-05 00:56:16',6,NULL),(38,'#10000038',9,'1','default','pending',1816.00,0.00,0.00,NULL,NULL,0.00,1816.00,1,NULL,1,NULL,'yjoh3PF9SR7O4T9V63Q5R3tmgjJmC',38,'2024-03-02 00:56:16','2024-03-05 00:56:16',4,NULL),(39,'#10000039',9,NULL,'','completed',1470.00,0.00,0.00,NULL,NULL,0.00,1470.00,1,NULL,1,'2024-03-05 00:56:17','qf2VlXQioPd1TTUUYiCRajPPUuYJU',39,'2024-03-03 00:56:17','2024-03-05 00:56:17',2,NULL),(40,'#10000040',9,'1','default','completed',2004.00,0.00,0.00,NULL,NULL,0.00,2004.00,1,NULL,1,'2024-03-05 00:56:24','KuH91OGTGx4FqlF6q3pIDc7vl9Aav',40,'2024-03-04 00:56:17','2024-03-05 00:56:24',1,NULL),(41,'#10000041',10,'1','default','completed',7315.00,0.00,0.00,NULL,NULL,0.00,7315.00,1,NULL,1,'2024-03-05 00:56:24','1ZqJFIiwL4im7NmP5xaNC2ztrtnfY',41,'2024-03-02 12:56:17','2024-03-05 00:56:24',4,NULL),(42,'#10000042',10,'1','default','pending',2400.00,0.00,0.00,NULL,NULL,0.00,2400.00,1,NULL,1,NULL,'NFfXBA39zl8tNfe7hxhD4uC63vSFd',42,'2024-03-03 18:56:17','2024-03-05 00:56:17',3,NULL),(43,'#10000043',10,'1','default','completed',1155.00,0.00,0.00,NULL,NULL,0.00,1155.00,1,NULL,1,'2024-03-05 00:56:17','2rKdvnR33ayQyp5lIyXteoHRgZkCA',43,'2024-02-29 20:56:17','2024-03-05 00:56:17',1,NULL),(44,'#10000044',9,NULL,'','completed',3900.00,0.00,0.00,NULL,NULL,0.00,3900.00,1,NULL,1,'2024-03-05 00:56:18','s9KYoCPcHzl7M0uLaFS7FAy0GYrn0',44,'2024-03-01 16:56:17','2024-03-05 00:56:18',4,NULL),(45,'#10000045',9,'1','default','completed',309.00,0.00,0.00,NULL,NULL,0.00,309.00,1,NULL,1,'2024-03-05 00:56:18','ChOKahrMLzQHuO0P9cIjP8av06Cmy',45,'2024-03-03 00:56:18','2024-03-05 00:56:18',6,NULL),(46,'#10000046',10,NULL,'','completed',5850.00,0.00,0.00,NULL,NULL,0.00,5850.00,1,NULL,1,'2024-03-05 00:56:18','DO7qVpE6DnxqlHwE41UrDxkx9yw8G',46,'2024-03-03 12:56:18','2024-03-05 00:56:18',4,NULL),(47,'#10000047',10,'1','default','completed',306.00,0.00,0.00,NULL,NULL,0.00,306.00,1,NULL,1,'2024-03-05 00:56:18','fK0YoF77nyVGkGMbHTthjw0pNSMoz',47,'2024-03-03 12:56:18','2024-03-05 00:56:18',6,NULL),(48,'#10000048',9,'1','default','completed',6624.00,0.00,0.00,NULL,NULL,0.00,6624.00,1,NULL,1,'2024-03-05 00:56:18','zS8XpYGOusldt5XgT623mrrKIFHjH',48,'2024-03-03 20:56:18','2024-03-05 00:56:18',4,NULL),(49,'#10000049',9,'1','default','completed',2242.00,0.00,0.00,NULL,NULL,0.00,2242.00,1,NULL,1,'2024-03-05 00:56:25','HCC84YckTsm2BHIhAIVizFSffzb3Y',49,'2024-03-04 14:56:18','2024-03-05 00:56:25',8,NULL),(50,'#10000050',9,NULL,'','completed',3189.00,0.00,0.00,NULL,NULL,0.00,3189.00,1,NULL,1,'2024-03-05 00:56:19','aE2OEPPUceDKgAEKEZMVACx4NqaAJ',50,'2024-03-04 22:56:19','2024-03-05 00:56:19',5,NULL),(51,'#10000051',9,'1','default','pending',1596.00,0.00,0.00,NULL,NULL,0.00,1596.00,1,NULL,1,NULL,'xg91jOQAffm9Et4UMHSDF9yWbr8p5',51,'2024-03-04 04:56:19','2024-03-05 00:56:19',2,NULL);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2024-03-05 00:55:56','2024-03-05 00:55:56',0),(2,'Size','size','text',1,1,1,'published',1,'2024-03-05 00:55:56','2024-03-05 00:55:56',0),(3,'Weight','weight','text',1,1,1,'published',0,'2024-03-05 00:55:56','2024-03-05 00:55:56',0),(4,'Boxes','boxes','text',1,1,1,'published',1,'2024-03-05 00:55:56','2024-03-05 00:55:56',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(2,1,'Blue','blue','#333333',NULL,0,2,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(3,1,'Red','red','#DA323F',NULL,0,3,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(4,1,'Black','black','#2F366C',NULL,0,4,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(6,2,'S','s',NULL,NULL,1,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(7,2,'M','m',NULL,NULL,0,2,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(8,2,'L','l',NULL,NULL,0,3,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(9,2,'XL','xl',NULL,NULL,0,4,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(11,3,'1KG','1kg',NULL,NULL,1,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(12,3,'2KG','2kg',NULL,NULL,0,2,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(13,3,'3KG','3kg',NULL,NULL,0,3,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(14,3,'4KG','4kg',NULL,NULL,0,4,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(15,3,'5KG','5kg',NULL,NULL,0,5,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(16,4,'1 Box','1-box',NULL,NULL,1,1,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(17,4,'2 Boxes','2-boxes',NULL,NULL,0,2,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(18,4,'3 Boxes','3-boxes',NULL,NULL,0,3,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(19,4,'4 Boxes','4-boxes',NULL,NULL,0,4,'2024-03-05 00:55:56','2024-03-05 00:55:56'),(20,4,'5 Boxes','5-boxes',NULL,NULL,0,5,'2024-03-05 00:55:56','2024-03-05 00:55:56');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Bags',0,NULL,'published',0,'fashion/product-categories/1.jpg',0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(2,'Clothing',0,NULL,'published',1,'fashion/product-categories/4.jpg',0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(3,'Men\'s Clothing',2,NULL,'published',0,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(4,'T-Shirts',3,NULL,'published',0,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(5,'Jeans',3,NULL,'published',1,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(6,'Suits',3,NULL,'published',2,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(7,'Women\'s Clothing',2,NULL,'published',1,'fashion/product-categories/2.jpg',0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(8,'Dresses',7,NULL,'published',0,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(9,'Blouses',7,NULL,'published',1,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(10,'Pants',7,NULL,'published',2,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(11,'Footwear',0,NULL,'published',2,'fashion/product-categories/6.jpg',0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(12,'Accessories',0,NULL,'published',3,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(13,'Hats',12,NULL,'published',0,NULL,0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(14,'Scarves',12,NULL,'published',1,NULL,0,'2024-03-05 00:56:05','2024-03-05 00:56:05',NULL,NULL),(15,'Jewelry',12,NULL,'published',2,NULL,0,'2024-03-05 00:56:05','2024-03-05 00:56:05',NULL,NULL),(16,'Sportswear',0,NULL,'published',4,NULL,0,'2024-03-05 00:56:05','2024-03-05 00:56:05',NULL,NULL),(17,'Activewear',16,NULL,'published',0,NULL,0,'2024-03-05 00:56:05','2024-03-05 00:56:05',NULL,NULL),(18,'Running Shoes',16,NULL,'published',1,'fashion/product-categories/3.jpg',0,'2024-03-05 00:56:05','2024-03-05 00:56:05',NULL,NULL),(19,'Outerwear',0,NULL,'published',5,'fashion/product-categories/5.jpg',0,'2024-03-05 00:56:05','2024-03-05 00:56:05',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,1),(1,3),(1,6),(1,9),(1,17),(1,22),(1,25),(1,26),(1,30),(1,35),(2,16),(2,20),(2,22),(2,23),(2,29),(2,32),(2,36),(2,41),(3,2),(3,3),(3,8),(3,10),(3,15),(3,24),(3,25),(3,30),(3,31),(3,33),(4,1),(4,5),(4,13),(4,16),(4,19),(4,20),(4,21),(4,27),(4,29),(4,31),(4,34),(4,37),(4,39),(4,40),(5,4),(5,9),(5,11),(5,13),(5,18),(5,19),(5,24),(5,30),(5,35),(5,43),(6,2),(6,15),(6,18),(6,23),(6,25),(6,28),(6,29),(6,37),(6,40),(7,4),(7,12),(7,13),(7,20),(7,31),(7,32),(7,36),(7,37),(7,41),(7,42),(7,43),(8,9),(8,11),(8,13),(8,14),(8,21),(8,22),(8,27),(8,41),(8,42),(8,43),(9,10),(9,12),(9,17),(9,18),(9,22),(9,26),(9,28),(9,33),(9,34),(10,3),(10,6),(10,8),(10,17),(10,19),(10,27),(10,30),(11,5),(11,8),(11,11),(11,12),(11,24),(11,26),(11,31),(11,34),(11,38),(11,39),(12,6),(12,10),(12,16),(12,20),(12,35),(12,36),(12,38),(12,39),(12,40),(13,1),(13,7),(13,14),(13,21),(13,35),(13,42),(14,2),(14,4),(14,9),(14,11),(14,15),(14,19),(14,23),(14,24),(14,32),(14,33),(14,36),(14,37),(14,40),(15,5),(15,6),(16,2),(16,7),(16,10),(16,15),(16,18),(16,25),(16,27),(16,32),(16,33),(16,34),(17,4),(17,7),(17,23),(17,28),(17,38),(17,39),(17,43),(18,1),(18,3),(18,8),(18,14),(18,17),(18,26),(18,28),(18,29),(18,42),(19,5),(19,7),(19,12),(19,14),(19,16),(19,21),(19,38),(19,41);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,6),(1,9),(1,11),(1,12),(1,17),(1,18),(1,21),(1,22),(1,23),(1,24),(1,27),(1,34),(1,35),(1,38),(1,43),(2,2),(2,3),(2,4),(2,7),(2,8),(2,10),(2,13),(2,14),(2,20),(2,25),(2,26),(2,28),(2,31),(2,33),(2,42),(3,5),(3,15),(3,16),(3,29),(3,36),(3,37),(3,39),(3,40),(3,41),(4,1),(4,19),(4,30),(4,32);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'Trendy Wardrobe Essentials','trendy-wardrobe-essentials',NULL,NULL,'published','2024-03-05 00:56:05','2024-03-05 00:56:05',0),(2,'Fashion Forward Finds','fashion-forward-finds',NULL,NULL,'published','2024-03-05 00:56:05','2024-03-05 00:56:05',0),(3,'Chic &amp; Stylish Collection','chic-stylish-collection',NULL,NULL,'published','2024-03-05 00:56:05','2024-03-05 00:56:05',0),(4,'Weekly Fashion Picks','weekly-fashion-picks',NULL,NULL,'published','2024-03-05 00:56:05','2024-03-05 00:56:05',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,2,0,0.00,'fixed',1),(1,5,0,0.00,'fixed',1),(1,7,0,0.00,'fixed',1),(1,11,0,0.00,'fixed',1),(1,18,0,0.00,'fixed',1),(1,20,0,0.00,'fixed',1),(2,1,0,0.00,'fixed',1),(2,6,0,0.00,'fixed',1),(2,7,0,0.00,'fixed',1),(2,10,0,0.00,'fixed',1),(2,13,0,0.00,'fixed',1),(2,15,0,0.00,'fixed',1),(2,19,0,0.00,'fixed',1),(3,6,0,0.00,'fixed',1),(3,8,0,0.00,'fixed',1),(3,10,0,0.00,'fixed',1),(3,13,0,0.00,'fixed',1),(3,15,0,0.00,'fixed',1),(3,18,0,0.00,'fixed',1),(3,19,0,0.00,'fixed',1),(4,2,0,0.00,'fixed',1),(4,3,0,0.00,'fixed',1),(4,7,0,0.00,'fixed',1),(4,18,0,0.00,'fixed',1),(4,20,0,0.00,'fixed',1),(5,1,0,0.00,'fixed',1),(5,4,0,0.00,'fixed',1),(5,8,0,0.00,'fixed',1),(5,13,0,0.00,'fixed',1),(5,18,0,0.00,'fixed',1),(5,19,0,0.00,'fixed',1),(6,1,0,0.00,'fixed',1),(6,3,0,0.00,'fixed',1),(6,12,0,0.00,'fixed',1),(6,13,0,0.00,'fixed',1),(6,16,0,0.00,'fixed',1),(6,17,0,0.00,'fixed',1),(6,20,0,0.00,'fixed',1),(7,1,0,0.00,'fixed',1),(7,3,0,0.00,'fixed',1),(7,8,0,0.00,'fixed',1),(7,10,0,0.00,'fixed',1),(7,12,0,0.00,'fixed',1),(7,14,0,0.00,'fixed',1),(7,20,0,0.00,'fixed',1),(8,3,0,0.00,'fixed',1),(8,6,0,0.00,'fixed',1),(8,11,0,0.00,'fixed',1),(8,16,0,0.00,'fixed',1),(8,19,0,0.00,'fixed',1),(8,20,0,0.00,'fixed',1),(9,3,0,0.00,'fixed',1),(9,7,0,0.00,'fixed',1),(9,10,0,0.00,'fixed',1),(9,15,0,0.00,'fixed',1),(9,20,0,0.00,'fixed',1),(10,2,0,0.00,'fixed',1),(10,13,0,0.00,'fixed',1),(10,15,0,0.00,'fixed',1),(10,17,0,0.00,'fixed',1),(10,18,0,0.00,'fixed',1),(10,19,0,0.00,'fixed',1),(10,20,0,0.00,'fixed',1),(11,2,0,0.00,'fixed',1),(11,5,0,0.00,'fixed',1),(11,6,0,0.00,'fixed',1),(11,10,0,0.00,'fixed',1),(11,12,0,0.00,'fixed',1),(11,14,0,0.00,'fixed',1),(11,18,0,0.00,'fixed',1),(12,1,0,0.00,'fixed',1),(12,6,0,0.00,'fixed',1),(12,8,0,0.00,'fixed',1),(12,9,0,0.00,'fixed',1),(12,13,0,0.00,'fixed',1),(12,16,0,0.00,'fixed',1),(13,2,0,0.00,'fixed',1),(13,5,0,0.00,'fixed',1),(13,7,0,0.00,'fixed',1),(13,11,0,0.00,'fixed',1),(13,20,0,0.00,'fixed',1),(14,1,0,0.00,'fixed',1),(14,3,0,0.00,'fixed',1),(14,6,0,0.00,'fixed',1),(14,10,0,0.00,'fixed',1),(14,13,0,0.00,'fixed',1),(14,16,0,0.00,'fixed',1),(14,19,0,0.00,'fixed',1),(15,2,0,0.00,'fixed',1),(15,4,0,0.00,'fixed',1),(15,5,0,0.00,'fixed',1),(15,6,0,0.00,'fixed',1),(15,8,0,0.00,'fixed',1),(16,2,0,0.00,'fixed',1),(16,8,0,0.00,'fixed',1),(16,9,0,0.00,'fixed',1),(16,12,0,0.00,'fixed',1),(16,15,0,0.00,'fixed',1),(16,20,0,0.00,'fixed',1),(17,2,0,0.00,'fixed',1),(17,4,0,0.00,'fixed',1),(17,6,0,0.00,'fixed',1),(17,12,0,0.00,'fixed',1),(17,13,0,0.00,'fixed',1),(17,14,0,0.00,'fixed',1),(17,20,0,0.00,'fixed',1),(18,3,0,0.00,'fixed',1),(18,4,0,0.00,'fixed',1),(18,8,0,0.00,'fixed',1),(18,11,0,0.00,'fixed',1),(18,16,0,0.00,'fixed',1),(19,3,0,0.00,'fixed',1),(19,6,0,0.00,'fixed',1),(19,7,0,0.00,'fixed',1),(19,9,0,0.00,'fixed',1),(19,18,0,0.00,'fixed',1),(19,20,0,0.00,'fixed',1),(20,4,0,0.00,'fixed',1),(20,6,0,0.00,'fixed',1),(20,13,0,0.00,'fixed',1),(20,18,0,0.00,'fixed',1),(20,19,0,0.00,'fixed',1),(21,5,0,0.00,'fixed',1),(21,6,0,0.00,'fixed',1),(21,7,0,0.00,'fixed',1),(21,9,0,0.00,'fixed',1),(21,15,0,0.00,'fixed',1),(21,17,0,0.00,'fixed',1),(21,18,0,0.00,'fixed',1),(22,9,0,0.00,'fixed',1),(22,11,0,0.00,'fixed',1),(22,12,0,0.00,'fixed',1),(22,13,0,0.00,'fixed',1),(22,14,0,0.00,'fixed',1),(23,1,0,0.00,'fixed',1),(23,2,0,0.00,'fixed',1),(23,4,0,0.00,'fixed',1),(23,10,0,0.00,'fixed',1),(23,11,0,0.00,'fixed',1),(23,17,0,0.00,'fixed',1),(23,19,0,0.00,'fixed',1),(24,2,0,0.00,'fixed',1),(24,5,0,0.00,'fixed',1),(24,9,0,0.00,'fixed',1),(24,13,0,0.00,'fixed',1),(24,18,0,0.00,'fixed',1),(24,19,0,0.00,'fixed',1),(25,8,0,0.00,'fixed',1),(25,10,0,0.00,'fixed',1),(25,15,0,0.00,'fixed',1),(25,16,0,0.00,'fixed',1),(25,19,0,0.00,'fixed',1),(26,2,0,0.00,'fixed',1),(26,4,0,0.00,'fixed',1),(26,8,0,0.00,'fixed',1),(26,9,0,0.00,'fixed',1),(26,10,0,0.00,'fixed',1),(26,14,0,0.00,'fixed',1),(26,17,0,0.00,'fixed',1),(27,6,0,0.00,'fixed',1),(27,8,0,0.00,'fixed',1),(27,14,0,0.00,'fixed',1),(27,17,0,0.00,'fixed',1),(28,1,0,0.00,'fixed',1),(28,3,0,0.00,'fixed',1),(28,4,0,0.00,'fixed',1),(28,6,0,0.00,'fixed',1),(28,9,0,0.00,'fixed',1),(28,11,0,0.00,'fixed',1),(29,1,0,0.00,'fixed',1),(29,3,0,0.00,'fixed',1),(29,7,0,0.00,'fixed',1),(29,8,0,0.00,'fixed',1),(29,17,0,0.00,'fixed',1),(30,1,0,0.00,'fixed',1),(30,3,0,0.00,'fixed',1),(30,5,0,0.00,'fixed',1),(30,7,0,0.00,'fixed',1),(30,12,0,0.00,'fixed',1),(30,17,0,0.00,'fixed',1),(30,19,0,0.00,'fixed',1),(31,1,0,0.00,'fixed',1),(31,4,0,0.00,'fixed',1),(31,7,0,0.00,'fixed',1),(31,11,0,0.00,'fixed',1),(31,14,0,0.00,'fixed',1),(32,2,0,0.00,'fixed',1),(32,7,0,0.00,'fixed',1),(32,8,0,0.00,'fixed',1),(32,9,0,0.00,'fixed',1),(32,17,0,0.00,'fixed',1),(32,18,0,0.00,'fixed',1),(33,3,0,0.00,'fixed',1),(33,8,0,0.00,'fixed',1),(33,15,0,0.00,'fixed',1),(33,18,0,0.00,'fixed',1),(34,2,0,0.00,'fixed',1),(34,4,0,0.00,'fixed',1),(34,6,0,0.00,'fixed',1),(34,11,0,0.00,'fixed',1),(34,12,0,0.00,'fixed',1),(34,13,0,0.00,'fixed',1),(34,18,0,0.00,'fixed',1),(35,1,0,0.00,'fixed',1),(35,6,0,0.00,'fixed',1),(35,10,0,0.00,'fixed',1),(35,11,0,0.00,'fixed',1),(35,12,0,0.00,'fixed',1),(35,14,0,0.00,'fixed',1),(35,17,0,0.00,'fixed',1),(36,1,0,0.00,'fixed',1),(36,5,0,0.00,'fixed',1),(36,10,0,0.00,'fixed',1),(36,11,0,0.00,'fixed',1),(36,12,0,0.00,'fixed',1),(36,14,0,0.00,'fixed',1),(37,1,0,0.00,'fixed',1),(37,3,0,0.00,'fixed',1),(37,7,0,0.00,'fixed',1),(37,10,0,0.00,'fixed',1),(37,12,0,0.00,'fixed',1),(37,16,0,0.00,'fixed',1),(37,17,0,0.00,'fixed',1),(38,1,0,0.00,'fixed',1),(38,4,0,0.00,'fixed',1),(38,5,0,0.00,'fixed',1),(38,13,0,0.00,'fixed',1),(38,16,0,0.00,'fixed',1),(38,17,0,0.00,'fixed',1),(39,1,0,0.00,'fixed',1),(39,2,0,0.00,'fixed',1),(39,6,0,0.00,'fixed',1),(39,11,0,0.00,'fixed',1),(39,15,0,0.00,'fixed',1),(40,1,0,0.00,'fixed',1),(40,3,0,0.00,'fixed',1),(40,9,0,0.00,'fixed',1),(40,11,0,0.00,'fixed',1),(40,17,0,0.00,'fixed',1),(40,19,0,0.00,'fixed',1),(41,6,0,0.00,'fixed',1),(41,8,0,0.00,'fixed',1),(41,9,0,0.00,'fixed',1),(41,10,0,0.00,'fixed',1),(41,14,0,0.00,'fixed',1),(41,15,0,0.00,'fixed',1),(42,4,0,0.00,'fixed',1),(42,8,0,0.00,'fixed',1),(42,14,0,0.00,'fixed',1),(42,18,0,0.00,'fixed',1),(43,7,0,0.00,'fixed',1),(43,11,0,0.00,'fixed',1),(43,13,0,0.00,'fixed',1),(43,14,0,0.00,'fixed',1),(43,15,0,0.00,'fixed',1),(43,16,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,54,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(2,54,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(3,54,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(4,54,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(5,54,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(6,54,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(7,54,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(8,55,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(9,55,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(10,55,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(11,55,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(12,55,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(13,55,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(14,55,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(15,56,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(16,56,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(17,56,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(18,56,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(19,56,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(20,56,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(21,56,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(22,57,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(23,57,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(24,57,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(25,57,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(26,57,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(27,57,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(28,57,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(29,58,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(30,58,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(31,58,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(32,58,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(33,58,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(34,58,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(35,58,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(36,67,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(37,67,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(38,67,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(39,68,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(40,68,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(41,68,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(42,78,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(43,78,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(44,78,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(45,78,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(46,78,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(47,78,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(48,78,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(49,79,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(50,79,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(51,79,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(52,79,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(53,79,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(54,79,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(55,79,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(56,86,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(57,86,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(58,86,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(59,86,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(60,86,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(61,86,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(62,87,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(63,87,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(64,87,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(65,87,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(66,87,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(67,87,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(68,88,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(69,88,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(70,88,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(71,88,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(72,88,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(73,88,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:06\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:06','2024-03-05 00:56:06'),(74,95,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(75,95,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(76,95,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(77,95,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(78,96,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(79,96,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(80,96,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(81,96,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(82,97,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(83,97,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(84,97,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(85,97,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(86,110,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(87,110,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(88,110,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(89,110,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(90,110,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(91,110,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(92,110,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(93,110,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(94,111,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(95,111,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(96,111,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(97,111,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(98,111,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(99,111,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(100,111,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(101,111,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(102,119,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(103,119,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(104,119,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(105,119,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(106,119,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(107,119,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(108,120,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(109,120,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(110,120,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(111,120,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(112,120,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(113,120,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(114,129,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(115,129,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(116,129,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(117,129,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(118,129,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(119,129,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(120,129,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(121,129,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(122,130,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(123,130,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(124,130,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(125,130,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(126,130,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(127,130,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(128,130,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(129,130,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:07\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:56:07','2024-03-05 00:56:07'),(130,138,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(131,138,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(132,138,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(133,138,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(134,138,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(135,138,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(136,148,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(137,148,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(138,148,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(139,148,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(140,148,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(141,149,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(142,149,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(143,149,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(144,149,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08'),(145,149,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:56:08\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:56:08','2024-03-05 00:56:08');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,3),(1,6),(1,24),(1,27),(1,42),(2,12),(2,18),(2,30),(2,33),(3,9),(3,15),(3,21),(3,36),(3,39);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#cb4321','published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(2,'New','#00c9a7','published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(3,'Sale','#ba591d','published','2024-03-05 00:55:56','2024-03-05 00:55:56');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,1),(1,3),(1,5),(2,2),(2,3),(2,6),(3,1),(3,4),(3,5),(4,3),(4,5),(4,6),(5,1),(5,2),(5,4),(6,2),(6,3),(6,5),(7,1),(7,2),(7,3),(8,2),(8,4),(8,5),(9,2),(9,4),(9,6),(10,1),(10,2),(10,4),(11,1),(11,3),(11,6),(12,1),(12,3),(12,6),(13,2),(13,3),(13,5),(14,4),(14,5),(14,6),(15,2),(15,4),(15,5),(16,2),(16,4),(16,6),(17,1),(17,2),(17,6),(18,2),(18,3),(18,6),(19,1),(19,3),(19,4),(20,1),(20,2),(20,3),(21,1),(21,3),(21,6),(22,1),(22,3),(22,4),(23,1),(23,3),(23,4),(24,1),(24,4),(24,6),(25,1),(25,2),(25,5),(26,1),(26,2),(26,4),(27,1),(27,2),(27,4),(28,1),(28,4),(28,5),(29,2),(29,3),(29,6),(30,2),(30,3),(30,4),(31,1),(31,2),(31,3),(32,1),(32,2),(32,3),(33,2),(33,4),(33,5),(34,3),(34,5),(34,6),(35,2),(35,4),(35,5),(36,2),(36,4),(36,5),(37,2),(37,4),(37,6),(38,1),(38,3),(38,5),(39,3),(39,4),(39,6),(40,3),(40,5),(40,6),(41,3),(41,4),(41,5),(42,1),(42,4),(42,6),(43,2),(43,3),(43,4);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2024-03-05 00:55:59','2024-03-05 00:55:59'),(2,'Mobile',NULL,'published','2024-03-05 00:55:59','2024-03-05 00:55:59'),(3,'Iphone',NULL,'published','2024-03-05 00:55:59','2024-03-05 00:55:59'),(4,'Printer',NULL,'published','2024-03-05 00:55:59','2024-03-05 00:55:59'),(5,'Office',NULL,'published','2024-03-05 00:55:59','2024-03-05 00:55:59'),(6,'IT',NULL,'published','2024-03-05 00:55:59','2024-03-05 00:55:59');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (1,1,1),(19,1,10),(21,1,11),(37,1,19),(45,1,23),(47,1,24),(49,1,25),(53,1,27),(55,1,28),(63,1,32),(95,1,48),(105,1,53),(107,1,54),(121,1,61),(123,1,62),(125,1,63),(7,2,4),(25,2,13),(27,2,14),(33,2,17),(43,2,22),(57,2,29),(69,2,35),(71,2,36),(101,2,51),(109,2,55),(115,2,58),(127,2,64),(131,2,66),(5,3,3),(9,3,5),(11,3,6),(17,3,9),(35,3,18),(41,3,21),(51,3,26),(61,3,31),(91,3,46),(3,4,2),(29,4,15),(65,4,33),(73,4,37),(77,4,39),(79,4,40),(85,4,43),(97,4,49),(99,4,50),(111,4,56),(113,4,57),(13,5,7),(15,5,8),(23,5,12),(31,5,16),(39,5,20),(59,5,30),(67,5,34),(75,5,38),(81,5,41),(83,5,42),(87,5,44),(89,5,45),(93,5,47),(103,5,52),(117,5,59),(119,5,60),(129,5,65),(2,6,1),(16,6,8),(24,6,12),(34,6,17),(36,6,18),(42,6,21),(48,6,24),(52,6,26),(60,6,30),(62,6,31),(66,6,33),(100,6,50),(110,6,55),(112,6,56),(122,6,61),(124,6,62),(6,7,3),(8,7,4),(10,7,5),(14,7,7),(20,7,10),(64,7,32),(70,7,35),(72,7,36),(108,7,54),(116,7,58),(4,8,2),(12,8,6),(22,8,11),(26,8,13),(28,8,14),(30,8,15),(38,8,19),(40,8,20),(68,8,34),(76,8,38),(80,8,40),(82,8,41),(86,8,43),(88,8,44),(90,8,45),(98,8,49),(104,8,52),(114,8,57),(118,8,59),(130,8,65),(132,8,66),(18,9,9),(32,9,16),(44,9,22),(50,9,25),(54,9,27),(56,9,28),(78,9,39),(84,9,42),(126,9,63),(128,9,64),(46,10,23),(58,10,29),(74,10,37),(92,10,46),(94,10,47),(96,10,48),(102,10,51),(106,10,53),(120,10,60),(135,11,68),(139,11,70),(151,11,76),(163,11,82),(177,11,89),(207,11,104),(213,11,107),(215,11,108),(219,11,110),(225,11,113),(145,12,73),(189,12,95),(203,12,102),(143,13,72),(155,13,78),(165,13,83),(171,13,86),(175,13,88),(179,13,90),(181,13,91),(191,13,96),(197,13,99),(223,13,112),(133,14,67),(137,14,69),(141,14,71),(149,14,75),(153,14,77),(159,14,80),(167,14,84),(173,14,87),(183,14,92),(187,14,94),(193,14,97),(199,14,100),(205,14,103),(209,14,105),(211,14,106),(217,14,109),(147,15,74),(157,15,79),(161,15,81),(169,15,85),(185,15,93),(195,15,98),(201,15,101),(221,15,111),(138,16,69),(174,16,87),(178,16,89),(182,16,91),(184,16,92),(200,16,100),(204,16,102),(170,17,85),(176,17,88),(180,17,90),(192,17,96),(202,17,101),(212,17,106),(216,17,108),(218,17,109),(136,18,68),(144,18,72),(152,18,76),(158,18,79),(168,18,84),(172,18,86),(206,18,103),(140,19,70),(148,19,74),(150,19,75),(156,19,78),(160,19,80),(166,19,83),(186,19,93),(190,19,95),(196,19,98),(198,19,99),(210,19,105),(220,19,110),(134,20,67),(142,20,71),(146,20,73),(154,20,77),(162,20,81),(164,20,82),(188,20,94),(194,20,97),(208,20,104),(214,20,107),(222,20,111),(224,20,112),(226,20,113);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,44,1,1),(2,45,1,0),(3,46,1,0),(4,47,1,0),(5,48,2,1),(6,49,2,0),(7,50,2,0),(8,51,3,1),(9,52,3,0),(10,53,3,0),(11,54,4,1),(12,55,4,0),(13,56,4,0),(14,57,4,0),(15,58,4,0),(16,59,5,1),(17,60,6,1),(18,61,6,0),(19,62,7,1),(20,63,7,0),(21,64,7,0),(22,65,7,0),(23,66,7,0),(24,67,8,1),(25,68,8,0),(26,69,9,1),(27,70,9,0),(28,71,9,0),(29,72,10,1),(30,73,10,0),(31,74,10,0),(32,75,11,1),(33,76,11,0),(34,77,11,0),(35,78,12,1),(36,79,12,0),(37,80,13,1),(38,81,14,1),(39,82,14,0),(40,83,15,1),(41,84,15,0),(42,85,15,0),(43,86,16,1),(44,87,16,0),(45,88,16,0),(46,89,17,1),(47,90,17,0),(48,91,18,1),(49,92,19,1),(50,93,19,0),(51,94,19,0),(52,95,20,1),(53,96,20,0),(54,97,20,0),(55,98,21,1),(56,99,21,0),(57,100,21,0),(58,101,21,0),(59,102,21,0),(60,103,22,1),(61,104,22,0),(62,105,22,0),(63,106,23,1),(64,107,23,0),(65,108,23,0),(66,109,23,0),(67,110,24,1),(68,111,24,0),(69,112,25,1),(70,113,25,0),(71,114,26,1),(72,115,26,0),(73,116,26,0),(74,117,27,1),(75,118,27,0),(76,119,28,1),(77,120,28,0),(78,121,29,1),(79,122,29,0),(80,123,29,0),(81,124,30,1),(82,125,30,0),(83,126,31,1),(84,127,31,0),(85,128,31,0),(86,129,32,1),(87,130,32,0),(88,131,33,1),(89,132,34,1),(90,133,34,0),(91,134,34,0),(92,135,34,0),(93,136,35,1),(94,137,35,0),(95,138,36,1),(96,139,37,1),(97,140,37,0),(98,141,38,1),(99,142,38,0),(100,143,39,1),(101,144,39,0),(102,145,39,0),(103,146,39,0),(104,147,39,0),(105,148,40,1),(106,149,40,0),(107,150,41,1),(108,151,41,0),(109,152,42,1),(110,153,42,0),(111,154,43,1),(112,155,43,0),(113,156,43,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2024-03-05',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(3,24,0),(4,24,0),(3,25,0),(4,25,0),(3,26,0),(4,26,0),(3,27,0),(4,27,0),(3,28,0),(4,28,0),(3,29,0),(4,29,0),(3,30,0),(4,30,0),(3,31,0),(4,31,0),(3,32,0),(4,32,0),(3,33,0),(4,33,0),(3,34,0),(4,34,0),(3,35,0),(4,35,0),(3,36,0),(4,36,0),(3,37,0),(4,37,0),(3,38,0),(4,38,0),(3,39,0),(4,39,0),(3,40,0),(4,40,0),(3,41,0),(4,41,0),(3,42,0),(4,42,0),(3,43,0),(4,43,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `approved_by` bigint unsigned DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Vintage Denim Jacket','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\"]','PH-114-A0',0,11,0,1,1,2,0,0,716,NULL,NULL,NULL,17.00,19.00,17.00,878.00,NULL,38763,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(2,'Floral Maxi Dress','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\"]','NH-177-A0',0,10,0,1,0,3,0,0,518,NULL,NULL,NULL,12.00,16.00,17.00,598.00,NULL,32050,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(3,'Leather Ankle Boots','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-1.png\"]','FS-128-A0',0,20,0,1,0,5,0,0,1240,NULL,NULL,NULL,18.00,15.00,19.00,649.00,NULL,73709,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(4,'Knit Turtleneck Sweater (Digital)','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-8.png\"]','VD-173-A0',0,14,0,1,1,3,0,0,1950,1384.5,NULL,NULL,13.00,16.00,12.00,576.00,NULL,125431,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(5,'Classic Aviator Sunglasses','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-4.png\"]','EK-166-A0',0,13,0,1,0,2,0,0,1473,NULL,NULL,NULL,20.00,12.00,11.00,628.00,NULL,13063,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(6,'Tailored Wool Blazer','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-4.png\"]','7R-115-A0',0,16,0,1,1,5,0,0,1289,NULL,NULL,NULL,11.00,13.00,16.00,504.00,NULL,68989,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(7,'Bohemian Fringe Handbag','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\"]','MD-111-A0',0,18,0,1,0,5,0,0,908,NULL,NULL,NULL,16.00,20.00,16.00,672.00,NULL,159130,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(8,'Silk Scarf with Geometric Print (Digital)','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\"]','07-101-A0',0,20,0,1,1,1,0,0,2497,2222.33,NULL,NULL,12.00,19.00,14.00,707.00,NULL,108942,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(9,'High-Waisted Wide Leg Trousers','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\"]','6Y-120-A0',0,15,0,1,1,5,0,0,1047,NULL,NULL,NULL,10.00,12.00,11.00,571.00,NULL,150997,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(10,'Embroidered Boho Blouse','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\"]','9Q-161-A0',0,15,0,1,1,4,0,0,1048,NULL,NULL,NULL,19.00,18.00,13.00,782.00,NULL,175002,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(11,'Statement Chunky Necklace','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\"]','YP-121-A0',0,12,0,1,0,3,0,0,306,NULL,NULL,NULL,20.00,19.00,17.00,691.00,NULL,188596,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(12,'Chic Fedora Hat (Digital)','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-8.png\"]','QR-141-A0',0,12,0,1,0,1,0,0,1753,1577.7,NULL,NULL,11.00,13.00,20.00,614.00,NULL,56899,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(13,'Strappy Block Heel Sandals','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-6.png\"]','4L-166-A0',0,14,0,1,1,2,0,0,1058,NULL,NULL,NULL,14.00,20.00,15.00,894.00,NULL,89025,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(14,'Velvet Evening Gown','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\"]','VW-175-A0',0,17,0,1,1,3,0,0,2071,NULL,NULL,NULL,20.00,10.00,17.00,501.00,NULL,49597,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(15,'Quilted Crossbody Bag','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\"]','JQ-195-A0',0,20,0,1,0,2,0,0,800,NULL,NULL,NULL,16.00,11.00,16.00,694.00,NULL,123529,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(16,'Distressed Skinny Jeans (Digital)','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-3.png\"]','KJ-145-A0',0,18,0,1,0,3,0,0,490,362.6,NULL,NULL,20.00,11.00,17.00,536.00,NULL,119668,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(17,'Lace-Up Combat Boots','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\"]','U7-159-A0',0,17,0,1,0,4,0,0,327,NULL,NULL,NULL,15.00,17.00,14.00,534.00,NULL,155701,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(18,'Cotton Striped T-Shirt Dress','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\"]','Y8-123-A0',0,19,0,1,1,5,0,0,1850,NULL,NULL,NULL,13.00,19.00,13.00,711.00,NULL,22223,'2024-03-05 00:56:05','2024-03-05 00:56:06','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(19,'Printed Palazzo Pants','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\"]','UO-150-A0',0,10,0,1,1,1,0,0,2431,NULL,NULL,NULL,13.00,12.00,13.00,670.00,NULL,176644,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(20,'Structured Satchel Bag (Digital)','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\"]','ZH-114-A0',0,11,0,1,1,5,0,0,2450,1715,NULL,NULL,14.00,11.00,20.00,843.00,NULL,137399,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(21,'Off-Shoulder Ruffle Top','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-5.png\"]','UM-125-A0',0,19,0,1,1,2,0,0,1722,NULL,NULL,NULL,16.00,20.00,18.00,648.00,NULL,178787,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(22,'Suede Pointed-Toe Pumps','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\"]','FR-144-A0',0,10,0,1,0,5,0,0,1379,NULL,NULL,NULL,19.00,16.00,16.00,722.00,NULL,149166,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(23,'Cropped Cable Knit Sweater','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-1.png\"]','E2-121-A0',0,16,0,1,0,2,0,0,2242,NULL,NULL,NULL,10.00,13.00,13.00,804.00,NULL,128891,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(24,'Athleisure Jogger Pants (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\"]','XS-101-A0',0,19,0,1,1,3,0,0,1479,1183.2,NULL,NULL,16.00,18.00,15.00,778.00,NULL,93465,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(25,'Leopard Print Midi Skirt','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-4.png\"]','AH-129-A0',0,18,0,1,0,4,0,0,2304,NULL,NULL,NULL,19.00,10.00,16.00,648.00,NULL,15600,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(26,'Retro Cat-Eye Sunglasses','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\"]','VF-160-A0',0,16,0,1,0,4,0,0,2441,NULL,NULL,NULL,15.00,13.00,16.00,525.00,NULL,54079,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(27,'Faux Fur Trimmed Coat','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\"]','6U-190-A0',0,15,0,1,0,4,0,0,1904,NULL,NULL,NULL,17.00,18.00,11.00,543.00,NULL,32325,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(28,'Boho Fringed Kimono (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\"]','ZU-186-A0',0,14,0,1,1,4,0,0,1063,818.51,NULL,NULL,18.00,14.00,14.00,895.00,NULL,176100,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(29,'Ruffled Wrap Dress','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\"]','Z1-112-A0',0,15,0,1,0,5,0,0,2098,NULL,NULL,NULL,17.00,16.00,16.00,541.00,NULL,34135,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(30,'Beaded Evening Clutch','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\"]','TF-194-A0',0,13,0,1,1,3,0,0,1512,NULL,NULL,NULL,12.00,17.00,12.00,837.00,NULL,134959,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(31,'Wide Brim Floppy Hat','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\"]','EN-191-A0',0,17,0,1,1,4,0,0,1376,NULL,NULL,NULL,11.00,13.00,16.00,834.00,NULL,143360,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(32,'Denim Overall Jumpsuit (Digital)','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-2.png\"]','CL-103-A0',0,12,0,1,1,2,0,0,682,600.16,NULL,NULL,18.00,13.00,15.00,837.00,NULL,115156,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(33,'Embellished Ballet Flats','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\"]','VL-197-A0',0,14,0,1,0,4,0,0,1465,NULL,NULL,NULL,12.00,17.00,20.00,580.00,NULL,55267,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(34,'Pleated Midi Skirt','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\"]','LC-188-A0',0,18,0,1,0,4,0,0,1155,NULL,NULL,NULL,13.00,10.00,16.00,602.00,NULL,23273,'2024-03-05 00:56:05','2024-03-05 00:56:07','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(35,'Velour Tracksuit Set','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\"]','QJ-126-A0',0,18,0,1,1,1,0,0,2004,NULL,NULL,NULL,10.00,17.00,17.00,527.00,NULL,14937,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(36,'Geometric Patterned Cardigan (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\"]','M8-112-A0',0,12,0,1,1,1,0,0,289,236.98,NULL,NULL,12.00,12.00,19.00,606.00,NULL,12880,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(37,'Buckle Detail Ankle Booties','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-5.png\"]','AJ-168-A0',0,10,0,1,0,5,0,0,532,NULL,NULL,NULL,16.00,13.00,10.00,778.00,NULL,162084,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(38,'Embroidered Bomber Jacket','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\"]','LJ-162-A0',0,18,0,1,1,5,0,0,309,NULL,NULL,NULL,19.00,11.00,18.00,668.00,NULL,151947,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(39,'Cowl Neck Knit Poncho','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\"]','W5-146-A0',0,16,0,1,1,5,0,0,1901,NULL,NULL,NULL,19.00,18.00,10.00,596.00,NULL,149594,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(40,'Chunky Knit Infinity Scarf (Digital)','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-7.png\"]','NW-108-A0',0,15,0,1,0,1,0,0,265,198.75,NULL,NULL,19.00,14.00,11.00,692.00,NULL,102862,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(41,'Retro High-Top Sneakers','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-3.png\"]','5F-177-A0',0,17,0,1,1,1,0,0,1733,NULL,NULL,NULL,15.00,13.00,11.00,601.00,NULL,71577,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(42,'Faux Leather Leggings','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-3.png\"]','9B-176-A0',0,15,0,1,0,4,0,0,331,NULL,NULL,NULL,20.00,20.00,17.00,580.00,NULL,182056,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(43,'Metallic Pleated Maxi Skirt','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\"]','LW-200-A0',0,11,0,1,0,1,0,0,1838,NULL,NULL,NULL,16.00,20.00,15.00,863.00,NULL,135253,'2024-03-05 00:56:05','2024-03-05 00:56:08','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(44,'Vintage Denim Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','PH-114-A0',0,11,0,1,0,2,1,0,716,NULL,NULL,NULL,17.00,19.00,17.00,878.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(45,'Vintage Denim Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','PH-114-A0-A1',0,11,0,1,0,2,1,0,716,NULL,NULL,NULL,17.00,19.00,17.00,878.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(46,'Vintage Denim Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','PH-114-A0-A2',0,11,0,1,0,2,1,0,716,NULL,NULL,NULL,17.00,19.00,17.00,878.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(47,'Vintage Denim Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','PH-114-A0-A3',0,11,0,1,0,2,1,0,716,NULL,NULL,NULL,17.00,19.00,17.00,878.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(48,'Floral Maxi Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','NH-177-A0',0,10,0,1,0,3,1,0,518,NULL,NULL,NULL,12.00,16.00,17.00,598.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(49,'Floral Maxi Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','NH-177-A0-A1',0,10,0,1,0,3,1,0,518,NULL,NULL,NULL,12.00,16.00,17.00,598.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(50,'Floral Maxi Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','NH-177-A0-A2',0,10,0,1,0,3,1,0,518,NULL,NULL,NULL,12.00,16.00,17.00,598.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(51,'Leather Ankle Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','FS-128-A0',0,20,0,1,0,5,1,0,1240,NULL,NULL,NULL,18.00,15.00,19.00,649.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(52,'Leather Ankle Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','FS-128-A0-A1',0,20,0,1,0,5,1,0,1240,NULL,NULL,NULL,18.00,15.00,19.00,649.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(53,'Leather Ankle Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','FS-128-A0-A2',0,20,0,1,0,5,1,0,1240,NULL,NULL,NULL,18.00,15.00,19.00,649.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(54,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','VD-173-A0',0,14,0,1,0,3,1,0,1950,1384.5,NULL,NULL,13.00,16.00,12.00,576.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(55,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','VD-173-A0-A1',0,14,0,1,0,3,1,0,1950,1638,NULL,NULL,13.00,16.00,12.00,576.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(56,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','VD-173-A0-A2',0,14,0,1,0,3,1,0,1950,1696.5,NULL,NULL,13.00,16.00,12.00,576.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(57,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','VD-173-A0-A3',0,14,0,1,0,3,1,0,1950,1482,NULL,NULL,13.00,16.00,12.00,576.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(58,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','VD-173-A0-A4',0,14,0,1,0,3,1,0,1950,1755,NULL,NULL,13.00,16.00,12.00,576.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(59,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','EK-166-A0',0,13,0,1,0,2,1,0,1473,NULL,NULL,NULL,20.00,12.00,11.00,628.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(60,'Tailored Wool Blazer',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','7R-115-A0',0,16,0,1,0,5,1,0,1289,NULL,NULL,NULL,11.00,13.00,16.00,504.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(61,'Tailored Wool Blazer',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','7R-115-A0-A1',0,16,0,1,0,5,1,0,1289,NULL,NULL,NULL,11.00,13.00,16.00,504.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(62,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','MD-111-A0',0,18,0,1,0,5,1,0,908,NULL,NULL,NULL,16.00,20.00,16.00,672.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(63,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','MD-111-A0-A1',0,18,0,1,0,5,1,0,908,NULL,NULL,NULL,16.00,20.00,16.00,672.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(64,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','MD-111-A0-A2',0,18,0,1,0,5,1,0,908,NULL,NULL,NULL,16.00,20.00,16.00,672.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(65,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','MD-111-A0-A3',0,18,0,1,0,5,1,0,908,NULL,NULL,NULL,16.00,20.00,16.00,672.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(66,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','MD-111-A0-A4',0,18,0,1,0,5,1,0,908,NULL,NULL,NULL,16.00,20.00,16.00,672.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(67,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','07-101-A0',0,20,0,1,0,1,1,0,2497,2222.33,NULL,NULL,12.00,19.00,14.00,707.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(68,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','07-101-A0-A1',0,20,0,1,0,1,1,0,2497,2122.45,NULL,NULL,12.00,19.00,14.00,707.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(69,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','6Y-120-A0',0,15,0,1,0,5,1,0,1047,NULL,NULL,NULL,10.00,12.00,11.00,571.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(70,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','6Y-120-A0-A1',0,15,0,1,0,5,1,0,1047,NULL,NULL,NULL,10.00,12.00,11.00,571.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(71,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','6Y-120-A0-A2',0,15,0,1,0,5,1,0,1047,NULL,NULL,NULL,10.00,12.00,11.00,571.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(72,'Embroidered Boho Blouse',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','9Q-161-A0',0,15,0,1,0,4,1,0,1048,NULL,NULL,NULL,19.00,18.00,13.00,782.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(73,'Embroidered Boho Blouse',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','9Q-161-A0-A1',0,15,0,1,0,4,1,0,1048,NULL,NULL,NULL,19.00,18.00,13.00,782.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(74,'Embroidered Boho Blouse',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','9Q-161-A0-A2',0,15,0,1,0,4,1,0,1048,NULL,NULL,NULL,19.00,18.00,13.00,782.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(75,'Statement Chunky Necklace',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','YP-121-A0',0,12,0,1,0,3,1,0,306,NULL,NULL,NULL,20.00,19.00,17.00,691.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(76,'Statement Chunky Necklace',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','YP-121-A0-A1',0,12,0,1,0,3,1,0,306,NULL,NULL,NULL,20.00,19.00,17.00,691.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(77,'Statement Chunky Necklace',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','YP-121-A0-A2',0,12,0,1,0,3,1,0,306,NULL,NULL,NULL,20.00,19.00,17.00,691.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(78,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','QR-141-A0',0,12,0,1,0,1,1,0,1753,1577.7,NULL,NULL,11.00,13.00,20.00,614.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(79,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','QR-141-A0-A1',0,12,0,1,0,1,1,0,1753,1490.05,NULL,NULL,11.00,13.00,20.00,614.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(80,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','4L-166-A0',0,14,0,1,0,2,1,0,1058,NULL,NULL,NULL,14.00,20.00,15.00,894.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(81,'Velvet Evening Gown',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','VW-175-A0',0,17,0,1,0,3,1,0,2071,NULL,NULL,NULL,20.00,10.00,17.00,501.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(82,'Velvet Evening Gown',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','VW-175-A0-A1',0,17,0,1,0,3,1,0,2071,NULL,NULL,NULL,20.00,10.00,17.00,501.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(83,'Quilted Crossbody Bag',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','JQ-195-A0',0,20,0,1,0,2,1,0,800,NULL,NULL,NULL,16.00,11.00,16.00,694.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(84,'Quilted Crossbody Bag',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','JQ-195-A0-A1',0,20,0,1,0,2,1,0,800,NULL,NULL,NULL,16.00,11.00,16.00,694.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(85,'Quilted Crossbody Bag',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','JQ-195-A0-A2',0,20,0,1,0,2,1,0,800,NULL,NULL,NULL,16.00,11.00,16.00,694.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(86,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','KJ-145-A0',0,18,0,1,0,3,1,0,490,362.6,NULL,NULL,20.00,11.00,17.00,536.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(87,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','KJ-145-A0-A1',0,18,0,1,0,3,1,0,490,352.8,NULL,NULL,20.00,11.00,17.00,536.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(88,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','KJ-145-A0-A2',0,18,0,1,0,3,1,0,490,411.6,NULL,NULL,20.00,11.00,17.00,536.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(89,'Lace-Up Combat Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','U7-159-A0',0,17,0,1,0,4,1,0,327,NULL,NULL,NULL,15.00,17.00,14.00,534.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(90,'Lace-Up Combat Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','U7-159-A0-A1',0,17,0,1,0,4,1,0,327,NULL,NULL,NULL,15.00,17.00,14.00,534.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(91,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','Y8-123-A0',0,19,0,1,0,5,1,0,1850,NULL,NULL,NULL,13.00,19.00,13.00,711.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:06','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(92,'Printed Palazzo Pants',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','UO-150-A0',0,10,0,1,0,1,1,0,2431,NULL,NULL,NULL,13.00,12.00,13.00,670.00,NULL,0,'2024-03-05 00:56:06','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(93,'Printed Palazzo Pants',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','UO-150-A0-A1',0,10,0,1,0,1,1,0,2431,NULL,NULL,NULL,13.00,12.00,13.00,670.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(94,'Printed Palazzo Pants',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','UO-150-A0-A2',0,10,0,1,0,1,1,0,2431,NULL,NULL,NULL,13.00,12.00,13.00,670.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(95,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','ZH-114-A0',0,11,0,1,0,5,1,0,2450,1715,NULL,NULL,14.00,11.00,20.00,843.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(96,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','ZH-114-A0-A1',0,11,0,1,0,5,1,0,2450,1960,NULL,NULL,14.00,11.00,20.00,843.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(97,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','ZH-114-A0-A2',0,11,0,1,0,5,1,0,2450,1984.5,NULL,NULL,14.00,11.00,20.00,843.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(98,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','UM-125-A0',0,19,0,1,0,2,1,0,1722,NULL,NULL,NULL,16.00,20.00,18.00,648.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(99,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','UM-125-A0-A1',0,19,0,1,0,2,1,0,1722,NULL,NULL,NULL,16.00,20.00,18.00,648.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(100,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','UM-125-A0-A2',0,19,0,1,0,2,1,0,1722,NULL,NULL,NULL,16.00,20.00,18.00,648.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(101,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','UM-125-A0-A3',0,19,0,1,0,2,1,0,1722,NULL,NULL,NULL,16.00,20.00,18.00,648.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(102,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','UM-125-A0-A4',0,19,0,1,0,2,1,0,1722,NULL,NULL,NULL,16.00,20.00,18.00,648.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(103,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','FR-144-A0',0,10,0,1,0,5,1,0,1379,NULL,NULL,NULL,19.00,16.00,16.00,722.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(104,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','FR-144-A0-A1',0,10,0,1,0,5,1,0,1379,NULL,NULL,NULL,19.00,16.00,16.00,722.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(105,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','FR-144-A0-A2',0,10,0,1,0,5,1,0,1379,NULL,NULL,NULL,19.00,16.00,16.00,722.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(106,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','E2-121-A0',0,16,0,1,0,2,1,0,2242,NULL,NULL,NULL,10.00,13.00,13.00,804.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(107,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','E2-121-A0-A1',0,16,0,1,0,2,1,0,2242,NULL,NULL,NULL,10.00,13.00,13.00,804.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(108,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','E2-121-A0-A2',0,16,0,1,0,2,1,0,2242,NULL,NULL,NULL,10.00,13.00,13.00,804.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(109,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','E2-121-A0-A3',0,16,0,1,0,2,1,0,2242,NULL,NULL,NULL,10.00,13.00,13.00,804.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(110,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','XS-101-A0',0,19,0,1,0,3,1,0,1479,1183.2,NULL,NULL,16.00,18.00,15.00,778.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(111,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','XS-101-A0-A1',0,19,0,1,0,3,1,0,1479,1064.88,NULL,NULL,16.00,18.00,15.00,778.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(112,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','AH-129-A0',0,18,0,1,0,4,1,0,2304,NULL,NULL,NULL,19.00,10.00,16.00,648.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(113,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','AH-129-A0-A1',0,18,0,1,0,4,1,0,2304,NULL,NULL,NULL,19.00,10.00,16.00,648.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(114,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','VF-160-A0',0,16,0,1,0,4,1,0,2441,NULL,NULL,NULL,15.00,13.00,16.00,525.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(115,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','VF-160-A0-A1',0,16,0,1,0,4,1,0,2441,NULL,NULL,NULL,15.00,13.00,16.00,525.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(116,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','VF-160-A0-A2',0,16,0,1,0,4,1,0,2441,NULL,NULL,NULL,15.00,13.00,16.00,525.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(117,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','6U-190-A0',0,15,0,1,0,4,1,0,1904,NULL,NULL,NULL,17.00,18.00,11.00,543.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(118,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','6U-190-A0-A1',0,15,0,1,0,4,1,0,1904,NULL,NULL,NULL,17.00,18.00,11.00,543.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(119,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','ZU-186-A0',0,14,0,1,0,4,1,0,1063,818.51,NULL,NULL,18.00,14.00,14.00,895.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(120,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','ZU-186-A0-A1',0,14,0,1,0,4,1,0,1063,956.7,NULL,NULL,18.00,14.00,14.00,895.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(121,'Ruffled Wrap Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','Z1-112-A0',0,15,0,1,0,5,1,0,2098,NULL,NULL,NULL,17.00,16.00,16.00,541.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(122,'Ruffled Wrap Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','Z1-112-A0-A1',0,15,0,1,0,5,1,0,2098,NULL,NULL,NULL,17.00,16.00,16.00,541.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(123,'Ruffled Wrap Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','Z1-112-A0-A2',0,15,0,1,0,5,1,0,2098,NULL,NULL,NULL,17.00,16.00,16.00,541.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(124,'Beaded Evening Clutch',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','TF-194-A0',0,13,0,1,0,3,1,0,1512,NULL,NULL,NULL,12.00,17.00,12.00,837.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(125,'Beaded Evening Clutch',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','TF-194-A0-A1',0,13,0,1,0,3,1,0,1512,NULL,NULL,NULL,12.00,17.00,12.00,837.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(126,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','EN-191-A0',0,17,0,1,0,4,1,0,1376,NULL,NULL,NULL,11.00,13.00,16.00,834.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(127,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','EN-191-A0-A1',0,17,0,1,0,4,1,0,1376,NULL,NULL,NULL,11.00,13.00,16.00,834.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(128,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','EN-191-A0-A2',0,17,0,1,0,4,1,0,1376,NULL,NULL,NULL,11.00,13.00,16.00,834.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(129,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','CL-103-A0',0,12,0,1,0,2,1,0,682,600.16,NULL,NULL,18.00,13.00,15.00,837.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(130,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','CL-103-A0-A1',0,12,0,1,0,2,1,0,682,613.8,NULL,NULL,18.00,13.00,15.00,837.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(131,'Embellished Ballet Flats',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','VL-197-A0',0,14,0,1,0,4,1,0,1465,NULL,NULL,NULL,12.00,17.00,20.00,580.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(132,'Pleated Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','LC-188-A0',0,18,0,1,0,4,1,0,1155,NULL,NULL,NULL,13.00,10.00,16.00,602.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(133,'Pleated Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','LC-188-A0-A1',0,18,0,1,0,4,1,0,1155,NULL,NULL,NULL,13.00,10.00,16.00,602.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(134,'Pleated Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','LC-188-A0-A2',0,18,0,1,0,4,1,0,1155,NULL,NULL,NULL,13.00,10.00,16.00,602.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(135,'Pleated Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','LC-188-A0-A3',0,18,0,1,0,4,1,0,1155,NULL,NULL,NULL,13.00,10.00,16.00,602.00,NULL,0,'2024-03-05 00:56:07','2024-03-05 00:56:07','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(136,'Velour Tracksuit Set',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','QJ-126-A0',0,18,0,1,0,1,1,0,2004,NULL,NULL,NULL,10.00,17.00,17.00,527.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(137,'Velour Tracksuit Set',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','QJ-126-A0-A1',0,18,0,1,0,1,1,0,2004,NULL,NULL,NULL,10.00,17.00,17.00,527.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(138,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','M8-112-A0',0,12,0,1,0,1,1,0,289,236.98,NULL,NULL,12.00,12.00,19.00,606.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(139,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','AJ-168-A0',0,10,0,1,0,5,1,0,532,NULL,NULL,NULL,16.00,13.00,10.00,778.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(140,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','AJ-168-A0-A1',0,10,0,1,0,5,1,0,532,NULL,NULL,NULL,16.00,13.00,10.00,778.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(141,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','LJ-162-A0',0,18,0,1,0,5,1,0,309,NULL,NULL,NULL,19.00,11.00,18.00,668.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(142,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','LJ-162-A0-A1',0,18,0,1,0,5,1,0,309,NULL,NULL,NULL,19.00,11.00,18.00,668.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(143,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','W5-146-A0',0,16,0,1,0,5,1,0,1901,NULL,NULL,NULL,19.00,18.00,10.00,596.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(144,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','W5-146-A0-A1',0,16,0,1,0,5,1,0,1901,NULL,NULL,NULL,19.00,18.00,10.00,596.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(145,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','W5-146-A0-A2',0,16,0,1,0,5,1,0,1901,NULL,NULL,NULL,19.00,18.00,10.00,596.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(146,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','W5-146-A0-A3',0,16,0,1,0,5,1,0,1901,NULL,NULL,NULL,19.00,18.00,10.00,596.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(147,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','W5-146-A0-A4',0,16,0,1,0,5,1,0,1901,NULL,NULL,NULL,19.00,18.00,10.00,596.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(148,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','NW-108-A0',0,15,0,1,0,1,1,0,265,198.75,NULL,NULL,19.00,14.00,11.00,692.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(149,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','NW-108-A0-A1',0,15,0,1,0,1,1,0,265,230.55,NULL,NULL,19.00,14.00,11.00,692.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(150,'Retro High-Top Sneakers',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','5F-177-A0',0,17,0,1,0,1,1,0,1733,NULL,NULL,NULL,15.00,13.00,11.00,601.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(151,'Retro High-Top Sneakers',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','5F-177-A0-A1',0,17,0,1,0,1,1,0,1733,NULL,NULL,NULL,15.00,13.00,11.00,601.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(152,'Faux Leather Leggings',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','9B-176-A0',0,15,0,1,0,4,1,0,331,NULL,NULL,NULL,20.00,20.00,17.00,580.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(153,'Faux Leather Leggings',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','9B-176-A0-A1',0,15,0,1,0,4,1,0,331,NULL,NULL,NULL,20.00,20.00,17.00,580.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(154,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','LW-200-A0',0,11,0,1,0,1,1,0,1838,NULL,NULL,NULL,16.00,20.00,15.00,863.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(155,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','LW-200-A0-A1',0,11,0,1,0,1,1,0,1838,NULL,NULL,NULL,16.00,20.00,15.00,863.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(156,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','LW-200-A0-A2',0,11,0,1,0,1,1,0,1838,NULL,NULL,NULL,16.00,20.00,15.00,863.00,NULL,0,'2024-03-05 00:56:08','2024-03-05 00:56:08','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,6,21,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(2,10,6,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(3,4,24,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(4,3,28,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(5,7,6,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(6,8,15,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-18.jpg\"]'),(7,7,42,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(8,7,3,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(9,6,13,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(10,9,40,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\"]'),(11,6,33,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(12,3,43,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\"]'),(13,8,4,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(14,3,34,5.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(15,9,24,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(16,7,2,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(17,5,11,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\"]'),(18,7,35,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(19,10,3,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(21,6,7,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\"]'),(22,8,28,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(23,4,18,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(24,1,4,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\"]'),(25,7,11,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(26,9,34,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\"]'),(27,9,22,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(28,10,11,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(29,5,9,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(30,10,10,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(31,4,38,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(32,2,30,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\"]'),(33,8,3,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(34,3,7,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(35,3,2,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\"]'),(36,6,4,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\"]'),(37,5,32,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(38,7,16,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\"]'),(39,9,17,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\"]'),(40,7,4,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(41,3,21,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(44,9,5,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(45,3,25,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(47,2,43,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(48,6,35,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(50,6,8,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(51,10,25,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(52,5,28,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(53,2,7,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(54,3,27,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\"]'),(55,6,17,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\"]'),(56,7,34,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(57,8,22,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(58,10,39,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(59,4,25,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\"]'),(60,5,15,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(61,4,35,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\"]'),(62,9,9,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(63,7,9,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(64,7,12,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(66,2,32,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(67,8,30,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(68,1,1,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\"]'),(69,9,16,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(70,10,14,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(71,5,42,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(73,7,25,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\"]'),(74,6,3,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\"]'),(76,10,28,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\"]'),(77,1,28,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(78,8,23,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(79,4,1,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(80,4,42,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(81,6,36,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(82,4,36,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-20.jpg\"]'),(83,3,41,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\"]'),(84,3,22,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\"]'),(85,10,20,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(86,8,17,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\"]'),(87,3,19,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(88,1,13,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\"]'),(89,10,43,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(90,10,29,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\"]'),(91,4,11,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(92,3,14,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(93,10,26,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(94,7,24,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\"]'),(95,1,16,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(96,1,40,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\"]'),(97,5,4,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(98,1,36,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(99,8,20,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(100,3,3,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(101,7,41,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(104,8,9,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(105,8,5,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\"]'),(106,9,38,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(107,10,4,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(111,10,33,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(113,4,17,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\"]'),(114,7,8,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(115,1,35,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(117,5,12,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(118,5,41,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(119,2,25,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(121,8,36,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(122,7,17,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(123,6,15,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\"]'),(124,8,34,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\"]'),(127,3,9,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(128,8,7,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(129,6,24,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\"]'),(130,7,43,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(132,9,25,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\"]'),(134,2,28,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(135,6,40,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\"]'),(136,10,27,5.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(137,4,7,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(138,4,21,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\"]'),(139,2,26,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\"]'),(140,9,19,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(141,7,39,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(143,2,23,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(145,6,22,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\"]'),(146,7,20,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(147,9,31,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(148,7,38,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(149,1,10,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\"]'),(153,9,4,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(154,5,17,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(156,2,17,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\"]'),(163,9,2,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(164,2,33,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(165,10,12,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(166,1,43,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(167,3,15,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(168,4,34,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(169,1,25,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-18.jpg\"]'),(171,9,12,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(172,8,43,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(173,6,29,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\"]'),(175,9,13,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(177,2,18,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(179,4,14,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\"]'),(180,8,25,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]'),(181,1,22,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(182,1,9,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(183,8,41,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-20.jpg\"]'),(185,6,10,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(189,5,43,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(192,9,3,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(193,1,11,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(196,1,8,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\"]'),(197,1,21,5.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(198,4,30,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\"]'),(200,6,9,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(202,8,8,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\"]'),(203,3,30,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(204,7,23,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(206,5,10,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(208,9,20,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\"]'),(209,8,11,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(210,5,27,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(211,10,37,5.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(212,1,2,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(215,9,32,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(216,4,26,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(217,5,23,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(219,8,33,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(220,7,13,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\"]'),(221,7,28,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\"]'),(222,7,27,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(224,10,7,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(225,4,32,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(226,5,13,2.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\"]'),(229,7,14,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\"]'),(230,9,11,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(231,6,2,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\"]'),(232,6,38,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(234,5,31,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(235,5,33,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\"]'),(237,7,5,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\"]'),(238,9,42,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(240,6,42,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\"]'),(241,10,36,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(245,1,33,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-20.jpg\"]'),(246,7,26,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(247,5,3,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(250,1,23,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(251,8,31,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(253,3,32,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(254,1,17,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(255,7,31,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(256,2,19,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\"]'),(257,3,26,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(258,10,34,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(260,5,1,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(262,4,22,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\"]'),(264,5,37,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(265,1,32,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]'),(266,2,29,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(267,3,8,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(268,9,30,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(269,6,6,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(270,3,1,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(271,3,5,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(273,2,2,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(274,3,24,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\"]'),(275,10,16,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(276,6,25,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(277,8,16,1.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(280,4,40,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(281,2,38,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(283,10,18,2.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\"]'),(284,3,4,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\"]'),(287,2,1,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\"]'),(288,1,26,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(290,5,20,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\"]'),(292,5,38,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(294,10,35,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\"]'),(295,6,28,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(297,4,41,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\"]'),(299,3,18,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(301,5,18,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(303,2,41,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(305,9,15,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(306,4,4,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(310,3,42,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\"]'),(311,3,39,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\"]'),(312,8,6,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(314,6,30,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\"]'),(315,8,40,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\"]'),(316,8,13,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(317,2,35,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(319,5,22,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\"]'),(323,1,24,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\"]'),(324,6,31,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\"]'),(325,9,37,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(328,7,19,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(330,2,9,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(332,6,11,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(334,6,1,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\"]'),(336,10,8,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(338,8,37,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(339,8,35,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(340,2,11,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\"]'),(341,5,6,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(342,8,29,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(344,6,23,4.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(348,1,7,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\"]'),(349,6,14,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(350,3,16,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(351,10,41,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(352,2,10,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(354,8,18,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\"]'),(355,5,35,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(360,2,27,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(361,3,29,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\"]'),(362,7,10,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(367,2,36,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(368,6,12,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(373,10,30,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(377,5,39,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\"]'),(378,9,35,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(379,8,38,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]'),(383,8,24,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\"]'),(387,3,17,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-20.jpg\"]'),(390,9,7,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\"]'),(392,3,33,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\"]'),(393,5,36,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(394,2,24,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\"]'),(395,10,5,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-18.jpg\"]'),(401,6,37,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(405,5,21,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(410,9,36,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\"]'),(411,10,13,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\"]'),(413,4,20,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(414,6,43,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(416,10,23,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\"]'),(417,10,15,2.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\"]'),(418,8,12,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(421,6,39,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\"]'),(422,2,12,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\"]'),(423,10,21,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(425,2,6,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(426,6,27,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\"]'),(429,1,38,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(431,6,20,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\"]'),(432,7,7,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-17.jpg\"]'),(439,9,33,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(442,5,34,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(443,2,5,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(446,3,23,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(455,10,42,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\"]'),(456,2,31,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(457,5,2,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(459,4,23,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(466,4,29,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(476,7,29,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(477,9,10,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(481,5,14,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(483,6,16,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(491,1,30,4.00,'Clean & perfect source code','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(497,2,20,2.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\"]'),(502,3,6,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\"]'),(504,4,37,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\"]'),(510,2,39,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(517,9,23,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\"]'),(527,4,5,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(528,2,8,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\"]'),(533,9,41,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(535,3,38,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(538,4,33,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(540,2,15,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(541,3,10,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(545,4,16,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(547,4,43,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\"]'),(558,5,25,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(559,5,30,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(560,4,13,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(562,5,5,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\"]'),(567,5,19,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(570,7,21,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\"]'),(578,3,11,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(580,10,38,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(587,5,40,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\"]'),(590,1,5,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-17.jpg\"]'),(597,2,37,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]'),(599,8,39,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(604,8,21,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(606,1,37,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(613,7,40,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-9.jpg\"]'),(640,4,15,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(654,1,12,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\"]'),(656,1,3,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-20.jpg\"]'),(659,9,14,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(669,9,26,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(670,9,43,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(677,2,14,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(679,1,31,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(680,6,5,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(688,10,40,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(689,8,2,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\"]'),(694,2,3,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\"]'),(703,8,14,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(712,1,19,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\"]'),(714,8,19,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(730,1,34,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(735,6,18,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\"]'),(744,3,37,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(763,7,33,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(764,6,34,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(769,4,39,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\"]'),(774,7,37,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(778,9,21,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-20.jpg\"]'),(787,2,34,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\"]'),(790,5,26,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\"]'),(799,6,41,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(800,7,32,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(807,9,1,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(812,2,42,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(814,4,10,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(828,6,32,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\"]'),(829,10,22,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(837,3,31,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(845,7,22,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(855,8,32,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(868,7,30,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(906,10,31,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(907,6,26,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(910,1,15,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(915,8,1,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(916,3,12,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\"]'),(919,10,9,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-8.jpg\"]'),(924,8,26,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(928,4,8,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\"]'),(930,1,41,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\"]'),(932,1,42,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(935,9,8,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(937,3,35,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(942,3,36,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-20.jpg\"]'),(962,4,27,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(995,5,16,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:56:32','2024-03-05 00:56:32','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,1,'2024-02-29 00:56:10','2024-02-29 00:56:10','Botble\\ACL\\Models\\User'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,1,'2024-03-03 08:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(3,'create_from_order','Shipping was created from order %order_id%',0,2,2,'2024-02-29 00:56:10','2024-02-29 00:56:10','Botble\\ACL\\Models\\User'),(4,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,2,'2024-03-03 08:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(5,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,2,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(6,'create_from_order','Shipping was created from order %order_id%',0,3,3,'2024-02-26 02:56:10','2024-02-26 02:56:10','Botble\\ACL\\Models\\User'),(7,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,3,'2024-03-03 10:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(8,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,3,3,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(9,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,3,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(10,'create_from_order','Shipping was created from order %order_id%',0,4,4,'2024-02-27 16:56:10','2024-02-27 16:56:10','Botble\\ACL\\Models\\User'),(11,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,4,'2024-03-03 10:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(12,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,4,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\ACL\\Models\\User'),(13,'create_from_order','Shipping was created from order %order_id%',0,5,5,'2024-02-18 04:56:10','2024-02-18 04:56:10','Botble\\ACL\\Models\\User'),(14,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,5,'2024-03-03 10:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(15,'create_from_order','Shipping was created from order %order_id%',0,6,6,'2024-02-22 00:56:11','2024-02-22 00:56:11','Botble\\ACL\\Models\\User'),(16,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,6,'2024-03-03 12:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(17,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,6,6,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(18,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,6,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(19,'create_from_order','Shipping was created from order %order_id%',0,7,7,'2024-02-29 12:56:11','2024-02-29 12:56:11','Botble\\ACL\\Models\\User'),(20,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,7,'2024-03-03 12:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(21,'create_from_order','Shipping was created from order %order_id%',0,8,8,'2024-03-03 12:56:11','2024-03-03 12:56:11','Botble\\ACL\\Models\\User'),(22,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,8,'2024-03-03 12:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(23,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,8,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(24,'create_from_order','Shipping was created from order %order_id%',0,9,9,'2024-02-29 18:56:11','2024-02-29 18:56:11','Botble\\ACL\\Models\\User'),(25,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,9,'2024-03-03 14:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(26,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,9,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\ACL\\Models\\User'),(27,'create_from_order','Shipping was created from order %order_id%',0,10,10,'2024-02-28 08:56:11','2024-02-28 08:56:11','Botble\\ACL\\Models\\User'),(28,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,10,'2024-03-03 14:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(29,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,10,10,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(30,'create_from_order','Shipping was created from order %order_id%',0,11,11,'2024-02-29 18:56:12','2024-02-29 18:56:12','Botble\\ACL\\Models\\User'),(31,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,11,'2024-03-03 14:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(32,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,11,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(33,'create_from_order','Shipping was created from order %order_id%',0,12,13,'2024-03-03 16:56:12','2024-03-03 16:56:12','Botble\\ACL\\Models\\User'),(34,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,13,'2024-03-03 16:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(35,'create_from_order','Shipping was created from order %order_id%',0,13,14,'2024-02-23 08:56:12','2024-02-23 08:56:12','Botble\\ACL\\Models\\User'),(36,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,14,'2024-03-03 16:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(37,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,14,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(38,'create_from_order','Shipping was created from order %order_id%',0,14,15,'2024-02-27 18:56:12','2024-02-27 18:56:12','Botble\\ACL\\Models\\User'),(39,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,15,'2024-03-03 18:56:12','2024-03-05 00:56:12','Botble\\ACL\\Models\\User'),(40,'create_from_order','Shipping was created from order %order_id%',0,15,16,'2024-02-26 12:56:12','2024-02-26 12:56:12','Botble\\ACL\\Models\\User'),(41,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,16,'2024-03-03 18:56:13','2024-03-05 00:56:13','Botble\\ACL\\Models\\User'),(42,'create_from_order','Shipping was created from order %order_id%',0,16,18,'2024-03-03 20:56:13','2024-03-03 20:56:13','Botble\\ACL\\Models\\User'),(43,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,18,'2024-03-03 20:56:13','2024-03-05 00:56:13','Botble\\ACL\\Models\\User'),(44,'create_from_order','Shipping was created from order %order_id%',0,17,19,'2024-02-29 16:56:13','2024-02-29 16:56:13','Botble\\ACL\\Models\\User'),(45,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,19,'2024-03-03 22:56:13','2024-03-05 00:56:13','Botble\\ACL\\Models\\User'),(46,'create_from_order','Shipping was created from order %order_id%',0,18,20,'2024-02-25 08:56:13','2024-02-25 08:56:13','Botble\\ACL\\Models\\User'),(47,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,20,'2024-03-03 22:56:13','2024-03-05 00:56:13','Botble\\ACL\\Models\\User'),(48,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,20,'2024-03-05 00:56:13','2024-03-05 00:56:13','Botble\\ACL\\Models\\User'),(49,'create_from_order','Shipping was created from order %order_id%',0,19,22,'2024-02-24 00:56:14','2024-02-24 00:56:14','Botble\\ACL\\Models\\User'),(50,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,22,'2024-03-04 00:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(51,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,19,22,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(52,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,22,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(53,'create_from_order','Shipping was created from order %order_id%',0,20,23,'2024-02-26 00:56:14','2024-02-26 00:56:14','Botble\\ACL\\Models\\User'),(54,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,23,'2024-03-04 00:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(55,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,20,23,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(56,'create_from_order','Shipping was created from order %order_id%',0,21,24,'2024-02-25 18:56:14','2024-02-25 18:56:14','Botble\\ACL\\Models\\User'),(57,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,24,'2024-03-04 02:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(58,'create_from_order','Shipping was created from order %order_id%',0,22,25,'2024-02-24 20:56:14','2024-02-24 20:56:14','Botble\\ACL\\Models\\User'),(59,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,25,'2024-03-04 02:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(60,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,22,25,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(61,'create_from_order','Shipping was created from order %order_id%',0,23,26,'2024-02-25 16:56:14','2024-02-25 16:56:14','Botble\\ACL\\Models\\User'),(62,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,26,'2024-03-04 04:56:14','2024-03-05 00:56:14','Botble\\ACL\\Models\\User'),(63,'create_from_order','Shipping was created from order %order_id%',0,24,30,'2024-03-01 06:56:15','2024-03-01 06:56:15','Botble\\ACL\\Models\\User'),(64,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,30,'2024-03-04 06:56:15','2024-03-05 00:56:15','Botble\\ACL\\Models\\User'),(65,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,30,'2024-03-05 00:56:15','2024-03-05 00:56:15','Botble\\ACL\\Models\\User'),(66,'create_from_order','Shipping was created from order %order_id%',0,25,33,'2024-02-29 08:56:16','2024-02-29 08:56:16','Botble\\ACL\\Models\\User'),(67,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,33,'2024-03-04 08:56:16','2024-03-05 00:56:16','Botble\\ACL\\Models\\User'),(68,'create_from_order','Shipping was created from order %order_id%',0,26,34,'2024-02-28 00:56:16','2024-02-28 00:56:16','Botble\\ACL\\Models\\User'),(69,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,34,'2024-03-04 08:56:16','2024-03-05 00:56:16','Botble\\ACL\\Models\\User'),(70,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,26,34,'2024-03-05 00:56:16','2024-03-05 00:56:16','Botble\\ACL\\Models\\User'),(71,'create_from_order','Shipping was created from order %order_id%',0,27,37,'2024-03-01 12:56:16','2024-03-01 12:56:16','Botble\\ACL\\Models\\User'),(72,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,37,'2024-03-04 12:56:16','2024-03-05 00:56:16','Botble\\ACL\\Models\\User'),(73,'create_from_order','Shipping was created from order %order_id%',0,28,38,'2024-03-02 00:56:16','2024-03-02 00:56:16','Botble\\ACL\\Models\\User'),(74,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,38,'2024-03-04 12:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(75,'create_from_order','Shipping was created from order %order_id%',0,29,40,'2024-03-04 00:56:17','2024-03-04 00:56:17','Botble\\ACL\\Models\\User'),(76,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,40,'2024-03-04 12:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(77,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,40,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(78,'create_from_order','Shipping was created from order %order_id%',0,30,41,'2024-03-02 12:56:17','2024-03-02 12:56:17','Botble\\ACL\\Models\\User'),(79,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,41,'2024-03-04 14:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(80,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,41,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(81,'create_from_order','Shipping was created from order %order_id%',0,31,42,'2024-03-03 18:56:17','2024-03-03 18:56:17','Botble\\ACL\\Models\\User'),(82,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,42,'2024-03-04 14:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(83,'create_from_order','Shipping was created from order %order_id%',0,32,43,'2024-02-29 20:56:17','2024-02-29 20:56:17','Botble\\ACL\\Models\\User'),(84,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,43,'2024-03-04 14:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(85,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,43,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\ACL\\Models\\User'),(86,'create_from_order','Shipping was created from order %order_id%',0,33,45,'2024-03-03 00:56:18','2024-03-03 00:56:18','Botble\\ACL\\Models\\User'),(87,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,45,'2024-03-04 16:56:18','2024-03-05 00:56:18','Botble\\ACL\\Models\\User'),(88,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,33,45,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\ACL\\Models\\User'),(89,'create_from_order','Shipping was created from order %order_id%',0,34,47,'2024-03-03 12:56:18','2024-03-03 12:56:18','Botble\\ACL\\Models\\User'),(90,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,47,'2024-03-04 18:56:18','2024-03-05 00:56:18','Botble\\ACL\\Models\\User'),(91,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,34,47,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\ACL\\Models\\User'),(92,'create_from_order','Shipping was created from order %order_id%',0,35,48,'2024-03-03 20:56:18','2024-03-03 20:56:18','Botble\\ACL\\Models\\User'),(93,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,48,'2024-03-04 20:56:18','2024-03-05 00:56:18','Botble\\ACL\\Models\\User'),(94,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,35,48,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\ACL\\Models\\User'),(95,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,48,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\ACL\\Models\\User'),(96,'create_from_order','Shipping was created from order %order_id%',0,36,49,'2024-03-04 14:56:18','2024-03-04 14:56:18','Botble\\ACL\\Models\\User'),(97,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,49,'2024-03-04 22:56:19','2024-03-05 00:56:19','Botble\\ACL\\Models\\User'),(98,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,49,'2024-03-05 00:56:19','2024-03-05 00:56:19','Botble\\ACL\\Models\\User'),(99,'create_from_order','Shipping was created from order %order_id%',0,37,51,'2024-03-04 04:56:19','2024-03-04 04:56:19','Botble\\ACL\\Models\\User'),(100,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,51,'2024-03-04 22:56:19','2024-03-05 00:56:19','Botble\\ACL\\Models\\User');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,1,NULL,670.00,NULL,NULL,'','approved',2431.00,'pending','pending',0.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','JJD0024103475','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:10',NULL,NULL,NULL),(2,2,NULL,804.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','JJD0015147128','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:10','2024-03-05 07:56:10',NULL,NULL),(3,3,NULL,3072.00,NULL,NULL,'','delivered',7666.00,'completed','pending',0.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','JJD0068840166','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:10','2024-03-05 07:56:10',NULL,NULL),(4,4,NULL,648.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:10','2024-03-05 00:56:10','JJD0094624610','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:10','2024-03-05 07:56:10',NULL,NULL),(5,5,NULL,1726.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','JJD0096900835','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:11',NULL,NULL,NULL),(6,6,NULL,672.00,NULL,NULL,'','delivered',908.00,'completed','pending',0.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','JJD0060072799','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:11','2024-03-05 07:56:11',NULL,NULL),(7,7,NULL,1388.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','JJD0089694411','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-10 07:56:11',NULL,NULL,NULL),(8,8,NULL,2004.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','JJD0085027346','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:11','2024-03-05 07:56:11',NULL,NULL),(9,9,NULL,1756.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','JJD0049883733','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:56:11','2024-03-05 07:56:11',NULL,NULL),(10,10,NULL,722.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:11','2024-03-05 00:56:11','JJD0054461574','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:56:11','2024-03-05 07:56:11',NULL,NULL),(11,11,NULL,863.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','JJD0034386649','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:12','2024-03-05 07:56:12',NULL,NULL),(12,13,NULL,1503.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','JJD0085092742','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:56:12',NULL,NULL,NULL),(13,14,NULL,1668.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','JJD0099371056','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:56:12','2024-03-05 07:56:12',NULL,NULL),(14,15,NULL,1944.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:12','2024-03-05 00:56:12','JJD0044945628','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:56:12',NULL,NULL,NULL),(15,16,NULL,2511.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','JJD0011361349','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:13',NULL,NULL,NULL),(16,18,NULL,804.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','JJD0056749489','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:56:13',NULL,NULL,NULL),(17,19,NULL,3530.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','JJD008134965','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:56:13',NULL,NULL,NULL),(18,20,NULL,541.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:13','2024-03-05 00:56:13','JJD0098723990','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:56:13','2024-03-05 07:56:13',NULL,NULL),(19,22,NULL,2634.00,NULL,NULL,'','delivered',2148.00,'completed','pending',0.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','JJD0038824799','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:14','2024-03-05 07:56:14',NULL,NULL),(20,23,NULL,1713.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','JJD0043325793','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:14','2024-03-05 07:56:14',NULL,NULL),(21,24,NULL,1564.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','JJD0010914713','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:14',NULL,NULL,NULL),(22,25,NULL,694.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','JJD0067910891','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:56:14','2024-03-05 07:56:14',NULL,NULL),(23,26,NULL,2346.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:14','2024-03-05 00:56:14','JJD0021151699','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:56:14',NULL,NULL,NULL),(24,30,NULL,1082.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:15','2024-03-05 00:56:15','JJD0059074338','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:15','2024-03-05 07:56:15',NULL,NULL),(25,33,NULL,1503.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','JJD0088119213','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:56:16',NULL,NULL,NULL),(26,34,NULL,1668.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','JJD0053944682','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:56:16','2024-03-05 07:56:16',NULL,NULL),(27,37,NULL,1756.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:16','2024-03-05 00:56:16','JJD0074031584','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:16',NULL,NULL,NULL),(28,38,NULL,1344.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','JJD0090190634','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:56:17',NULL,NULL,NULL),(29,40,NULL,527.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','JJD009402150','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:56:17','2024-03-05 07:56:17',NULL,NULL),(30,41,NULL,2308.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','JJD0023662608','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:17','2024-03-05 07:56:17',NULL,NULL),(31,42,NULL,2082.00,NULL,NULL,'','approved',2400.00,'pending','pending',0.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','JJD0096672784','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:56:17',NULL,NULL,NULL),(32,43,NULL,602.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:17','2024-03-05 00:56:17','JJD0058788297','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:17','2024-03-05 07:56:17',NULL,NULL),(33,45,NULL,668.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','JJD0094386484','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-10 07:56:18','2024-03-05 07:56:18',NULL,NULL),(34,47,NULL,691.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','JJD0074390136','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:56:18','2024-03-05 07:56:18',NULL,NULL),(35,48,NULL,3168.00,NULL,NULL,'','delivered',6624.00,'completed','pending',0.00,0,'2024-03-05 00:56:18','2024-03-05 00:56:18','JJD0053765322','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:18','2024-03-05 07:56:18',NULL,NULL),(36,49,NULL,804.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:19','2024-03-05 00:56:19','JJD0028847063','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:56:19','2024-03-05 07:56:19',NULL,NULL),(37,51,NULL,2334.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:56:19','2024-03-05 00:56:19','JJD0035274456','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:56:19',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2024-03-05 00:55:59','2024-03-05 00:55:59');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',0.00,NULL,0.00,'2024-03-05 00:55:59','2024-03-05 00:55:59');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Shofy','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2024-03-05 00:56:01','2024-03-05 00:56:01');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,2),(1,4),(1,10),(1,15),(1,16),(1,19),(1,20),(1,21),(1,22),(1,24),(1,35),(1,36),(1,37),(1,39),(1,41),(1,42),(2,1),(2,3),(2,5),(2,7),(2,23),(2,28),(2,30),(2,33),(2,40),(2,43),(3,6),(3,8),(3,9),(3,11),(3,12),(3,13),(3,14),(3,17),(3,18),(3,25),(3,26),(3,27),(3,29),(3,31),(3,32),(3,34),(3,38);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2024-03-05 00:55:59','2024-03-05 00:55:59'),(2,'None',0.000000,2,'published','2024-03-05 00:55:59','2024-03-05 00:55:59'),(3,'Import Tax',15.000000,3,'published','2024-03-05 00:55:59','2024-03-05 00:55:59');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(2,'PAYMENT',1,'published','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(3,'ORDER &amp; RETURNS',2,'published','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2024-03-05 00:55:56','2024-03-05 00:55:56'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2024-03-05 00:55:56','2024-03-05 00:55:56');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Perfect','I think that proved it at all; however, she waited patiently. \'Once,\' said the last words out loud, and the words all coming different, and then turned to the shore, and then the puppy began a.',1,0,'fashion/galleries/1.jpg',1,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(2,'New Day','I COULD NOT SWIM--\" you can\'t take more.\' \'You mean you can\'t swim, can you?\' he added, turning to Alice, \'Have you seen the Mock Turtle. \'Very much indeed,\' said Alice. \'Well, I should think you\'ll.',1,0,'fashion/galleries/2.jpg',1,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(3,'Happy Day','The baby grunted again, and went on again:-- \'You may not have lived much under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you haven\'t found it so VERY remarkable in that; nor did Alice.',1,0,'fashion/galleries/3.jpg',1,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(4,'Nature','I said \"What for?\"\' \'She boxed the Queen\'s shrill cries to the heads of the pack, she could do to ask: perhaps I shall be punished for it now, I suppose, by being drowned in my time, but never ONE.',1,0,'fashion/galleries/4.jpg',1,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(5,'Morning','English, who wanted leaders, and had just upset the milk-jug into his plate. Alice did not sneeze, were the two creatures, who had spoken first. \'That\'s none of YOUR adventures.\' \'I could tell you.',1,0,'fashion/galleries/5.jpg',1,'published','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"I have to whisper a hint to Time, and round Alice, every now and then all the unjust things--\' when his eye chanced to fall a long time with one eye; \'I seem to be\\\"--or if you\'d like it very much,\'.\"},{\"img\":\"fashion\\/galleries\\/5.jpg\",\"description\":\"But if I\'m not the right size, that it was too dark to see if she meant to take out of their hearing her; and the roof of the reeds--the rattling teacups would change (she knew) to the other side of.\"},{\"img\":\"fashion\\/galleries\\/3.jpg\",\"description\":\"Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon hastily. \'Go on with the time,\' she said, \'for her hair goes in such a very little way off, and that makes them so shiny?\' Alice looked all.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"I\'ll go round a deal faster than it does.\' \'Which would NOT be an old conger-eel, that used to call him Tortoise--\' \'Why did you do lessons?\' said Alice, who felt very glad she had hoped) a fan and.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:09','2024-03-05 00:56:09'),(2,'[{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"I have to whisper a hint to Time, and round Alice, every now and then all the unjust things--\' when his eye chanced to fall a long time with one eye; \'I seem to be\\\"--or if you\'d like it very much,\'.\"},{\"img\":\"fashion\\/galleries\\/5.jpg\",\"description\":\"But if I\'m not the right size, that it was too dark to see if she meant to take out of their hearing her; and the roof of the reeds--the rattling teacups would change (she knew) to the other side of.\"},{\"img\":\"fashion\\/galleries\\/3.jpg\",\"description\":\"Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon hastily. \'Go on with the time,\' she said, \'for her hair goes in such a very little way off, and that makes them so shiny?\' Alice looked all.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"I\'ll go round a deal faster than it does.\' \'Which would NOT be an old conger-eel, that used to call him Tortoise--\' \'Why did you do lessons?\' said Alice, who felt very glad she had hoped) a fan and.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:09','2024-03-05 00:56:09'),(3,'[{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"I have to whisper a hint to Time, and round Alice, every now and then all the unjust things--\' when his eye chanced to fall a long time with one eye; \'I seem to be\\\"--or if you\'d like it very much,\'.\"},{\"img\":\"fashion\\/galleries\\/5.jpg\",\"description\":\"But if I\'m not the right size, that it was too dark to see if she meant to take out of their hearing her; and the roof of the reeds--the rattling teacups would change (she knew) to the other side of.\"},{\"img\":\"fashion\\/galleries\\/3.jpg\",\"description\":\"Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon hastily. \'Go on with the time,\' she said, \'for her hair goes in such a very little way off, and that makes them so shiny?\' Alice looked all.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"I\'ll go round a deal faster than it does.\' \'Which would NOT be an old conger-eel, that used to call him Tortoise--\' \'Why did you do lessons?\' said Alice, who felt very glad she had hoped) a fan and.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:09','2024-03-05 00:56:09'),(4,'[{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"I have to whisper a hint to Time, and round Alice, every now and then all the unjust things--\' when his eye chanced to fall a long time with one eye; \'I seem to be\\\"--or if you\'d like it very much,\'.\"},{\"img\":\"fashion\\/galleries\\/5.jpg\",\"description\":\"But if I\'m not the right size, that it was too dark to see if she meant to take out of their hearing her; and the roof of the reeds--the rattling teacups would change (she knew) to the other side of.\"},{\"img\":\"fashion\\/galleries\\/3.jpg\",\"description\":\"Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon hastily. \'Go on with the time,\' she said, \'for her hair goes in such a very little way off, and that makes them so shiny?\' Alice looked all.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"I\'ll go round a deal faster than it does.\' \'Which would NOT be an old conger-eel, that used to call him Tortoise--\' \'Why did you do lessons?\' said Alice, who felt very glad she had hoped) a fan and.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:09','2024-03-05 00:56:09'),(5,'[{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"I have to whisper a hint to Time, and round Alice, every now and then all the unjust things--\' when his eye chanced to fall a long time with one eye; \'I seem to be\\\"--or if you\'d like it very much,\'.\"},{\"img\":\"fashion\\/galleries\\/5.jpg\",\"description\":\"But if I\'m not the right size, that it was too dark to see if she meant to take out of their hearing her; and the roof of the reeds--the rattling teacups would change (she knew) to the other side of.\"},{\"img\":\"fashion\\/galleries\\/3.jpg\",\"description\":\"Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon hastily. \'Go on with the time,\' she said, \'for her hair goes in such a very little way off, and that makes them so shiny?\' Alice looked all.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"I\'ll go round a deal faster than it does.\' \'Which would NOT be an old conger-eel, that used to call him Tortoise--\' \'Why did you do lessons?\' said Alice, who felt very glad she had hoped) a fan and.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','e12cb76fa1c96643f2607d7a43b2b20e',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','1f38f482b98b4e8c851ccc17ee946d2c',1,'Botble\\Menu\\Models\\MenuLocation'),(3,'en_US','8bca800fbeef0e1f8b81ae18c3c8954f',1,'Botble\\Menu\\Models\\Menu'),(4,'en_US','328a2638a9b7aa67632fd2ba3660afaf',2,'Botble\\Menu\\Models\\Menu'),(5,'en_US','1c372714cd1f0c59a34b23924b10f723',3,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'404','404',2,'image/png',15820,'main/general/404.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(2,0,'about-1','about-1',2,'image/jpeg',9222,'main/general/about-1.jpg','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(3,0,'about-2','about-2',2,'image/jpeg',5105,'main/general/about-2.jpg','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(4,0,'cta-shape-1','cta-shape-1',2,'image/png',22860,'main/general/cta-shape-1.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(5,0,'cta-shape-2','cta-shape-2',2,'image/png',16796,'main/general/cta-shape-2.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(6,0,'cta-thumb-1','cta-thumb-1',2,'image/jpeg',6053,'main/general/cta-thumb-1.jpg','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(7,0,'favicon','favicon',2,'image/png',1831,'main/general/favicon.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(8,0,'footer-pay','footer-pay',2,'image/png',490,'main/general/footer-pay.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(9,0,'logo-white','logo-white',2,'image/png',3793,'main/general/logo-white.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(10,0,'logo','logo',2,'image/png',4122,'main/general/logo.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(11,0,'preloader-icon','preloader-icon',2,'image/png',4182,'main/general/preloader-icon.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(12,0,'signature','signature',2,'image/png',2117,'main/general/signature.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(13,0,'slider-offer','slider-offer',2,'image/png',970,'main/general/slider-offer.png','[]','2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(24,0,'1','1',4,'image/jpeg',4294,'main/customers/1.jpg','[]','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(25,0,'10','10',4,'image/jpeg',4294,'main/customers/10.jpg','[]','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(26,0,'2','2',4,'image/jpeg',4294,'main/customers/2.jpg','[]','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(27,0,'3','3',4,'image/jpeg',4294,'main/customers/3.jpg','[]','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(28,0,'4','4',4,'image/jpeg',4294,'main/customers/4.jpg','[]','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(29,0,'5','5',4,'image/jpeg',4294,'main/customers/5.jpg','[]','2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(30,0,'6','6',4,'image/jpeg',4294,'main/customers/6.jpg','[]','2024-03-05 00:55:57','2024-03-05 00:55:57',NULL),(31,0,'7','7',4,'image/jpeg',4294,'main/customers/7.jpg','[]','2024-03-05 00:55:57','2024-03-05 00:55:57',NULL),(32,0,'8','8',4,'image/jpeg',4294,'main/customers/8.jpg','[]','2024-03-05 00:55:57','2024-03-05 00:55:57',NULL),(33,0,'9','9',4,'image/jpeg',4294,'main/customers/9.jpg','[]','2024-03-05 00:55:57','2024-03-05 00:55:57',NULL),(34,0,'blog-big-1','blog-big-1',5,'image/jpeg',13885,'main/blog/blog-big-1.jpg','[]','2024-03-05 00:55:59','2024-03-05 00:55:59',NULL),(35,0,'blog-details-sm-1','blog-details-sm-1',5,'image/jpeg',8166,'main/blog/blog-details-sm-1.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(36,0,'post-1','post-1',5,'image/jpeg',6189,'main/blog/post-1.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(37,0,'post-10','post-10',5,'image/jpeg',5907,'main/blog/post-10.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(38,0,'post-11','post-11',5,'image/jpeg',5907,'main/blog/post-11.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(39,0,'post-12','post-12',5,'image/jpeg',5907,'main/blog/post-12.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(40,0,'post-2','post-2',5,'image/jpeg',6189,'main/blog/post-2.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(41,0,'post-3','post-3',5,'image/jpeg',6189,'main/blog/post-3.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(42,0,'post-4','post-4',5,'image/jpeg',6045,'main/blog/post-4.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(43,0,'post-5','post-5',5,'image/jpeg',6045,'main/blog/post-5.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(44,0,'post-6','post-6',5,'image/jpeg',6045,'main/blog/post-6.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(45,0,'post-7','post-7',5,'image/jpeg',5907,'main/blog/post-7.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(46,0,'post-8','post-8',5,'image/jpeg',5907,'main/blog/post-8.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(47,0,'post-9','post-9',5,'image/jpeg',5907,'main/blog/post-9.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(48,0,'1','1',3,'image/jpeg',4068,'main/users/1.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(49,0,'10','10',3,'image/jpeg',7599,'main/users/10.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(50,0,'2','2',3,'image/jpeg',7599,'main/users/2.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(51,0,'3','3',3,'image/jpeg',6387,'main/users/3.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(52,0,'4','4',3,'image/jpeg',7599,'main/users/4.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(53,0,'5','5',3,'image/jpeg',6387,'main/users/5.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(54,0,'6','6',3,'image/jpeg',7599,'main/users/6.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(55,0,'7','7',3,'image/jpeg',6387,'main/users/7.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(56,0,'8','8',3,'image/jpeg',7599,'main/users/8.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(57,0,'9','9',3,'image/jpeg',6387,'main/users/9.jpg','[]','2024-03-05 00:56:00','2024-03-05 00:56:00',NULL),(58,0,'1','1',6,'image/png',9133,'main/stores/1.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(59,0,'10','10',6,'image/png',4263,'main/stores/10.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(60,0,'11','11',6,'image/png',4420,'main/stores/11.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(61,0,'12','12',6,'image/png',4908,'main/stores/12.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(62,0,'13','13',6,'image/png',3441,'main/stores/13.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(63,0,'14','14',6,'image/png',4209,'main/stores/14.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(64,0,'15','15',6,'image/png',5113,'main/stores/15.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(65,0,'16','16',6,'image/png',4563,'main/stores/16.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(66,0,'17','17',6,'image/png',4896,'main/stores/17.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(67,0,'2','2',6,'image/png',9008,'main/stores/2.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(68,0,'3','3',6,'image/png',8006,'main/stores/3.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(69,0,'4','4',6,'image/png',8728,'main/stores/4.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(70,0,'5','5',6,'image/png',10689,'main/stores/5.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(71,0,'6','6',6,'image/png',10989,'main/stores/6.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(72,0,'7','7',6,'image/png',3730,'main/stores/7.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(73,0,'8','8',6,'image/png',4030,'main/stores/8.png','[]','2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(74,0,'9','9',6,'image/png',3810,'main/stores/9.png','[]','2024-03-05 00:56:02','2024-03-05 00:56:02',NULL),(75,0,'cover-1','cover-1',6,'image/png',4208,'main/stores/cover-1.png','[]','2024-03-05 00:56:02','2024-03-05 00:56:02',NULL),(76,0,'cover-2','cover-2',6,'image/png',8798,'main/stores/cover-2.png','[]','2024-03-05 00:56:02','2024-03-05 00:56:02',NULL),(77,0,'cover-3','cover-3',6,'image/png',3888,'main/stores/cover-3.png','[]','2024-03-05 00:56:02','2024-03-05 00:56:02',NULL),(78,0,'cover-4','cover-4',6,'image/png',11893,'main/stores/cover-4.png','[]','2024-03-05 00:56:02','2024-03-05 00:56:02',NULL),(79,0,'cover-5','cover-5',6,'image/png',8798,'main/stores/cover-5.png','[]','2024-03-05 00:56:02','2024-03-05 00:56:02',NULL),(80,0,'shape-1','shape-1',8,'image/png',1842,'fashion/sliders/shape-1.png','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(81,0,'shape-2','shape-2',8,'image/png',489,'fashion/sliders/shape-2.png','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(82,0,'shape-3','shape-3',8,'image/png',221,'fashion/sliders/shape-3.png','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(83,0,'slider-1','slider-1',8,'image/png',10444,'fashion/sliders/slider-1.png','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(84,0,'slider-2','slider-2',8,'image/png',9843,'fashion/sliders/slider-2.png','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(85,0,'slider-3','slider-3',8,'image/png',11768,'fashion/sliders/slider-3.png','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(86,0,'1','1',9,'image/jpeg',4294,'fashion/product-categories/1.jpg','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(87,0,'2','2',9,'image/jpeg',4294,'fashion/product-categories/2.jpg','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(88,0,'3','3',9,'image/jpeg',4294,'fashion/product-categories/3.jpg','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(89,0,'4','4',9,'image/jpeg',4294,'fashion/product-categories/4.jpg','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(90,0,'5','5',9,'image/jpeg',4294,'fashion/product-categories/5.jpg','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(91,0,'6','6',9,'image/jpeg',4294,'fashion/product-categories/6.jpg','[]','2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(92,0,'product-1','product-1',10,'image/png',9803,'fashion/products/product-1.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(93,0,'product-2','product-2',10,'image/png',9803,'fashion/products/product-2.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(94,0,'product-3','product-3',10,'image/png',9803,'fashion/products/product-3.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(95,0,'product-4','product-4',10,'image/png',9803,'fashion/products/product-4.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(96,0,'product-5','product-5',10,'image/png',9803,'fashion/products/product-5.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(97,0,'product-6','product-6',10,'image/png',9803,'fashion/products/product-6.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(98,0,'product-7','product-7',10,'image/png',9803,'fashion/products/product-7.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(99,0,'product-8','product-8',10,'image/png',9803,'fashion/products/product-8.png','[]','2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(100,0,'1','1',11,'image/jpeg',6309,'main/banners/1.jpg','[]','2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(101,0,'2','2',11,'image/jpeg',6275,'main/banners/2.jpg','[]','2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(102,0,'banner-1','banner-1',11,'image/png',18708,'main/banners/banner-1.png','[]','2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(103,0,'banner-2','banner-2',11,'image/png',24098,'main/banners/banner-2.png','[]','2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(104,0,'banner-3','banner-3',11,'image/png',24098,'main/banners/banner-3.png','[]','2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(105,0,'slider-1','slider-1',11,'image/png',8207,'main/banners/slider-1.png','[]','2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(106,0,'slider-2','slider-2',11,'image/png',7768,'main/banners/slider-2.png','[]','2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(107,0,'slider-3','slider-3',11,'image/png',6182,'main/banners/slider-3.png','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(108,0,'1','1',12,'image/jpeg',6287,'fashion/banners/1.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(109,0,'2','2',12,'image/jpeg',5975,'fashion/banners/2.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(110,0,'3','3',12,'image/jpeg',5975,'fashion/banners/3.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(111,0,'4','4',12,'image/jpeg',9052,'fashion/banners/4.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(112,0,'1','1',13,'image/jpeg',4294,'fashion/galleries/1.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(113,0,'2','2',13,'image/jpeg',4294,'fashion/galleries/2.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(114,0,'3','3',13,'image/jpeg',4294,'fashion/galleries/3.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(115,0,'4','4',13,'image/jpeg',4294,'fashion/galleries/4.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(116,0,'5','5',13,'image/jpeg',4294,'fashion/galleries/5.jpg','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(117,0,'icon-1','icon-1',14,'image/png',4469,'main/contact/icon-1.png','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(118,0,'icon-2','icon-2',14,'image/png',5977,'main/contact/icon-2.png','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(119,0,'icon-3','icon-3',14,'image/png',6082,'main/contact/icon-3.png','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(120,0,'line','line',15,'image/png',6152,'main/shapes/line.png','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(121,0,'quote','quote',15,'image/png',595,'main/shapes/quote.png','[]','2024-03-05 00:56:09','2024-03-05 00:56:09',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(2,0,'general',NULL,'general',1,'2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(3,0,'users',NULL,'users',1,'2024-03-05 00:55:55','2024-03-05 00:55:55',NULL),(4,0,'customers',NULL,'customers',1,'2024-03-05 00:55:56','2024-03-05 00:55:56',NULL),(5,0,'blog',NULL,'blog',1,'2024-03-05 00:55:59','2024-03-05 00:55:59',NULL),(6,0,'stores',NULL,'stores',1,'2024-03-05 00:56:01','2024-03-05 00:56:01',NULL),(7,0,'fashion',NULL,'fashion',0,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(8,0,'sliders',NULL,'sliders',7,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(9,0,'product-categories',NULL,'product-categories',7,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL),(10,0,'products',NULL,'products',7,'2024-03-05 00:56:05','2024-03-05 00:56:05',NULL),(11,0,'banners',NULL,'banners',1,'2024-03-05 00:56:08','2024-03-05 00:56:08',NULL),(12,0,'banners',NULL,'banners',7,'2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(13,0,'galleries',NULL,'galleries',7,'2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(14,0,'contact',NULL,'contact',1,'2024-03-05 00:56:09','2024-03-05 00:56:09',NULL),(15,0,'shapes',NULL,'shapes',1,'2024-03-05 00:56:09','2024-03-05 00:56:09',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,1,'Botble\\Page\\Models\\Page','/home',NULL,0,'Home',NULL,'_self',1,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(2,1,1,NULL,NULL,'https://shofy.botble.com',NULL,0,'Electronics',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(3,1,1,NULL,NULL,'https://shofy-fashion.botble.com',NULL,0,'Fashion',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(4,1,1,NULL,NULL,'https://shofy-beauty.botble.com',NULL,0,'Beauty',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(5,1,1,NULL,NULL,'https://shofy-jewelry.botble.com',NULL,0,'Jewelry',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(6,1,1,NULL,NULL,'https://shofy-grocery.botble.com',NULL,0,'Grocery',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(7,1,0,NULL,NULL,NULL,NULL,0,'Shop',NULL,'_self',1,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(8,1,7,2,'Botble\\Page\\Models\\Page','/product-categories',NULL,0,'Shop Categories',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,0,'Shop List',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(10,1,7,NULL,NULL,'/products?layout=grid',NULL,0,'Shop Grid',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(11,1,7,NULL,NULL,'/products/tailored-wool-blazer',NULL,0,'Product Detail',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(12,1,7,3,'Botble\\Page\\Models\\Page','/coupons',NULL,0,'Grab Coupons',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(13,1,7,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(14,1,7,NULL,NULL,'/compare',NULL,0,'Compare',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(15,1,7,NULL,NULL,'/wishlist',NULL,0,'Wishlist',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(16,1,7,NULL,NULL,'/orders/tracking',NULL,0,'Track Your Order',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(17,1,0,NULL,NULL,'/stores',NULL,0,'Vendors',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(18,1,0,NULL,NULL,NULL,NULL,0,'Pages',NULL,'_self',1,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(19,1,18,NULL,NULL,'/login',NULL,0,'Login',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(20,1,18,NULL,NULL,'/register',NULL,0,'Register',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(21,1,18,NULL,NULL,'/password/reset',NULL,0,'Forgot Password',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(22,1,18,NULL,NULL,'/404',NULL,0,'404 Error',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(23,1,0,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',1,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(24,1,23,NULL,NULL,'/blog?layout=grid',NULL,0,'Blog Grid',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(25,1,23,NULL,NULL,'/blog?layout=list',NULL,0,'Blog List',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(26,1,23,NULL,NULL,'/blog/heres-the-first-valentinos-new-makeup-collection',NULL,0,'Blog Detail',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(27,1,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(28,2,0,NULL,NULL,'/orders/tracking',NULL,1,'Track Orders',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(29,2,0,9,'Botble\\Page\\Models\\Page','/shipping',NULL,1,'Shipping',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(30,2,0,NULL,NULL,'/wishlist',NULL,1,'Wishlist',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(31,2,0,NULL,NULL,'/customer/overview',NULL,1,'My Account',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(32,2,0,NULL,NULL,'/customer/orders',NULL,1,'Order History',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(33,2,0,NULL,NULL,'/customer/order-returns',NULL,1,'Returns',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(34,3,0,7,'Botble\\Page\\Models\\Page','/our-story',NULL,2,'Our Story',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(35,3,0,8,'Botble\\Page\\Models\\Page','/careers',NULL,2,'Careers',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(36,3,0,6,'Botble\\Page\\Models\\Page','/cookie-policy',NULL,2,'Privacy Policy',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(37,3,0,NULL,NULL,'/blog',NULL,2,'Latest News',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09'),(38,3,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,2,'Contact Us',NULL,'_self',0,'2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(2,'My Account','my-account','published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(3,'Information','information','published','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'background','[\"main\\/stores\\/cover-1.png\"]',1,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(2,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',1,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(3,'background','[\"main\\/stores\\/cover-2.png\"]',2,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(4,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',2,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(5,'background','[\"main\\/stores\\/cover-5.png\"]',3,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(6,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',3,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(7,'background','[\"main\\/stores\\/cover-2.png\"]',4,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(8,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',4,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(9,'background','[\"main\\/stores\\/cover-5.png\"]',5,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(10,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',5,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(11,'background','[\"main\\/stores\\/cover-2.png\"]',6,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(12,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',6,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(13,'background','[\"main\\/stores\\/cover-5.png\"]',7,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(14,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',7,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(15,'background','[\"main\\/stores\\/cover-3.png\"]',8,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(16,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',8,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:56:04','2024-03-05 00:56:04'),(17,'button_label','[\"Shop Collection\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:56:04','2024-03-05 00:56:04'),(18,'button_label','[\"Shop Collection\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:56:04','2024-03-05 00:56:04'),(19,'button_label','[\"Shop Collection\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:56:04','2024-03-05 00:56:04'),(20,'faq_ids','[[2,3,4,5,10]]',1,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(21,'faq_ids','[[1,2,4,5,6]]',2,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(22,'faq_ids','[[2,5,8,9,10]]',3,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(23,'faq_ids','[[2,4,5,9,10]]',4,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(24,'faq_ids','[[1,5,6,7,9]]',5,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(25,'faq_ids','[[3,5,8,9,10]]',6,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(26,'faq_ids','[[3,4,5,8,10]]',7,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(27,'faq_ids','[[1,3,6,7,9]]',8,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(28,'faq_ids','[[2,3,5,7,8]]',9,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(29,'faq_ids','[[2,3,4,6,10]]',10,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(30,'faq_ids','[[4,6,7,8,10]]',11,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(31,'faq_ids','[[3,4,6,8,9]]',12,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(32,'faq_ids','[[1,2,4,6,9]]',13,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(33,'faq_ids','[[2,3,8,9,10]]',14,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(34,'faq_ids','[[1,2,3,4,5]]',15,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(35,'faq_ids','[[1,4,8,9,10]]',16,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(36,'faq_ids','[[1,2,4,5,7]]',17,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(37,'faq_ids','[[4,5,8,9,10]]',18,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(38,'faq_ids','[[2,4,5,9,10]]',19,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(39,'faq_ids','[[2,3,6,7,8]]',20,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(40,'faq_ids','[[1,5,6,7,10]]',21,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(41,'faq_ids','[[1,6,7,9,10]]',22,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(42,'faq_ids','[[1,2,4,6,8]]',23,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(43,'faq_ids','[[1,2,4,6,10]]',24,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(44,'faq_ids','[[3,5,6,7,10]]',25,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(45,'faq_ids','[[2,3,5,8,9]]',26,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(46,'faq_ids','[[2,4,6,8,9]]',27,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(47,'faq_ids','[[2,4,7,8,10]]',28,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(48,'faq_ids','[[3,4,5,9,10]]',29,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(49,'faq_ids','[[1,3,4,7,8]]',30,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(50,'faq_ids','[[5,7,8,9,10]]',31,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(51,'faq_ids','[[2,3,4,5,7]]',32,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(52,'faq_ids','[[3,4,8,9,10]]',33,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(53,'faq_ids','[[1,2,5,7,9]]',34,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(54,'faq_ids','[[1,4,5,7,9]]',35,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(55,'faq_ids','[[4,6,8,9,10]]',36,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(56,'faq_ids','[[5,6,7,9,10]]',37,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(57,'faq_ids','[[1,4,5,7,9]]',38,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(58,'faq_ids','[[2,3,4,6,8]]',39,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(59,'faq_ids','[[1,4,5,6,9]]',40,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(60,'faq_ids','[[1,4,6,8,10]]',41,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(61,'faq_ids','[[2,6,7,8,10]]',42,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:05','2024-03-05 00:56:05'),(62,'faq_ids','[[1,5,8,9,10]]',43,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:56:06','2024-03-05 00:56:06'),(63,'title','[\"Smartphone \\\\n BLU G91 Pro 2022\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(64,'subtitle','[\"Sale 20% off all store\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(65,'button_label','[\"Shop Now\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(66,'title','[\"HyperX Cloud II \\\\n Wireless\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(67,'subtitle','[\"Sale 35% off\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(68,'button_label','[\"Shop Now\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(69,'title','[\"T-Shirt Tunic \\n Tops Blouse\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(70,'button_label','[\"Shop Now\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(71,'title','[\"Satchel Tote \\n Crossbody Bags\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(72,'button_label','[\"Shop Now\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(73,'title','[\"Men\'s Tennis \\n Walking Shoes\"]',5,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(74,'button_label','[\"Shop Now\"]',5,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(75,'title','[\"Short Sleeve Tunic \\n Tops Casual Swing\"]',6,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(76,'button_label','[\"Explore More\"]',6,'Botble\\Ads\\Models\\Ads','2024-03-05 00:56:09','2024-03-05 00:56:09'),(77,'breadcrumb_style','[\"none\"]',1,'Botble\\Page\\Models\\Page','2024-03-05 00:56:09','2024-03-05 00:56:09'),(78,'breadcrumb_style','[\"align-start\"]',2,'Botble\\Page\\Models\\Page','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_reset_tokens_table',1),(5,'2015_06_18_033822_create_blog_table',1),(6,'2015_06_29_025744_create_audit_history',1),(7,'2016_05_28_112028_create_system_request_logs_table',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2020_03_05_041139_create_ecommerce_tables',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',1),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',1),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',1),(34,'2021_02_16_092633_remove_default_value_for_author_type',1),(35,'2021_02_18_073505_update_table_ec_reviews',1),(36,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',1),(37,'2021_03_10_025153_change_column_tax_amount',1),(38,'2021_03_20_033103_add_column_availability_to_table_ec_products',1),(39,'2021_03_27_144913_add_customer_type_into_table_payments',1),(40,'2021_04_28_074008_ecommerce_create_product_label_table',1),(41,'2021_05_24_034720_make_column_currency_nullable',1),(42,'2021_05_31_173037_ecommerce_create_ec_products_translations',1),(43,'2021_07_06_030002_create_marketplace_table',1),(44,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(45,'2021_08_17_105016_remove_column_currency_id_in_some_tables',1),(46,'2021_08_30_142128_add_images_column_to_ec_reviews_table',1),(47,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',1),(48,'2021_10_04_030050_add_column_created_by_to_table_ec_products',1),(49,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',1),(50,'2021_10_05_122616_add_status_column_to_ec_customers_table',1),(51,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',1),(52,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',1),(53,'2021_10_19_020859_update_metadata_field',1),(54,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(55,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',1),(56,'2021_11_23_071403_correct_languages_for_product_variations',1),(57,'2021_11_28_031808_add_product_tags_translations',1),(58,'2021_12_01_031123_add_featured_image_to_ec_products',1),(59,'2021_12_02_035301_add_ads_translations_table',1),(60,'2021_12_03_030600_create_blog_translations',1),(61,'2021_12_03_075608_create_page_translations',1),(62,'2021_12_03_082134_create_faq_translations',1),(63,'2021_12_03_082953_create_gallery_translations',1),(64,'2021_12_03_083642_create_testimonials_translations',1),(65,'2021_12_03_084118_create_location_translations',1),(66,'2021_12_03_094518_migrate_old_location_data',1),(67,'2021_12_06_031304_update_table_mp_customer_revenues',1),(68,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(69,'2022_01_01_033107_update_table_ec_shipments',1),(70,'2022_01_16_085908_improve_plugin_location',1),(71,'2022_02_16_042457_improve_product_attribute_sets',1),(72,'2022_03_22_075758_correct_product_name',1),(73,'2022_04_19_113334_add_index_to_ec_products',1),(74,'2022_04_19_113923_add_index_to_table_posts',1),(75,'2022_04_20_100851_add_index_to_media_table',1),(76,'2022_04_20_101046_add_index_to_menu_table',1),(77,'2022_04_28_144405_remove_unused_table',1),(78,'2022_04_30_034048_create_gallery_meta_translations_table',1),(79,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',1),(80,'2022_05_18_143720_add_index_to_table_ec_product_categories',1),(81,'2022_06_16_095633_add_index_to_some_tables',1),(82,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(83,'2022_06_30_035148_create_order_referrals_table',1),(84,'2022_07_07_153354_update_charge_id_in_table_payments',1),(85,'2022_07_10_034813_move_lang_folder_to_root',1),(86,'2022_07_24_153815_add_completed_at_to_ec_orders_table',1),(87,'2022_08_04_051940_add_missing_column_expires_at',1),(88,'2022_08_04_052122_delete_location_backup_tables',1),(89,'2022_08_14_032836_create_ec_order_returns_table',1),(90,'2022_08_14_033554_create_ec_order_return_items_table',1),(91,'2022_08_15_040324_add_billing_address',1),(92,'2022_08_30_091114_support_digital_products_table',1),(93,'2022_09_01_000001_create_admin_notifications_tables',1),(94,'2022_09_13_095744_create_options_table',1),(95,'2022_09_13_104347_create_option_value_table',1),(96,'2022_10_05_163518_alter_table_ec_order_product',1),(97,'2022_10_12_041517_create_invoices_table',1),(98,'2022_10_12_142226_update_orders_table',1),(99,'2022_10_13_024916_update_table_order_returns',1),(100,'2022_10_14_024629_drop_column_is_featured',1),(101,'2022_10_19_152916_add_columns_to_mp_stores_table',1),(102,'2022_10_20_062849_create_mp_category_sale_commissions_table',1),(103,'2022_10_21_030830_update_columns_in_ec_shipments_table',1),(104,'2022_10_28_021046_update_columns_in_ec_shipments_table',1),(105,'2022_11_02_071413_add_more_info_for_store',1),(106,'2022_11_02_080444_add_tax_info',1),(107,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',1),(108,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(109,'2022_11_19_041643_add_ec_tax_product_table',1),(110,'2022_12_02_093615_update_slug_index_columns',1),(111,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',1),(112,'2022_12_17_041532_fix_address_in_order_invoice',1),(113,'2022_12_26_070329_create_ec_product_views_table',1),(114,'2023_01_04_033051_fix_product_categories',1),(115,'2023_01_09_050400_add_ec_global_options_translations_table',1),(116,'2023_01_10_093754_add_missing_option_value_id',1),(117,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',1),(118,'2023_01_26_021854_add_ec_customer_used_coupons_table',1),(119,'2023_01_30_024431_add_alt_to_media_table',1),(120,'2023_02_01_062030_add_store_translations',1),(121,'2023_02_08_015900_update_options_column_in_ec_order_product_table',1),(122,'2023_02_13_032133_update_fee_column_mp_customer_revenues_table',1),(123,'2023_02_16_042611_drop_table_password_resets',1),(124,'2023_02_17_023648_fix_store_prefix',1),(125,'2023_02_27_095752_remove_duplicate_reviews',1),(126,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',1),(127,'2023_04_17_062645_add_open_in_new_tab',1),(128,'2023_04_21_082427_create_ec_product_categorizables_table',1),(129,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(130,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(131,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',1),(132,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(133,'2023_05_17_025812_fix_invoice_issue',1),(134,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',1),(135,'2023_05_27_144611_fix_exchange_rate_setting',1),(136,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',1),(137,'2023_06_30_042512_create_ec_order_tax_information_table',1),(138,'2023_07_06_011444_create_slug_translations_table',1),(139,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',1),(140,'2023_07_26_041451_add_more_columns_to_location_table',1),(141,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(142,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',1),(143,'2023_08_11_060908_create_announcements_table',1),(144,'2023_08_15_064505_create_ec_tax_rules_table',1),(145,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(146,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',1),(147,'2023_08_21_090810_make_page_content_nullable',1),(148,'2023_08_22_094114_drop_unique_for_barcode',1),(149,'2023_08_29_074620_make_column_author_id_nullable',1),(150,'2023_08_29_075308_make_column_user_id_nullable',1),(151,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',1),(152,'2023_09_07_094312_add_index_to_product_sku_and_translations',1),(153,'2023_09_14_021936_update_index_for_slugs_table',1),(154,'2023_09_14_022423_add_index_for_language_table',1),(155,'2023_09_19_024955_create_discount_product_categories_table',1),(156,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',1),(157,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(158,'2023_11_07_023805_add_tablet_mobile_image',1),(159,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(160,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(161,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(162,'2023_11_22_154643_add_unique_in_table_ec_products_variations',1),(163,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',1),(164,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',1),(165,'2023_12_06_100448_change_random_hash_for_media',1),(166,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(167,'2023_12_12_105220_drop_translations_table',1),(168,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(169,'2023_12_25_040604_ec_create_review_replies_table',1),(170,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',1),(171,'2024_01_16_070706_fix_translation_tables',1),(172,'2024_01_23_075227_add_proof_file_to_ec_orders_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,8,2,2242.00,0.00,2242.00,0.00,'USD',NULL,'2024-03-02 12:56:19','2024-03-02 12:56:19',0,'add-amount'),(2,1,4,2304.00,0.00,2304.00,0.00,'USD',NULL,'2024-03-02 22:56:19','2024-03-02 22:56:19',0,'add-amount'),(3,6,8,927.00,0.00,927.00,0.00,'USD',NULL,'2024-02-28 00:56:20','2024-02-28 00:56:20',0,'add-amount'),(4,6,9,1432.00,0.00,1432.00,927.00,'USD',NULL,'2024-02-29 00:56:20','2024-02-29 00:56:20',0,'add-amount'),(5,4,10,1379.00,0.00,1379.00,0.00,'USD',NULL,'2024-02-29 10:56:21','2024-02-29 10:56:21',0,'add-amount'),(6,5,11,1838.00,0.00,1838.00,0.00,'USD',NULL,'2024-03-04 00:56:21','2024-03-04 00:56:21',0,'add-amount'),(7,8,14,2752.00,0.00,2752.00,2242.00,'USD',NULL,'2024-02-29 00:56:22','2024-02-29 00:56:22',0,'add-amount'),(8,4,20,2098.00,0.00,2098.00,1379.00,'USD',NULL,'2024-02-23 12:56:22','2024-02-23 12:56:22',0,'add-amount'),(9,3,25,800.00,0.00,800.00,0.00,'USD',NULL,'2024-02-14 12:56:23','2024-02-14 12:56:23',0,'add-amount'),(10,8,34,2752.00,0.00,2752.00,4994.00,'USD',NULL,'2024-02-04 20:56:23','2024-02-04 20:56:23',0,'add-amount'),(11,1,40,2004.00,0.00,2004.00,2304.00,'USD',NULL,'2024-02-06 16:56:24','2024-02-06 16:56:24',0,'add-amount'),(12,4,41,7315.00,0.00,7315.00,3477.00,'USD',NULL,'2024-02-16 12:56:24','2024-02-16 12:56:24',0,'add-amount'),(13,8,49,2242.00,0.00,2242.00,7746.00,'USD',NULL,'2024-02-17 08:56:25','2024-02-17 08:56:25',0,'add-amount');
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,1,0.00,507.00,4308.00,'USD','','{\"name\":\"Beverly Murray\",\"number\":\"+19409443356\",\"full_name\":\"Myles Jerde II\",\"description\":\"Roselyn Koelpin\"}',NULL,0,'pending',NULL,'2024-03-05 00:56:25','2024-03-05 00:56:25',NULL),(2,1,0.00,713.00,3801.00,'USD','','{\"name\":\"Beverly Murray\",\"number\":\"+19409443356\",\"full_name\":\"Myles Jerde II\",\"description\":\"Roselyn Koelpin\"}',NULL,0,'processing',NULL,'2024-03-05 00:56:26','2024-03-05 00:56:26',NULL),(3,1,0.00,963.00,3088.00,'USD','','{\"name\":\"Beverly Murray\",\"number\":\"+19409443356\",\"full_name\":\"Myles Jerde II\",\"description\":\"Roselyn Koelpin\"}',NULL,0,'pending',NULL,'2024-03-05 00:56:26','2024-03-05 00:56:26',NULL),(4,3,0.00,165.00,800.00,'USD','','{\"name\":\"Malinda Moen\",\"number\":\"+16789221397\",\"full_name\":\"Prof. Thad Kulas\",\"description\":\"Catherine Cummerata\"}',NULL,0,'completed',NULL,'2024-03-05 00:56:27','2024-03-05 00:56:27',NULL),(5,3,0.00,57.00,635.00,'USD','','{\"name\":\"Malinda Moen\",\"number\":\"+16789221397\",\"full_name\":\"Prof. Thad Kulas\",\"description\":\"Catherine Cummerata\"}',NULL,0,'processing',NULL,'2024-03-05 00:56:27','2024-03-05 00:56:27',NULL),(6,4,0.00,778.00,10792.00,'USD','','{\"name\":\"Isobel Bergstrom\",\"number\":\"+15203500783\",\"full_name\":\"Gordon Hackett\",\"description\":\"Salvador Johns\"}',NULL,0,'completed',NULL,'2024-03-05 00:56:28','2024-03-05 00:56:28',NULL),(7,4,0.00,71.00,10014.00,'USD','','{\"name\":\"Isobel Bergstrom\",\"number\":\"+15203500783\",\"full_name\":\"Gordon Hackett\",\"description\":\"Salvador Johns\"}',NULL,0,'processing',NULL,'2024-03-05 00:56:28','2024-03-05 00:56:28',NULL),(8,5,0.00,278.00,1838.00,'USD','','{\"name\":\"Marty Hickle Jr.\",\"number\":\"+15858448005\",\"full_name\":\"Cora Ledner\",\"description\":\"Amir Zieme III\"}',NULL,0,'processing',NULL,'2024-03-05 00:56:29','2024-03-05 00:56:29',NULL),(9,5,0.00,377.00,1560.00,'USD','','{\"name\":\"Marty Hickle Jr.\",\"number\":\"+15858448005\",\"full_name\":\"Cora Ledner\",\"description\":\"Amir Zieme III\"}',NULL,0,'completed',NULL,'2024-03-05 00:56:29','2024-03-05 00:56:29',NULL),(10,6,0.00,695.00,2359.00,'USD','','{\"name\":\"Dr. Issac Hermann DDS\",\"number\":\"+13644870321\",\"full_name\":\"Ayana Wehner DDS\",\"description\":\"Marianna Dietrich\"}',NULL,0,'completed',NULL,'2024-03-05 00:56:30','2024-03-05 00:56:30',NULL),(11,6,0.00,36.00,1664.00,'USD','','{\"name\":\"Dr. Issac Hermann DDS\",\"number\":\"+13644870321\",\"full_name\":\"Ayana Wehner DDS\",\"description\":\"Marianna Dietrich\"}',NULL,0,'pending',NULL,'2024-03-05 00:56:30','2024-03-05 00:56:30',NULL),(12,8,0.00,2285.00,9988.00,'USD','','{\"name\":\"Alvena Torp\",\"number\":\"+12726604081\",\"full_name\":\"Marjorie Ritchie\",\"description\":\"Alysson Toy\"}',NULL,0,'completed',NULL,'2024-03-05 00:56:31','2024-03-05 00:56:31',NULL),(13,8,0.00,1083.00,7703.00,'USD','','{\"name\":\"Alvena Torp\",\"number\":\"+12726604081\",\"full_name\":\"Marjorie Ritchie\",\"description\":\"Alysson Toy\"}',NULL,0,'processing',NULL,'2024-03-05 00:56:31','2024-03-05 00:56:31',NULL),(14,8,0.00,687.00,6620.00,'USD','','{\"name\":\"Alvena Torp\",\"number\":\"+12726604081\",\"full_name\":\"Marjorie Ritchie\",\"description\":\"Alysson Toy\"}',NULL,0,'processing',NULL,'2024-03-05 00:56:32','2024-03-05 00:56:32',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','prosacco.asa@example.net','+13619932749','953 Wolff Rue','CK','Arkansas','Blockborough',1,'main/stores/1.png','Quibusdam veritatis ut exercitationem. Non et reprehenderit quis quo perferendis deserunt. Debitis officia ea qui. Sapiente et sed sint rerum quibusdam quaerat harum beatae. Aliquam enim distinctio dolores veniam. Tempora voluptatem voluptas velit. Voluptate iusto ut et nisi illo recusandae doloremque minima. Dicta a rerum consequuntur corporis. Est minima et et id.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(2,'Global Office','vaufderhar@example.net','+17165974308','937 Wolf Dam','FM','Louisiana','Thompsonfurt',2,'main/stores/2.png','Nihil ea aut temporibus. Est ut qui nihil ea excepturi ut quae. Iste laborum eum aperiam fuga aut ut et est. Dolor ab rem quidem officiis quia culpa et neque. Quisquam sit sunt ut eveniet sit. Earum omnis voluptates laudantium est sed ut at. Magnam dolorem et dolorum corrupti. Alias architecto dolor ipsam in earum et minus.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(3,'Young Shop','felton53@example.com','+12407840554','268 Madyson Stream Suite 676','AF','Illinois','South Eudora',3,'main/stores/3.png','Eum praesentium nobis quisquam inventore reiciendis. Ut in eum quod. Quo ut eligendi aut a ut. Voluptatem voluptas voluptatem placeat dolorem. Similique cupiditate quia ut quaerat laborum. Velit eos quidem enim et deserunt. Nemo praesentium ratione est vero facere sit ipsa.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(4,'Global Store','irunte@example.org','+15395980321','33378 Wiley Divide','HT','Wisconsin','North Romaineton',4,'main/stores/4.png','Aperiam ab quia non laudantium laudantium quisquam. Dignissimos assumenda voluptatem pariatur rem pariatur doloribus ipsa. Soluta rerum laudantium labore consequatur. Placeat eum facilis eum sunt. Est laboriosam libero nostrum voluptas iure accusamus inventore. Ex ratione at quod et ut. Aut itaque sapiente occaecati aspernatur eveniet enim illo modi. Ex autem eius laudantium consequatur.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(5,'Robert’s Store','dbednar@example.com','+13032082694','1993 Monserrat Shore Apt. 018','CD','Illinois','New Demariochester',5,'main/stores/5.png','Cupiditate aut fugit nam reiciendis nihil praesentium facilis. Quisquam ut saepe veniam laborum sit asperiores. Aut dignissimos consequatur sit animi fugit est eligendi aut. Voluptas dolorem possimus consectetur ad et. Praesentium animi quasi nostrum ullam quo est explicabo. Eos labore nihil et quia qui deleniti. Nihil tenetur laborum cupiditate accusantium aut reiciendis.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(6,'Stouffer','malcolm37@example.net','+15078182191','324 Bartoletti Circle Apt. 105','DE','New Mexico','East Garretport',6,'main/stores/6.png','Quibusdam autem debitis et cum quia. Omnis sed aperiam quas est. Temporibus dolor impedit enim et culpa non. Ut nesciunt molestiae minima impedit omnis non. Aliquam dolores in odit error. Dolores saepe omnis omnis illo odit iste. Sint ut ut voluptas quae omnis iure enim labore. Eum voluptatem perferendis quia placeat. Veniam accusantium aut incidunt minus praesentium. Eum tempore quaerat aut rem.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(7,'StarKist','vweimann@example.org','+14175962910','18436 Kaia Turnpike','IR','South Dakota','New Kurtisburgh',7,'main/stores/7.png','Perspiciatis laudantium voluptatem amet eum repellat. Sed suscipit non illo aut. Et iste odio in culpa. Quibusdam voluptas ut distinctio error ea. Nobis temporibus impedit sunt nemo dolorum. Quas officia soluta quas quaerat. Illum iure aspernatur nulla labore et. Omnis in sapiente ducimus id minus modi dolorum. Et vel dolorum qui rerum maiores.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL),(8,'Old El Paso','hiram37@example.com','+16677605313','241 Reva Circle Apt. 786','CX','Colorado','Aubreeburgh',8,'main/stores/8.png','Et velit voluptas eum suscipit error. Eaque et non earum autem veritatis provident nam. Qui optio similique ullam natus totam. Tenetur quasi eveniet ut. Illo nulla error id quis non atque qui. Ipsam error voluptatem sapiente cumque praesentium veritatis sed.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:56:04','2024-03-05 00:56:04',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores_translations`
--

DROP TABLE IF EXISTS `mp_stores_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mp_stores_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`mp_stores_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores_translations`
--

LOCK TABLES `mp_stores_translations` WRITE;
/*!40000 ALTER TABLE `mp_stores_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_stores_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,1,2125.00,0.00,4308.00,'$2y$12$yorl0SYPG0lgULgwamMocOOiCI6m5AX0QxDCPOP4gipBdKyRYb8DS','{\"name\":\"Beverly Murray\",\"number\":\"+19409443356\",\"full_name\":\"Myles Jerde II\",\"description\":\"Roselyn Koelpin\"}','2024-03-05 00:56:02','2024-03-05 00:56:27','bank_transfer',NULL),(2,2,0.00,0.00,0.00,'$2y$12$qN/Z4wXJ.vG.32dq7FRstO56S6jLgFnqu0V5BYdYnE2qs5GvEthM2','{\"name\":\"Ms. Oleta Maggio I\",\"number\":\"+14197694979\",\"full_name\":\"Roderick Bayer\",\"description\":\"Louisa Swaniawski IV\"}','2024-03-05 00:56:02','2024-03-05 00:56:02','bank_transfer',NULL),(3,3,578.00,0.00,800.00,'$2y$12$tktlF23iHxVK82hgHW7w3e4HVTb.uUWZF3KCPPdMdxIqTouckkSAS','{\"name\":\"Malinda Moen\",\"number\":\"+16789221397\",\"full_name\":\"Prof. Thad Kulas\",\"description\":\"Catherine Cummerata\"}','2024-03-05 00:56:03','2024-03-05 00:56:28','bank_transfer',NULL),(4,4,9943.00,0.00,10792.00,'$2y$12$DElRPpsiPlmUIIcFQWulwOlHB7BLZCbhSHOKIJ/7GQV5MJfSoeokG','{\"name\":\"Isobel Bergstrom\",\"number\":\"+15203500783\",\"full_name\":\"Gordon Hackett\",\"description\":\"Salvador Johns\"}','2024-03-05 00:56:03','2024-03-05 00:56:29','bank_transfer',NULL),(5,5,1183.00,0.00,1838.00,'$2y$12$xH0gYMmdheqs.Lb2uhU7LetHKTFgrTDv0p7lMYbbeYbrt.29GVyru','{\"name\":\"Marty Hickle Jr.\",\"number\":\"+15858448005\",\"full_name\":\"Cora Ledner\",\"description\":\"Amir Zieme III\"}','2024-03-05 00:56:03','2024-03-05 00:56:30','bank_transfer',NULL),(6,6,1628.00,0.00,2359.00,'$2y$12$hYysvAJpgl5OK/nti4rNsup2T1bvxkBCkANAXt3SHoOkmc.gi4wQO','{\"name\":\"Dr. Issac Hermann DDS\",\"number\":\"+13644870321\",\"full_name\":\"Ayana Wehner DDS\",\"description\":\"Marianna Dietrich\"}','2024-03-05 00:56:03','2024-03-05 00:56:31','bank_transfer',NULL),(7,7,0.00,0.00,0.00,'$2y$12$s1wK6IrcS.GYWBqyv7.Duuoe6V0gzqrrGC9UWK4Y7m7Xe6xhN.MPy','{\"name\":\"Zena Torphy Sr.\",\"number\":\"+13513340260\",\"full_name\":\"Beatrice Rau\",\"description\":\"Xzavier Krajcik\"}','2024-03-05 00:56:04','2024-03-05 00:56:04','bank_transfer',NULL),(8,8,5933.00,0.00,9988.00,'$2y$12$R8tIHMdBLD0dgy0fDjnwmOsu.t4JVH73zjiw2muJktCz7hKfD9NXe','{\"name\":\"Alvena Torp\",\"number\":\"+12726604081\",\"full_name\":\"Marjorie Ritchie\",\"description\":\"Alysson Toy\"}','2024-03-05 00:56:04','2024-03-05 00:56:32','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','[simple-slider style=\"2\" key=\"home-slider\" shape_1=\"fashion/sliders/shape-1.png\" shape_2=\"fashion/sliders/shape-2.png\" shape_3=\"fashion/sliders/shape-3.png\"][/simple-slider][ads style=\"2\" key_1=\"WXAUTIJV1QU0\" key_2=\"7Z5RXBBWV7J2\" key_3=\"JY08TDO8FG1E\" full_width=\"0,1\"][/ads][ecommerce-categories style=\"slider\" title=\"Popular on the Shofy store.\" description=\"Shop by Category\" category_ids=\"1,2,7,11,18,19\" background_color=\"#F3F5F7\"][/ecommerce-categories][ecommerce-product-groups title=\"Customer Favorite Style Product\" subtitle=\"All Product Shop\" limit=\"8\" tabs=\"all,featured,on-sale,trending,top-rated\"][/ecommerce-product-groups][ecommerce-products title=\"This Week\'s Featured\" subtitle=\"Shop by Category\" by=\"collection\" collection_ids=\"1\" limit=\"5\" style=\"slider-full-width\"][/ecommerce-products][ecommerce-products title=\"Trending Arrivals\" subtitle=\"More to Discover\" by=\"collection\" collection_ids=\"1\" limit=\"5\" style=\"slider-with-ads-sidebar\" ads=\"VKJNCBIBQC1O\"][/ecommerce-products][ecommerce-products title=\"This Week\'s Featured\" subtitle=\"Best Seller This Week\\’s\" by=\"specify\" product_ids=\"3,4,5,6\" limit=\"12\" style=\"slider\" button_label=\"Shop All Now\" button_url=\"/products\"][/ecommerce-products][testimonials style=\"1\" title=\"The Review Are In\" testimonial_ids=\"2,3,4\"][/testimonials][blog-posts title=\"Latest News & Articles\" subtitle=\"Our Blog & News\" type=\"recent\" limit=\"3\" button_label=\"Discover More\" button_url=\"/blog\"][/blog-posts][site-features style=\"2\" quantity=\"4\" title_1=\"Free Delivery\" description_1=\"Orders from all item\" icon_1=\"ti ti-truck-delivery\" title_2=\"Return & Refund\" description_2=\"Money back guarantee\" icon_2=\"ti ti-currency-dollar\" title_3=\"Member Discount\" description_3=\"Every order over $140.00\" icon_3=\"ti ti-discount-2\" title_4=\"Support 24/7\" description_4=\"Contact us 24 hours a day\" icon_4=\"ti ti-headset\"][/site-features][gallery style=\"2\" limit=\"5\"][/gallery]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(2,'Product Categories','[ads style=\"2\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads][ecommerce-categories style=\"slider\" title=\"Popular on the Shofy store.\" description=\"Shop by Category\" category_ids=\"1,2,7,11,18,19\" background_color=\"#F3F5F7\"][/ecommerce-categories]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(3,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(4,'Blog',NULL,1,NULL,'full-width',NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(5,'Contact','[contact-form show_contact_form=&quot;0,1&quot; title=&quot;Sent A Message&quot; quantity=&quot;2&quot; icon_1=&quot;main/contact/icon-1.png&quot; content_1=&quot;contact@shofy.com &lt;br&gt; &lt;strong&gt;+670 413 90 762&lt;/strong&gt;&quot; icon_2=&quot;main/contact/icon-2.png&quot; content_2=&quot;502 New St, Brighton VIC 3186, Australia&quot; show_social_info=&quot;0,1&quot; social_info_label=&quot;Find on social media&quot; social_info_icon=&quot;main/contact/icon-3.png&quot;][/contact-form][google-map]502 New Street, Brighton VIC, Australia[/google-map]',1,NULL,'full-width',NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(6,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(7,'Our Story','<h4>A passion for handcrafted coffee, brewed with love and community.</h4>\n\n<p>\n    We are a small, family-owned coffee roaster dedicated to bringing the finest, ethically sourced beans to your cup. Our story began in a cozy kitchen, fueled by a shared passion for the rich aroma and invigorating taste of freshly brewed coffee. We dreamt of creating a space where people could connect over a warm cup, share stories, and experience the joy of handcrafted coffee.\n</p>\n\n<h4>From Humble Beginnings to Roasting Success:</h4>\n\n<p>\n    Our journey started with a small coffee roaster nestled in our garage. We spent countless hours experimenting with different roasting profiles, meticulously cupping each batch to achieve the perfect balance of flavor and aroma. Driven by a desire to make a difference, we built relationships with sustainable coffee farms around the world, ensuring fair trade practices and the highest quality beans.\n</p>\n\n<h4>Milestones and More to Come:</h4>\n\n<p>\n    Our dedication to quality and community resonated with coffee lovers, and our small business quickly grew. We opened our first cafe, a warm and inviting space where people could gather, savor our freshly roasted coffee, and connect with friends and neighbors. We\'ve continued to expand, now offering a variety of handcrafted coffee beverages, alongside delicious pastries and light bites.\n</p>\n\n<h4>Values at Our Core:</h4>\n\n<p>\n    At the heart of everything we do lies our commitment to ethical sourcing, sustainable practices, and building meaningful connections. We believe in supporting the communities that cultivate our coffee beans, ensuring fair wages and responsible farming methods. Every cup you enjoy contributes to a positive impact, one sip at a time.\n</p>\n\n<h4>Join us on our journey!</h4>\n\n<p>\n    We invite you to explore our world of coffee, from the rich diversity of our bean origins to the unique flavors crafted through meticulous roasting. Visit our cafe, discover your perfect cup, and become part of our ever-growing coffee community. Let\'s connect over a cup, share stories, and celebrate the simple joy of a well-brewed coffee.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(8,'Careers','<h3>Careers: Be Part of Our Brewing Legacy</h3>\n\n<p>\n    At Shofy, we\'re not just brewing coffee, we\'re brewing a legacy. Since our humble beginnings in 2024, we\'ve grown from a small, family-owned roaster to a thriving coffee haven. But our passion for quality, community, and sustainability remains at the core of everything we do.\n</p>\n\n<h4>Why Join Our Team?</h4>\n\n<ul>\n    <li>\n        <p><strong>Become a Coffee Connoisseur</strong>: Immerse yourself in the world of coffee, learning from experienced roasters and baristas about bean origins, roasting techniques, and crafting the perfect cup.</p>\n    </li>\n    <li>\n        <p><strong>Fuel Your Passion</strong>: Contribute to our mission by sourcing ethically, promoting sustainable practices, and fostering positive relationships with coffee-growing communities around the globe.</p>\n    </li>\n    <li>\n        <p><strong>Grow with Us</strong>: We offer comprehensive training programs and opportunities for professional development, helping you refine your skills and advance your career in the coffee industry.</p>\n    </li>\n    <li>\n        <p><strong>Be Part of the Family</strong>: We cultivate a collaborative and supportive work environment where your unique talents and perspectives are valued.</p>\n    </li>\n</ul>\n\n<h4>Current Openings:</h4>\n\n<ul>\n    <li>\n        <p><strong>Coffee Roaster</strong>: Play a vital role in our roasting process, meticulously crafting unique flavor profiles and ensuring the highest quality beans reach our customers.</p>\n    </li>\n    <li>\n        <p><strong>Barista</strong>: Become a coffee ambassador, welcoming guests with a smile, crafting their perfect cup, and sharing your knowledge and passion for coffee.</p>\n    </li>\n    <li>\n        <p><strong>Cafe Manager</strong>: Lead your team in creating a warm and inviting atmosphere, overseeing daily operations, and ensuring exceptional customer service.</p>\n    </li>\n</ul>\n\n<h4>We are always looking for passionate individuals who share our values:</h4>\n\n<ul>\n    <li>\n        <p>A genuine love for coffee and a desire to learn everything there is to know about it.</p>\n    </li>\n    <li>\n        <p>A commitment to ethical sourcing, sustainability, and social responsibility.</p>\n    </li>\n    <li>\n        <p>Excellent communication and interpersonal skills to build rapport with colleagues and customers.</p>\n    </li>\n    <li>\n        <p>A positive attitude, a willingness to learn, and a collaborative spirit.</p>\n    </li>\n</ul>\n\n<p>Ready to join our brewing legacy?</p>\n\n<p>\n    Submit your resume and cover letter, telling us why you\'re a perfect fit for our team. We look forward to meeting passionate individuals who are ready to brew the future with us, one cup at a time.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09'),(9,'Shipping','<section>\n    <h2>Shipping Methods</h2>\n    <p>We offer several shipping methods to choose from:</p>\n    <ul>\n        <li>Standard Shipping - 3 to 5 business days</li>\n        <li>Express Shipping - 1 to 2 business days</li>\n        <li>International Shipping - 7 to 14 business days</li>\n    </ul>\n    <p>Please note that shipping times may vary depending on your location and other factors.</p>\n</section>\n\n<section>\n    <h2>Shipping Costs</h2>\n    <p>Shipping costs are calculated based on the weight of your order and the shipping method selected during checkout.</p>\n    <p>You can view the estimated shipping costs in your shopping cart before completing your purchase.</p>\n</section>\n\n<section>\n    <h2>Tracking Your Order</h2>\n    <p>Once your order has been shipped, you will receive a confirmation email with a tracking number.</p>\n    <p>You can use this tracking number to monitor the status of your delivery on our website or through the shipping carrier\'s website.</p>\n</section>\n\n<section>\n    <h2>Shipping Restrictions</h2>\n    <p>Some items may be subject to shipping restrictions due to size, weight, or destination.</p>\n    <p>If your order contains any restricted items, we will notify you during the checkout process.</p>\n</section>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'WQZXCAKP73','cod',NULL,2431.00,1,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'FXZSUMAXG2','paystack',NULL,2242.00,2,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'MJBFGXBSWK','cod',NULL,7666.00,3,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'56WDJ5ZG9U','paystack',NULL,2304.00,4,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'U1LWAKDLDP','paystack',NULL,3676.00,5,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:10','2024-03-05 00:56:10','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'EXRYJTYR4G','cod',NULL,908.00,6,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'3IV8YRNW7M','paypal',NULL,1600.00,7,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'GERF4HSFRV','paystack',NULL,927.00,8,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'FCSHV0HJIP','razorpay',NULL,1432.00,9,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'LW8XXRCJKU','stripe',NULL,1379.00,10,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:11','2024-03-05 00:56:11','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'YJO5PVVACW','paypal',NULL,1838.00,11,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'C5Q6PRY5V9','sslcommerz',NULL,5850.00,12,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'NPEFISDJUB','paypal',NULL,6213.00,13,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'1LC0S6T6CG','paypal',NULL,2752.00,14,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'DKLMQHA1DI','paypal',NULL,5166.00,15,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'RZTKYBV9UR','stripe',NULL,4536.00,16,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:12','2024-03-05 00:56:12','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'OC24KJN3XN','paypal',NULL,490.00,17,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'NOTZR0YZUM','razorpay',NULL,2242.00,18,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'BVEMCGOZ93','sslcommerz',NULL,2632.00,19,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'4PWICQUDHM','paypal',NULL,2098.00,20,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'SAVYXY03WX','stripe',NULL,530.00,21,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:13','2024-03-05 00:56:13','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'CYI7YF5UQN','cod',NULL,2148.00,22,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'JUDILDTYXW','bank_transfer',NULL,3141.00,23,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'JOS2N09AJW','bank_transfer',NULL,2096.00,24,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'UARWX650ER','razorpay',NULL,800.00,25,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'WMEYCXFHJA','bank_transfer',NULL,3144.00,26,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:14','2024-03-05 00:56:14','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'F3ZCQJZXDO','paypal',NULL,682.00,27,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'FSACK1ZGMH','cod',NULL,2497.00,28,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'H1YEHHQQFA','paystack',NULL,1063.00,29,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'ENDOOIKAOV','bank_transfer',NULL,4196.00,30,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'AEYEUEHEA8','stripe',NULL,5850.00,31,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'AYPXRD4TLP','paystack',NULL,7491.00,32,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:15','2024-03-05 00:56:15','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'ZFCSA8EKXP','paypal',NULL,6213.00,33,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'FD0KFURHBK','stripe',NULL,2752.00,34,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'TFL7IOV3CR','sslcommerz',NULL,5850.00,35,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'2VR3L45BXS','paypal',NULL,795.00,36,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'XCYLSE2RG0','razorpay',NULL,1432.00,37,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'ZPQUDRRZHD','paypal',NULL,1816.00,38,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:16','2024-03-05 00:56:16','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'PVDMDD6BQF','paystack',NULL,1470.00,39,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'K8STDJMBAZ','sslcommerz',NULL,2004.00,40,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'VMTSIN49MG','paypal',NULL,7315.00,41,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'POQCNUBEJD','cod',NULL,2400.00,42,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\Ecommerce\\Models\\Customer',NULL),(43,'USD',0,'GNUTLDI5TJ','bank_transfer',NULL,1155.00,43,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\Ecommerce\\Models\\Customer',NULL),(44,'USD',0,'LAGIIIKXPN','razorpay',NULL,3900.00,44,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:17','2024-03-05 00:56:17','Botble\\Ecommerce\\Models\\Customer',NULL),(45,'USD',0,'EXABYRW0RR','bank_transfer',NULL,309.00,45,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\Ecommerce\\Models\\Customer',NULL),(46,'USD',0,'EM8L2DW48Q','sslcommerz',NULL,5850.00,46,'completed','confirm',10,NULL,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\Ecommerce\\Models\\Customer',NULL),(47,'USD',0,'XBARP6GEQ1','bank_transfer',NULL,306.00,47,'pending','confirm',10,NULL,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\Ecommerce\\Models\\Customer',NULL),(48,'USD',0,'9OTIOSFIPT','cod',NULL,6624.00,48,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\Ecommerce\\Models\\Customer',NULL),(49,'USD',0,'N4MQXLNBE7','paystack',NULL,2242.00,49,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:18','2024-03-05 00:56:18','Botble\\Ecommerce\\Models\\Customer',NULL),(50,'USD',0,'JHNRP7DIUG','paystack',NULL,3189.00,50,'completed','confirm',9,NULL,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19','Botble\\Ecommerce\\Models\\Customer',NULL),(51,'USD',0,'LFLDJ2QZNX','bank_transfer',NULL,1596.00,51,'pending','confirm',9,NULL,NULL,'2024-03-05 00:56:19','2024-03-05 00:56:19','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (4,1),(4,2),(6,2),(3,3),(6,3),(5,4),(2,5),(1,5),(6,6),(4,6),(1,7),(4,7),(1,8),(3,9),(4,9),(1,10),(4,10),(2,11),(1,11),(3,12),(2,12),(5,13),(2,14),(6,14),(3,15),(4,15),(2,16),(5,16),(6,17),(6,18),(4,18);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (7,1),(3,1),(4,1),(5,2),(4,2),(3,2),(5,3),(7,3),(2,3),(8,4),(6,4),(3,5),(5,5),(4,6),(8,6),(5,7),(4,7),(1,7),(5,8),(6,8),(7,9),(6,9),(5,9),(1,10),(3,10),(3,11),(5,11),(1,11),(3,12),(1,12),(3,13),(1,13),(8,14),(5,14),(6,14),(3,15),(4,15),(2,16),(7,16),(5,16),(6,17),(6,18),(4,18),(3,18);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','The Dormouse had closed its eyes by this time?\' she said to Alice, and she hurried out of that is--\"Oh, \'tis love, that makes people hot-tempered,\' she went back to finish his story. CHAPTER IV. The.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',345,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','Time!\' \'Perhaps not,\' Alice cautiously replied: \'but I haven\'t had a bone in his sleep, \'that \"I like what I get\" is the driest thing I ever was at in all directions, \'just like a serpent. She had.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-9.jpg',1349,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(3,'The Top 2020 Handbag Trends to Know','I? Ah, THAT\'S the great puzzle!\' And she kept fanning herself all the rats and--oh dear!\' cried Alice in a hurry to change the subject. \'Go on with the birds hurried off to the door, she found.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-3.jpg',2107,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(4,'How to Match the Color of Your Handbag With an Outfit','HIS time of life. The King\'s argument was, that anything that looked like the three gardeners, oblong and flat, with their hands and feet, to make it stop. \'Well, I\'d hardly finished the goose, with.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-3.jpg',1079,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(5,'How to Care for Leather Bags','Rabbit-Hole Alice was a body to cut it off from: that he shook his head off outside,\' the Queen had never heard of uglifying!\' it exclaimed. \'You know what to do, so Alice went timidly up to the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',546,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','I BEG your pardon!\' cried Alice in a very difficult game indeed. The players all played at once took up the conversation a little. \'\'Tis so,\' said Alice. \'Did you say things are \"much of a.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-11.jpg',1936,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(7,'Essential Qualities of Highly Successful Music','White Rabbit interrupted: \'UNimportant, your Majesty means, of course,\' said the Hatter, \'or you\'ll be telling me next that you think you could keep it to half-past one as long as it could go, and.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-4.jpg',2354,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(8,'9 Things I Love About Shaving My Head','I only knew how to begin.\' He looked at poor Alice, and her face in her own ears for having missed their turns, and she put them into a pig, my dear,\' said Alice, \'I\'ve often seen a cat without a.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-2.jpg',1258,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(9,'Why Teamwork Really Makes The Dream Work','As a duck with its mouth and yawned once or twice, and shook itself. Then it got down off the subjects on his spectacles. \'Where shall I begin, please your Majesty,\' said Alice thoughtfully: \'but.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-5.jpg',906,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(10,'The World Caters to Average People','May it won\'t be raving mad after all! I almost wish I\'d gone to see it written up somewhere.\' Down, down, down. There was not quite like the right size again; and the Queen in a voice sometimes.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',2300,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(11,'The litigants on the screen are not actors','So they sat down, and the Queen was silent. The Dormouse shook its head to keep back the wandering hair that curled all over crumbs.\' \'You\'re wrong about the games now.\' CHAPTER X. The Lobster.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',2257,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(12,'Hiring the Right Sales Team at the Right Time','Gryphon, and the Mock Turtle replied; \'and then the puppy began a series of short charges at the Hatter, and here the Mock Turtle sighed deeply, and began, in a thick wood. \'The first thing I\'ve got.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-1.jpg',1419,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(13,'Fully Embrace the Return of 90s fashion','I don\'t think,\' Alice went on just as well as she leant against a buttercup to rest herself, and once she remembered how small she was always ready to make ONE respectable person!\' Soon her eye fell.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',2458,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(14,'Exploring the English Countryside','Gryphon: \'I went to school in the beautiful garden, among the people that walk with their hands and feet, to make SOME change in my time, but never ONE with such a subject! Our family always HATED.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-2.jpg',1332,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(15,'Here’s the First Valentino’s New Makeup Collection','The cook threw a frying-pan after her as she swam about, trying to invent something!\' \'I--I\'m a little nervous about it in a hoarse, feeble voice: \'I heard the Rabbit angrily. \'Here! Come and help.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',2234,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(16,'Follow Your own Design process, whatever gets','King. \'When did you begin?\' The Hatter was out of sight: \'but it doesn\'t matter much,\' thought Alice, \'to pretend to be almost out of a water-well,\' said the Knave, \'I didn\'t know how to speak with.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-3.jpg',400,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(17,'Freelancer Days 2024, What’s new?','Duck and a sad tale!\' said the Gryphon: and it put the Dormouse shook its head down, and felt quite strange at first; but she felt very lonely and low-spirited. In a little of the officers: but the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',120,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01'),(18,'Quality Foods Requirments For Every Human Body’s','Dormouse!\' And they pinched it on both sides at once. The Dormouse had closed its eyes again, to see it trying in a game of play with a large caterpillar, that was lying on the back. However, it was.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-1.jpg',610,NULL,'2024-03-05 00:56:01','2024-03-05 00:56:01');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_logs`
--

DROP TABLE IF EXISTS `request_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_code` int DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_logs`
--

LOCK TABLES `request_logs` WRITE;
/*!40000 ALTER TABLE `request_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.manage.license\":true,\"extensions.index\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.cronjob\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"plugins.captcha\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.settings\":true,\"plugins.ecommerce\":true,\"ecommerce.settings\":true,\"ecommerce.report.index\":true,\"products.index\":true,\"products.create\":true,\"products.edit\":true,\"products.destroy\":true,\"products.duplicate\":true,\"product-categories.index\":true,\"product-categories.create\":true,\"product-categories.edit\":true,\"product-categories.destroy\":true,\"product-tag.index\":true,\"product-tag.create\":true,\"product-tag.edit\":true,\"product-tag.destroy\":true,\"brands.index\":true,\"brands.create\":true,\"brands.edit\":true,\"brands.destroy\":true,\"product-collections.index\":true,\"product-collections.create\":true,\"product-collections.edit\":true,\"product-collections.destroy\":true,\"product-attribute-sets.index\":true,\"product-attribute-sets.create\":true,\"product-attribute-sets.edit\":true,\"product-attribute-sets.destroy\":true,\"product-attributes.index\":true,\"product-attributes.create\":true,\"product-attributes.edit\":true,\"product-attributes.destroy\":true,\"tax.index\":true,\"tax.create\":true,\"tax.edit\":true,\"tax.destroy\":true,\"reviews.index\":true,\"reviews.create\":true,\"reviews.destroy\":true,\"reviews.publish\":true,\"reviews.reply\":true,\"shipping_methods.index\":true,\"ecommerce.shipping-rule-items.index\":true,\"ecommerce.shipping-rule-items.create\":true,\"ecommerce.shipping-rule-items.edit\":true,\"ecommerce.shipping-rule-items.destroy\":true,\"ecommerce.shipping-rule-items.bulk-import\":true,\"ecommerce.shipments.index\":true,\"ecommerce.shipments.create\":true,\"ecommerce.shipments.edit\":true,\"ecommerce.shipments.destroy\":true,\"orders.index\":true,\"orders.create\":true,\"orders.edit\":true,\"orders.destroy\":true,\"discounts.index\":true,\"discounts.create\":true,\"discounts.edit\":true,\"discounts.destroy\":true,\"customers.index\":true,\"customers.create\":true,\"customers.edit\":true,\"customers.destroy\":true,\"flash-sale.index\":true,\"flash-sale.create\":true,\"flash-sale.edit\":true,\"flash-sale.destroy\":true,\"product-label.index\":true,\"product-label.create\":true,\"product-label.edit\":true,\"product-label.destroy\":true,\"ecommerce.import.products.index\":true,\"ecommerce.export.products.index\":true,\"order_returns.index\":true,\"order_returns.edit\":true,\"order_returns.destroy\":true,\"global-option.index\":true,\"global-option.create\":true,\"global-option.edit\":true,\"global-option.destroy\":true,\"ecommerce.invoice.index\":true,\"ecommerce.invoice.edit\":true,\"ecommerce.invoice.destroy\":true,\"ecommerce.invoice-template.index\":true,\"ecommerce.settings.general\":true,\"ecommerce.settings.currencies\":true,\"ecommerce.settings.products\":true,\"ecommerce.settings.product-search\":true,\"ecommerce.settings.digital-products\":true,\"ecommerce.settings.store-locators\":true,\"ecommerce.settings.invoices\":true,\"ecommerce.settings.product-reviews\":true,\"ecommerce.settings.customers\":true,\"ecommerce.settings.shopping\":true,\"ecommerce.settings.taxes\":true,\"ecommerce.settings.shipping\":true,\"ecommerce.settings.tracking\":true,\"ecommerce.settings.standard-and-format\":true,\"ecommerce.settings.checkout\":true,\"ecommerce.settings.return\":true,\"ecommerce.settings.flash-sale\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"location.bulk-import.index\":true,\"location.export.index\":true,\"marketplace.index\":true,\"marketplace.store.index\":true,\"marketplace.store.create\":true,\"marketplace.store.edit\":true,\"marketplace.store.destroy\":true,\"marketplace.store.view\":true,\"marketplace.store.revenue.create\":true,\"marketplace.withdrawal.index\":true,\"marketplace.withdrawal.edit\":true,\"marketplace.withdrawal.destroy\":true,\"marketplace.vendors.index\":true,\"marketplace.unverified-vendors.index\":true,\"marketplace.unverified-vendors.edit\":true,\"marketplace.settings\":true,\"marketplace.reports\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"request-log.index\":true,\"request-log.destroy\":true,\"sale-popup.settings\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true}','Admin users role',1,1,1,'2024-03-05 00:55:56','2024-03-05 00:55:56');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','92c8a1c05a1cd78be205197a9438ab6e',NULL,'2024-03-05 00:56:09'),(2,'api_enabled','0',NULL,'2024-03-05 00:56:09'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"ecommerce\",\"faq\",\"gallery\",\"location\",\"marketplace\",\"newsletter\",\"payment\",\"paypal\",\"paypal-payout\",\"paystack\",\"razorpay\",\"request-log\",\"sale-popup\",\"shippo\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2024-03-05 00:56:09'),(6,'theme','shofy-fashion',NULL,'2024-03-05 00:56:09'),(7,'show_admin_bar','1',NULL,'2024-03-05 00:56:09'),(8,'payment_cod_status','1',NULL,'2024-03-05 00:56:09'),(9,'payment_bank_transfer_status','1',NULL,'2024-03-05 00:56:09'),(10,'admin_favicon','main/general/favicon.png',NULL,'2024-03-05 00:56:09'),(11,'admin_logo','main/general/logo-white.png',NULL,'2024-03-05 00:56:09'),(12,'permalink-botble-blog-models-post','blog',NULL,'2024-03-05 00:56:09'),(13,'permalink-botble-blog-models-category','blog',NULL,'2024-03-05 00:56:09'),(14,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2024-03-05 00:56:09'),(15,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2024-03-05 00:56:09'),(16,'payment_stripe_payment_type','stripe_checkout',NULL,'2024-03-05 00:56:09'),(17,'plugins_ecommerce_customer_new_order_status','0',NULL,'2024-03-05 00:56:09'),(18,'plugins_ecommerce_admin_new_order_status','0',NULL,'2024-03-05 00:56:09'),(19,'ecommerce_is_enabled_support_digital_products','1',NULL,'2024-03-05 00:56:09'),(20,'ecommerce_load_countries_states_cities_from_location_plugin','0',NULL,'2024-03-05 00:56:09'),(21,'language_hide_default','1',NULL,'2024-03-05 00:56:09'),(22,'language_switcher_display','dropdown',NULL,'2024-03-05 00:56:09'),(23,'language_display','all',NULL,'2024-03-05 00:56:09'),(24,'language_hide_languages','[]',NULL,'2024-03-05 00:56:09'),(25,'ecommerce_store_name','Shofy',NULL,'2024-03-05 00:56:09'),(26,'ecommerce_store_phone','1800979769',NULL,'2024-03-05 00:56:09'),(27,'ecommerce_store_address','502 New Street',NULL,'2024-03-05 00:56:09'),(28,'ecommerce_store_state','Brighton VIC',NULL,'2024-03-05 00:56:09'),(29,'ecommerce_store_city','Brighton VIC',NULL,'2024-03-05 00:56:09'),(30,'ecommerce_store_country','AU',NULL,'2024-03-05 00:56:09'),(31,'announcement_max_width','1390',NULL,'2024-03-05 00:56:09'),(32,'announcement_text_color','#010f1c',NULL,'2024-03-05 00:56:09'),(33,'announcement_background_color','transparent',NULL,'2024-03-05 00:56:09'),(34,'announcement_placement','theme',NULL,'2024-03-05 00:56:09'),(35,'announcement_text_alignment','start',NULL,'2024-03-05 00:56:09'),(36,'announcement_dismissible','0',NULL,'2024-03-05 00:56:09'),(37,'simple_slider_using_assets','0',NULL,'2024-03-05 00:56:09'),(38,'theme-shofy-fashion-site_name','Shofy',NULL,NULL),(39,'theme-shofy-fashion-site_title','Shofy - Multipurpose eCommerce Laravel Script',NULL,NULL),(40,'theme-shofy-fashion-seo_description','Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.s',NULL,NULL),(41,'theme-shofy-fashion-copyright','© 2024 All Rights Reserved.',NULL,NULL),(42,'theme-shofy-fashion-primary_font','Jost',NULL,NULL),(43,'theme-shofy-fashion-primary_color','#821F40',NULL,NULL),(44,'theme-shofy-fashion-favicon','main/general/favicon.png',NULL,NULL),(45,'theme-shofy-fashion-logo','main/general/logo.png',NULL,NULL),(46,'theme-shofy-fashion-logo_light','main/general/logo-white.png',NULL,NULL),(47,'theme-shofy-fashion-header_style','2',NULL,NULL),(48,'theme-shofy-fashion-preloader_icon','main/general/preloader-icon.png',NULL,NULL),(49,'theme-shofy-fashion-address','502 New Street, Brighton VIC, Australia',NULL,NULL),(50,'theme-shofy-fashion-hotline','8 800 332 65-66',NULL,NULL),(51,'theme-shofy-fashion-email','contact@fartmart.co',NULL,NULL),(52,'theme-shofy-fashion-working_time','Mon - Fri: 07AM - 06PM',NULL,NULL),(53,'theme-shofy-fashion-homepage_id','1',NULL,NULL),(54,'theme-shofy-fashion-blog_page_id','4',NULL,NULL),(55,'theme-shofy-fashion-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(56,'theme-shofy-fashion-cookie_consent_learn_more_url','cookie-policy',NULL,NULL),(57,'theme-shofy-fashion-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(58,'theme-shofy-fashion-number_of_products_per_page','24',NULL,NULL),(59,'theme-shofy-fashion-number_of_cross_sale_product','6',NULL,NULL),(60,'theme-shofy-fashion-ecommerce_products_page_layout','left_sidebar',NULL,NULL),(61,'theme-shofy-fashion-ecommerce_product_item_style','2',NULL,NULL),(62,'theme-shofy-fashion-logo_in_the_checkout_page','main/general/logo.png',NULL,NULL),(63,'theme-shofy-fashion-logo_in_invoices','main/general/logo.png',NULL,NULL),(64,'theme-shofy-fashion-logo_vendor_dashboard','main/general/logo.png',NULL,NULL),(65,'theme-shofy-fashion-404_page_image','main/general/404.png',NULL,NULL),(66,'theme-shofy-fashion-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"Youtube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'The Clothing Collection','fashion/sliders/slider-1.png','/products','New Arrivals 2023',0,'2024-03-05 00:56:04','2024-03-05 00:56:04'),(2,1,'The Summer Collection','fashion/sliders/slider-2.png','/products','Best Selling 2023',1,'2024-03-05 00:56:04','2024-03-05 00:56:04'),(3,1,'Amazing New designs','fashion/sliders/slider-3.png','/products','Winter Has Arrived',2,'2024-03-05 00:56:04','2024-03-05 00:56:04');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2024-03-05 00:56:04','2024-03-05 00:56:04');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'foodpound',1,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:55:56','2024-03-05 00:55:56'),(2,'itea-jsc',2,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:55:56','2024-03-05 00:55:56'),(3,'soda-brand',3,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:55:56','2024-03-05 00:55:56'),(4,'shofy',4,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:55:56','2024-03-05 00:55:56'),(5,'soda-brand',5,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:55:56','2024-03-05 00:55:56'),(6,'electronic',1,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:55:59','2024-03-05 00:55:59'),(7,'mobile',2,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:55:59','2024-03-05 00:55:59'),(8,'iphone',3,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:55:59','2024-03-05 00:55:59'),(9,'printer',4,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:55:59','2024-03-05 00:55:59'),(10,'office',5,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:55:59','2024-03-05 00:55:59'),(11,'it',6,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:55:59','2024-03-05 00:55:59'),(12,'crisp-bread-cake',1,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:00','2024-03-05 00:56:00'),(13,'fashion',2,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:00','2024-03-05 00:56:00'),(14,'electronic',3,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:00','2024-03-05 00:56:00'),(15,'commercial',4,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:00','2024-03-05 00:56:00'),(16,'organic-fruits',5,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:00','2024-03-05 00:56:00'),(17,'ecological',6,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:56:00','2024-03-05 00:56:00'),(18,'general',1,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:00','2024-03-05 00:56:00'),(19,'design',2,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:01','2024-03-05 00:56:01'),(20,'fashion',3,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:01','2024-03-05 00:56:01'),(21,'branding',4,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:01','2024-03-05 00:56:01'),(22,'modern',5,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:01','2024-03-05 00:56:01'),(23,'nature',6,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:01','2024-03-05 00:56:01'),(24,'vintage',7,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:01','2024-03-05 00:56:01'),(25,'sunglasses',8,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:56:01','2024-03-05 00:56:01'),(26,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',1,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(27,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',2,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(28,'the-top-2020-handbag-trends-to-know',3,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(29,'how-to-match-the-color-of-your-handbag-with-an-outfit',4,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(30,'how-to-care-for-leather-bags',5,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(31,'were-crushing-hard-on-summers-10-biggest-bag-trends',6,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(32,'essential-qualities-of-highly-successful-music',7,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(33,'9-things-i-love-about-shaving-my-head',8,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(34,'why-teamwork-really-makes-the-dream-work',9,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(35,'the-world-caters-to-average-people',10,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(36,'the-litigants-on-the-screen-are-not-actors',11,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(37,'hiring-the-right-sales-team-at-the-right-time',12,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(38,'fully-embrace-the-return-of-90s-fashion',13,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(39,'exploring-the-english-countryside',14,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(40,'heres-the-first-valentinos-new-makeup-collection',15,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(41,'follow-your-own-design-process-whatever-gets',16,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(42,'freelancer-days-2024-whats-new',17,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(43,'quality-foods-requirments-for-every-human-bodys',18,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:56:01','2024-03-05 00:56:01'),(44,'gopro',1,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(45,'global-office',2,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(46,'young-shop',3,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(47,'global-store',4,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(48,'roberts-store',5,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(49,'stouffer',6,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(50,'starkist',7,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(51,'old-el-paso',8,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:56:04','2024-03-05 00:56:04'),(52,'bags',1,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(53,'clothing',2,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(54,'mens-clothing',3,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(55,'t-shirts',4,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(56,'jeans',5,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(57,'suits',6,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(58,'womens-clothing',7,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(59,'dresses',8,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(60,'blouses',9,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(61,'pants',10,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(62,'footwear',11,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(63,'accessories',12,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(64,'hats',13,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:04','2024-03-05 00:56:04'),(65,'scarves',14,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:05','2024-03-05 00:56:05'),(66,'jewelry',15,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:05','2024-03-05 00:56:05'),(67,'sportswear',16,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:05','2024-03-05 00:56:05'),(68,'activewear',17,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:05','2024-03-05 00:56:05'),(69,'running-shoes',18,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:05','2024-03-05 00:56:05'),(70,'outerwear',19,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:56:05','2024-03-05 00:56:05'),(71,'vintage-denim-jacket',1,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(72,'floral-maxi-dress',2,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(73,'leather-ankle-boots',3,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(74,'knit-turtleneck-sweater-digital',4,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(75,'classic-aviator-sunglasses',5,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(76,'tailored-wool-blazer',6,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(77,'bohemian-fringe-handbag',7,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(78,'silk-scarf-with-geometric-print-digital',8,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(79,'high-waisted-wide-leg-trousers',9,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(80,'embroidered-boho-blouse',10,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(81,'statement-chunky-necklace',11,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(82,'chic-fedora-hat-digital',12,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(83,'strappy-block-heel-sandals',13,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(84,'velvet-evening-gown',14,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(85,'quilted-crossbody-bag',15,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(86,'distressed-skinny-jeans-digital',16,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(87,'lace-up-combat-boots',17,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(88,'cotton-striped-t-shirt-dress',18,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(89,'printed-palazzo-pants',19,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(90,'structured-satchel-bag-digital',20,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(91,'off-shoulder-ruffle-top',21,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(92,'suede-pointed-toe-pumps',22,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(93,'cropped-cable-knit-sweater',23,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(94,'athleisure-jogger-pants-digital',24,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(95,'leopard-print-midi-skirt',25,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(96,'retro-cat-eye-sunglasses',26,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(97,'faux-fur-trimmed-coat',27,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(98,'boho-fringed-kimono-digital',28,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(99,'ruffled-wrap-dress',29,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(100,'beaded-evening-clutch',30,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(101,'wide-brim-floppy-hat',31,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(102,'denim-overall-jumpsuit-digital',32,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(103,'embellished-ballet-flats',33,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(104,'pleated-midi-skirt',34,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(105,'velour-tracksuit-set',35,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(106,'geometric-patterned-cardigan-digital',36,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(107,'buckle-detail-ankle-booties',37,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(108,'embroidered-bomber-jacket',38,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(109,'cowl-neck-knit-poncho',39,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(110,'chunky-knit-infinity-scarf-digital',40,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:33'),(111,'retro-high-top-sneakers',41,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(112,'faux-leather-leggings',42,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:05','2024-03-05 00:56:05'),(113,'metallic-pleated-maxi-skirt',43,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:06','2024-03-05 00:56:06'),(114,'perfect',1,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:09','2024-03-05 00:56:09'),(115,'new-day',2,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:09','2024-03-05 00:56:09'),(116,'happy-day',3,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:09','2024-03-05 00:56:09'),(117,'nature',4,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:09','2024-03-05 00:56:09'),(118,'morning',5,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:56:09','2024-03-05 00:56:09'),(119,'home',1,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(120,'product-categories',2,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(121,'coupons',3,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(122,'blog',4,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(123,'contact',5,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(124,'cookie-policy',6,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(125,'our-story',7,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(126,'careers',8,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(127,'shipping',9,'Botble\\Page\\Models\\Page','','2024-03-05 00:56:09','2024-03-05 00:56:09'),(128,'vintage-denim-jacket',44,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(129,'vintage-denim-jacket',45,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(130,'vintage-denim-jacket',46,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(131,'vintage-denim-jacket',47,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(132,'floral-maxi-dress',48,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(133,'floral-maxi-dress',49,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(134,'floral-maxi-dress',50,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(135,'leather-ankle-boots',51,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(136,'leather-ankle-boots',52,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(137,'leather-ankle-boots',53,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(138,'knit-turtleneck-sweater-digital',54,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(139,'knit-turtleneck-sweater-digital',55,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(140,'knit-turtleneck-sweater-digital',56,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(141,'knit-turtleneck-sweater-digital',57,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(142,'knit-turtleneck-sweater-digital',58,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(143,'classic-aviator-sunglasses',59,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(144,'tailored-wool-blazer',60,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(145,'tailored-wool-blazer',61,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(146,'bohemian-fringe-handbag',62,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(147,'bohemian-fringe-handbag',63,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(148,'bohemian-fringe-handbag',64,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(149,'bohemian-fringe-handbag',65,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(150,'bohemian-fringe-handbag',66,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(151,'silk-scarf-with-geometric-print-digital',67,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(152,'silk-scarf-with-geometric-print-digital',68,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(153,'high-waisted-wide-leg-trousers',69,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(154,'high-waisted-wide-leg-trousers',70,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(155,'high-waisted-wide-leg-trousers',71,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(156,'embroidered-boho-blouse',72,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(157,'embroidered-boho-blouse',73,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(158,'embroidered-boho-blouse',74,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(159,'statement-chunky-necklace',75,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(160,'statement-chunky-necklace',76,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(161,'statement-chunky-necklace',77,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(162,'chic-fedora-hat-digital',78,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(163,'chic-fedora-hat-digital',79,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(164,'strappy-block-heel-sandals',80,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(165,'velvet-evening-gown',81,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(166,'velvet-evening-gown',82,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(167,'quilted-crossbody-bag',83,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(168,'quilted-crossbody-bag',84,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(169,'quilted-crossbody-bag',85,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(170,'distressed-skinny-jeans-digital',86,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(171,'distressed-skinny-jeans-digital',87,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(172,'distressed-skinny-jeans-digital',88,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(173,'lace-up-combat-boots',89,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(174,'lace-up-combat-boots',90,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(175,'cotton-striped-t-shirt-dress',91,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(176,'printed-palazzo-pants',92,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(177,'printed-palazzo-pants',93,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(178,'printed-palazzo-pants',94,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(179,'structured-satchel-bag-digital',95,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(180,'structured-satchel-bag-digital',96,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(181,'structured-satchel-bag-digital',97,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(182,'off-shoulder-ruffle-top',98,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(183,'off-shoulder-ruffle-top',99,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(184,'off-shoulder-ruffle-top',100,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(185,'off-shoulder-ruffle-top',101,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(186,'off-shoulder-ruffle-top',102,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(187,'suede-pointed-toe-pumps',103,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(188,'suede-pointed-toe-pumps',104,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(189,'suede-pointed-toe-pumps',105,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(190,'cropped-cable-knit-sweater',106,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(191,'cropped-cable-knit-sweater',107,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(192,'cropped-cable-knit-sweater',108,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(193,'cropped-cable-knit-sweater',109,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(194,'athleisure-jogger-pants-digital',110,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(195,'athleisure-jogger-pants-digital',111,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(196,'leopard-print-midi-skirt',112,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(197,'leopard-print-midi-skirt',113,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(198,'retro-cat-eye-sunglasses',114,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(199,'retro-cat-eye-sunglasses',115,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(200,'retro-cat-eye-sunglasses',116,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(201,'faux-fur-trimmed-coat',117,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(202,'faux-fur-trimmed-coat',118,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(203,'boho-fringed-kimono-digital',119,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(204,'boho-fringed-kimono-digital',120,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(205,'ruffled-wrap-dress',121,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(206,'ruffled-wrap-dress',122,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(207,'ruffled-wrap-dress',123,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(208,'beaded-evening-clutch',124,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(209,'beaded-evening-clutch',125,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(210,'wide-brim-floppy-hat',126,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(211,'wide-brim-floppy-hat',127,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(212,'wide-brim-floppy-hat',128,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(213,'denim-overall-jumpsuit-digital',129,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(214,'denim-overall-jumpsuit-digital',130,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(215,'embellished-ballet-flats',131,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(216,'pleated-midi-skirt',132,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(217,'pleated-midi-skirt',133,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(218,'pleated-midi-skirt',134,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(219,'pleated-midi-skirt',135,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(220,'velour-tracksuit-set',136,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(221,'velour-tracksuit-set',137,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(222,'geometric-patterned-cardigan-digital',138,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(223,'buckle-detail-ankle-booties',139,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(224,'buckle-detail-ankle-booties',140,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(225,'embroidered-bomber-jacket',141,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(226,'embroidered-bomber-jacket',142,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(227,'cowl-neck-knit-poncho',143,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(228,'cowl-neck-knit-poncho',144,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(229,'cowl-neck-knit-poncho',145,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(230,'cowl-neck-knit-poncho',146,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(231,'cowl-neck-knit-poncho',147,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(232,'chunky-knit-infinity-scarf-digital',148,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(233,'chunky-knit-infinity-scarf-digital',149,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(234,'retro-high-top-sneakers',150,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(235,'retro-high-top-sneakers',151,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(236,'faux-leather-leggings',152,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(237,'faux-leather-leggings',153,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(238,'metallic-pleated-maxi-skirt',154,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(239,'metallic-pleated-maxi-skirt',155,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33'),(240,'metallic-pleated-maxi-skirt',156,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:56:33','2024-03-05 00:56:33');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'General',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:00','2024-03-05 00:56:00'),(2,'Design',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:01','2024-03-05 00:56:01'),(3,'Fashion',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:01','2024-03-05 00:56:01'),(4,'Branding',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:01','2024-03-05 00:56:01'),(5,'Modern',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:01','2024-03-05 00:56:01'),(6,'Nature',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:01','2024-03-05 00:56:01'),(7,'Vintage',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:01','2024-03-05 00:56:01'),(8,'Sunglasses',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:56:01','2024-03-05 00:56:01');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'James Dopli','Thanks for all your efforts and teamwork over the last several months!  Thank you so much','main/users/8.jpg','Developer','published','2024-03-05 00:56:04','2024-03-05 00:56:04'),(2,'Theodore Handle','How you use the city or town name is up to you. All results may be freely used in any work.','main/users/4.jpg','CO Founder','published','2024-03-05 00:56:04','2024-03-05 00:56:04'),(3,'Shahnewaz Sakil','Very happy with our choice to take our daughter to Brave care. The entire team was great! Thank you!','main/users/10.jpg','UI/UX Designer','published','2024-03-05 00:56:04','2024-03-05 00:56:04'),(4,'Albert Flores','Wedding day savior! 5 stars. Their bridal collection is a game-changer. Made me feel like a star.','main/users/8.jpg','Bank of America','published','2024-03-05 00:56:04','2024-03-05 00:56:04');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'lind.zachary@hessel.com',NULL,'$2y$12$kFmeQ6FyBs8uXeApTv/mPO6v.ANUqKYaso3qp1NZWzJv8clW9fEJO',NULL,'2024-03-05 00:55:56','2024-03-05 00:55:56','Candelario','O\'Keefe','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInfoWidget','footer_primary_sidebar','shofy-fashion',0,'{\"id\":\"SiteInfoWidget\",\"logo\":\"main\\/general\\/logo.png\",\"about\":\"Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.\",\"show_social_links\":true}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(2,'CustomMenuWidget','footer_primary_sidebar','shofy-fashion',1,'{\"id\":\"CustomMenuWidget\",\"name\":\"My Account\",\"menu_id\":\"my-account\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(3,'CustomMenuWidget','footer_primary_sidebar','shofy-fashion',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"Information\",\"menu_id\":\"information\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(4,'SiteContactWidget','footer_primary_sidebar','shofy-fashion',4,'{\"id\":\"SiteContactWidget\",\"name\":\"Talk To Us\",\"phone_label\":\"Got Questions? Call us\",\"phone\":\"+670 413 90 762\",\"email\":\"shofy@support.com\",\"address\":\"79 Sleepy Hollow St. Jamaica, New York 1432\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(5,'NewsletterWidget','footer_top_sidebar','shofy-fashion',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe our Newsletter\",\"subtitle\":\"Sale 20% off all store\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(6,'SiteCopyrightWidget','footer_bottom_sidebar','shofy-fashion',1,'{\"id\":\"SiteCopyrightWidget\",\"content\":\"\\u00a9 %y% All rights Reserved.\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(7,'SiteAcceptedPaymentsWidget','footer_bottom_sidebar','shofy-fashion',2,'{\"id\":\"SiteAcceptedPaymentsWidget\",\"name\":\"Accepted Payments\",\"image\":\"main\\/general\\/footer-pay.png\",\"url\":\"#\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(8,'BlogSearchWidget','blog_sidebar','shofy-fashion',1,'{\"id\":\"BlogSearchWidget\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(9,'BlogAboutMeWidget','blog_sidebar','shofy-fashion',2,'{\"id\":\"BlogAboutMeWidget\",\"name\":\"About Me\",\"author_url\":\"\\/blog\",\"author_avatar\":\"main\\/users\\/9.jpg\",\"author_name\":\"Ravi O\'Leigh\",\"author_role\":\"Photographer & Blogger\",\"author_description\":\"Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient\",\"author_signature\":\"main\\/general\\/signature.png\"}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(10,'BlogPostsWidget','blog_sidebar','shofy-fashion',3,'{\"id\":\"BlogPostsWidget\",\"name\":\"Latest Posts\",\"limit\":3}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(11,'BlogCategoriesWidget','blog_sidebar','shofy-fashion',4,'{\"id\":\"BlogCategoriesWidget\",\"name\":\"Categories\",\"number_display\":6}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(12,'BlogTagsWidget','blog_sidebar','shofy-fashion',5,'{\"id\":\"BlogTagsWidget\",\"name\":\"Popular Tags\",\"number_display\":6}','2024-03-05 00:56:09','2024-03-05 00:56:09'),(13,'ProductDetailInfoWidget','product_details_sidebar','shofy-fashion',1,'{\"id\":\"ProductDetailInfoWidget\",\"messages\":[[{\"key\":\"message\",\"value\":\"30 days easy returns\"}],[{\"key\":\"message\",\"value\":\"Order yours before 2.30pm for same day dispatch\"}]],\"description\":\"Guaranteed safe & secure checkout\",\"image\":\"main\\/general\\/footer-pay.png\"}','2024-03-05 00:56:09','2024-03-05 00:56:09');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-05 14:56:34
