-- MySQL dump 10.13  Distrib 8.3.0, for macos14.2 (arm64)
--
-- Host: 127.0.0.1    Database: shofy
-- ------------------------------------------------------
-- Server version	8.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'IRGi4jl2Vu4e7eIP3I9RnpHrpNs59gvL',1,'2024-03-15 03:02:29','2024-03-15 03:02:29','2024-03-15 03:02:29');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Enjoy free shipping on all orders over $99! Shop now and save on delivery costs.',0,NULL,NULL,0,1,'2024-03-15 10:02:38',NULL,1,'2024-03-15 03:02:38','2024-03-15 03:02:38'),(2,'Announcement 2','Need assistance? Our customer support is available 24/7 to help you with any questions or concerns.',0,NULL,NULL,0,1,'2024-03-15 10:02:38',NULL,1,'2024-03-15 03:02:38','2024-03-15 03:02:38'),(3,'Announcement 3','Shop with confidence! We offer a hassle-free 30 days return service for your peace of mind.',0,NULL,NULL,0,1,'2024-03-15 10:02:38',NULL,1,'2024-03-15 03:02:38','2024-03-15 03:02:38');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Crisp Bread &amp; Cake',0,'Non eum laboriosam ad. Delectus rem autem delectus.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(2,'Fashion',0,'Id consequatur ipsam harum voluptas enim. Qui repellendus in amet. Et nihil tempore sint quia illum omnis similique.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(3,'Electronic',0,'Natus nihil amet sint saepe in. Voluptates tempora ut totam sit enim. Deserunt sint harum voluptatum quia reprehenderit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(4,'Commercial',0,'Soluta quibusdam est omnis beatae autem fugit voluptas. Iusto quas et et earum non qui. Et ipsum eligendi quod voluptatem ullam iusto totam. Reiciendis expedita facere esse eum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(5,'Organic Fruits',0,'Rem quibusdam non iure consequatur qui provident repellendus. Vel veniam voluptates esse molestias dolor iusto dignissimos. Ratione impedit non quos. Neque ut eius magni ut qui.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(6,'Ecological',0,'Dignissimos ea in ea nam. Nemo repellendus non id dolor sed et et. Qui magnam provident necessitatibus eos ut. Qui sapiente in ad laboriosam officiis ut. Qui nisi voluptate id.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:02:34','2024-03-15 03:02:34');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Madisyn Gutkowski','dayana.trantow@example.org','(802) 926-0232','956 Schinner Forges Apt. 178\nKleinside, AK 25753-5160','Consequatur velit nemo nemo ad tenetur et.','At hic illum voluptatem placeat dolor debitis dolorem dignissimos. Rem deleniti assumenda sit. Aspernatur sit optio et delectus dolore dolorem est. Ratione omnis voluptas suscipit dolor voluptatibus. Magnam placeat maiores reiciendis earum maiores consectetur nihil. Dignissimos nostrum eveniet molestiae assumenda qui dolores accusantium animi. Maxime molestiae autem aut culpa. Voluptatem tenetur repudiandae quis sed et. Ut aut veniam et magni voluptate voluptas nam.','read','2024-03-15 03:02:32','2024-03-15 03:02:32'),(2,'Nels Morissette','zdickinson@example.org','+14194885393','215 Goldner Plaza\nWest Arjunland, MO 39708','Voluptatem harum dignissimos modi quos.','Error quidem explicabo ut fugit repellat et velit. Qui et animi deserunt sit veritatis reprehenderit reiciendis. Est in aliquam impedit ut sed molestiae. Rerum voluptas consequatur et velit incidunt voluptas. Reiciendis consectetur temporibus corrupti similique sit qui. Molestias omnis adipisci labore quia sed.','unread','2024-03-15 03:02:32','2024-03-15 03:02:32'),(3,'Jaeden Gottlieb','spaucek@example.net','+1.346.779.3143','87228 Cormier Expressway\nLake Kiratown, MS 23825','In totam et omnis inventore.','Ut animi a et sit amet. Ex nisi ut deleniti sed aut. Eum et eius repudiandae fugiat quas et. In et odio laboriosam dolores sed. Aperiam voluptates non sed omnis. Quae minus dolorum et est alias quia nesciunt. Placeat culpa culpa libero hic voluptate. Quod aut enim qui dolorem laboriosam ab. A praesentium repudiandae quaerat soluta. Aperiam non quia doloribus itaque.','unread','2024-03-15 03:02:32','2024-03-15 03:02:32'),(4,'Prof. Jaron Dooley Jr.','asauer@example.net','+1-605-943-1305','2500 Jamaal Expressway\nLake Rhiannonside, PA 46862-8325','Tenetur et voluptas similique similique sint et.','Deleniti repudiandae labore sed nihil sapiente aut numquam. Deserunt in ipsa vitae quia placeat dignissimos. Et quo non quia. Dolores cum beatae maxime adipisci ipsum velit error. Eum ratione adipisci hic modi officiis praesentium eveniet in. Qui non eos ea vitae suscipit et cupiditate. Molestias eveniet facilis dolores eveniet. Ut optio doloremque qui reprehenderit amet cumque rerum repellendus.','unread','2024-03-15 03:02:32','2024-03-15 03:02:32'),(5,'Prof. Adolphus Yost','virginie.bailey@example.net','+1-812-245-3090','276 Weissnat Garden Suite 920\nWest Rolando, ND 74953','Nam fugit repellat consequatur et quod.','Iste libero voluptatibus nisi quibusdam voluptatem veniam accusamus. Animi quod soluta molestiae eum sint nulla. Commodi pariatur consequatur sit alias aperiam enim. Ut corporis quibusdam eveniet sit fugit doloribus. Quos quo iste dolores natus magnam. Molestias eum quisquam minus aut aut hic voluptate neque. Ut dolor in consequuntur omnis deleniti veritatis reprehenderit laboriosam.','read','2024-03-15 03:02:32','2024-03-15 03:02:32'),(6,'Eli Bernhard','armstrong.jeramy@example.org','+1 (815) 454-1801','77992 Jaqueline Cliff\nNorth Madison, SC 47055','Consequatur voluptate ut aliquam nam nobis dolor.','Officia et perferendis nihil aut quisquam sit unde. Iure nihil omnis totam dolor recusandae. Voluptates quo consequuntur eum. Necessitatibus saepe officiis laboriosam atque facere ex. Facere cupiditate voluptatem architecto perspiciatis. Voluptatem sequi dignissimos quia. Laudantium aliquam dolorem molestiae ipsum repellat sint id. Molestias in consectetur eos aliquam. Maxime ad omnis sint culpa praesentium.','read','2024-03-15 03:02:32','2024-03-15 03:02:32'),(7,'Russel Keebler','elyssa.kihn@example.com','+1-989-412-0837','93713 Zaria Summit\nEast Elveraview, IL 05995-5364','Nisi et illo quo.','Tempore corrupti qui enim amet. Ratione ea deleniti et tenetur ratione ipsam. Ex sit labore quaerat dolor officiis delectus dolor. Ab consequatur et ut assumenda quae. Eos corrupti consequatur repellendus aut. Quia hic sed quia sit eum. Nesciunt nobis asperiores reiciendis aliquid minima alias. Voluptas ullam amet similique quaerat consequatur alias quis accusantium. Ea laudantium facilis voluptas dolores quae itaque. Labore sit nemo voluptatem consequuntur repellat et.','read','2024-03-15 03:02:32','2024-03-15 03:02:32'),(8,'Prof. Isaias Abernathy','dibbert.amaya@example.net','(423) 971-3263','97479 Gutmann Brooks Apt. 861\nCarmelomouth, SC 96501-9932','Quos quia et eum sint libero tenetur porro quasi.','Atque nisi libero adipisci exercitationem cum. Ut deserunt aut voluptas praesentium. Enim et beatae voluptatem officia et reprehenderit. Et nemo et temporibus quod exercitationem. Eum quisquam sunt est aut accusantium. Nisi tempore veniam voluptatem quae ex id et. Voluptatem est quasi eius molestias quas. Aut consequatur vero natus ad consectetur. Ad iste sed ut vel velit ut assumenda. Iure ea voluptatem architecto laudantium omnis nam. Eum molestias tenetur natus numquam.','read','2024-03-15 03:02:32','2024-03-15 03:02:32'),(9,'Brisa Kautzer','carlee14@example.net','517-427-6749','75854 McDermott Causeway\nLake Helena, NH 33745','Inventore nihil harum et maxime id odit.','Nemo qui at saepe omnis corporis mollitia. Sed dolor eos voluptate veniam. Debitis accusamus est tenetur adipisci maiores autem maxime. Ut et saepe est doloremque et. Qui adipisci rerum nihil et culpa voluptatem sapiente deleniti. Iusto nostrum dicta dicta occaecati. Quis exercitationem fuga eum illum minima. Dolorem ipsum qui recusandae nihil ab ipsum. Magnam dolores quas vel. Est esse id eos voluptas. Eaque autem sequi veritatis perferendis.','unread','2024-03-15 03:02:32','2024-03-15 03:02:32'),(10,'Dr. Barney Witting','gjones@example.com','1-484-279-3714','60876 Jordyn Spring\nSchmelerfort, LA 17784','Velit placeat iusto tenetur ut ipsam facilis.','Id blanditiis officia odit laborum tempora sit ab. Animi eum sit aut placeat. Natus explicabo dolores non voluptate et non ea. Quia in ea recusandae. Eos ut quis officiis et doloribus vel quibusdam. Ut asperiores ut a quaerat. Harum dignissimos et quas quas temporibus consequatur. Adipisci omnis beatae qui sit. Nulla et consequatur aut aut quisquam ea iusto. Nulla debitis ut aut neque maxime. Omnis eligendi qui est voluptatem.','unread','2024-03-15 03:02:32','2024-03-15 03:02:32');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'FoodPound','New Snacks Release',NULL,NULL,'published',0,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(2,'iTea JSC','Happy Tea 100% Organic. From $29.9',NULL,NULL,'published',1,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(3,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',2,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(4,'Shofy','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',3,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(5,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',4,1,'2024-03-15 03:02:29','2024-03-15 03:02:29');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(2,'EUR','€',0,2,1,0,0.84,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(3,'VND','₫',0,0,2,0,23203,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(4,'NGN','₦',1,2,2,0,895.52,'2024-03-15 03:02:29','2024-03-15 03:02:29');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Valentina Mertz','customer@botble.com','+15519280574','BJ','New Mexico','East Johnathan','50130 Jon Lodge Suite 464',1,1,'2024-03-15 03:02:30','2024-03-15 03:02:30','02625-4634'),(2,'Valentina Mertz','customer@botble.com','+15167043942','AG','Florida','East Melvinaberg','6940 Kling Divide Suite 434',1,0,'2024-03-15 03:02:30','2024-03-15 03:02:30','21659-4436'),(3,'Julien Ward','vendor@botble.com','+19479404215','RE','Missouri','New Isabella','6221 Little Stravenue',2,1,'2024-03-15 03:02:30','2024-03-15 03:02:30','20123'),(4,'Julien Ward','vendor@botble.com','+14259016828','ZW','Virginia','Port Terrilltown','70445 Gorczany Corners Apt. 249',2,0,'2024-03-15 03:02:30','2024-03-15 03:02:30','58400'),(5,'Turner Gusikowski III','daija78@example.com','+17402431497','SS','Illinois','Grahamstad','363 Margarita Crossing Apt. 589',3,1,'2024-03-15 03:02:30','2024-03-15 03:02:30','15890-6829'),(6,'Wallace Sawayn','romaguera.griffin@example.net','+14809060432','PL','West Virginia','North Aureliahaven','58766 Margarita Crest Apt. 371',4,1,'2024-03-15 03:02:31','2024-03-15 03:02:31','71149'),(7,'Golden Labadie','carter.rachael@example.org','+19257761496','RU','Kentucky','North Chloe','301 Vandervort Lane',5,1,'2024-03-15 03:02:31','2024-03-15 03:02:31','75730-7847'),(8,'Al Okuneva','rico24@example.com','+19208007863','SX','Virginia','Vergietown','2018 Nikolaus Causeway Suite 195',6,1,'2024-03-15 03:02:31','2024-03-15 03:02:31','78756'),(9,'Guido Smitham','fschoen@example.net','+12513003504','SL','Nevada','Dimitriborough','585 Mayert Prairie',7,1,'2024-03-15 03:02:31','2024-03-15 03:02:31','39705-3354'),(10,'Mr. Americo Waelchi','oscar41@example.net','+17066954100','UA','Texas','Lake Patsy','681 Assunta Fork Apt. 098',8,1,'2024-03-15 03:02:32','2024-03-15 03:02:32','17321'),(11,'Clark Grant','elisha77@example.org','+16296201050','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',9,1,'2024-03-15 03:02:32','2024-03-15 03:02:32','71594'),(12,'Claire Kunze','erik27@example.net','+16784509249','CO','Georgia','Starkshire','7637 Agustin Glen',10,1,'2024-03-15 03:02:32','2024-03-15 03:02:32','78109');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Valentina Mertz','customer@botble.com','$2y$12$aFF9PvItR.vLOxpGO/6hce2QhuoKryYEMNU8ONnUmxXg/EGyfJS3u','main/customers/8.jpg','1977-02-19','+18547632110',NULL,'2024-03-15 03:02:30','2024-03-15 03:02:35','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(2,'Julien Ward','vendor@botble.com','$2y$12$FtnVikjx50lhNqP93eGZAef1vm6uMY3lZVy1fZbwF/sGLDo9BFZsC','main/customers/6.jpg','1987-02-14','+14253483510',NULL,'2024-03-15 03:02:30','2024-03-15 03:02:36','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(3,'Turner Gusikowski III','daija78@example.com','$2y$12$SIoqgFeHFd5YwJPmx4fgbOH9Nmm0VJEz467MDtrfy4LiAboitJNmi','main/customers/1.jpg','1976-02-18','+17436424206',NULL,'2024-03-15 03:02:30','2024-03-15 03:02:36','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(4,'Wallace Sawayn','romaguera.griffin@example.net','$2y$12$C3fa.2FhoscYGlyR8EET3ektcF9i6kRWl3vpBWJJlRD3OBAFLF/Pe','main/customers/2.jpg','1991-03-13','+16179788164',NULL,'2024-03-15 03:02:31','2024-03-15 03:02:36','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(5,'Golden Labadie','carter.rachael@example.org','$2y$12$brDBgXNMNdOuG1l4Nw2X3Oc/.EYocHEXHnJDMbygvE4oLlqF.8UdK','main/customers/3.jpg','1991-03-08','+16207631421',NULL,'2024-03-15 03:02:31','2024-03-15 03:02:36','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(6,'Al Okuneva','rico24@example.com','$2y$12$9zRnapodsXRRAMcdBAMgUOXQ5StPqib4OHRPyae4evMdmaz.jthw6','main/customers/4.jpg','2003-03-08','+13412795570',NULL,'2024-03-15 03:02:31','2024-03-15 03:02:37','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(7,'Guido Smitham','fschoen@example.net','$2y$12$hFReSdSzME5xfVcitjx0Veg748YjGnio4NRkWIS/nNnK3HeBPRLXq','main/customers/5.jpg','1974-03-04','+18577367206',NULL,'2024-03-15 03:02:31','2024-03-15 03:02:37','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(8,'Mr. Americo Waelchi','oscar41@example.net','$2y$12$tMF8s/CK7JpcWYPGIMa1d.cmsh4putnyJXKmrczAX/P7ZbtNjDidy','main/customers/6.jpg','1986-03-11','+15737121766',NULL,'2024-03-15 03:02:32','2024-03-15 03:02:37','2024-03-15 10:02:30',NULL,1,'2024-03-15 10:02:35','activated',NULL),(9,'Clark Grant','elisha77@example.org','$2y$12$EzB3APKKBYNjcZiaEg2uEeo1Oxqvj3bBHRiztf8/bJy5dr0nyft62','main/customers/7.jpg','1987-03-07','+15313042568',NULL,'2024-03-15 03:02:32','2024-03-15 03:02:37','2024-03-15 10:02:30',NULL,0,NULL,'activated',NULL),(10,'Claire Kunze','erik27@example.net','$2y$12$vYFXDxyt3e.jbaEVaB.kfOnKwYcUq5FqPAdVvX1uoe1Ae2/QOT1SW','main/customers/8.jpg','1993-02-18','+15592374233',NULL,'2024-03-15 03:02:32','2024-03-15 03:02:37','2024-03-15 10:02:30',NULL,0,NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','V24E12Y8OWVV','2024-03-14 10:02:34','2024-03-18 10:02:34',NULL,0,57,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(2,'Discount 2','6LJ5MGQ2UCPV','2024-03-14 10:02:34',NULL,NULL,0,544,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(3,'Discount 3','L7NV1ZHOCST1','2024-03-14 10:02:34','2024-04-01 10:02:34',NULL,0,60,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(4,'Discount 4','GJJEUUWVOTPJ','2024-03-14 10:02:34',NULL,NULL,0,872,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(5,'Discount 5','KG54XBUIVLFS','2024-03-14 10:02:34','2024-03-29 10:02:34',NULL,0,106,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(6,'Discount 6','MFQ94P7PAMJB','2024-03-14 10:02:34',NULL,NULL,0,6,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(7,'Discount 7','TTJKRQ6OJVCE','2024-03-14 10:02:34','2024-03-22 10:02:34',NULL,0,619,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(8,'Discount 8','PHPDSJAMZTPV','2024-03-14 10:02:34',NULL,NULL,0,68,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(9,'Discount 9','V1OS9J7JKTNR','2024-03-14 10:02:34','2024-03-28 10:02:34',NULL,0,677,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL),(10,'Discount 10','VF6EYHZAL20I','2024-03-14 10:02:34','2024-04-11 10:02:34',NULL,0,89,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL,NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,291.58,10,4),(1,2,619.2,17,3),(1,3,400.95,13,2),(1,4,1100.3436,7,4),(1,5,168.84,19,4),(1,6,210.68,17,3),(1,7,239.97,9,4),(1,8,1241.912,7,1),(1,9,1025.75,12,2),(1,10,1715.4,7,5);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2024-04-06 00:00:00','published','2024-03-15 03:02:42','2024-03-15 03:02:42');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(1,2,'2 Year',10,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(1,3,'3 Year',20,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(2,4,'4GB',0,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(2,5,'8GB',10,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(2,6,'16GB',20,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(3,7,'Core i5',0,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(3,8,'Core i7',10,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(3,9,'Core i9',20,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(4,10,'128GB',0,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(4,11,'256GB',10,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(4,12,'512GB',20,9999,0,'2024-03-15 03:02:34','2024-03-15 03:02:34');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2024-03-15 03:02:34','2024-03-15 03:02:34');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
INSERT INTO `ec_invoice_items` VALUES (1,1,'Botble\\Ecommerce\\Models\\Product',92,'Off-Shoulder Ruffle Top',NULL,'beauty/products/product-7.png',1,2161.00,2161.00,0.00,0.00,2161.00,'{\"sku\":\"OA-196-A0-A4\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(2,2,'Botble\\Ecommerce\\Models\\Product',118,'Wide Brim Floppy Hat',NULL,'beauty/products/product-8.png',2,1883.00,3766.00,0.00,0.00,3766.00,'{\"sku\":\"9G-113-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(3,3,'Botble\\Ecommerce\\Models\\Product',123,'Denim Overall Jumpsuit (Digital)',NULL,'beauty/products/product-2.png',3,2124.00,6372.00,0.00,0.00,6372.00,'{\"sku\":\"NI-190-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(4,4,'Botble\\Ecommerce\\Models\\Product',125,'Embellished Ballet Flats',NULL,'beauty/products/product-5.png',3,1351.00,4053.00,0.00,0.00,4053.00,'{\"sku\":\"BY-172-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:45','2024-03-15 03:02:45'),(5,5,'Botble\\Ecommerce\\Models\\Product',49,'Leather Ankle Boots',NULL,'beauty/products/product-2.png',2,1215.00,2430.00,0.00,0.00,2430.00,'{\"sku\":\"5D-197-A0\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:02:45','2024-03-15 03:02:45'),(6,6,'Botble\\Ecommerce\\Models\\Product',82,'Cotton Striped T-Shirt Dress',NULL,'beauty/products/product-8.png',3,373.00,1119.00,0.00,0.00,1119.00,'{\"sku\":\"DV-187-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:02:45','2024-03-15 03:02:45'),(7,7,'Botble\\Ecommerce\\Models\\Product',114,'Boho Fringed Kimono (Digital)',NULL,'beauty/products/product-2.png',3,635.00,1905.00,0.00,0.00,1905.00,'{\"sku\":\"WS-190-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-15 03:02:45','2024-03-15 03:02:45'),(8,8,'Botble\\Ecommerce\\Models\\Product',45,'Vintage Denim Jacket',NULL,'beauty/products/product-7.png',1,478.00,478.00,0.00,0.00,478.00,'{\"sku\":\"CN-192-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-15 03:02:45','2024-03-15 03:02:45'),(9,9,'Botble\\Ecommerce\\Models\\Product',111,'Boho Fringed Kimono (Digital)',NULL,'beauty/products/product-4.png',3,635.00,1905.00,0.00,0.00,1905.00,'{\"sku\":\"WS-190-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(10,9,'Botble\\Ecommerce\\Models\\Product',142,'Retro High-Top Sneakers',NULL,'beauty/products/product-8.png',3,319.00,957.00,0.00,0.00,957.00,'{\"sku\":\"OG-141-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(11,9,'Botble\\Ecommerce\\Models\\Product',143,'Retro High-Top Sneakers',NULL,'beauty/products/product-5.png',3,319.00,957.00,0.00,0.00,957.00,'{\"sku\":\"OG-141-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(12,10,'Botble\\Ecommerce\\Models\\Product',68,'Chic Fedora Hat (Digital)',NULL,'beauty/products/product-6.png',1,1365.00,1365.00,0.00,0.00,1365.00,'{\"sku\":\"YT-191-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(13,10,'Botble\\Ecommerce\\Models\\Product',124,'Denim Overall Jumpsuit (Digital)',NULL,'beauty/products/product-8.png',1,2124.00,2124.00,0.00,0.00,2124.00,'{\"sku\":\"NI-190-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(14,11,'Botble\\Ecommerce\\Models\\Product',70,'Strappy Block Heel Sandals',NULL,'beauty/products/product-1.png',3,2320.00,6960.00,0.00,0.00,6960.00,'{\"sku\":\"PI-148-A0\",\"attributes\":\"(Color: Green, Size: XXL)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(15,12,'Botble\\Ecommerce\\Models\\Product',132,'Buckle Detail Ankle Booties',NULL,'beauty/products/product-2.png',1,707.00,707.00,0.00,0.00,707.00,'{\"sku\":\"JS-162-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(16,13,'Botble\\Ecommerce\\Models\\Product',141,'Retro High-Top Sneakers',NULL,'beauty/products/product-6.png',1,319.00,319.00,0.00,0.00,319.00,'{\"sku\":\"OG-141-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:46','2024-03-15 03:02:46'),(17,14,'Botble\\Ecommerce\\Models\\Product',146,'Faux Leather Leggings',NULL,'beauty/products/product-6.png',2,986.00,1972.00,0.00,0.00,1972.00,'{\"sku\":\"3G-196-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:47','2024-03-15 03:02:47'),(18,15,'Botble\\Ecommerce\\Models\\Product',51,'Knit Turtleneck Sweater (Digital)',NULL,'beauty/products/product-4.png',1,1908.00,1908.00,0.00,0.00,1908.00,'{\"sku\":\"F1-160-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-15 03:02:47','2024-03-15 03:02:47'),(19,16,'Botble\\Ecommerce\\Models\\Product',107,'Faux Fur Trimmed Coat',NULL,'beauty/products/product-2.png',1,1792.00,1792.00,0.00,0.00,1792.00,'{\"sku\":\"2O-188-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:47','2024-03-15 03:02:47'),(20,16,'Botble\\Ecommerce\\Models\\Product',121,'Denim Overall Jumpsuit (Digital)',NULL,'beauty/products/product-5.png',1,2124.00,2124.00,0.00,0.00,2124.00,'{\"sku\":\"NI-190-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:47','2024-03-15 03:02:47'),(21,17,'Botble\\Ecommerce\\Models\\Product',50,'Knit Turtleneck Sweater (Digital)',NULL,'beauty/products/product-5.png',1,1908.00,1908.00,0.00,0.00,1908.00,'{\"sku\":\"F1-160-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}','2024-03-15 03:02:47','2024-03-15 03:02:47'),(22,18,'Botble\\Ecommerce\\Models\\Product',115,'Ruffled Wrap Dress',NULL,'beauty/products/product-3.png',3,2317.00,6951.00,0.00,0.00,6951.00,'{\"sku\":\"H6-129-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-15 03:02:48','2024-03-15 03:02:48'),(23,19,'Botble\\Ecommerce\\Models\\Product',121,'Denim Overall Jumpsuit (Digital)',NULL,'beauty/products/product-5.png',3,2124.00,6372.00,0.00,0.00,6372.00,'{\"sku\":\"NI-190-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:48','2024-03-15 03:02:48'),(24,20,'Botble\\Ecommerce\\Models\\Product',141,'Retro High-Top Sneakers',NULL,'beauty/products/product-6.png',2,319.00,638.00,0.00,0.00,638.00,'{\"sku\":\"OG-141-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:48','2024-03-15 03:02:48'),(25,21,'Botble\\Ecommerce\\Models\\Product',76,'Quilted Crossbody Bag',NULL,'beauty/products/product-1.png',3,919.00,2757.00,0.00,0.00,2757.00,'{\"sku\":\"JX-101-A0\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:02:48','2024-03-15 03:02:48'),(26,22,'Botble\\Ecommerce\\Models\\Product',127,'Velour Tracksuit Set',NULL,'beauty/products/product-8.png',3,1062.00,3186.00,0.00,0.00,3186.00,'{\"sku\":\"JG-149-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:48','2024-03-15 03:02:48'),(27,23,'Botble\\Ecommerce\\Models\\Product',81,'Lace-Up Combat Boots',NULL,'beauty/products/product-8.png',2,1145.00,2290.00,0.00,0.00,2290.00,'{\"sku\":\"DX-154-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:02:49','2024-03-15 03:02:49'),(28,24,'Botble\\Ecommerce\\Models\\Product',133,'Embroidered Bomber Jacket',NULL,'beauty/products/product-8.png',2,1862.00,3724.00,0.00,0.00,3724.00,'{\"sku\":\"RU-193-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:49','2024-03-15 03:02:49'),(29,25,'Botble\\Ecommerce\\Models\\Product',145,'Faux Leather Leggings',NULL,'beauty/products/product-2.png',2,986.00,1972.00,0.00,0.00,1972.00,'{\"sku\":\"3G-196-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:49','2024-03-15 03:02:49'),(30,26,'Botble\\Ecommerce\\Models\\Product',45,'Vintage Denim Jacket',NULL,'beauty/products/product-7.png',3,478.00,1434.00,0.00,0.00,1434.00,'{\"sku\":\"CN-192-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-15 03:02:49','2024-03-15 03:02:49'),(31,27,'Botble\\Ecommerce\\Models\\Product',117,'Wide Brim Floppy Hat',NULL,'beauty/products/product-1.png',1,1883.00,1883.00,0.00,0.00,1883.00,'{\"sku\":\"9G-113-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-15 03:02:49','2024-03-15 03:02:49'),(32,28,'Botble\\Ecommerce\\Models\\Product',148,'Metallic Pleated Maxi Skirt',NULL,'beauty/products/product-7.png',1,2418.00,2418.00,0.00,0.00,2418.00,'{\"sku\":\"3F-139-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:50','2024-03-15 03:02:50'),(33,29,'Botble\\Ecommerce\\Models\\Product',78,'Quilted Crossbody Bag',NULL,'beauty/products/product-8.png',3,919.00,2757.00,0.00,0.00,2757.00,'{\"sku\":\"JX-101-A0-A2\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-15 03:02:50','2024-03-15 03:02:50'),(34,30,'Botble\\Ecommerce\\Models\\Product',105,'Retro Cat-Eye Sunglasses',NULL,'beauty/products/product-8.png',2,1825.00,3650.00,0.00,0.00,3650.00,'{\"sku\":\"2R-104-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:02:50','2024-03-15 03:02:50'),(35,31,'Botble\\Ecommerce\\Models\\Product',143,'Retro High-Top Sneakers',NULL,'beauty/products/product-5.png',2,319.00,638.00,0.00,0.00,638.00,'{\"sku\":\"OG-141-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}','2024-03-15 03:02:50','2024-03-15 03:02:50'),(36,32,'Botble\\Ecommerce\\Models\\Product',61,'High-Waisted Wide Leg Trousers',NULL,'beauty/products/product-8.png',1,1865.00,1865.00,0.00,0.00,1865.00,'{\"sku\":\"P7-111-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:02:50','2024-03-15 03:02:50'),(37,33,'Botble\\Ecommerce\\Models\\Product',93,'Suede Pointed-Toe Pumps',NULL,'beauty/products/product-6.png',2,449.00,898.00,0.00,0.00,898.00,'{\"sku\":\"PC-171-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-15 03:02:51','2024-03-15 03:02:51'),(38,33,'Botble\\Ecommerce\\Models\\Product',105,'Retro Cat-Eye Sunglasses',NULL,'beauty/products/product-8.png',3,1825.00,5475.00,0.00,0.00,5475.00,'{\"sku\":\"2R-104-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:02:51','2024-03-15 03:02:51'),(39,34,'Botble\\Ecommerce\\Models\\Product',82,'Cotton Striped T-Shirt Dress',NULL,'beauty/products/product-8.png',3,373.00,1119.00,0.00,0.00,1119.00,'{\"sku\":\"DV-187-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:02:51','2024-03-15 03:02:51'),(40,35,'Botble\\Ecommerce\\Models\\Product',88,'Off-Shoulder Ruffle Top',NULL,'beauty/products/product-1.png',2,2161.00,4322.00,0.00,0.00,4322.00,'{\"sku\":\"OA-196-A0\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-15 03:02:51','2024-03-15 03:02:51'),(41,36,'Botble\\Ecommerce\\Models\\Product',44,'Vintage Denim Jacket',NULL,'beauty/products/product-4.png',1,478.00,478.00,0.00,0.00,478.00,'{\"sku\":\"CN-192-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:02:51','2024-03-15 03:02:51'),(42,37,'Botble\\Ecommerce\\Models\\Product',61,'High-Waisted Wide Leg Trousers',NULL,'beauty/products/product-8.png',2,1865.00,3730.00,0.00,0.00,3730.00,'{\"sku\":\"P7-111-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:02:52','2024-03-15 03:02:52'),(43,38,'Botble\\Ecommerce\\Models\\Product',71,'Strappy Block Heel Sandals',NULL,'beauty/products/product-3.png',2,2320.00,4640.00,0.00,0.00,4640.00,'{\"sku\":\"PI-148-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:02:52','2024-03-15 03:02:52'),(44,39,'Botble\\Ecommerce\\Models\\Product',136,'Cowl Neck Knit Poncho',NULL,'beauty/products/product-6.png',1,1452.00,1452.00,0.00,0.00,1452.00,'{\"sku\":\"GY-193-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}','2024-03-15 03:02:52','2024-03-15 03:02:52'),(45,40,'Botble\\Ecommerce\\Models\\Product',81,'Lace-Up Combat Boots',NULL,'beauty/products/product-8.png',3,1145.00,3435.00,0.00,0.00,3435.00,'{\"sku\":\"DX-154-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:02:52','2024-03-15 03:02:52'),(46,41,'Botble\\Ecommerce\\Models\\Product',119,'Wide Brim Floppy Hat',NULL,'beauty/products/product-5.png',2,1883.00,3766.00,0.00,0.00,3766.00,'{\"sku\":\"9G-113-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}','2024-03-15 03:02:52','2024-03-15 03:02:52'),(47,42,'Botble\\Ecommerce\\Models\\Product',125,'Embellished Ballet Flats',NULL,'beauty/products/product-5.png',1,1351.00,1351.00,0.00,0.00,1351.00,'{\"sku\":\"BY-172-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:53','2024-03-15 03:02:53'),(48,43,'Botble\\Ecommerce\\Models\\Product',49,'Leather Ankle Boots',NULL,'beauty/products/product-2.png',3,1215.00,3645.00,0.00,0.00,3645.00,'{\"sku\":\"5D-197-A0\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:02:53','2024-03-15 03:02:53'),(49,44,'Botble\\Ecommerce\\Models\\Product',101,'Leopard Print Midi Skirt',NULL,'beauty/products/product-5.png',1,890.00,890.00,0.00,0.00,890.00,'{\"sku\":\"QM-167-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-15 03:02:53','2024-03-15 03:02:53'),(50,45,'Botble\\Ecommerce\\Models\\Product',107,'Faux Fur Trimmed Coat',NULL,'beauty/products/product-2.png',3,1792.00,5376.00,0.00,0.00,5376.00,'{\"sku\":\"2O-188-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:53','2024-03-15 03:02:53'),(51,46,'Botble\\Ecommerce\\Models\\Product',135,'Embroidered Bomber Jacket',NULL,'beauty/products/product-5.png',1,1862.00,1862.00,0.00,0.00,1862.00,'{\"sku\":\"RU-193-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:53','2024-03-15 03:02:53'),(52,47,'Botble\\Ecommerce\\Models\\Product',55,'Tailored Wool Blazer',NULL,'beauty/products/product-2.png',1,458.00,458.00,0.00,0.00,458.00,'{\"sku\":\"AC-123-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}','2024-03-15 03:02:53','2024-03-15 03:02:53'),(53,48,'Botble\\Ecommerce\\Models\\Product',75,'Velvet Evening Gown',NULL,'beauty/products/product-2.png',1,1233.00,1233.00,0.00,0.00,1233.00,'{\"sku\":\"VD-145-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-15 03:02:54','2024-03-15 03:02:54'),(54,49,'Botble\\Ecommerce\\Models\\Product',128,'Velour Tracksuit Set',NULL,'beauty/products/product-6.png',1,1062.00,1062.00,0.00,0.00,1062.00,'{\"sku\":\"JG-149-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:55','2024-03-15 03:02:55'),(55,50,'Botble\\Ecommerce\\Models\\Product',113,'Boho Fringed Kimono (Digital)',NULL,'beauty/products/product-8.png',1,635.00,635.00,0.00,0.00,635.00,'{\"sku\":\"WS-190-A0-A2\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}','2024-03-15 03:02:56','2024-03-15 03:02:56'),(56,51,'Botble\\Ecommerce\\Models\\Product',120,'Wide Brim Floppy Hat',NULL,'beauty/products/product-4.png',3,1883.00,5649.00,0.00,0.00,5649.00,'{\"sku\":\"9G-113-A0-A3\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}','2024-03-15 03:02:56','2024-03-15 03:02:56'),(57,52,'Botble\\Ecommerce\\Models\\Product',60,'High-Waisted Wide Leg Trousers',NULL,'beauty/products/product-4.png',1,1865.00,1865.00,0.00,0.00,1865.00,'{\"sku\":\"P7-111-A0\",\"attributes\":\"(Color: Blue, Size: M)\"}','2024-03-15 03:02:56','2024-03-15 03:02:56'),(58,53,'Botble\\Ecommerce\\Models\\Product',82,'Cotton Striped T-Shirt Dress',NULL,'beauty/products/product-8.png',1,373.00,373.00,0.00,0.00,373.00,'{\"sku\":\"DV-187-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:02:56','2024-03-15 03:02:56'),(59,53,'Botble\\Ecommerce\\Models\\Product',98,'Cropped Cable Knit Sweater',NULL,'beauty/products/product-8.png',3,699.00,2097.00,0.00,0.00,2097.00,'{\"sku\":\"F7-126-A0-A2\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:02:56','2024-03-15 03:02:56'),(60,54,'Botble\\Ecommerce\\Models\\Product',125,'Embellished Ballet Flats',NULL,'beauty/products/product-5.png',2,1351.00,2702.00,0.00,0.00,2702.00,'{\"sku\":\"BY-172-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:56','2024-03-15 03:02:56'),(61,55,'Botble\\Ecommerce\\Models\\Product',99,'Athleisure Jogger Pants (Digital)',NULL,'beauty/products/product-7.png',1,1452.00,1452.00,0.00,0.00,1452.00,'{\"sku\":\"EO-165-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-15 03:02:57','2024-03-15 03:02:57'),(62,56,'Botble\\Ecommerce\\Models\\Product',121,'Denim Overall Jumpsuit (Digital)',NULL,'beauty/products/product-5.png',1,2124.00,2124.00,0.00,0.00,2124.00,'{\"sku\":\"NI-190-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:57','2024-03-15 03:02:57'),(63,57,'Botble\\Ecommerce\\Models\\Product',141,'Retro High-Top Sneakers',NULL,'beauty/products/product-6.png',1,319.00,319.00,0.00,0.00,319.00,'{\"sku\":\"OG-141-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:57','2024-03-15 03:02:57');
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
INSERT INTO `ec_invoices` VALUES (1,'Botble\\Ecommerce\\Models\\Order',1,'INV-1','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,2161.00,0.00,0.00,0.00,'1','default',NULL,NULL,2161.00,NULL,1,'pending',NULL,'2024-03-01 19:02:44','2024-03-15 03:02:44'),(2,'Botble\\Ecommerce\\Models\\Order',2,'INV-2','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3766.00,0.00,0.00,0.00,'1','default',NULL,NULL,3766.00,NULL,2,'completed','2024-03-15 03:02:44','2024-02-27 11:02:44','2024-03-15 03:02:44'),(3,'Botble\\Ecommerce\\Models\\Order',3,'INV-3','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,6372.00,0.00,0.00,0.00,NULL,'',NULL,NULL,6372.00,NULL,3,'completed','2024-03-15 03:02:44','2024-03-11 19:02:44','2024-03-15 03:02:44'),(4,'Botble\\Ecommerce\\Models\\Order',4,'INV-4','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,4053.00,0.00,0.00,0.00,'1','default',NULL,NULL,4053.00,NULL,4,'pending',NULL,'2024-02-27 11:02:45','2024-03-15 03:02:45'),(5,'Botble\\Ecommerce\\Models\\Order',5,'INV-5','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,2430.00,0.00,0.00,0.00,'1','default',NULL,NULL,2430.00,NULL,5,'completed','2024-03-15 03:02:45','2024-03-11 23:02:45','2024-03-15 03:02:45'),(6,'Botble\\Ecommerce\\Models\\Order',6,'INV-6','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,1119.00,0.00,0.00,0.00,'1','default',NULL,NULL,1119.00,NULL,6,'pending',NULL,'2024-03-13 13:02:45','2024-03-15 03:02:45'),(7,'Botble\\Ecommerce\\Models\\Order',7,'INV-7','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,1905.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1905.00,NULL,7,'completed','2024-03-15 03:02:45','2024-03-11 23:02:45','2024-03-15 03:02:45'),(8,'Botble\\Ecommerce\\Models\\Order',8,'INV-8','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,478.00,0.00,0.00,0.00,'1','default',NULL,NULL,478.00,NULL,8,'pending',NULL,'2024-03-12 03:02:45','2024-03-15 03:02:45'),(9,'Botble\\Ecommerce\\Models\\Order',9,'INV-9','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,3819.00,0.00,0.00,0.00,'1','default',NULL,NULL,3819.00,NULL,9,'pending',NULL,'2024-03-03 03:02:45','2024-03-15 03:02:46'),(10,'Botble\\Ecommerce\\Models\\Order',10,'INV-10','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3489.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3489.00,NULL,10,'pending',NULL,'2024-03-08 01:02:46','2024-03-15 03:02:46'),(11,'Botble\\Ecommerce\\Models\\Order',11,'INV-11','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,6960.00,0.00,0.00,0.00,'1','default',NULL,NULL,6960.00,NULL,11,'completed','2024-03-15 03:02:46','2024-03-02 09:02:46','2024-03-15 03:02:46'),(12,'Botble\\Ecommerce\\Models\\Order',12,'INV-12','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,707.00,0.00,0.00,0.00,'1','default',NULL,NULL,707.00,NULL,12,'completed','2024-03-15 03:02:46','2024-03-13 17:02:46','2024-03-15 03:02:46'),(13,'Botble\\Ecommerce\\Models\\Order',13,'INV-13','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,319.00,0.00,0.00,0.00,'1','default',NULL,NULL,319.00,NULL,13,'completed','2024-03-15 03:02:46','2024-03-11 03:02:46','2024-03-15 03:02:46'),(14,'Botble\\Ecommerce\\Models\\Order',14,'INV-14','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1972.00,0.00,0.00,0.00,'1','default',NULL,NULL,1972.00,NULL,14,'completed','2024-03-15 03:02:47','2024-03-03 03:02:47','2024-03-15 03:02:47'),(15,'Botble\\Ecommerce\\Models\\Order',15,'INV-15','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1908.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1908.00,NULL,15,'completed','2024-03-15 03:02:47','2024-03-08 21:02:47','2024-03-15 03:02:47'),(16,'Botble\\Ecommerce\\Models\\Order',16,'INV-16','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3916.00,0.00,0.00,0.00,'1','default',NULL,NULL,3916.00,NULL,16,'completed','2024-03-15 03:02:47','2024-03-11 09:02:47','2024-03-15 03:02:47'),(17,'Botble\\Ecommerce\\Models\\Order',17,'INV-17','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1908.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1908.00,NULL,17,'completed','2024-03-15 03:02:47','2024-03-11 15:02:47','2024-03-15 03:02:47'),(18,'Botble\\Ecommerce\\Models\\Order',18,'INV-18','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,6951.00,0.00,0.00,0.00,'1','default',NULL,NULL,6951.00,NULL,18,'completed','2024-03-15 03:02:48','2024-03-11 15:02:48','2024-03-15 03:02:48'),(19,'Botble\\Ecommerce\\Models\\Order',19,'INV-19','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,6372.00,0.00,0.00,0.00,NULL,'',NULL,NULL,6372.00,NULL,19,'completed','2024-03-15 03:02:48','2024-03-04 15:02:48','2024-03-15 03:02:48'),(20,'Botble\\Ecommerce\\Models\\Order',20,'INV-20','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,638.00,0.00,0.00,0.00,'1','default',NULL,NULL,638.00,NULL,20,'pending',NULL,'2024-03-12 19:02:48','2024-03-15 03:02:48'),(21,'Botble\\Ecommerce\\Models\\Order',21,'INV-21','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,2757.00,0.00,0.00,0.00,'1','default',NULL,NULL,2757.00,NULL,21,'completed','2024-03-15 03:02:48','2024-03-14 01:02:48','2024-03-15 03:02:48'),(22,'Botble\\Ecommerce\\Models\\Order',22,'INV-22','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3186.00,0.00,0.00,0.00,'1','default',NULL,NULL,3186.00,NULL,22,'pending',NULL,'2024-03-07 13:02:48','2024-03-15 03:02:48'),(23,'Botble\\Ecommerce\\Models\\Order',23,'INV-23','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,2290.00,0.00,0.00,0.00,'1','default',NULL,NULL,2290.00,NULL,23,'pending',NULL,'2024-03-08 03:02:49','2024-03-15 03:02:49'),(24,'Botble\\Ecommerce\\Models\\Order',24,'INV-24','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3724.00,0.00,0.00,0.00,'1','default',NULL,NULL,3724.00,NULL,24,'pending',NULL,'2024-03-10 03:02:49','2024-03-15 03:02:49'),(25,'Botble\\Ecommerce\\Models\\Order',25,'INV-25','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1972.00,0.00,0.00,0.00,'1','default',NULL,NULL,1972.00,NULL,25,'completed','2024-03-15 03:02:49','2024-03-12 03:02:49','2024-03-15 03:02:49'),(26,'Botble\\Ecommerce\\Models\\Order',26,'INV-26','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1434.00,0.00,0.00,0.00,'1','default',NULL,NULL,1434.00,NULL,26,'completed','2024-03-15 03:02:49','2024-03-14 05:02:49','2024-03-15 03:02:49'),(27,'Botble\\Ecommerce\\Models\\Order',27,'INV-27','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1883.00,0.00,0.00,0.00,'1','default',NULL,NULL,1883.00,NULL,27,'completed','2024-03-15 03:02:49','2024-03-07 19:02:49','2024-03-15 03:02:49'),(28,'Botble\\Ecommerce\\Models\\Order',28,'INV-28','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,2418.00,0.00,0.00,0.00,'1','default',NULL,NULL,2418.00,NULL,28,'completed','2024-03-15 03:02:50','2024-03-13 07:02:50','2024-03-15 03:02:50'),(29,'Botble\\Ecommerce\\Models\\Order',29,'INV-29','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,2757.00,0.00,0.00,0.00,'1','default',NULL,NULL,2757.00,NULL,29,'pending',NULL,'2024-03-08 11:02:50','2024-03-15 03:02:50'),(30,'Botble\\Ecommerce\\Models\\Order',30,'INV-30','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3650.00,0.00,0.00,0.00,'1','default',NULL,NULL,3650.00,NULL,30,'pending',NULL,'2024-03-08 11:02:50','2024-03-15 03:02:50'),(31,'Botble\\Ecommerce\\Models\\Order',31,'INV-31','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,638.00,0.00,0.00,0.00,'1','default',NULL,NULL,638.00,NULL,31,'completed','2024-03-15 03:02:50','2024-03-08 11:02:50','2024-03-15 03:02:50'),(32,'Botble\\Ecommerce\\Models\\Order',32,'INV-32','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,1865.00,0.00,0.00,0.00,'1','default',NULL,NULL,1865.00,NULL,32,'pending',NULL,'2024-03-12 21:02:50','2024-03-15 03:02:50'),(33,'Botble\\Ecommerce\\Models\\Order',33,'INV-33','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,6373.00,0.00,0.00,0.00,'1','default',NULL,NULL,6373.00,NULL,33,'completed','2024-03-15 03:02:51','2024-03-13 15:02:51','2024-03-15 03:02:51'),(34,'Botble\\Ecommerce\\Models\\Order',34,'INV-34','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,1119.00,0.00,0.00,0.00,'1','default',NULL,NULL,1119.00,NULL,34,'pending',NULL,'2024-03-14 11:02:51','2024-03-15 03:02:51'),(35,'Botble\\Ecommerce\\Models\\Order',35,'INV-35','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,4322.00,0.00,0.00,0.00,'1','default',NULL,NULL,4322.00,NULL,35,'completed','2024-03-15 03:02:51','2024-03-14 11:02:51','2024-03-15 03:02:51'),(36,'Botble\\Ecommerce\\Models\\Order',36,'INV-36','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,478.00,0.00,0.00,0.00,'1','default',NULL,NULL,478.00,NULL,36,'pending',NULL,'2024-03-12 05:02:51','2024-03-15 03:02:51'),(37,'Botble\\Ecommerce\\Models\\Order',37,'INV-37','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3730.00,0.00,0.00,0.00,'1','default',NULL,NULL,3730.00,NULL,37,'pending',NULL,'2024-03-13 09:02:52','2024-03-15 03:02:52'),(38,'Botble\\Ecommerce\\Models\\Order',38,'INV-38','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,4640.00,0.00,0.00,0.00,'1','default',NULL,NULL,4640.00,NULL,38,'pending',NULL,'2024-03-12 19:02:52','2024-03-15 03:02:52'),(39,'Botble\\Ecommerce\\Models\\Order',39,'INV-39','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1452.00,0.00,0.00,0.00,'1','default',NULL,NULL,1452.00,NULL,39,'completed','2024-03-15 03:02:52','2024-03-13 09:02:52','2024-03-15 03:02:52'),(40,'Botble\\Ecommerce\\Models\\Order',40,'INV-40','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,3435.00,0.00,0.00,0.00,'1','default',NULL,NULL,3435.00,NULL,40,'completed','2024-03-15 03:02:52','2024-03-11 15:02:52','2024-03-15 03:02:52'),(41,'Botble\\Ecommerce\\Models\\Order',41,'INV-41','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,3766.00,0.00,0.00,0.00,'1','default',NULL,NULL,3766.00,NULL,41,'completed','2024-03-15 03:02:52','2024-03-10 15:02:52','2024-03-15 03:02:52'),(42,'Botble\\Ecommerce\\Models\\Order',42,'INV-42','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,1351.00,0.00,0.00,0.00,'1','default',NULL,NULL,1351.00,NULL,42,'completed','2024-03-15 03:02:53','2024-03-10 03:02:53','2024-03-15 03:02:53'),(43,'Botble\\Ecommerce\\Models\\Order',43,'INV-43','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,3645.00,0.00,0.00,0.00,'1','default',NULL,NULL,3645.00,NULL,43,'pending',NULL,'2024-03-13 21:02:53','2024-03-15 03:02:53'),(44,'Botble\\Ecommerce\\Models\\Order',44,'INV-44','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,890.00,0.00,0.00,0.00,'1','default',NULL,NULL,890.00,NULL,44,'pending',NULL,'2024-03-12 05:02:53','2024-03-15 03:02:53'),(45,'Botble\\Ecommerce\\Models\\Order',45,'INV-45','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,5376.00,0.00,0.00,0.00,'1','default',NULL,NULL,5376.00,NULL,45,'completed','2024-03-15 03:02:53','2024-03-10 23:02:53','2024-03-15 03:02:53'),(46,'Botble\\Ecommerce\\Models\\Order',46,'INV-46','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1862.00,0.00,0.00,0.00,'1','default',NULL,NULL,1862.00,NULL,46,'completed','2024-03-15 03:02:53','2024-03-13 11:02:53','2024-03-15 03:02:53'),(47,'Botble\\Ecommerce\\Models\\Order',47,'INV-47','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,458.00,0.00,0.00,0.00,'1','default',NULL,NULL,458.00,NULL,47,'completed','2024-03-15 03:02:53','2024-03-14 03:02:53','2024-03-15 03:02:53'),(48,'Botble\\Ecommerce\\Models\\Order',48,'INV-48','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1233.00,0.00,0.00,0.00,'1','default',NULL,NULL,1233.00,NULL,48,'pending',NULL,'2024-03-12 03:02:54','2024-03-15 03:02:54'),(49,'Botble\\Ecommerce\\Models\\Order',49,'INV-49','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1062.00,0.00,0.00,0.00,'1','default',NULL,NULL,1062.00,NULL,49,'completed','2024-03-15 03:02:55','2024-03-14 19:02:55','2024-03-15 03:02:55'),(50,'Botble\\Ecommerce\\Models\\Order',50,'INV-50','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,635.00,0.00,0.00,0.00,NULL,'',NULL,NULL,635.00,NULL,50,'completed','2024-03-15 03:02:56','2024-03-13 21:02:55','2024-03-15 03:02:56'),(51,'Botble\\Ecommerce\\Models\\Order',51,'INV-51','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,5649.00,0.00,0.00,0.00,'1','default',NULL,NULL,5649.00,NULL,51,'completed','2024-03-15 03:02:56','2024-03-14 15:02:56','2024-03-15 03:02:56'),(52,'Botble\\Ecommerce\\Models\\Order',52,'INV-52','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,1865.00,0.00,0.00,0.00,'1','default',NULL,NULL,1865.00,NULL,52,'pending',NULL,'2024-03-13 11:02:56','2024-03-15 03:02:56'),(53,'Botble\\Ecommerce\\Models\\Order',53,'INV-53','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,2470.00,0.00,0.00,0.00,'1','default',NULL,NULL,2470.00,NULL,53,'completed','2024-03-15 03:02:56','2024-03-13 15:02:56','2024-03-15 03:02:56'),(54,'Botble\\Ecommerce\\Models\\Order',54,'INV-54','Claire Kunze','',NULL,'erik27@example.net','+16784509249','7637 Agustin Glen, Starkshire, Georgia, CO',NULL,2702.00,0.00,0.00,0.00,'1','default',NULL,NULL,2702.00,NULL,54,'pending',NULL,'2024-03-13 11:02:56','2024-03-15 03:02:56'),(55,'Botble\\Ecommerce\\Models\\Order',55,'INV-55','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,1452.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1452.00,NULL,55,'pending',NULL,'2024-03-14 19:02:57','2024-03-15 03:02:57'),(56,'Botble\\Ecommerce\\Models\\Order',56,'INV-56','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,2124.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2124.00,NULL,56,'pending',NULL,'2024-03-15 01:02:57','2024-03-15 03:02:57'),(57,'Botble\\Ecommerce\\Models\\Order',57,'INV-57','Clark Grant','',NULL,'elisha77@example.org','+16296201050','45814 Daugherty Mews Suite 572, Morarhaven, Ohio, WS',NULL,319.00,0.00,0.00,0.00,'1','default',NULL,NULL,319.00,NULL,57,'completed','2024-03-15 03:02:57','2024-03-14 17:02:57','2024-03-15 03:02:57');
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',1,'78109','shipping_address'),(2,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',2,'78109','shipping_address'),(3,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',3,'78109','shipping_address'),(4,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',4,'78109','shipping_address'),(5,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',5,'71594','shipping_address'),(6,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',6,'71594','shipping_address'),(7,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',7,'71594','shipping_address'),(8,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',8,'71594','shipping_address'),(9,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',9,'71594','shipping_address'),(10,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',10,'78109','shipping_address'),(11,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',11,'78109','shipping_address'),(12,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',12,'78109','shipping_address'),(13,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',13,'78109','shipping_address'),(14,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',14,'78109','shipping_address'),(15,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',15,'78109','shipping_address'),(16,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',16,'78109','shipping_address'),(17,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',17,'78109','shipping_address'),(18,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',18,'78109','shipping_address'),(19,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',19,'78109','shipping_address'),(20,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',20,'78109','shipping_address'),(21,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',21,'78109','shipping_address'),(22,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',22,'78109','shipping_address'),(23,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',23,'78109','shipping_address'),(24,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',24,'78109','shipping_address'),(25,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',25,'78109','shipping_address'),(26,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',26,'78109','shipping_address'),(27,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',27,'78109','shipping_address'),(28,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',28,'78109','shipping_address'),(29,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',29,'78109','shipping_address'),(30,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',30,'78109','shipping_address'),(31,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',31,'78109','shipping_address'),(32,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',32,'71594','shipping_address'),(33,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',33,'71594','shipping_address'),(34,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',34,'71594','shipping_address'),(35,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',35,'71594','shipping_address'),(36,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',36,'78109','shipping_address'),(37,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',37,'78109','shipping_address'),(38,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',38,'78109','shipping_address'),(39,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',39,'78109','shipping_address'),(40,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',40,'71594','shipping_address'),(41,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',41,'71594','shipping_address'),(42,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',42,'71594','shipping_address'),(43,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',43,'78109','shipping_address'),(44,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',44,'78109','shipping_address'),(45,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',45,'78109','shipping_address'),(46,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',46,'78109','shipping_address'),(47,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',47,'78109','shipping_address'),(48,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',48,'78109','shipping_address'),(49,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',49,'78109','shipping_address'),(50,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',50,'71594','shipping_address'),(51,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',51,'71594','shipping_address'),(52,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',52,'78109','shipping_address'),(53,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',53,'78109','shipping_address'),(54,'Claire Kunze','+16784509249','erik27@example.net','CO','Georgia','Starkshire','7637 Agustin Glen',54,'78109','shipping_address'),(55,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',55,'71594','shipping_address'),(56,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',56,'71594','shipping_address'),(57,'Clark Grant','+16296201050','elisha77@example.org','WS','Ohio','Morarhaven','45814 Daugherty Mews Suite 572',57,'71594','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=238 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2024-03-01 19:02:44','2024-03-01 19:02:44'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2024-03-01 19:02:44','2024-03-01 19:02:44'),(3,'create_shipment','Created shipment for order',0,1,NULL,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(4,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2024-02-27 11:02:44','2024-02-27 11:02:44'),(5,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2024-02-27 11:02:44','2024-02-27 11:02:44'),(6,'confirm_payment','Payment was confirmed (amount $3,766.00) by %user_name%',0,2,NULL,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(7,'create_shipment','Created shipment for order',0,2,NULL,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(8,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2024-03-11 19:02:44','2024-03-11 19:02:44'),(9,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2024-03-11 19:02:44','2024-03-11 19:02:44'),(10,'confirm_payment','Payment was confirmed (amount $6,372.00) by %user_name%',0,3,NULL,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(11,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,3,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(12,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2024-02-27 11:02:45','2024-02-27 11:02:45'),(13,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2024-02-27 11:02:45','2024-02-27 11:02:45'),(14,'create_shipment','Created shipment for order',0,4,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(15,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(16,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2024-03-11 23:02:45','2024-03-11 23:02:45'),(17,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2024-03-11 23:02:45','2024-03-11 23:02:45'),(18,'confirm_payment','Payment was confirmed (amount $2,430.00) by %user_name%',0,5,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(19,'create_shipment','Created shipment for order',0,5,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(20,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,5,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(21,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2024-03-13 13:02:45','2024-03-13 13:02:45'),(22,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2024-03-13 13:02:45','2024-03-13 13:02:45'),(23,'create_shipment','Created shipment for order',0,6,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(24,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2024-03-11 23:02:45','2024-03-11 23:02:45'),(25,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2024-03-11 23:02:45','2024-03-11 23:02:45'),(26,'confirm_payment','Payment was confirmed (amount $1,905.00) by %user_name%',0,7,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(27,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,7,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(28,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2024-03-12 03:02:45','2024-03-12 03:02:45'),(29,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2024-03-12 03:02:45','2024-03-12 03:02:45'),(30,'create_shipment','Created shipment for order',0,8,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(31,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45'),(32,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2024-03-03 03:02:45','2024-03-03 03:02:45'),(33,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2024-03-03 03:02:45','2024-03-03 03:02:45'),(34,'create_shipment','Created shipment for order',0,9,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(35,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(36,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2024-03-08 01:02:46','2024-03-08 01:02:46'),(37,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2024-03-08 01:02:46','2024-03-08 01:02:46'),(38,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2024-03-02 09:02:46','2024-03-02 09:02:46'),(39,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2024-03-02 09:02:46','2024-03-02 09:02:46'),(40,'confirm_payment','Payment was confirmed (amount $6,960.00) by %user_name%',0,11,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(41,'create_shipment','Created shipment for order',0,11,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(42,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2024-03-13 17:02:46','2024-03-13 17:02:46'),(43,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2024-03-13 17:02:46','2024-03-13 17:02:46'),(44,'confirm_payment','Payment was confirmed (amount $707.00) by %user_name%',0,12,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(45,'create_shipment','Created shipment for order',0,12,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(46,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,12,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(47,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2024-03-11 03:02:46','2024-03-11 03:02:46'),(48,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2024-03-11 03:02:46','2024-03-11 03:02:46'),(49,'confirm_payment','Payment was confirmed (amount $319.00) by %user_name%',0,13,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46'),(50,'create_shipment','Created shipment for order',0,13,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(51,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(52,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2024-03-03 03:02:47','2024-03-03 03:02:47'),(53,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2024-03-03 03:02:47','2024-03-03 03:02:47'),(54,'confirm_payment','Payment was confirmed (amount $1,972.00) by %user_name%',0,14,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(55,'create_shipment','Created shipment for order',0,14,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(56,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(57,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2024-03-08 21:02:47','2024-03-08 21:02:47'),(58,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2024-03-08 21:02:47','2024-03-08 21:02:47'),(59,'confirm_payment','Payment was confirmed (amount $1,908.00) by %user_name%',0,15,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(60,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,15,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(61,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2024-03-11 09:02:47','2024-03-11 09:02:47'),(62,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2024-03-11 09:02:47','2024-03-11 09:02:47'),(63,'confirm_payment','Payment was confirmed (amount $3,916.00) by %user_name%',0,16,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(64,'create_shipment','Created shipment for order',0,16,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(65,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2024-03-11 15:02:47','2024-03-11 15:02:47'),(66,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2024-03-11 15:02:47','2024-03-11 15:02:47'),(67,'confirm_payment','Payment was confirmed (amount $1,908.00) by %user_name%',0,17,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47'),(68,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,17,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(69,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2024-03-11 15:02:48','2024-03-11 15:02:48'),(70,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2024-03-11 15:02:48','2024-03-11 15:02:48'),(71,'confirm_payment','Payment was confirmed (amount $6,951.00) by %user_name%',0,18,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(72,'create_shipment','Created shipment for order',0,18,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(73,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(74,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2024-03-04 15:02:48','2024-03-04 15:02:48'),(75,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2024-03-04 15:02:48','2024-03-04 15:02:48'),(76,'confirm_payment','Payment was confirmed (amount $6,372.00) by %user_name%',0,19,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(77,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,19,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(78,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2024-03-12 19:02:48','2024-03-12 19:02:48'),(79,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2024-03-12 19:02:48','2024-03-12 19:02:48'),(80,'create_shipment','Created shipment for order',0,20,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(81,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,20,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(82,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2024-03-14 01:02:48','2024-03-14 01:02:48'),(83,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2024-03-14 01:02:48','2024-03-14 01:02:48'),(84,'confirm_payment','Payment was confirmed (amount $2,757.00) by %user_name%',0,21,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(85,'create_shipment','Created shipment for order',0,21,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(86,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,21,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48'),(87,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2024-03-07 13:02:48','2024-03-07 13:02:48'),(88,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2024-03-07 13:02:48','2024-03-07 13:02:48'),(89,'create_shipment','Created shipment for order',0,22,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(90,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2024-03-08 03:02:49','2024-03-08 03:02:49'),(91,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2024-03-08 03:02:49','2024-03-08 03:02:49'),(92,'create_shipment','Created shipment for order',0,23,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(93,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2024-03-10 03:02:49','2024-03-10 03:02:49'),(94,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2024-03-10 03:02:49','2024-03-10 03:02:49'),(95,'create_shipment','Created shipment for order',0,24,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(96,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(97,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2024-03-12 03:02:49','2024-03-12 03:02:49'),(98,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2024-03-12 03:02:49','2024-03-12 03:02:49'),(99,'confirm_payment','Payment was confirmed (amount $1,972.00) by %user_name%',0,25,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(100,'create_shipment','Created shipment for order',0,25,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(101,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,25,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(102,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2024-03-14 05:02:49','2024-03-14 05:02:49'),(103,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2024-03-14 05:02:49','2024-03-14 05:02:49'),(104,'confirm_payment','Payment was confirmed (amount $1,434.00) by %user_name%',0,26,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(105,'create_shipment','Created shipment for order',0,26,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(106,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2024-03-07 19:02:49','2024-03-07 19:02:49'),(107,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2024-03-07 19:02:49','2024-03-07 19:02:49'),(108,'confirm_payment','Payment was confirmed (amount $1,883.00) by %user_name%',0,27,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49'),(109,'create_shipment','Created shipment for order',0,27,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(110,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2024-03-13 07:02:50','2024-03-13 07:02:50'),(111,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2024-03-13 07:02:50','2024-03-13 07:02:50'),(112,'confirm_payment','Payment was confirmed (amount $2,418.00) by %user_name%',0,28,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(113,'create_shipment','Created shipment for order',0,28,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(114,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2024-03-08 11:02:50','2024-03-08 11:02:50'),(115,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2024-03-08 11:02:50','2024-03-08 11:02:50'),(116,'create_shipment','Created shipment for order',0,29,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(117,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(118,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2024-03-08 11:02:50','2024-03-08 11:02:50'),(119,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2024-03-08 11:02:50','2024-03-08 11:02:50'),(120,'create_shipment','Created shipment for order',0,30,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(121,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2024-03-08 11:02:50','2024-03-08 11:02:50'),(122,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2024-03-08 11:02:50','2024-03-08 11:02:50'),(123,'confirm_payment','Payment was confirmed (amount $638.00) by %user_name%',0,31,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(124,'create_shipment','Created shipment for order',0,31,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50'),(125,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2024-03-12 21:02:50','2024-03-12 21:02:50'),(126,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2024-03-12 21:02:50','2024-03-12 21:02:50'),(127,'create_shipment','Created shipment for order',0,32,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(128,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(129,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2024-03-13 15:02:51','2024-03-13 15:02:51'),(130,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2024-03-13 15:02:51','2024-03-13 15:02:51'),(131,'confirm_payment','Payment was confirmed (amount $6,373.00) by %user_name%',0,33,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(132,'create_shipment','Created shipment for order',0,33,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(133,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2024-03-14 11:02:51','2024-03-14 11:02:51'),(134,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2024-03-14 11:02:51','2024-03-14 11:02:51'),(135,'create_shipment','Created shipment for order',0,34,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(136,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,34,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(137,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2024-03-14 11:02:51','2024-03-14 11:02:51'),(138,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2024-03-14 11:02:51','2024-03-14 11:02:51'),(139,'confirm_payment','Payment was confirmed (amount $4,322.00) by %user_name%',0,35,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(140,'create_shipment','Created shipment for order',0,35,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51'),(141,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2024-03-12 05:02:51','2024-03-12 05:02:51'),(142,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2024-03-12 05:02:51','2024-03-12 05:02:51'),(143,'create_shipment','Created shipment for order',0,36,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(144,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2024-03-13 09:02:52','2024-03-13 09:02:52'),(145,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2024-03-13 09:02:52','2024-03-13 09:02:52'),(146,'create_shipment','Created shipment for order',0,37,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(147,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,37,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(148,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2024-03-12 19:02:52','2024-03-12 19:02:52'),(149,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2024-03-12 19:02:52','2024-03-12 19:02:52'),(150,'create_shipment','Created shipment for order',0,38,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(151,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2024-03-13 09:02:52','2024-03-13 09:02:52'),(152,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2024-03-13 09:02:52','2024-03-13 09:02:52'),(153,'confirm_payment','Payment was confirmed (amount $1,452.00) by %user_name%',0,39,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(154,'create_shipment','Created shipment for order',0,39,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(155,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(156,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2024-03-11 15:02:52','2024-03-11 15:02:52'),(157,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2024-03-11 15:02:52','2024-03-11 15:02:52'),(158,'confirm_payment','Payment was confirmed (amount $3,435.00) by %user_name%',0,40,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(159,'create_shipment','Created shipment for order',0,40,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(160,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2024-03-10 15:02:52','2024-03-10 15:02:52'),(161,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2024-03-10 15:02:52','2024-03-10 15:02:52'),(162,'confirm_payment','Payment was confirmed (amount $3,766.00) by %user_name%',0,41,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52'),(163,'create_shipment','Created shipment for order',0,41,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(164,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,41,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(165,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2024-03-10 03:02:53','2024-03-10 03:02:53'),(166,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2024-03-10 03:02:53','2024-03-10 03:02:53'),(167,'confirm_payment','Payment was confirmed (amount $1,351.00) by %user_name%',0,42,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(168,'create_shipment','Created shipment for order',0,42,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(169,'create_order_from_seeder','Order is created from the checkout page',NULL,43,NULL,'2024-03-13 21:02:53','2024-03-13 21:02:53'),(170,'confirm_order','Order was verified by %user_name%',0,43,NULL,'2024-03-13 21:02:53','2024-03-13 21:02:53'),(171,'create_shipment','Created shipment for order',0,43,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(172,'create_order_from_seeder','Order is created from the checkout page',NULL,44,NULL,'2024-03-12 05:02:53','2024-03-12 05:02:53'),(173,'confirm_order','Order was verified by %user_name%',0,44,NULL,'2024-03-12 05:02:53','2024-03-12 05:02:53'),(174,'create_shipment','Created shipment for order',0,44,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(175,'create_order_from_seeder','Order is created from the checkout page',NULL,45,NULL,'2024-03-10 23:02:53','2024-03-10 23:02:53'),(176,'confirm_order','Order was verified by %user_name%',0,45,NULL,'2024-03-10 23:02:53','2024-03-10 23:02:53'),(177,'confirm_payment','Payment was confirmed (amount $5,376.00) by %user_name%',0,45,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(178,'create_shipment','Created shipment for order',0,45,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(179,'create_order_from_seeder','Order is created from the checkout page',NULL,46,NULL,'2024-03-13 11:02:53','2024-03-13 11:02:53'),(180,'confirm_order','Order was verified by %user_name%',0,46,NULL,'2024-03-13 11:02:53','2024-03-13 11:02:53'),(181,'confirm_payment','Payment was confirmed (amount $1,862.00) by %user_name%',0,46,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(182,'create_shipment','Created shipment for order',0,46,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(183,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,46,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(184,'create_order_from_seeder','Order is created from the checkout page',NULL,47,NULL,'2024-03-14 03:02:53','2024-03-14 03:02:53'),(185,'confirm_order','Order was verified by %user_name%',0,47,NULL,'2024-03-14 03:02:53','2024-03-14 03:02:53'),(186,'confirm_payment','Payment was confirmed (amount $458.00) by %user_name%',0,47,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53'),(187,'create_shipment','Created shipment for order',0,47,NULL,'2024-03-15 03:02:54','2024-03-15 03:02:54'),(188,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,47,NULL,'2024-03-15 03:02:54','2024-03-15 03:02:54'),(189,'create_order_from_seeder','Order is created from the checkout page',NULL,48,NULL,'2024-03-12 03:02:54','2024-03-12 03:02:54'),(190,'confirm_order','Order was verified by %user_name%',0,48,NULL,'2024-03-12 03:02:54','2024-03-12 03:02:54'),(191,'create_shipment','Created shipment for order',0,48,NULL,'2024-03-15 03:02:55','2024-03-15 03:02:55'),(192,'create_order_from_seeder','Order is created from the checkout page',NULL,49,NULL,'2024-03-14 19:02:55','2024-03-14 19:02:55'),(193,'confirm_order','Order was verified by %user_name%',0,49,NULL,'2024-03-14 19:02:55','2024-03-14 19:02:55'),(194,'confirm_payment','Payment was confirmed (amount $1,062.00) by %user_name%',0,49,NULL,'2024-03-15 03:02:55','2024-03-15 03:02:55'),(195,'create_shipment','Created shipment for order',0,49,NULL,'2024-03-15 03:02:55','2024-03-15 03:02:55'),(196,'create_order_from_seeder','Order is created from the checkout page',NULL,50,NULL,'2024-03-13 21:02:55','2024-03-13 21:02:55'),(197,'confirm_order','Order was verified by %user_name%',0,50,NULL,'2024-03-13 21:02:55','2024-03-13 21:02:55'),(198,'confirm_payment','Payment was confirmed (amount $635.00) by %user_name%',0,50,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(199,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,50,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(200,'create_order_from_seeder','Order is created from the checkout page',NULL,51,NULL,'2024-03-14 15:02:56','2024-03-14 15:02:56'),(201,'confirm_order','Order was verified by %user_name%',0,51,NULL,'2024-03-14 15:02:56','2024-03-14 15:02:56'),(202,'confirm_payment','Payment was confirmed (amount $5,649.00) by %user_name%',0,51,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(203,'create_shipment','Created shipment for order',0,51,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(204,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,51,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(205,'create_order_from_seeder','Order is created from the checkout page',NULL,52,NULL,'2024-03-13 11:02:56','2024-03-13 11:02:56'),(206,'confirm_order','Order was verified by %user_name%',0,52,NULL,'2024-03-13 11:02:56','2024-03-13 11:02:56'),(207,'create_shipment','Created shipment for order',0,52,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(208,'create_order_from_seeder','Order is created from the checkout page',NULL,53,NULL,'2024-03-13 15:02:56','2024-03-13 15:02:56'),(209,'confirm_order','Order was verified by %user_name%',0,53,NULL,'2024-03-13 15:02:56','2024-03-13 15:02:56'),(210,'confirm_payment','Payment was confirmed (amount $2,470.00) by %user_name%',0,53,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(211,'create_shipment','Created shipment for order',0,53,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(212,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,53,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56'),(213,'create_order_from_seeder','Order is created from the checkout page',NULL,54,NULL,'2024-03-13 11:02:56','2024-03-13 11:02:56'),(214,'confirm_order','Order was verified by %user_name%',0,54,NULL,'2024-03-13 11:02:56','2024-03-13 11:02:56'),(215,'create_shipment','Created shipment for order',0,54,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57'),(216,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,54,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57'),(217,'create_order_from_seeder','Order is created from the checkout page',NULL,55,NULL,'2024-03-14 19:02:57','2024-03-14 19:02:57'),(218,'confirm_order','Order was verified by %user_name%',0,55,NULL,'2024-03-14 19:02:57','2024-03-14 19:02:57'),(219,'create_order_from_seeder','Order is created from the checkout page',NULL,56,NULL,'2024-03-15 01:02:57','2024-03-15 01:02:57'),(220,'confirm_order','Order was verified by %user_name%',0,56,NULL,'2024-03-15 01:02:57','2024-03-15 01:02:57'),(221,'create_order_from_seeder','Order is created from the checkout page',NULL,57,NULL,'2024-03-14 17:02:57','2024-03-14 17:02:57'),(222,'confirm_order','Order was verified by %user_name%',0,57,NULL,'2024-03-14 17:02:57','2024-03-14 17:02:57'),(223,'confirm_payment','Payment was confirmed (amount $319.00) by %user_name%',0,57,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57'),(224,'create_shipment','Created shipment for order',0,57,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57'),(225,'update_status','Order confirmed by %user_name%',0,5,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57'),(226,'update_status','Order confirmed by %user_name%',0,12,NULL,'2024-03-15 03:02:58','2024-03-15 03:02:58'),(227,'update_status','Order confirmed by %user_name%',0,13,NULL,'2024-03-15 03:02:58','2024-03-15 03:02:58'),(228,'update_status','Order confirmed by %user_name%',0,14,NULL,'2024-03-15 03:02:59','2024-03-15 03:02:59'),(229,'update_status','Order confirmed by %user_name%',0,18,NULL,'2024-03-15 03:03:00','2024-03-15 03:03:00'),(230,'update_status','Order confirmed by %user_name%',0,21,NULL,'2024-03-15 03:03:00','2024-03-15 03:03:00'),(231,'update_status','Order confirmed by %user_name%',0,25,NULL,'2024-03-15 03:03:01','2024-03-15 03:03:01'),(232,'update_status','Order confirmed by %user_name%',0,39,NULL,'2024-03-15 03:03:01','2024-03-15 03:03:01'),(233,'update_status','Order confirmed by %user_name%',0,41,NULL,'2024-03-15 03:03:02','2024-03-15 03:03:02'),(234,'update_status','Order confirmed by %user_name%',0,46,NULL,'2024-03-15 03:03:02','2024-03-15 03:03:02'),(235,'update_status','Order confirmed by %user_name%',0,47,NULL,'2024-03-15 03:03:03','2024-03-15 03:03:03'),(236,'update_status','Order confirmed by %user_name%',0,51,NULL,'2024-03-15 03:03:03','2024-03-15 03:03:03'),(237,'update_status','Order confirmed by %user_name%',0,53,NULL,'2024-03-15 03:03:04','2024-03-15 03:03:04');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,1,2161.00,0.00,'{\"sku\":\"OA-196-A0-A4\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,92,'Off-Shoulder Ruffle Top','beauty/products/product-7.png',799.00,0,'2024-03-15 03:02:44','2024-03-15 03:02:44','physical',0,NULL),(2,2,2,1883.00,0.00,'{\"sku\":\"9G-113-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,118,'Wide Brim Floppy Hat','beauty/products/product-8.png',1480.00,0,'2024-03-15 03:02:44','2024-03-15 03:02:44','physical',0,NULL),(3,3,3,2124.00,0.00,'{\"sku\":\"NI-190-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,123,'Denim Overall Jumpsuit (Digital)','beauty/products/product-2.png',2631.00,0,'2024-03-15 03:02:44','2024-03-15 03:02:44','digital',7,NULL),(4,4,3,1351.00,0.00,'{\"sku\":\"BY-172-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,125,'Embellished Ballet Flats','beauty/products/product-5.png',2271.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','physical',0,NULL),(5,5,2,1215.00,0.00,'{\"sku\":\"5D-197-A0\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,49,'Leather Ankle Boots','beauty/products/product-2.png',1234.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','physical',0,NULL),(6,6,3,373.00,0.00,'{\"sku\":\"DV-187-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,82,'Cotton Striped T-Shirt Dress','beauty/products/product-8.png',2205.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','physical',0,NULL),(7,7,3,635.00,0.00,'{\"sku\":\"WS-190-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,114,'Boho Fringed Kimono (Digital)','beauty/products/product-2.png',2412.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','digital',0,NULL),(8,8,1,478.00,0.00,'{\"sku\":\"CN-192-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,45,'Vintage Denim Jacket','beauty/products/product-7.png',691.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','physical',0,NULL),(9,9,3,635.00,0.00,'{\"sku\":\"WS-190-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}',NULL,111,'Boho Fringed Kimono (Digital)','beauty/products/product-4.png',2412.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','digital',7,NULL),(10,9,3,319.00,0.00,'{\"sku\":\"OG-141-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}',NULL,142,'Retro High-Top Sneakers','beauty/products/product-8.png',2412.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','physical',0,NULL),(11,9,3,319.00,0.00,'{\"sku\":\"OG-141-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}',NULL,143,'Retro High-Top Sneakers','beauty/products/product-5.png',2412.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','physical',0,NULL),(12,10,1,1365.00,0.00,'{\"sku\":\"YT-191-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,68,'Chic Fedora Hat (Digital)','beauty/products/product-6.png',866.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','digital',2,NULL),(13,10,1,2124.00,0.00,'{\"sku\":\"NI-190-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,124,'Denim Overall Jumpsuit (Digital)','beauty/products/product-8.png',877.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','digital',6,NULL),(14,11,3,2320.00,0.00,'{\"sku\":\"PI-148-A0\",\"attributes\":\"(Color: Green, Size: XXL)\"}',NULL,70,'Strappy Block Heel Sandals','beauty/products/product-1.png',1824.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','physical',0,NULL),(15,12,1,707.00,0.00,'{\"sku\":\"JS-162-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,132,'Buckle Detail Ankle Booties','beauty/products/product-2.png',826.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','physical',0,NULL),(16,13,1,319.00,0.00,'{\"sku\":\"OG-141-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,141,'Retro High-Top Sneakers','beauty/products/product-6.png',804.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','physical',0,NULL),(17,14,2,986.00,0.00,'{\"sku\":\"3G-196-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,146,'Faux Leather Leggings','beauty/products/product-6.png',1586.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','physical',0,NULL),(18,15,1,1908.00,0.00,'{\"sku\":\"F1-160-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,51,'Knit Turtleneck Sweater (Digital)','beauty/products/product-4.png',813.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','digital',6,NULL),(19,16,1,1792.00,0.00,'{\"sku\":\"2O-188-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,107,'Faux Fur Trimmed Coat','beauty/products/product-2.png',537.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','physical',0,NULL),(20,16,1,2124.00,0.00,'{\"sku\":\"NI-190-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,121,'Denim Overall Jumpsuit (Digital)','beauty/products/product-5.png',877.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','digital',4,NULL),(21,17,1,1908.00,0.00,'{\"sku\":\"F1-160-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}',NULL,50,'Knit Turtleneck Sweater (Digital)','beauty/products/product-5.png',813.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','digital',2,NULL),(22,18,3,2317.00,0.00,'{\"sku\":\"H6-129-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,115,'Ruffled Wrap Dress','beauty/products/product-3.png',2028.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','physical',0,NULL),(23,19,3,2124.00,0.00,'{\"sku\":\"NI-190-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,121,'Denim Overall Jumpsuit (Digital)','beauty/products/product-5.png',2631.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','digital',6,NULL),(24,20,2,319.00,0.00,'{\"sku\":\"OG-141-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,141,'Retro High-Top Sneakers','beauty/products/product-6.png',1608.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','physical',0,NULL),(25,21,3,919.00,0.00,'{\"sku\":\"JX-101-A0\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,76,'Quilted Crossbody Bag','beauty/products/product-1.png',2097.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','physical',0,NULL),(26,22,3,1062.00,0.00,'{\"sku\":\"JG-149-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,127,'Velour Tracksuit Set','beauty/products/product-8.png',2256.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','physical',0,NULL),(27,23,2,1145.00,0.00,'{\"sku\":\"DX-154-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,81,'Lace-Up Combat Boots','beauty/products/product-8.png',1308.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','physical',0,NULL),(28,24,2,1862.00,0.00,'{\"sku\":\"RU-193-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,133,'Embroidered Bomber Jacket','beauty/products/product-8.png',1768.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','physical',0,NULL),(29,25,2,986.00,0.00,'{\"sku\":\"3G-196-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,145,'Faux Leather Leggings','beauty/products/product-2.png',1586.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','physical',0,NULL),(30,26,3,478.00,0.00,'{\"sku\":\"CN-192-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,45,'Vintage Denim Jacket','beauty/products/product-7.png',2073.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','physical',0,NULL),(31,27,1,1883.00,0.00,'{\"sku\":\"9G-113-A0\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,117,'Wide Brim Floppy Hat','beauty/products/product-1.png',740.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','physical',0,NULL),(32,28,1,2418.00,0.00,'{\"sku\":\"3F-139-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,148,'Metallic Pleated Maxi Skirt','beauty/products/product-7.png',779.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','physical',0,NULL),(33,29,3,919.00,0.00,'{\"sku\":\"JX-101-A0-A2\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,78,'Quilted Crossbody Bag','beauty/products/product-8.png',2097.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','physical',0,NULL),(34,30,2,1825.00,0.00,'{\"sku\":\"2R-104-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,105,'Retro Cat-Eye Sunglasses','beauty/products/product-8.png',1476.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','physical',0,NULL),(35,31,2,319.00,0.00,'{\"sku\":\"OG-141-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}',NULL,143,'Retro High-Top Sneakers','beauty/products/product-5.png',1608.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','physical',0,NULL),(36,32,1,1865.00,0.00,'{\"sku\":\"P7-111-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,61,'High-Waisted Wide Leg Trousers','beauty/products/product-8.png',552.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','physical',0,NULL),(37,33,2,449.00,0.00,'{\"sku\":\"PC-171-A0\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,93,'Suede Pointed-Toe Pumps','beauty/products/product-6.png',1046.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','physical',0,NULL),(38,33,3,1825.00,0.00,'{\"sku\":\"2R-104-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,105,'Retro Cat-Eye Sunglasses','beauty/products/product-8.png',2214.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','physical',0,NULL),(39,34,3,373.00,0.00,'{\"sku\":\"DV-187-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,82,'Cotton Striped T-Shirt Dress','beauty/products/product-8.png',2205.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','physical',0,NULL),(40,35,2,2161.00,0.00,'{\"sku\":\"OA-196-A0\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,88,'Off-Shoulder Ruffle Top','beauty/products/product-1.png',1598.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','physical',0,NULL),(41,36,1,478.00,0.00,'{\"sku\":\"CN-192-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,44,'Vintage Denim Jacket','beauty/products/product-4.png',691.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','physical',0,NULL),(42,37,2,1865.00,0.00,'{\"sku\":\"P7-111-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,61,'High-Waisted Wide Leg Trousers','beauty/products/product-8.png',1104.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','physical',0,NULL),(43,38,2,2320.00,0.00,'{\"sku\":\"PI-148-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,71,'Strappy Block Heel Sandals','beauty/products/product-3.png',1216.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','physical',0,NULL),(44,39,1,1452.00,0.00,'{\"sku\":\"GY-193-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}',NULL,136,'Cowl Neck Knit Poncho','beauty/products/product-6.png',780.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','physical',0,NULL),(45,40,3,1145.00,0.00,'{\"sku\":\"DX-154-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,81,'Lace-Up Combat Boots','beauty/products/product-8.png',1962.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','physical',0,NULL),(46,41,2,1883.00,0.00,'{\"sku\":\"9G-113-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}',NULL,119,'Wide Brim Floppy Hat','beauty/products/product-5.png',1480.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','physical',0,NULL),(47,42,1,1351.00,0.00,'{\"sku\":\"BY-172-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,125,'Embellished Ballet Flats','beauty/products/product-5.png',757.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','physical',0,NULL),(48,43,3,1215.00,0.00,'{\"sku\":\"5D-197-A0\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,49,'Leather Ankle Boots','beauty/products/product-2.png',1851.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','physical',0,NULL),(49,44,1,890.00,0.00,'{\"sku\":\"QM-167-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,101,'Leopard Print Midi Skirt','beauty/products/product-5.png',685.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','physical',0,NULL),(50,45,3,1792.00,0.00,'{\"sku\":\"2O-188-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,107,'Faux Fur Trimmed Coat','beauty/products/product-2.png',1611.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','physical',0,NULL),(51,46,1,1862.00,0.00,'{\"sku\":\"RU-193-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,135,'Embroidered Bomber Jacket','beauty/products/product-5.png',884.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','physical',0,NULL),(52,47,1,458.00,0.00,'{\"sku\":\"AC-123-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}',NULL,55,'Tailored Wool Blazer','beauty/products/product-2.png',506.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','physical',0,NULL),(53,48,1,1233.00,0.00,'{\"sku\":\"VD-145-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,75,'Velvet Evening Gown','beauty/products/product-2.png',753.00,0,'2024-03-15 03:02:54','2024-03-15 03:02:54','physical',0,NULL),(54,49,1,1062.00,0.00,'{\"sku\":\"JG-149-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,128,'Velour Tracksuit Set','beauty/products/product-6.png',752.00,0,'2024-03-15 03:02:55','2024-03-15 03:02:55','physical',0,NULL),(55,50,1,635.00,0.00,'{\"sku\":\"WS-190-A0-A2\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}',NULL,113,'Boho Fringed Kimono (Digital)','beauty/products/product-8.png',804.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','digital',6,NULL),(56,51,3,1883.00,0.00,'{\"sku\":\"9G-113-A0-A3\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}',NULL,120,'Wide Brim Floppy Hat','beauty/products/product-4.png',2220.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','physical',0,NULL),(57,52,1,1865.00,0.00,'{\"sku\":\"P7-111-A0\",\"attributes\":\"(Color: Blue, Size: M)\"}',NULL,60,'High-Waisted Wide Leg Trousers','beauty/products/product-4.png',552.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','physical',0,NULL),(58,53,1,373.00,0.00,'{\"sku\":\"DV-187-A0\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,82,'Cotton Striped T-Shirt Dress','beauty/products/product-8.png',735.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','physical',0,NULL),(59,53,3,699.00,0.00,'{\"sku\":\"F7-126-A0-A2\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,98,'Cropped Cable Knit Sweater','beauty/products/product-8.png',1515.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','physical',0,NULL),(60,54,2,1351.00,0.00,'{\"sku\":\"BY-172-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,125,'Embellished Ballet Flats','beauty/products/product-5.png',1514.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','physical',0,NULL),(61,55,1,1452.00,0.00,'{\"sku\":\"EO-165-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,99,'Athleisure Jogger Pants (Digital)','beauty/products/product-7.png',597.00,0,'2024-03-15 03:02:57','2024-03-15 03:02:57','digital',4,NULL),(62,56,1,2124.00,0.00,'{\"sku\":\"NI-190-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,121,'Denim Overall Jumpsuit (Digital)','beauty/products/product-5.png',877.00,0,'2024-03-15 03:02:57','2024-03-15 03:02:57','digital',3,NULL),(63,57,1,319.00,0.00,'{\"sku\":\"OG-141-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,141,'Retro High-Top Sneakers','beauty/products/product-6.png',804.00,0,'2024-03-15 03:02:57','2024-03-15 03:02:57','physical',0,NULL);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `proof_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',10,'1','default','pending',2161.00,0.00,0.00,NULL,NULL,0.00,2161.00,1,NULL,1,NULL,'ZKsDW7AawfaW4gUzYteka6KRSwj8g',1,'2024-03-01 19:02:44','2024-03-15 03:02:44',5,NULL),(2,'#10000002',10,'1','default','pending',3766.00,0.00,0.00,NULL,NULL,0.00,3766.00,1,NULL,1,NULL,'zbqsefl7aIYy8Pac463z6syN6x1eR',2,'2024-02-27 11:02:44','2024-03-15 03:02:44',3,NULL),(3,'#10000003',10,NULL,'','completed',6372.00,0.00,0.00,NULL,NULL,0.00,6372.00,1,NULL,1,'2024-03-15 03:02:45','HBdasBsldZ1UygKNhRyvzhqezpCeR',3,'2024-03-11 19:02:44','2024-03-15 03:02:45',2,NULL),(4,'#10000004',10,'1','default','completed',4053.00,0.00,0.00,NULL,NULL,0.00,4053.00,1,NULL,1,'2024-03-15 03:02:45','nCfJT6AyxedrHratUuEmk9tDLCMYJ',4,'2024-02-27 11:02:45','2024-03-15 03:02:45',8,NULL),(5,'#10000005',9,'1','default','completed',2430.00,0.00,0.00,NULL,NULL,0.00,2430.00,1,NULL,1,'2024-03-15 03:02:57','QQYqjZXBFP4QxAXn7VIDQmawKNFv8',5,'2024-03-11 23:02:45','2024-03-15 03:02:57',7,NULL),(6,'#10000006',9,'1','default','pending',1119.00,0.00,0.00,NULL,NULL,0.00,1119.00,1,NULL,1,NULL,'w4wox0UpxLrTCwmwjUiPAuKyKlh5G',6,'2024-03-13 13:02:45','2024-03-15 03:02:45',6,NULL),(7,'#10000007',9,NULL,'','completed',1905.00,0.00,0.00,NULL,NULL,0.00,1905.00,1,NULL,1,'2024-03-15 03:02:45','PzMTTRfCk42T2bz3kDwxCGequLD9Q',7,'2024-03-11 23:02:45','2024-03-15 03:02:45',5,NULL),(8,'#10000008',9,'1','default','completed',478.00,0.00,0.00,NULL,NULL,0.00,478.00,1,NULL,1,'2024-03-15 03:02:45','i5maQB09IGYQKzgDTcxiARG7Hatam',8,'2024-03-12 03:02:45','2024-03-15 03:02:45',7,NULL),(9,'#10000009',9,'1','default','completed',3819.00,0.00,0.00,NULL,NULL,0.00,3819.00,1,NULL,1,'2024-03-15 03:02:46','te8ihG0akRTw5RmZ9GJZeoBsT2TD1',9,'2024-03-03 03:02:45','2024-03-15 03:02:46',5,NULL),(10,'#10000010',10,NULL,'','pending',3489.00,0.00,0.00,NULL,NULL,0.00,3489.00,1,NULL,1,NULL,'KU1eeODJpoy8mSmid3pCLQO5TbqcO',10,'2024-03-08 01:02:46','2024-03-15 03:02:46',2,NULL),(11,'#10000011',10,'1','default','pending',6960.00,0.00,0.00,NULL,NULL,0.00,6960.00,1,NULL,1,NULL,'OSghKaOL3gTSniGXTf7H4wfH0fBtW',11,'2024-03-02 09:02:46','2024-03-15 03:02:46',8,NULL),(12,'#10000012',10,'1','default','completed',707.00,0.00,0.00,NULL,NULL,0.00,707.00,1,NULL,1,'2024-03-15 03:02:58','GPgOOedPZwUlIUSy7rjuViiHm6L6E',12,'2024-03-13 17:02:46','2024-03-15 03:02:58',3,NULL),(13,'#10000013',10,'1','default','completed',319.00,0.00,0.00,NULL,NULL,0.00,319.00,1,NULL,1,'2024-03-15 03:02:58','xADI2l820BBXzKY8yPptfPhVUnPXf',13,'2024-03-11 03:02:46','2024-03-15 03:02:58',5,NULL),(14,'#10000014',10,'1','default','completed',1972.00,0.00,0.00,NULL,NULL,0.00,1972.00,1,NULL,1,'2024-03-15 03:02:59','K5s958i6ByXt1vGSjP18euUAuGA1a',14,'2024-03-03 03:02:47','2024-03-15 03:02:59',2,NULL),(15,'#10000015',10,NULL,'','completed',1908.00,0.00,0.00,NULL,NULL,0.00,1908.00,1,NULL,1,'2024-03-15 03:02:47','LqChrN5tFDF5VM9bSfeLH5wigDF0K',15,'2024-03-08 21:02:47','2024-03-15 03:02:47',4,NULL),(16,'#10000016',10,'1','default','pending',3916.00,0.00,0.00,NULL,NULL,0.00,3916.00,1,NULL,1,NULL,'rkiQ2cIGQJj1vG1IDlFONC92Bdjzr',16,'2024-03-11 09:02:47','2024-03-15 03:02:47',2,NULL),(17,'#10000017',10,NULL,'','completed',1908.00,0.00,0.00,NULL,NULL,0.00,1908.00,1,NULL,1,'2024-03-15 03:02:48','UnfBOfTDezFvaKX9G6G7MuHRWRyqJ',17,'2024-03-11 15:02:47','2024-03-15 03:02:48',4,NULL),(18,'#10000018',10,'1','default','completed',6951.00,0.00,0.00,NULL,NULL,0.00,6951.00,1,NULL,1,'2024-03-15 03:03:00','64MI9gFyT6dAGzGY6yurkibqWIlXS',18,'2024-03-11 15:02:48','2024-03-15 03:03:00',7,NULL),(19,'#10000019',10,NULL,'','completed',6372.00,0.00,0.00,NULL,NULL,0.00,6372.00,1,NULL,1,'2024-03-15 03:02:48','CBCep6Jjxx5GW0oc1FQP5teJf2Stu',19,'2024-03-04 15:02:48','2024-03-15 03:02:48',2,NULL),(20,'#10000020',10,'1','default','completed',638.00,0.00,0.00,NULL,NULL,0.00,638.00,1,NULL,1,'2024-03-15 03:02:48','gorkhEzaaOraH6tVo4tGDhW27UNnB',20,'2024-03-12 19:02:48','2024-03-15 03:02:48',5,NULL),(21,'#10000021',10,'1','default','completed',2757.00,0.00,0.00,NULL,NULL,0.00,2757.00,1,NULL,1,'2024-03-15 03:03:00','K0wAZzY0CsmbM4zB6ID7ZLJbkamn9',21,'2024-03-14 01:02:48','2024-03-15 03:03:00',6,NULL),(22,'#10000022',10,'1','default','pending',3186.00,0.00,0.00,NULL,NULL,0.00,3186.00,1,NULL,1,NULL,'2cAC9GdjDQWzoZg26vmZz0DnFf3mK',22,'2024-03-07 13:02:48','2024-03-15 03:02:48',2,NULL),(23,'#10000023',10,'1','default','pending',2290.00,0.00,0.00,NULL,NULL,0.00,2290.00,1,NULL,1,NULL,'v3PoDORnRN9uho61zWRxEca8mV9DP',23,'2024-03-08 03:02:49','2024-03-15 03:02:49',1,NULL),(24,'#10000024',10,'1','default','completed',3724.00,0.00,0.00,NULL,NULL,0.00,3724.00,1,NULL,1,'2024-03-15 03:02:49','pBNgHrLCdkgV0pklY0Myt2hPoXcwV',24,'2024-03-10 03:02:49','2024-03-15 03:02:49',5,NULL),(25,'#10000025',10,'1','default','completed',1972.00,0.00,0.00,NULL,NULL,0.00,1972.00,1,NULL,1,'2024-03-15 03:03:01','XeuzF09rnbqAXr55ZwYB1vaKl9Eez',25,'2024-03-12 03:02:49','2024-03-15 03:03:01',2,NULL),(26,'#10000026',10,'1','default','pending',1434.00,0.00,0.00,NULL,NULL,0.00,1434.00,1,NULL,1,NULL,'7moUDLco5kbo68AOQ4KM9yer5Dcau',26,'2024-03-14 05:02:49','2024-03-15 03:02:49',7,NULL),(27,'#10000027',10,'1','default','pending',1883.00,0.00,0.00,NULL,NULL,0.00,1883.00,1,NULL,1,NULL,'9uvIXd6FBsCbAHNhWnmx7VSKSHfW6',27,'2024-03-07 19:02:49','2024-03-15 03:02:49',3,NULL),(28,'#10000028',10,'1','default','pending',2418.00,0.00,0.00,NULL,NULL,0.00,2418.00,1,NULL,1,NULL,'qwbPakccCfLPzYZii0QiQwzrsrT3g',28,'2024-03-13 07:02:50','2024-03-15 03:02:50',1,NULL),(29,'#10000029',10,'1','default','completed',2757.00,0.00,0.00,NULL,NULL,0.00,2757.00,1,NULL,1,'2024-03-15 03:02:50','rb1UhqzHOqRLj2gQ7tsaTH1bRoCjZ',29,'2024-03-08 11:02:50','2024-03-15 03:02:50',6,NULL),(30,'#10000030',10,'1','default','pending',3650.00,0.00,0.00,NULL,NULL,0.00,3650.00,1,NULL,1,NULL,'4eeEDAd2PeNbRzhuEybOUv5vchfEr',30,'2024-03-08 11:02:50','2024-03-15 03:02:50',2,NULL),(31,'#10000031',10,'1','default','pending',638.00,0.00,0.00,NULL,NULL,0.00,638.00,1,NULL,1,NULL,'kWi7t4gJszqUqZezIdhHRCzcFUNdR',31,'2024-03-08 11:02:50','2024-03-15 03:02:50',5,NULL),(32,'#10000032',9,'1','default','completed',1865.00,0.00,0.00,NULL,NULL,0.00,1865.00,1,NULL,1,'2024-03-15 03:02:51','0aG2NX1O3SU5O3ol8eSmUckbALlB6',32,'2024-03-12 21:02:50','2024-03-15 03:02:51',4,NULL),(33,'#10000033',9,'1','default','pending',6373.00,0.00,0.00,NULL,NULL,0.00,6373.00,1,NULL,1,NULL,'U0SoeBmtSR25L5xowCC2fHvs6woPW',33,'2024-03-13 15:02:51','2024-03-15 03:02:51',2,NULL),(34,'#10000034',9,'1','default','completed',1119.00,0.00,0.00,NULL,NULL,0.00,1119.00,1,NULL,1,'2024-03-15 03:02:51','uSEB5sd8pGBqNsZsBYYXL2KAHSYi9',34,'2024-03-14 11:02:51','2024-03-15 03:02:51',6,NULL),(35,'#10000035',9,'1','default','pending',4322.00,0.00,0.00,NULL,NULL,0.00,4322.00,1,NULL,1,NULL,'NzwfrIZsq1dOni1mJJXW6pDZS3JBA',35,'2024-03-14 11:02:51','2024-03-15 03:02:51',5,NULL),(36,'#10000036',10,'1','default','pending',478.00,0.00,0.00,NULL,NULL,0.00,478.00,1,NULL,1,NULL,'9vCOCo6ufP30gHEywrkQjV5NjkP7R',36,'2024-03-12 05:02:51','2024-03-15 03:02:51',7,NULL),(37,'#10000037',10,'1','default','completed',3730.00,0.00,0.00,NULL,NULL,0.00,3730.00,1,NULL,1,'2024-03-15 03:02:52','Ia4LjOWnDeuLf4fdFo9OURujwwPFG',37,'2024-03-13 09:02:52','2024-03-15 03:02:52',4,NULL),(38,'#10000038',10,'1','default','pending',4640.00,0.00,0.00,NULL,NULL,0.00,4640.00,1,NULL,1,NULL,'3mVjORausz4wtagvN3D0N2g8HywuL',38,'2024-03-12 19:02:52','2024-03-15 03:02:52',8,NULL),(39,'#10000039',10,'1','default','completed',1452.00,0.00,0.00,NULL,NULL,0.00,1452.00,1,NULL,1,'2024-03-15 03:03:01','gCBvC6ktOOBh9vcB659lKUiP0XZSJ',39,'2024-03-13 09:02:52','2024-03-15 03:03:01',5,NULL),(40,'#10000040',9,'1','default','pending',3435.00,0.00,0.00,NULL,NULL,0.00,3435.00,1,NULL,1,NULL,'mF3RVI8RIKnFeUnjEWtuOfDAP89BI',40,'2024-03-11 15:02:52','2024-03-15 03:02:52',1,NULL),(41,'#10000041',9,'1','default','completed',3766.00,0.00,0.00,NULL,NULL,0.00,3766.00,1,NULL,1,'2024-03-15 03:03:02','eVO13SXYl6gEpw7Sfj5fTcYVEah1r',41,'2024-03-10 15:02:52','2024-03-15 03:03:02',3,NULL),(42,'#10000042',9,'1','default','pending',1351.00,0.00,0.00,NULL,NULL,0.00,1351.00,1,NULL,1,NULL,'GFdtA8EOZD6iHzuQ4J0VNubtKhrtQ',42,'2024-03-10 03:02:53','2024-03-15 03:02:53',8,NULL),(43,'#10000043',10,'1','default','pending',3645.00,0.00,0.00,NULL,NULL,0.00,3645.00,1,NULL,1,NULL,'HxxtGDv3rEE3Dwmr3xh7HYPZ6duFX',43,'2024-03-13 21:02:53','2024-03-15 03:02:53',7,NULL),(44,'#10000044',10,'1','default','pending',890.00,0.00,0.00,NULL,NULL,0.00,890.00,1,NULL,1,NULL,'DreALRHzVfN3U5waPNSD89KLFeUB0',44,'2024-03-12 05:02:53','2024-03-15 03:02:53',6,NULL),(45,'#10000045',10,'1','default','pending',5376.00,0.00,0.00,NULL,NULL,0.00,5376.00,1,NULL,1,NULL,'g9rg0SlIrOEzolZsCMwZALmY80FLS',45,'2024-03-10 23:02:53','2024-03-15 03:02:53',2,NULL),(46,'#10000046',10,'1','default','completed',1862.00,0.00,0.00,NULL,NULL,0.00,1862.00,1,NULL,1,'2024-03-15 03:03:02','UMjAzFqHUO2gmOHfZKMfkvzMzUCVu',46,'2024-03-13 11:02:53','2024-03-15 03:03:02',5,NULL),(47,'#10000047',10,'1','default','completed',458.00,0.00,0.00,NULL,NULL,0.00,458.00,1,NULL,1,'2024-03-15 03:03:03','7GRtY2Dv1NJThBChbOJy30ylheswF',47,'2024-03-14 03:02:53','2024-03-15 03:03:03',1,NULL),(48,'#10000048',10,'1','default','pending',1233.00,0.00,0.00,NULL,NULL,0.00,1233.00,1,NULL,1,NULL,'lDQPEwL7y9DPzmUbkNpaBnMG6tHlj',48,'2024-03-12 03:02:54','2024-03-15 03:02:54',3,NULL),(49,'#10000049',10,'1','default','pending',1062.00,0.00,0.00,NULL,NULL,0.00,1062.00,1,NULL,1,NULL,'jnaX84WVYcPmKMnEJZmHW9dJf481X',49,'2024-03-14 19:02:55','2024-03-15 03:02:55',2,NULL),(50,'#10000050',9,NULL,'','completed',635.00,0.00,0.00,NULL,NULL,0.00,635.00,1,NULL,1,'2024-03-15 03:02:56','9UmTiUPuIyxaRErL15ayl4x3knklq',50,'2024-03-13 21:02:55','2024-03-15 03:02:56',5,NULL),(51,'#10000051',9,'1','default','completed',5649.00,0.00,0.00,NULL,NULL,0.00,5649.00,1,NULL,1,'2024-03-15 03:03:03','hummXBhE3prWcJbKoikZYRQ5kEYRL',51,'2024-03-14 15:02:56','2024-03-15 03:03:03',3,NULL),(52,'#10000052',10,'1','default','pending',1865.00,0.00,0.00,NULL,NULL,0.00,1865.00,1,NULL,1,NULL,'srmNT3D8tSzdwOUXZQwiceeU29eDt',52,'2024-03-13 11:02:56','2024-03-15 03:02:56',4,NULL),(53,'#10000053',10,'1','default','completed',2470.00,0.00,0.00,NULL,NULL,0.00,2470.00,1,NULL,1,'2024-03-15 03:03:04','YpJPMcvtxxmXrB3ag9sL5ZpCIYcoy',53,'2024-03-13 15:02:56','2024-03-15 03:03:04',6,NULL),(54,'#10000054',10,'1','default','completed',2702.00,0.00,0.00,NULL,NULL,0.00,2702.00,1,NULL,1,'2024-03-15 03:02:57','OZIoZTlXUmoi53jbe58u3T8JCBkGw',54,'2024-03-13 11:02:56','2024-03-15 03:02:57',8,NULL),(55,'#10000055',9,NULL,'','pending',1452.00,0.00,0.00,NULL,NULL,0.00,1452.00,1,NULL,1,NULL,'WLby0qTzQcihfpsp2I10drOL3Xg1r',55,'2024-03-14 19:02:57','2024-03-15 03:02:57',1,NULL),(56,'#10000056',9,NULL,'','pending',2124.00,0.00,0.00,NULL,NULL,0.00,2124.00,1,NULL,1,NULL,'kR6XF27f4t06cbmoLaznRJNTD4uTa',56,'2024-03-15 01:02:57','2024-03-15 03:02:57',2,NULL),(57,'#10000057',9,'1','default','pending',319.00,0.00,0.00,NULL,NULL,0.00,319.00,1,NULL,1,NULL,'hu7ZXaijoCpbmVplAbT2exmeZ3hln',57,'2024-03-14 17:02:57','2024-03-15 03:02:57',5,NULL);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2024-03-15 03:02:29','2024-03-15 03:02:29',0),(2,'Size','size','text',1,1,1,'published',1,'2024-03-15 03:02:29','2024-03-15 03:02:29',0),(3,'Weight','weight','text',1,1,1,'published',0,'2024-03-15 03:02:29','2024-03-15 03:02:29',0),(4,'Boxes','boxes','text',1,1,1,'published',1,'2024-03-15 03:02:29','2024-03-15 03:02:29',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(2,1,'Blue','blue','#333333',NULL,0,2,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(3,1,'Red','red','#DA323F',NULL,0,3,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(4,1,'Black','black','#2F366C',NULL,0,4,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(6,2,'S','s',NULL,NULL,1,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(7,2,'M','m',NULL,NULL,0,2,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(8,2,'L','l',NULL,NULL,0,3,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(9,2,'XL','xl',NULL,NULL,0,4,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(11,3,'1KG','1kg',NULL,NULL,1,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(12,3,'2KG','2kg',NULL,NULL,0,2,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(13,3,'3KG','3kg',NULL,NULL,0,3,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(14,3,'4KG','4kg',NULL,NULL,0,4,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(15,3,'5KG','5kg',NULL,NULL,0,5,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(16,4,'1 Box','1-box',NULL,NULL,1,1,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(17,4,'2 Boxes','2-boxes',NULL,NULL,0,2,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(18,4,'3 Boxes','3-boxes',NULL,NULL,0,3,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(19,4,'4 Boxes','4-boxes',NULL,NULL,0,4,'2024-03-15 03:02:29','2024-03-15 03:02:29'),(20,4,'5 Boxes','5-boxes',NULL,NULL,0,5,'2024-03-15 03:02:29','2024-03-15 03:02:29');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Discover Skincare',0,NULL,'published',0,'beauty/product-categories/1.jpg',0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(2,'Clothing',0,NULL,'published',1,'beauty/product-categories/4.jpg',0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(3,'Men\'s Clothing',2,NULL,'published',0,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(4,'T-Shirts',3,NULL,'published',0,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(5,'Jeans',3,NULL,'published',1,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(6,'Suits',3,NULL,'published',2,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(7,'Women\'s Clothing',2,NULL,'published',1,'beauty/product-categories/2.jpg',0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(8,'Dresses',7,NULL,'published',0,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(9,'Blouses',7,NULL,'published',1,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(10,'Pants',7,NULL,'published',2,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(11,'Accessories',0,NULL,'published',2,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(12,'Hats',11,NULL,'published',0,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(13,'Scarves',11,NULL,'published',1,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(14,'Jewelry',11,NULL,'published',2,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(15,'Sportswear',0,NULL,'published',3,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(16,'Activewear',15,NULL,'published',0,NULL,0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(17,'Running Shoes',15,NULL,'published',1,'beauty/product-categories/3.jpg',0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,2),(1,5),(1,7),(1,8),(1,19),(1,23),(1,28),(1,40),(1,42),(2,3),(2,11),(2,16),(2,17),(2,22),(2,26),(2,27),(2,31),(2,35),(2,39),(3,6),(3,8),(3,14),(3,32),(3,42),(4,1),(4,2),(4,10),(4,13),(4,20),(4,26),(4,29),(4,38),(4,41),(5,1),(5,4),(5,9),(5,11),(5,12),(5,13),(5,14),(5,16),(5,17),(5,19),(5,22),(5,25),(5,26),(5,27),(5,33),(5,36),(5,39),(5,40),(5,43),(6,6),(6,7),(6,19),(6,21),(6,23),(6,25),(6,27),(6,28),(6,43),(7,6),(7,12),(7,14),(7,15),(7,21),(7,28),(7,30),(7,34),(7,35),(7,36),(7,41),(7,43),(8,7),(8,12),(8,15),(8,17),(8,24),(8,34),(8,41),(9,5),(9,9),(9,10),(9,16),(9,18),(9,20),(9,22),(9,24),(9,30),(9,31),(9,33),(9,34),(9,35),(9,36),(9,37),(9,38),(9,39),(9,43),(10,5),(10,11),(10,13),(10,15),(10,22),(10,27),(10,32),(10,42),(11,3),(11,8),(11,13),(11,23),(11,24),(11,32),(11,34),(11,39),(11,41),(12,3),(12,11),(12,16),(12,18),(12,25),(12,37),(13,1),(13,2),(13,4),(13,7),(13,15),(13,18),(13,19),(13,20),(13,23),(13,25),(13,26),(13,29),(13,38),(14,1),(14,3),(14,5),(14,8),(14,9),(14,10),(14,14),(14,24),(14,28),(14,30),(14,33),(14,37),(15,2),(15,4),(15,9),(15,10),(15,12),(15,20),(15,21),(15,29),(15,30),(15,35),(15,36),(16,4),(16,17),(16,29),(16,31),(16,32),(16,33),(16,37),(16,40),(17,6),(17,18),(17,21),(17,31),(17,38),(17,40),(17,42);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,12),(1,15),(1,25),(1,26),(1,32),(1,36),(2,1),(2,6),(2,8),(2,9),(2,10),(2,11),(2,16),(2,21),(2,22),(2,23),(2,29),(2,31),(2,37),(2,38),(2,40),(2,41),(3,2),(3,3),(3,13),(3,19),(3,28),(3,30),(3,33),(3,35),(4,4),(4,5),(4,7),(4,14),(4,17),(4,18),(4,20),(4,24),(4,27),(4,34),(4,39),(4,42),(4,43);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'Trendy Wardrobe Essentials','trendy-wardrobe-essentials',NULL,NULL,'published','2024-03-15 03:02:38','2024-03-15 03:02:38',0),(2,'Fashion Forward Finds','fashion-forward-finds',NULL,NULL,'published','2024-03-15 03:02:38','2024-03-15 03:02:38',0),(3,'Chic &amp; Stylish Collection','chic-stylish-collection',NULL,NULL,'published','2024-03-15 03:02:38','2024-03-15 03:02:38',0),(4,'Weekly Fashion Picks','weekly-fashion-picks',NULL,NULL,'published','2024-03-15 03:02:38','2024-03-15 03:02:38',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,4,0,0.00,'fixed',1),(1,10,0,0.00,'fixed',1),(1,12,0,0.00,'fixed',1),(1,14,0,0.00,'fixed',1),(1,20,0,0.00,'fixed',1),(2,3,0,0.00,'fixed',1),(2,4,0,0.00,'fixed',1),(2,7,0,0.00,'fixed',1),(2,12,0,0.00,'fixed',1),(2,16,0,0.00,'fixed',1),(3,1,0,0.00,'fixed',1),(3,5,0,0.00,'fixed',1),(3,8,0,0.00,'fixed',1),(3,11,0,0.00,'fixed',1),(3,15,0,0.00,'fixed',1),(3,17,0,0.00,'fixed',1),(3,18,0,0.00,'fixed',1),(4,5,0,0.00,'fixed',1),(4,10,0,0.00,'fixed',1),(4,14,0,0.00,'fixed',1),(4,15,0,0.00,'fixed',1),(4,16,0,0.00,'fixed',1),(4,18,0,0.00,'fixed',1),(5,1,0,0.00,'fixed',1),(5,4,0,0.00,'fixed',1),(5,7,0,0.00,'fixed',1),(5,11,0,0.00,'fixed',1),(5,14,0,0.00,'fixed',1),(5,18,0,0.00,'fixed',1),(6,1,0,0.00,'fixed',1),(6,3,0,0.00,'fixed',1),(6,9,0,0.00,'fixed',1),(6,10,0,0.00,'fixed',1),(6,11,0,0.00,'fixed',1),(6,16,0,0.00,'fixed',1),(6,18,0,0.00,'fixed',1),(7,1,0,0.00,'fixed',1),(7,5,0,0.00,'fixed',1),(7,6,0,0.00,'fixed',1),(7,10,0,0.00,'fixed',1),(7,14,0,0.00,'fixed',1),(7,19,0,0.00,'fixed',1),(8,7,0,0.00,'fixed',1),(8,9,0,0.00,'fixed',1),(8,11,0,0.00,'fixed',1),(8,14,0,0.00,'fixed',1),(8,17,0,0.00,'fixed',1),(8,19,0,0.00,'fixed',1),(9,1,0,0.00,'fixed',1),(9,3,0,0.00,'fixed',1),(9,7,0,0.00,'fixed',1),(9,12,0,0.00,'fixed',1),(9,14,0,0.00,'fixed',1),(9,17,0,0.00,'fixed',1),(10,2,0,0.00,'fixed',1),(10,3,0,0.00,'fixed',1),(10,7,0,0.00,'fixed',1),(10,11,0,0.00,'fixed',1),(10,13,0,0.00,'fixed',1),(10,15,0,0.00,'fixed',1),(10,17,0,0.00,'fixed',1),(11,1,0,0.00,'fixed',1),(11,2,0,0.00,'fixed',1),(11,4,0,0.00,'fixed',1),(11,5,0,0.00,'fixed',1),(11,6,0,0.00,'fixed',1),(11,14,0,0.00,'fixed',1),(12,6,0,0.00,'fixed',1),(12,8,0,0.00,'fixed',1),(12,9,0,0.00,'fixed',1),(12,10,0,0.00,'fixed',1),(12,17,0,0.00,'fixed',1),(13,2,0,0.00,'fixed',1),(13,3,0,0.00,'fixed',1),(13,4,0,0.00,'fixed',1),(13,7,0,0.00,'fixed',1),(13,9,0,0.00,'fixed',1),(13,18,0,0.00,'fixed',1),(13,19,0,0.00,'fixed',1),(14,3,0,0.00,'fixed',1),(14,9,0,0.00,'fixed',1),(14,12,0,0.00,'fixed',1),(14,13,0,0.00,'fixed',1),(14,15,0,0.00,'fixed',1),(14,20,0,0.00,'fixed',1),(15,1,0,0.00,'fixed',1),(15,5,0,0.00,'fixed',1),(15,6,0,0.00,'fixed',1),(15,13,0,0.00,'fixed',1),(15,17,0,0.00,'fixed',1),(15,20,0,0.00,'fixed',1),(16,4,0,0.00,'fixed',1),(16,8,0,0.00,'fixed',1),(16,11,0,0.00,'fixed',1),(16,14,0,0.00,'fixed',1),(16,15,0,0.00,'fixed',1),(16,19,0,0.00,'fixed',1),(17,1,0,0.00,'fixed',1),(17,2,0,0.00,'fixed',1),(17,7,0,0.00,'fixed',1),(17,9,0,0.00,'fixed',1),(17,13,0,0.00,'fixed',1),(18,1,0,0.00,'fixed',1),(18,2,0,0.00,'fixed',1),(18,4,0,0.00,'fixed',1),(18,5,0,0.00,'fixed',1),(18,7,0,0.00,'fixed',1),(18,13,0,0.00,'fixed',1),(19,6,0,0.00,'fixed',1),(19,9,0,0.00,'fixed',1),(19,12,0,0.00,'fixed',1),(19,17,0,0.00,'fixed',1),(19,18,0,0.00,'fixed',1),(20,1,0,0.00,'fixed',1),(20,4,0,0.00,'fixed',1),(20,7,0,0.00,'fixed',1),(20,9,0,0.00,'fixed',1),(20,14,0,0.00,'fixed',1),(20,16,0,0.00,'fixed',1),(21,5,0,0.00,'fixed',1),(21,6,0,0.00,'fixed',1),(21,7,0,0.00,'fixed',1),(21,8,0,0.00,'fixed',1),(21,11,0,0.00,'fixed',1),(21,14,0,0.00,'fixed',1),(21,19,0,0.00,'fixed',1),(22,1,0,0.00,'fixed',1),(22,3,0,0.00,'fixed',1),(22,6,0,0.00,'fixed',1),(22,12,0,0.00,'fixed',1),(22,17,0,0.00,'fixed',1),(22,18,0,0.00,'fixed',1),(23,1,0,0.00,'fixed',1),(23,2,0,0.00,'fixed',1),(23,7,0,0.00,'fixed',1),(23,9,0,0.00,'fixed',1),(23,12,0,0.00,'fixed',1),(23,13,0,0.00,'fixed',1),(24,2,0,0.00,'fixed',1),(24,3,0,0.00,'fixed',1),(24,6,0,0.00,'fixed',1),(24,9,0,0.00,'fixed',1),(24,12,0,0.00,'fixed',1),(24,18,0,0.00,'fixed',1),(24,19,0,0.00,'fixed',1),(25,5,0,0.00,'fixed',1),(25,7,0,0.00,'fixed',1),(25,9,0,0.00,'fixed',1),(25,12,0,0.00,'fixed',1),(25,14,0,0.00,'fixed',1),(25,18,0,0.00,'fixed',1),(26,3,0,0.00,'fixed',1),(26,8,0,0.00,'fixed',1),(26,9,0,0.00,'fixed',1),(26,10,0,0.00,'fixed',1),(26,12,0,0.00,'fixed',1),(26,19,0,0.00,'fixed',1),(27,2,0,0.00,'fixed',1),(27,4,0,0.00,'fixed',1),(27,7,0,0.00,'fixed',1),(27,10,0,0.00,'fixed',1),(27,18,0,0.00,'fixed',1),(28,1,0,0.00,'fixed',1),(28,2,0,0.00,'fixed',1),(28,6,0,0.00,'fixed',1),(28,9,0,0.00,'fixed',1),(28,13,0,0.00,'fixed',1),(28,15,0,0.00,'fixed',1),(29,1,0,0.00,'fixed',1),(29,2,0,0.00,'fixed',1),(29,10,0,0.00,'fixed',1),(29,11,0,0.00,'fixed',1),(29,17,0,0.00,'fixed',1),(29,19,0,0.00,'fixed',1),(30,1,0,0.00,'fixed',1),(30,5,0,0.00,'fixed',1),(30,11,0,0.00,'fixed',1),(30,15,0,0.00,'fixed',1),(30,16,0,0.00,'fixed',1),(30,17,0,0.00,'fixed',1),(30,19,0,0.00,'fixed',1),(31,1,0,0.00,'fixed',1),(31,2,0,0.00,'fixed',1),(31,7,0,0.00,'fixed',1),(31,8,0,0.00,'fixed',1),(31,14,0,0.00,'fixed',1),(31,16,0,0.00,'fixed',1),(31,19,0,0.00,'fixed',1),(32,1,0,0.00,'fixed',1),(32,3,0,0.00,'fixed',1),(32,7,0,0.00,'fixed',1),(32,15,0,0.00,'fixed',1),(32,16,0,0.00,'fixed',1),(32,17,0,0.00,'fixed',1),(32,19,0,0.00,'fixed',1),(33,1,0,0.00,'fixed',1),(33,5,0,0.00,'fixed',1),(33,9,0,0.00,'fixed',1),(33,13,0,0.00,'fixed',1),(33,14,0,0.00,'fixed',1),(33,15,0,0.00,'fixed',1),(33,19,0,0.00,'fixed',1),(34,1,0,0.00,'fixed',1),(34,5,0,0.00,'fixed',1),(34,15,0,0.00,'fixed',1),(34,16,0,0.00,'fixed',1),(34,17,0,0.00,'fixed',1),(34,19,0,0.00,'fixed',1),(35,1,0,0.00,'fixed',1),(35,4,0,0.00,'fixed',1),(35,6,0,0.00,'fixed',1),(35,10,0,0.00,'fixed',1),(35,11,0,0.00,'fixed',1),(35,13,0,0.00,'fixed',1),(35,18,0,0.00,'fixed',1),(36,3,0,0.00,'fixed',1),(36,4,0,0.00,'fixed',1),(36,6,0,0.00,'fixed',1),(36,14,0,0.00,'fixed',1),(36,16,0,0.00,'fixed',1),(36,17,0,0.00,'fixed',1),(37,1,0,0.00,'fixed',1),(37,3,0,0.00,'fixed',1),(37,10,0,0.00,'fixed',1),(37,14,0,0.00,'fixed',1),(37,15,0,0.00,'fixed',1),(37,16,0,0.00,'fixed',1),(38,2,0,0.00,'fixed',1),(38,5,0,0.00,'fixed',1),(38,9,0,0.00,'fixed',1),(38,13,0,0.00,'fixed',1),(38,14,0,0.00,'fixed',1),(38,16,0,0.00,'fixed',1),(39,1,0,0.00,'fixed',1),(39,4,0,0.00,'fixed',1),(39,10,0,0.00,'fixed',1),(39,14,0,0.00,'fixed',1),(39,17,0,0.00,'fixed',1),(39,18,0,0.00,'fixed',1),(40,4,0,0.00,'fixed',1),(40,7,0,0.00,'fixed',1),(40,10,0,0.00,'fixed',1),(40,11,0,0.00,'fixed',1),(40,16,0,0.00,'fixed',1),(40,18,0,0.00,'fixed',1),(40,19,0,0.00,'fixed',1),(41,2,0,0.00,'fixed',1),(41,7,0,0.00,'fixed',1),(41,9,0,0.00,'fixed',1),(41,10,0,0.00,'fixed',1),(41,12,0,0.00,'fixed',1),(41,16,0,0.00,'fixed',1),(41,18,0,0.00,'fixed',1),(42,5,0,0.00,'fixed',1),(42,6,0,0.00,'fixed',1),(42,9,0,0.00,'fixed',1),(42,10,0,0.00,'fixed',1),(42,12,0,0.00,'fixed',1),(42,13,0,0.00,'fixed',1),(43,3,0,0.00,'fixed',1),(43,4,0,0.00,'fixed',1),(43,6,0,0.00,'fixed',1),(43,9,0,0.00,'fixed',1),(43,13,0,0.00,'fixed',1),(43,19,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,50,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(2,50,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(3,50,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(4,50,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(5,50,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(6,50,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(7,50,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(8,51,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(9,51,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(10,51,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(11,51,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(12,51,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(13,51,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(14,51,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(15,52,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(16,52,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(17,52,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(18,52,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(19,52,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(20,52,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(21,52,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(22,53,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(23,53,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(24,53,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(25,53,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(26,53,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(27,53,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(28,53,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(29,59,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(30,59,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(31,59,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(32,59,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:40\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:40','2024-03-15 03:02:40'),(33,68,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(34,68,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(35,68,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(36,68,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(37,68,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(38,68,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(39,68,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(40,69,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(41,69,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(42,69,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(43,69,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(44,69,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(45,69,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(46,69,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(47,79,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(48,79,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(49,79,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(50,86,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(51,86,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(52,86,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(53,86,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(54,86,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(55,87,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(56,87,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(57,87,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(58,87,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(59,87,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(60,99,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(61,99,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(62,99,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(63,100,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(64,100,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(65,100,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:41\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:41','2024-03-15 03:02:41'),(66,111,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(67,111,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(68,111,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(69,111,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(70,111,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(71,111,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(72,111,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(73,112,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(74,112,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(75,112,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(76,112,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(77,112,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(78,112,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(79,112,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(80,113,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(81,113,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(82,113,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(83,113,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(84,113,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(85,113,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(86,113,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(87,114,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(88,114,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(89,114,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(90,114,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(91,114,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(92,114,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(93,114,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(94,121,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(95,121,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(96,121,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(97,121,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(98,121,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(99,121,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(100,121,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(101,122,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(102,122,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(103,122,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(104,122,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(105,122,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(106,122,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(107,122,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(108,123,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(109,123,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(110,123,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(111,123,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(112,123,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(113,123,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(114,123,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(115,124,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(116,124,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(117,124,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(118,124,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(119,124,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(120,124,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(121,124,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(122,130,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(123,130,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(124,130,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(125,130,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(126,130,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(127,130,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(128,130,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(129,130,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(130,139,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(131,139,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(132,139,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(133,139,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(134,139,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(135,139,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(136,139,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(137,140,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(138,140,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(139,140,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(140,140,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(141,140,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(142,140,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42'),(143,140,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:02:42\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:02:42','2024-03-15 03:02:42');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,3),(1,6),(1,9),(1,15),(1,36),(2,18),(2,21),(2,27),(2,33),(2,39),(3,12),(3,24),(3,30),(3,42);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#cb4321','published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(2,'New','#00c9a7','published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(3,'Sale','#ba591d','published','2024-03-15 03:02:29','2024-03-15 03:02:29');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,1),(1,5),(1,6),(2,3),(2,4),(2,5),(3,1),(3,3),(3,5),(4,2),(4,4),(4,5),(5,1),(5,2),(5,6),(6,1),(6,2),(6,5),(7,2),(7,5),(7,6),(8,2),(8,3),(8,4),(9,1),(9,3),(9,6),(10,3),(10,4),(10,5),(11,1),(11,5),(11,6),(12,2),(12,5),(12,6),(13,2),(13,3),(13,6),(14,2),(14,3),(14,6),(15,1),(15,3),(15,5),(16,1),(16,3),(16,6),(17,1),(17,2),(17,4),(18,2),(18,4),(18,6),(19,2),(19,3),(19,6),(20,1),(20,2),(20,5),(21,2),(21,5),(21,6),(22,1),(22,2),(22,6),(23,2),(23,3),(23,4),(24,1),(24,5),(24,6),(25,1),(25,3),(25,6),(26,2),(26,4),(26,6),(27,2),(27,4),(27,5),(28,3),(28,5),(28,6),(29,1),(29,2),(29,4),(30,1),(30,5),(30,6),(31,1),(31,5),(31,6),(32,1),(32,3),(32,5),(33,1),(33,2),(33,4),(34,3),(34,5),(34,6),(35,2),(35,5),(35,6),(36,3),(36,4),(36,6),(37,3),(37,5),(37,6),(38,1),(38,2),(38,6),(39,1),(39,2),(39,6),(40,2),(40,4),(40,5),(41,1),(41,5),(41,6),(42,1),(42,2),(42,4),(43,2),(43,3),(43,4);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2024-03-15 03:02:32','2024-03-15 03:02:32'),(2,'Mobile',NULL,'published','2024-03-15 03:02:32','2024-03-15 03:02:32'),(3,'Iphone',NULL,'published','2024-03-15 03:02:32','2024-03-15 03:02:32'),(4,'Printer',NULL,'published','2024-03-15 03:02:32','2024-03-15 03:02:32'),(5,'Office',NULL,'published','2024-03-15 03:02:32','2024-03-15 03:02:32'),(6,'IT',NULL,'published','2024-03-15 03:02:32','2024-03-15 03:02:32');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (9,1,5),(19,1,10),(25,1,13),(31,1,16),(45,1,23),(53,1,27),(61,1,31),(65,1,33),(75,1,38),(79,1,40),(93,1,47),(107,1,54),(5,2,3),(7,2,4),(29,2,15),(33,2,17),(37,2,19),(49,2,25),(51,2,26),(87,2,44),(95,2,48),(99,2,50),(101,2,51),(11,3,6),(15,3,8),(21,3,11),(27,3,14),(41,3,21),(43,3,22),(57,3,29),(59,3,30),(83,3,42),(105,3,53),(1,4,1),(3,4,2),(13,4,7),(23,4,12),(47,4,24),(69,4,35),(71,4,36),(77,4,39),(81,4,41),(85,4,43),(89,4,45),(91,4,46),(97,4,49),(103,4,52),(109,4,55),(17,5,9),(35,5,18),(39,5,20),(55,5,28),(63,5,32),(67,5,34),(73,5,37),(4,6,2),(6,6,3),(8,6,4),(12,6,6),(20,6,10),(26,6,13),(36,6,18),(42,6,21),(56,6,28),(66,6,33),(70,6,35),(74,6,37),(76,6,38),(82,6,41),(90,6,45),(102,6,51),(106,6,53),(34,7,17),(38,7,19),(52,7,26),(80,7,40),(86,7,43),(92,7,46),(110,7,55),(10,8,5),(16,8,8),(18,8,9),(44,8,22),(58,8,29),(84,8,42),(104,8,52),(2,9,1),(28,9,14),(30,9,15),(46,9,23),(62,9,31),(64,9,32),(78,9,39),(88,9,44),(94,9,47),(98,9,49),(14,10,7),(22,10,11),(24,10,12),(32,10,16),(40,10,20),(48,10,24),(50,10,25),(54,10,27),(60,10,30),(68,10,34),(72,10,36),(96,10,48),(100,10,50),(108,10,54),(115,11,58),(127,11,64),(129,11,65),(141,11,71),(145,11,73),(155,11,78),(161,11,81),(171,11,86),(177,11,89),(179,11,90),(185,11,93),(113,12,57),(137,12,69),(167,12,84),(169,12,85),(183,12,92),(195,12,98),(203,12,102),(209,12,105),(119,13,60),(153,13,77),(157,13,79),(165,13,83),(175,13,88),(193,13,97),(197,13,99),(111,14,56),(123,14,62),(135,14,68),(139,14,70),(143,14,72),(149,14,75),(159,14,80),(173,14,87),(181,14,91),(187,14,94),(189,14,95),(201,14,101),(207,14,104),(117,15,59),(121,15,61),(125,15,63),(131,15,66),(133,15,67),(147,15,74),(151,15,76),(163,15,82),(191,15,96),(199,15,100),(205,15,103),(130,16,65),(168,16,84),(182,16,91),(184,16,92),(186,16,93),(192,16,96),(196,16,98),(200,16,100),(204,16,102),(118,17,59),(122,17,61),(126,17,63),(136,17,68),(140,17,70),(156,17,78),(162,17,81),(170,17,85),(176,17,88),(180,17,90),(210,17,105),(114,18,57),(124,18,62),(132,18,66),(138,18,69),(142,18,71),(146,18,73),(150,18,75),(152,18,76),(154,18,77),(160,18,80),(172,18,86),(174,18,87),(178,18,89),(112,19,56),(116,19,58),(144,19,72),(148,19,74),(166,19,83),(188,19,94),(190,19,95),(194,19,97),(198,19,99),(202,19,101),(120,20,60),(128,20,64),(134,20,67),(158,20,79),(164,20,82),(206,20,103),(208,20,104);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,44,1,1),(2,45,1,0),(3,46,1,0),(4,47,2,1),(5,48,2,0),(6,49,3,1),(7,50,4,1),(8,51,4,0),(9,52,4,0),(10,53,4,0),(11,54,5,1),(12,55,6,1),(13,56,6,0),(14,57,7,1),(15,58,7,0),(16,59,8,1),(17,60,9,1),(18,61,9,0),(19,62,9,0),(20,63,9,0),(21,64,10,1),(22,65,10,0),(23,66,10,0),(24,67,11,1),(25,68,12,1),(26,69,12,0),(27,70,13,1),(28,71,13,0),(29,72,13,0),(30,73,14,1),(31,74,14,0),(32,75,14,0),(33,76,15,1),(34,77,15,0),(35,78,15,0),(36,79,16,1),(37,80,17,1),(38,81,17,0),(39,82,18,1),(40,83,19,1),(41,84,19,0),(42,85,19,0),(43,86,20,1),(44,87,20,0),(45,88,21,1),(46,89,21,0),(47,90,21,0),(48,91,21,0),(49,92,21,0),(50,93,22,1),(51,94,22,0),(52,95,22,0),(53,96,23,1),(54,97,23,0),(55,98,23,0),(56,99,24,1),(57,100,24,0),(58,101,25,1),(59,102,25,0),(60,103,26,1),(61,104,26,0),(62,105,26,0),(63,106,26,0),(64,107,27,1),(65,108,27,0),(66,109,27,0),(67,110,27,0),(68,111,28,1),(69,112,28,0),(70,113,28,0),(71,114,28,0),(72,115,29,1),(73,116,30,1),(74,117,31,1),(75,118,31,0),(76,119,31,0),(77,120,31,0),(78,121,32,1),(79,122,32,0),(80,123,32,0),(81,124,32,0),(82,125,33,1),(83,126,34,1),(84,127,35,1),(85,128,35,0),(86,129,35,0),(87,130,36,1),(88,131,37,1),(89,132,37,0),(90,133,38,1),(91,134,38,0),(92,135,38,0),(93,136,39,1),(94,137,39,0),(95,138,39,0),(96,139,40,1),(97,140,40,0),(98,141,41,1),(99,142,41,0),(100,143,41,0),(101,144,41,0),(102,145,42,1),(103,146,42,0),(104,147,43,1),(105,148,43,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2024-03-15',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(3,24,0),(4,24,0),(3,25,0),(4,25,0),(3,26,0),(4,26,0),(3,27,0),(4,27,0),(3,28,0),(4,28,0),(3,29,0),(4,29,0),(3,30,0),(4,30,0),(3,31,0),(4,31,0),(3,32,0),(4,32,0),(3,33,0),(4,33,0),(3,34,0),(4,34,0),(3,35,0),(4,35,0),(3,36,0),(4,36,0),(3,37,0),(4,37,0),(3,38,0),(4,38,0),(3,39,0),(4,39,0),(3,40,0),(4,40,0),(3,41,0),(4,41,0),(3,42,0),(4,42,0),(3,43,0),(4,43,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `approved_by` bigint unsigned DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Vintage Denim Jacket','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-2.png\"]','CN-192-A0',0,13,0,1,0,4,0,0,478,NULL,NULL,NULL,11.00,11.00,18.00,691.00,NULL,60663,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(2,'Floral Maxi Dress','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-1.png\"]','PR-172-A0',0,15,0,1,1,4,0,0,860,NULL,NULL,NULL,18.00,16.00,17.00,790.00,NULL,94703,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(3,'Leather Ankle Boots','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\"]','5D-197-A0',0,15,0,1,1,4,0,0,1215,NULL,NULL,NULL,17.00,17.00,17.00,617.00,NULL,73659,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(4,'Knit Turtleneck Sweater (Digital)','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-1.png\"]','F1-160-A0',0,11,0,1,1,1,0,0,1908,1392.84,NULL,NULL,20.00,16.00,12.00,813.00,NULL,152216,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(5,'Classic Aviator Sunglasses','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\"]','OI-104-A0',0,14,0,1,1,3,0,0,469,NULL,NULL,NULL,10.00,16.00,14.00,665.00,NULL,96653,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(6,'Tailored Wool Blazer','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-8.png\"]','AC-123-A0',0,18,0,1,1,2,0,0,458,NULL,NULL,NULL,19.00,17.00,13.00,506.00,NULL,162508,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(7,'Bohemian Fringe Handbag','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\"]','5A-192-A0',0,17,0,1,1,5,0,0,421,NULL,NULL,NULL,14.00,13.00,15.00,595.00,NULL,168184,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(8,'Silk Scarf with Geometric Print (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\"]','AK-177-A0',0,10,0,1,1,5,0,0,2317,1853.6,NULL,NULL,10.00,15.00,12.00,790.00,NULL,42507,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(9,'High-Waisted Wide Leg Trousers','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\"]','P7-111-A0',0,19,0,1,0,4,0,0,1865,NULL,NULL,NULL,19.00,19.00,10.00,552.00,NULL,18831,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(10,'Embroidered Boho Blouse','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\"]','E4-126-A0',0,13,0,1,1,3,0,0,1906,NULL,NULL,NULL,11.00,10.00,13.00,533.00,NULL,72239,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(11,'Statement Chunky Necklace','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-2.png\"]','XR-114-A0',0,19,0,1,0,4,0,0,574,NULL,NULL,NULL,18.00,14.00,10.00,556.00,NULL,89870,'2024-03-15 03:02:39','2024-03-15 03:02:40','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(12,'Chic Fedora Hat (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-3.png\"]','YT-191-A0',0,13,0,1,0,5,0,0,1365,1132.95,NULL,NULL,14.00,14.00,17.00,866.00,NULL,31493,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(13,'Strappy Block Heel Sandals','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\"]','PI-148-A0',0,15,0,1,0,2,0,0,2320,NULL,NULL,NULL,14.00,18.00,16.00,608.00,NULL,52880,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(14,'Velvet Evening Gown','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-2.png\"]','VD-145-A0',0,11,0,1,0,2,0,0,1233,NULL,NULL,NULL,14.00,11.00,10.00,753.00,NULL,67141,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(15,'Quilted Crossbody Bag','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-3.png\"]','JX-101-A0',0,16,0,1,0,3,0,0,919,NULL,NULL,NULL,19.00,14.00,18.00,699.00,NULL,5415,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(16,'Distressed Skinny Jeans (Digital)','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-5.png\"]','QA-133-A0',0,14,0,1,0,5,0,0,387,274.77,NULL,NULL,13.00,18.00,12.00,763.00,NULL,120640,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(17,'Lace-Up Combat Boots','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-7.png\"]','DX-154-A0',0,13,0,1,0,5,0,0,1145,NULL,NULL,NULL,15.00,12.00,12.00,654.00,NULL,147576,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(18,'Cotton Striped T-Shirt Dress','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\"]','DV-187-A0',0,10,0,1,1,5,0,0,373,NULL,NULL,NULL,14.00,18.00,20.00,735.00,NULL,59883,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(19,'Printed Palazzo Pants','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-2.png\"]','RU-113-A0',0,12,0,1,1,1,0,0,1182,NULL,NULL,NULL,18.00,10.00,17.00,616.00,NULL,125030,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(20,'Structured Satchel Bag (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-4.png\"]','Q3-136-A0',0,10,0,1,0,1,0,0,2417,2006.11,NULL,NULL,11.00,16.00,10.00,728.00,NULL,5037,'2024-03-15 03:02:39','2024-03-15 03:02:41','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(21,'Off-Shoulder Ruffle Top','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-5.png\"]','OA-196-A0',0,17,0,1,1,5,0,0,2161,NULL,NULL,NULL,16.00,15.00,16.00,799.00,NULL,136121,'2024-03-15 03:02:40','2024-03-15 03:02:41','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(22,'Suede Pointed-Toe Pumps','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\"]','PC-171-A0',0,13,0,1,1,3,0,0,449,NULL,NULL,NULL,20.00,12.00,17.00,523.00,NULL,104408,'2024-03-15 03:02:40','2024-03-15 03:02:41','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(23,'Cropped Cable Knit Sweater','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\"]','F7-126-A0',0,18,0,1,1,4,0,0,699,NULL,NULL,NULL,11.00,14.00,15.00,505.00,NULL,39001,'2024-03-15 03:02:40','2024-03-15 03:02:41','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(24,'Athleisure Jogger Pants (Digital)','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\"]','EO-165-A0',0,12,0,1,1,3,0,0,1452,1306.8,NULL,NULL,16.00,10.00,19.00,597.00,NULL,166480,'2024-03-15 03:02:40','2024-03-15 03:02:41','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(25,'Leopard Print Midi Skirt','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-6.png\"]','QM-167-A0',0,19,0,1,1,3,0,0,890,NULL,NULL,NULL,18.00,19.00,17.00,685.00,NULL,117237,'2024-03-15 03:02:40','2024-03-15 03:02:41','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(26,'Retro Cat-Eye Sunglasses','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\"]','2R-104-A0',0,17,0,1,0,2,0,0,1825,NULL,NULL,NULL,14.00,13.00,18.00,738.00,NULL,114765,'2024-03-15 03:02:40','2024-03-15 03:02:41','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(27,'Faux Fur Trimmed Coat','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-4.png\"]','2O-188-A0',0,10,0,1,1,2,0,0,1792,NULL,NULL,NULL,17.00,15.00,10.00,537.00,NULL,103334,'2024-03-15 03:02:40','2024-03-15 03:02:41','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(28,'Boho Fringed Kimono (Digital)','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-3.png\"]','WS-190-A0',0,18,0,1,1,1,0,0,635,495.3,NULL,NULL,16.00,20.00,16.00,804.00,NULL,173706,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(29,'Ruffled Wrap Dress','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\"]','H6-129-A0',0,20,0,1,0,3,0,0,2317,NULL,NULL,NULL,16.00,11.00,15.00,676.00,NULL,162009,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(30,'Beaded Evening Clutch','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-6.png\"]','3D-196-A0',0,18,0,1,1,1,0,0,1035,NULL,NULL,NULL,14.00,20.00,16.00,781.00,NULL,40719,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(31,'Wide Brim Floppy Hat','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-4.png\"]','9G-113-A0',0,14,0,1,1,3,0,0,1883,NULL,NULL,NULL,16.00,20.00,19.00,740.00,NULL,197065,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(32,'Denim Overall Jumpsuit (Digital)','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-7.png\"]','NI-190-A0',0,17,0,1,0,4,0,0,2124,1677.96,NULL,NULL,18.00,20.00,19.00,877.00,NULL,129736,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(33,'Embellished Ballet Flats','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-4.png\"]','BY-172-A0',0,16,0,1,1,1,0,0,1351,NULL,NULL,NULL,19.00,18.00,11.00,757.00,NULL,18681,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(34,'Pleated Midi Skirt','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\"]','FI-104-A0',0,13,0,1,0,5,0,0,1681,NULL,NULL,NULL,18.00,17.00,14.00,606.00,NULL,91661,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(35,'Velour Tracksuit Set','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-4.png\"]','JG-149-A0',0,16,0,1,0,3,0,0,1062,NULL,NULL,NULL,10.00,18.00,15.00,752.00,NULL,187683,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(36,'Geometric Patterned Cardigan (Digital)','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-5.png\"]','EV-163-A0',0,20,0,1,1,4,0,0,564,445.56,NULL,NULL,12.00,14.00,11.00,858.00,NULL,43483,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(37,'Buckle Detail Ankle Booties','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-7.png\"]','JS-162-A0',0,12,0,1,0,1,0,0,707,NULL,NULL,NULL,13.00,14.00,20.00,826.00,NULL,18532,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(38,'Embroidered Bomber Jacket','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-1.png\"]','RU-193-A0',0,20,0,1,0,3,0,0,1862,NULL,NULL,NULL,11.00,20.00,14.00,884.00,NULL,156446,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(39,'Cowl Neck Knit Poncho','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-4.png\"]','GY-193-A0',0,11,0,1,1,1,0,0,1452,NULL,NULL,NULL,12.00,18.00,13.00,780.00,NULL,41446,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(40,'Chunky Knit Infinity Scarf (Digital)','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-3.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-5.png\"]','7P-165-A0',0,11,0,1,1,5,0,0,503,437.61,NULL,NULL,10.00,17.00,20.00,878.00,NULL,65571,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(41,'Retro High-Top Sneakers','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\"]','OG-141-A0',0,15,0,1,1,4,0,0,319,NULL,NULL,NULL,18.00,20.00,19.00,804.00,NULL,110361,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(42,'Faux Leather Leggings','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-2.png\",\"beauty\\/products\\/product-6.png\",\"beauty\\/products\\/product-8.png\",\"beauty\\/products\\/product-5.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-1.png\"]','3G-196-A0',0,13,0,1,1,2,0,0,986,NULL,NULL,NULL,15.00,12.00,11.00,793.00,NULL,147585,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(43,'Metallic Pleated Maxi Skirt','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"beauty\\/products\\/product-1.png\",\"beauty\\/products\\/product-7.png\",\"beauty\\/products\\/product-4.png\",\"beauty\\/products\\/product-8.png\"]','3F-139-A0',0,17,0,1,1,4,0,0,2418,NULL,NULL,NULL,10.00,19.00,19.00,779.00,NULL,51942,'2024-03-15 03:02:40','2024-03-15 03:02:42','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(44,'Vintage Denim Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','CN-192-A0',0,13,0,1,0,4,1,0,478,NULL,NULL,NULL,11.00,11.00,18.00,691.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(45,'Vintage Denim Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','CN-192-A0-A1',0,13,0,1,0,4,1,0,478,NULL,NULL,NULL,11.00,11.00,18.00,691.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(46,'Vintage Denim Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','CN-192-A0-A2',0,13,0,1,0,4,1,0,478,NULL,NULL,NULL,11.00,11.00,18.00,691.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(47,'Floral Maxi Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','PR-172-A0',0,15,0,1,0,4,1,0,860,NULL,NULL,NULL,18.00,16.00,17.00,790.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(48,'Floral Maxi Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','PR-172-A0-A1',0,15,0,1,0,4,1,0,860,NULL,NULL,NULL,18.00,16.00,17.00,790.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(49,'Leather Ankle Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','5D-197-A0',0,15,0,1,0,4,1,0,1215,NULL,NULL,NULL,17.00,17.00,17.00,617.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(50,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','F1-160-A0',0,11,0,1,0,1,1,0,1908,1392.84,NULL,NULL,20.00,16.00,12.00,813.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(51,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','F1-160-A0-A1',0,11,0,1,0,1,1,0,1908,1659.96,NULL,NULL,20.00,16.00,12.00,813.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(52,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','F1-160-A0-A2',0,11,0,1,0,1,1,0,1908,1659.96,NULL,NULL,20.00,16.00,12.00,813.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(53,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','F1-160-A0-A3',0,11,0,1,0,1,1,0,1908,1545.48,NULL,NULL,20.00,16.00,12.00,813.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(54,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','OI-104-A0',0,14,0,1,0,3,1,0,469,NULL,NULL,NULL,10.00,16.00,14.00,665.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(55,'Tailored Wool Blazer',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','AC-123-A0',0,18,0,1,0,2,1,0,458,NULL,NULL,NULL,19.00,17.00,13.00,506.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(56,'Tailored Wool Blazer',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','AC-123-A0-A1',0,18,0,1,0,2,1,0,458,NULL,NULL,NULL,19.00,17.00,13.00,506.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(57,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','5A-192-A0',0,17,0,1,0,5,1,0,421,NULL,NULL,NULL,14.00,13.00,15.00,595.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(58,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','5A-192-A0-A1',0,17,0,1,0,5,1,0,421,NULL,NULL,NULL,14.00,13.00,15.00,595.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(59,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','AK-177-A0',0,10,0,1,0,5,1,0,2317,1853.6,NULL,NULL,10.00,15.00,12.00,790.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(60,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','P7-111-A0',0,19,0,1,0,4,1,0,1865,NULL,NULL,NULL,19.00,19.00,10.00,552.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(61,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','P7-111-A0-A1',0,19,0,1,0,4,1,0,1865,NULL,NULL,NULL,19.00,19.00,10.00,552.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(62,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','P7-111-A0-A2',0,19,0,1,0,4,1,0,1865,NULL,NULL,NULL,19.00,19.00,10.00,552.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(63,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','P7-111-A0-A3',0,19,0,1,0,4,1,0,1865,NULL,NULL,NULL,19.00,19.00,10.00,552.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(64,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','E4-126-A0',0,13,0,1,0,3,1,0,1906,NULL,NULL,NULL,11.00,10.00,13.00,533.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(65,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','E4-126-A0-A1',0,13,0,1,0,3,1,0,1906,NULL,NULL,NULL,11.00,10.00,13.00,533.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(66,'Embroidered Boho Blouse',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','E4-126-A0-A2',0,13,0,1,0,3,1,0,1906,NULL,NULL,NULL,11.00,10.00,13.00,533.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(67,'Statement Chunky Necklace',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','XR-114-A0',0,19,0,1,0,4,1,0,574,NULL,NULL,NULL,18.00,14.00,10.00,556.00,NULL,0,'2024-03-15 03:02:40','2024-03-15 03:02:40','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(68,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','YT-191-A0',0,13,0,1,0,5,1,0,1365,1132.95,NULL,NULL,14.00,14.00,17.00,866.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(69,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','YT-191-A0-A1',0,13,0,1,0,5,1,0,1365,1105.65,NULL,NULL,14.00,14.00,17.00,866.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(70,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','PI-148-A0',0,15,0,1,0,2,1,0,2320,NULL,NULL,NULL,14.00,18.00,16.00,608.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(71,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','PI-148-A0-A1',0,15,0,1,0,2,1,0,2320,NULL,NULL,NULL,14.00,18.00,16.00,608.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(72,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','PI-148-A0-A2',0,15,0,1,0,2,1,0,2320,NULL,NULL,NULL,14.00,18.00,16.00,608.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(73,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','VD-145-A0',0,11,0,1,0,2,1,0,1233,NULL,NULL,NULL,14.00,11.00,10.00,753.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(74,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','VD-145-A0-A1',0,11,0,1,0,2,1,0,1233,NULL,NULL,NULL,14.00,11.00,10.00,753.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(75,'Velvet Evening Gown',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','VD-145-A0-A2',0,11,0,1,0,2,1,0,1233,NULL,NULL,NULL,14.00,11.00,10.00,753.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(76,'Quilted Crossbody Bag',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','JX-101-A0',0,16,0,1,0,3,1,0,919,NULL,NULL,NULL,19.00,14.00,18.00,699.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(77,'Quilted Crossbody Bag',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','JX-101-A0-A1',0,16,0,1,0,3,1,0,919,NULL,NULL,NULL,19.00,14.00,18.00,699.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(78,'Quilted Crossbody Bag',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','JX-101-A0-A2',0,16,0,1,0,3,1,0,919,NULL,NULL,NULL,19.00,14.00,18.00,699.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(79,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','QA-133-A0',0,14,0,1,0,5,1,0,387,274.77,NULL,NULL,13.00,18.00,12.00,763.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(80,'Lace-Up Combat Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','DX-154-A0',0,13,0,1,0,5,1,0,1145,NULL,NULL,NULL,15.00,12.00,12.00,654.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(81,'Lace-Up Combat Boots',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','DX-154-A0-A1',0,13,0,1,0,5,1,0,1145,NULL,NULL,NULL,15.00,12.00,12.00,654.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(82,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','DV-187-A0',0,10,0,1,0,5,1,0,373,NULL,NULL,NULL,14.00,18.00,20.00,735.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(83,'Printed Palazzo Pants',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','RU-113-A0',0,12,0,1,0,1,1,0,1182,NULL,NULL,NULL,18.00,10.00,17.00,616.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(84,'Printed Palazzo Pants',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','RU-113-A0-A1',0,12,0,1,0,1,1,0,1182,NULL,NULL,NULL,18.00,10.00,17.00,616.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(85,'Printed Palazzo Pants',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','RU-113-A0-A2',0,12,0,1,0,1,1,0,1182,NULL,NULL,NULL,18.00,10.00,17.00,616.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(86,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','Q3-136-A0',0,10,0,1,0,1,1,0,2417,2006.11,NULL,NULL,11.00,16.00,10.00,728.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(87,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','Q3-136-A0-A1',0,10,0,1,0,1,1,0,2417,2102.79,NULL,NULL,11.00,16.00,10.00,728.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(88,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','OA-196-A0',0,17,0,1,0,5,1,0,2161,NULL,NULL,NULL,16.00,15.00,16.00,799.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(89,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','OA-196-A0-A1',0,17,0,1,0,5,1,0,2161,NULL,NULL,NULL,16.00,15.00,16.00,799.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(90,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','OA-196-A0-A2',0,17,0,1,0,5,1,0,2161,NULL,NULL,NULL,16.00,15.00,16.00,799.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(91,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','OA-196-A0-A3',0,17,0,1,0,5,1,0,2161,NULL,NULL,NULL,16.00,15.00,16.00,799.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(92,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','OA-196-A0-A4',0,17,0,1,0,5,1,0,2161,NULL,NULL,NULL,16.00,15.00,16.00,799.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(93,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','PC-171-A0',0,13,0,1,0,3,1,0,449,NULL,NULL,NULL,20.00,12.00,17.00,523.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(94,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','PC-171-A0-A1',0,13,0,1,0,3,1,0,449,NULL,NULL,NULL,20.00,12.00,17.00,523.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(95,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','PC-171-A0-A2',0,13,0,1,0,3,1,0,449,NULL,NULL,NULL,20.00,12.00,17.00,523.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(96,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','F7-126-A0',0,18,0,1,0,4,1,0,699,NULL,NULL,NULL,11.00,14.00,15.00,505.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(97,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','F7-126-A0-A1',0,18,0,1,0,4,1,0,699,NULL,NULL,NULL,11.00,14.00,15.00,505.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(98,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','F7-126-A0-A2',0,18,0,1,0,4,1,0,699,NULL,NULL,NULL,11.00,14.00,15.00,505.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(99,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','EO-165-A0',0,12,0,1,0,3,1,0,1452,1306.8,NULL,NULL,16.00,10.00,19.00,597.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(100,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','EO-165-A0-A1',0,12,0,1,0,3,1,0,1452,1306.8,NULL,NULL,16.00,10.00,19.00,597.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(101,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','QM-167-A0',0,19,0,1,0,3,1,0,890,NULL,NULL,NULL,18.00,19.00,17.00,685.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(102,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','QM-167-A0-A1',0,19,0,1,0,3,1,0,890,NULL,NULL,NULL,18.00,19.00,17.00,685.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(103,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','2R-104-A0',0,17,0,1,0,2,1,0,1825,NULL,NULL,NULL,14.00,13.00,18.00,738.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(104,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','2R-104-A0-A1',0,17,0,1,0,2,1,0,1825,NULL,NULL,NULL,14.00,13.00,18.00,738.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(105,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','2R-104-A0-A2',0,17,0,1,0,2,1,0,1825,NULL,NULL,NULL,14.00,13.00,18.00,738.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(106,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','2R-104-A0-A3',0,17,0,1,0,2,1,0,1825,NULL,NULL,NULL,14.00,13.00,18.00,738.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(107,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','2O-188-A0',0,10,0,1,0,2,1,0,1792,NULL,NULL,NULL,17.00,15.00,10.00,537.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(108,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','2O-188-A0-A1',0,10,0,1,0,2,1,0,1792,NULL,NULL,NULL,17.00,15.00,10.00,537.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(109,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','2O-188-A0-A2',0,10,0,1,0,2,1,0,1792,NULL,NULL,NULL,17.00,15.00,10.00,537.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(110,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','2O-188-A0-A3',0,10,0,1,0,2,1,0,1792,NULL,NULL,NULL,17.00,15.00,10.00,537.00,NULL,0,'2024-03-15 03:02:41','2024-03-15 03:02:41','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(111,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','WS-190-A0',0,18,0,1,0,1,1,0,635,495.3,NULL,NULL,16.00,20.00,16.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(112,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','WS-190-A0-A1',0,18,0,1,0,1,1,0,635,488.95,NULL,NULL,16.00,20.00,16.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(113,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','WS-190-A0-A2',0,18,0,1,0,1,1,0,635,533.4,NULL,NULL,16.00,20.00,16.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(114,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','WS-190-A0-A3',0,18,0,1,0,1,1,0,635,450.85,NULL,NULL,16.00,20.00,16.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(115,'Ruffled Wrap Dress',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','H6-129-A0',0,20,0,1,0,3,1,0,2317,NULL,NULL,NULL,16.00,11.00,15.00,676.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(116,'Beaded Evening Clutch',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','3D-196-A0',0,18,0,1,0,1,1,0,1035,NULL,NULL,NULL,14.00,20.00,16.00,781.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(117,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','9G-113-A0',0,14,0,1,0,3,1,0,1883,NULL,NULL,NULL,16.00,20.00,19.00,740.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(118,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','9G-113-A0-A1',0,14,0,1,0,3,1,0,1883,NULL,NULL,NULL,16.00,20.00,19.00,740.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(119,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','9G-113-A0-A2',0,14,0,1,0,3,1,0,1883,NULL,NULL,NULL,16.00,20.00,19.00,740.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(120,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','9G-113-A0-A3',0,14,0,1,0,3,1,0,1883,NULL,NULL,NULL,16.00,20.00,19.00,740.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(121,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','NI-190-A0',0,17,0,1,0,4,1,0,2124,1677.96,NULL,NULL,18.00,20.00,19.00,877.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(122,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','NI-190-A0-A1',0,17,0,1,0,4,1,0,2124,1720.44,NULL,NULL,18.00,20.00,19.00,877.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(123,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','NI-190-A0-A2',0,17,0,1,0,4,1,0,2124,1869.12,NULL,NULL,18.00,20.00,19.00,877.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(124,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','NI-190-A0-A3',0,17,0,1,0,4,1,0,2124,1826.64,NULL,NULL,18.00,20.00,19.00,877.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(125,'Embellished Ballet Flats',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','BY-172-A0',0,16,0,1,0,1,1,0,1351,NULL,NULL,NULL,19.00,18.00,11.00,757.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(126,'Pleated Midi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','FI-104-A0',0,13,0,1,0,5,1,0,1681,NULL,NULL,NULL,18.00,17.00,14.00,606.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(127,'Velour Tracksuit Set',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','JG-149-A0',0,16,0,1,0,3,1,0,1062,NULL,NULL,NULL,10.00,18.00,15.00,752.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(128,'Velour Tracksuit Set',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','JG-149-A0-A1',0,16,0,1,0,3,1,0,1062,NULL,NULL,NULL,10.00,18.00,15.00,752.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(129,'Velour Tracksuit Set',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','JG-149-A0-A2',0,16,0,1,0,3,1,0,1062,NULL,NULL,NULL,10.00,18.00,15.00,752.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(130,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','EV-163-A0',0,20,0,1,0,4,1,0,564,445.56,NULL,NULL,12.00,14.00,11.00,858.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(131,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"beauty\\/products\\/product-3.png\"]','JS-162-A0',0,12,0,1,0,1,1,0,707,NULL,NULL,NULL,13.00,14.00,20.00,826.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(132,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','JS-162-A0-A1',0,12,0,1,0,1,1,0,707,NULL,NULL,NULL,13.00,14.00,20.00,826.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(133,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','RU-193-A0',0,20,0,1,0,3,1,0,1862,NULL,NULL,NULL,11.00,20.00,14.00,884.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(134,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','RU-193-A0-A1',0,20,0,1,0,3,1,0,1862,NULL,NULL,NULL,11.00,20.00,14.00,884.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(135,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','RU-193-A0-A2',0,20,0,1,0,3,1,0,1862,NULL,NULL,NULL,11.00,20.00,14.00,884.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(136,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','GY-193-A0',0,11,0,1,0,1,1,0,1452,NULL,NULL,NULL,12.00,18.00,13.00,780.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(137,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','GY-193-A0-A1',0,11,0,1,0,1,1,0,1452,NULL,NULL,NULL,12.00,18.00,13.00,780.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(138,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','GY-193-A0-A2',0,11,0,1,0,1,1,0,1452,NULL,NULL,NULL,12.00,18.00,13.00,780.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(139,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-4.png\"]','7P-165-A0',0,11,0,1,0,5,1,0,503,437.61,NULL,NULL,10.00,17.00,20.00,878.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(140,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','7P-165-A0-A1',0,11,0,1,0,5,1,0,503,442.64,NULL,NULL,10.00,17.00,20.00,878.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(141,'Retro High-Top Sneakers',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','OG-141-A0',0,15,0,1,0,4,1,0,319,NULL,NULL,NULL,18.00,20.00,19.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(142,'Retro High-Top Sneakers',NULL,NULL,'published','[\"beauty\\/products\\/product-8.png\"]','OG-141-A0-A1',0,15,0,1,0,4,1,0,319,NULL,NULL,NULL,18.00,20.00,19.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(143,'Retro High-Top Sneakers',NULL,NULL,'published','[\"beauty\\/products\\/product-5.png\"]','OG-141-A0-A2',0,15,0,1,0,4,1,0,319,NULL,NULL,NULL,18.00,20.00,19.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(144,'Retro High-Top Sneakers',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','OG-141-A0-A3',0,15,0,1,0,4,1,0,319,NULL,NULL,NULL,18.00,20.00,19.00,804.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(145,'Faux Leather Leggings',NULL,NULL,'published','[\"beauty\\/products\\/product-2.png\"]','3G-196-A0',0,13,0,1,0,2,1,0,986,NULL,NULL,NULL,15.00,12.00,11.00,793.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(146,'Faux Leather Leggings',NULL,NULL,'published','[\"beauty\\/products\\/product-6.png\"]','3G-196-A0-A1',0,13,0,1,0,2,1,0,986,NULL,NULL,NULL,15.00,12.00,11.00,793.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(147,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-1.png\"]','3F-139-A0',0,17,0,1,0,4,1,0,2418,NULL,NULL,NULL,10.00,19.00,19.00,779.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(148,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"beauty\\/products\\/product-7.png\"]','3F-139-A0-A1',0,17,0,1,0,4,1,0,2418,NULL,NULL,NULL,10.00,19.00,19.00,779.00,NULL,0,'2024-03-15 03:02:42','2024-03-15 03:02:42','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,6,17,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\"]'),(2,3,22,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\"]'),(3,9,14,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(4,1,22,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(5,6,43,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(6,3,36,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(7,3,13,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(8,5,12,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(9,1,3,3.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\"]'),(10,7,25,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(11,2,36,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(12,3,17,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-20.jpg\"]'),(13,6,3,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\"]'),(14,2,11,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\"]'),(15,2,31,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\"]'),(16,1,24,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\"]'),(17,9,11,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\"]'),(18,9,4,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\"]'),(19,4,38,1.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(20,7,20,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(21,1,4,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\"]'),(22,9,15,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(23,7,15,1.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(24,2,25,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\"]'),(25,6,4,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(26,6,24,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(27,10,5,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(28,1,25,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\"]'),(29,1,43,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(30,5,39,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-18.jpg\"]'),(31,5,43,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\"]'),(32,3,6,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(33,4,16,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\"]'),(34,6,1,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(35,8,31,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(36,2,34,4.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(37,6,6,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(38,5,35,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\"]'),(40,6,36,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(42,3,7,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(43,8,37,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(44,10,7,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(45,10,34,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(47,10,2,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(48,5,22,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(49,7,11,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\"]'),(50,2,37,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\"]'),(51,7,22,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\"]'),(52,4,12,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(53,5,34,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\"]'),(54,3,8,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\"]'),(55,10,16,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(56,8,42,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(57,3,23,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(60,10,36,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(61,2,2,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(63,6,37,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(64,10,20,3.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(65,4,40,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(67,6,34,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(68,9,36,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(69,8,20,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(70,7,19,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(71,10,3,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(72,9,35,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\"]'),(73,2,35,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(74,1,2,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(75,8,19,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\"]'),(79,7,34,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(80,9,18,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(81,8,10,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(82,2,12,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(83,6,11,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(84,4,36,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(85,7,21,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]'),(86,9,8,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(87,2,4,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(88,8,41,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(89,4,5,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(91,10,38,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(92,1,35,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(93,1,16,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(94,8,15,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(95,1,18,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(97,9,26,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(98,1,42,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(99,4,32,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\"]'),(100,1,9,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(101,10,8,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(102,1,30,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(103,2,24,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\"]'),(105,6,8,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(107,7,5,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(108,4,35,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(109,4,27,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-20.jpg\"]'),(110,1,27,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(111,3,18,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\"]'),(113,8,16,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(115,7,1,2.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(116,8,26,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(117,9,27,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(121,1,31,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\"]'),(123,6,2,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(124,3,1,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(125,4,22,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(126,7,16,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(127,9,2,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(128,5,16,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(129,6,40,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(130,9,41,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\"]'),(131,5,26,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(132,3,41,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(133,1,23,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(134,8,23,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]'),(135,2,26,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\"]'),(136,10,18,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(137,4,9,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(138,2,6,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(139,3,21,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(140,5,17,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(143,10,12,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(146,1,26,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(147,5,29,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\"]'),(148,2,20,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(149,7,3,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(150,10,21,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(151,7,43,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\"]'),(152,6,23,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(153,8,28,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(154,3,39,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(155,2,1,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(156,5,38,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(157,8,12,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(158,9,17,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(159,3,25,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(160,2,38,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(161,4,11,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\"]'),(162,8,17,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(163,9,10,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(165,4,37,1.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\"]'),(166,10,4,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(167,5,37,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-20.jpg\"]'),(168,1,40,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(169,10,33,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(170,4,8,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-15.jpg\"]'),(173,9,3,2.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(174,10,32,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(176,1,14,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(177,8,24,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(178,7,24,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(179,1,19,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\"]'),(181,4,24,3.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\"]'),(182,2,14,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\"]'),(184,10,17,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(185,3,35,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\"]'),(186,2,16,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\"]'),(189,8,1,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(190,1,39,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\"]'),(191,7,8,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(194,6,41,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(195,6,16,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(197,10,43,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(198,6,27,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\"]'),(200,7,30,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(201,9,40,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(204,1,32,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(205,7,13,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(209,10,14,5.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(210,10,35,5.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\"]'),(211,5,25,3.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(212,2,40,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(213,8,5,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\"]'),(216,7,6,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(217,2,7,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(222,7,23,1.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(224,9,21,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(225,5,2,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(227,2,23,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(230,3,3,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\"]'),(232,7,29,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\"]'),(233,7,2,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\"]'),(234,10,42,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(236,5,41,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(237,6,38,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(239,10,31,5.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(241,2,42,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(242,4,4,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(244,4,43,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(245,9,22,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(247,3,29,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(248,4,26,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(250,8,18,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(251,1,21,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(252,1,29,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\"]'),(255,10,25,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(256,2,22,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-20.jpg\"]'),(257,7,26,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(259,10,1,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-20.jpg\"]'),(260,5,9,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(262,4,33,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\"]'),(263,7,10,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(264,5,1,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(265,7,39,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(266,9,29,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\"]'),(267,6,13,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\"]'),(268,4,1,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-20.jpg\"]'),(271,5,31,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(275,5,6,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\"]'),(278,6,21,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\"]'),(279,3,19,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(285,8,36,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(287,3,37,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(288,7,27,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(289,1,41,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(291,2,33,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(292,4,31,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(295,9,37,3.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(296,6,10,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(299,8,35,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\"]'),(301,4,20,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(304,6,12,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(306,3,2,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\"]'),(312,1,6,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(316,5,13,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\"]'),(317,1,20,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(320,10,19,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(323,6,28,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(324,4,42,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(325,7,35,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(329,9,13,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(330,10,40,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(332,8,8,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(333,4,18,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\"]'),(335,8,30,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(337,4,6,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(343,9,31,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(344,7,14,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\"]'),(345,8,4,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\"]'),(346,5,14,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(347,5,5,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(348,3,20,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(349,10,9,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(350,4,34,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\"]'),(352,1,33,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(353,9,24,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(356,2,28,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\"]'),(358,7,40,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(360,5,36,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(363,5,20,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\"]'),(368,2,10,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-18.jpg\"]'),(369,3,33,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\"]'),(373,9,33,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(374,9,19,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(376,2,5,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\"]'),(381,4,21,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\"]'),(382,7,12,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(383,4,29,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(384,1,37,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(386,7,4,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(389,10,39,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(390,4,15,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(396,5,4,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\"]'),(402,9,39,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(407,6,22,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\"]'),(410,8,43,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(414,5,19,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(417,3,32,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-19.jpg\"]'),(418,5,24,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(419,10,22,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(420,6,15,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\"]'),(421,4,2,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(422,7,32,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(424,1,10,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\"]'),(427,9,7,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(430,9,38,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(431,3,15,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(433,10,30,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(434,10,6,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(441,3,16,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(442,6,20,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\"]'),(448,4,7,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\"]'),(449,6,14,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(454,9,43,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(456,1,12,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\"]'),(460,7,42,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(464,6,25,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(468,2,8,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(473,10,13,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(483,5,11,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\"]'),(485,9,1,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(486,2,13,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(488,7,38,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(490,5,23,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\"]'),(493,10,23,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(502,4,10,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\"]'),(503,3,27,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\"]'),(505,9,30,2.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\"]'),(507,2,19,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(510,4,14,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(511,5,21,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\"]'),(514,10,11,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(520,5,30,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\"]'),(522,7,17,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-20.jpg\"]'),(523,4,28,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(527,3,38,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(533,1,11,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(536,3,30,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(538,6,30,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(539,5,32,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(540,4,41,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\"]'),(547,3,31,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(551,9,5,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(552,9,23,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(560,10,24,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(561,4,19,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(564,6,31,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(566,6,35,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\"]'),(570,3,26,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(573,9,6,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-19.jpg\"]'),(574,2,39,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(579,6,19,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\"]'),(583,2,17,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(589,2,3,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(591,9,34,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(592,9,28,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\"]'),(603,3,9,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(606,8,29,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(611,1,8,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(612,7,18,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(616,10,28,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\"]'),(617,1,1,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(623,8,25,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-17.jpg\"]'),(624,10,41,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(627,8,39,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(631,7,36,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(637,1,28,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(641,5,27,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(642,5,33,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\"]'),(648,4,39,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\"]'),(652,3,24,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(654,8,6,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\"]'),(655,2,43,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\"]'),(661,2,41,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(669,3,11,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\"]'),(670,5,18,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\"]'),(678,8,13,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\"]'),(685,7,28,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-5.jpg\"]'),(687,8,22,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(690,10,29,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\"]'),(692,2,29,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\"]'),(705,3,28,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(711,8,33,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(724,6,7,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(733,8,27,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(734,5,40,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\"]'),(750,10,27,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(753,6,33,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(757,5,15,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-11.jpg\"]'),(763,3,5,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(764,3,14,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-19.jpg\"]'),(765,3,40,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(774,2,32,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\"]'),(783,7,33,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\"]'),(789,9,12,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(796,8,7,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-19.jpg\"]'),(799,7,31,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\"]'),(801,10,37,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(803,3,10,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(828,4,17,1.00,'Clean & perfect source code','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(840,8,38,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(843,4,3,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(844,7,41,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\"]'),(862,3,4,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(871,5,7,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(873,1,38,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(878,8,9,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(889,2,15,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(921,6,42,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(923,4,13,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(924,6,39,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-16.jpg\"]'),(925,8,40,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(941,8,14,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(959,10,26,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(965,10,10,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(966,9,25,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(972,6,29,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(976,8,34,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(983,8,32,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\"]'),(989,5,3,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(991,7,7,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:03:14','2024-03-15 03:03:14','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,1,'2024-03-01 19:02:44','2024-03-01 19:02:44','Botble\\ACL\\Models\\User'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,1,'2024-03-13 11:02:44','2024-03-15 03:02:44','Botble\\ACL\\Models\\User'),(3,'create_from_order','Shipping was created from order %order_id%',0,2,2,'2024-02-27 11:02:44','2024-02-27 11:02:44','Botble\\ACL\\Models\\User'),(4,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,2,'2024-03-13 11:02:44','2024-03-15 03:02:44','Botble\\ACL\\Models\\User'),(5,'create_from_order','Shipping was created from order %order_id%',0,3,4,'2024-02-27 11:02:45','2024-02-27 11:02:45','Botble\\ACL\\Models\\User'),(6,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,4,'2024-03-13 11:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(7,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,4,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(8,'create_from_order','Shipping was created from order %order_id%',0,4,5,'2024-03-11 23:02:45','2024-03-11 23:02:45','Botble\\ACL\\Models\\User'),(9,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,5,'2024-03-13 13:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(10,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,5,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(11,'create_from_order','Shipping was created from order %order_id%',0,5,6,'2024-03-13 13:02:45','2024-03-13 13:02:45','Botble\\ACL\\Models\\User'),(12,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,6,'2024-03-13 13:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(13,'create_from_order','Shipping was created from order %order_id%',0,6,8,'2024-03-12 03:02:45','2024-03-12 03:02:45','Botble\\ACL\\Models\\User'),(14,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,8,'2024-03-13 15:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(15,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,6,8,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(16,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,8,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\ACL\\Models\\User'),(17,'create_from_order','Shipping was created from order %order_id%',0,7,9,'2024-03-03 03:02:45','2024-03-03 03:02:45','Botble\\ACL\\Models\\User'),(18,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,9,'2024-03-13 15:02:46','2024-03-15 03:02:46','Botble\\ACL\\Models\\User'),(19,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,7,9,'2024-03-15 03:02:46','2024-03-15 03:02:46','Botble\\ACL\\Models\\User'),(20,'create_from_order','Shipping was created from order %order_id%',0,8,11,'2024-03-02 09:02:46','2024-03-02 09:02:46','Botble\\ACL\\Models\\User'),(21,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,11,'2024-03-13 17:02:46','2024-03-15 03:02:46','Botble\\ACL\\Models\\User'),(22,'create_from_order','Shipping was created from order %order_id%',0,9,12,'2024-03-13 17:02:46','2024-03-13 17:02:46','Botble\\ACL\\Models\\User'),(23,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,12,'2024-03-13 17:02:46','2024-03-15 03:02:46','Botble\\ACL\\Models\\User'),(24,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,12,'2024-03-15 03:02:46','2024-03-15 03:02:46','Botble\\ACL\\Models\\User'),(25,'create_from_order','Shipping was created from order %order_id%',0,10,13,'2024-03-11 03:02:46','2024-03-11 03:02:46','Botble\\ACL\\Models\\User'),(26,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,13,'2024-03-13 19:02:47','2024-03-15 03:02:47','Botble\\ACL\\Models\\User'),(27,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,10,13,'2024-03-15 03:02:47','2024-03-15 03:02:47','Botble\\ACL\\Models\\User'),(28,'create_from_order','Shipping was created from order %order_id%',0,11,14,'2024-03-03 03:02:47','2024-03-03 03:02:47','Botble\\ACL\\Models\\User'),(29,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,14,'2024-03-13 19:02:47','2024-03-15 03:02:47','Botble\\ACL\\Models\\User'),(30,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,14,'2024-03-15 03:02:47','2024-03-15 03:02:47','Botble\\ACL\\Models\\User'),(31,'create_from_order','Shipping was created from order %order_id%',0,12,16,'2024-03-11 09:02:47','2024-03-11 09:02:47','Botble\\ACL\\Models\\User'),(32,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,16,'2024-03-13 21:02:47','2024-03-15 03:02:47','Botble\\ACL\\Models\\User'),(33,'create_from_order','Shipping was created from order %order_id%',0,13,18,'2024-03-11 15:02:48','2024-03-11 15:02:48','Botble\\ACL\\Models\\User'),(34,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,18,'2024-03-13 23:02:48','2024-03-15 03:02:48','Botble\\ACL\\Models\\User'),(35,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,18,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\ACL\\Models\\User'),(36,'create_from_order','Shipping was created from order %order_id%',0,14,20,'2024-03-12 19:02:48','2024-03-12 19:02:48','Botble\\ACL\\Models\\User'),(37,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,20,'2024-03-13 23:02:48','2024-03-15 03:02:48','Botble\\ACL\\Models\\User'),(38,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,20,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\ACL\\Models\\User'),(39,'create_from_order','Shipping was created from order %order_id%',0,15,21,'2024-03-14 01:02:48','2024-03-14 01:02:48','Botble\\ACL\\Models\\User'),(40,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,21,'2024-03-14 01:02:48','2024-03-15 03:02:48','Botble\\ACL\\Models\\User'),(41,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,15,21,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\ACL\\Models\\User'),(42,'create_from_order','Shipping was created from order %order_id%',0,16,22,'2024-03-07 13:02:48','2024-03-07 13:02:48','Botble\\ACL\\Models\\User'),(43,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,22,'2024-03-14 01:02:49','2024-03-15 03:02:49','Botble\\ACL\\Models\\User'),(44,'create_from_order','Shipping was created from order %order_id%',0,17,23,'2024-03-08 03:02:49','2024-03-08 03:02:49','Botble\\ACL\\Models\\User'),(45,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,23,'2024-03-14 03:02:49','2024-03-15 03:02:49','Botble\\ACL\\Models\\User'),(46,'create_from_order','Shipping was created from order %order_id%',0,18,24,'2024-03-10 03:02:49','2024-03-10 03:02:49','Botble\\ACL\\Models\\User'),(47,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,24,'2024-03-14 03:02:49','2024-03-15 03:02:49','Botble\\ACL\\Models\\User'),(48,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,24,'2024-03-15 03:02:49','2024-03-15 03:02:49','Botble\\ACL\\Models\\User'),(49,'create_from_order','Shipping was created from order %order_id%',0,19,25,'2024-03-12 03:02:49','2024-03-12 03:02:49','Botble\\ACL\\Models\\User'),(50,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,25,'2024-03-14 03:02:49','2024-03-15 03:02:49','Botble\\ACL\\Models\\User'),(51,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,25,'2024-03-15 03:02:49','2024-03-15 03:02:49','Botble\\ACL\\Models\\User'),(52,'create_from_order','Shipping was created from order %order_id%',0,20,26,'2024-03-14 05:02:49','2024-03-14 05:02:49','Botble\\ACL\\Models\\User'),(53,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,26,'2024-03-14 05:02:49','2024-03-15 03:02:49','Botble\\ACL\\Models\\User'),(54,'create_from_order','Shipping was created from order %order_id%',0,21,27,'2024-03-07 19:02:49','2024-03-07 19:02:49','Botble\\ACL\\Models\\User'),(55,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,27,'2024-03-14 05:02:50','2024-03-15 03:02:50','Botble\\ACL\\Models\\User'),(56,'create_from_order','Shipping was created from order %order_id%',0,22,28,'2024-03-13 07:02:50','2024-03-13 07:02:50','Botble\\ACL\\Models\\User'),(57,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,28,'2024-03-14 05:02:50','2024-03-15 03:02:50','Botble\\ACL\\Models\\User'),(58,'create_from_order','Shipping was created from order %order_id%',0,23,29,'2024-03-08 11:02:50','2024-03-08 11:02:50','Botble\\ACL\\Models\\User'),(59,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,29,'2024-03-14 07:02:50','2024-03-15 03:02:50','Botble\\ACL\\Models\\User'),(60,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,23,29,'2024-03-15 03:02:50','2024-03-15 03:02:50','Botble\\ACL\\Models\\User'),(61,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,29,'2024-03-15 03:02:50','2024-03-15 03:02:50','Botble\\ACL\\Models\\User'),(62,'create_from_order','Shipping was created from order %order_id%',0,24,30,'2024-03-08 11:02:50','2024-03-08 11:02:50','Botble\\ACL\\Models\\User'),(63,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,30,'2024-03-14 07:02:50','2024-03-15 03:02:50','Botble\\ACL\\Models\\User'),(64,'create_from_order','Shipping was created from order %order_id%',0,25,31,'2024-03-08 11:02:50','2024-03-08 11:02:50','Botble\\ACL\\Models\\User'),(65,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,31,'2024-03-14 07:02:50','2024-03-15 03:02:50','Botble\\ACL\\Models\\User'),(66,'create_from_order','Shipping was created from order %order_id%',0,26,32,'2024-03-12 21:02:50','2024-03-12 21:02:50','Botble\\ACL\\Models\\User'),(67,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,32,'2024-03-14 09:02:51','2024-03-15 03:02:51','Botble\\ACL\\Models\\User'),(68,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,26,32,'2024-03-15 03:02:51','2024-03-15 03:02:51','Botble\\ACL\\Models\\User'),(69,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,26,32,'2024-03-15 03:02:51','2024-03-15 03:02:51','Botble\\ACL\\Models\\User'),(70,'create_from_order','Shipping was created from order %order_id%',0,27,33,'2024-03-13 15:02:51','2024-03-13 15:02:51','Botble\\ACL\\Models\\User'),(71,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,33,'2024-03-14 09:02:51','2024-03-15 03:02:51','Botble\\ACL\\Models\\User'),(72,'create_from_order','Shipping was created from order %order_id%',0,28,34,'2024-03-14 11:02:51','2024-03-14 11:02:51','Botble\\ACL\\Models\\User'),(73,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,34,'2024-03-14 11:02:51','2024-03-15 03:02:51','Botble\\ACL\\Models\\User'),(74,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,28,34,'2024-03-15 03:02:51','2024-03-15 03:02:51','Botble\\ACL\\Models\\User'),(75,'create_from_order','Shipping was created from order %order_id%',0,29,35,'2024-03-14 11:02:51','2024-03-14 11:02:51','Botble\\ACL\\Models\\User'),(76,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,35,'2024-03-14 11:02:51','2024-03-15 03:02:51','Botble\\ACL\\Models\\User'),(77,'create_from_order','Shipping was created from order %order_id%',0,30,36,'2024-03-12 05:02:51','2024-03-12 05:02:51','Botble\\ACL\\Models\\User'),(78,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,36,'2024-03-14 13:02:52','2024-03-15 03:02:52','Botble\\ACL\\Models\\User'),(79,'create_from_order','Shipping was created from order %order_id%',0,31,37,'2024-03-13 09:02:52','2024-03-13 09:02:52','Botble\\ACL\\Models\\User'),(80,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,37,'2024-03-14 13:02:52','2024-03-15 03:02:52','Botble\\ACL\\Models\\User'),(81,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,31,37,'2024-03-15 03:02:52','2024-03-15 03:02:52','Botble\\ACL\\Models\\User'),(82,'create_from_order','Shipping was created from order %order_id%',0,32,38,'2024-03-12 19:02:52','2024-03-12 19:02:52','Botble\\ACL\\Models\\User'),(83,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,38,'2024-03-14 13:02:52','2024-03-15 03:02:52','Botble\\ACL\\Models\\User'),(84,'create_from_order','Shipping was created from order %order_id%',0,33,39,'2024-03-13 09:02:52','2024-03-13 09:02:52','Botble\\ACL\\Models\\User'),(85,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,39,'2024-03-14 13:02:52','2024-03-15 03:02:52','Botble\\ACL\\Models\\User'),(86,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,33,39,'2024-03-15 03:02:52','2024-03-15 03:02:52','Botble\\ACL\\Models\\User'),(87,'create_from_order','Shipping was created from order %order_id%',0,34,40,'2024-03-11 15:02:52','2024-03-11 15:02:52','Botble\\ACL\\Models\\User'),(88,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,40,'2024-03-14 15:02:52','2024-03-15 03:02:52','Botble\\ACL\\Models\\User'),(89,'create_from_order','Shipping was created from order %order_id%',0,35,41,'2024-03-10 15:02:52','2024-03-10 15:02:52','Botble\\ACL\\Models\\User'),(90,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,41,'2024-03-14 15:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(91,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,41,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(92,'create_from_order','Shipping was created from order %order_id%',0,36,42,'2024-03-10 03:02:53','2024-03-10 03:02:53','Botble\\ACL\\Models\\User'),(93,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,42,'2024-03-14 15:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(94,'create_from_order','Shipping was created from order %order_id%',0,37,43,'2024-03-13 21:02:53','2024-03-13 21:02:53','Botble\\ACL\\Models\\User'),(95,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,43,'2024-03-14 17:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(96,'create_from_order','Shipping was created from order %order_id%',0,38,44,'2024-03-12 05:02:53','2024-03-12 05:02:53','Botble\\ACL\\Models\\User'),(97,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,38,44,'2024-03-14 17:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(98,'create_from_order','Shipping was created from order %order_id%',0,39,45,'2024-03-10 23:02:53','2024-03-10 23:02:53','Botble\\ACL\\Models\\User'),(99,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,39,45,'2024-03-14 17:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(100,'create_from_order','Shipping was created from order %order_id%',0,40,46,'2024-03-13 11:02:53','2024-03-13 11:02:53','Botble\\ACL\\Models\\User'),(101,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,40,46,'2024-03-14 17:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(102,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,46,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\ACL\\Models\\User'),(103,'create_from_order','Shipping was created from order %order_id%',0,41,47,'2024-03-14 03:02:53','2024-03-14 03:02:53','Botble\\ACL\\Models\\User'),(104,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,41,47,'2024-03-14 19:02:54','2024-03-15 03:02:54','Botble\\ACL\\Models\\User'),(105,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,41,47,'2024-03-15 03:02:54','2024-03-15 03:02:54','Botble\\ACL\\Models\\User'),(106,'create_from_order','Shipping was created from order %order_id%',0,42,48,'2024-03-12 03:02:54','2024-03-12 03:02:54','Botble\\ACL\\Models\\User'),(107,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,42,48,'2024-03-14 19:02:55','2024-03-15 03:02:55','Botble\\ACL\\Models\\User'),(108,'create_from_order','Shipping was created from order %order_id%',0,43,49,'2024-03-14 19:02:55','2024-03-14 19:02:55','Botble\\ACL\\Models\\User'),(109,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,43,49,'2024-03-14 19:02:55','2024-03-15 03:02:55','Botble\\ACL\\Models\\User'),(110,'create_from_order','Shipping was created from order %order_id%',0,44,51,'2024-03-14 15:02:56','2024-03-14 15:02:56','Botble\\ACL\\Models\\User'),(111,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,44,51,'2024-03-14 21:02:56','2024-03-15 03:02:56','Botble\\ACL\\Models\\User'),(112,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,44,51,'2024-03-15 03:02:56','2024-03-15 03:02:56','Botble\\ACL\\Models\\User'),(113,'create_from_order','Shipping was created from order %order_id%',0,45,52,'2024-03-13 11:02:56','2024-03-13 11:02:56','Botble\\ACL\\Models\\User'),(114,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,45,52,'2024-03-14 23:02:56','2024-03-15 03:02:56','Botble\\ACL\\Models\\User'),(115,'create_from_order','Shipping was created from order %order_id%',0,46,53,'2024-03-13 15:02:56','2024-03-13 15:02:56','Botble\\ACL\\Models\\User'),(116,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,46,53,'2024-03-14 23:02:56','2024-03-15 03:02:56','Botble\\ACL\\Models\\User'),(117,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,46,53,'2024-03-15 03:02:56','2024-03-15 03:02:56','Botble\\ACL\\Models\\User'),(118,'create_from_order','Shipping was created from order %order_id%',0,47,54,'2024-03-13 11:02:56','2024-03-13 11:02:56','Botble\\ACL\\Models\\User'),(119,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,47,54,'2024-03-14 23:02:57','2024-03-15 03:02:57','Botble\\ACL\\Models\\User'),(120,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,47,54,'2024-03-15 03:02:57','2024-03-15 03:02:57','Botble\\ACL\\Models\\User'),(121,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,47,54,'2024-03-15 03:02:57','2024-03-15 03:02:57','Botble\\ACL\\Models\\User'),(122,'create_from_order','Shipping was created from order %order_id%',0,48,57,'2024-03-14 17:02:57','2024-03-14 17:02:57','Botble\\ACL\\Models\\User'),(123,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,48,57,'2024-03-15 01:02:57','2024-03-15 03:02:57','Botble\\ACL\\Models\\User');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,1,NULL,799.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:44','2024-03-15 03:02:44','JJD0047714084','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:02:44',NULL,NULL,NULL),(2,2,NULL,1480.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:44','2024-03-15 03:02:44','JJD0010553962','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:02:44',NULL,NULL,NULL),(3,4,NULL,2271.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','JJD0049436931','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:02:45','2024-03-15 10:02:45',NULL,NULL),(4,5,NULL,1234.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','JJD0020315741','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:02:45','2024-03-15 10:02:45',NULL,NULL),(5,6,NULL,2205.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','JJD005437875','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:02:45',NULL,NULL,NULL),(6,8,NULL,691.00,NULL,NULL,'','delivered',478.00,'completed','pending',0.00,0,'2024-03-15 03:02:45','2024-03-15 03:02:45','JJD0043715007','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:02:45','2024-03-15 10:02:45',NULL,NULL),(7,9,NULL,7236.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','JJD0032162999','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:02:46','2024-03-15 10:02:46',NULL,NULL),(8,11,NULL,1824.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','JJD0099099006','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:02:46',NULL,NULL,NULL),(9,12,NULL,826.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:46','2024-03-15 03:02:46','JJD0046492340','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:02:46','2024-03-15 10:02:46',NULL,NULL),(10,13,NULL,804.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','JJD0061102629','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:47','2024-03-15 10:02:47',NULL,NULL),(11,14,NULL,1586.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','JJD0069576924','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:02:47','2024-03-15 10:02:47',NULL,NULL),(12,16,NULL,1414.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:47','2024-03-15 03:02:47','JJD0060774724','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:47',NULL,NULL,NULL),(13,18,NULL,2028.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','JJD0064815933','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:02:48','2024-03-15 10:02:48',NULL,NULL),(14,20,NULL,1608.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','JJD0031796351','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:02:48','2024-03-15 10:02:48',NULL,NULL),(15,21,NULL,2097.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:48','2024-03-15 03:02:48','JJD006709073','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:02:48','2024-03-15 10:02:48',NULL,NULL),(16,22,NULL,2256.00,NULL,NULL,'','approved',3186.00,'pending','pending',0.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','JJD0021028017','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:02:49',NULL,NULL,NULL),(17,23,NULL,1308.00,NULL,NULL,'','approved',2290.00,'pending','pending',0.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','JJD0084159900','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:02:49',NULL,NULL,NULL),(18,24,NULL,1768.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','JJD0073475349','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:49','2024-03-15 10:02:49',NULL,NULL),(19,25,NULL,1586.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','JJD0051979667','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:02:49','2024-03-15 10:02:49',NULL,NULL),(20,26,NULL,2073.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:49','2024-03-15 03:02:49','JJD0037675032','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:02:49',NULL,NULL,NULL),(21,27,NULL,740.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','JJD0050708369','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:50',NULL,NULL,NULL),(22,28,NULL,779.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','JJD0036396261','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:02:50',NULL,NULL,NULL),(23,29,NULL,2097.00,NULL,NULL,'','delivered',2757.00,'completed','pending',0.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','JJD0074393265','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:02:50','2024-03-15 10:02:50',NULL,NULL),(24,30,NULL,1476.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','JJD0080136064','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:50',NULL,NULL,NULL),(25,31,NULL,1608.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:50','2024-03-15 03:02:50','JJD0033299644','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:02:50',NULL,NULL,NULL),(26,32,NULL,552.00,NULL,NULL,'','delivered',1865.00,'completed','pending',0.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','JJD003775959','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:02:51','2024-03-15 10:02:51',NULL,NULL),(27,33,NULL,3260.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','JJD0051333759','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:02:51',NULL,NULL,NULL),(28,34,NULL,2205.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','JJD0091737746','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:02:51','2024-03-15 10:02:51',NULL,NULL),(29,35,NULL,1598.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:51','2024-03-15 03:02:51','JJD0024994751','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:02:51',NULL,NULL,NULL),(30,36,NULL,691.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','JJD0040620074','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:52',NULL,NULL,NULL),(31,37,NULL,1104.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','JJD0089453115','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:02:52','2024-03-15 10:02:52',NULL,NULL),(32,38,NULL,1216.00,NULL,NULL,'','approved',4640.00,'pending','pending',0.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','JJD0021609361','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:02:52',NULL,NULL,NULL),(33,39,NULL,780.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','JJD0028693344','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:02:52','2024-03-15 10:02:52',NULL,NULL),(34,40,NULL,1962.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:52','2024-03-15 03:02:52','JJD0050975181','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:02:52',NULL,NULL,NULL),(35,41,NULL,1480.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','JJD0039753535','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:02:53','2024-03-15 10:02:53',NULL,NULL),(36,42,NULL,757.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','JJD0092890636','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:02:53',NULL,NULL,NULL),(37,43,NULL,1851.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','JJD0013147836','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:53',NULL,NULL,NULL),(38,44,NULL,685.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','JJD0078006892','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:02:53',NULL,NULL,NULL),(39,45,NULL,1611.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','JJD0032015905','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:02:53',NULL,NULL,NULL),(40,46,NULL,884.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:53','2024-03-15 03:02:53','JJD009159452','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:02:53','2024-03-15 10:02:53',NULL,NULL),(41,47,NULL,506.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:54','2024-03-15 03:02:54','JJD0094093218','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:02:54','2024-03-15 10:02:54',NULL,NULL),(42,48,NULL,753.00,NULL,NULL,'','approved',1233.00,'pending','pending',0.00,0,'2024-03-15 03:02:55','2024-03-15 03:02:55','JJD0087949393','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:02:55',NULL,NULL,NULL),(43,49,NULL,752.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:55','2024-03-15 03:02:55','JJD0069982639','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:02:55',NULL,NULL,NULL),(44,51,NULL,2220.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','JJD0015974482','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:56','2024-03-15 10:02:56',NULL,NULL),(45,52,NULL,552.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','JJD0026521614','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:02:56',NULL,NULL,NULL),(46,53,NULL,2250.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:56','2024-03-15 03:02:56','JJD0023670846','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:56','2024-03-15 10:02:56',NULL,NULL),(47,54,NULL,1514.00,NULL,NULL,'','delivered',2702.00,'completed','pending',0.00,0,'2024-03-15 03:02:57','2024-03-15 03:02:57','JJD0020026628','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:02:57','2024-03-15 10:02:57',NULL,NULL),(48,57,NULL,804.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:57','2024-03-15 03:02:57','JJD0090876571','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:57',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2024-03-15 03:02:32','2024-03-15 03:02:32');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',0.00,NULL,0.00,'2024-03-15 03:02:32','2024-03-15 03:02:32');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Shofy','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2024-03-15 03:02:34','2024-03-15 03:02:34');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,4),(1,5),(1,9),(1,10),(1,13),(1,14),(1,16),(1,27),(1,30),(1,37),(1,39),(1,42),(2,1),(2,2),(2,7),(2,11),(2,17),(2,23),(2,24),(2,25),(2,31),(2,34),(2,35),(2,43),(3,3),(3,6),(3,8),(3,12),(3,15),(3,18),(3,19),(3,20),(3,21),(3,22),(3,26),(3,28),(3,29),(3,32),(3,33),(3,36),(3,38),(3,40),(3,41);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2024-03-15 03:02:32','2024-03-15 03:02:32'),(2,'None',0.000000,2,'published','2024-03-15 03:02:32','2024-03-15 03:02:32'),(3,'Import Tax',15.000000,3,'published','2024-03-15 03:02:32','2024-03-15 03:02:32');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(2,'PAYMENT',1,'published','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(3,'ORDER &amp; RETURNS',2,'published','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2024-03-15 03:02:29','2024-03-15 03:02:29'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2024-03-15 03:02:29','2024-03-15 03:02:29');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Radiant Reflections','I don\'t understand. Where did they live on?\' said the Knave, \'I didn\'t know it was too much frightened to say it out into the air off all its feet at once, with a sigh: \'it\'s always tea-time, and.',1,0,'beauty/galleries/1.jpg',1,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(2,'Glamour Grove','Mouse had changed his mind, and was suppressed. \'Come, that finished the first really clever thing the King triumphantly, pointing to the jury. \'Not yet, not yet!\' the Rabbit hastily interrupted.',1,0,'beauty/galleries/2.jpg',1,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(3,'Serene Styles Showcase','Ann! Mary Ann!\' said the Hatter: \'let\'s all move one place on.\' He moved on as he fumbled over the list, feeling very glad she had not gone much farther before she gave one sharp kick, and waited.',1,0,'beauty/galleries/3.jpg',1,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(4,'Allure Alcove','Alice began telling them her adventures from the sky! Ugh, Serpent!\' \'But I\'m not the smallest idea how confusing it is all the same, shedding gallons of tears, but said nothing. \'When we were.',1,0,'beauty/galleries/4.jpg',1,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(5,'Glamour Galleria','Duchess; \'I never went to school every day--\' \'I\'VE been to a mouse: she had never seen such a subject! Our family always HATED cats: nasty, low, vulgar things! Don\'t let me hear the Rabbit say, \'A.',1,0,'beauty/galleries/5.jpg',1,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(6,'Beauty Boulevard','I!\' said the Caterpillar. Here was another puzzling question; and as he fumbled over the list, feeling very curious thing, and she went to him,\' said Alice sadly. \'Hand it over afterwards, it.',1,0,'beauty/galleries/6.jpg',1,'published','2024-03-15 03:02:43','2024-03-15 03:02:43');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Alice; not that she let the jury--\' \'If any one left alive!\' She was moving them about as much use in the middle of the table. \'Have some wine,\' the March Hare and his friends shared their.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"Queen. \'I haven\'t the least idea what a Mock Turtle went on, \'and most things twinkled after that--only the March Hare. Alice was soon submitted to by the fire, stirring a large cauldron which.\"},{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then came a little way off, and found in it about four inches deep and reaching half down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go with Edgar Atheling to meet.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"Hatter. \'I deny it!\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you like to see the Mock Turtle, suddenly dropping his voice; and the turtles all advance! They are waiting on.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess: you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen was in managing her flamingo: she succeeded in bringing herself down to them, and all that,\' said the Gryphon. \'Turn a.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:02:43','2024-03-15 03:02:43'),(2,'[{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Alice; not that she let the jury--\' \'If any one left alive!\' She was moving them about as much use in the middle of the table. \'Have some wine,\' the March Hare and his friends shared their.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"Queen. \'I haven\'t the least idea what a Mock Turtle went on, \'and most things twinkled after that--only the March Hare. Alice was soon submitted to by the fire, stirring a large cauldron which.\"},{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then came a little way off, and found in it about four inches deep and reaching half down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go with Edgar Atheling to meet.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"Hatter. \'I deny it!\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you like to see the Mock Turtle, suddenly dropping his voice; and the turtles all advance! They are waiting on.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess: you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen was in managing her flamingo: she succeeded in bringing herself down to them, and all that,\' said the Gryphon. \'Turn a.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:02:43','2024-03-15 03:02:43'),(3,'[{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Alice; not that she let the jury--\' \'If any one left alive!\' She was moving them about as much use in the middle of the table. \'Have some wine,\' the March Hare and his friends shared their.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"Queen. \'I haven\'t the least idea what a Mock Turtle went on, \'and most things twinkled after that--only the March Hare. Alice was soon submitted to by the fire, stirring a large cauldron which.\"},{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then came a little way off, and found in it about four inches deep and reaching half down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go with Edgar Atheling to meet.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"Hatter. \'I deny it!\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you like to see the Mock Turtle, suddenly dropping his voice; and the turtles all advance! They are waiting on.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess: you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen was in managing her flamingo: she succeeded in bringing herself down to them, and all that,\' said the Gryphon. \'Turn a.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:02:43','2024-03-15 03:02:43'),(4,'[{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Alice; not that she let the jury--\' \'If any one left alive!\' She was moving them about as much use in the middle of the table. \'Have some wine,\' the March Hare and his friends shared their.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"Queen. \'I haven\'t the least idea what a Mock Turtle went on, \'and most things twinkled after that--only the March Hare. Alice was soon submitted to by the fire, stirring a large cauldron which.\"},{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then came a little way off, and found in it about four inches deep and reaching half down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go with Edgar Atheling to meet.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"Hatter. \'I deny it!\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you like to see the Mock Turtle, suddenly dropping his voice; and the turtles all advance! They are waiting on.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess: you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen was in managing her flamingo: she succeeded in bringing herself down to them, and all that,\' said the Gryphon. \'Turn a.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:02:43','2024-03-15 03:02:43'),(5,'[{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Alice; not that she let the jury--\' \'If any one left alive!\' She was moving them about as much use in the middle of the table. \'Have some wine,\' the March Hare and his friends shared their.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"Queen. \'I haven\'t the least idea what a Mock Turtle went on, \'and most things twinkled after that--only the March Hare. Alice was soon submitted to by the fire, stirring a large cauldron which.\"},{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then came a little way off, and found in it about four inches deep and reaching half down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go with Edgar Atheling to meet.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"Hatter. \'I deny it!\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you like to see the Mock Turtle, suddenly dropping his voice; and the turtles all advance! They are waiting on.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess: you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen was in managing her flamingo: she succeeded in bringing herself down to them, and all that,\' said the Gryphon. \'Turn a.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:02:43','2024-03-15 03:02:43'),(6,'[{\"img\":\"beauty\\/galleries\\/3.jpg\",\"description\":\"Alice; not that she let the jury--\' \'If any one left alive!\' She was moving them about as much use in the middle of the table. \'Have some wine,\' the March Hare and his friends shared their.\"},{\"img\":\"beauty\\/galleries\\/2.jpg\",\"description\":\"Queen. \'I haven\'t the least idea what a Mock Turtle went on, \'and most things twinkled after that--only the March Hare. Alice was soon submitted to by the fire, stirring a large cauldron which.\"},{\"img\":\"beauty\\/galleries\\/1.jpg\",\"description\":\"Then came a little way off, and found in it about four inches deep and reaching half down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go with Edgar Atheling to meet.\"},{\"img\":\"beauty\\/galleries\\/4.jpg\",\"description\":\"Hatter. \'I deny it!\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you like to see the Mock Turtle, suddenly dropping his voice; and the turtles all advance! They are waiting on.\"},{\"img\":\"beauty\\/galleries\\/5.jpg\",\"description\":\"Duchess: you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen was in managing her flamingo: she succeeded in bringing herself down to them, and all that,\' said the Gryphon. \'Turn a.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:02:43','2024-03-15 03:02:43');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','bf34e823e6e1588c363caac5e252a1a7',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','53fcd09cbcced94c70f379a7359e9362',1,'Botble\\Menu\\Models\\MenuLocation'),(3,'en_US','4971df244f1b7fa7520fa6f1a25ccd40',1,'Botble\\Menu\\Models\\Menu'),(4,'en_US','263e1800041b3d30c9593f71a462e106',2,'Botble\\Menu\\Models\\Menu'),(5,'en_US','e18f4ee3456be8af03b78a33d7717460',3,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'404','404',2,'image/png',15820,'main/general/404.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(2,0,'about-1','about-1',2,'image/jpeg',9222,'main/general/about-1.jpg','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(3,0,'about-2','about-2',2,'image/jpeg',5105,'main/general/about-2.jpg','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(4,0,'breadcrumb','breadcrumb',2,'image/jpeg',5276,'main/general/breadcrumb.jpg','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(5,0,'cta-shape-1','cta-shape-1',2,'image/png',22860,'main/general/cta-shape-1.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(6,0,'cta-shape-2','cta-shape-2',2,'image/png',16796,'main/general/cta-shape-2.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(7,0,'cta-thumb-1','cta-thumb-1',2,'image/jpeg',6053,'main/general/cta-thumb-1.jpg','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(8,0,'favicon','favicon',2,'image/png',1831,'main/general/favicon.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(9,0,'footer-pay','footer-pay',2,'image/png',490,'main/general/footer-pay.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(10,0,'logo-white','logo-white',2,'image/png',22020,'main/general/logo-white.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(11,0,'logo','logo',2,'image/png',22398,'main/general/logo.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(12,0,'newsletter-popup','newsletter-popup',2,'image/png',17253,'main/general/newsletter-popup.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(13,0,'placeholder','placeholder',2,'image/png',2100,'main/general/placeholder.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(14,0,'preloader-icon','preloader-icon',2,'image/png',4182,'main/general/preloader-icon.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(15,0,'signature','signature',2,'image/png',2117,'main/general/signature.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(16,0,'slider-offer','slider-offer',2,'image/png',970,'main/general/slider-offer.png','[]','2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(27,0,'1','1',4,'image/jpeg',4294,'main/customers/1.jpg','[]','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(28,0,'10','10',4,'image/jpeg',4294,'main/customers/10.jpg','[]','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(29,0,'2','2',4,'image/jpeg',4294,'main/customers/2.jpg','[]','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(30,0,'3','3',4,'image/jpeg',4294,'main/customers/3.jpg','[]','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(31,0,'4','4',4,'image/jpeg',4294,'main/customers/4.jpg','[]','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(32,0,'5','5',4,'image/jpeg',4294,'main/customers/5.jpg','[]','2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(33,0,'6','6',4,'image/jpeg',4294,'main/customers/6.jpg','[]','2024-03-15 03:02:30','2024-03-15 03:02:30',NULL),(34,0,'7','7',4,'image/jpeg',4294,'main/customers/7.jpg','[]','2024-03-15 03:02:30','2024-03-15 03:02:30',NULL),(35,0,'8','8',4,'image/jpeg',4294,'main/customers/8.jpg','[]','2024-03-15 03:02:30','2024-03-15 03:02:30',NULL),(36,0,'9','9',4,'image/jpeg',4294,'main/customers/9.jpg','[]','2024-03-15 03:02:30','2024-03-15 03:02:30',NULL),(37,0,'blog-big-1','blog-big-1',5,'image/jpeg',13885,'main/blog/blog-big-1.jpg','[]','2024-03-15 03:02:32','2024-03-15 03:02:32',NULL),(38,0,'blog-details-sm-1','blog-details-sm-1',5,'image/jpeg',8166,'main/blog/blog-details-sm-1.jpg','[]','2024-03-15 03:02:32','2024-03-15 03:02:32',NULL),(39,0,'post-1','post-1',5,'image/jpeg',6189,'main/blog/post-1.jpg','[]','2024-03-15 03:02:32','2024-03-15 03:02:32',NULL),(40,0,'post-10','post-10',5,'image/jpeg',5907,'main/blog/post-10.jpg','[]','2024-03-15 03:02:32','2024-03-15 03:02:32',NULL),(41,0,'post-11','post-11',5,'image/jpeg',5907,'main/blog/post-11.jpg','[]','2024-03-15 03:02:32','2024-03-15 03:02:32',NULL),(42,0,'post-12','post-12',5,'image/jpeg',5907,'main/blog/post-12.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(43,0,'post-2','post-2',5,'image/jpeg',6189,'main/blog/post-2.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(44,0,'post-3','post-3',5,'image/jpeg',6189,'main/blog/post-3.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(45,0,'post-4','post-4',5,'image/jpeg',6045,'main/blog/post-4.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(46,0,'post-5','post-5',5,'image/jpeg',6045,'main/blog/post-5.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(47,0,'post-6','post-6',5,'image/jpeg',6045,'main/blog/post-6.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(48,0,'post-7','post-7',5,'image/jpeg',5907,'main/blog/post-7.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(49,0,'post-8','post-8',5,'image/jpeg',5907,'main/blog/post-8.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(50,0,'post-9','post-9',5,'image/jpeg',5907,'main/blog/post-9.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(51,0,'1','1',3,'image/jpeg',4068,'main/users/1.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(52,0,'10','10',3,'image/jpeg',7599,'main/users/10.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(53,0,'2','2',3,'image/jpeg',7599,'main/users/2.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(54,0,'3','3',3,'image/jpeg',6387,'main/users/3.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(55,0,'4','4',3,'image/jpeg',7599,'main/users/4.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(56,0,'5','5',3,'image/jpeg',6387,'main/users/5.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(57,0,'6','6',3,'image/jpeg',7599,'main/users/6.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(58,0,'7','7',3,'image/jpeg',6387,'main/users/7.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(59,0,'8','8',3,'image/jpeg',7599,'main/users/8.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(60,0,'9','9',3,'image/jpeg',6387,'main/users/9.jpg','[]','2024-03-15 03:02:33','2024-03-15 03:02:33',NULL),(61,0,'1','1',6,'image/png',9133,'main/stores/1.png','[]','2024-03-15 03:02:34','2024-03-15 03:02:34',NULL),(62,0,'10','10',6,'image/png',4263,'main/stores/10.png','[]','2024-03-15 03:02:34','2024-03-15 03:02:34',NULL),(63,0,'11','11',6,'image/png',4420,'main/stores/11.png','[]','2024-03-15 03:02:34','2024-03-15 03:02:34',NULL),(64,0,'12','12',6,'image/png',4908,'main/stores/12.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(65,0,'13','13',6,'image/png',3441,'main/stores/13.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(66,0,'14','14',6,'image/png',4209,'main/stores/14.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(67,0,'15','15',6,'image/png',5113,'main/stores/15.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(68,0,'16','16',6,'image/png',4563,'main/stores/16.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(69,0,'17','17',6,'image/png',4896,'main/stores/17.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(70,0,'2','2',6,'image/png',9008,'main/stores/2.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(71,0,'3','3',6,'image/png',8006,'main/stores/3.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(72,0,'4','4',6,'image/png',8728,'main/stores/4.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(73,0,'5','5',6,'image/png',10689,'main/stores/5.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(74,0,'6','6',6,'image/png',10989,'main/stores/6.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(75,0,'7','7',6,'image/png',3730,'main/stores/7.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(76,0,'8','8',6,'image/png',4030,'main/stores/8.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(77,0,'9','9',6,'image/png',3810,'main/stores/9.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(78,0,'cover-1','cover-1',6,'image/png',4208,'main/stores/cover-1.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(79,0,'cover-2','cover-2',6,'image/png',8798,'main/stores/cover-2.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(80,0,'cover-3','cover-3',6,'image/png',3888,'main/stores/cover-3.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(81,0,'cover-4','cover-4',6,'image/png',11893,'main/stores/cover-4.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(82,0,'cover-5','cover-5',6,'image/png',8798,'main/stores/cover-5.png','[]','2024-03-15 03:02:35','2024-03-15 03:02:35',NULL),(83,0,'slider-1','slider-1',8,'image/jpeg',27493,'beauty/sliders/slider-1.jpg','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(84,0,'slider-2','slider-2',8,'image/jpeg',27493,'beauty/sliders/slider-2.jpg','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(85,0,'slider-3','slider-3',8,'image/jpeg',27493,'beauty/sliders/slider-3.jpg','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(86,0,'1','1',9,'image/jpeg',4294,'beauty/product-categories/1.jpg','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(87,0,'2','2',9,'image/jpeg',4294,'beauty/product-categories/2.jpg','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(88,0,'3','3',9,'image/jpeg',4294,'beauty/product-categories/3.jpg','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(89,0,'4','4',9,'image/jpeg',4294,'beauty/product-categories/4.jpg','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(90,0,'product-1','product-1',10,'image/png',9803,'beauty/products/product-1.png','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(91,0,'product-2','product-2',10,'image/png',9803,'beauty/products/product-2.png','[]','2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(92,0,'product-3','product-3',10,'image/png',9803,'beauty/products/product-3.png','[]','2024-03-15 03:02:39','2024-03-15 03:02:39',NULL),(93,0,'product-4','product-4',10,'image/png',9803,'beauty/products/product-4.png','[]','2024-03-15 03:02:39','2024-03-15 03:02:39',NULL),(94,0,'product-5','product-5',10,'image/png',9803,'beauty/products/product-5.png','[]','2024-03-15 03:02:39','2024-03-15 03:02:39',NULL),(95,0,'product-6','product-6',10,'image/png',9803,'beauty/products/product-6.png','[]','2024-03-15 03:02:39','2024-03-15 03:02:39',NULL),(96,0,'product-7','product-7',10,'image/png',9803,'beauty/products/product-7.png','[]','2024-03-15 03:02:39','2024-03-15 03:02:39',NULL),(97,0,'product-8','product-8',10,'image/png',9803,'beauty/products/product-8.png','[]','2024-03-15 03:02:39','2024-03-15 03:02:39',NULL),(98,0,'1','1',11,'image/jpeg',4294,'beauty/galleries/1.jpg','[]','2024-03-15 03:02:42','2024-03-15 03:02:42',NULL),(99,0,'2','2',11,'image/jpeg',4294,'beauty/galleries/2.jpg','[]','2024-03-15 03:02:42','2024-03-15 03:02:42',NULL),(100,0,'3','3',11,'image/jpeg',4294,'beauty/galleries/3.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(101,0,'4','4',11,'image/jpeg',4294,'beauty/galleries/4.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(102,0,'5','5',11,'image/jpeg',4294,'beauty/galleries/5.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(103,0,'6','6',11,'image/jpeg',4294,'beauty/galleries/6.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(104,0,'instagram-1','instagram-1',11,'image/jpeg',4294,'beauty/galleries/instagram-1.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(105,0,'instagram-2','instagram-2',11,'image/jpeg',4294,'beauty/galleries/instagram-2.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(106,0,'instagram-3','instagram-3',11,'image/jpeg',4294,'beauty/galleries/instagram-3.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(107,0,'instagram-4','instagram-4',11,'image/jpeg',4294,'beauty/galleries/instagram-4.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(108,0,'instagram-5','instagram-5',11,'image/jpeg',4294,'beauty/galleries/instagram-5.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(109,0,'instagram-6','instagram-6',11,'image/jpeg',4294,'beauty/galleries/instagram-6.jpg','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(110,0,'icon-1','icon-1',12,'image/png',4469,'main/contact/icon-1.png','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(111,0,'icon-2','icon-2',12,'image/png',5977,'main/contact/icon-2.png','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(112,0,'icon-3','icon-3',12,'image/png',6082,'main/contact/icon-3.png','[]','2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(113,0,'line','line',13,'image/png',6152,'main/shapes/line.png','[]','2024-03-15 03:02:44','2024-03-15 03:02:44',NULL),(114,0,'quote','quote',13,'image/png',595,'main/shapes/quote.png','[]','2024-03-15 03:02:44','2024-03-15 03:02:44',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(2,0,'general',NULL,'general',1,'2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(3,0,'users',NULL,'users',1,'2024-03-15 03:02:28','2024-03-15 03:02:28',NULL),(4,0,'customers',NULL,'customers',1,'2024-03-15 03:02:29','2024-03-15 03:02:29',NULL),(5,0,'blog',NULL,'blog',1,'2024-03-15 03:02:32','2024-03-15 03:02:32',NULL),(6,0,'stores',NULL,'stores',1,'2024-03-15 03:02:34','2024-03-15 03:02:34',NULL),(7,0,'beauty',NULL,'beauty',0,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(8,0,'sliders',NULL,'sliders',7,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(9,0,'product-categories',NULL,'product-categories',7,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(10,0,'products',NULL,'products',7,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL),(11,0,'galleries',NULL,'galleries',7,'2024-03-15 03:02:42','2024-03-15 03:02:42',NULL),(12,0,'contact',NULL,'contact',1,'2024-03-15 03:02:43','2024-03-15 03:02:43',NULL),(13,0,'shapes',NULL,'shapes',1,'2024-03-15 03:02:44','2024-03-15 03:02:44',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2024-03-15 03:02:43','2024-03-15 03:02:43');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,1,'Botble\\Page\\Models\\Page','/home',NULL,0,'Home',NULL,'_self',1,'2024-03-15 03:02:43','2024-03-15 03:02:44'),(2,1,1,NULL,NULL,'https://shofy.botble.com',NULL,0,'Electronics',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(3,1,1,NULL,NULL,'https://shofy-fashion.botble.com',NULL,0,'Fashion',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(4,1,1,NULL,NULL,'https://shofy-beauty.botble.com',NULL,0,'Beauty',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(5,1,1,NULL,NULL,'https://shofy-jewelry.botble.com',NULL,0,'Jewelry',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(6,1,1,NULL,NULL,'https://shofy-grocery.botble.com',NULL,0,'Grocery',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(7,1,0,NULL,NULL,NULL,NULL,0,'Shop',NULL,'_self',1,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(8,1,7,2,'Botble\\Page\\Models\\Page','/product-categories',NULL,0,'Shop Categories',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:44'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,0,'Shop List',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(10,1,7,NULL,NULL,'/products?layout=grid',NULL,0,'Shop Grid',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(11,1,7,NULL,NULL,'/products/floral-maxi-dress',NULL,0,'Product Detail',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(12,1,7,3,'Botble\\Page\\Models\\Page','/coupons',NULL,0,'Grab Coupons',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:44'),(13,1,7,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(14,1,7,NULL,NULL,'/compare',NULL,0,'Compare',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(15,1,7,NULL,NULL,'/wishlist',NULL,0,'Wishlist',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(16,1,7,NULL,NULL,'/orders/tracking',NULL,0,'Track Your Order',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(17,1,0,NULL,NULL,'/stores',NULL,0,'Vendors',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(18,1,0,NULL,NULL,NULL,NULL,0,'Pages',NULL,'_self',1,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(19,1,18,NULL,NULL,'/login',NULL,0,'Login',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(20,1,18,NULL,NULL,'/register',NULL,0,'Register',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(21,1,18,NULL,NULL,'/password/reset',NULL,0,'Forgot Password',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(22,1,18,NULL,NULL,'/404',NULL,0,'404 Error',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(23,1,0,5,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',1,'2024-03-15 03:02:43','2024-03-15 03:02:44'),(24,1,23,NULL,NULL,'/blog?layout=grid',NULL,0,'Blog Grid',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(25,1,23,NULL,NULL,'/blog?layout=list',NULL,0,'Blog List',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(26,1,23,NULL,NULL,'/blog/essential-qualities-of-highly-successful-music',NULL,0,'Blog Detail',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(27,1,0,6,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:44'),(28,2,0,NULL,NULL,'/orders/tracking',NULL,1,'Track Orders',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(29,2,0,10,'Botble\\Page\\Models\\Page','/shipping',NULL,1,'Shipping',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:44'),(30,2,0,NULL,NULL,'/wishlist',NULL,1,'Wishlist',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(31,2,0,NULL,NULL,'/customer/overview',NULL,1,'My Account',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(32,2,0,NULL,NULL,'/customer/orders',NULL,1,'Order History',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(33,2,0,NULL,NULL,'/customer/order-returns',NULL,1,'Returns',NULL,'_self',0,'2024-03-15 03:02:43','2024-03-15 03:02:43'),(34,3,0,8,'Botble\\Page\\Models\\Page','/our-story',NULL,2,'Our Story',NULL,'_self',0,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(35,3,0,9,'Botble\\Page\\Models\\Page','/careers',NULL,2,'Careers',NULL,'_self',0,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(36,3,0,7,'Botble\\Page\\Models\\Page','/cookie-policy',NULL,2,'Privacy Policy',NULL,'_self',0,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(37,3,0,NULL,NULL,'/blog',NULL,2,'Latest News',NULL,'_self',0,'2024-03-15 03:02:44','2024-03-15 03:02:44'),(38,3,0,6,'Botble\\Page\\Models\\Page','/contact',NULL,2,'Contact Us',NULL,'_self',0,'2024-03-15 03:02:44','2024-03-15 03:02:44');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(2,'My Account','my-account','published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(3,'Information','information','published','2024-03-15 03:02:44','2024-03-15 03:02:44');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'background','[\"main\\/stores\\/cover-2.png\"]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(2,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(3,'background','[\"main\\/stores\\/cover-3.png\"]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(4,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(5,'background','[\"main\\/stores\\/cover-2.png\"]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(6,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(7,'background','[\"main\\/stores\\/cover-5.png\"]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(8,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(9,'background','[\"main\\/stores\\/cover-5.png\"]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(10,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(11,'background','[\"main\\/stores\\/cover-5.png\"]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:37','2024-03-15 03:02:37'),(12,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:38','2024-03-15 03:02:38'),(13,'background','[\"main\\/stores\\/cover-3.png\"]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:38','2024-03-15 03:02:38'),(14,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:38','2024-03-15 03:02:38'),(15,'background','[\"main\\/stores\\/cover-4.png\"]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:38','2024-03-15 03:02:38'),(16,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:02:38','2024-03-15 03:02:38'),(17,'button_label','[\"Shop Collection\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:02:38','2024-03-15 03:02:38'),(18,'button_label','[\"Shop Collection\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:02:38','2024-03-15 03:02:38'),(19,'button_label','[\"Shop Collection\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:02:38','2024-03-15 03:02:38'),(20,'faq_ids','[[2,4,5,6,9]]',1,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(21,'faq_ids','[[2,3,4,5,8]]',2,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(22,'faq_ids','[[3,4,6,8,9]]',3,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(23,'faq_ids','[[2,7,8,9,10]]',4,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(24,'faq_ids','[[4,5,6,8,10]]',5,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(25,'faq_ids','[[3,4,5,8,9]]',6,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(26,'faq_ids','[[1,4,7,9,10]]',7,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(27,'faq_ids','[[1,3,4,8,9]]',8,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(28,'faq_ids','[[3,4,5,6,7]]',9,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(29,'faq_ids','[[2,4,5,8,9]]',10,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(30,'faq_ids','[[2,3,5,7,8]]',11,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(31,'faq_ids','[[1,3,4,5,9]]',12,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(32,'faq_ids','[[4,5,7,8,10]]',13,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(33,'faq_ids','[[2,3,6,8,9]]',14,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(34,'faq_ids','[[1,2,6,7,10]]',15,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(35,'faq_ids','[[1,2,4,7,8]]',16,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(36,'faq_ids','[[1,3,7,8,9]]',17,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(37,'faq_ids','[[1,4,6,8,9]]',18,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(38,'faq_ids','[[3,4,7,8,10]]',19,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:39','2024-03-15 03:02:39'),(39,'faq_ids','[[1,2,3,4,7]]',20,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(40,'faq_ids','[[1,3,7,8,10]]',21,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(41,'faq_ids','[[1,3,4,6,10]]',22,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(42,'faq_ids','[[1,2,3,7,9]]',23,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(43,'faq_ids','[[1,3,4,6,10]]',24,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(44,'faq_ids','[[1,3,7,8,9]]',25,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(45,'faq_ids','[[2,3,4,5,7]]',26,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(46,'faq_ids','[[1,3,5,6,9]]',27,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(47,'faq_ids','[[2,4,5,6,9]]',28,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(48,'faq_ids','[[3,5,6,7,8]]',29,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(49,'faq_ids','[[1,6,8,9,10]]',30,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(50,'faq_ids','[[1,3,4,5,6]]',31,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(51,'faq_ids','[[1,3,6,7,8]]',32,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(52,'faq_ids','[[3,5,6,7,8]]',33,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(53,'faq_ids','[[1,3,7,8,10]]',34,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(54,'faq_ids','[[2,3,6,9,10]]',35,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(55,'faq_ids','[[1,2,8,9,10]]',36,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(56,'faq_ids','[[1,3,7,8,10]]',37,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(57,'faq_ids','[[1,4,7,9,10]]',38,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(58,'faq_ids','[[1,2,3,4,7]]',39,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(59,'faq_ids','[[2,4,5,8,10]]',40,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(60,'faq_ids','[[1,4,5,7,8]]',41,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(61,'faq_ids','[[1,2,5,6,7]]',42,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(62,'faq_ids','[[2,3,5,8,9]]',43,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:02:40','2024-03-15 03:02:40'),(63,'breadcrumb_style','[\"none\"]',1,'Botble\\Page\\Models\\Page','2024-03-15 03:02:43','2024-03-15 03:02:43'),(64,'breadcrumb_style','[\"align-start\"]',2,'Botble\\Page\\Models\\Page','2024-03-15 03:02:43','2024-03-15 03:02:43');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_reset_tokens_table',1),(5,'2015_06_18_033822_create_blog_table',1),(6,'2015_06_29_025744_create_audit_history',1),(7,'2016_05_28_112028_create_system_request_logs_table',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2020_03_05_041139_create_ecommerce_tables',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',1),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',1),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',1),(34,'2021_02_16_092633_remove_default_value_for_author_type',1),(35,'2021_02_18_073505_update_table_ec_reviews',1),(36,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',1),(37,'2021_03_10_025153_change_column_tax_amount',1),(38,'2021_03_20_033103_add_column_availability_to_table_ec_products',1),(39,'2021_03_27_144913_add_customer_type_into_table_payments',1),(40,'2021_04_28_074008_ecommerce_create_product_label_table',1),(41,'2021_05_24_034720_make_column_currency_nullable',1),(42,'2021_05_31_173037_ecommerce_create_ec_products_translations',1),(43,'2021_07_06_030002_create_marketplace_table',1),(44,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(45,'2021_08_17_105016_remove_column_currency_id_in_some_tables',1),(46,'2021_08_30_142128_add_images_column_to_ec_reviews_table',1),(47,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',1),(48,'2021_10_04_030050_add_column_created_by_to_table_ec_products',1),(49,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',1),(50,'2021_10_05_122616_add_status_column_to_ec_customers_table',1),(51,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',1),(52,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',1),(53,'2021_10_19_020859_update_metadata_field',1),(54,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(55,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',1),(56,'2021_11_23_071403_correct_languages_for_product_variations',1),(57,'2021_11_28_031808_add_product_tags_translations',1),(58,'2021_12_01_031123_add_featured_image_to_ec_products',1),(59,'2021_12_02_035301_add_ads_translations_table',1),(60,'2021_12_03_030600_create_blog_translations',1),(61,'2021_12_03_075608_create_page_translations',1),(62,'2021_12_03_082134_create_faq_translations',1),(63,'2021_12_03_082953_create_gallery_translations',1),(64,'2021_12_03_083642_create_testimonials_translations',1),(65,'2021_12_03_084118_create_location_translations',1),(66,'2021_12_03_094518_migrate_old_location_data',1),(67,'2021_12_06_031304_update_table_mp_customer_revenues',1),(68,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(69,'2022_01_01_033107_update_table_ec_shipments',1),(70,'2022_01_16_085908_improve_plugin_location',1),(71,'2022_02_16_042457_improve_product_attribute_sets',1),(72,'2022_03_22_075758_correct_product_name',1),(73,'2022_04_19_113334_add_index_to_ec_products',1),(74,'2022_04_19_113923_add_index_to_table_posts',1),(75,'2022_04_20_100851_add_index_to_media_table',1),(76,'2022_04_20_101046_add_index_to_menu_table',1),(77,'2022_04_28_144405_remove_unused_table',1),(78,'2022_04_30_034048_create_gallery_meta_translations_table',1),(79,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',1),(80,'2022_05_18_143720_add_index_to_table_ec_product_categories',1),(81,'2022_06_16_095633_add_index_to_some_tables',1),(82,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(83,'2022_06_30_035148_create_order_referrals_table',1),(84,'2022_07_07_153354_update_charge_id_in_table_payments',1),(85,'2022_07_10_034813_move_lang_folder_to_root',1),(86,'2022_07_24_153815_add_completed_at_to_ec_orders_table',1),(87,'2022_08_04_051940_add_missing_column_expires_at',1),(88,'2022_08_04_052122_delete_location_backup_tables',1),(89,'2022_08_14_032836_create_ec_order_returns_table',1),(90,'2022_08_14_033554_create_ec_order_return_items_table',1),(91,'2022_08_15_040324_add_billing_address',1),(92,'2022_08_30_091114_support_digital_products_table',1),(93,'2022_09_01_000001_create_admin_notifications_tables',1),(94,'2022_09_13_095744_create_options_table',1),(95,'2022_09_13_104347_create_option_value_table',1),(96,'2022_10_05_163518_alter_table_ec_order_product',1),(97,'2022_10_12_041517_create_invoices_table',1),(98,'2022_10_12_142226_update_orders_table',1),(99,'2022_10_13_024916_update_table_order_returns',1),(100,'2022_10_14_024629_drop_column_is_featured',1),(101,'2022_10_19_152916_add_columns_to_mp_stores_table',1),(102,'2022_10_20_062849_create_mp_category_sale_commissions_table',1),(103,'2022_10_21_030830_update_columns_in_ec_shipments_table',1),(104,'2022_10_28_021046_update_columns_in_ec_shipments_table',1),(105,'2022_11_02_071413_add_more_info_for_store',1),(106,'2022_11_02_080444_add_tax_info',1),(107,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',1),(108,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(109,'2022_11_19_041643_add_ec_tax_product_table',1),(110,'2022_12_02_093615_update_slug_index_columns',1),(111,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',1),(112,'2022_12_17_041532_fix_address_in_order_invoice',1),(113,'2022_12_26_070329_create_ec_product_views_table',1),(114,'2023_01_04_033051_fix_product_categories',1),(115,'2023_01_09_050400_add_ec_global_options_translations_table',1),(116,'2023_01_10_093754_add_missing_option_value_id',1),(117,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',1),(118,'2023_01_26_021854_add_ec_customer_used_coupons_table',1),(119,'2023_01_30_024431_add_alt_to_media_table',1),(120,'2023_02_01_062030_add_store_translations',1),(121,'2023_02_08_015900_update_options_column_in_ec_order_product_table',1),(122,'2023_02_13_032133_update_fee_column_mp_customer_revenues_table',1),(123,'2023_02_16_042611_drop_table_password_resets',1),(124,'2023_02_17_023648_fix_store_prefix',1),(125,'2023_02_27_095752_remove_duplicate_reviews',1),(126,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',1),(127,'2023_04_17_062645_add_open_in_new_tab',1),(128,'2023_04_21_082427_create_ec_product_categorizables_table',1),(129,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(130,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(131,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',1),(132,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(133,'2023_05_17_025812_fix_invoice_issue',1),(134,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',1),(135,'2023_05_27_144611_fix_exchange_rate_setting',1),(136,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',1),(137,'2023_06_30_042512_create_ec_order_tax_information_table',1),(138,'2023_07_06_011444_create_slug_translations_table',1),(139,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',1),(140,'2023_07_26_041451_add_more_columns_to_location_table',1),(141,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(142,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',1),(143,'2023_08_11_060908_create_announcements_table',1),(144,'2023_08_15_064505_create_ec_tax_rules_table',1),(145,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(146,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',1),(147,'2023_08_21_090810_make_page_content_nullable',1),(148,'2023_08_22_094114_drop_unique_for_barcode',1),(149,'2023_08_29_074620_make_column_author_id_nullable',1),(150,'2023_08_29_075308_make_column_user_id_nullable',1),(151,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',1),(152,'2023_09_07_094312_add_index_to_product_sku_and_translations',1),(153,'2023_09_14_021936_update_index_for_slugs_table',1),(154,'2023_09_14_022423_add_index_for_language_table',1),(155,'2023_09_19_024955_create_discount_product_categories_table',1),(156,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',1),(157,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(158,'2023_11_07_023805_add_tablet_mobile_image',1),(159,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(160,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(161,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(162,'2023_11_22_154643_add_unique_in_table_ec_products_variations',1),(163,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',1),(164,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',1),(165,'2023_12_06_100448_change_random_hash_for_media',1),(166,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(167,'2023_12_12_105220_drop_translations_table',1),(168,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(169,'2023_12_25_040604_ec_create_review_replies_table',1),(170,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',1),(171,'2024_01_16_070706_fix_translation_tables',1),(172,'2024_01_23_075227_add_proof_file_to_ec_orders_table',1),(173,'2024_03_14_041050_migrate_lazy_load_theme_options',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,7,5,2430.00,0.00,2430.00,0.00,'USD',NULL,'2024-03-11 15:02:57','2024-03-11 15:02:57',0,'add-amount'),(2,3,12,707.00,0.00,707.00,0.00,'USD',NULL,'2024-03-08 15:02:58','2024-03-08 15:02:58',0,'add-amount'),(3,5,13,319.00,0.00,319.00,0.00,'USD',NULL,'2024-03-06 23:02:58','2024-03-06 23:02:58',0,'add-amount'),(4,2,14,1972.00,0.00,1972.00,0.00,'USD',NULL,'2024-03-06 09:02:59','2024-03-06 09:02:59',0,'add-amount'),(5,7,18,6951.00,0.00,6951.00,2430.00,'USD',NULL,'2024-02-28 07:03:00','2024-02-28 07:03:00',0,'add-amount'),(6,6,21,2757.00,0.00,2757.00,0.00,'USD',NULL,'2024-03-02 07:03:00','2024-03-02 07:03:00',0,'add-amount'),(7,2,25,1972.00,0.00,1972.00,1972.00,'USD',NULL,'2024-02-22 11:03:01','2024-02-22 11:03:01',0,'add-amount'),(8,5,39,1452.00,0.00,1452.00,319.00,'USD',NULL,'2024-03-11 19:03:01','2024-03-11 19:03:01',0,'add-amount'),(9,3,41,3766.00,0.00,3766.00,707.00,'USD',NULL,'2024-03-11 15:03:02','2024-03-11 15:03:02',0,'add-amount'),(10,5,46,1862.00,0.00,1862.00,1771.00,'USD',NULL,'2024-03-03 09:03:02','2024-03-03 09:03:02',0,'add-amount'),(11,1,47,458.00,0.00,458.00,0.00,'USD',NULL,'2024-03-11 03:03:03','2024-03-11 03:03:03',0,'add-amount'),(12,3,51,5649.00,0.00,5649.00,4473.00,'USD',NULL,'2024-02-18 03:03:03','2024-02-18 03:03:03',0,'add-amount'),(13,6,53,2470.00,0.00,2470.00,2757.00,'USD',NULL,'2024-02-26 03:03:04','2024-02-26 03:03:04',0,'add-amount');
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,1,0.00,14.00,458.00,'USD','','{\"name\":\"Keith Steuber\",\"number\":\"+12816684450\",\"full_name\":\"Cassandre Auer\",\"description\":\"Jodie Ritchie\"}',NULL,0,'completed',NULL,'2024-03-15 03:03:04','2024-03-15 03:03:04',NULL),(2,1,0.00,123.00,444.00,'USD','','{\"name\":\"Keith Steuber\",\"number\":\"+12816684450\",\"full_name\":\"Cassandre Auer\",\"description\":\"Jodie Ritchie\"}',NULL,0,'pending',NULL,'2024-03-15 03:03:05','2024-03-15 03:03:05',NULL),(3,2,0.00,1230.00,3944.00,'USD','','{\"name\":\"Suzanne Moore\",\"number\":\"+16814805679\",\"full_name\":\"Dortha Parisian\",\"description\":\"Mr. Grant Kihn\"}',NULL,0,'processing',NULL,'2024-03-15 03:03:05','2024-03-15 03:03:05',NULL),(4,2,0.00,471.00,2714.00,'USD','','{\"name\":\"Suzanne Moore\",\"number\":\"+16814805679\",\"full_name\":\"Dortha Parisian\",\"description\":\"Mr. Grant Kihn\"}',NULL,0,'completed',NULL,'2024-03-15 03:03:06','2024-03-15 03:03:06',NULL),(5,3,0.00,2300.00,10122.00,'USD','','{\"name\":\"Emil Kreiger\",\"number\":\"+14803415908\",\"full_name\":\"Kaci Gleichner\",\"description\":\"Irving Gutkowski\"}',NULL,0,'completed',NULL,'2024-03-15 03:03:07','2024-03-15 03:03:07',NULL),(6,3,0.00,875.00,7822.00,'USD','','{\"name\":\"Emil Kreiger\",\"number\":\"+14803415908\",\"full_name\":\"Kaci Gleichner\",\"description\":\"Irving Gutkowski\"}',NULL,0,'pending',NULL,'2024-03-15 03:03:07','2024-03-15 03:03:07',NULL),(7,3,0.00,1411.00,6947.00,'USD','','{\"name\":\"Emil Kreiger\",\"number\":\"+14803415908\",\"full_name\":\"Kaci Gleichner\",\"description\":\"Irving Gutkowski\"}',NULL,0,'processing',NULL,'2024-03-15 03:03:08','2024-03-15 03:03:08',NULL),(8,3,0.00,543.00,5536.00,'USD','','{\"name\":\"Emil Kreiger\",\"number\":\"+14803415908\",\"full_name\":\"Kaci Gleichner\",\"description\":\"Irving Gutkowski\"}',NULL,0,'completed',NULL,'2024-03-15 03:03:08','2024-03-15 03:03:08',NULL),(9,5,0.00,679.00,3633.00,'USD','','{\"name\":\"Neil Leannon\",\"number\":\"+13517951008\",\"full_name\":\"Tracy Wilderman\",\"description\":\"Melyssa Hagenes\"}',NULL,0,'processing',NULL,'2024-03-15 03:03:09','2024-03-15 03:03:09',NULL),(10,5,0.00,646.00,2954.00,'USD','','{\"name\":\"Neil Leannon\",\"number\":\"+13517951008\",\"full_name\":\"Tracy Wilderman\",\"description\":\"Melyssa Hagenes\"}',NULL,0,'completed',NULL,'2024-03-15 03:03:09','2024-03-15 03:03:09',NULL),(11,5,0.00,491.00,2308.00,'USD','','{\"name\":\"Neil Leannon\",\"number\":\"+13517951008\",\"full_name\":\"Tracy Wilderman\",\"description\":\"Melyssa Hagenes\"}',NULL,0,'pending',NULL,'2024-03-15 03:03:10','2024-03-15 03:03:10',NULL),(12,6,0.00,307.00,5227.00,'USD','','{\"name\":\"Haskell Boyle\",\"number\":\"+16693171997\",\"full_name\":\"Blanche Hackett I\",\"description\":\"Royal Hackett IV\"}',NULL,0,'completed',NULL,'2024-03-15 03:03:10','2024-03-15 03:03:10',NULL),(13,6,0.00,1545.00,4920.00,'USD','','{\"name\":\"Haskell Boyle\",\"number\":\"+16693171997\",\"full_name\":\"Blanche Hackett I\",\"description\":\"Royal Hackett IV\"}',NULL,0,'pending',NULL,'2024-03-15 03:03:11','2024-03-15 03:03:11',NULL),(14,7,0.00,329.00,9381.00,'USD','','{\"name\":\"Katelyn Brakus\",\"number\":\"+12407974951\",\"full_name\":\"Lester Kutch\",\"description\":\"Mr. Kade Hirthe Sr.\"}',NULL,0,'processing',NULL,'2024-03-15 03:03:11','2024-03-15 03:03:11',NULL),(15,7,0.00,168.00,9052.00,'USD','','{\"name\":\"Katelyn Brakus\",\"number\":\"+12407974951\",\"full_name\":\"Lester Kutch\",\"description\":\"Mr. Kade Hirthe Sr.\"}',NULL,0,'processing',NULL,'2024-03-15 03:03:12','2024-03-15 03:03:12',NULL),(16,7,0.00,888.00,8884.00,'USD','','{\"name\":\"Katelyn Brakus\",\"number\":\"+12407974951\",\"full_name\":\"Lester Kutch\",\"description\":\"Mr. Kade Hirthe Sr.\"}',NULL,0,'processing',NULL,'2024-03-15 03:03:12','2024-03-15 03:03:12',NULL),(17,7,0.00,269.00,7996.00,'USD','','{\"name\":\"Katelyn Brakus\",\"number\":\"+12407974951\",\"full_name\":\"Lester Kutch\",\"description\":\"Mr. Kade Hirthe Sr.\"}',NULL,0,'processing',NULL,'2024-03-15 03:03:13','2024-03-15 03:03:13',NULL),(18,8,0.00,1.00,0.00,'USD','','{\"name\":\"Suzanne Gottlieb\",\"number\":\"+12096985984\",\"full_name\":\"Joel Stracke I\",\"description\":\"Adriel Lind\"}',NULL,0,'completed',NULL,'2024-03-15 03:03:13','2024-03-15 03:03:13',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','dcrist@example.org','+15804120677','62581 Grimes Mills','LA','Nebraska','Lake Emanuelburgh',1,'main/stores/1.png','Consequatur vel doloribus eveniet aut. Et laborum saepe minima quos. Autem ea ex dolorem sint consequatur. Sit cumque debitis velit in est ea ea. A culpa quos exercitationem porro sed beatae quidem voluptate. Non corrupti aperiam repellendus possimus qui quod. Totam dolores voluptatem pariatur cumque corrupti quas eaque. Omnis similique eveniet ad nemo atque voluptas.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:37','2024-03-15 03:02:37',NULL,NULL),(2,'Global Office','bogisich.aaliyah@example.org','+13077162191','4991 O\'Hara Garden','JP','Minnesota','Lake Uriahfort',2,'main/stores/2.png','Accusantium expedita fugit eveniet et nihil consequuntur voluptas. Maiores recusandae perspiciatis autem optio provident qui quaerat cumque. Architecto explicabo laborum quia ex qui harum. Pariatur animi minus adipisci facilis tempora dolor accusamus. Consequatur et culpa dicta. Consequatur qui ipsa sit nisi maxime sequi. Nobis non eum atque incidunt totam labore.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:37','2024-03-15 03:02:37',NULL,NULL),(3,'Young Shop','verner.feeney@example.org','+19784887936','428 Mathilde Meadows','NF','Washington','Kubport',3,'main/stores/3.png','Ut minima aut sed est. Deserunt non aut nobis itaque voluptas perspiciatis quo voluptatem. Corporis aut et enim fugit. Ut facere nostrum autem debitis corrupti nesciunt voluptas. Provident nihil vero eum doloribus dolor aut. Et nulla quod unde est dolores. Qui illo rerum voluptatum veniam. Dolorem occaecati aut velit ex ratione magni.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:37','2024-03-15 03:02:37',NULL,NULL),(4,'Global Store','jpollich@example.org','+13158334280','1301 Amelie Hill','JO','Alabama','New Mae',4,'main/stores/4.png','Accusantium dolorem dolor sunt minus. Eos non aspernatur occaecati accusamus. Officiis sint in non dolores et delectus. Placeat blanditiis dignissimos consequatur facere tempore dolores consectetur. Saepe facere quia qui quo eius dignissimos eaque qui.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:37','2024-03-15 03:02:37',NULL,NULL),(5,'Robert’s Store','muller.eve@example.org','+19064929418','23123 Moore Via Suite 173','KR','New Hampshire','Lake Clydestad',5,'main/stores/5.png','Pariatur corporis eligendi maiores dolor. Id fugiat molestias ab quaerat similique ut eveniet sint. Mollitia quia facilis dolorem perferendis. Sed soluta ut vero quia et dolore. Aliquam nesciunt et quis fugit et qui. Aut qui dolorem reprehenderit odio cum consequatur. Fugit deserunt soluta vero. Sequi architecto cumque illo corrupti. Quis distinctio facere cupiditate quod.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:37','2024-03-15 03:02:37',NULL,NULL),(6,'Stouffer','harrison.stoltenberg@example.com','+15857102382','604 Boehm Drive Suite 561','JM','Iowa','South Perryport',6,'main/stores/6.png','Aspernatur officia aut error quia architecto aut commodi non. Accusamus tempore aliquid ipsa. Voluptatem quas quos rerum quaerat. Aut voluptatem distinctio voluptatum necessitatibus. Est praesentium veniam autem inventore. Nostrum voluptates possimus qui sint natus beatae. Sed eum veritatis sit est dolorem sed est.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:37','2024-03-15 03:02:37',NULL,NULL),(7,'StarKist','dare.marcel@example.com','+15319704809','318 Melvin Ridges','BF','New York','Thurmanville',7,'main/stores/7.png','Quam repudiandae perferendis officia esse iusto. Laboriosam pariatur quis dolor enim error voluptate. Facere libero aut similique quod aut pariatur voluptas. Adipisci dolore voluptas quo. Fuga omnis unde non itaque ipsum delectus sunt. Ipsa accusantium sequi omnis eligendi. Vel earum omnis qui amet.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL),(8,'Old El Paso','qlittle@example.com','+13218472131','651 Hayes Valley','EH','Arizona','Turnerbury',8,'main/stores/8.png','Rerum voluptas totam cupiditate hic ut quidem accusamus magni. Maxime maiores eum nihil earum. At quae magnam consequatur repellat libero fugit dignissimos. Qui aut sequi molestias molestiae animi qui. Et nihil est libero eligendi. Pariatur et impedit doloremque eligendi suscipit et quia. Expedita accusamus in consequatur voluptates consectetur. Mollitia sed aut enim.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:02:38','2024-03-15 03:02:38',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores_translations`
--

DROP TABLE IF EXISTS `mp_stores_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mp_stores_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`mp_stores_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores_translations`
--

LOCK TABLES `mp_stores_translations` WRITE;
/*!40000 ALTER TABLE `mp_stores_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_stores_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,1,321.00,0.00,458.00,'$2y$12$2JQc/QmO4gegtUwGECR80.mhttoZRhOsqEOfnlAtBsE8ygnLbXBHC','{\"name\":\"Keith Steuber\",\"number\":\"+12816684450\",\"full_name\":\"Cassandre Auer\",\"description\":\"Jodie Ritchie\"}','2024-03-15 03:02:36','2024-03-15 03:03:05','bank_transfer',NULL),(2,2,2243.00,0.00,3944.00,'$2y$12$94OFDG5wQ4h.bn1vs95ib.uP86Hotq7/3pytcFOycR3QTrX6PnT5K','{\"name\":\"Suzanne Moore\",\"number\":\"+16814805679\",\"full_name\":\"Dortha Parisian\",\"description\":\"Mr. Grant Kihn\"}','2024-03-15 03:02:36','2024-03-15 03:03:07','bank_transfer',NULL),(3,3,4993.00,0.00,10122.00,'$2y$12$P6XrRvZwhGEgtlDujT1fUut0HTDmKSkoW3G7RsamH7H3pmlda9fre','{\"name\":\"Emil Kreiger\",\"number\":\"+14803415908\",\"full_name\":\"Kaci Gleichner\",\"description\":\"Irving Gutkowski\"}','2024-03-15 03:02:36','2024-03-15 03:03:09','bank_transfer',NULL),(4,4,0.00,0.00,0.00,'$2y$12$jG4qtn2OyfHllz5.Ds1Cjeaw9Zw8wTIR7yZeHl5Jbr906efmZHCNC','{\"name\":\"Donnell Wintheiser\",\"number\":\"+17127501887\",\"full_name\":\"Rowan McLaughlin\",\"description\":\"Maryse Watsica DDS\"}','2024-03-15 03:02:36','2024-03-15 03:02:36','bank_transfer',NULL),(5,5,1817.00,0.00,3633.00,'$2y$12$Y3J/0SL50On78LBf/3WsjO8s0VtyP4WssryydV0m/XgI98J1vY4Ua','{\"name\":\"Neil Leannon\",\"number\":\"+13517951008\",\"full_name\":\"Tracy Wilderman\",\"description\":\"Melyssa Hagenes\"}','2024-03-15 03:02:37','2024-03-15 03:03:10','bank_transfer',NULL),(6,6,3375.00,0.00,5227.00,'$2y$12$HJAbmrw1Ojd1RRJpUNI4O.yvzDL1TLVBB95UbX2dlbzzjeK8WF13e','{\"name\":\"Haskell Boyle\",\"number\":\"+16693171997\",\"full_name\":\"Blanche Hackett I\",\"description\":\"Royal Hackett IV\"}','2024-03-15 03:02:37','2024-03-15 03:03:11','bank_transfer',NULL),(7,7,7727.00,0.00,9381.00,'$2y$12$vWSeL9wPZwPLhaaQ5G2clO2EpgKutFHJDEqi6cHfRXNLMae.2w8gq','{\"name\":\"Katelyn Brakus\",\"number\":\"+12407974951\",\"full_name\":\"Lester Kutch\",\"description\":\"Mr. Kade Hirthe Sr.\"}','2024-03-15 03:02:37','2024-03-15 03:03:13','bank_transfer',NULL),(8,8,-1.00,0.00,0.00,'$2y$12$Z1PgmYD1hVVR6YmpvC5PfOJBCGhC9wJ7pHZ2/S.TuiJj.MEOkXvyq','{\"name\":\"Suzanne Gottlieb\",\"number\":\"+12096985984\",\"full_name\":\"Joel Stracke I\",\"description\":\"Adriel Lind\"}','2024-03-15 03:02:37','2024-03-15 03:03:14','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','[simple-slider style=\"3\" key=\"home-slider\"][/simple-slider][ecommerce-categories style=\"slider\" category_ids=\"1,2,7,17\" background_color=\"#F3F5F7\" title=\"Discover our products\" subtitle=\"Product Collection\" button_label=\"Shop All Products\" button_url=\"/products\"][/ecommerce-categories][ecommerce-products style=\"simple\" by=\"specify\" product_ids=\"2,39,41\"][/ecommerce-products][ecommerce-products style=\"grid\" title=\"Best sellers in beauty\" subtitle=\"Shop by Category\" by=\"category\" category_ids=\"2,3,4\" limit=\"8\" background_color=\"rgb(234, 228, 222)\" button_label=\"Shop All Products\" button_url=\"/products\"][/ecommerce-products][ecommerce-product-groups title=\"Enjoy the best quality\" subtitle=\"Best Seller This Week’s\" limit=\"8\" tabs=\"all,featured,on-sale,trending,top-rated\"][/ecommerce-product-groups][testimonials style=\"2\" title=\"What our Clients say\" subtitle=\"Customers Review\" testimonial_ids=\"1,2,3,4\"][/testimonials][site-features style=\"2\" quantity=\"4\" title_1=\"Free Delivery\" description_1=\"Orders from all item\" icon_1=\"ti ti-truck-delivery\" title_2=\"Return & Refund\" description_2=\"Money back guarantee\" icon_2=\"ti ti-currency-dollar\" title_3=\"Member Discount\" description_3=\"Every order over $140.00\" icon_3=\"ti ti-discount-2\" title_4=\"Support 24/7\" description_4=\"Contact us 24 hours a day\" icon_4=\"ti ti-headset\"][/site-features][gallery style=\"2\" limit=\"6\"][/gallery]',1,NULL,'full-width',NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(2,'Product Categories','[ads style=\"2\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads]<p>&nbsp;</p>[ecommerce-categories category_ids=\"11,14,17,18,21,22,23,25,38\" style=\"grid\"][/ecommerce-categories]<p>&nbsp;</p><p>&nbsp;</p>',1,NULL,'full-width',NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(3,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(4,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(5,'Blog',NULL,1,NULL,'full-width',NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(6,'Contact','[contact-form show_contact_form=&quot;1&quot; title=&quot;Sent A Message&quot; quantity=&quot;2&quot; icon_1=&quot;main/contact/icon-1.png&quot; content_1=&quot;contact@shofy.com &lt;br&gt; &lt;strong&gt;+670 413 90 762&lt;/strong&gt;&quot; icon_2=&quot;main/contact/icon-2.png&quot; content_2=&quot;502 New St, Brighton VIC 3186, Australia&quot; show_social_info=&quot;1&quot; social_info_label=&quot;Find on social media&quot; social_info_icon=&quot;main/contact/icon-3.png&quot;][/contact-form][google-map]502 New Street, Brighton VIC, Australia[/google-map]',1,NULL,'full-width',NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(7,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(8,'Our Story','<h4>A passion for handcrafted coffee, brewed with love and community.</h4>\n\n<p>\n    We are a small, family-owned coffee roaster dedicated to bringing the finest, ethically sourced beans to your cup. Our story began in a cozy kitchen, fueled by a shared passion for the rich aroma and invigorating taste of freshly brewed coffee. We dreamt of creating a space where people could connect over a warm cup, share stories, and experience the joy of handcrafted coffee.\n</p>\n\n<h4>From Humble Beginnings to Roasting Success:</h4>\n\n<p>\n    Our journey started with a small coffee roaster nestled in our garage. We spent countless hours experimenting with different roasting profiles, meticulously cupping each batch to achieve the perfect balance of flavor and aroma. Driven by a desire to make a difference, we built relationships with sustainable coffee farms around the world, ensuring fair trade practices and the highest quality beans.\n</p>\n\n<h4>Milestones and More to Come:</h4>\n\n<p>\n    Our dedication to quality and community resonated with coffee lovers, and our small business quickly grew. We opened our first cafe, a warm and inviting space where people could gather, savor our freshly roasted coffee, and connect with friends and neighbors. We\'ve continued to expand, now offering a variety of handcrafted coffee beverages, alongside delicious pastries and light bites.\n</p>\n\n<h4>Values at Our Core:</h4>\n\n<p>\n    At the heart of everything we do lies our commitment to ethical sourcing, sustainable practices, and building meaningful connections. We believe in supporting the communities that cultivate our coffee beans, ensuring fair wages and responsible farming methods. Every cup you enjoy contributes to a positive impact, one sip at a time.\n</p>\n\n<h4>Join us on our journey!</h4>\n\n<p>\n    We invite you to explore our world of coffee, from the rich diversity of our bean origins to the unique flavors crafted through meticulous roasting. Visit our cafe, discover your perfect cup, and become part of our ever-growing coffee community. Let\'s connect over a cup, share stories, and celebrate the simple joy of a well-brewed coffee.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(9,'Careers','<h3>Careers: Be Part of Our Brewing Legacy</h3>\n\n<p>\n    At Shofy, we\'re not just brewing coffee, we\'re brewing a legacy. Since our humble beginnings in 2024, we\'ve grown from a small, family-owned roaster to a thriving coffee haven. But our passion for quality, community, and sustainability remains at the core of everything we do.\n</p>\n\n<h4>Why Join Our Team?</h4>\n\n<ul>\n    <li>\n        <p><strong>Become a Coffee Connoisseur</strong>: Immerse yourself in the world of coffee, learning from experienced roasters and baristas about bean origins, roasting techniques, and crafting the perfect cup.</p>\n    </li>\n    <li>\n        <p><strong>Fuel Your Passion</strong>: Contribute to our mission by sourcing ethically, promoting sustainable practices, and fostering positive relationships with coffee-growing communities around the globe.</p>\n    </li>\n    <li>\n        <p><strong>Grow with Us</strong>: We offer comprehensive training programs and opportunities for professional development, helping you refine your skills and advance your career in the coffee industry.</p>\n    </li>\n    <li>\n        <p><strong>Be Part of the Family</strong>: We cultivate a collaborative and supportive work environment where your unique talents and perspectives are valued.</p>\n    </li>\n</ul>\n\n<h4>Current Openings:</h4>\n\n<ul>\n    <li>\n        <p><strong>Coffee Roaster</strong>: Play a vital role in our roasting process, meticulously crafting unique flavor profiles and ensuring the highest quality beans reach our customers.</p>\n    </li>\n    <li>\n        <p><strong>Barista</strong>: Become a coffee ambassador, welcoming guests with a smile, crafting their perfect cup, and sharing your knowledge and passion for coffee.</p>\n    </li>\n    <li>\n        <p><strong>Cafe Manager</strong>: Lead your team in creating a warm and inviting atmosphere, overseeing daily operations, and ensuring exceptional customer service.</p>\n    </li>\n</ul>\n\n<h4>We are always looking for passionate individuals who share our values:</h4>\n\n<ul>\n    <li>\n        <p>A genuine love for coffee and a desire to learn everything there is to know about it.</p>\n    </li>\n    <li>\n        <p>A commitment to ethical sourcing, sustainability, and social responsibility.</p>\n    </li>\n    <li>\n        <p>Excellent communication and interpersonal skills to build rapport with colleagues and customers.</p>\n    </li>\n    <li>\n        <p>A positive attitude, a willingness to learn, and a collaborative spirit.</p>\n    </li>\n</ul>\n\n<p>Ready to join our brewing legacy?</p>\n\n<p>\n    Submit your resume and cover letter, telling us why you\'re a perfect fit for our team. We look forward to meeting passionate individuals who are ready to brew the future with us, one cup at a time.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43'),(10,'Shipping','<section>\n    <h2>Shipping Methods</h2>\n    <p>We offer several shipping methods to choose from:</p>\n    <ul>\n        <li>Standard Shipping - 3 to 5 business days</li>\n        <li>Express Shipping - 1 to 2 business days</li>\n        <li>International Shipping - 7 to 14 business days</li>\n    </ul>\n    <p>Please note that shipping times may vary depending on your location and other factors.</p>\n</section>\n\n<section>\n    <h2>Shipping Costs</h2>\n    <p>Shipping costs are calculated based on the weight of your order and the shipping method selected during checkout.</p>\n    <p>You can view the estimated shipping costs in your shopping cart before completing your purchase.</p>\n</section>\n\n<section>\n    <h2>Tracking Your Order</h2>\n    <p>Once your order has been shipped, you will receive a confirmation email with a tracking number.</p>\n    <p>You can use this tracking number to monitor the status of your delivery on our website or through the shipping carrier\'s website.</p>\n</section>\n\n<section>\n    <h2>Shipping Restrictions</h2>\n    <p>Some items may be subject to shipping restrictions due to size, weight, or destination.</p>\n    <p>If your order contains any restricted items, we will notify you during the checkout process.</p>\n</section>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:02:43','2024-03-15 03:02:43');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'8F3TQPVMM0','bank_transfer',NULL,2161.00,1,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:44','2024-03-15 03:02:44','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'UXGAGBN8YC','stripe',NULL,3766.00,2,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:44','2024-03-15 03:02:44','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'HKMGFOP8NU','paypal',NULL,6372.00,3,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:44','2024-03-15 03:02:44','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'ZJNZPPHACY','bank_transfer',NULL,4053.00,4,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'ONC4BXBVZD','razorpay',NULL,2430.00,5,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'P4TTDVE8TP','bank_transfer',NULL,1119.00,6,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'LF5H5YTDOX','sslcommerz',NULL,1905.00,7,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'0PKW16MQAL','cod',NULL,478.00,8,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:45','2024-03-15 03:02:45','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'Q0KWJHGJOM','bank_transfer',NULL,3819.00,9,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'QPGVWTG9UB','bank_transfer',NULL,3489.00,10,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'GBX9VROXSL','razorpay',NULL,6960.00,11,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'DTOGQPEJFC','stripe',NULL,707.00,12,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'BIVGKSNFYY','paypal',NULL,319.00,13,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:46','2024-03-15 03:02:46','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'DAMTVC9Z7Y','razorpay',NULL,1972.00,14,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'K9EC56XGK8','sslcommerz',NULL,1908.00,15,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'FI0YXVQFXM','stripe',NULL,3916.00,16,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'M74MLCNXYG','paystack',NULL,1908.00,17,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:47','2024-03-15 03:02:47','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'CRSNENCTLP','razorpay',NULL,6951.00,18,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'N1PLNSGS4S','paystack',NULL,6372.00,19,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'V1RKVNXATG','bank_transfer',NULL,638.00,20,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'MEB10P3WRV','sslcommerz',NULL,2757.00,21,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'T5MYCDO7RW','cod',NULL,3186.00,22,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:48','2024-03-15 03:02:48','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'GMXUKMRFXD','cod',NULL,2290.00,23,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'8TEP629UKH','bank_transfer',NULL,3724.00,24,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'YVGPB3FZBX','sslcommerz',NULL,1972.00,25,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'9OMU7YWUWK','paypal',NULL,1434.00,26,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'4TT1PHQTVT','paystack',NULL,1883.00,27,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:49','2024-03-15 03:02:49','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'1XAV2BHGR6','stripe',NULL,2418.00,28,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'UUNHNFLILW','cod',NULL,2757.00,29,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'4XJ3QAKRL1','bank_transfer',NULL,3650.00,30,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'EL7UPAULHL','stripe',NULL,638.00,31,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'3UP0M3WB6A','cod',NULL,1865.00,32,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:50','2024-03-15 03:02:50','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'M4ISJB5P4R','stripe',NULL,6373.00,33,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'HW4LBLW5GY','bank_transfer',NULL,1119.00,34,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'GKURQBTLMQ','stripe',NULL,4322.00,35,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'AXQRSHP7ZI','bank_transfer',NULL,478.00,36,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:51','2024-03-15 03:02:51','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'LZFAUGJW1L','bank_transfer',NULL,3730.00,37,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'ZBKTBNZZYO','cod',NULL,4640.00,38,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'ZZSI0KAG6J','sslcommerz',NULL,1452.00,39,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'ZIWFLDF2VZ','razorpay',NULL,3435.00,40,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'RVW0KYBWUJ','sslcommerz',NULL,3766.00,41,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:52','2024-03-15 03:02:52','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'FSZBH8Q56I','razorpay',NULL,1351.00,42,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\Ecommerce\\Models\\Customer',NULL),(43,'USD',0,'E4OZ9PLFS3','bank_transfer',NULL,3645.00,43,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\Ecommerce\\Models\\Customer',NULL),(44,'USD',0,'DJSNJVXJFT','bank_transfer',NULL,890.00,44,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\Ecommerce\\Models\\Customer',NULL),(45,'USD',0,'DYJARXEV9S','razorpay',NULL,5376.00,45,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\Ecommerce\\Models\\Customer',NULL),(46,'USD',0,'FS1PPZBES1','razorpay',NULL,1862.00,46,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\Ecommerce\\Models\\Customer',NULL),(47,'USD',0,'AEW4OOC1UM','razorpay',NULL,458.00,47,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:53','2024-03-15 03:02:53','Botble\\Ecommerce\\Models\\Customer',NULL),(48,'USD',0,'UE4BC6FCHE','cod',NULL,1233.00,48,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:54','2024-03-15 03:02:54','Botble\\Ecommerce\\Models\\Customer',NULL),(49,'USD',0,'WCKQLNLOLK','paystack',NULL,1062.00,49,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:55','2024-03-15 03:02:55','Botble\\Ecommerce\\Models\\Customer',NULL),(50,'USD',0,'ILRU5TSMMB','paypal',NULL,635.00,50,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56','Botble\\Ecommerce\\Models\\Customer',NULL),(51,'USD',0,'AYYMZSDRO4','sslcommerz',NULL,5649.00,51,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56','Botble\\Ecommerce\\Models\\Customer',NULL),(52,'USD',0,'IVAEYKGNQ2','bank_transfer',NULL,1865.00,52,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56','Botble\\Ecommerce\\Models\\Customer',NULL),(53,'USD',0,'IIU8UMYMSU','razorpay',NULL,2470.00,53,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56','Botble\\Ecommerce\\Models\\Customer',NULL),(54,'USD',0,'7Z2T8DUWX5','cod',NULL,2702.00,54,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:56','2024-03-15 03:02:56','Botble\\Ecommerce\\Models\\Customer',NULL),(55,'USD',0,'W92WFQKSV7','bank_transfer',NULL,1452.00,55,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57','Botble\\Ecommerce\\Models\\Customer',NULL),(56,'USD',0,'5DM5VIWPMW','bank_transfer',NULL,2124.00,56,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57','Botble\\Ecommerce\\Models\\Customer',NULL),(57,'USD',0,'EFTNMRF8YB','razorpay',NULL,319.00,57,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:57','2024-03-15 03:02:57','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (6,1),(3,1),(1,2),(3,2),(4,3),(1,3),(6,4),(5,4),(3,5),(1,5),(4,6),(6,6),(5,7),(6,7),(2,8),(4,8),(3,9),(4,9),(6,10),(4,10),(6,11),(6,12),(6,13),(3,13),(4,14),(4,15),(2,15),(6,16),(3,16),(2,17),(4,17),(1,18),(6,18);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (3,1),(4,1),(6,1),(4,2),(3,2),(1,2),(2,3),(8,3),(3,3),(4,4),(1,4),(3,4),(1,5),(7,6),(5,6),(8,6),(5,7),(2,7),(4,8),(6,8),(2,8),(1,9),(8,9),(3,9),(8,10),(6,10),(5,10),(6,11),(5,11),(3,11),(4,12),(6,12),(5,13),(7,13),(8,14),(7,14),(2,15),(3,15),(5,15),(3,16),(1,16),(6,16),(7,17),(1,17),(2,18),(7,18);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','On which Seven looked up and picking the daisies, when suddenly a White Rabbit put on one side, to look about her pet: \'Dinah\'s our cat. And she\'s such a pleasant temper, and thought to herself.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-3.jpg',1028,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','Lory positively refused to tell them something more. \'You promised to tell me the truth: did you manage on the breeze that followed them, the melancholy words:-- \'Soo--oop of the leaves: \'I should.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-11.jpg',1985,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(3,'The Top 2020 Handbag Trends to Know','Oh, my dear Dinah! I wonder what they said. The executioner\'s argument was, that her shoulders were nowhere to be seen: she found that it was talking in a few minutes, and she drew herself up closer.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-10.jpg',2082,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(4,'How to Match the Color of Your Handbag With an Outfit','Cat, as soon as she did not venture to ask them what the next thing is, to get her head to feel a little anxiously. \'Yes,\' said Alice thoughtfully: \'but then--I shouldn\'t be hungry for it, she found.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-10.jpg',178,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(5,'How to Care for Leather Bags','Alice thought she had never been so much contradicted in her French lesson-book. The Mouse did not like to be in Bill\'s place for a minute, while Alice thought she might as well as she heard the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-8.jpg',676,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','It was, no doubt: only Alice did not sneeze, were the cook, and a piece of rudeness was more and more faintly came, carried on the top with its mouth and began picking them up again with a bound.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-5.jpg',2494,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(7,'Essential Qualities of Highly Successful Music','When the Mouse was swimming away from her as she added, \'and the moral of that is--\"Oh, \'tis love, \'tis love, that makes people hot-tempered,\' she went on, half to herself, \'whenever I eat one of.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',849,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(8,'9 Things I Love About Shaving My Head','All this time she had gone through that day. \'A likely story indeed!\' said the Gryphon. \'Do you take me for his housemaid,\' she said to the Hatter. Alice felt so desperate that she ran with all.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-3.jpg',2438,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(9,'Why Teamwork Really Makes The Dream Work','I used to say.\' \'So he did, so he with his head!\' or \'Off with their fur clinging close to the confused clamour of the same thing as \"I eat what I could let you out, you know.\' He was looking about.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-12.jpg',2318,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(10,'The World Caters to Average People','I\'m talking!\' Just then she walked on in the pool as it could go, and making faces at him as he shook his head off outside,\' the Queen was to get in?\' she repeated, aloud. \'I shall sit here,\' he.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-7.jpg',2329,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(11,'The litigants on the screen are not actors','Christmas.\' And she kept tossing the baby was howling so much surprised, that for two reasons. First, because I\'m on the twelfth?\' Alice went on muttering over the fire, stirring a large cat which.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-9.jpg',1934,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(12,'Hiring the Right Sales Team at the Right Time','I shall have somebody to talk nonsense. The Queen\'s Croquet-Ground A large rose-tree stood near the entrance of the evening, beautiful Soup! \'Beautiful Soup! Who cares for fish, Game, or any other.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-11.jpg',1961,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(13,'Fully Embrace the Return of 90s fashion','How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure those are not attending!\' said the Pigeon; \'but if you\'ve seen them at last, they must be the best.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-5.jpg',754,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(14,'Exploring the English Countryside','NOT marked \'poison,\' so Alice went on talking: \'Dear, dear! How queer everything is queer to-day.\' Just then she walked up towards it rather timidly, as she picked her way into that lovely garden. I.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-7.jpg',425,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(15,'Here’s the First Valentino’s New Makeup Collection','As soon as there was no longer to be Involved in this way! Stop this moment, I tell you!\' said Alice. \'It goes on, you know,\' the Mock Turtle; \'but it sounds uncommon nonsense.\' Alice said nothing.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-7.jpg',2219,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(16,'Follow Your own Design process, whatever gets','Mock Turtle, who looked at it again: but he would deny it too: but the Gryphon replied very politely, \'for I never heard of \"Uglification,\"\' Alice ventured to ask. \'Suppose we change the subject.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-5.jpg',449,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(17,'Freelancer Days 2024, What’s new?','I THINK; or is it twelve? I--\' \'Oh, don\'t talk about her and to wonder what CAN have happened to you? Tell us all about as curious as it was YOUR table,\' said Alice; \'I must go back by railway,\' she.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',2128,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34'),(18,'Quality Foods Requirments For Every Human Body’s','Alice, in a twinkling! Half-past one, time for dinner!\' (\'I only wish they COULD! I\'m sure I can\'t quite follow it as far down the chimney as she said this, she came in sight of the jury had a.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-5.jpg',2072,NULL,'2024-03-15 03:02:34','2024-03-15 03:02:34');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_logs`
--

DROP TABLE IF EXISTS `request_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_code` int DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  `user_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_logs`
--

LOCK TABLES `request_logs` WRITE;
/*!40000 ALTER TABLE `request_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.manage.license\":true,\"extensions.index\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.cronjob\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"plugins.captcha\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.settings\":true,\"plugins.ecommerce\":true,\"ecommerce.settings\":true,\"ecommerce.report.index\":true,\"products.index\":true,\"products.create\":true,\"products.edit\":true,\"products.destroy\":true,\"products.duplicate\":true,\"product-categories.index\":true,\"product-categories.create\":true,\"product-categories.edit\":true,\"product-categories.destroy\":true,\"product-tag.index\":true,\"product-tag.create\":true,\"product-tag.edit\":true,\"product-tag.destroy\":true,\"brands.index\":true,\"brands.create\":true,\"brands.edit\":true,\"brands.destroy\":true,\"product-collections.index\":true,\"product-collections.create\":true,\"product-collections.edit\":true,\"product-collections.destroy\":true,\"product-attribute-sets.index\":true,\"product-attribute-sets.create\":true,\"product-attribute-sets.edit\":true,\"product-attribute-sets.destroy\":true,\"product-attributes.index\":true,\"product-attributes.create\":true,\"product-attributes.edit\":true,\"product-attributes.destroy\":true,\"tax.index\":true,\"tax.create\":true,\"tax.edit\":true,\"tax.destroy\":true,\"reviews.index\":true,\"reviews.create\":true,\"reviews.destroy\":true,\"reviews.publish\":true,\"reviews.reply\":true,\"shipping_methods.index\":true,\"ecommerce.shipping-rule-items.index\":true,\"ecommerce.shipping-rule-items.create\":true,\"ecommerce.shipping-rule-items.edit\":true,\"ecommerce.shipping-rule-items.destroy\":true,\"ecommerce.shipping-rule-items.bulk-import\":true,\"ecommerce.shipments.index\":true,\"ecommerce.shipments.create\":true,\"ecommerce.shipments.edit\":true,\"ecommerce.shipments.destroy\":true,\"orders.index\":true,\"orders.create\":true,\"orders.edit\":true,\"orders.destroy\":true,\"discounts.index\":true,\"discounts.create\":true,\"discounts.edit\":true,\"discounts.destroy\":true,\"customers.index\":true,\"customers.create\":true,\"customers.edit\":true,\"customers.destroy\":true,\"flash-sale.index\":true,\"flash-sale.create\":true,\"flash-sale.edit\":true,\"flash-sale.destroy\":true,\"product-label.index\":true,\"product-label.create\":true,\"product-label.edit\":true,\"product-label.destroy\":true,\"ecommerce.import.products.index\":true,\"ecommerce.export.products.index\":true,\"order_returns.index\":true,\"order_returns.edit\":true,\"order_returns.destroy\":true,\"global-option.index\":true,\"global-option.create\":true,\"global-option.edit\":true,\"global-option.destroy\":true,\"ecommerce.invoice.index\":true,\"ecommerce.invoice.edit\":true,\"ecommerce.invoice.destroy\":true,\"ecommerce.invoice-template.index\":true,\"ecommerce.settings.general\":true,\"ecommerce.settings.currencies\":true,\"ecommerce.settings.products\":true,\"ecommerce.settings.product-search\":true,\"ecommerce.settings.digital-products\":true,\"ecommerce.settings.store-locators\":true,\"ecommerce.settings.invoices\":true,\"ecommerce.settings.product-reviews\":true,\"ecommerce.settings.customers\":true,\"ecommerce.settings.shopping\":true,\"ecommerce.settings.taxes\":true,\"ecommerce.settings.shipping\":true,\"ecommerce.settings.tracking\":true,\"ecommerce.settings.standard-and-format\":true,\"ecommerce.settings.checkout\":true,\"ecommerce.settings.return\":true,\"ecommerce.settings.flash-sale\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"location.bulk-import.index\":true,\"location.export.index\":true,\"marketplace.index\":true,\"marketplace.store.index\":true,\"marketplace.store.create\":true,\"marketplace.store.edit\":true,\"marketplace.store.destroy\":true,\"marketplace.store.view\":true,\"marketplace.store.revenue.create\":true,\"marketplace.withdrawal.index\":true,\"marketplace.withdrawal.edit\":true,\"marketplace.withdrawal.destroy\":true,\"marketplace.vendors.index\":true,\"marketplace.unverified-vendors.index\":true,\"marketplace.unverified-vendors.edit\":true,\"marketplace.settings\":true,\"marketplace.reports\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"request-log.index\":true,\"request-log.destroy\":true,\"sale-popup.settings\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true}','Admin users role',1,1,1,'2024-03-15 03:02:29','2024-03-15 03:02:29');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','825b4419a12fa8e3b961ec14b0a5b4d2',NULL,'2024-03-15 03:02:44'),(2,'api_enabled','0',NULL,'2024-03-15 03:02:44'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"ecommerce\",\"faq\",\"gallery\",\"location\",\"marketplace\",\"newsletter\",\"payment\",\"paypal\",\"paypal-payout\",\"paystack\",\"razorpay\",\"request-log\",\"sale-popup\",\"shippo\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2024-03-15 03:02:44'),(6,'theme','shofy-beauty',NULL,'2024-03-15 03:02:44'),(7,'show_admin_bar','1',NULL,'2024-03-15 03:02:44'),(8,'payment_cod_status','1',NULL,'2024-03-15 03:02:44'),(9,'payment_bank_transfer_status','1',NULL,'2024-03-15 03:02:44'),(10,'admin_favicon','main/general/favicon.png',NULL,'2024-03-15 03:02:44'),(11,'admin_logo','main/general/logo-white.png',NULL,'2024-03-15 03:02:44'),(12,'permalink-botble-blog-models-post','blog',NULL,'2024-03-15 03:02:44'),(13,'permalink-botble-blog-models-category','blog',NULL,'2024-03-15 03:02:44'),(14,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2024-03-15 03:02:44'),(15,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2024-03-15 03:02:44'),(16,'payment_stripe_payment_type','stripe_checkout',NULL,'2024-03-15 03:02:44'),(17,'plugins_ecommerce_customer_new_order_status','0',NULL,'2024-03-15 03:02:44'),(18,'plugins_ecommerce_admin_new_order_status','0',NULL,'2024-03-15 03:02:44'),(19,'ecommerce_is_enabled_support_digital_products','1',NULL,'2024-03-15 03:02:44'),(20,'ecommerce_load_countries_states_cities_from_location_plugin','0',NULL,'2024-03-15 03:02:44'),(21,'language_hide_default','1',NULL,'2024-03-15 03:02:44'),(22,'language_switcher_display','dropdown',NULL,'2024-03-15 03:02:44'),(23,'language_display','all',NULL,'2024-03-15 03:02:44'),(24,'language_hide_languages','[]',NULL,'2024-03-15 03:02:44'),(25,'ecommerce_store_name','Shofy',NULL,'2024-03-15 03:02:44'),(26,'ecommerce_store_phone','1800979769',NULL,'2024-03-15 03:02:44'),(27,'ecommerce_store_address','502 New Street',NULL,'2024-03-15 03:02:44'),(28,'ecommerce_store_state','Brighton VIC',NULL,'2024-03-15 03:02:44'),(29,'ecommerce_store_city','Brighton VIC',NULL,'2024-03-15 03:02:44'),(30,'ecommerce_store_country','AU',NULL,'2024-03-15 03:02:44'),(31,'announcement_max_width','1390',NULL,'2024-03-15 03:02:44'),(32,'announcement_text_color','#010f1c',NULL,'2024-03-15 03:02:44'),(33,'announcement_background_color','transparent',NULL,'2024-03-15 03:02:44'),(34,'announcement_placement','theme',NULL,'2024-03-15 03:02:44'),(35,'announcement_text_alignment','start',NULL,'2024-03-15 03:02:44'),(36,'announcement_dismissible','0',NULL,'2024-03-15 03:02:44'),(37,'simple_slider_using_assets','0',NULL,'2024-03-15 03:02:44'),(38,'theme-shofy-beauty-site_name','Shofy',NULL,NULL),(39,'theme-shofy-beauty-site_title','Shofy - Multipurpose eCommerce Laravel Script',NULL,NULL),(40,'theme-shofy-beauty-seo_description','Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.',NULL,NULL),(41,'theme-shofy-beauty-copyright','© %Y All Rights Reserved.',NULL,NULL),(42,'theme-shofy-beauty-primary_font','Jost',NULL,NULL),(43,'theme-shofy-beauty-primary_color','#BD844C',NULL,NULL),(44,'theme-shofy-beauty-favicon','main/general/favicon.png',NULL,NULL),(45,'theme-shofy-beauty-logo','main/general/logo.png',NULL,NULL),(46,'theme-shofy-beauty-logo_light','main/general/logo-white.png',NULL,NULL),(47,'theme-shofy-beauty-header_style','3',NULL,NULL),(48,'theme-shofy-beauty-preloader_icon','main/general/preloader-icon.png',NULL,NULL),(49,'theme-shofy-beauty-address','502 New Street, Brighton VIC, Australia',NULL,NULL),(50,'theme-shofy-beauty-hotline','8 800 332 65-66',NULL,NULL),(51,'theme-shofy-beauty-email','contact@fartmart.co',NULL,NULL),(52,'theme-shofy-beauty-working_time','Mon - Fri: 07AM - 06PM',NULL,NULL),(53,'theme-shofy-beauty-homepage_id','1',NULL,NULL),(54,'theme-shofy-beauty-blog_page_id','5',NULL,NULL),(55,'theme-shofy-beauty-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(56,'theme-shofy-beauty-cookie_consent_learn_more_url','cookie-policy',NULL,NULL),(57,'theme-shofy-beauty-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(58,'theme-shofy-beauty-number_of_products_per_page','24',NULL,NULL),(59,'theme-shofy-beauty-number_of_cross_sale_product','6',NULL,NULL),(60,'theme-shofy-beauty-ecommerce_products_page_layout','left_sidebar',NULL,NULL),(61,'theme-shofy-beauty-ecommerce_product_item_style','3',NULL,NULL),(62,'theme-shofy-beauty-logo_in_the_checkout_page','main/general/logo.png',NULL,NULL),(63,'theme-shofy-beauty-logo_in_invoices','main/general/logo.png',NULL,NULL),(64,'theme-shofy-beauty-logo_vendor_dashboard','main/general/logo.png',NULL,NULL),(65,'theme-shofy-beauty-404_page_image','main/general/404.png',NULL,NULL),(66,'theme-shofy-beauty-newsletter_popup_enable','1',NULL,NULL),(67,'theme-shofy-beauty-newsletter_popup_image','main/general/newsletter-popup.png',NULL,NULL),(68,'theme-shofy-beauty-newsletter_popup_title','Subscribe Now',NULL,NULL),(69,'theme-shofy-beauty-newsletter_popup_subtitle','Newsletter',NULL,NULL),(70,'theme-shofy-beauty-newsletter_popup_description','Subscribe to our newsletter and get 10% off your first purchase',NULL,NULL),(71,'theme-shofy-beauty-lazy_load_images','1',NULL,NULL),(72,'theme-shofy-beauty-lazy_load_placeholder_image','main/general/placeholder.png',NULL,NULL),(73,'theme-shofy-beauty-breadcrumb_background_image','main/general/breadcrumb.jpg',NULL,NULL),(74,'theme-shofy-beauty-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"Youtube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'The Clothing Collection','beauty/sliders/slider-1.jpg','/products','New Arrivals 2023',0,'2024-03-15 03:02:38','2024-03-15 03:02:38'),(2,1,'The Summer Collection','beauty/sliders/slider-2.jpg','/products','Best Selling 2023',1,'2024-03-15 03:02:38','2024-03-15 03:02:38'),(3,1,'Amazing New designs','beauty/sliders/slider-3.jpg','/products','Winter Has Arrived',2,'2024-03-15 03:02:38','2024-03-15 03:02:38');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2024-03-15 03:02:38','2024-03-15 03:02:38');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'foodpound',1,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:02:29','2024-03-15 03:02:29'),(2,'itea-jsc',2,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:02:29','2024-03-15 03:02:29'),(3,'soda-brand',3,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:02:29','2024-03-15 03:02:29'),(4,'shofy',4,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:02:29','2024-03-15 03:02:29'),(5,'soda-brand',5,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:02:29','2024-03-15 03:02:29'),(6,'electronic',1,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:02:32','2024-03-15 03:02:32'),(7,'mobile',2,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:02:32','2024-03-15 03:02:32'),(8,'iphone',3,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:02:32','2024-03-15 03:02:32'),(9,'printer',4,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:02:32','2024-03-15 03:02:32'),(10,'office',5,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:02:32','2024-03-15 03:02:32'),(11,'it',6,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:02:32','2024-03-15 03:02:32'),(12,'crisp-bread-cake',1,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(13,'fashion',2,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(14,'electronic',3,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(15,'commercial',4,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(16,'organic-fruits',5,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(17,'ecological',6,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(18,'general',1,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(19,'design',2,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(20,'fashion',3,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(21,'branding',4,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(22,'modern',5,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(23,'nature',6,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(24,'vintage',7,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(25,'sunglasses',8,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:02:34','2024-03-15 03:02:34'),(26,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',1,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(27,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',2,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(28,'the-top-2020-handbag-trends-to-know',3,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(29,'how-to-match-the-color-of-your-handbag-with-an-outfit',4,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(30,'how-to-care-for-leather-bags',5,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(31,'were-crushing-hard-on-summers-10-biggest-bag-trends',6,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(32,'essential-qualities-of-highly-successful-music',7,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(33,'9-things-i-love-about-shaving-my-head',8,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(34,'why-teamwork-really-makes-the-dream-work',9,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(35,'the-world-caters-to-average-people',10,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(36,'the-litigants-on-the-screen-are-not-actors',11,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(37,'hiring-the-right-sales-team-at-the-right-time',12,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(38,'fully-embrace-the-return-of-90s-fashion',13,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(39,'exploring-the-english-countryside',14,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(40,'heres-the-first-valentinos-new-makeup-collection',15,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(41,'follow-your-own-design-process-whatever-gets',16,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(42,'freelancer-days-2024-whats-new',17,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(43,'quality-foods-requirments-for-every-human-bodys',18,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:02:34','2024-03-15 03:02:34'),(44,'gopro',1,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:37','2024-03-15 03:02:37'),(45,'global-office',2,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:37','2024-03-15 03:02:37'),(46,'young-shop',3,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:37','2024-03-15 03:02:37'),(47,'global-store',4,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:37','2024-03-15 03:02:37'),(48,'roberts-store',5,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:37','2024-03-15 03:02:37'),(49,'stouffer',6,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:37','2024-03-15 03:02:37'),(50,'starkist',7,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:38','2024-03-15 03:02:38'),(51,'old-el-paso',8,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:02:38','2024-03-15 03:02:38'),(52,'discover-skincare',1,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(53,'clothing',2,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(54,'mens-clothing',3,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(55,'t-shirts',4,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(56,'jeans',5,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(57,'suits',6,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(58,'womens-clothing',7,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(59,'dresses',8,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(60,'blouses',9,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(61,'pants',10,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(62,'accessories',11,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(63,'hats',12,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(64,'scarves',13,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(65,'jewelry',14,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(66,'sportswear',15,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(67,'activewear',16,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(68,'running-shoes',17,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:02:38','2024-03-15 03:02:38'),(69,'vintage-denim-jacket',1,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(70,'floral-maxi-dress',2,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(71,'leather-ankle-boots',3,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(72,'knit-turtleneck-sweater-digital',4,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:03:15'),(73,'classic-aviator-sunglasses',5,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(74,'tailored-wool-blazer',6,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(75,'bohemian-fringe-handbag',7,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(76,'silk-scarf-with-geometric-print-digital',8,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:03:15'),(77,'high-waisted-wide-leg-trousers',9,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(78,'embroidered-boho-blouse',10,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(79,'statement-chunky-necklace',11,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(80,'chic-fedora-hat-digital',12,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:03:15'),(81,'strappy-block-heel-sandals',13,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(82,'velvet-evening-gown',14,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(83,'quilted-crossbody-bag',15,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(84,'distressed-skinny-jeans-digital',16,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:03:15'),(85,'lace-up-combat-boots',17,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(86,'cotton-striped-t-shirt-dress',18,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(87,'printed-palazzo-pants',19,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:39','2024-03-15 03:02:39'),(88,'structured-satchel-bag-digital',20,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:03:15'),(89,'off-shoulder-ruffle-top',21,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(90,'suede-pointed-toe-pumps',22,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(91,'cropped-cable-knit-sweater',23,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(92,'athleisure-jogger-pants-digital',24,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:03:15'),(93,'leopard-print-midi-skirt',25,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(94,'retro-cat-eye-sunglasses',26,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(95,'faux-fur-trimmed-coat',27,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(96,'boho-fringed-kimono-digital',28,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:03:15'),(97,'ruffled-wrap-dress',29,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(98,'beaded-evening-clutch',30,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(99,'wide-brim-floppy-hat',31,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(100,'denim-overall-jumpsuit-digital',32,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:03:15'),(101,'embellished-ballet-flats',33,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(102,'pleated-midi-skirt',34,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(103,'velour-tracksuit-set',35,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(104,'geometric-patterned-cardigan-digital',36,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:03:15'),(105,'buckle-detail-ankle-booties',37,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(106,'embroidered-bomber-jacket',38,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(107,'cowl-neck-knit-poncho',39,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(108,'chunky-knit-infinity-scarf-digital',40,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:03:15'),(109,'retro-high-top-sneakers',41,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(110,'faux-leather-leggings',42,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(111,'metallic-pleated-maxi-skirt',43,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:40','2024-03-15 03:02:40'),(112,'radiant-reflections',1,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:02:43','2024-03-15 03:02:43'),(113,'glamour-grove',2,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:02:43','2024-03-15 03:02:43'),(114,'serene-styles-showcase',3,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:02:43','2024-03-15 03:02:43'),(115,'allure-alcove',4,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:02:43','2024-03-15 03:02:43'),(116,'glamour-galleria',5,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:02:43','2024-03-15 03:02:43'),(117,'beauty-boulevard',6,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:02:43','2024-03-15 03:02:43'),(118,'home',1,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(119,'product-categories',2,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(120,'coupons',3,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(121,'coupons',4,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(122,'blog',5,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(123,'contact',6,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(124,'cookie-policy',7,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(125,'our-story',8,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(126,'careers',9,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(127,'shipping',10,'Botble\\Page\\Models\\Page','','2024-03-15 03:02:43','2024-03-15 03:02:43'),(128,'vintage-denim-jacket',44,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(129,'vintage-denim-jacket',45,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(130,'vintage-denim-jacket',46,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(131,'floral-maxi-dress',47,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(132,'floral-maxi-dress',48,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(133,'leather-ankle-boots',49,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(134,'knit-turtleneck-sweater-digital',50,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(135,'knit-turtleneck-sweater-digital',51,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(136,'knit-turtleneck-sweater-digital',52,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(137,'knit-turtleneck-sweater-digital',53,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(138,'classic-aviator-sunglasses',54,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(139,'tailored-wool-blazer',55,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(140,'tailored-wool-blazer',56,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(141,'bohemian-fringe-handbag',57,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(142,'bohemian-fringe-handbag',58,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(143,'silk-scarf-with-geometric-print-digital',59,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(144,'high-waisted-wide-leg-trousers',60,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(145,'high-waisted-wide-leg-trousers',61,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(146,'high-waisted-wide-leg-trousers',62,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(147,'high-waisted-wide-leg-trousers',63,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(148,'embroidered-boho-blouse',64,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(149,'embroidered-boho-blouse',65,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(150,'embroidered-boho-blouse',66,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(151,'statement-chunky-necklace',67,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(152,'chic-fedora-hat-digital',68,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(153,'chic-fedora-hat-digital',69,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(154,'strappy-block-heel-sandals',70,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(155,'strappy-block-heel-sandals',71,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(156,'strappy-block-heel-sandals',72,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(157,'velvet-evening-gown',73,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(158,'velvet-evening-gown',74,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(159,'velvet-evening-gown',75,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(160,'quilted-crossbody-bag',76,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(161,'quilted-crossbody-bag',77,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(162,'quilted-crossbody-bag',78,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(163,'distressed-skinny-jeans-digital',79,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(164,'lace-up-combat-boots',80,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(165,'lace-up-combat-boots',81,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(166,'cotton-striped-t-shirt-dress',82,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(167,'printed-palazzo-pants',83,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(168,'printed-palazzo-pants',84,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(169,'printed-palazzo-pants',85,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(170,'structured-satchel-bag-digital',86,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(171,'structured-satchel-bag-digital',87,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(172,'off-shoulder-ruffle-top',88,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(173,'off-shoulder-ruffle-top',89,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(174,'off-shoulder-ruffle-top',90,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(175,'off-shoulder-ruffle-top',91,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(176,'off-shoulder-ruffle-top',92,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(177,'suede-pointed-toe-pumps',93,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(178,'suede-pointed-toe-pumps',94,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(179,'suede-pointed-toe-pumps',95,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(180,'cropped-cable-knit-sweater',96,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(181,'cropped-cable-knit-sweater',97,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(182,'cropped-cable-knit-sweater',98,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(183,'athleisure-jogger-pants-digital',99,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(184,'athleisure-jogger-pants-digital',100,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(185,'leopard-print-midi-skirt',101,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(186,'leopard-print-midi-skirt',102,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(187,'retro-cat-eye-sunglasses',103,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(188,'retro-cat-eye-sunglasses',104,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(189,'retro-cat-eye-sunglasses',105,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(190,'retro-cat-eye-sunglasses',106,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(191,'faux-fur-trimmed-coat',107,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(192,'faux-fur-trimmed-coat',108,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(193,'faux-fur-trimmed-coat',109,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(194,'faux-fur-trimmed-coat',110,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(195,'boho-fringed-kimono-digital',111,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(196,'boho-fringed-kimono-digital',112,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(197,'boho-fringed-kimono-digital',113,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(198,'boho-fringed-kimono-digital',114,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(199,'ruffled-wrap-dress',115,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(200,'beaded-evening-clutch',116,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(201,'wide-brim-floppy-hat',117,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(202,'wide-brim-floppy-hat',118,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(203,'wide-brim-floppy-hat',119,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(204,'wide-brim-floppy-hat',120,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(205,'denim-overall-jumpsuit-digital',121,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(206,'denim-overall-jumpsuit-digital',122,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(207,'denim-overall-jumpsuit-digital',123,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(208,'denim-overall-jumpsuit-digital',124,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(209,'embellished-ballet-flats',125,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(210,'pleated-midi-skirt',126,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(211,'velour-tracksuit-set',127,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(212,'velour-tracksuit-set',128,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(213,'velour-tracksuit-set',129,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(214,'geometric-patterned-cardigan-digital',130,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(215,'buckle-detail-ankle-booties',131,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(216,'buckle-detail-ankle-booties',132,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(217,'embroidered-bomber-jacket',133,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(218,'embroidered-bomber-jacket',134,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(219,'embroidered-bomber-jacket',135,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(220,'cowl-neck-knit-poncho',136,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(221,'cowl-neck-knit-poncho',137,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(222,'cowl-neck-knit-poncho',138,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(223,'chunky-knit-infinity-scarf-digital',139,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(224,'chunky-knit-infinity-scarf-digital',140,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(225,'retro-high-top-sneakers',141,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(226,'retro-high-top-sneakers',142,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(227,'retro-high-top-sneakers',143,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(228,'retro-high-top-sneakers',144,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(229,'faux-leather-leggings',145,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(230,'faux-leather-leggings',146,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(231,'metallic-pleated-maxi-skirt',147,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15'),(232,'metallic-pleated-maxi-skirt',148,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:03:15','2024-03-15 03:03:15');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'General',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34'),(2,'Design',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34'),(3,'Fashion',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34'),(4,'Branding',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34'),(5,'Modern',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34'),(6,'Nature',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34'),(7,'Vintage',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34'),(8,'Sunglasses',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:02:34','2024-03-15 03:02:34');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'James Dopli','Thanks for all your efforts and teamwork over the last several months!  Thank you so much','main/users/7.jpg','Developer','published','2024-03-15 03:02:38','2024-03-15 03:02:38'),(2,'Theodore Handle','How you use the city or town name is up to you. All results may be freely used in any work.','main/users/7.jpg','CO Founder','published','2024-03-15 03:02:38','2024-03-15 03:02:38'),(3,'Shahnewaz Sakil','Very happy with our choice to take our daughter to Brave care. The entire team was great! Thank you!','main/users/7.jpg','UI/UX Designer','published','2024-03-15 03:02:38','2024-03-15 03:02:38'),(4,'Albert Flores','Wedding day savior! 5 stars. Their bridal collection is a game-changer. Made me feel like a star.','main/users/9.jpg','Bank of America','published','2024-03-15 03:02:38','2024-03-15 03:02:38');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'joseph.turner@brown.biz',NULL,'$2y$12$mEfYfCxjhz/68Cx2bBISU.avTFs3xEAhUbFFUfPtGDDAjTYs9fE0W',NULL,'2024-03-15 03:02:29','2024-03-15 03:02:29','Celestine','Moen','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInfoWidget','footer_primary_sidebar','shofy-beauty',1,'{\"id\":\"SiteInfoWidget\",\"logo\":\"main\\/general\\/logo.png\",\"logo_height\":50,\"about\":\"Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.\",\"show_social_links\":true}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(2,'CustomMenuWidget','footer_primary_sidebar','shofy-beauty',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"My Account\",\"menu_id\":\"my-account\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(3,'CustomMenuWidget','footer_primary_sidebar','shofy-beauty',3,'{\"id\":\"CustomMenuWidget\",\"name\":\"Information\",\"menu_id\":\"information\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(4,'SiteContactWidget','footer_primary_sidebar','shofy-beauty',4,'{\"id\":\"SiteContactWidget\",\"name\":\"Talk To Us\",\"phone_label\":\"Got Questions? Call us\",\"phone\":\"+670 413 90 762\",\"email\":\"shofy@support.com\",\"address\":\"79 Sleepy Hollow St. Jamaica, New York 1432\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(5,'ProductCategoriesWidget','footer_primary_sidebar','shofy-beauty',5,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Health & Beauty\",\"categories\":[5,6,7,8,10,11,12]}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(6,'ProductCategoriesWidget','footer_primary_sidebar','shofy-beauty',7,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Electronics\",\"categories\":[3,4,15,18,19,20]}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(7,'ProductCategoriesWidget','footer_primary_sidebar','shofy-beauty',8,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Sweet Treats\",\"categories\":[11,12,13,14,15,16,17]}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(8,'ProductCategoriesWidget','footer_primary_sidebar','shofy-beauty',9,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Fashion\",\"categories\":[1,2,3,4,5,6,7,8]}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(9,'NewsletterWidget','footer_top_sidebar','shofy-beauty',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe our Newsletter\",\"subtitle\":\"Sale 20% off all store\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(10,'SiteCopyrightWidget','footer_bottom_sidebar','shofy-beauty',1,'{\"id\":\"SiteCopyrightWidget\",\"content\":\"\\u00a9 %y% All rights Reserved.\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(11,'SiteAcceptedPaymentsWidget','footer_bottom_sidebar','shofy-beauty',2,'{\"id\":\"SiteAcceptedPaymentsWidget\",\"name\":\"Accepted Payments\",\"image\":\"main\\/general\\/footer-pay.png\",\"url\":\"#\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(12,'BlogSearchWidget','blog_sidebar','shofy-beauty',1,'{\"id\":\"BlogSearchWidget\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(13,'BlogAboutMeWidget','blog_sidebar','shofy-beauty',2,'{\"id\":\"BlogAboutMeWidget\",\"name\":\"About Me\",\"author_url\":\"\\/blog\",\"author_avatar\":\"main\\/users\\/1.jpg\",\"author_name\":\"Ravi O\'Leigh\",\"author_role\":\"Photographer & Blogger\",\"author_description\":\"Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient\",\"author_signature\":\"main\\/general\\/signature.png\"}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(14,'BlogPostsWidget','blog_sidebar','shofy-beauty',3,'{\"id\":\"BlogPostsWidget\",\"name\":\"Latest Posts\",\"limit\":3}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(15,'BlogCategoriesWidget','blog_sidebar','shofy-beauty',4,'{\"id\":\"BlogCategoriesWidget\",\"name\":\"Categories\",\"number_display\":6}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(16,'BlogTagsWidget','blog_sidebar','shofy-beauty',5,'{\"id\":\"BlogTagsWidget\",\"name\":\"Popular Tags\",\"number_display\":6}','2024-03-15 03:02:44','2024-03-15 03:02:44'),(17,'ProductDetailInfoWidget','product_details_sidebar','shofy-beauty',1,'{\"id\":\"ProductDetailInfoWidget\",\"messages\":[[{\"key\":\"message\",\"value\":\"30 days easy returns\"}],[{\"key\":\"message\",\"value\":\"Order yours before 2.30pm for same day dispatch\"}]],\"description\":\"Guaranteed safe & secure checkout\",\"image\":\"main\\/general\\/footer-pay.png\"}','2024-03-15 03:02:44','2024-03-15 03:02:44');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-15 17:03:16
