-- MySQL dump 10.13  Distrib 8.3.0, for macos14.2 (arm64)
--
-- Host: 127.0.0.1    Database: shofy
-- ------------------------------------------------------
-- Server version	8.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'23Lqsf0Ai16qMgVhcB2RYlksrYiN4Mya',1,'2024-03-15 03:01:34','2024-03-15 03:01:34','2024-03-15 03:01:34');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'Ads 1','2029-03-15 00:00:00','not_set','UROL9F9ZZVAA','main/banners/1.jpg','/products',0,1,'published','2024-03-15 03:01:49','2024-03-15 03:01:49',1,NULL,NULL),(2,'Ads 2','2029-03-15 00:00:00','not_set','B30VDBKO7SBF','main/banners/2.jpg','/products',0,2,'published','2024-03-15 03:01:49','2024-03-15 03:01:49',1,NULL,NULL),(3,'Ads 3','2029-03-15 00:00:00','not_set','WXAUTIJV1QU0','fashion/banners/1.jpg','/products',0,3,'published','2024-03-15 03:01:49','2024-03-15 03:01:49',1,NULL,NULL),(4,'Ads 4','2029-03-15 00:00:00','not_set','7Z5RXBBWV7J2','fashion/banners/2.jpg','/products',0,4,'published','2024-03-15 03:01:49','2024-03-15 03:01:49',1,NULL,NULL),(5,'Ads 5','2029-03-15 00:00:00','not_set','JY08TDO8FG1E','fashion/banners/3.jpg','/products',0,5,'published','2024-03-15 03:01:49','2024-03-15 03:01:49',1,NULL,NULL),(6,'Ads 6','2029-03-15 00:00:00','not_set','VKJNCBIBQC1O','fashion/banners/4.jpg','/products',0,6,'published','2024-03-15 03:01:49','2024-03-15 03:01:49',1,NULL,NULL);
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Enjoy free shipping on all orders over $99! Shop now and save on delivery costs.',0,NULL,NULL,0,1,'2024-03-15 10:01:44',NULL,1,'2024-03-15 03:01:44','2024-03-15 03:01:44'),(2,'Announcement 2','Need assistance? Our customer support is available 24/7 to help you with any questions or concerns.',0,NULL,NULL,0,1,'2024-03-15 10:01:44',NULL,1,'2024-03-15 03:01:44','2024-03-15 03:01:44'),(3,'Announcement 3','Shop with confidence! We offer a hassle-free 30 days return service for your peace of mind.',0,NULL,NULL,0,1,'2024-03-15 10:01:44',NULL,1,'2024-03-15 03:01:44','2024-03-15 03:01:44');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Crisp Bread &amp; Cake',0,'Quia est vero nobis non. Provident omnis qui nobis culpa pariatur.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(2,'Fashion',0,'Et et sint accusamus cupiditate ut. Veritatis ullam ipsam nulla ut blanditiis. Quam et optio dolor reprehenderit quis mollitia doloremque. Dolorum quia fugit occaecati eos ullam odio rem neque.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(3,'Electronic',0,'Dolor cumque eum veritatis non provident voluptatem. Voluptatem animi temporibus repudiandae sapiente hic repudiandae quasi. Et ipsa reiciendis et quae nihil incidunt impedit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(4,'Commercial',0,'Quis quod aspernatur facere ut at voluptas. Natus quia quibusdam quia qui inventore magni vitae tenetur. Iste et repellendus atque rerum tenetur. Voluptatibus omnis pariatur consequatur adipisci.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(5,'Organic Fruits',0,'Veniam mollitia omnis dicta et assumenda deserunt. Quia dolores aut dolorum et veniam odit. Deserunt et earum et omnis consequatur. Cumque corporis consequuntur est qui odio id quas.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(6,'Ecological',0,'Nihil recusandae harum quia quibusdam. Accusantium explicabo eius molestiae. Officia rerum sed voluptas ullam cum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:01:40','2024-03-15 03:01:40');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Mr. Bill Wintheiser','schowalter.verner@example.net','+17276603132','4915 Kohler Lights Suite 862\nEast Carolyneville, AR 04241-6011','Ea est aperiam aut alias autem.','Nisi commodi rerum a ab illum praesentium asperiores nihil. Aut cumque sint rerum repudiandae. In maxime voluptatem error fuga eius. Est cumque nulla ipsam iusto numquam architecto. Nostrum cupiditate nisi alias saepe nam quae. Laboriosam ut molestias distinctio ab sequi autem fugit. Dolores fugit ipsam aut veritatis corporis ea. Quis temporibus voluptate non consequuntur. Sapiente voluptatem aut et excepturi. Earum tempora ut voluptate eos sapiente quia.','read','2024-03-15 03:01:39','2024-03-15 03:01:39'),(2,'Prof. Marie Fisher I','caesar77@example.net','830-678-6387','811 Petra Forest\nEvieview, HI 26121-0391','Saepe iste quae quia aut ab fuga dolores tempore.','Quam at tenetur maxime repellat. Sit temporibus deserunt aliquam sunt totam. Optio debitis repellat expedita omnis voluptate. Odio error accusamus quas id eum amet. In architecto ut nihil nisi consequatur perferendis et. Sequi excepturi est ipsam dolor totam. Ut et accusamus porro quo placeat officia repudiandae odio. Dicta voluptatem a distinctio. Id ab ipsum amet autem laboriosam culpa. Nesciunt vel in doloribus dicta explicabo. Voluptas rerum dignissimos ut molestias dolores provident.','read','2024-03-15 03:01:39','2024-03-15 03:01:39'),(3,'Iliana Towne','damore.victoria@example.com','+1.913.674.3836','677 Kautzer Tunnel Suite 691\nPort Londonburgh, IN 24523-8784','Aut omnis harum aut quia.','Aliquid occaecati laboriosam molestiae id id quo nostrum esse. Recusandae aut ratione quos odit doloribus consectetur. Repellendus reprehenderit eos quia veniam ex numquam. Est et occaecati nostrum eos et enim eum. Et qui officia quia. Qui quo dignissimos excepturi necessitatibus sed. Odit nesciunt maiores minima iusto ipsum. Maiores vel at omnis et voluptas voluptas. Consequatur dignissimos quibusdam qui minus consequuntur.','read','2024-03-15 03:01:39','2024-03-15 03:01:39'),(4,'Ora Breitenberg','ned54@example.org','+1.425.359.6225','17678 Magali Plaza\nKipmouth, IN 34638-6423','Ratione iure corporis est non.','Officiis perspiciatis expedita ea ut et sit. Iste est ad odit. Fuga minima accusantium ut aliquid est. Fugit magnam id soluta aliquid in velit nulla. Voluptas voluptatibus dignissimos vitae occaecati praesentium. Enim possimus sit hic atque voluptatem nulla enim accusamus. Dolores vel at ut ut aut explicabo non sint. Consequatur quam assumenda quas mollitia. Omnis eum fugit ipsam dolorem officiis excepturi. Exercitationem ea quo consequatur debitis quisquam nulla.','read','2024-03-15 03:01:39','2024-03-15 03:01:39'),(5,'Karolann Stokes MD','rippin.theresa@example.org','303.694.8787','770 Bahringer Fort\nUniquemouth, MO 52372-6515','Et voluptatibus in ipsum quia ut eum quam.','Vel deleniti est quia laborum. Consequatur sint doloremque qui illo molestiae. Ea impedit rem vero alias. Ut voluptatem et quaerat omnis. Rerum molestiae pariatur quas ea et. Laboriosam qui voluptatem id culpa. Dicta deleniti ut laudantium repudiandae numquam fugiat. Quia cupiditate nulla animi eum et assumenda repellendus exercitationem. Et unde consequatur magnam suscipit reprehenderit. Iusto praesentium occaecati voluptas et eligendi.','unread','2024-03-15 03:01:39','2024-03-15 03:01:39'),(6,'Mr. Kaleigh O\'Kon','eluettgen@example.net','217-693-9599','51315 Homenick Prairie\nNorth Pansyville, NV 16668','Nam nostrum eos aut tempore.','Et aliquam autem in laboriosam. Deleniti aliquid debitis doloremque dolorem delectus eius fuga ad. Consequatur quo nobis dolor nam. Et consequatur occaecati veniam quia repellat. Sunt est esse magni quia. Modi sit quod non ut molestias doloremque. Provident consequatur aut aliquid unde deserunt. Voluptatum nulla eum id explicabo laboriosam maxime assumenda. Laborum quia et dolores est at.','unread','2024-03-15 03:01:39','2024-03-15 03:01:39'),(7,'Nedra Pfeffer DVM','lesch.marco@example.com','(315) 556-4813','2323 Lawson Forges\nKuphalfurt, OR 45250','Vel et numquam inventore iure cumque.','Autem recusandae placeat iure voluptates sit. Nam asperiores sit ipsum commodi tempore ut occaecati. Repellendus voluptatibus quisquam doloribus rerum error voluptatibus. Non animi quis modi saepe ducimus nihil autem. Expedita adipisci non minima laboriosam est. Velit qui assumenda est et qui totam quia. Incidunt pariatur possimus voluptatem quidem autem officiis. Explicabo nulla non eum. Qui facilis ea quia vitae odit at quo. Est temporibus a ex voluptatibus eum et autem corporis.','unread','2024-03-15 03:01:39','2024-03-15 03:01:39'),(8,'Katharina Gerhold','tkoelpin@example.net','+1.951.946.3499','64952 Smitham Club\nPort Josephine, NV 10193','Officiis et nam doloribus voluptatum.','Nostrum id odit eum dolores. In dolores excepturi dicta sunt animi. Quas eius sed dolor porro omnis officia vel. Consequatur aut reprehenderit quis ut quas ea. Molestias et esse rem. Culpa nemo explicabo autem et architecto expedita. Enim maxime illo recusandae voluptatibus voluptas quisquam.','read','2024-03-15 03:01:39','2024-03-15 03:01:39'),(9,'Freda Lesch DVM','fritsch.neil@example.org','+1.479.875.8201','86694 Sandrine Ways Apt. 141\nStiedemanntown, OH 02734','Aut est modi sit in quo sunt ullam.','Eos nam debitis est iusto. Dignissimos facere qui illum qui non. Rerum est voluptatum consectetur ab repellendus eaque. Voluptas aut accusantium et iste ducimus cumque. Consequatur sit eveniet nobis corrupti cupiditate culpa aut. Alias sed nesciunt inventore sint. Nulla quasi non sunt ut.','unread','2024-03-15 03:01:39','2024-03-15 03:01:39'),(10,'Ocie Bosco','yharvey@example.org','+1-260-925-3353','351 Larue Camp\nNew Ginaview, WI 03559-4731','Dicta unde necessitatibus quam quia minima.','Dolor nihil asperiores pariatur doloremque eius. Et rerum sit ipsa sit consectetur. Blanditiis est dolorem atque rerum libero sed deserunt. Aut iste laboriosam veritatis suscipit quisquam. Nihil est possimus non sit omnis. Et laboriosam officia quisquam aliquam quis quis. Reiciendis inventore non ad nulla rerum excepturi. Aut corrupti pariatur eum et consequatur atque molestiae. Animi et reprehenderit exercitationem sit.','read','2024-03-15 03:01:39','2024-03-15 03:01:39');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'FoodPound','New Snacks Release',NULL,NULL,'published',0,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(2,'iTea JSC','Happy Tea 100% Organic. From $29.9',NULL,NULL,'published',1,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(3,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',2,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(4,'Shofy','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',3,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(5,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',4,1,'2024-03-15 03:01:35','2024-03-15 03:01:35');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(2,'EUR','€',0,2,1,0,0.84,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(3,'VND','₫',0,0,2,0,23203,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(4,'NGN','₦',1,2,2,0,895.52,'2024-03-15 03:01:35','2024-03-15 03:01:35');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Sunny McDermott','customer@botble.com','+19092099444','CM','Wisconsin','Isaiahfurt','7293 O\'Conner Locks',1,1,'2024-03-15 03:01:36','2024-03-15 03:01:36','02430-3581'),(2,'Sunny McDermott','customer@botble.com','+19042255207','CF','Mississippi','Curtisfort','608 Alvina Valleys',1,0,'2024-03-15 03:01:36','2024-03-15 03:01:36','45947'),(3,'German Hickle','vendor@botble.com','+19202202377','SM','Washington','Susanamouth','36594 Precious Falls Suite 223',2,1,'2024-03-15 03:01:36','2024-03-15 03:01:36','69203'),(4,'German Hickle','vendor@botble.com','+12797380919','AS','Rhode Island','New Sydnie','4651 Deborah Points',2,0,'2024-03-15 03:01:36','2024-03-15 03:01:36','21358'),(5,'Tre Kiehn','barton.willms@example.net','+16605409211','RE','Ohio','Lake Reese','8438 Mann Stream',3,1,'2024-03-15 03:01:36','2024-03-15 03:01:36','59214-8473'),(6,'Dr. Jaydon Schaden II','dwitting@example.net','+15519569786','VA','Wisconsin','Maceyport','93131 Nakia Junctions',4,1,'2024-03-15 03:01:36','2024-03-15 03:01:36','06766'),(7,'Skye Towne I','caesar.muller@example.org','+14347400434','BZ','Nebraska','West Sammyton','472 Andres Road',5,1,'2024-03-15 03:01:37','2024-03-15 03:01:37','40343-5828'),(8,'Eliza Satterfield','kuhlman.demetris@example.com','+19068834734','NR','Kentucky','Cletusport','8378 Dan Courts Suite 486',6,1,'2024-03-15 03:01:37','2024-03-15 03:01:37','97333'),(9,'Jayne Price','carson.witting@example.com','+13645952948','GD','Kentucky','South Halie','728 Purdy Canyon',7,1,'2024-03-15 03:01:37','2024-03-15 03:01:37','50638'),(10,'Vance Gusikowski III','selena.nienow@example.com','+15619530083','GU','Alaska','Port Mona','81190 Felipe Extension',8,1,'2024-03-15 03:01:38','2024-03-15 03:01:38','57425'),(11,'Prof. John Stoltenberg DVM','nstehr@example.net','+18322573230','BN','South Dakota','Lake Brook','9600 Dorris Dale',9,1,'2024-03-15 03:01:38','2024-03-15 03:01:38','55738'),(12,'Miss Eileen Zulauf DDS','drunolfsdottir@example.com','+15757175376','SA','Washington','South Alexander','76043 Marks Parkway',10,1,'2024-03-15 03:01:38','2024-03-15 03:01:38','96346-2867');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Sunny McDermott','customer@botble.com','$2y$12$eGX9GdN.TMsPPh/NlKtTgOYvm0tGY07Uu7jIWBspRjCNdu75StSQG','main/customers/7.jpg','1988-03-11','+14066684264',NULL,'2024-03-15 03:01:36','2024-03-15 03:01:42','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(2,'German Hickle','vendor@botble.com','$2y$12$7ELmIvA6RKMz/fKWQOr44uLpWJRBepmq2LGAQHEbFFsWIQwEwM4ca','main/customers/8.jpg','1993-03-14','+15705785874',NULL,'2024-03-15 03:01:36','2024-03-15 03:01:42','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(3,'Tre Kiehn','barton.willms@example.net','$2y$12$YHcxxtP0Eb3Rhmq1EBajbeh6B7zMXMDVSM6lCKiW.9m24C8DHfUja','main/customers/1.jpg','1998-02-26','+15519950812',NULL,'2024-03-15 03:01:36','2024-03-15 03:01:42','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(4,'Dr. Jaydon Schaden II','dwitting@example.net','$2y$12$H9HIQIVpyi.fRvqJ8e3aNOrl.kXeA31e1KY4vyH3Q3u7G8LDbnk76','main/customers/2.jpg','1988-03-01','+12014432161',NULL,'2024-03-15 03:01:36','2024-03-15 03:01:43','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(5,'Skye Towne I','caesar.muller@example.org','$2y$12$lw0jADpagqpsTCjUUNsXCeKqr6yxQOxmWT8tlO0IuLOa/92w/gnWK','main/customers/3.jpg','1985-02-14','+17068949097',NULL,'2024-03-15 03:01:37','2024-03-15 03:01:43','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(6,'Eliza Satterfield','kuhlman.demetris@example.com','$2y$12$xkpzZCdnY9G8xsMgXa/onOZx2YaKJVuycOZEdmU2YX.Lzzof8AEJ.','main/customers/4.jpg','1987-02-18','+17404510844',NULL,'2024-03-15 03:01:37','2024-03-15 03:01:43','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(7,'Jayne Price','carson.witting@example.com','$2y$12$L09akgFcPfT8MtXl1z8xzOSgSHCjD03NftrFIYlLW/Ye1y3NiLU56','main/customers/5.jpg','1988-02-15','+17208846446',NULL,'2024-03-15 03:01:37','2024-03-15 03:01:43','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(8,'Vance Gusikowski III','selena.nienow@example.com','$2y$12$i5H/fY3kSkwUE5LdDjGtR.52/5fnxmnxovmIg098CHPE1JhbWvMbu','main/customers/6.jpg','2002-02-21','+17206310423',NULL,'2024-03-15 03:01:38','2024-03-15 03:01:44','2024-03-15 10:01:35',NULL,1,'2024-03-15 10:01:42','activated',NULL),(9,'Prof. John Stoltenberg DVM','nstehr@example.net','$2y$12$HpKTHO1qnYSNCdEqm29FROL0HLwfWuoAkxQJ2mojQkEiZwCXv9/BS','main/customers/7.jpg','1988-02-14','+16623532783',NULL,'2024-03-15 03:01:38','2024-03-15 03:01:44','2024-03-15 10:01:35',NULL,0,NULL,'activated',NULL),(10,'Miss Eileen Zulauf DDS','drunolfsdottir@example.com','$2y$12$d7roKhPpJSNNwJCf1SavFeYOLoHVG/QD4wYfDRucMWrKGCyzl2BFq','main/customers/8.jpg','2001-02-20','+17709321256',NULL,'2024-03-15 03:01:38','2024-03-15 03:01:44','2024-03-15 10:01:35',NULL,0,NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','JBBNGHHRFTSF','2024-03-14 10:01:41','2024-03-27 10:01:41',NULL,0,504,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(2,'Discount 2','25CQFCNZZVT2','2024-03-14 10:01:41',NULL,NULL,0,626,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(3,'Discount 3','UJATM0SROVPA','2024-03-14 10:01:41',NULL,NULL,0,823,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(4,'Discount 4','LAVPDJNSRIM2','2024-03-14 10:01:41','2024-03-24 10:01:41',NULL,0,30,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(5,'Discount 5','IP4EUXZKPAST','2024-03-14 10:01:41','2024-04-07 10:01:41',NULL,0,288,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(6,'Discount 6','CVUVCPEK1ANS','2024-03-14 10:01:41',NULL,NULL,0,72,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(7,'Discount 7','DGM2LGZKOO6R','2024-03-14 10:01:41','2024-03-19 10:01:41',NULL,0,309,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(8,'Discount 8','MDER2MJVS6AR','2024-03-14 10:01:41','2024-04-09 10:01:41',NULL,0,71,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(9,'Discount 9','NTLDZK9KC753','2024-03-14 10:01:41',NULL,NULL,0,493,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL),(10,'Discount 10','DEA4EAT4GKWS','2024-03-14 10:01:41',NULL,NULL,0,544,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL,NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,760.8,9,5),(1,2,334.56,20,2),(1,3,1258.52,20,2),(1,4,858.6984,13,3),(1,5,174.96,9,4),(1,6,183.91,15,1),(1,7,1407.66,15,1),(1,8,866.8198,12,1),(1,9,1429.84,19,2),(1,10,1319.85,10,5);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2024-04-14 00:00:00','published','2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(1,2,'2 Year',10,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(1,3,'3 Year',20,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(2,4,'4GB',0,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(2,5,'8GB',10,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(2,6,'16GB',20,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(3,7,'Core i5',0,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(3,8,'Core i7',10,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(3,9,'Core i9',20,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(4,10,'128GB',0,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(4,11,'256GB',10,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(4,12,'512GB',20,9999,0,'2024-03-15 03:01:41','2024-03-15 03:01:41');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2024-03-15 03:01:41','2024-03-15 03:01:41');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
INSERT INTO `ec_invoice_items` VALUES (1,1,'Botble\\Ecommerce\\Models\\Product',54,'Classic Aviator Sunglasses',NULL,'fashion/products/product-4.png',2,324.00,648.00,0.00,0.00,648.00,'{\"sku\":\"YN-124-A0-A1\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(2,2,'Botble\\Ecommerce\\Models\\Product',135,'Buckle Detail Ankle Booties',NULL,'fashion/products/product-3.png',3,398.00,1194.00,0.00,0.00,1194.00,'{\"sku\":\"YM-108-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(3,3,'Botble\\Ecommerce\\Models\\Product',113,'Ruffled Wrap Dress',NULL,'fashion/products/product-3.png',1,1541.00,1541.00,0.00,0.00,1541.00,'{\"sku\":\"7J-122-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(4,4,'Botble\\Ecommerce\\Models\\Product',130,'Velour Tracksuit Set',NULL,'fashion/products/product-6.png',2,1258.00,2516.00,0.00,0.00,2516.00,'{\"sku\":\"MT-110-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(5,5,'Botble\\Ecommerce\\Models\\Product',145,'Retro High-Top Sneakers',NULL,'fashion/products/product-6.png',1,517.00,517.00,0.00,0.00,517.00,'{\"sku\":\"XP-105-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}','2024-03-15 03:01:51','2024-03-15 03:01:51'),(6,6,'Botble\\Ecommerce\\Models\\Product',65,'High-Waisted Wide Leg Trousers',NULL,'fashion/products/product-2.png',1,2344.00,2344.00,0.00,0.00,2344.00,'{\"sku\":\"TI-119-A0\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:01:51','2024-03-15 03:01:51'),(7,6,'Botble\\Ecommerce\\Models\\Product',100,'Cropped Cable Knit Sweater',NULL,'fashion/products/product-5.png',3,1095.00,3285.00,0.00,0.00,3285.00,'{\"sku\":\"LW-179-A0-A3\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-15 03:01:51','2024-03-15 03:01:51'),(8,7,'Botble\\Ecommerce\\Models\\Product',55,'Classic Aviator Sunglasses',NULL,'fashion/products/product-1.png',2,324.00,648.00,0.00,0.00,648.00,'{\"sku\":\"YN-124-A0-A2\",\"attributes\":\"(Color: Black, Size: XXL)\"}','2024-03-15 03:01:51','2024-03-15 03:01:51'),(9,7,'Botble\\Ecommerce\\Models\\Product',62,'Silk Scarf with Geometric Print (Digital)',NULL,'fashion/products/product-6.png',3,1309.00,3927.00,0.00,0.00,3927.00,'{\"sku\":\"Y8-136-A0-A1\",\"attributes\":\"(Color: Blue, Size: XL)\"}','2024-03-15 03:01:51','2024-03-15 03:01:51'),(10,8,'Botble\\Ecommerce\\Models\\Product',70,'Statement Chunky Necklace',NULL,'fashion/products/product-2.png',1,576.00,576.00,0.00,0.00,576.00,'{\"sku\":\"GP-110-A0-A1\",\"attributes\":\"(Color: Green, Size: M)\"}','2024-03-15 03:01:51','2024-03-15 03:01:51'),(11,9,'Botble\\Ecommerce\\Models\\Product',65,'High-Waisted Wide Leg Trousers',NULL,'fashion/products/product-2.png',2,2344.00,4688.00,0.00,0.00,4688.00,'{\"sku\":\"TI-119-A0\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:01:52','2024-03-15 03:01:52'),(12,10,'Botble\\Ecommerce\\Models\\Product',138,'Embroidered Bomber Jacket',NULL,'fashion/products/product-6.png',2,2449.00,4898.00,0.00,0.00,4898.00,'{\"sku\":\"K9-161-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:52','2024-03-15 03:01:52'),(13,11,'Botble\\Ecommerce\\Models\\Product',104,'Athleisure Jogger Pants (Digital)',NULL,'fashion/products/product-3.png',2,2174.00,4348.00,0.00,0.00,4348.00,'{\"sku\":\"3I-116-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:01:53','2024-03-15 03:01:53'),(14,12,'Botble\\Ecommerce\\Models\\Product',135,'Buckle Detail Ankle Booties',NULL,'fashion/products/product-3.png',2,398.00,796.00,0.00,0.00,796.00,'{\"sku\":\"YM-108-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-15 03:01:54','2024-03-15 03:01:54'),(15,13,'Botble\\Ecommerce\\Models\\Product',56,'Tailored Wool Blazer',NULL,'fashion/products/product-2.png',1,347.00,347.00,0.00,0.00,347.00,'{\"sku\":\"4Z-114-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}','2024-03-15 03:01:54','2024-03-15 03:01:54'),(16,13,'Botble\\Ecommerce\\Models\\Product',149,'Metallic Pleated Maxi Skirt',NULL,'fashion/products/product-2.png',3,1048.00,3144.00,0.00,0.00,3144.00,'{\"sku\":\"N7-144-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-15 03:01:54','2024-03-15 03:01:54'),(17,14,'Botble\\Ecommerce\\Models\\Product',90,'Structured Satchel Bag (Digital)',NULL,'fashion/products/product-7.png',3,1076.00,3228.00,0.00,0.00,3228.00,'{\"sku\":\"3W-199-A0-A1\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-15 03:01:54','2024-03-15 03:01:54'),(18,15,'Botble\\Ecommerce\\Models\\Product',118,'Wide Brim Floppy Hat',NULL,'fashion/products/product-8.png',1,446.00,446.00,0.00,0.00,446.00,'{\"sku\":\"RO-115-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:55','2024-03-15 03:01:55'),(19,16,'Botble\\Ecommerce\\Models\\Product',53,'Classic Aviator Sunglasses',NULL,'fashion/products/product-8.png',3,324.00,972.00,0.00,0.00,972.00,'{\"sku\":\"YN-124-A0\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-15 03:01:55','2024-03-15 03:01:55'),(20,17,'Botble\\Ecommerce\\Models\\Product',65,'High-Waisted Wide Leg Trousers',NULL,'fashion/products/product-2.png',2,2344.00,4688.00,0.00,0.00,4688.00,'{\"sku\":\"TI-119-A0\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:01:55','2024-03-15 03:01:55'),(21,18,'Botble\\Ecommerce\\Models\\Product',118,'Wide Brim Floppy Hat',NULL,'fashion/products/product-8.png',2,446.00,892.00,0.00,0.00,892.00,'{\"sku\":\"RO-115-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:55','2024-03-15 03:01:55'),(22,19,'Botble\\Ecommerce\\Models\\Product',138,'Embroidered Bomber Jacket',NULL,'fashion/products/product-6.png',3,2449.00,7347.00,0.00,0.00,7347.00,'{\"sku\":\"K9-161-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:56','2024-03-15 03:01:56'),(23,20,'Botble\\Ecommerce\\Models\\Product',68,'Embroidered Boho Blouse',NULL,'fashion/products/product-8.png',2,2095.00,4190.00,0.00,0.00,4190.00,'{\"sku\":\"QA-126-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:01:56','2024-03-15 03:01:56'),(24,21,'Botble\\Ecommerce\\Models\\Product',100,'Cropped Cable Knit Sweater',NULL,'fashion/products/product-5.png',1,1095.00,1095.00,0.00,0.00,1095.00,'{\"sku\":\"LW-179-A0-A3\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-15 03:01:56','2024-03-15 03:01:56'),(25,22,'Botble\\Ecommerce\\Models\\Product',118,'Wide Brim Floppy Hat',NULL,'fashion/products/product-8.png',3,446.00,1338.00,0.00,0.00,1338.00,'{\"sku\":\"RO-115-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:56','2024-03-15 03:01:56'),(26,23,'Botble\\Ecommerce\\Models\\Product',138,'Embroidered Bomber Jacket',NULL,'fashion/products/product-6.png',3,2449.00,7347.00,0.00,0.00,7347.00,'{\"sku\":\"K9-161-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:56','2024-03-15 03:01:56'),(27,24,'Botble\\Ecommerce\\Models\\Product',143,'Chunky Knit Infinity Scarf (Digital)',NULL,'fashion/products/product-3.png',1,2471.00,2471.00,0.00,0.00,2471.00,'{\"sku\":\"LW-185-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:01:57','2024-03-15 03:01:57'),(28,25,'Botble\\Ecommerce\\Models\\Product',144,'Retro High-Top Sneakers',NULL,'fashion/products/product-7.png',2,517.00,1034.00,0.00,0.00,1034.00,'{\"sku\":\"XP-105-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:57','2024-03-15 03:01:57'),(29,26,'Botble\\Ecommerce\\Models\\Product',73,'Chic Fedora Hat (Digital)',NULL,'fashion/products/product-2.png',2,376.00,752.00,0.00,0.00,752.00,'{\"sku\":\"WU-134-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}','2024-03-15 03:01:57','2024-03-15 03:01:57'),(30,27,'Botble\\Ecommerce\\Models\\Product',104,'Athleisure Jogger Pants (Digital)',NULL,'fashion/products/product-3.png',3,2174.00,6522.00,0.00,0.00,6522.00,'{\"sku\":\"3I-116-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:01:57','2024-03-15 03:01:57'),(31,28,'Botble\\Ecommerce\\Models\\Product',71,'Statement Chunky Necklace',NULL,'fashion/products/product-3.png',2,576.00,1152.00,0.00,0.00,1152.00,'{\"sku\":\"GP-110-A0-A2\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-15 03:01:58','2024-03-15 03:01:58'),(32,29,'Botble\\Ecommerce\\Models\\Product',81,'Distressed Skinny Jeans (Digital)',NULL,'fashion/products/product-7.png',2,1638.00,3276.00,0.00,0.00,3276.00,'{\"sku\":\"QA-196-A0-A1\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:01:58','2024-03-15 03:01:58'),(33,30,'Botble\\Ecommerce\\Models\\Product',107,'Retro Cat-Eye Sunglasses',NULL,'fashion/products/product-5.png',2,1467.00,2934.00,0.00,0.00,2934.00,'{\"sku\":\"R7-154-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-15 03:01:58','2024-03-15 03:01:58'),(34,31,'Botble\\Ecommerce\\Models\\Product',72,'Chic Fedora Hat (Digital)',NULL,'fashion/products/product-8.png',1,376.00,376.00,0.00,0.00,376.00,'{\"sku\":\"WU-134-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}','2024-03-15 03:01:58','2024-03-15 03:01:58'),(35,32,'Botble\\Ecommerce\\Models\\Product',106,'Retro Cat-Eye Sunglasses',NULL,'fashion/products/product-3.png',3,1467.00,4401.00,0.00,0.00,4401.00,'{\"sku\":\"R7-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-15 03:01:58','2024-03-15 03:01:58'),(36,33,'Botble\\Ecommerce\\Models\\Product',132,'Velour Tracksuit Set',NULL,'fashion/products/product-5.png',2,1258.00,2516.00,0.00,0.00,2516.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:01:59','2024-03-15 03:01:59'),(37,34,'Botble\\Ecommerce\\Models\\Product',143,'Chunky Knit Infinity Scarf (Digital)',NULL,'fashion/products/product-3.png',3,2471.00,7413.00,0.00,0.00,7413.00,'{\"sku\":\"LW-185-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:01:59','2024-03-15 03:01:59'),(38,35,'Botble\\Ecommerce\\Models\\Product',99,'Cropped Cable Knit Sweater',NULL,'fashion/products/product-2.png',2,1095.00,2190.00,0.00,0.00,2190.00,'{\"sku\":\"LW-179-A0-A2\",\"attributes\":\"(Color: Blue, Size: XXL)\"}','2024-03-15 03:01:59','2024-03-15 03:01:59'),(39,36,'Botble\\Ecommerce\\Models\\Product',104,'Athleisure Jogger Pants (Digital)',NULL,'fashion/products/product-3.png',3,2174.00,6522.00,0.00,0.00,6522.00,'{\"sku\":\"3I-116-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:01:59','2024-03-15 03:01:59'),(40,37,'Botble\\Ecommerce\\Models\\Product',150,'Metallic Pleated Maxi Skirt',NULL,'fashion/products/product-5.png',3,1048.00,3144.00,0.00,0.00,3144.00,'{\"sku\":\"N7-144-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:01:59','2024-03-15 03:01:59'),(41,38,'Botble\\Ecommerce\\Models\\Product',110,'Boho Fringed Kimono (Digital)',NULL,'fashion/products/product-6.png',1,478.00,478.00,0.00,0.00,478.00,'{\"sku\":\"W2-104-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:00','2024-03-15 03:02:00'),(42,39,'Botble\\Ecommerce\\Models\\Product',122,'Denim Overall Jumpsuit (Digital)',NULL,'fashion/products/product-3.png',1,2134.00,2134.00,0.00,0.00,2134.00,'{\"sku\":\"HD-143-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}','2024-03-15 03:02:00','2024-03-15 03:02:00'),(43,39,'Botble\\Ecommerce\\Models\\Product',132,'Velour Tracksuit Set',NULL,'fashion/products/product-5.png',1,1258.00,1258.00,0.00,0.00,1258.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:00','2024-03-15 03:02:00'),(44,40,'Botble\\Ecommerce\\Models\\Product',132,'Velour Tracksuit Set',NULL,'fashion/products/product-5.png',3,1258.00,3774.00,0.00,0.00,3774.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:00','2024-03-15 03:02:00'),(45,41,'Botble\\Ecommerce\\Models\\Product',150,'Metallic Pleated Maxi Skirt',NULL,'fashion/products/product-5.png',3,1048.00,3144.00,0.00,0.00,3144.00,'{\"sku\":\"N7-144-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:00','2024-03-15 03:02:00'),(46,42,'Botble\\Ecommerce\\Models\\Product',52,'Knit Turtleneck Sweater (Digital)',NULL,'fashion/products/product-4.png',2,1941.00,3882.00,0.00,0.00,3882.00,'{\"sku\":\"SL-181-A0-A3\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-15 03:02:00','2024-03-15 03:02:00'),(47,43,'Botble\\Ecommerce\\Models\\Product',149,'Metallic Pleated Maxi Skirt',NULL,'fashion/products/product-2.png',3,1048.00,3144.00,0.00,0.00,3144.00,'{\"sku\":\"N7-144-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}','2024-03-15 03:02:01','2024-03-15 03:02:01'),(48,44,'Botble\\Ecommerce\\Models\\Product',57,'Tailored Wool Blazer',NULL,'fashion/products/product-1.png',1,347.00,347.00,0.00,0.00,347.00,'{\"sku\":\"4Z-114-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-15 03:02:01','2024-03-15 03:02:01'),(49,45,'Botble\\Ecommerce\\Models\\Product',101,'Athleisure Jogger Pants (Digital)',NULL,'fashion/products/product-4.png',2,2174.00,4348.00,0.00,0.00,4348.00,'{\"sku\":\"3I-116-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:01','2024-03-15 03:02:01'),(50,46,'Botble\\Ecommerce\\Models\\Product',119,'Wide Brim Floppy Hat',NULL,'fashion/products/product-4.png',2,446.00,892.00,0.00,0.00,892.00,'{\"sku\":\"RO-115-A0-A3\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:01','2024-03-15 03:02:01'),(51,47,'Botble\\Ecommerce\\Models\\Product',132,'Velour Tracksuit Set',NULL,'fashion/products/product-5.png',1,1258.00,1258.00,0.00,0.00,1258.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:02:01','2024-03-15 03:02:01'),(52,48,'Botble\\Ecommerce\\Models\\Product',74,'Strappy Block Heel Sandals',NULL,'fashion/products/product-4.png',1,430.00,430.00,0.00,0.00,430.00,'{\"sku\":\"SG-132-A0\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:02:02','2024-03-15 03:02:02'),(53,49,'Botble\\Ecommerce\\Models\\Product',93,'Off-Shoulder Ruffle Top',NULL,'fashion/products/product-1.png',2,1749.00,3498.00,0.00,0.00,3498.00,'{\"sku\":\"WA-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-15 03:02:02','2024-03-15 03:02:02'),(54,50,'Botble\\Ecommerce\\Models\\Product',102,'Athleisure Jogger Pants (Digital)',NULL,'fashion/products/product-7.png',2,2174.00,4348.00,0.00,0.00,4348.00,'{\"sku\":\"3I-116-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:02:02','2024-03-15 03:02:02'),(55,51,'Botble\\Ecommerce\\Models\\Product',136,'Buckle Detail Ankle Booties',NULL,'fashion/products/product-1.png',2,398.00,796.00,0.00,0.00,796.00,'{\"sku\":\"YM-108-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}','2024-03-15 03:02:02','2024-03-15 03:02:02'),(56,52,'Botble\\Ecommerce\\Models\\Product',86,'Cotton Striped T-Shirt Dress',NULL,'fashion/products/product-5.png',3,1190.00,3570.00,0.00,0.00,3570.00,'{\"sku\":\"ZN-197-A0-A2\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-15 03:02:02','2024-03-15 03:02:02'),(57,53,'Botble\\Ecommerce\\Models\\Product',134,'Geometric Patterned Cardigan (Digital)',NULL,'fashion/products/product-2.png',2,1993.00,3986.00,0.00,0.00,3986.00,'{\"sku\":\"TN-107-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-15 03:02:03','2024-03-15 03:02:03'),(58,54,'Botble\\Ecommerce\\Models\\Product',135,'Buckle Detail Ankle Booties',NULL,'fashion/products/product-3.png',1,398.00,398.00,0.00,0.00,398.00,'{\"sku\":\"YM-108-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-15 03:02:03','2024-03-15 03:02:03');
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
INSERT INTO `ec_invoices` VALUES (1,'Botble\\Ecommerce\\Models\\Order',1,'INV-1','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,648.00,0.00,0.00,0.00,'1','default',NULL,NULL,648.00,NULL,1,'pending',NULL,'2024-03-11 19:01:50','2024-03-15 03:01:50'),(2,'Botble\\Ecommerce\\Models\\Order',2,'INV-2','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,1194.00,0.00,0.00,0.00,'1','default',NULL,NULL,1194.00,NULL,2,'completed','2024-03-15 03:01:50','2024-02-27 11:01:50','2024-03-15 03:01:50'),(3,'Botble\\Ecommerce\\Models\\Order',3,'INV-3','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,1541.00,0.00,0.00,0.00,'1','default',NULL,NULL,1541.00,NULL,3,'completed','2024-03-15 03:01:50','2024-03-13 13:01:50','2024-03-15 03:01:50'),(4,'Botble\\Ecommerce\\Models\\Order',4,'INV-4','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,2516.00,0.00,0.00,0.00,'1','default',NULL,NULL,2516.00,NULL,4,'pending',NULL,'2024-03-08 19:01:50','2024-03-15 03:01:50'),(5,'Botble\\Ecommerce\\Models\\Order',5,'INV-5','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,517.00,0.00,0.00,0.00,'1','default',NULL,NULL,517.00,NULL,5,'completed','2024-03-15 03:01:51','2024-03-08 19:01:51','2024-03-15 03:01:51'),(6,'Botble\\Ecommerce\\Models\\Order',6,'INV-6','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,5629.00,0.00,0.00,0.00,'1','default',NULL,NULL,5629.00,NULL,6,'pending',NULL,'2024-03-01 15:01:51','2024-03-15 03:01:51'),(7,'Botble\\Ecommerce\\Models\\Order',7,'INV-7','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,4575.00,0.00,0.00,0.00,'1','default',NULL,NULL,4575.00,NULL,7,'pending',NULL,'2024-03-05 05:01:51','2024-03-15 03:01:51'),(8,'Botble\\Ecommerce\\Models\\Order',8,'INV-8','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,576.00,0.00,0.00,0.00,'1','default',NULL,NULL,576.00,NULL,8,'completed','2024-03-15 03:01:51','2024-02-29 23:01:51','2024-03-15 03:01:51'),(9,'Botble\\Ecommerce\\Models\\Order',9,'INV-9','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,4688.00,0.00,0.00,0.00,'1','default',NULL,NULL,4688.00,NULL,9,'completed','2024-03-15 03:01:51','2024-03-04 11:01:51','2024-03-15 03:01:52'),(10,'Botble\\Ecommerce\\Models\\Order',10,'INV-10','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,4898.00,0.00,0.00,0.00,'1','default',NULL,NULL,4898.00,NULL,10,'completed','2024-03-15 03:01:52','2024-03-07 03:01:52','2024-03-15 03:01:52'),(11,'Botble\\Ecommerce\\Models\\Order',11,'INV-11','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,4348.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4348.00,NULL,11,'completed','2024-03-15 03:01:53','2024-03-06 09:01:52','2024-03-15 03:01:53'),(12,'Botble\\Ecommerce\\Models\\Order',12,'INV-12','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,796.00,0.00,0.00,0.00,'1','default',NULL,NULL,796.00,NULL,12,'pending',NULL,'2024-03-06 09:01:54','2024-03-15 03:01:54'),(13,'Botble\\Ecommerce\\Models\\Order',13,'INV-13','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,3491.00,0.00,0.00,0.00,'1','default',NULL,NULL,3491.00,NULL,13,'completed','2024-03-15 03:01:54','2024-03-03 11:01:54','2024-03-15 03:01:54'),(14,'Botble\\Ecommerce\\Models\\Order',14,'INV-14','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,3228.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3228.00,NULL,14,'completed','2024-03-15 03:01:54','2024-03-05 19:01:54','2024-03-15 03:01:54'),(15,'Botble\\Ecommerce\\Models\\Order',15,'INV-15','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,446.00,0.00,0.00,0.00,'1','default',NULL,NULL,446.00,NULL,15,'completed','2024-03-15 03:01:55','2024-03-05 19:01:55','2024-03-15 03:01:55'),(16,'Botble\\Ecommerce\\Models\\Order',16,'INV-16','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,972.00,0.00,0.00,0.00,'1','default',NULL,NULL,972.00,NULL,16,'completed','2024-03-15 03:01:55','2024-03-10 19:01:55','2024-03-15 03:01:55'),(17,'Botble\\Ecommerce\\Models\\Order',17,'INV-17','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,4688.00,0.00,0.00,0.00,'1','default',NULL,NULL,4688.00,NULL,17,'pending',NULL,'2024-03-12 23:01:55','2024-03-15 03:01:55'),(18,'Botble\\Ecommerce\\Models\\Order',18,'INV-18','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,892.00,0.00,0.00,0.00,'1','default',NULL,NULL,892.00,NULL,18,'completed','2024-03-15 03:01:55','2024-03-14 01:01:55','2024-03-15 03:01:55'),(19,'Botble\\Ecommerce\\Models\\Order',19,'INV-19','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,7347.00,0.00,0.00,0.00,'1','default',NULL,NULL,7347.00,NULL,19,'pending',NULL,'2024-03-09 17:01:55','2024-03-15 03:01:56'),(20,'Botble\\Ecommerce\\Models\\Order',20,'INV-20','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,4190.00,0.00,0.00,0.00,'1','default',NULL,NULL,4190.00,NULL,20,'pending',NULL,'2024-03-05 03:01:56','2024-03-15 03:01:56'),(21,'Botble\\Ecommerce\\Models\\Order',21,'INV-21','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,1095.00,0.00,0.00,0.00,'1','default',NULL,NULL,1095.00,NULL,21,'completed','2024-03-15 03:01:56','2024-03-10 03:01:56','2024-03-15 03:01:56'),(22,'Botble\\Ecommerce\\Models\\Order',22,'INV-22','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,1338.00,0.00,0.00,0.00,'1','default',NULL,NULL,1338.00,NULL,22,'completed','2024-03-15 03:01:56','2024-03-13 03:01:56','2024-03-15 03:01:56'),(23,'Botble\\Ecommerce\\Models\\Order',23,'INV-23','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,7347.00,0.00,0.00,0.00,'1','default',NULL,NULL,7347.00,NULL,23,'completed','2024-03-15 03:01:56','2024-03-13 07:01:56','2024-03-15 03:01:56'),(24,'Botble\\Ecommerce\\Models\\Order',24,'INV-24','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,2471.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2471.00,NULL,24,'completed','2024-03-15 03:01:57','2024-03-14 05:01:57','2024-03-15 03:01:57'),(25,'Botble\\Ecommerce\\Models\\Order',25,'INV-25','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,1034.00,0.00,0.00,0.00,'1','default',NULL,NULL,1034.00,NULL,25,'pending',NULL,'2024-03-11 11:01:57','2024-03-15 03:01:57'),(26,'Botble\\Ecommerce\\Models\\Order',26,'INV-26','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,752.00,0.00,0.00,0.00,NULL,'',NULL,NULL,752.00,NULL,26,'completed','2024-03-15 03:01:57','2024-03-10 23:01:57','2024-03-15 03:01:57'),(27,'Botble\\Ecommerce\\Models\\Order',27,'INV-27','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,6522.00,0.00,0.00,0.00,NULL,'',NULL,NULL,6522.00,NULL,27,'completed','2024-03-15 03:01:57','2024-03-10 03:01:57','2024-03-15 03:01:57'),(28,'Botble\\Ecommerce\\Models\\Order',28,'INV-28','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,1152.00,0.00,0.00,0.00,'1','default',NULL,NULL,1152.00,NULL,28,'completed','2024-03-15 03:01:57','2024-03-14 09:01:57','2024-03-15 03:01:57'),(29,'Botble\\Ecommerce\\Models\\Order',29,'INV-29','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,3276.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3276.00,NULL,29,'completed','2024-03-15 03:01:58','2024-03-10 15:01:58','2024-03-15 03:01:58'),(30,'Botble\\Ecommerce\\Models\\Order',30,'INV-30','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,2934.00,0.00,0.00,0.00,'1','default',NULL,NULL,2934.00,NULL,30,'completed','2024-03-15 03:01:58','2024-03-11 09:01:58','2024-03-15 03:01:58'),(31,'Botble\\Ecommerce\\Models\\Order',31,'INV-31','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,376.00,0.00,0.00,0.00,NULL,'',NULL,NULL,376.00,NULL,31,'completed','2024-03-15 03:01:58','2024-03-11 19:01:58','2024-03-15 03:01:58'),(32,'Botble\\Ecommerce\\Models\\Order',32,'INV-32','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,4401.00,0.00,0.00,0.00,'1','default',NULL,NULL,4401.00,NULL,32,'completed','2024-03-15 03:01:58','2024-03-10 11:01:58','2024-03-15 03:01:58'),(33,'Botble\\Ecommerce\\Models\\Order',33,'INV-33','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,2516.00,0.00,0.00,0.00,'1','default',NULL,NULL,2516.00,NULL,33,'pending',NULL,'2024-03-09 03:01:59','2024-03-15 03:01:59'),(34,'Botble\\Ecommerce\\Models\\Order',34,'INV-34','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,7413.00,0.00,0.00,0.00,NULL,'',NULL,NULL,7413.00,NULL,34,'completed','2024-03-15 03:01:59','2024-03-11 03:01:59','2024-03-15 03:01:59'),(35,'Botble\\Ecommerce\\Models\\Order',35,'INV-35','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,2190.00,0.00,0.00,0.00,'1','default',NULL,NULL,2190.00,NULL,35,'completed','2024-03-15 03:01:59','2024-03-09 21:01:59','2024-03-15 03:01:59'),(36,'Botble\\Ecommerce\\Models\\Order',36,'INV-36','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,6522.00,0.00,0.00,0.00,NULL,'',NULL,NULL,6522.00,NULL,36,'completed','2024-03-15 03:01:59','2024-03-13 23:01:59','2024-03-15 03:01:59'),(37,'Botble\\Ecommerce\\Models\\Order',37,'INV-37','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3144.00,0.00,0.00,0.00,'1','default',NULL,NULL,3144.00,NULL,37,'completed','2024-03-15 03:01:59','2024-03-12 19:01:59','2024-03-15 03:01:59'),(38,'Botble\\Ecommerce\\Models\\Order',38,'INV-38','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,478.00,0.00,0.00,0.00,NULL,'',NULL,NULL,478.00,NULL,38,'completed','2024-03-15 03:02:00','2024-03-13 03:02:00','2024-03-15 03:02:00'),(39,'Botble\\Ecommerce\\Models\\Order',39,'INV-39','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3392.00,0.00,0.00,0.00,'1','default',NULL,NULL,3392.00,NULL,39,'pending',NULL,'2024-03-13 15:02:00','2024-03-15 03:02:00'),(40,'Botble\\Ecommerce\\Models\\Order',40,'INV-40','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3774.00,0.00,0.00,0.00,'1','default',NULL,NULL,3774.00,NULL,40,'completed','2024-03-15 03:02:00','2024-03-13 11:02:00','2024-03-15 03:02:00'),(41,'Botble\\Ecommerce\\Models\\Order',41,'INV-41','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3144.00,0.00,0.00,0.00,'1','default',NULL,NULL,3144.00,NULL,41,'completed','2024-03-15 03:02:00','2024-03-13 21:02:00','2024-03-15 03:02:00'),(42,'Botble\\Ecommerce\\Models\\Order',42,'INV-42','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3882.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3882.00,NULL,42,'completed','2024-03-15 03:02:00','2024-03-14 03:02:00','2024-03-15 03:02:00'),(43,'Botble\\Ecommerce\\Models\\Order',43,'INV-43','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3144.00,0.00,0.00,0.00,'1','default',NULL,NULL,3144.00,NULL,43,'completed','2024-03-15 03:02:01','2024-03-11 19:02:01','2024-03-15 03:02:01'),(44,'Botble\\Ecommerce\\Models\\Order',44,'INV-44','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,347.00,0.00,0.00,0.00,'1','default',NULL,NULL,347.00,NULL,44,'pending',NULL,'2024-03-13 21:02:01','2024-03-15 03:02:01'),(45,'Botble\\Ecommerce\\Models\\Order',45,'INV-45','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,4348.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4348.00,NULL,45,'completed','2024-03-15 03:02:01','2024-03-14 21:02:01','2024-03-15 03:02:01'),(46,'Botble\\Ecommerce\\Models\\Order',46,'INV-46','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,892.00,0.00,0.00,0.00,'1','default',NULL,NULL,892.00,NULL,46,'completed','2024-03-15 03:02:01','2024-03-14 09:02:01','2024-03-15 03:02:01'),(47,'Botble\\Ecommerce\\Models\\Order',47,'INV-47','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,1258.00,0.00,0.00,0.00,'1','default',NULL,NULL,1258.00,NULL,47,'completed','2024-03-15 03:02:01','2024-03-13 15:02:01','2024-03-15 03:02:01'),(48,'Botble\\Ecommerce\\Models\\Order',48,'INV-48','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,430.00,0.00,0.00,0.00,'1','default',NULL,NULL,430.00,NULL,48,'completed','2024-03-15 03:02:02','2024-03-13 19:02:02','2024-03-15 03:02:02'),(49,'Botble\\Ecommerce\\Models\\Order',49,'INV-49','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,3498.00,0.00,0.00,0.00,'1','default',NULL,NULL,3498.00,NULL,49,'pending',NULL,'2024-03-14 23:02:02','2024-03-15 03:02:02'),(50,'Botble\\Ecommerce\\Models\\Order',50,'INV-50','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,4348.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4348.00,NULL,50,'completed','2024-03-15 03:02:02','2024-03-14 15:02:02','2024-03-15 03:02:02'),(51,'Botble\\Ecommerce\\Models\\Order',51,'INV-51','Miss Eileen Zulauf DDS','',NULL,'drunolfsdottir@example.com','+15757175376','76043 Marks Parkway, South Alexander, Washington, SA',NULL,796.00,0.00,0.00,0.00,'1','default',NULL,NULL,796.00,NULL,51,'completed','2024-03-15 03:02:02','2024-03-14 19:02:02','2024-03-15 03:02:02'),(52,'Botble\\Ecommerce\\Models\\Order',52,'INV-52','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3570.00,0.00,0.00,0.00,'1','default',NULL,NULL,3570.00,NULL,52,'pending',NULL,'2024-03-14 17:02:02','2024-03-15 03:02:02'),(53,'Botble\\Ecommerce\\Models\\Order',53,'INV-53','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,3986.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3986.00,NULL,53,'pending',NULL,'2024-03-14 07:02:03','2024-03-15 03:02:03'),(54,'Botble\\Ecommerce\\Models\\Order',54,'INV-54','Prof. John Stoltenberg DVM','',NULL,'nstehr@example.net','+18322573230','9600 Dorris Dale, Lake Brook, South Dakota, BN',NULL,398.00,0.00,0.00,0.00,'1','default',NULL,NULL,398.00,NULL,54,'pending',NULL,'2024-03-14 17:02:03','2024-03-15 03:02:03');
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',1,'96346-2867','shipping_address'),(2,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',2,'96346-2867','shipping_address'),(3,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',3,'55738','shipping_address'),(4,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',4,'55738','shipping_address'),(5,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',5,'55738','shipping_address'),(6,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',6,'96346-2867','shipping_address'),(7,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',7,'55738','shipping_address'),(8,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',8,'55738','shipping_address'),(9,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',9,'55738','shipping_address'),(10,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',10,'55738','shipping_address'),(11,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',11,'96346-2867','shipping_address'),(12,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',12,'96346-2867','shipping_address'),(13,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',13,'96346-2867','shipping_address'),(14,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',14,'96346-2867','shipping_address'),(15,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',15,'96346-2867','shipping_address'),(16,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',16,'55738','shipping_address'),(17,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',17,'55738','shipping_address'),(18,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',18,'55738','shipping_address'),(19,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',19,'55738','shipping_address'),(20,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',20,'55738','shipping_address'),(21,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',21,'55738','shipping_address'),(22,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',22,'55738','shipping_address'),(23,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',23,'96346-2867','shipping_address'),(24,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',24,'96346-2867','shipping_address'),(25,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',25,'96346-2867','shipping_address'),(26,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',26,'96346-2867','shipping_address'),(27,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',27,'96346-2867','shipping_address'),(28,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',28,'96346-2867','shipping_address'),(29,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',29,'96346-2867','shipping_address'),(30,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',30,'96346-2867','shipping_address'),(31,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',31,'55738','shipping_address'),(32,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',32,'55738','shipping_address'),(33,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',33,'55738','shipping_address'),(34,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',34,'55738','shipping_address'),(35,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',35,'55738','shipping_address'),(36,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',36,'55738','shipping_address'),(37,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',37,'55738','shipping_address'),(38,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',38,'55738','shipping_address'),(39,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',39,'55738','shipping_address'),(40,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',40,'55738','shipping_address'),(41,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',41,'55738','shipping_address'),(42,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',42,'55738','shipping_address'),(43,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',43,'55738','shipping_address'),(44,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',44,'96346-2867','shipping_address'),(45,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',45,'96346-2867','shipping_address'),(46,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',46,'96346-2867','shipping_address'),(47,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',47,'96346-2867','shipping_address'),(48,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',48,'96346-2867','shipping_address'),(49,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',49,'96346-2867','shipping_address'),(50,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',50,'96346-2867','shipping_address'),(51,'Miss Eileen Zulauf DDS','+15757175376','drunolfsdottir@example.com','SA','Washington','South Alexander','76043 Marks Parkway',51,'96346-2867','shipping_address'),(52,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',52,'55738','shipping_address'),(53,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',53,'55738','shipping_address'),(54,'Prof. John Stoltenberg DVM','+18322573230','nstehr@example.net','BN','South Dakota','Lake Brook','9600 Dorris Dale',54,'55738','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=235 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2024-03-11 19:01:50','2024-03-11 19:01:50'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2024-03-11 19:01:50','2024-03-11 19:01:50'),(3,'create_shipment','Created shipment for order',0,1,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50'),(4,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50'),(5,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2024-02-27 11:01:50','2024-02-27 11:01:50'),(6,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2024-02-27 11:01:50','2024-02-27 11:01:50'),(7,'confirm_payment','Payment was confirmed (amount $1,194.00) by %user_name%',0,2,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50'),(8,'create_shipment','Created shipment for order',0,2,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50'),(9,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50'),(10,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2024-03-13 13:01:50','2024-03-13 13:01:50'),(11,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2024-03-13 13:01:50','2024-03-13 13:01:50'),(12,'confirm_payment','Payment was confirmed (amount $1,541.00) by %user_name%',0,3,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50'),(13,'create_shipment','Created shipment for order',0,3,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50'),(14,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2024-03-08 19:01:50','2024-03-08 19:01:50'),(15,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2024-03-08 19:01:50','2024-03-08 19:01:50'),(16,'create_shipment','Created shipment for order',0,4,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(17,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2024-03-08 19:01:51','2024-03-08 19:01:51'),(18,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2024-03-08 19:01:51','2024-03-08 19:01:51'),(19,'confirm_payment','Payment was confirmed (amount $517.00) by %user_name%',0,5,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(20,'create_shipment','Created shipment for order',0,5,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(21,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,5,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(22,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2024-03-01 15:01:51','2024-03-01 15:01:51'),(23,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2024-03-01 15:01:51','2024-03-01 15:01:51'),(24,'create_shipment','Created shipment for order',0,6,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(25,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(26,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2024-03-05 05:01:51','2024-03-05 05:01:51'),(27,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2024-03-05 05:01:51','2024-03-05 05:01:51'),(28,'create_shipment','Created shipment for order',0,7,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(29,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,7,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(30,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2024-02-29 23:01:51','2024-02-29 23:01:51'),(31,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2024-02-29 23:01:51','2024-02-29 23:01:51'),(32,'confirm_payment','Payment was confirmed (amount $576.00) by %user_name%',0,8,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(33,'create_shipment','Created shipment for order',0,8,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(34,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2024-03-04 11:01:51','2024-03-04 11:01:51'),(35,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2024-03-04 11:01:51','2024-03-04 11:01:51'),(36,'confirm_payment','Payment was confirmed (amount $4,688.00) by %user_name%',0,9,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51'),(37,'create_shipment','Created shipment for order',0,9,NULL,'2024-03-15 03:01:52','2024-03-15 03:01:52'),(38,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,NULL,'2024-03-15 03:01:52','2024-03-15 03:01:52'),(39,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2024-03-07 03:01:52','2024-03-07 03:01:52'),(40,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2024-03-07 03:01:52','2024-03-07 03:01:52'),(41,'confirm_payment','Payment was confirmed (amount $4,898.00) by %user_name%',0,10,NULL,'2024-03-15 03:01:52','2024-03-15 03:01:52'),(42,'create_shipment','Created shipment for order',0,10,NULL,'2024-03-15 03:01:52','2024-03-15 03:01:52'),(43,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2024-03-06 09:01:52','2024-03-06 09:01:52'),(44,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2024-03-06 09:01:52','2024-03-06 09:01:52'),(45,'confirm_payment','Payment was confirmed (amount $4,348.00) by %user_name%',0,11,NULL,'2024-03-15 03:01:53','2024-03-15 03:01:53'),(46,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,11,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54'),(47,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2024-03-06 09:01:54','2024-03-06 09:01:54'),(48,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2024-03-06 09:01:54','2024-03-06 09:01:54'),(49,'create_shipment','Created shipment for order',0,12,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54'),(50,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,12,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54'),(51,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2024-03-03 11:01:54','2024-03-03 11:01:54'),(52,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2024-03-03 11:01:54','2024-03-03 11:01:54'),(53,'confirm_payment','Payment was confirmed (amount $3,491.00) by %user_name%',0,13,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54'),(54,'create_shipment','Created shipment for order',0,13,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54'),(55,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54'),(56,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2024-03-05 19:01:54','2024-03-05 19:01:54'),(57,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2024-03-05 19:01:54','2024-03-05 19:01:54'),(58,'confirm_payment','Payment was confirmed (amount $3,228.00) by %user_name%',0,14,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54'),(59,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,14,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(60,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2024-03-05 19:01:55','2024-03-05 19:01:55'),(61,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2024-03-05 19:01:55','2024-03-05 19:01:55'),(62,'confirm_payment','Payment was confirmed (amount $446.00) by %user_name%',0,15,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(63,'create_shipment','Created shipment for order',0,15,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(64,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2024-03-10 19:01:55','2024-03-10 19:01:55'),(65,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2024-03-10 19:01:55','2024-03-10 19:01:55'),(66,'confirm_payment','Payment was confirmed (amount $972.00) by %user_name%',0,16,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(67,'create_shipment','Created shipment for order',0,16,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(68,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2024-03-12 23:01:55','2024-03-12 23:01:55'),(69,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2024-03-12 23:01:55','2024-03-12 23:01:55'),(70,'create_shipment','Created shipment for order',0,17,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(71,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2024-03-14 01:01:55','2024-03-14 01:01:55'),(72,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2024-03-14 01:01:55','2024-03-14 01:01:55'),(73,'confirm_payment','Payment was confirmed (amount $892.00) by %user_name%',0,18,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(74,'create_shipment','Created shipment for order',0,18,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(75,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55'),(76,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2024-03-09 17:01:55','2024-03-09 17:01:55'),(77,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2024-03-09 17:01:55','2024-03-09 17:01:55'),(78,'create_shipment','Created shipment for order',0,19,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(79,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2024-03-05 03:01:56','2024-03-05 03:01:56'),(80,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2024-03-05 03:01:56','2024-03-05 03:01:56'),(81,'create_shipment','Created shipment for order',0,20,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(82,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,20,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(83,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2024-03-10 03:01:56','2024-03-10 03:01:56'),(84,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2024-03-10 03:01:56','2024-03-10 03:01:56'),(85,'confirm_payment','Payment was confirmed (amount $1,095.00) by %user_name%',0,21,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(86,'create_shipment','Created shipment for order',0,21,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(87,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,21,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(88,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2024-03-13 03:01:56','2024-03-13 03:01:56'),(89,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2024-03-13 03:01:56','2024-03-13 03:01:56'),(90,'confirm_payment','Payment was confirmed (amount $1,338.00) by %user_name%',0,22,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(91,'create_shipment','Created shipment for order',0,22,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(92,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2024-03-13 07:01:56','2024-03-13 07:01:56'),(93,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2024-03-13 07:01:56','2024-03-13 07:01:56'),(94,'confirm_payment','Payment was confirmed (amount $7,347.00) by %user_name%',0,23,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56'),(95,'create_shipment','Created shipment for order',0,23,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(96,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(97,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2024-03-14 05:01:57','2024-03-14 05:01:57'),(98,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2024-03-14 05:01:57','2024-03-14 05:01:57'),(99,'confirm_payment','Payment was confirmed (amount $2,471.00) by %user_name%',0,24,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(100,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,24,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(101,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2024-03-11 11:01:57','2024-03-11 11:01:57'),(102,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2024-03-11 11:01:57','2024-03-11 11:01:57'),(103,'create_shipment','Created shipment for order',0,25,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(104,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2024-03-10 23:01:57','2024-03-10 23:01:57'),(105,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2024-03-10 23:01:57','2024-03-10 23:01:57'),(106,'confirm_payment','Payment was confirmed (amount $752.00) by %user_name%',0,26,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(107,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,26,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(108,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2024-03-10 03:01:57','2024-03-10 03:01:57'),(109,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2024-03-10 03:01:57','2024-03-10 03:01:57'),(110,'confirm_payment','Payment was confirmed (amount $6,522.00) by %user_name%',0,27,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(111,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,27,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(112,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2024-03-14 09:01:57','2024-03-14 09:01:57'),(113,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2024-03-14 09:01:57','2024-03-14 09:01:57'),(114,'confirm_payment','Payment was confirmed (amount $1,152.00) by %user_name%',0,28,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57'),(115,'create_shipment','Created shipment for order',0,28,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(116,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2024-03-10 15:01:58','2024-03-10 15:01:58'),(117,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2024-03-10 15:01:58','2024-03-10 15:01:58'),(118,'confirm_payment','Payment was confirmed (amount $3,276.00) by %user_name%',0,29,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(119,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,29,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(120,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2024-03-11 09:01:58','2024-03-11 09:01:58'),(121,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2024-03-11 09:01:58','2024-03-11 09:01:58'),(122,'confirm_payment','Payment was confirmed (amount $2,934.00) by %user_name%',0,30,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(123,'create_shipment','Created shipment for order',0,30,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(124,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(125,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2024-03-11 19:01:58','2024-03-11 19:01:58'),(126,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2024-03-11 19:01:58','2024-03-11 19:01:58'),(127,'confirm_payment','Payment was confirmed (amount $376.00) by %user_name%',0,31,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(128,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,31,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(129,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2024-03-10 11:01:58','2024-03-10 11:01:58'),(130,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2024-03-10 11:01:58','2024-03-10 11:01:58'),(131,'confirm_payment','Payment was confirmed (amount $4,401.00) by %user_name%',0,32,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58'),(132,'create_shipment','Created shipment for order',0,32,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(133,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(134,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2024-03-09 03:01:59','2024-03-09 03:01:59'),(135,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2024-03-09 03:01:59','2024-03-09 03:01:59'),(136,'create_shipment','Created shipment for order',0,33,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(137,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2024-03-11 03:01:59','2024-03-11 03:01:59'),(138,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2024-03-11 03:01:59','2024-03-11 03:01:59'),(139,'confirm_payment','Payment was confirmed (amount $7,413.00) by %user_name%',0,34,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(140,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,34,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(141,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2024-03-09 21:01:59','2024-03-09 21:01:59'),(142,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2024-03-09 21:01:59','2024-03-09 21:01:59'),(143,'confirm_payment','Payment was confirmed (amount $2,190.00) by %user_name%',0,35,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(144,'create_shipment','Created shipment for order',0,35,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(145,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(146,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2024-03-13 23:01:59','2024-03-13 23:01:59'),(147,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2024-03-13 23:01:59','2024-03-13 23:01:59'),(148,'confirm_payment','Payment was confirmed (amount $6,522.00) by %user_name%',0,36,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(149,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,36,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(150,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2024-03-12 19:01:59','2024-03-12 19:01:59'),(151,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2024-03-12 19:01:59','2024-03-12 19:01:59'),(152,'confirm_payment','Payment was confirmed (amount $3,144.00) by %user_name%',0,37,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59'),(153,'create_shipment','Created shipment for order',0,37,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(154,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,37,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(155,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2024-03-13 03:02:00','2024-03-13 03:02:00'),(156,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2024-03-13 03:02:00','2024-03-13 03:02:00'),(157,'confirm_payment','Payment was confirmed (amount $478.00) by %user_name%',0,38,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(158,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,38,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(159,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2024-03-13 15:02:00','2024-03-13 15:02:00'),(160,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2024-03-13 15:02:00','2024-03-13 15:02:00'),(161,'create_shipment','Created shipment for order',0,39,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(162,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(163,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2024-03-13 11:02:00','2024-03-13 11:02:00'),(164,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2024-03-13 11:02:00','2024-03-13 11:02:00'),(165,'confirm_payment','Payment was confirmed (amount $3,774.00) by %user_name%',0,40,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(166,'create_shipment','Created shipment for order',0,40,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(167,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2024-03-13 21:02:00','2024-03-13 21:02:00'),(168,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2024-03-13 21:02:00','2024-03-13 21:02:00'),(169,'confirm_payment','Payment was confirmed (amount $3,144.00) by %user_name%',0,41,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(170,'create_shipment','Created shipment for order',0,41,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(171,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,41,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(172,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2024-03-14 03:02:00','2024-03-14 03:02:00'),(173,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2024-03-14 03:02:00','2024-03-14 03:02:00'),(174,'confirm_payment','Payment was confirmed (amount $3,882.00) by %user_name%',0,42,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00'),(175,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,42,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(176,'create_order_from_seeder','Order is created from the checkout page',NULL,43,NULL,'2024-03-11 19:02:01','2024-03-11 19:02:01'),(177,'confirm_order','Order was verified by %user_name%',0,43,NULL,'2024-03-11 19:02:01','2024-03-11 19:02:01'),(178,'confirm_payment','Payment was confirmed (amount $3,144.00) by %user_name%',0,43,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(179,'create_shipment','Created shipment for order',0,43,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(180,'create_order_from_seeder','Order is created from the checkout page',NULL,44,NULL,'2024-03-13 21:02:01','2024-03-13 21:02:01'),(181,'confirm_order','Order was verified by %user_name%',0,44,NULL,'2024-03-13 21:02:01','2024-03-13 21:02:01'),(182,'create_shipment','Created shipment for order',0,44,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(183,'create_order_from_seeder','Order is created from the checkout page',NULL,45,NULL,'2024-03-14 21:02:01','2024-03-14 21:02:01'),(184,'confirm_order','Order was verified by %user_name%',0,45,NULL,'2024-03-14 21:02:01','2024-03-14 21:02:01'),(185,'confirm_payment','Payment was confirmed (amount $4,348.00) by %user_name%',0,45,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(186,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,45,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(187,'create_order_from_seeder','Order is created from the checkout page',NULL,46,NULL,'2024-03-14 09:02:01','2024-03-14 09:02:01'),(188,'confirm_order','Order was verified by %user_name%',0,46,NULL,'2024-03-14 09:02:01','2024-03-14 09:02:01'),(189,'confirm_payment','Payment was confirmed (amount $892.00) by %user_name%',0,46,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(190,'create_shipment','Created shipment for order',0,46,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(191,'create_order_from_seeder','Order is created from the checkout page',NULL,47,NULL,'2024-03-13 15:02:01','2024-03-13 15:02:01'),(192,'confirm_order','Order was verified by %user_name%',0,47,NULL,'2024-03-13 15:02:01','2024-03-13 15:02:01'),(193,'confirm_payment','Payment was confirmed (amount $1,258.00) by %user_name%',0,47,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01'),(194,'create_shipment','Created shipment for order',0,47,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(195,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,47,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(196,'create_order_from_seeder','Order is created from the checkout page',NULL,48,NULL,'2024-03-13 19:02:02','2024-03-13 19:02:02'),(197,'confirm_order','Order was verified by %user_name%',0,48,NULL,'2024-03-13 19:02:02','2024-03-13 19:02:02'),(198,'confirm_payment','Payment was confirmed (amount $430.00) by %user_name%',0,48,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(199,'create_shipment','Created shipment for order',0,48,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(200,'create_order_from_seeder','Order is created from the checkout page',NULL,49,NULL,'2024-03-14 23:02:02','2024-03-14 23:02:02'),(201,'confirm_order','Order was verified by %user_name%',0,49,NULL,'2024-03-14 23:02:02','2024-03-14 23:02:02'),(202,'create_shipment','Created shipment for order',0,49,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(203,'create_order_from_seeder','Order is created from the checkout page',NULL,50,NULL,'2024-03-14 15:02:02','2024-03-14 15:02:02'),(204,'confirm_order','Order was verified by %user_name%',0,50,NULL,'2024-03-14 15:02:02','2024-03-14 15:02:02'),(205,'confirm_payment','Payment was confirmed (amount $4,348.00) by %user_name%',0,50,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(206,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,50,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(207,'create_order_from_seeder','Order is created from the checkout page',NULL,51,NULL,'2024-03-14 19:02:02','2024-03-14 19:02:02'),(208,'confirm_order','Order was verified by %user_name%',0,51,NULL,'2024-03-14 19:02:02','2024-03-14 19:02:02'),(209,'confirm_payment','Payment was confirmed (amount $796.00) by %user_name%',0,51,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(210,'create_shipment','Created shipment for order',0,51,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(211,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,51,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02'),(212,'create_order_from_seeder','Order is created from the checkout page',NULL,52,NULL,'2024-03-14 17:02:02','2024-03-14 17:02:02'),(213,'confirm_order','Order was verified by %user_name%',0,52,NULL,'2024-03-14 17:02:02','2024-03-14 17:02:02'),(214,'create_shipment','Created shipment for order',0,52,NULL,'2024-03-15 03:02:03','2024-03-15 03:02:03'),(215,'create_order_from_seeder','Order is created from the checkout page',NULL,53,NULL,'2024-03-14 07:02:03','2024-03-14 07:02:03'),(216,'confirm_order','Order was verified by %user_name%',0,53,NULL,'2024-03-14 07:02:03','2024-03-14 07:02:03'),(217,'create_order_from_seeder','Order is created from the checkout page',NULL,54,NULL,'2024-03-14 17:02:03','2024-03-14 17:02:03'),(218,'confirm_order','Order was verified by %user_name%',0,54,NULL,'2024-03-14 17:02:03','2024-03-14 17:02:03'),(219,'create_shipment','Created shipment for order',0,54,NULL,'2024-03-15 03:02:03','2024-03-15 03:02:03'),(220,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,54,NULL,'2024-03-15 03:02:03','2024-03-15 03:02:03'),(221,'update_status','Order confirmed by %user_name%',0,2,NULL,'2024-03-15 03:02:03','2024-03-15 03:02:03'),(222,'update_status','Order confirmed by %user_name%',0,5,NULL,'2024-03-15 03:02:04','2024-03-15 03:02:04'),(223,'update_status','Order confirmed by %user_name%',0,9,NULL,'2024-03-15 03:02:04','2024-03-15 03:02:04'),(224,'update_status','Order confirmed by %user_name%',0,13,NULL,'2024-03-15 03:02:05','2024-03-15 03:02:05'),(225,'update_status','Order confirmed by %user_name%',0,18,NULL,'2024-03-15 03:02:05','2024-03-15 03:02:05'),(226,'update_status','Order confirmed by %user_name%',0,21,NULL,'2024-03-15 03:02:06','2024-03-15 03:02:06'),(227,'update_status','Order confirmed by %user_name%',0,23,NULL,'2024-03-15 03:02:06','2024-03-15 03:02:06'),(228,'update_status','Order confirmed by %user_name%',0,30,NULL,'2024-03-15 03:02:07','2024-03-15 03:02:07'),(229,'update_status','Order confirmed by %user_name%',0,32,NULL,'2024-03-15 03:02:07','2024-03-15 03:02:07'),(230,'update_status','Order confirmed by %user_name%',0,35,NULL,'2024-03-15 03:02:08','2024-03-15 03:02:08'),(231,'update_status','Order confirmed by %user_name%',0,37,NULL,'2024-03-15 03:02:09','2024-03-15 03:02:09'),(232,'update_status','Order confirmed by %user_name%',0,41,NULL,'2024-03-15 03:02:09','2024-03-15 03:02:09'),(233,'update_status','Order confirmed by %user_name%',0,47,NULL,'2024-03-15 03:02:10','2024-03-15 03:02:10'),(234,'update_status','Order confirmed by %user_name%',0,51,NULL,'2024-03-15 03:02:10','2024-03-15 03:02:10');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,2,324.00,0.00,'{\"sku\":\"YN-124-A0-A1\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,54,'Classic Aviator Sunglasses','fashion/products/product-4.png',1116.00,0,'2024-03-15 03:01:50','2024-03-15 03:01:50','physical',0,NULL),(2,2,3,398.00,0.00,'{\"sku\":\"YM-108-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,135,'Buckle Detail Ankle Booties','fashion/products/product-3.png',1962.00,0,'2024-03-15 03:01:50','2024-03-15 03:01:50','physical',0,NULL),(3,3,1,1541.00,0.00,'{\"sku\":\"7J-122-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,113,'Ruffled Wrap Dress','fashion/products/product-3.png',554.00,0,'2024-03-15 03:01:50','2024-03-15 03:01:50','physical',0,NULL),(4,4,2,1258.00,0.00,'{\"sku\":\"MT-110-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}',NULL,130,'Velour Tracksuit Set','fashion/products/product-6.png',1206.00,0,'2024-03-15 03:01:50','2024-03-15 03:01:50','physical',0,NULL),(5,5,1,517.00,0.00,'{\"sku\":\"XP-105-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}',NULL,145,'Retro High-Top Sneakers','fashion/products/product-6.png',863.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','physical',0,NULL),(6,6,1,2344.00,0.00,'{\"sku\":\"TI-119-A0\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,65,'High-Waisted Wide Leg Trousers','fashion/products/product-2.png',620.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','physical',0,NULL),(7,6,3,1095.00,0.00,'{\"sku\":\"LW-179-A0-A3\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,100,'Cropped Cable Knit Sweater','fashion/products/product-5.png',1752.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','physical',0,NULL),(8,7,2,324.00,0.00,'{\"sku\":\"YN-124-A0-A2\",\"attributes\":\"(Color: Black, Size: XXL)\"}',NULL,55,'Classic Aviator Sunglasses','fashion/products/product-1.png',1116.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','physical',0,NULL),(9,7,3,1309.00,0.00,'{\"sku\":\"Y8-136-A0-A1\",\"attributes\":\"(Color: Blue, Size: XL)\"}',NULL,62,'Silk Scarf with Geometric Print (Digital)','fashion/products/product-6.png',1743.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','digital',8,NULL),(10,8,1,576.00,0.00,'{\"sku\":\"GP-110-A0-A1\",\"attributes\":\"(Color: Green, Size: M)\"}',NULL,70,'Statement Chunky Necklace','fashion/products/product-2.png',709.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','physical',0,NULL),(11,9,2,2344.00,0.00,'{\"sku\":\"TI-119-A0\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,65,'High-Waisted Wide Leg Trousers','fashion/products/product-2.png',1240.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','physical',0,NULL),(12,10,2,2449.00,0.00,'{\"sku\":\"K9-161-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,138,'Embroidered Bomber Jacket','fashion/products/product-6.png',1260.00,0,'2024-03-15 03:01:52','2024-03-15 03:01:52','physical',0,NULL),(13,11,2,2174.00,0.00,'{\"sku\":\"3I-116-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,104,'Athleisure Jogger Pants (Digital)','fashion/products/product-3.png',1736.00,0,'2024-03-15 03:01:52','2024-03-15 03:01:52','digital',1,NULL),(14,12,2,398.00,0.00,'{\"sku\":\"YM-108-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,135,'Buckle Detail Ankle Booties','fashion/products/product-3.png',1308.00,0,'2024-03-15 03:01:54','2024-03-15 03:01:54','physical',0,NULL),(15,13,1,347.00,0.00,'{\"sku\":\"4Z-114-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}',NULL,56,'Tailored Wool Blazer','fashion/products/product-2.png',887.00,0,'2024-03-15 03:01:54','2024-03-15 03:01:54','physical',0,NULL),(16,13,3,1048.00,0.00,'{\"sku\":\"N7-144-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,149,'Metallic Pleated Maxi Skirt','fashion/products/product-2.png',1767.00,0,'2024-03-15 03:01:54','2024-03-15 03:01:54','physical',0,NULL),(17,14,3,1076.00,0.00,'{\"sku\":\"3W-199-A0-A1\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,90,'Structured Satchel Bag (Digital)','fashion/products/product-7.png',1998.00,0,'2024-03-15 03:01:54','2024-03-15 03:01:54','digital',10,NULL),(18,15,1,446.00,0.00,'{\"sku\":\"RO-115-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,118,'Wide Brim Floppy Hat','fashion/products/product-8.png',835.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','physical',0,NULL),(19,16,3,324.00,0.00,'{\"sku\":\"YN-124-A0\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,53,'Classic Aviator Sunglasses','fashion/products/product-8.png',1674.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','physical',0,NULL),(20,17,2,2344.00,0.00,'{\"sku\":\"TI-119-A0\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,65,'High-Waisted Wide Leg Trousers','fashion/products/product-2.png',1240.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','physical',0,NULL),(21,18,2,446.00,0.00,'{\"sku\":\"RO-115-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,118,'Wide Brim Floppy Hat','fashion/products/product-8.png',1670.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','physical',0,NULL),(22,19,3,2449.00,0.00,'{\"sku\":\"K9-161-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,138,'Embroidered Bomber Jacket','fashion/products/product-6.png',1890.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','physical',0,NULL),(23,20,2,2095.00,0.00,'{\"sku\":\"QA-126-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,68,'Embroidered Boho Blouse','fashion/products/product-8.png',1594.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','physical',0,NULL),(24,21,1,1095.00,0.00,'{\"sku\":\"LW-179-A0-A3\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,100,'Cropped Cable Knit Sweater','fashion/products/product-5.png',584.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','physical',0,NULL),(25,22,3,446.00,0.00,'{\"sku\":\"RO-115-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,118,'Wide Brim Floppy Hat','fashion/products/product-8.png',2505.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','physical',0,NULL),(26,23,3,2449.00,0.00,'{\"sku\":\"K9-161-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,138,'Embroidered Bomber Jacket','fashion/products/product-6.png',1890.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','physical',0,NULL),(27,24,1,2471.00,0.00,'{\"sku\":\"LW-185-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,143,'Chunky Knit Infinity Scarf (Digital)','fashion/products/product-3.png',828.00,0,'2024-03-15 03:01:57','2024-03-15 03:01:57','digital',4,NULL),(28,25,2,517.00,0.00,'{\"sku\":\"XP-105-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,144,'Retro High-Top Sneakers','fashion/products/product-7.png',1726.00,0,'2024-03-15 03:01:57','2024-03-15 03:01:57','physical',0,NULL),(29,26,2,376.00,0.00,'{\"sku\":\"WU-134-A0-A1\",\"attributes\":\"(Color: Green, Size: XL)\"}',NULL,73,'Chic Fedora Hat (Digital)','fashion/products/product-2.png',1572.00,0,'2024-03-15 03:01:57','2024-03-15 03:01:57','digital',6,NULL),(30,27,3,2174.00,0.00,'{\"sku\":\"3I-116-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,104,'Athleisure Jogger Pants (Digital)','fashion/products/product-3.png',2604.00,0,'2024-03-15 03:01:57','2024-03-15 03:01:57','digital',8,NULL),(31,28,2,576.00,0.00,'{\"sku\":\"GP-110-A0-A2\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,71,'Statement Chunky Necklace','fashion/products/product-3.png',1418.00,0,'2024-03-15 03:01:57','2024-03-15 03:01:57','physical',0,NULL),(32,29,2,1638.00,0.00,'{\"sku\":\"QA-196-A0-A1\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,81,'Distressed Skinny Jeans (Digital)','fashion/products/product-7.png',1148.00,0,'2024-03-15 03:01:58','2024-03-15 03:01:58','digital',10,NULL),(33,30,2,1467.00,0.00,'{\"sku\":\"R7-154-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,107,'Retro Cat-Eye Sunglasses','fashion/products/product-5.png',1692.00,0,'2024-03-15 03:01:58','2024-03-15 03:01:58','physical',0,NULL),(34,31,1,376.00,0.00,'{\"sku\":\"WU-134-A0\",\"attributes\":\"(Color: Black, Size: XXL)\"}',NULL,72,'Chic Fedora Hat (Digital)','fashion/products/product-8.png',786.00,0,'2024-03-15 03:01:58','2024-03-15 03:01:58','digital',8,NULL),(35,32,3,1467.00,0.00,'{\"sku\":\"R7-154-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,106,'Retro Cat-Eye Sunglasses','fashion/products/product-3.png',2538.00,0,'2024-03-15 03:01:58','2024-03-15 03:01:58','physical',0,NULL),(36,33,2,1258.00,0.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,132,'Velour Tracksuit Set','fashion/products/product-5.png',1206.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','physical',0,NULL),(37,34,3,2471.00,0.00,'{\"sku\":\"LW-185-A0-A1\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,143,'Chunky Knit Infinity Scarf (Digital)','fashion/products/product-3.png',2484.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','digital',2,NULL),(38,35,2,1095.00,0.00,'{\"sku\":\"LW-179-A0-A2\",\"attributes\":\"(Color: Blue, Size: XXL)\"}',NULL,99,'Cropped Cable Knit Sweater','fashion/products/product-2.png',1168.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','physical',0,NULL),(39,36,3,2174.00,0.00,'{\"sku\":\"3I-116-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,104,'Athleisure Jogger Pants (Digital)','fashion/products/product-3.png',2604.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','digital',10,NULL),(40,37,3,1048.00,0.00,'{\"sku\":\"N7-144-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,150,'Metallic Pleated Maxi Skirt','fashion/products/product-5.png',1767.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','physical',0,NULL),(41,38,1,478.00,0.00,'{\"sku\":\"W2-104-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,110,'Boho Fringed Kimono (Digital)','fashion/products/product-6.png',713.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','digital',8,NULL),(42,39,1,2134.00,0.00,'{\"sku\":\"HD-143-A0-A2\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}',NULL,122,'Denim Overall Jumpsuit (Digital)','fashion/products/product-3.png',828.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','digital',10,NULL),(43,39,1,1258.00,0.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,132,'Velour Tracksuit Set','fashion/products/product-5.png',603.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','physical',0,NULL),(44,40,3,1258.00,0.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,132,'Velour Tracksuit Set','fashion/products/product-5.png',1809.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','physical',0,NULL),(45,41,3,1048.00,0.00,'{\"sku\":\"N7-144-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,150,'Metallic Pleated Maxi Skirt','fashion/products/product-5.png',1767.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','physical',0,NULL),(46,42,2,1941.00,0.00,'{\"sku\":\"SL-181-A0-A3\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,52,'Knit Turtleneck Sweater (Digital)','fashion/products/product-4.png',1284.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','digital',2,NULL),(47,43,3,1048.00,0.00,'{\"sku\":\"N7-144-A0\",\"attributes\":\"(Weight: 4KG, Boxes: 4 Boxes)\"}',NULL,149,'Metallic Pleated Maxi Skirt','fashion/products/product-2.png',1767.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','physical',0,NULL),(48,44,1,347.00,0.00,'{\"sku\":\"4Z-114-A0-A1\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,57,'Tailored Wool Blazer','fashion/products/product-1.png',887.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','physical',0,NULL),(49,45,2,2174.00,0.00,'{\"sku\":\"3I-116-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,101,'Athleisure Jogger Pants (Digital)','fashion/products/product-4.png',1736.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','digital',8,NULL),(50,46,2,446.00,0.00,'{\"sku\":\"RO-115-A0-A3\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,119,'Wide Brim Floppy Hat','fashion/products/product-4.png',1670.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','physical',0,NULL),(51,47,1,1258.00,0.00,'{\"sku\":\"MT-110-A0-A2\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,132,'Velour Tracksuit Set','fashion/products/product-5.png',603.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','physical',0,NULL),(52,48,1,430.00,0.00,'{\"sku\":\"SG-132-A0\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,74,'Strappy Block Heel Sandals','fashion/products/product-4.png',582.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','physical',0,NULL),(53,49,2,1749.00,0.00,'{\"sku\":\"WA-178-A0-A1\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,93,'Off-Shoulder Ruffle Top','fashion/products/product-1.png',1498.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','physical',0,NULL),(54,50,2,2174.00,0.00,'{\"sku\":\"3I-116-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,102,'Athleisure Jogger Pants (Digital)','fashion/products/product-7.png',1736.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','digital',9,NULL),(55,51,2,398.00,0.00,'{\"sku\":\"YM-108-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}',NULL,136,'Buckle Detail Ankle Booties','fashion/products/product-1.png',1308.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','physical',0,NULL),(56,52,3,1190.00,0.00,'{\"sku\":\"ZN-197-A0-A2\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,86,'Cotton Striped T-Shirt Dress','fashion/products/product-5.png',2034.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','physical',0,NULL),(57,53,2,1993.00,0.00,'{\"sku\":\"TN-107-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,134,'Geometric Patterned Cardigan (Digital)','fashion/products/product-2.png',1634.00,0,'2024-03-15 03:02:03','2024-03-15 03:02:03','digital',2,NULL),(58,54,1,398.00,0.00,'{\"sku\":\"YM-108-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,135,'Buckle Detail Ankle Booties','fashion/products/product-3.png',654.00,0,'2024-03-15 03:02:03','2024-03-15 03:02:03','physical',0,NULL);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `proof_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',10,'1','default','completed',648.00,0.00,0.00,NULL,NULL,0.00,648.00,1,NULL,1,'2024-03-15 03:01:50','jrx2R8XKNQEhppncOgTl8D4vip76n',1,'2024-03-11 19:01:50','2024-03-15 03:01:50',1,NULL),(2,'#10000002',10,'1','default','completed',1194.00,0.00,0.00,NULL,NULL,0.00,1194.00,1,NULL,1,'2024-03-15 03:02:03','TlrSQNblUtQEVaDF60juWsdcLm2du',2,'2024-02-27 11:01:50','2024-03-15 03:02:03',8,NULL),(3,'#10000003',9,'1','default','pending',1541.00,0.00,0.00,NULL,NULL,0.00,1541.00,1,NULL,1,NULL,'6tJ2K3OBhoCNJdiW2CVbYHkrrCcLb',3,'2024-03-13 13:01:50','2024-03-15 03:01:50',7,NULL),(4,'#10000004',9,'1','default','pending',2516.00,0.00,0.00,NULL,NULL,0.00,2516.00,1,NULL,1,NULL,'6IuNo6UZagZoeETrkT7nIPlDPHcqh',4,'2024-03-08 19:01:50','2024-03-15 03:01:50',2,NULL),(5,'#10000005',9,'1','default','completed',517.00,0.00,0.00,NULL,NULL,0.00,517.00,1,NULL,1,'2024-03-15 03:02:04','eaHEE9PhV5kkpiKICOOn2zPWGdU6t',5,'2024-03-08 19:01:51','2024-03-15 03:02:04',3,NULL),(6,'#10000006',10,'1','default','completed',5629.00,0.00,0.00,NULL,NULL,0.00,5629.00,1,NULL,1,'2024-03-15 03:01:51','hopBBvDxLsfOvq6i3cRi2KHcjE2gp',6,'2024-03-01 15:01:51','2024-03-15 03:01:51',2,NULL),(7,'#10000007',9,'1','default','completed',4575.00,0.00,0.00,NULL,NULL,0.00,4575.00,1,NULL,1,'2024-03-15 03:01:51','CJjjp1FL4bQILwZYFGSE7VY6wTK3T',7,'2024-03-05 05:01:51','2024-03-15 03:01:51',1,NULL),(8,'#10000008',9,'1','default','pending',576.00,0.00,0.00,NULL,NULL,0.00,576.00,1,NULL,1,NULL,'PJknmHr4fIzfqQHO8NekpeljKX1T2',8,'2024-02-29 23:01:51','2024-03-15 03:01:51',4,NULL),(9,'#10000009',9,'1','default','completed',4688.00,0.00,0.00,NULL,NULL,0.00,4688.00,1,NULL,1,'2024-03-15 03:02:04','NViETLA8EIIngEyba5xfkFwP9bAay',9,'2024-03-04 11:01:51','2024-03-15 03:02:04',2,NULL),(10,'#10000010',9,'1','default','pending',4898.00,0.00,0.00,NULL,NULL,0.00,4898.00,1,NULL,1,NULL,'RjKkttqQxXv5cPNzpCIvR9XyWp7ch',10,'2024-03-07 03:01:52','2024-03-15 03:01:52',5,NULL),(11,'#10000011',10,NULL,'','completed',4348.00,0.00,0.00,NULL,NULL,0.00,4348.00,1,NULL,1,'2024-03-15 03:01:54','yW802go163hej5ducNmXSTEQWlnKr',11,'2024-03-06 09:01:52','2024-03-15 03:01:54',5,NULL),(12,'#10000012',10,'1','default','completed',796.00,0.00,0.00,NULL,NULL,0.00,796.00,1,NULL,1,'2024-03-15 03:01:54','7AnHvldF5rYktaHYSOEbaDBzXjZbu',12,'2024-03-06 09:01:54','2024-03-15 03:01:54',8,NULL),(13,'#10000013',10,'1','default','completed',3491.00,0.00,0.00,NULL,NULL,0.00,3491.00,1,NULL,1,'2024-03-15 03:02:05','rHtQiuc1QWNYazmrykuV8dVkKl8Xp',13,'2024-03-03 11:01:54','2024-03-15 03:02:05',6,NULL),(14,'#10000014',10,NULL,'','completed',3228.00,0.00,0.00,NULL,NULL,0.00,3228.00,1,NULL,1,'2024-03-15 03:01:55','dd06ExlifpnfALusJMGMCsXhmuezY',14,'2024-03-05 19:01:54','2024-03-15 03:01:55',2,NULL),(15,'#10000015',10,'1','default','pending',446.00,0.00,0.00,NULL,NULL,0.00,446.00,1,NULL,1,NULL,'bVayR66Jpuz2I3OBzplKWrwQXwebQ',15,'2024-03-05 19:01:55','2024-03-15 03:01:55',7,NULL),(16,'#10000016',9,'1','default','pending',972.00,0.00,0.00,NULL,NULL,0.00,972.00,1,NULL,1,NULL,'kfufbstytcYXLltTlSgmdRjl6hXAx',16,'2024-03-10 19:01:55','2024-03-15 03:01:55',1,NULL),(17,'#10000017',9,'1','default','pending',4688.00,0.00,0.00,NULL,NULL,0.00,4688.00,1,NULL,1,NULL,'9BTBlQid1fr3WcdakvcbhZ5QPTwQZ',17,'2024-03-12 23:01:55','2024-03-15 03:01:55',2,NULL),(18,'#10000018',9,'1','default','completed',892.00,0.00,0.00,NULL,NULL,0.00,892.00,1,NULL,1,'2024-03-15 03:02:05','vdC1vga3dg5InYGMOyQa57HMVF89h',18,'2024-03-14 01:01:55','2024-03-15 03:02:05',7,NULL),(19,'#10000019',9,'1','default','pending',7347.00,0.00,0.00,NULL,NULL,0.00,7347.00,1,NULL,1,NULL,'Z8z82f5Kgo5i7O1HfYf4413CoX4eX',19,'2024-03-09 17:01:55','2024-03-15 03:01:56',5,NULL),(20,'#10000020',9,'1','default','completed',4190.00,0.00,0.00,NULL,NULL,0.00,4190.00,1,NULL,1,'2024-03-15 03:01:56','daqO1OC03aE00ZXaen4TYg10G7Ors',20,'2024-03-05 03:01:56','2024-03-15 03:01:56',5,NULL),(21,'#10000021',9,'1','default','completed',1095.00,0.00,0.00,NULL,NULL,0.00,1095.00,1,NULL,1,'2024-03-15 03:02:06','siz5nzN5Z08EOGJrVoyOeXgh3EvDk',21,'2024-03-10 03:01:56','2024-03-15 03:02:06',2,NULL),(22,'#10000022',9,'1','default','pending',1338.00,0.00,0.00,NULL,NULL,0.00,1338.00,1,NULL,1,NULL,'bvRSC3D1pvzwPzYodkE52QY36wOcw',22,'2024-03-13 03:01:56','2024-03-15 03:01:56',7,NULL),(23,'#10000023',10,'1','default','completed',7347.00,0.00,0.00,NULL,NULL,0.00,7347.00,1,NULL,1,'2024-03-15 03:02:06','67Rb5Br1RjSrHYeIun9M9a3pFNy1u',23,'2024-03-13 07:01:56','2024-03-15 03:02:06',5,NULL),(24,'#10000024',10,NULL,'','completed',2471.00,0.00,0.00,NULL,NULL,0.00,2471.00,1,NULL,1,'2024-03-15 03:01:57','e7JnWiTogSiSOm1LKK0Q1eniNVjd7',24,'2024-03-14 05:01:57','2024-03-15 03:01:57',4,NULL),(25,'#10000025',10,'1','default','pending',1034.00,0.00,0.00,NULL,NULL,0.00,1034.00,1,NULL,1,NULL,'gOApE2bUoqH2Y9vuryKWLJ7xtxvzG',25,'2024-03-11 11:01:57','2024-03-15 03:01:57',3,NULL),(26,'#10000026',10,NULL,'','completed',752.00,0.00,0.00,NULL,NULL,0.00,752.00,1,NULL,1,'2024-03-15 03:01:57','Y26lYRkwdBz1fqE5PB2Wpo3lx53C3',26,'2024-03-10 23:01:57','2024-03-15 03:01:57',7,NULL),(27,'#10000027',10,NULL,'','completed',6522.00,0.00,0.00,NULL,NULL,0.00,6522.00,1,NULL,1,'2024-03-15 03:01:57','tw70mAXdK7TdX6zFE7s8QfzgKYnQt',27,'2024-03-10 03:01:57','2024-03-15 03:01:57',5,NULL),(28,'#10000028',10,'1','default','pending',1152.00,0.00,0.00,NULL,NULL,0.00,1152.00,1,NULL,1,NULL,'6sMIOVzcDGEvI1ASkpQfMIlglF8R1',28,'2024-03-14 09:01:57','2024-03-15 03:01:57',4,NULL),(29,'#10000029',10,NULL,'','completed',3276.00,0.00,0.00,NULL,NULL,0.00,3276.00,1,NULL,1,'2024-03-15 03:01:58','lS9cpC6XKILqsiwH7pHNQ3Cc9VoM9',29,'2024-03-10 15:01:58','2024-03-15 03:01:58',5,NULL),(30,'#10000030',10,'1','default','completed',2934.00,0.00,0.00,NULL,NULL,0.00,2934.00,1,NULL,1,'2024-03-15 03:02:07','CGi0yJ7OcqKyWkK1xW8mfamvuKZ6Z',30,'2024-03-11 09:01:58','2024-03-15 03:02:07',8,NULL),(31,'#10000031',9,NULL,'','completed',376.00,0.00,0.00,NULL,NULL,0.00,376.00,1,NULL,1,'2024-03-15 03:01:58','kWwabYcwKsHRSNnzRgL1g7cuTAAsR',31,'2024-03-11 19:01:58','2024-03-15 03:01:58',7,NULL),(32,'#10000032',9,'1','default','completed',4401.00,0.00,0.00,NULL,NULL,0.00,4401.00,1,NULL,1,'2024-03-15 03:02:07','FQQyVN33YZ3CeW0XBeax1ITJY42VP',32,'2024-03-10 11:01:58','2024-03-15 03:02:07',8,NULL),(33,'#10000033',9,'1','default','pending',2516.00,0.00,0.00,NULL,NULL,0.00,2516.00,1,NULL,1,NULL,'79xfWtAQPwaB1Ns8D0TzX1cD15l2V',33,'2024-03-09 03:01:59','2024-03-15 03:01:59',2,NULL),(34,'#10000034',9,NULL,'','completed',7413.00,0.00,0.00,NULL,NULL,0.00,7413.00,1,NULL,1,'2024-03-15 03:01:59','JyFaltMqrIKpNHiPM0c8bShJ3n3Lf',34,'2024-03-11 03:01:59','2024-03-15 03:01:59',4,NULL),(35,'#10000035',9,'1','default','completed',2190.00,0.00,0.00,NULL,NULL,0.00,2190.00,1,NULL,1,'2024-03-15 03:02:08','Z4Qryjmi2bAn8xXRfBptFFFdVBUip',35,'2024-03-09 21:01:59','2024-03-15 03:02:08',2,NULL),(36,'#10000036',9,NULL,'','completed',6522.00,0.00,0.00,NULL,NULL,0.00,6522.00,1,NULL,1,'2024-03-15 03:01:59','9beFeaNJDOsoACtWbu6WugDH4J86m',36,'2024-03-13 23:01:59','2024-03-15 03:01:59',5,NULL),(37,'#10000037',9,'1','default','completed',3144.00,0.00,0.00,NULL,NULL,0.00,3144.00,1,NULL,1,'2024-03-15 03:02:09','BWYRgCqQGYIuZTmDt6l2ga1AY0ooX',37,'2024-03-12 19:01:59','2024-03-15 03:02:09',6,NULL),(38,'#10000038',9,NULL,'','completed',478.00,0.00,0.00,NULL,NULL,0.00,478.00,1,NULL,1,'2024-03-15 03:02:00','zp5WASlZrjZLCVqtHYKlWOit3dABS',38,'2024-03-13 03:02:00','2024-03-15 03:02:00',4,NULL),(39,'#10000039',9,'1','default','completed',3392.00,0.00,0.00,NULL,NULL,0.00,3392.00,1,NULL,1,'2024-03-15 03:02:00','QL7HorAI2CdQoFaOkOgG9LpkUnTnp',39,'2024-03-13 15:02:00','2024-03-15 03:02:00',2,NULL),(40,'#10000040',9,'1','default','pending',3774.00,0.00,0.00,NULL,NULL,0.00,3774.00,1,NULL,1,NULL,'zhSKr1hulFp5VkiYn2X59CxDeK8dd',40,'2024-03-13 11:02:00','2024-03-15 03:02:00',2,NULL),(41,'#10000041',9,'1','default','completed',3144.00,0.00,0.00,NULL,NULL,0.00,3144.00,1,NULL,1,'2024-03-15 03:02:09','iVsH8kehzj3RWpw8Pg8m0R5IdmKIh',41,'2024-03-13 21:02:00','2024-03-15 03:02:09',6,NULL),(42,'#10000042',9,NULL,'','completed',3882.00,0.00,0.00,NULL,NULL,0.00,3882.00,1,NULL,1,'2024-03-15 03:02:01','22kHe1x8vFOKHM8WXDkkOQONa6UjF',42,'2024-03-14 03:02:00','2024-03-15 03:02:01',7,NULL),(43,'#10000043',9,'1','default','pending',3144.00,0.00,0.00,NULL,NULL,0.00,3144.00,1,NULL,1,NULL,'23ExmrFGETEecqsqwTETNUoYBf4mt',43,'2024-03-11 19:02:01','2024-03-15 03:02:01',6,NULL),(44,'#10000044',10,'1','default','pending',347.00,0.00,0.00,NULL,NULL,0.00,347.00,1,NULL,1,NULL,'Ba0EmVBcZIV38GITAFeodFZgY8Abd',44,'2024-03-13 21:02:01','2024-03-15 03:02:01',6,NULL),(45,'#10000045',10,NULL,'','completed',4348.00,0.00,0.00,NULL,NULL,0.00,4348.00,1,NULL,1,'2024-03-15 03:02:01','V2TSs02webB2CVTYY5QuD3qwQytUJ',45,'2024-03-14 21:02:01','2024-03-15 03:02:01',5,NULL),(46,'#10000046',10,'1','default','pending',892.00,0.00,0.00,NULL,NULL,0.00,892.00,1,NULL,1,NULL,'wVMnNhjR0yINqzrasPxUeHFvkPUlL',46,'2024-03-14 09:02:01','2024-03-15 03:02:01',7,NULL),(47,'#10000047',10,'1','default','completed',1258.00,0.00,0.00,NULL,NULL,0.00,1258.00,1,NULL,1,'2024-03-15 03:02:10','r6J91QxjYYdRhgNEE3QccDw1UXCk1',47,'2024-03-13 15:02:01','2024-03-15 03:02:10',2,NULL),(48,'#10000048',10,'1','default','pending',430.00,0.00,0.00,NULL,NULL,0.00,430.00,1,NULL,1,NULL,'FFSIoeuxzehdIPKQxky45uqpg5lJz',48,'2024-03-13 19:02:02','2024-03-15 03:02:02',3,NULL),(49,'#10000049',10,'1','default','pending',3498.00,0.00,0.00,NULL,NULL,0.00,3498.00,1,NULL,1,NULL,'xBsZjFh6KBlmK6fOh41ApfBe3LmAO',49,'2024-03-14 23:02:02','2024-03-15 03:02:02',4,NULL),(50,'#10000050',10,NULL,'','completed',4348.00,0.00,0.00,NULL,NULL,0.00,4348.00,1,NULL,1,'2024-03-15 03:02:02','yswzsjuXuTgRVff8AvhY5x8TcUO8N',50,'2024-03-14 15:02:02','2024-03-15 03:02:02',5,NULL),(51,'#10000051',10,'1','default','completed',796.00,0.00,0.00,NULL,NULL,0.00,796.00,1,NULL,1,'2024-03-15 03:02:10','aAtVhUX0CG1YMUuKwGM59e9JU5s6b',51,'2024-03-14 19:02:02','2024-03-15 03:02:10',8,NULL),(52,'#10000052',9,'1','default','pending',3570.00,0.00,0.00,NULL,NULL,0.00,3570.00,1,NULL,1,NULL,'FngyoWVmTdtCkmOz1E30sV9PPzYUF',52,'2024-03-14 17:02:02','2024-03-15 03:02:02',6,NULL),(53,'#10000053',9,NULL,'','pending',3986.00,0.00,0.00,NULL,NULL,0.00,3986.00,1,NULL,1,NULL,'yx6YDoHmtL2VbOv5G7bmvhcSTVtgv',53,'2024-03-14 07:02:03','2024-03-15 03:02:03',1,NULL),(54,'#10000054',9,'1','default','completed',398.00,0.00,0.00,NULL,NULL,0.00,398.00,1,NULL,1,'2024-03-15 03:02:03','6xy4AMJGdRDSUuRaeexRVL2tX8iij',54,'2024-03-14 17:02:03','2024-03-15 03:02:03',8,NULL);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2024-03-15 03:01:35','2024-03-15 03:01:35',0),(2,'Size','size','text',1,1,1,'published',1,'2024-03-15 03:01:35','2024-03-15 03:01:35',0),(3,'Weight','weight','text',1,1,1,'published',0,'2024-03-15 03:01:35','2024-03-15 03:01:35',0),(4,'Boxes','boxes','text',1,1,1,'published',1,'2024-03-15 03:01:35','2024-03-15 03:01:35',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(2,1,'Blue','blue','#333333',NULL,0,2,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(3,1,'Red','red','#DA323F',NULL,0,3,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(4,1,'Black','black','#2F366C',NULL,0,4,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(6,2,'S','s',NULL,NULL,1,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(7,2,'M','m',NULL,NULL,0,2,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(8,2,'L','l',NULL,NULL,0,3,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(9,2,'XL','xl',NULL,NULL,0,4,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(11,3,'1KG','1kg',NULL,NULL,1,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(12,3,'2KG','2kg',NULL,NULL,0,2,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(13,3,'3KG','3kg',NULL,NULL,0,3,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(14,3,'4KG','4kg',NULL,NULL,0,4,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(15,3,'5KG','5kg',NULL,NULL,0,5,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(16,4,'1 Box','1-box',NULL,NULL,1,1,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(17,4,'2 Boxes','2-boxes',NULL,NULL,0,2,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(18,4,'3 Boxes','3-boxes',NULL,NULL,0,3,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(19,4,'4 Boxes','4-boxes',NULL,NULL,0,4,'2024-03-15 03:01:35','2024-03-15 03:01:35'),(20,4,'5 Boxes','5-boxes',NULL,NULL,0,5,'2024-03-15 03:01:35','2024-03-15 03:01:35');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Bags',0,NULL,'published',0,'fashion/product-categories/1.jpg',0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(2,'Clothing',0,NULL,'published',1,'fashion/product-categories/4.jpg',0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(3,'Men\'s Clothing',2,NULL,'published',0,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(4,'T-Shirts',3,NULL,'published',0,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(5,'Jeans',3,NULL,'published',1,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(6,'Suits',3,NULL,'published',2,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(7,'Women\'s Clothing',2,NULL,'published',1,'fashion/product-categories/2.jpg',0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(8,'Dresses',7,NULL,'published',0,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(9,'Blouses',7,NULL,'published',1,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(10,'Pants',7,NULL,'published',2,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(11,'Footwear',0,NULL,'published',2,'fashion/product-categories/6.jpg',0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(12,'Accessories',0,NULL,'published',3,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(13,'Hats',12,NULL,'published',0,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(14,'Scarves',12,NULL,'published',1,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(15,'Jewelry',12,NULL,'published',2,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(16,'Sportswear',0,NULL,'published',4,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(17,'Activewear',16,NULL,'published',0,NULL,0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(18,'Running Shoes',16,NULL,'published',1,'fashion/product-categories/3.jpg',0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL),(19,'Outerwear',0,NULL,'published',5,'fashion/product-categories/5.jpg',0,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,1),(1,5),(1,9),(1,10),(1,19),(1,24),(1,35),(1,38),(1,41),(2,1),(2,2),(2,3),(2,4),(2,11),(2,12),(2,15),(2,16),(2,25),(2,32),(2,33),(2,34),(2,37),(2,42),(3,5),(3,6),(3,7),(3,8),(3,11),(3,12),(3,20),(3,21),(3,23),(3,25),(3,26),(3,28),(3,35),(4,3),(4,10),(4,16),(4,22),(4,27),(4,28),(4,31),(4,35),(4,36),(5,6),(5,8),(5,20),(5,22),(5,26),(5,29),(5,31),(5,37),(6,16),(6,19),(6,20),(6,23),(6,26),(6,31),(6,43),(7,5),(7,17),(7,18),(7,19),(7,22),(7,27),(7,30),(7,33),(7,34),(7,41),(7,43),(8,4),(8,5),(8,9),(8,12),(8,21),(8,25),(8,32),(8,34),(9,1),(9,13),(9,14),(9,18),(9,27),(9,37),(9,38),(10,1),(10,6),(10,14),(10,15),(10,17),(10,21),(10,24),(10,30),(10,36),(10,39),(10,42),(10,43),(11,8),(11,10),(11,11),(11,18),(11,26),(11,35),(11,42),(12,7),(12,11),(12,20),(12,21),(12,24),(12,29),(12,32),(12,33),(12,39),(12,40),(12,41),(13,17),(13,18),(14,7),(14,9),(14,14),(14,17),(14,36),(14,38),(14,39),(15,4),(15,13),(15,15),(15,36),(15,39),(16,2),(16,3),(16,4),(16,8),(16,23),(16,28),(16,30),(16,31),(16,34),(16,40),(16,43),(17,2),(17,3),(17,6),(17,7),(17,10),(17,12),(17,13),(17,24),(17,29),(17,33),(17,40),(18,13),(18,14),(18,16),(18,23),(18,29),(18,30),(18,38),(18,42),(19,2),(19,9),(19,15),(19,19),(19,22),(19,25),(19,27),(19,28),(19,32),(19,37),(19,40),(19,41);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,8),(1,10),(1,11),(1,12),(1,13),(1,16),(1,20),(1,22),(1,23),(1,24),(1,27),(2,1),(2,2),(2,14),(2,29),(2,31),(2,36),(2,38),(2,42),(3,4),(3,17),(3,18),(3,19),(3,30),(3,32),(3,33),(3,35),(3,37),(3,40),(3,43),(4,3),(4,5),(4,6),(4,7),(4,9),(4,15),(4,21),(4,25),(4,26),(4,28),(4,34),(4,39),(4,41);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'Trendy Wardrobe Essentials','trendy-wardrobe-essentials',NULL,NULL,'published','2024-03-15 03:01:45','2024-03-15 03:01:45',0),(2,'Fashion Forward Finds','fashion-forward-finds',NULL,NULL,'published','2024-03-15 03:01:45','2024-03-15 03:01:45',0),(3,'Chic &amp; Stylish Collection','chic-stylish-collection',NULL,NULL,'published','2024-03-15 03:01:45','2024-03-15 03:01:45',0),(4,'Weekly Fashion Picks','weekly-fashion-picks',NULL,NULL,'published','2024-03-15 03:01:45','2024-03-15 03:01:45',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,5,0,0.00,'fixed',1),(1,6,0,0.00,'fixed',1),(1,7,0,0.00,'fixed',1),(1,12,0,0.00,'fixed',1),(1,14,0,0.00,'fixed',1),(1,19,0,0.00,'fixed',1),(2,1,0,0.00,'fixed',1),(2,10,0,0.00,'fixed',1),(2,12,0,0.00,'fixed',1),(2,13,0,0.00,'fixed',1),(2,15,0,0.00,'fixed',1),(2,20,0,0.00,'fixed',1),(3,8,0,0.00,'fixed',1),(3,10,0,0.00,'fixed',1),(3,12,0,0.00,'fixed',1),(3,14,0,0.00,'fixed',1),(3,16,0,0.00,'fixed',1),(3,19,0,0.00,'fixed',1),(3,20,0,0.00,'fixed',1),(4,12,0,0.00,'fixed',1),(4,13,0,0.00,'fixed',1),(4,14,0,0.00,'fixed',1),(4,17,0,0.00,'fixed',1),(4,19,0,0.00,'fixed',1),(4,20,0,0.00,'fixed',1),(5,6,0,0.00,'fixed',1),(5,9,0,0.00,'fixed',1),(5,11,0,0.00,'fixed',1),(5,12,0,0.00,'fixed',1),(5,15,0,0.00,'fixed',1),(6,5,0,0.00,'fixed',1),(6,7,0,0.00,'fixed',1),(6,8,0,0.00,'fixed',1),(6,10,0,0.00,'fixed',1),(6,18,0,0.00,'fixed',1),(7,2,0,0.00,'fixed',1),(7,3,0,0.00,'fixed',1),(7,10,0,0.00,'fixed',1),(7,12,0,0.00,'fixed',1),(7,16,0,0.00,'fixed',1),(7,19,0,0.00,'fixed',1),(8,1,0,0.00,'fixed',1),(8,4,0,0.00,'fixed',1),(8,6,0,0.00,'fixed',1),(8,13,0,0.00,'fixed',1),(8,17,0,0.00,'fixed',1),(8,19,0,0.00,'fixed',1),(9,11,0,0.00,'fixed',1),(9,12,0,0.00,'fixed',1),(9,13,0,0.00,'fixed',1),(9,15,0,0.00,'fixed',1),(9,18,0,0.00,'fixed',1),(9,20,0,0.00,'fixed',1),(10,2,0,0.00,'fixed',1),(10,4,0,0.00,'fixed',1),(10,6,0,0.00,'fixed',1),(10,14,0,0.00,'fixed',1),(10,15,0,0.00,'fixed',1),(10,17,0,0.00,'fixed',1),(11,1,0,0.00,'fixed',1),(11,4,0,0.00,'fixed',1),(11,6,0,0.00,'fixed',1),(11,8,0,0.00,'fixed',1),(11,13,0,0.00,'fixed',1),(11,14,0,0.00,'fixed',1),(11,15,0,0.00,'fixed',1),(12,3,0,0.00,'fixed',1),(12,5,0,0.00,'fixed',1),(12,7,0,0.00,'fixed',1),(12,8,0,0.00,'fixed',1),(12,14,0,0.00,'fixed',1),(13,1,0,0.00,'fixed',1),(13,12,0,0.00,'fixed',1),(13,15,0,0.00,'fixed',1),(13,17,0,0.00,'fixed',1),(13,19,0,0.00,'fixed',1),(13,20,0,0.00,'fixed',1),(14,5,0,0.00,'fixed',1),(14,6,0,0.00,'fixed',1),(14,7,0,0.00,'fixed',1),(14,9,0,0.00,'fixed',1),(14,13,0,0.00,'fixed',1),(14,15,0,0.00,'fixed',1),(14,18,0,0.00,'fixed',1),(15,1,0,0.00,'fixed',1),(15,4,0,0.00,'fixed',1),(15,6,0,0.00,'fixed',1),(15,13,0,0.00,'fixed',1),(15,16,0,0.00,'fixed',1),(15,17,0,0.00,'fixed',1),(16,2,0,0.00,'fixed',1),(16,7,0,0.00,'fixed',1),(16,9,0,0.00,'fixed',1),(16,15,0,0.00,'fixed',1),(16,18,0,0.00,'fixed',1),(16,19,0,0.00,'fixed',1),(17,2,0,0.00,'fixed',1),(17,5,0,0.00,'fixed',1),(17,6,0,0.00,'fixed',1),(17,8,0,0.00,'fixed',1),(17,10,0,0.00,'fixed',1),(17,15,0,0.00,'fixed',1),(18,5,0,0.00,'fixed',1),(18,6,0,0.00,'fixed',1),(18,9,0,0.00,'fixed',1),(18,12,0,0.00,'fixed',1),(18,13,0,0.00,'fixed',1),(18,16,0,0.00,'fixed',1),(19,1,0,0.00,'fixed',1),(19,7,0,0.00,'fixed',1),(19,10,0,0.00,'fixed',1),(19,12,0,0.00,'fixed',1),(19,16,0,0.00,'fixed',1),(19,20,0,0.00,'fixed',1),(20,3,0,0.00,'fixed',1),(20,4,0,0.00,'fixed',1),(20,5,0,0.00,'fixed',1),(20,10,0,0.00,'fixed',1),(20,11,0,0.00,'fixed',1),(20,15,0,0.00,'fixed',1),(20,17,0,0.00,'fixed',1),(21,1,0,0.00,'fixed',1),(21,2,0,0.00,'fixed',1),(21,3,0,0.00,'fixed',1),(21,8,0,0.00,'fixed',1),(21,9,0,0.00,'fixed',1),(22,5,0,0.00,'fixed',1),(22,6,0,0.00,'fixed',1),(22,9,0,0.00,'fixed',1),(22,11,0,0.00,'fixed',1),(22,15,0,0.00,'fixed',1),(22,17,0,0.00,'fixed',1),(22,19,0,0.00,'fixed',1),(23,1,0,0.00,'fixed',1),(23,3,0,0.00,'fixed',1),(23,5,0,0.00,'fixed',1),(23,8,0,0.00,'fixed',1),(23,12,0,0.00,'fixed',1),(23,14,0,0.00,'fixed',1),(24,4,0,0.00,'fixed',1),(24,8,0,0.00,'fixed',1),(24,11,0,0.00,'fixed',1),(24,14,0,0.00,'fixed',1),(24,16,0,0.00,'fixed',1),(24,17,0,0.00,'fixed',1),(24,18,0,0.00,'fixed',1),(25,2,0,0.00,'fixed',1),(25,5,0,0.00,'fixed',1),(25,6,0,0.00,'fixed',1),(25,9,0,0.00,'fixed',1),(25,10,0,0.00,'fixed',1),(25,12,0,0.00,'fixed',1),(26,3,0,0.00,'fixed',1),(26,4,0,0.00,'fixed',1),(26,5,0,0.00,'fixed',1),(26,11,0,0.00,'fixed',1),(26,12,0,0.00,'fixed',1),(26,18,0,0.00,'fixed',1),(27,9,0,0.00,'fixed',1),(27,13,0,0.00,'fixed',1),(27,14,0,0.00,'fixed',1),(27,16,0,0.00,'fixed',1),(27,19,0,0.00,'fixed',1),(28,1,0,0.00,'fixed',1),(28,3,0,0.00,'fixed',1),(28,5,0,0.00,'fixed',1),(28,7,0,0.00,'fixed',1),(28,10,0,0.00,'fixed',1),(28,11,0,0.00,'fixed',1),(29,1,0,0.00,'fixed',1),(29,3,0,0.00,'fixed',1),(29,6,0,0.00,'fixed',1),(29,14,0,0.00,'fixed',1),(29,15,0,0.00,'fixed',1),(29,17,0,0.00,'fixed',1),(30,1,0,0.00,'fixed',1),(30,2,0,0.00,'fixed',1),(30,5,0,0.00,'fixed',1),(30,7,0,0.00,'fixed',1),(30,11,0,0.00,'fixed',1),(30,16,0,0.00,'fixed',1),(30,19,0,0.00,'fixed',1),(31,3,0,0.00,'fixed',1),(31,4,0,0.00,'fixed',1),(31,5,0,0.00,'fixed',1),(31,9,0,0.00,'fixed',1),(31,13,0,0.00,'fixed',1),(31,14,0,0.00,'fixed',1),(31,16,0,0.00,'fixed',1),(32,3,0,0.00,'fixed',1),(32,4,0,0.00,'fixed',1),(32,6,0,0.00,'fixed',1),(32,8,0,0.00,'fixed',1),(32,9,0,0.00,'fixed',1),(32,10,0,0.00,'fixed',1),(32,14,0,0.00,'fixed',1),(33,1,0,0.00,'fixed',1),(33,6,0,0.00,'fixed',1),(33,9,0,0.00,'fixed',1),(33,11,0,0.00,'fixed',1),(33,16,0,0.00,'fixed',1),(33,18,0,0.00,'fixed',1),(34,1,0,0.00,'fixed',1),(34,4,0,0.00,'fixed',1),(34,8,0,0.00,'fixed',1),(34,9,0,0.00,'fixed',1),(34,14,0,0.00,'fixed',1),(34,19,0,0.00,'fixed',1),(35,3,0,0.00,'fixed',1),(35,4,0,0.00,'fixed',1),(35,6,0,0.00,'fixed',1),(35,7,0,0.00,'fixed',1),(35,11,0,0.00,'fixed',1),(35,13,0,0.00,'fixed',1),(36,1,0,0.00,'fixed',1),(36,4,0,0.00,'fixed',1),(36,11,0,0.00,'fixed',1),(36,13,0,0.00,'fixed',1),(36,14,0,0.00,'fixed',1),(37,1,0,0.00,'fixed',1),(37,6,0,0.00,'fixed',1),(37,7,0,0.00,'fixed',1),(37,8,0,0.00,'fixed',1),(37,15,0,0.00,'fixed',1),(37,17,0,0.00,'fixed',1),(38,2,0,0.00,'fixed',1),(38,5,0,0.00,'fixed',1),(38,7,0,0.00,'fixed',1),(38,11,0,0.00,'fixed',1),(38,15,0,0.00,'fixed',1),(38,16,0,0.00,'fixed',1),(39,3,0,0.00,'fixed',1),(39,4,0,0.00,'fixed',1),(39,8,0,0.00,'fixed',1),(39,9,0,0.00,'fixed',1),(39,11,0,0.00,'fixed',1),(39,12,0,0.00,'fixed',1),(39,16,0,0.00,'fixed',1),(40,1,0,0.00,'fixed',1),(40,2,0,0.00,'fixed',1),(40,4,0,0.00,'fixed',1),(40,9,0,0.00,'fixed',1),(40,13,0,0.00,'fixed',1),(41,2,0,0.00,'fixed',1),(41,5,0,0.00,'fixed',1),(41,8,0,0.00,'fixed',1),(41,14,0,0.00,'fixed',1),(41,15,0,0.00,'fixed',1),(41,16,0,0.00,'fixed',1),(42,1,0,0.00,'fixed',1),(42,3,0,0.00,'fixed',1),(42,5,0,0.00,'fixed',1),(42,12,0,0.00,'fixed',1),(42,14,0,0.00,'fixed',1),(43,1,0,0.00,'fixed',1),(43,5,0,0.00,'fixed',1),(43,7,0,0.00,'fixed',1),(43,12,0,0.00,'fixed',1),(43,13,0,0.00,'fixed',1),(43,16,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=196 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,49,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(2,49,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(3,49,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(4,49,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(5,49,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(6,49,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(7,49,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(8,49,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(9,50,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(10,50,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(11,50,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(12,50,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(13,50,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(14,50,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(15,50,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(16,50,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(17,51,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(18,51,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(19,51,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(20,51,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(21,51,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(22,51,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(23,51,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(24,51,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(25,52,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(26,52,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(27,52,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(28,52,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(29,52,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(30,52,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(31,52,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(32,52,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(33,61,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(34,61,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(35,61,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(36,61,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(37,61,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(38,61,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(39,61,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(40,61,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(41,62,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(42,62,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(43,62,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(44,62,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(45,62,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(46,62,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(47,62,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(48,62,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(49,63,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(50,63,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(51,63,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(52,63,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(53,63,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(54,63,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(55,63,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(56,63,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(57,64,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(58,64,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(59,64,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(60,64,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(61,64,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(62,64,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(63,64,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(64,64,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:46\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:46','2024-03-15 03:01:46'),(65,72,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(66,72,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(67,72,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(68,72,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(69,72,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(70,72,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(71,72,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(72,73,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(73,73,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(74,73,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(75,73,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(76,73,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(77,73,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(78,73,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(79,80,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(80,80,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(81,80,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(82,80,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(83,80,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(84,81,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(85,81,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(86,81,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(87,81,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(88,81,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(89,89,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(90,89,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(91,89,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(92,89,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(93,89,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(94,90,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(95,90,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(96,90,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(97,90,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(98,90,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(99,91,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(100,91,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(101,91,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(102,91,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(103,91,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(104,101,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(105,101,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(106,101,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(107,101,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(108,101,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(109,101,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(110,102,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(111,102,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(112,102,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(113,102,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(114,102,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(115,102,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(116,103,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(117,103,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(118,103,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(119,103,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(120,103,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(121,103,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(122,104,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(123,104,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(124,104,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(125,104,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(126,104,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(127,104,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(128,110,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(129,110,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(130,110,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(131,110,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(132,110,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(133,110,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(134,110,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(135,110,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(136,111,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(137,111,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(138,111,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(139,111,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(140,111,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(141,111,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(142,111,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(143,111,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(144,120,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(145,120,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(146,120,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(147,120,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(148,120,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(149,120,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(150,121,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(151,121,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(152,121,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(153,121,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(154,121,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(155,121,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:47\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:47','2024-03-15 03:01:47'),(156,122,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(157,122,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(158,122,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(159,122,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(160,122,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(161,122,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(162,123,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(163,123,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(164,123,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(165,123,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(166,123,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(167,123,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(168,133,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(169,133,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(170,133,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(171,133,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(172,133,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(173,133,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(174,133,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(175,134,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(176,134,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(177,134,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(178,134,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(179,134,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(180,134,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(181,134,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(182,142,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(183,142,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(184,142,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(185,142,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(186,142,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(187,142,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(188,142,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(189,143,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(190,143,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(191,143,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(192,143,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(193,143,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(194,143,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48'),(195,143,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:01:48\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:01:48','2024-03-15 03:01:48');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,6),(1,9),(1,12),(1,27),(2,18),(2,42),(3,3),(3,15),(3,21),(3,24),(3,30),(3,33),(3,36),(3,39);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#cb4321','published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(2,'New','#00c9a7','published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(3,'Sale','#ba591d','published','2024-03-15 03:01:35','2024-03-15 03:01:35');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,1),(1,3),(1,4),(2,1),(2,2),(2,6),(3,2),(3,3),(3,4),(4,3),(4,4),(4,6),(5,1),(5,4),(5,6),(6,2),(6,3),(6,6),(7,1),(7,2),(7,3),(8,1),(8,5),(8,6),(9,2),(9,3),(9,4),(10,2),(10,3),(10,5),(11,3),(11,5),(11,6),(12,1),(12,5),(12,6),(13,1),(13,4),(13,6),(14,3),(14,5),(14,6),(15,1),(15,2),(15,5),(16,1),(16,3),(16,6),(17,2),(17,4),(17,6),(18,1),(18,2),(18,5),(19,1),(19,2),(19,6),(20,2),(20,3),(20,6),(21,1),(21,3),(21,5),(22,2),(22,4),(22,5),(23,2),(23,5),(23,6),(24,1),(24,3),(24,6),(25,3),(25,4),(25,5),(26,1),(26,3),(26,4),(27,1),(27,2),(27,6),(28,4),(28,5),(28,6),(29,1),(29,2),(29,3),(30,1),(30,2),(30,3),(31,1),(31,2),(31,5),(32,2),(32,3),(32,5),(33,3),(33,4),(33,6),(34,1),(34,3),(34,6),(35,1),(35,2),(35,6),(36,2),(36,5),(36,6),(37,4),(37,5),(37,6),(38,2),(38,3),(38,5),(39,2),(39,3),(39,5),(40,1),(40,2),(40,5),(41,1),(41,4),(41,6),(42,1),(42,4),(42,5),(43,1),(43,2),(43,6);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2024-03-15 03:01:39','2024-03-15 03:01:39'),(2,'Mobile',NULL,'published','2024-03-15 03:01:39','2024-03-15 03:01:39'),(3,'Iphone',NULL,'published','2024-03-15 03:01:39','2024-03-15 03:01:39'),(4,'Printer',NULL,'published','2024-03-15 03:01:39','2024-03-15 03:01:39'),(5,'Office',NULL,'published','2024-03-15 03:01:39','2024-03-15 03:01:39'),(6,'IT',NULL,'published','2024-03-15 03:01:39','2024-03-15 03:01:39');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=219 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (7,1,4),(11,1,6),(13,1,7),(33,1,17),(53,1,27),(59,1,30),(61,1,31),(63,1,32),(73,1,37),(87,1,44),(99,1,50),(9,2,5),(21,2,11),(37,2,19),(39,2,20),(41,2,21),(69,2,35),(71,2,36),(79,2,40),(83,2,42),(95,2,48),(97,2,49),(111,2,56),(1,3,1),(3,3,2),(17,3,9),(43,3,22),(45,3,23),(55,3,28),(77,3,39),(105,3,53),(113,3,57),(23,4,12),(25,4,13),(35,4,18),(47,4,24),(49,4,25),(51,4,26),(57,4,29),(65,4,33),(75,4,38),(81,4,41),(85,4,43),(91,4,46),(103,4,52),(107,4,54),(5,5,3),(15,5,8),(19,5,10),(27,5,14),(29,5,15),(31,5,16),(67,5,34),(89,5,45),(93,5,47),(101,5,51),(109,5,55),(14,6,7),(28,6,14),(34,6,17),(36,6,18),(44,6,22),(62,6,31),(74,6,37),(78,6,39),(82,6,41),(90,6,45),(100,6,50),(102,6,51),(104,6,52),(10,7,5),(48,7,24),(52,7,26),(54,7,27),(72,7,36),(76,7,38),(80,7,40),(92,7,46),(96,7,48),(2,8,1),(6,8,3),(8,8,4),(18,8,9),(42,8,21),(46,8,23),(56,8,28),(64,8,32),(68,8,34),(106,8,53),(108,8,54),(4,9,2),(16,9,8),(30,9,15),(32,9,16),(38,9,19),(50,9,25),(60,9,30),(84,9,42),(86,9,43),(94,9,47),(110,9,55),(12,10,6),(20,10,10),(22,10,11),(24,10,12),(26,10,13),(40,10,20),(58,10,29),(66,10,33),(70,10,35),(88,10,44),(98,10,49),(112,10,56),(114,10,57),(115,11,58),(121,11,61),(123,11,62),(129,11,65),(131,11,66),(167,11,84),(195,11,98),(207,11,104),(209,11,105),(117,12,59),(125,12,63),(133,12,67),(139,12,70),(143,12,72),(151,12,76),(155,12,78),(161,12,81),(165,12,83),(171,12,86),(177,12,89),(181,12,91),(183,12,92),(197,12,99),(119,13,60),(141,13,71),(173,13,87),(191,13,96),(145,14,73),(147,14,74),(149,14,75),(163,14,82),(169,14,85),(179,14,90),(185,14,93),(199,14,100),(201,14,101),(211,14,106),(217,14,109),(127,15,64),(135,15,68),(137,15,69),(153,15,77),(157,15,79),(159,15,80),(175,15,88),(187,15,94),(189,15,95),(193,15,97),(203,15,102),(205,15,103),(213,15,107),(215,15,108),(146,16,73),(162,16,81),(172,16,86),(178,16,89),(198,16,99),(204,16,102),(206,16,103),(122,17,61),(128,17,64),(138,17,69),(142,17,71),(154,17,77),(156,17,78),(160,17,80),(164,17,82),(182,17,91),(186,17,93),(188,17,94),(194,17,97),(136,18,68),(140,18,70),(144,18,72),(148,18,74),(158,18,79),(166,18,83),(168,18,84),(170,18,85),(180,18,90),(184,18,92),(200,18,100),(216,18,108),(218,18,109),(126,19,63),(132,19,66),(192,19,96),(208,19,104),(210,19,105),(212,19,106),(116,20,58),(118,20,59),(120,20,60),(124,20,62),(130,20,65),(134,20,67),(150,20,75),(152,20,76),(174,20,87),(176,20,88),(190,20,95),(196,20,98),(202,20,101),(214,20,107);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,44,1,1),(2,45,2,1),(3,46,2,0),(4,47,3,1),(5,48,3,0),(6,49,4,1),(7,50,4,0),(8,51,4,0),(9,52,4,0),(10,53,5,1),(11,54,5,0),(12,55,5,0),(13,56,6,1),(14,57,6,0),(15,58,7,1),(16,59,7,0),(17,60,7,0),(18,61,8,1),(19,62,8,0),(20,63,8,0),(21,64,8,0),(22,65,9,1),(23,66,9,0),(24,67,10,1),(25,68,10,0),(26,69,11,1),(27,70,11,0),(28,71,11,0),(29,72,12,1),(30,73,12,0),(31,74,13,1),(32,75,13,0),(33,76,14,1),(34,77,15,1),(35,78,15,0),(36,79,15,0),(37,80,16,1),(38,81,16,0),(39,82,17,1),(40,83,17,0),(41,84,18,1),(42,85,18,0),(43,86,18,0),(44,87,19,1),(45,88,19,0),(46,89,20,1),(47,90,20,0),(48,91,20,0),(49,92,21,1),(50,93,21,0),(51,94,21,0),(52,95,22,1),(53,96,22,0),(54,97,23,1),(55,98,23,0),(56,99,23,0),(57,100,23,0),(58,101,24,1),(59,102,24,0),(60,103,24,0),(61,104,24,0),(62,105,25,1),(63,106,26,1),(64,107,26,0),(65,108,26,0),(66,109,27,1),(67,110,28,1),(68,111,28,0),(69,112,29,1),(70,113,29,0),(71,114,30,1),(72,115,30,0),(73,116,31,1),(74,117,31,0),(75,118,31,0),(76,119,31,0),(77,120,32,1),(78,121,32,0),(79,122,32,0),(80,123,32,0),(81,124,33,1),(82,125,33,0),(83,126,33,0),(84,127,33,0),(85,128,33,0),(86,129,34,1),(87,130,35,1),(88,131,35,0),(89,132,35,0),(90,133,36,1),(91,134,36,0),(92,135,37,1),(93,136,37,0),(94,137,38,1),(95,138,38,0),(96,139,39,1),(97,140,39,0),(98,141,39,0),(99,142,40,1),(100,143,40,0),(101,144,41,1),(102,145,41,0),(103,146,41,0),(104,147,42,1),(105,148,42,0),(106,149,43,1),(107,150,43,0),(108,151,43,0),(109,152,43,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2024-03-15',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(3,24,0),(4,24,0),(3,25,0),(4,25,0),(3,26,0),(4,26,0),(3,27,0),(4,27,0),(3,28,0),(4,28,0),(3,29,0),(4,29,0),(3,30,0),(4,30,0),(3,31,0),(4,31,0),(3,32,0),(4,32,0),(3,33,0),(4,33,0),(3,34,0),(4,34,0),(3,35,0),(4,35,0),(3,36,0),(4,36,0),(3,37,0),(4,37,0),(3,38,0),(4,38,0),(3,39,0),(4,39,0),(3,40,0),(4,40,0),(3,41,0),(4,41,0),(3,42,0),(4,42,0),(3,43,0),(4,43,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `approved_by` bigint unsigned DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Vintage Denim Jacket','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\"]','ZG-126-A0',0,13,0,1,0,2,0,0,951,NULL,NULL,NULL,17.00,16.00,10.00,758.00,NULL,30302,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(2,'Floral Maxi Dress','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-1.png\"]','1E-156-A0',0,18,0,1,0,1,0,0,984,NULL,NULL,NULL,12.00,13.00,10.00,886.00,NULL,155557,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(3,'Leather Ankle Boots','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\"]','9W-158-A0',0,17,0,1,0,4,0,0,1724,NULL,NULL,NULL,17.00,10.00,20.00,783.00,NULL,55506,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(4,'Knit Turtleneck Sweater (Digital)','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\"]','SL-181-A0',0,11,0,1,1,3,0,0,1941,1533.39,NULL,NULL,10.00,17.00,10.00,642.00,NULL,33748,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(5,'Classic Aviator Sunglasses','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-2.png\"]','YN-124-A0',0,13,0,1,1,5,0,0,324,NULL,NULL,NULL,15.00,10.00,18.00,558.00,NULL,57772,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(6,'Tailored Wool Blazer','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-6.png\"]','4Z-114-A0',0,18,0,1,1,3,0,0,347,NULL,NULL,NULL,16.00,18.00,11.00,887.00,NULL,146154,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(7,'Bohemian Fringe Handbag','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-7.png\"]','GF-190-A0',0,19,0,1,0,3,0,0,2427,NULL,NULL,NULL,12.00,19.00,18.00,642.00,NULL,168335,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(8,'Silk Scarf with Geometric Print (Digital)','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\"]','Y8-136-A0',0,17,0,1,1,3,0,0,1309,1007.93,NULL,NULL,12.00,18.00,18.00,581.00,NULL,190540,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(9,'High-Waisted Wide Leg Trousers','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\"]','TI-119-A0',0,17,0,1,0,1,0,0,2344,NULL,NULL,NULL,12.00,11.00,19.00,620.00,NULL,26861,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(10,'Embroidered Boho Blouse','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\"]','QA-126-A0',0,13,0,1,0,2,0,0,2095,NULL,NULL,NULL,13.00,18.00,19.00,797.00,NULL,117330,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(11,'Statement Chunky Necklace','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\"]','GP-110-A0',0,12,0,1,0,4,0,0,576,NULL,NULL,NULL,13.00,18.00,13.00,709.00,NULL,45418,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(12,'Chic Fedora Hat (Digital)','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\"]','WU-134-A0',0,20,0,1,1,2,0,0,376,330.88,NULL,NULL,15.00,18.00,18.00,786.00,NULL,158885,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(13,'Strappy Block Heel Sandals','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-3.png\"]','SG-132-A0',0,18,0,1,0,5,0,0,430,NULL,NULL,NULL,17.00,16.00,10.00,582.00,NULL,6828,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(14,'Velvet Evening Gown','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-5.png\"]','B4-128-A0',0,18,0,1,0,3,0,0,2194,NULL,NULL,NULL,12.00,19.00,12.00,688.00,NULL,17029,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(15,'Quilted Crossbody Bag','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-3.png\"]','VI-185-A0',0,12,0,1,1,1,0,0,1067,NULL,NULL,NULL,12.00,20.00,19.00,586.00,NULL,192703,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(16,'Distressed Skinny Jeans (Digital)','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\"]','QA-196-A0',0,16,0,1,0,3,0,0,1638,1244.88,NULL,NULL,14.00,17.00,18.00,574.00,NULL,194538,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(17,'Lace-Up Combat Boots','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\"]','1J-156-A0',0,15,0,1,0,1,0,0,921,NULL,NULL,NULL,13.00,18.00,16.00,761.00,NULL,64266,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(18,'Cotton Striped T-Shirt Dress','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-3.png\"]','ZN-197-A0',0,19,0,1,1,4,0,0,1190,NULL,NULL,NULL,20.00,19.00,14.00,678.00,NULL,83983,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(19,'Printed Palazzo Pants','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-3.png\"]','LQ-148-A0',0,15,0,1,0,1,0,0,2386,NULL,NULL,NULL,12.00,15.00,14.00,601.00,NULL,155013,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(20,'Structured Satchel Bag (Digital)','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\"]','3W-199-A0',0,14,0,1,1,5,0,0,1076,763.96,NULL,NULL,18.00,10.00,13.00,666.00,NULL,173917,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(21,'Off-Shoulder Ruffle Top','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-6.png\"]','WA-178-A0',0,16,0,1,0,4,0,0,1749,NULL,NULL,NULL,15.00,16.00,12.00,749.00,NULL,3135,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(22,'Suede Pointed-Toe Pumps','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-3.png\"]','OF-183-A0',0,18,0,1,0,1,0,0,641,NULL,NULL,NULL,17.00,14.00,13.00,852.00,NULL,96588,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(23,'Cropped Cable Knit Sweater','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\"]','LW-179-A0',0,13,0,1,0,1,0,0,1095,NULL,NULL,NULL,20.00,18.00,18.00,584.00,NULL,10644,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(24,'Athleisure Jogger Pants (Digital)','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-6.png\"]','3I-116-A0',0,20,0,1,0,1,0,0,2174,1521.8,NULL,NULL,10.00,18.00,12.00,868.00,NULL,70765,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(25,'Leopard Print Midi Skirt','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\"]','HV-127-A0',0,13,0,1,1,3,0,0,2410,NULL,NULL,NULL,16.00,15.00,18.00,684.00,NULL,76037,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(26,'Retro Cat-Eye Sunglasses','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\"]','R7-154-A0',0,10,0,1,1,1,0,0,1467,NULL,NULL,NULL,15.00,18.00,17.00,846.00,NULL,192421,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(27,'Faux Fur Trimmed Coat','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-1.png\"]','LK-137-A0',0,16,0,1,1,1,0,0,2332,NULL,NULL,NULL,17.00,17.00,16.00,838.00,NULL,20692,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(28,'Boho Fringed Kimono (Digital)','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-1.png\"]','W2-104-A0',0,18,0,1,1,4,0,0,478,344.16,NULL,NULL,10.00,15.00,10.00,713.00,NULL,84889,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(29,'Ruffled Wrap Dress','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-2.png\"]','7J-122-A0',0,13,0,1,1,5,0,0,1541,NULL,NULL,NULL,18.00,11.00,12.00,554.00,NULL,45961,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(30,'Beaded Evening Clutch','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-2.png\"]','DW-156-A0',0,19,0,1,0,2,0,0,1089,NULL,NULL,NULL,13.00,11.00,15.00,805.00,NULL,39121,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(31,'Wide Brim Floppy Hat','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-2.png\"]','RO-115-A0',0,15,0,1,0,1,0,0,446,NULL,NULL,NULL,14.00,18.00,15.00,835.00,NULL,72050,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(32,'Denim Overall Jumpsuit (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-4.png\"]','HD-143-A0',0,17,0,1,0,5,0,0,2134,1643.18,NULL,NULL,14.00,11.00,11.00,828.00,NULL,37010,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(33,'Embellished Ballet Flats','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\"]','ZX-108-A0',0,13,0,1,0,1,0,0,334,NULL,NULL,NULL,11.00,12.00,17.00,698.00,NULL,10215,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(34,'Pleated Midi Skirt','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\"]','TJ-150-A0',0,10,0,1,1,1,0,0,689,NULL,NULL,NULL,14.00,20.00,15.00,683.00,NULL,159961,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(35,'Velour Tracksuit Set','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-3.png\"]','MT-110-A0',0,17,0,1,0,2,0,0,1258,NULL,NULL,NULL,14.00,12.00,11.00,603.00,NULL,145769,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(36,'Geometric Patterned Cardigan (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\"]','TN-107-A0',0,20,0,1,1,3,0,0,1993,1395.1,NULL,NULL,15.00,17.00,13.00,817.00,NULL,147889,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(37,'Buckle Detail Ankle Booties','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-8.png\"]','YM-108-A0',0,20,0,1,1,5,0,0,398,NULL,NULL,NULL,10.00,11.00,13.00,654.00,NULL,129595,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(38,'Embroidered Bomber Jacket','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-2.png\"]','K9-161-A0',0,15,0,1,0,5,0,0,2449,NULL,NULL,NULL,19.00,14.00,14.00,630.00,NULL,181790,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(39,'Cowl Neck Knit Poncho','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-8.png\"]','GI-187-A0',0,15,0,1,0,3,0,0,341,NULL,NULL,NULL,20.00,12.00,11.00,564.00,NULL,129315,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(40,'Chunky Knit Infinity Scarf (Digital)','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-4.png\"]','LW-185-A0',0,13,0,1,1,4,0,0,2471,1828.54,NULL,NULL,15.00,17.00,11.00,828.00,NULL,166775,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(41,'Retro High-Top Sneakers','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-8.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-3.png\",\"fashion\\/products\\/product-5.png\"]','XP-105-A0',0,10,0,1,0,2,0,0,517,NULL,NULL,NULL,18.00,12.00,15.00,863.00,NULL,193233,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(42,'Faux Leather Leggings','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-7.png\",\"fashion\\/products\\/product-6.png\",\"fashion\\/products\\/product-1.png\",\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-4.png\",\"fashion\\/products\\/product-3.png\"]','76-108-A0',0,18,0,1,0,2,0,0,1516,NULL,NULL,NULL,10.00,20.00,16.00,681.00,NULL,86243,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(43,'Metallic Pleated Maxi Skirt','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"fashion\\/products\\/product-2.png\",\"fashion\\/products\\/product-5.png\",\"fashion\\/products\\/product-7.png\"]','N7-144-A0',0,13,0,1,0,3,0,0,1048,NULL,NULL,NULL,17.00,20.00,16.00,589.00,NULL,125605,'2024-03-15 03:01:46','2024-03-15 03:01:48','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(44,'Vintage Denim Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','ZG-126-A0',0,13,0,1,0,2,1,0,951,NULL,NULL,NULL,17.00,16.00,10.00,758.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(45,'Floral Maxi Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','1E-156-A0',0,18,0,1,0,1,1,0,984,NULL,NULL,NULL,12.00,13.00,10.00,886.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(46,'Floral Maxi Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','1E-156-A0-A1',0,18,0,1,0,1,1,0,984,NULL,NULL,NULL,12.00,13.00,10.00,886.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(47,'Leather Ankle Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','9W-158-A0',0,17,0,1,0,4,1,0,1724,NULL,NULL,NULL,17.00,10.00,20.00,783.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(48,'Leather Ankle Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','9W-158-A0-A1',0,17,0,1,0,4,1,0,1724,NULL,NULL,NULL,17.00,10.00,20.00,783.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(49,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','SL-181-A0',0,11,0,1,0,3,1,0,1941,1533.39,NULL,NULL,10.00,17.00,10.00,642.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(50,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','SL-181-A0-A1',0,11,0,1,0,3,1,0,1941,1708.08,NULL,NULL,10.00,17.00,10.00,642.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(51,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','SL-181-A0-A2',0,11,0,1,0,3,1,0,1941,1513.98,NULL,NULL,10.00,17.00,10.00,642.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(52,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','SL-181-A0-A3',0,11,0,1,0,3,1,0,1941,1746.9,NULL,NULL,10.00,17.00,10.00,642.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(53,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','YN-124-A0',0,13,0,1,0,5,1,0,324,NULL,NULL,NULL,15.00,10.00,18.00,558.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(54,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','YN-124-A0-A1',0,13,0,1,0,5,1,0,324,NULL,NULL,NULL,15.00,10.00,18.00,558.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(55,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','YN-124-A0-A2',0,13,0,1,0,5,1,0,324,NULL,NULL,NULL,15.00,10.00,18.00,558.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(56,'Tailored Wool Blazer',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','4Z-114-A0',0,18,0,1,0,3,1,0,347,NULL,NULL,NULL,16.00,18.00,11.00,887.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(57,'Tailored Wool Blazer',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','4Z-114-A0-A1',0,18,0,1,0,3,1,0,347,NULL,NULL,NULL,16.00,18.00,11.00,887.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(58,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','GF-190-A0',0,19,0,1,0,3,1,0,2427,NULL,NULL,NULL,12.00,19.00,18.00,642.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(59,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','GF-190-A0-A1',0,19,0,1,0,3,1,0,2427,NULL,NULL,NULL,12.00,19.00,18.00,642.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(60,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','GF-190-A0-A2',0,19,0,1,0,3,1,0,2427,NULL,NULL,NULL,12.00,19.00,18.00,642.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(61,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','Y8-136-A0',0,17,0,1,0,3,1,0,1309,1007.93,NULL,NULL,12.00,18.00,18.00,581.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(62,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','Y8-136-A0-A1',0,17,0,1,0,3,1,0,1309,1112.65,NULL,NULL,12.00,18.00,18.00,581.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(63,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','Y8-136-A0-A2',0,17,0,1,0,3,1,0,1309,1021.02,NULL,NULL,12.00,18.00,18.00,581.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(64,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','Y8-136-A0-A3',0,17,0,1,0,3,1,0,1309,942.48,NULL,NULL,12.00,18.00,18.00,581.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:46','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(65,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','TI-119-A0',0,17,0,1,0,1,1,0,2344,NULL,NULL,NULL,12.00,11.00,19.00,620.00,NULL,0,'2024-03-15 03:01:46','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(66,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','TI-119-A0-A1',0,17,0,1,0,1,1,0,2344,NULL,NULL,NULL,12.00,11.00,19.00,620.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(67,'Embroidered Boho Blouse',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','QA-126-A0',0,13,0,1,0,2,1,0,2095,NULL,NULL,NULL,13.00,18.00,19.00,797.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(68,'Embroidered Boho Blouse',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','QA-126-A0-A1',0,13,0,1,0,2,1,0,2095,NULL,NULL,NULL,13.00,18.00,19.00,797.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(69,'Statement Chunky Necklace',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','GP-110-A0',0,12,0,1,0,4,1,0,576,NULL,NULL,NULL,13.00,18.00,13.00,709.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(70,'Statement Chunky Necklace',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','GP-110-A0-A1',0,12,0,1,0,4,1,0,576,NULL,NULL,NULL,13.00,18.00,13.00,709.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(71,'Statement Chunky Necklace',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','GP-110-A0-A2',0,12,0,1,0,4,1,0,576,NULL,NULL,NULL,13.00,18.00,13.00,709.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(72,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','WU-134-A0',0,20,0,1,0,2,1,0,376,330.88,NULL,NULL,15.00,18.00,18.00,786.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(73,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','WU-134-A0-A1',0,20,0,1,0,2,1,0,376,315.84,NULL,NULL,15.00,18.00,18.00,786.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(74,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','SG-132-A0',0,18,0,1,0,5,1,0,430,NULL,NULL,NULL,17.00,16.00,10.00,582.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(75,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','SG-132-A0-A1',0,18,0,1,0,5,1,0,430,NULL,NULL,NULL,17.00,16.00,10.00,582.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(76,'Velvet Evening Gown',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','B4-128-A0',0,18,0,1,0,3,1,0,2194,NULL,NULL,NULL,12.00,19.00,12.00,688.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(77,'Quilted Crossbody Bag',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','VI-185-A0',0,12,0,1,0,1,1,0,1067,NULL,NULL,NULL,12.00,20.00,19.00,586.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(78,'Quilted Crossbody Bag',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','VI-185-A0-A1',0,12,0,1,0,1,1,0,1067,NULL,NULL,NULL,12.00,20.00,19.00,586.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(79,'Quilted Crossbody Bag',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','VI-185-A0-A2',0,12,0,1,0,1,1,0,1067,NULL,NULL,NULL,12.00,20.00,19.00,586.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(80,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','QA-196-A0',0,16,0,1,0,3,1,0,1638,1244.88,NULL,NULL,14.00,17.00,18.00,574.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(81,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','QA-196-A0-A1',0,16,0,1,0,3,1,0,1638,1195.74,NULL,NULL,14.00,17.00,18.00,574.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(82,'Lace-Up Combat Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','1J-156-A0',0,15,0,1,0,1,1,0,921,NULL,NULL,NULL,13.00,18.00,16.00,761.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(83,'Lace-Up Combat Boots',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','1J-156-A0-A1',0,15,0,1,0,1,1,0,921,NULL,NULL,NULL,13.00,18.00,16.00,761.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(84,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','ZN-197-A0',0,19,0,1,0,4,1,0,1190,NULL,NULL,NULL,20.00,19.00,14.00,678.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(85,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','ZN-197-A0-A1',0,19,0,1,0,4,1,0,1190,NULL,NULL,NULL,20.00,19.00,14.00,678.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(86,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','ZN-197-A0-A2',0,19,0,1,0,4,1,0,1190,NULL,NULL,NULL,20.00,19.00,14.00,678.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(87,'Printed Palazzo Pants',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','LQ-148-A0',0,15,0,1,0,1,1,0,2386,NULL,NULL,NULL,12.00,15.00,14.00,601.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(88,'Printed Palazzo Pants',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','LQ-148-A0-A1',0,15,0,1,0,1,1,0,2386,NULL,NULL,NULL,12.00,15.00,14.00,601.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(89,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','3W-199-A0',0,14,0,1,0,5,1,0,1076,763.96,NULL,NULL,18.00,10.00,13.00,666.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(90,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','3W-199-A0-A1',0,14,0,1,0,5,1,0,1076,893.08,NULL,NULL,18.00,10.00,13.00,666.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(91,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','3W-199-A0-A2',0,14,0,1,0,5,1,0,1076,828.52,NULL,NULL,18.00,10.00,13.00,666.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(92,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','WA-178-A0',0,16,0,1,0,4,1,0,1749,NULL,NULL,NULL,15.00,16.00,12.00,749.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(93,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','WA-178-A0-A1',0,16,0,1,0,4,1,0,1749,NULL,NULL,NULL,15.00,16.00,12.00,749.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(94,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','WA-178-A0-A2',0,16,0,1,0,4,1,0,1749,NULL,NULL,NULL,15.00,16.00,12.00,749.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(95,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','OF-183-A0',0,18,0,1,0,1,1,0,641,NULL,NULL,NULL,17.00,14.00,13.00,852.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(96,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','OF-183-A0-A1',0,18,0,1,0,1,1,0,641,NULL,NULL,NULL,17.00,14.00,13.00,852.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(97,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','LW-179-A0',0,13,0,1,0,1,1,0,1095,NULL,NULL,NULL,20.00,18.00,18.00,584.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(98,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','LW-179-A0-A1',0,13,0,1,0,1,1,0,1095,NULL,NULL,NULL,20.00,18.00,18.00,584.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(99,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','LW-179-A0-A2',0,13,0,1,0,1,1,0,1095,NULL,NULL,NULL,20.00,18.00,18.00,584.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(100,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','LW-179-A0-A3',0,13,0,1,0,1,1,0,1095,NULL,NULL,NULL,20.00,18.00,18.00,584.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(101,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','3I-116-A0',0,20,0,1,0,1,1,0,2174,1521.8,NULL,NULL,10.00,18.00,12.00,868.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(102,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','3I-116-A0-A1',0,20,0,1,0,1,1,0,2174,1717.46,NULL,NULL,10.00,18.00,12.00,868.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(103,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','3I-116-A0-A2',0,20,0,1,0,1,1,0,2174,1826.16,NULL,NULL,10.00,18.00,12.00,868.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(104,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','3I-116-A0-A3',0,20,0,1,0,1,1,0,2174,1717.46,NULL,NULL,10.00,18.00,12.00,868.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(105,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','HV-127-A0',0,13,0,1,0,3,1,0,2410,NULL,NULL,NULL,16.00,15.00,18.00,684.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(106,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','R7-154-A0',0,10,0,1,0,1,1,0,1467,NULL,NULL,NULL,15.00,18.00,17.00,846.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(107,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','R7-154-A0-A1',0,10,0,1,0,1,1,0,1467,NULL,NULL,NULL,15.00,18.00,17.00,846.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(108,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','R7-154-A0-A2',0,10,0,1,0,1,1,0,1467,NULL,NULL,NULL,15.00,18.00,17.00,846.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(109,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','LK-137-A0',0,16,0,1,0,1,1,0,2332,NULL,NULL,NULL,17.00,17.00,16.00,838.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(110,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','W2-104-A0',0,18,0,1,0,4,1,0,478,344.16,NULL,NULL,10.00,15.00,10.00,713.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(111,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','W2-104-A0-A1',0,18,0,1,0,4,1,0,478,382.4,NULL,NULL,10.00,15.00,10.00,713.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(112,'Ruffled Wrap Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','7J-122-A0',0,13,0,1,0,5,1,0,1541,NULL,NULL,NULL,18.00,11.00,12.00,554.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(113,'Ruffled Wrap Dress',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','7J-122-A0-A1',0,13,0,1,0,5,1,0,1541,NULL,NULL,NULL,18.00,11.00,12.00,554.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(114,'Beaded Evening Clutch',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','DW-156-A0',0,19,0,1,0,2,1,0,1089,NULL,NULL,NULL,13.00,11.00,15.00,805.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(115,'Beaded Evening Clutch',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','DW-156-A0-A1',0,19,0,1,0,2,1,0,1089,NULL,NULL,NULL,13.00,11.00,15.00,805.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(116,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','RO-115-A0',0,15,0,1,0,1,1,0,446,NULL,NULL,NULL,14.00,18.00,15.00,835.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(117,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','RO-115-A0-A1',0,15,0,1,0,1,1,0,446,NULL,NULL,NULL,14.00,18.00,15.00,835.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(118,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','RO-115-A0-A2',0,15,0,1,0,1,1,0,446,NULL,NULL,NULL,14.00,18.00,15.00,835.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(119,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','RO-115-A0-A3',0,15,0,1,0,1,1,0,446,NULL,NULL,NULL,14.00,18.00,15.00,835.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(120,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','HD-143-A0',0,17,0,1,0,5,1,0,2134,1643.18,NULL,NULL,14.00,11.00,11.00,828.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(121,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','HD-143-A0-A1',0,17,0,1,0,5,1,0,2134,1515.14,NULL,NULL,14.00,11.00,11.00,828.00,NULL,0,'2024-03-15 03:01:47','2024-03-15 03:01:47','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(122,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','HD-143-A0-A2',0,17,0,1,0,5,1,0,2134,1899.26,NULL,NULL,14.00,11.00,11.00,828.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(123,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','HD-143-A0-A3',0,17,0,1,0,5,1,0,2134,1685.86,NULL,NULL,14.00,11.00,11.00,828.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(124,'Embellished Ballet Flats',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','ZX-108-A0',0,13,0,1,0,1,1,0,334,NULL,NULL,NULL,11.00,12.00,17.00,698.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(125,'Embellished Ballet Flats',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','ZX-108-A0-A1',0,13,0,1,0,1,1,0,334,NULL,NULL,NULL,11.00,12.00,17.00,698.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(126,'Embellished Ballet Flats',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','ZX-108-A0-A2',0,13,0,1,0,1,1,0,334,NULL,NULL,NULL,11.00,12.00,17.00,698.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(127,'Embellished Ballet Flats',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','ZX-108-A0-A3',0,13,0,1,0,1,1,0,334,NULL,NULL,NULL,11.00,12.00,17.00,698.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(128,'Embellished Ballet Flats',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','ZX-108-A0-A4',0,13,0,1,0,1,1,0,334,NULL,NULL,NULL,11.00,12.00,17.00,698.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(129,'Pleated Midi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','TJ-150-A0',0,10,0,1,0,1,1,0,689,NULL,NULL,NULL,14.00,20.00,15.00,683.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(130,'Velour Tracksuit Set',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','MT-110-A0',0,17,0,1,0,2,1,0,1258,NULL,NULL,NULL,14.00,12.00,11.00,603.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(131,'Velour Tracksuit Set',NULL,NULL,'published','[\"fashion\\/products\\/product-4.png\"]','MT-110-A0-A1',0,17,0,1,0,2,1,0,1258,NULL,NULL,NULL,14.00,12.00,11.00,603.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(132,'Velour Tracksuit Set',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','MT-110-A0-A2',0,17,0,1,0,2,1,0,1258,NULL,NULL,NULL,14.00,12.00,11.00,603.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(133,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','TN-107-A0',0,20,0,1,0,3,1,0,1993,1395.1,NULL,NULL,15.00,17.00,13.00,817.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(134,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','TN-107-A0-A1',0,20,0,1,0,3,1,0,1993,1415.03,NULL,NULL,15.00,17.00,13.00,817.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(135,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','YM-108-A0',0,20,0,1,0,5,1,0,398,NULL,NULL,NULL,10.00,11.00,13.00,654.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(136,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','YM-108-A0-A1',0,20,0,1,0,5,1,0,398,NULL,NULL,NULL,10.00,11.00,13.00,654.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(137,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','K9-161-A0',0,15,0,1,0,5,1,0,2449,NULL,NULL,NULL,19.00,14.00,14.00,630.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(138,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','K9-161-A0-A1',0,15,0,1,0,5,1,0,2449,NULL,NULL,NULL,19.00,14.00,14.00,630.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(139,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','GI-187-A0',0,15,0,1,0,3,1,0,341,NULL,NULL,NULL,20.00,12.00,11.00,564.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(140,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','GI-187-A0-A1',0,15,0,1,0,3,1,0,341,NULL,NULL,NULL,20.00,12.00,11.00,564.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(141,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"fashion\\/products\\/product-8.png\"]','GI-187-A0-A2',0,15,0,1,0,3,1,0,341,NULL,NULL,NULL,20.00,12.00,11.00,564.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(142,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','LW-185-A0',0,13,0,1,0,4,1,0,2471,1828.54,NULL,NULL,15.00,17.00,11.00,828.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(143,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"fashion\\/products\\/product-3.png\"]','LW-185-A0-A1',0,13,0,1,0,4,1,0,2471,2174.48,NULL,NULL,15.00,17.00,11.00,828.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(144,'Retro High-Top Sneakers',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','XP-105-A0',0,10,0,1,0,2,1,0,517,NULL,NULL,NULL,18.00,12.00,15.00,863.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(145,'Retro High-Top Sneakers',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','XP-105-A0-A1',0,10,0,1,0,2,1,0,517,NULL,NULL,NULL,18.00,12.00,15.00,863.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(146,'Retro High-Top Sneakers',NULL,NULL,'published','[\"fashion\\/products\\/product-1.png\"]','XP-105-A0-A2',0,10,0,1,0,2,1,0,517,NULL,NULL,NULL,18.00,12.00,15.00,863.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(147,'Faux Leather Leggings',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','76-108-A0',0,18,0,1,0,2,1,0,1516,NULL,NULL,NULL,10.00,20.00,16.00,681.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(148,'Faux Leather Leggings',NULL,NULL,'published','[\"fashion\\/products\\/product-6.png\"]','76-108-A0-A1',0,18,0,1,0,2,1,0,1516,NULL,NULL,NULL,10.00,20.00,16.00,681.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(149,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','N7-144-A0',0,13,0,1,0,3,1,0,1048,NULL,NULL,NULL,17.00,20.00,16.00,589.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(150,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-5.png\"]','N7-144-A0-A1',0,13,0,1,0,3,1,0,1048,NULL,NULL,NULL,17.00,20.00,16.00,589.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(151,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-7.png\"]','N7-144-A0-A2',0,13,0,1,0,3,1,0,1048,NULL,NULL,NULL,17.00,20.00,16.00,589.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(152,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"fashion\\/products\\/product-2.png\"]','N7-144-A0-A3',0,13,0,1,0,3,1,0,1048,NULL,NULL,NULL,17.00,20.00,16.00,589.00,NULL,0,'2024-03-15 03:01:48','2024-03-15 03:01:48','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,5,15,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\"]'),(2,4,24,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\"]'),(3,1,14,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(4,1,17,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\"]'),(5,5,34,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\"]'),(6,4,6,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(7,1,7,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(8,4,35,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\"]'),(9,6,30,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\"]'),(10,10,11,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(11,9,43,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(12,6,42,3.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(13,6,43,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\"]'),(14,9,1,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(15,6,23,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(16,6,16,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(18,7,40,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\"]'),(19,5,33,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(20,9,20,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(21,5,10,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(22,10,2,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(23,1,15,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\"]'),(24,8,30,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]'),(25,3,23,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(26,3,6,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(27,3,34,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\"]'),(28,3,12,1.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(30,7,8,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(31,1,20,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\"]'),(32,5,1,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(33,8,23,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(34,7,9,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(35,6,31,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(36,4,20,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(37,2,12,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(41,10,35,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(42,1,42,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\"]'),(43,10,12,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(44,4,43,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(46,10,19,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-18.jpg\"]'),(47,4,22,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(48,7,37,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(49,9,23,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-19.jpg\"]'),(50,9,31,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(51,8,17,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(52,5,21,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\"]'),(53,2,40,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\"]'),(54,1,35,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-20.jpg\"]'),(55,10,41,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(56,10,18,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(57,6,15,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(58,6,28,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\"]'),(59,10,43,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\"]'),(60,7,39,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\"]'),(61,1,12,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(62,9,13,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(63,8,29,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(64,7,27,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\"]'),(65,1,30,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(66,3,40,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\"]'),(67,5,3,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\"]'),(68,8,43,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-20.jpg\"]'),(69,9,11,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(70,2,42,3.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(71,8,1,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\"]'),(72,2,16,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(73,2,13,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\"]'),(74,7,26,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\"]'),(75,2,2,5.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\"]'),(76,4,37,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(77,8,5,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(78,2,38,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\"]'),(80,6,33,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(81,9,21,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(82,4,2,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(83,2,43,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(84,5,39,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(86,2,27,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(87,10,10,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\"]'),(90,2,5,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\"]'),(92,5,19,5.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(93,3,16,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(94,8,36,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(95,8,39,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(96,8,13,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(98,5,32,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(99,8,3,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(100,7,14,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\"]'),(101,6,3,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(102,4,31,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(103,4,19,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(104,4,40,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(106,6,13,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\"]'),(107,7,12,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(109,7,22,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(111,1,16,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(112,2,11,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(113,2,6,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(114,10,34,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(115,3,43,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(116,7,18,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(120,2,14,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\"]'),(121,7,15,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\"]'),(122,4,12,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\"]'),(124,5,23,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\"]'),(125,3,13,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(126,3,9,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(127,9,27,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(130,10,13,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\"]'),(131,10,32,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(132,9,10,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(133,10,27,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(135,2,41,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(136,8,7,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(138,9,42,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(140,9,34,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(142,3,15,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(145,10,8,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\"]'),(147,8,12,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(150,1,25,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(151,3,28,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\"]'),(152,10,3,2.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(153,9,29,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(155,8,31,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(156,3,4,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\"]'),(157,9,8,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\"]'),(158,5,25,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\"]'),(159,3,30,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(162,5,18,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\"]'),(165,8,18,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(166,6,37,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\"]'),(167,3,33,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(171,8,35,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(172,8,28,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\"]'),(173,2,31,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(174,10,22,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(175,4,34,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(179,2,15,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\"]'),(180,1,2,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(181,7,11,1.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\"]'),(183,2,4,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\"]'),(184,8,27,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(185,5,42,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\"]'),(186,2,34,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(187,3,42,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(188,1,8,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(190,4,11,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(191,6,8,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\"]'),(193,4,16,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(196,5,6,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(197,3,36,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(198,8,20,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(200,7,5,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(201,7,4,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(202,7,41,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-20.jpg\"]'),(203,7,19,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\"]'),(204,7,43,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(206,5,41,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\"]'),(207,7,3,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\"]'),(208,7,24,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(209,10,36,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\"]'),(210,1,5,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(211,4,36,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(212,8,2,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(216,1,31,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\"]'),(217,6,17,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\"]'),(218,2,30,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\"]'),(220,9,6,1.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(221,3,21,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(222,3,38,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\"]'),(224,4,15,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\"]'),(225,6,1,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(228,2,22,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(231,1,3,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(233,6,34,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\"]'),(234,10,14,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(237,5,7,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(238,1,11,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\"]'),(239,3,14,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(241,4,18,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(242,6,27,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\"]'),(243,6,22,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\"]'),(246,9,5,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\"]'),(247,1,34,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(249,1,36,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(252,1,9,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(254,4,9,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(255,4,26,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\"]'),(256,10,30,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(257,3,39,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(260,2,18,1.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-20.jpg\"]'),(261,2,26,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\"]'),(263,9,36,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(268,9,25,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(269,8,4,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(272,3,25,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(275,10,1,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(276,8,21,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(277,9,33,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(279,7,28,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\"]'),(280,3,22,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(281,8,16,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(282,6,26,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(286,1,23,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(287,7,2,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(288,2,28,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\"]'),(289,10,6,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(290,9,19,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(292,9,9,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\"]'),(295,6,9,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(297,10,24,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\"]'),(304,6,18,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(305,5,29,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(306,6,25,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(307,6,14,1.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(309,10,4,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(311,3,8,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-20.jpg\"]'),(312,3,31,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\"]'),(315,4,29,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(316,6,10,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(317,5,5,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-18.jpg\"]'),(318,8,11,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\"]'),(319,1,10,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\"]'),(322,6,6,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(324,8,22,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(325,1,4,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(327,7,23,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(328,7,32,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(329,8,19,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\"]'),(331,3,1,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(332,9,22,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(333,6,39,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(334,4,4,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(335,7,17,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\"]'),(336,7,30,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\"]'),(340,4,25,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\"]'),(341,4,32,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(343,4,39,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\"]'),(344,10,7,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\"]'),(346,4,8,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(348,7,42,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(349,7,21,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(351,5,36,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(357,2,33,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(361,1,13,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(362,9,17,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(365,2,25,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(366,3,24,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-18.jpg\"]'),(367,2,37,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(368,4,41,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\"]'),(370,5,13,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(371,8,41,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(372,8,25,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(376,3,11,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(378,9,41,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\"]'),(379,6,40,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(380,4,28,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(382,7,7,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(384,9,37,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(389,2,20,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(390,9,4,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-18.jpg\"]'),(397,2,24,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(398,5,16,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(399,1,29,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-17.jpg\"]'),(400,10,42,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(401,9,30,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(406,9,18,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(407,9,14,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(408,2,7,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(409,8,40,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(410,1,33,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(413,5,8,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(414,6,35,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(415,1,28,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(416,1,39,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]'),(417,6,24,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(418,4,30,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(420,6,36,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(425,6,4,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(429,5,27,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\"]'),(431,10,37,1.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(432,6,20,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\"]'),(433,7,1,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(434,8,6,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]'),(435,5,20,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(437,6,12,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(439,1,1,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\"]'),(449,5,35,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(453,3,29,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(462,9,28,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(471,6,5,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\"]'),(473,10,15,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(476,7,38,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\"]'),(477,1,6,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\"]'),(482,1,26,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(483,9,7,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\"]'),(494,8,37,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(495,4,23,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(506,2,8,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(511,10,5,4.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\"]'),(515,5,17,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(516,5,9,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\"]'),(521,8,24,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\"]'),(522,2,1,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\"]'),(524,2,17,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(525,2,19,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(526,9,39,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(527,7,31,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(531,10,29,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\"]'),(535,6,29,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(538,1,41,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\"]'),(539,5,38,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(540,1,24,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(543,9,40,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\"]'),(547,5,14,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(569,3,20,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\"]'),(570,5,37,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(577,2,3,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\"]'),(578,10,31,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\"]'),(579,6,38,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\"]'),(584,4,38,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\"]'),(587,4,17,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(590,1,18,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\"]'),(595,9,26,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(607,7,36,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\"]'),(610,3,2,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\"]'),(616,8,15,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(627,10,38,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(628,5,28,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\"]'),(629,5,26,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(630,8,10,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\"]'),(631,2,10,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(632,9,12,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(636,3,18,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\"]'),(644,4,21,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\"]'),(649,9,35,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(656,6,2,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(658,1,27,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-19.jpg\"]'),(665,8,34,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(666,7,10,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\"]'),(679,2,35,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-18.jpg\"]'),(683,9,38,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(688,1,40,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\"]'),(693,8,9,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(695,10,25,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(696,4,42,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(704,9,24,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(705,4,3,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(708,2,29,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\"]'),(710,9,2,1.00,'Clean & perfect source code','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(720,5,30,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(722,2,21,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\"]'),(726,5,24,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\"]'),(731,3,35,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-10.jpg\"]'),(743,9,15,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(745,9,32,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(749,3,41,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(753,7,16,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(755,9,16,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(759,2,32,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(762,10,33,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(784,4,5,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\"]'),(793,2,9,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(799,4,1,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-15.jpg\"]'),(802,5,40,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(814,3,5,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-13.jpg\"]'),(816,4,14,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\"]'),(817,8,32,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-19.jpg\"]'),(825,4,33,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\"]'),(833,10,26,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(837,2,23,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(838,10,40,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(841,1,32,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\"]'),(850,7,33,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(871,3,27,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\"]'),(904,10,39,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\"]'),(905,10,9,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(907,7,6,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(915,3,32,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(925,6,32,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(934,5,12,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\"]'),(937,1,19,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(943,8,42,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(949,7,35,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(950,6,21,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(960,5,4,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(972,3,37,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(988,5,43,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(993,6,7,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:02:20','2024-03-15 03:02:20','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,1,'2024-03-11 19:01:50','2024-03-11 19:01:50','Botble\\ACL\\Models\\User'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,1,'2024-03-13 11:01:50','2024-03-15 03:01:50','Botble\\ACL\\Models\\User'),(3,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,1,1,'2024-03-15 03:01:50','2024-03-15 03:01:50','Botble\\ACL\\Models\\User'),(4,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,1,'2024-03-15 03:01:50','2024-03-15 03:01:50','Botble\\ACL\\Models\\User'),(5,'create_from_order','Shipping was created from order %order_id%',0,2,2,'2024-02-27 11:01:50','2024-02-27 11:01:50','Botble\\ACL\\Models\\User'),(6,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,2,'2024-03-13 11:01:50','2024-03-15 03:01:50','Botble\\ACL\\Models\\User'),(7,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,2,'2024-03-15 03:01:50','2024-03-15 03:01:50','Botble\\ACL\\Models\\User'),(8,'create_from_order','Shipping was created from order %order_id%',0,3,3,'2024-03-13 13:01:50','2024-03-13 13:01:50','Botble\\ACL\\Models\\User'),(9,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,3,'2024-03-13 13:01:50','2024-03-15 03:01:50','Botble\\ACL\\Models\\User'),(10,'create_from_order','Shipping was created from order %order_id%',0,4,4,'2024-03-08 19:01:50','2024-03-08 19:01:50','Botble\\ACL\\Models\\User'),(11,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,4,'2024-03-13 13:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(12,'create_from_order','Shipping was created from order %order_id%',0,5,5,'2024-03-08 19:01:51','2024-03-08 19:01:51','Botble\\ACL\\Models\\User'),(13,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,5,'2024-03-13 13:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(14,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,5,5,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(15,'create_from_order','Shipping was created from order %order_id%',0,6,6,'2024-03-01 15:01:51','2024-03-01 15:01:51','Botble\\ACL\\Models\\User'),(16,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,6,'2024-03-13 15:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(17,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,6,6,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(18,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,6,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(19,'create_from_order','Shipping was created from order %order_id%',0,7,7,'2024-03-05 05:01:51','2024-03-05 05:01:51','Botble\\ACL\\Models\\User'),(20,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,7,'2024-03-13 17:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(21,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,7,7,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(22,'create_from_order','Shipping was created from order %order_id%',0,8,8,'2024-02-29 23:01:51','2024-02-29 23:01:51','Botble\\ACL\\Models\\User'),(23,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,8,'2024-03-13 17:01:51','2024-03-15 03:01:51','Botble\\ACL\\Models\\User'),(24,'create_from_order','Shipping was created from order %order_id%',0,9,9,'2024-03-04 11:01:51','2024-03-04 11:01:51','Botble\\ACL\\Models\\User'),(25,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,9,'2024-03-13 19:01:52','2024-03-15 03:01:52','Botble\\ACL\\Models\\User'),(26,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,9,'2024-03-15 03:01:52','2024-03-15 03:01:52','Botble\\ACL\\Models\\User'),(27,'create_from_order','Shipping was created from order %order_id%',0,10,10,'2024-03-07 03:01:52','2024-03-07 03:01:52','Botble\\ACL\\Models\\User'),(28,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,10,'2024-03-13 19:01:52','2024-03-15 03:01:52','Botble\\ACL\\Models\\User'),(29,'create_from_order','Shipping was created from order %order_id%',0,11,12,'2024-03-06 09:01:54','2024-03-06 09:01:54','Botble\\ACL\\Models\\User'),(30,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,12,'2024-03-13 21:01:54','2024-03-15 03:01:54','Botble\\ACL\\Models\\User'),(31,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,11,12,'2024-03-15 03:01:54','2024-03-15 03:01:54','Botble\\ACL\\Models\\User'),(32,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,12,'2024-03-15 03:01:54','2024-03-15 03:01:54','Botble\\ACL\\Models\\User'),(33,'create_from_order','Shipping was created from order %order_id%',0,12,13,'2024-03-03 11:01:54','2024-03-03 11:01:54','Botble\\ACL\\Models\\User'),(34,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,13,'2024-03-13 23:01:54','2024-03-15 03:01:54','Botble\\ACL\\Models\\User'),(35,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,12,13,'2024-03-15 03:01:54','2024-03-15 03:01:54','Botble\\ACL\\Models\\User'),(36,'create_from_order','Shipping was created from order %order_id%',0,13,15,'2024-03-05 19:01:55','2024-03-05 19:01:55','Botble\\ACL\\Models\\User'),(37,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,15,'2024-03-13 23:01:55','2024-03-15 03:01:55','Botble\\ACL\\Models\\User'),(38,'create_from_order','Shipping was created from order %order_id%',0,14,16,'2024-03-10 19:01:55','2024-03-10 19:01:55','Botble\\ACL\\Models\\User'),(39,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,16,'2024-03-14 01:01:55','2024-03-15 03:01:55','Botble\\ACL\\Models\\User'),(40,'create_from_order','Shipping was created from order %order_id%',0,15,17,'2024-03-12 23:01:55','2024-03-12 23:01:55','Botble\\ACL\\Models\\User'),(41,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,17,'2024-03-14 01:01:55','2024-03-15 03:01:55','Botble\\ACL\\Models\\User'),(42,'create_from_order','Shipping was created from order %order_id%',0,16,18,'2024-03-14 01:01:55','2024-03-14 01:01:55','Botble\\ACL\\Models\\User'),(43,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,18,'2024-03-14 01:01:55','2024-03-15 03:01:55','Botble\\ACL\\Models\\User'),(44,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,16,18,'2024-03-15 03:01:55','2024-03-15 03:01:55','Botble\\ACL\\Models\\User'),(45,'create_from_order','Shipping was created from order %order_id%',0,17,19,'2024-03-09 17:01:55','2024-03-09 17:01:55','Botble\\ACL\\Models\\User'),(46,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,19,'2024-03-14 01:01:56','2024-03-15 03:01:56','Botble\\ACL\\Models\\User'),(47,'create_from_order','Shipping was created from order %order_id%',0,18,20,'2024-03-05 03:01:56','2024-03-05 03:01:56','Botble\\ACL\\Models\\User'),(48,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,20,'2024-03-14 03:01:56','2024-03-15 03:01:56','Botble\\ACL\\Models\\User'),(49,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,20,'2024-03-15 03:01:56','2024-03-15 03:01:56','Botble\\ACL\\Models\\User'),(50,'create_from_order','Shipping was created from order %order_id%',0,19,21,'2024-03-10 03:01:56','2024-03-10 03:01:56','Botble\\ACL\\Models\\User'),(51,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,21,'2024-03-14 03:01:56','2024-03-15 03:01:56','Botble\\ACL\\Models\\User'),(52,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,21,'2024-03-15 03:01:56','2024-03-15 03:01:56','Botble\\ACL\\Models\\User'),(53,'create_from_order','Shipping was created from order %order_id%',0,20,22,'2024-03-13 03:01:56','2024-03-13 03:01:56','Botble\\ACL\\Models\\User'),(54,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,22,'2024-03-14 03:01:56','2024-03-15 03:01:56','Botble\\ACL\\Models\\User'),(55,'create_from_order','Shipping was created from order %order_id%',0,21,23,'2024-03-13 07:01:56','2024-03-13 07:01:56','Botble\\ACL\\Models\\User'),(56,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,23,'2024-03-14 05:01:57','2024-03-15 03:01:57','Botble\\ACL\\Models\\User'),(57,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,21,23,'2024-03-15 03:01:57','2024-03-15 03:01:57','Botble\\ACL\\Models\\User'),(58,'create_from_order','Shipping was created from order %order_id%',0,22,25,'2024-03-11 11:01:57','2024-03-11 11:01:57','Botble\\ACL\\Models\\User'),(59,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,25,'2024-03-14 05:01:57','2024-03-15 03:01:57','Botble\\ACL\\Models\\User'),(60,'create_from_order','Shipping was created from order %order_id%',0,23,28,'2024-03-14 09:01:57','2024-03-14 09:01:57','Botble\\ACL\\Models\\User'),(61,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,28,'2024-03-14 09:01:58','2024-03-15 03:01:58','Botble\\ACL\\Models\\User'),(62,'create_from_order','Shipping was created from order %order_id%',0,24,30,'2024-03-11 09:01:58','2024-03-11 09:01:58','Botble\\ACL\\Models\\User'),(63,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,30,'2024-03-14 09:01:58','2024-03-15 03:01:58','Botble\\ACL\\Models\\User'),(64,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,30,'2024-03-15 03:01:58','2024-03-15 03:01:58','Botble\\ACL\\Models\\User'),(65,'create_from_order','Shipping was created from order %order_id%',0,25,32,'2024-03-10 11:01:58','2024-03-10 11:01:58','Botble\\ACL\\Models\\User'),(66,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,32,'2024-03-14 11:01:59','2024-03-15 03:01:59','Botble\\ACL\\Models\\User'),(67,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,25,32,'2024-03-15 03:01:59','2024-03-15 03:01:59','Botble\\ACL\\Models\\User'),(68,'create_from_order','Shipping was created from order %order_id%',0,26,33,'2024-03-09 03:01:59','2024-03-09 03:01:59','Botble\\ACL\\Models\\User'),(69,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,33,'2024-03-14 11:01:59','2024-03-15 03:01:59','Botble\\ACL\\Models\\User'),(70,'create_from_order','Shipping was created from order %order_id%',0,27,35,'2024-03-09 21:01:59','2024-03-09 21:01:59','Botble\\ACL\\Models\\User'),(71,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,35,'2024-03-14 13:01:59','2024-03-15 03:01:59','Botble\\ACL\\Models\\User'),(72,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,27,35,'2024-03-15 03:01:59','2024-03-15 03:01:59','Botble\\ACL\\Models\\User'),(73,'create_from_order','Shipping was created from order %order_id%',0,28,37,'2024-03-12 19:01:59','2024-03-12 19:01:59','Botble\\ACL\\Models\\User'),(74,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,37,'2024-03-14 13:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(75,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,28,37,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(76,'create_from_order','Shipping was created from order %order_id%',0,29,39,'2024-03-13 15:02:00','2024-03-13 15:02:00','Botble\\ACL\\Models\\User'),(77,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,39,'2024-03-14 15:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(78,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,29,39,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(79,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,39,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(80,'create_from_order','Shipping was created from order %order_id%',0,30,40,'2024-03-13 11:02:00','2024-03-13 11:02:00','Botble\\ACL\\Models\\User'),(81,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,40,'2024-03-14 17:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(82,'create_from_order','Shipping was created from order %order_id%',0,31,41,'2024-03-13 21:02:00','2024-03-13 21:02:00','Botble\\ACL\\Models\\User'),(83,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,41,'2024-03-14 17:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(84,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,31,41,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\ACL\\Models\\User'),(85,'create_from_order','Shipping was created from order %order_id%',0,32,43,'2024-03-11 19:02:01','2024-03-11 19:02:01','Botble\\ACL\\Models\\User'),(86,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,43,'2024-03-14 19:02:01','2024-03-15 03:02:01','Botble\\ACL\\Models\\User'),(87,'create_from_order','Shipping was created from order %order_id%',0,33,44,'2024-03-13 21:02:01','2024-03-13 21:02:01','Botble\\ACL\\Models\\User'),(88,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,44,'2024-03-14 21:02:01','2024-03-15 03:02:01','Botble\\ACL\\Models\\User'),(89,'create_from_order','Shipping was created from order %order_id%',0,34,46,'2024-03-14 09:02:01','2024-03-14 09:02:01','Botble\\ACL\\Models\\User'),(90,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,46,'2024-03-14 21:02:01','2024-03-15 03:02:01','Botble\\ACL\\Models\\User'),(91,'create_from_order','Shipping was created from order %order_id%',0,35,47,'2024-03-13 15:02:01','2024-03-13 15:02:01','Botble\\ACL\\Models\\User'),(92,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,47,'2024-03-14 21:02:02','2024-03-15 03:02:02','Botble\\ACL\\Models\\User'),(93,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,47,'2024-03-15 03:02:02','2024-03-15 03:02:02','Botble\\ACL\\Models\\User'),(94,'create_from_order','Shipping was created from order %order_id%',0,36,48,'2024-03-13 19:02:02','2024-03-13 19:02:02','Botble\\ACL\\Models\\User'),(95,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,48,'2024-03-14 23:02:02','2024-03-15 03:02:02','Botble\\ACL\\Models\\User'),(96,'create_from_order','Shipping was created from order %order_id%',0,37,49,'2024-03-14 23:02:02','2024-03-14 23:02:02','Botble\\ACL\\Models\\User'),(97,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,49,'2024-03-14 23:02:02','2024-03-15 03:02:02','Botble\\ACL\\Models\\User'),(98,'create_from_order','Shipping was created from order %order_id%',0,38,51,'2024-03-14 19:02:02','2024-03-14 19:02:02','Botble\\ACL\\Models\\User'),(99,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,38,51,'2024-03-14 23:02:02','2024-03-15 03:02:02','Botble\\ACL\\Models\\User'),(100,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,38,51,'2024-03-15 03:02:02','2024-03-15 03:02:02','Botble\\ACL\\Models\\User'),(101,'create_from_order','Shipping was created from order %order_id%',0,39,52,'2024-03-14 17:02:02','2024-03-14 17:02:02','Botble\\ACL\\Models\\User'),(102,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,39,52,'2024-03-15 01:02:03','2024-03-15 03:02:03','Botble\\ACL\\Models\\User'),(103,'create_from_order','Shipping was created from order %order_id%',0,40,54,'2024-03-14 17:02:03','2024-03-14 17:02:03','Botble\\ACL\\Models\\User'),(104,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,40,54,'2024-03-15 01:02:03','2024-03-15 03:02:03','Botble\\ACL\\Models\\User'),(105,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,54,'2024-03-15 03:02:03','2024-03-15 03:02:03','Botble\\ACL\\Models\\User');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,1,NULL,1116.00,NULL,NULL,'','delivered',648.00,'completed','pending',0.00,0,'2024-03-15 03:01:50','2024-03-15 03:01:50','JJD0030420693','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:01:50','2024-03-15 10:01:50',NULL,NULL),(2,2,NULL,1962.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:50','2024-03-15 03:01:50','JJD0015121952','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:01:50','2024-03-15 10:01:50',NULL,NULL),(3,3,NULL,554.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:50','2024-03-15 03:01:50','JJD0042361311','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:01:50',NULL,NULL,NULL),(4,4,NULL,1206.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','JJD0052907543','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:01:51',NULL,NULL,NULL),(5,5,NULL,863.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','JJD0075455192','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:01:51','2024-03-15 10:01:51',NULL,NULL),(6,6,NULL,2372.00,NULL,NULL,'','delivered',5629.00,'completed','pending',0.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','JJD0075391944','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:01:51','2024-03-15 10:01:51',NULL,NULL),(7,7,NULL,2859.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','JJD0093079669','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:01:51','2024-03-15 10:01:51',NULL,NULL),(8,8,NULL,709.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:51','2024-03-15 03:01:51','JJD0046282239','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:01:51',NULL,NULL,NULL),(9,9,NULL,1240.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:52','2024-03-15 03:01:52','JJD0013209084','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:01:52','2024-03-15 10:01:52',NULL,NULL),(10,10,NULL,1260.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:52','2024-03-15 03:01:52','JJD0037895155','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:01:52',NULL,NULL,NULL),(11,12,NULL,1308.00,NULL,NULL,'','delivered',796.00,'completed','pending',0.00,0,'2024-03-15 03:01:54','2024-03-15 03:01:54','JJD0049788458','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:01:54','2024-03-15 10:01:54',NULL,NULL),(12,13,NULL,2654.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:54','2024-03-15 03:01:54','JJD0050070899','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:01:54','2024-03-15 10:01:54',NULL,NULL),(13,15,NULL,835.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','JJD0053333711','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:01:55',NULL,NULL,NULL),(14,16,NULL,1674.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','JJD005070410','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:01:55',NULL,NULL,NULL),(15,17,NULL,1240.00,NULL,NULL,'','approved',4688.00,'pending','pending',0.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','JJD0071964210','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:01:55',NULL,NULL,NULL),(16,18,NULL,1670.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:55','2024-03-15 03:01:55','JJD0086025125','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:01:55','2024-03-15 10:01:55',NULL,NULL),(17,19,NULL,1890.00,NULL,NULL,'','approved',7347.00,'pending','pending',0.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','JJD0013294929','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:01:56',NULL,NULL,NULL),(18,20,NULL,1594.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','JJD0098618648','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:01:56','2024-03-15 10:01:56',NULL,NULL),(19,21,NULL,584.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','JJD009042140','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:01:56','2024-03-15 10:01:56',NULL,NULL),(20,22,NULL,2505.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:56','2024-03-15 03:01:56','JJD0029108746','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:01:56',NULL,NULL,NULL),(21,23,NULL,1890.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:57','2024-03-15 03:01:57','JJD0074563465','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:01:57','2024-03-15 10:01:57',NULL,NULL),(22,25,NULL,1726.00,NULL,NULL,'','approved',1034.00,'pending','pending',0.00,0,'2024-03-15 03:01:57','2024-03-15 03:01:57','JJD0015086002','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:01:57',NULL,NULL,NULL),(23,28,NULL,1418.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:58','2024-03-15 03:01:58','JJD0061056297','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:01:58',NULL,NULL,NULL),(24,30,NULL,1692.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:58','2024-03-15 03:01:58','JJD0029567381','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:01:58','2024-03-15 10:01:58',NULL,NULL),(25,32,NULL,2538.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','JJD0079266208','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:01:59','2024-03-15 10:01:59',NULL,NULL),(26,33,NULL,1206.00,NULL,NULL,'','approved',2516.00,'pending','pending',0.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','JJD0027689228','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:01:59',NULL,NULL,NULL),(27,35,NULL,1168.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:01:59','2024-03-15 03:01:59','JJD0073829873','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:01:59','2024-03-15 10:01:59',NULL,NULL),(28,37,NULL,1767.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','JJD0043323495','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:02:00','2024-03-15 10:02:00',NULL,NULL),(29,39,NULL,1431.00,NULL,NULL,'','delivered',3392.00,'completed','pending',0.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','JJD0054934393','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:02:00','2024-03-15 10:02:00',NULL,NULL),(30,40,NULL,1809.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','JJD0077899559','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:00',NULL,NULL,NULL),(31,41,NULL,1767.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:00','2024-03-15 03:02:00','JJD0089318687','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:02:00','2024-03-15 10:02:00',NULL,NULL),(32,43,NULL,1767.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','JJD0062347405','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:02:01',NULL,NULL,NULL),(33,44,NULL,887.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','JJD0016581639','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:01',NULL,NULL,NULL),(34,46,NULL,1670.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:01','2024-03-15 03:02:01','JJD0064265224','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:02:01',NULL,NULL,NULL),(35,47,NULL,603.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','JJD0056850145','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:02:02','2024-03-15 10:02:02',NULL,NULL),(36,48,NULL,582.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','JJD0075099810','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:02:02',NULL,NULL,NULL),(37,49,NULL,1498.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','JJD0049388440','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:02:02',NULL,NULL,NULL),(38,51,NULL,1308.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:02','2024-03-15 03:02:02','JJD0057514761','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:02:02','2024-03-15 10:02:02',NULL,NULL),(39,52,NULL,2034.00,NULL,NULL,'','approved',3570.00,'pending','pending',0.00,0,'2024-03-15 03:02:03','2024-03-15 03:02:03','JJD0073181719','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:02:03',NULL,NULL,NULL),(40,54,NULL,654.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:02:03','2024-03-15 03:02:03','JJD001595461','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:02:03','2024-03-15 10:02:03',NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2024-03-15 03:01:39','2024-03-15 03:01:39');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',0.00,NULL,0.00,'2024-03-15 03:01:39','2024-03-15 03:01:39');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Shofy','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2024-03-15 03:01:41','2024-03-15 03:01:41');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,3),(1,6),(1,10),(1,11),(1,17),(1,27),(1,28),(1,29),(1,31),(1,34),(1,36),(1,41),(1,43),(2,2),(2,4),(2,7),(2,9),(2,13),(2,14),(2,15),(2,16),(2,18),(2,19),(2,20),(2,21),(2,25),(2,26),(2,30),(2,32),(2,35),(2,37),(2,38),(2,39),(2,40),(3,1),(3,5),(3,8),(3,12),(3,22),(3,23),(3,24),(3,33),(3,42);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2024-03-15 03:01:39','2024-03-15 03:01:39'),(2,'None',0.000000,2,'published','2024-03-15 03:01:39','2024-03-15 03:01:39'),(3,'Import Tax',15.000000,3,'published','2024-03-15 03:01:39','2024-03-15 03:01:39');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(2,'PAYMENT',1,'published','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(3,'ORDER &amp; RETURNS',2,'published','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2024-03-15 03:01:35','2024-03-15 03:01:35'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2024-03-15 03:01:35','2024-03-15 03:01:35');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Perfect','French lesson-book. The Mouse did not get dry very soon. \'Ahem!\' said the King, the Queen, in a day or two: wouldn\'t it be of any use, now,\' thought Alice, \'they\'re sure to make the arches. The.',1,0,'fashion/galleries/1.jpg',1,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(2,'New Day','Alice called after it; and the pattern on their backs was the King; and as Alice could see it trot away quietly into the open air. \'IF I don\'t think,\' Alice went on growing, and, as there was no.',1,0,'fashion/galleries/2.jpg',1,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(3,'Happy Day','Dormouse crossed the court, arm-in-arm with the Dormouse. \'Write that down,\' the King repeated angrily, \'or I\'ll have you executed, whether you\'re nervous or not.\' \'I\'m a poor man, your Majesty,\' he.',1,0,'fashion/galleries/3.jpg',1,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(4,'Nature','She took down a very humble tone, going down on the song, perhaps?\' \'I\'ve heard something like this:-- \'Fury said to herself \'That\'s quite enough--I hope I shan\'t grow any more--As it is, I can\'t.',1,0,'fashion/galleries/4.jpg',1,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(5,'Morning','This did not venture to say but \'It belongs to the executioner: \'fetch her here.\' And the executioner ran wildly up and to her ear. \'You\'re thinking about something, my dear, I think?\' \'I had NOT!\'.',1,0,'fashion/galleries/5.jpg',1,'published','2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"fashion\\/galleries\\/4.jpg\",\"description\":\"Eaglet, and several other curious creatures. Alice led the way, and nothing seems to be patted on the ground near the King was the only difficulty was, that you never tasted an egg!\' \'I HAVE tasted.\"},{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"Alice went on eagerly. \'That\'s enough about lessons,\' the Gryphon went on. \'I do,\' Alice said nothing: she had wept when she noticed a curious dream!\' said Alice, and sighing. \'It IS a long tail.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"She did not dare to disobey, though she knew the right size for going through the glass, and she went on again:-- \'You may go,\' said the Hatter: \'let\'s all move one place on.\' He moved on as he said.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:01:49','2024-03-15 03:01:49'),(2,'[{\"img\":\"fashion\\/galleries\\/4.jpg\",\"description\":\"Eaglet, and several other curious creatures. Alice led the way, and nothing seems to be patted on the ground near the King was the only difficulty was, that you never tasted an egg!\' \'I HAVE tasted.\"},{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"Alice went on eagerly. \'That\'s enough about lessons,\' the Gryphon went on. \'I do,\' Alice said nothing: she had wept when she noticed a curious dream!\' said Alice, and sighing. \'It IS a long tail.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"She did not dare to disobey, though she knew the right size for going through the glass, and she went on again:-- \'You may go,\' said the Hatter: \'let\'s all move one place on.\' He moved on as he said.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:01:49','2024-03-15 03:01:49'),(3,'[{\"img\":\"fashion\\/galleries\\/4.jpg\",\"description\":\"Eaglet, and several other curious creatures. Alice led the way, and nothing seems to be patted on the ground near the King was the only difficulty was, that you never tasted an egg!\' \'I HAVE tasted.\"},{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"Alice went on eagerly. \'That\'s enough about lessons,\' the Gryphon went on. \'I do,\' Alice said nothing: she had wept when she noticed a curious dream!\' said Alice, and sighing. \'It IS a long tail.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"She did not dare to disobey, though she knew the right size for going through the glass, and she went on again:-- \'You may go,\' said the Hatter: \'let\'s all move one place on.\' He moved on as he said.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:01:49','2024-03-15 03:01:49'),(4,'[{\"img\":\"fashion\\/galleries\\/4.jpg\",\"description\":\"Eaglet, and several other curious creatures. Alice led the way, and nothing seems to be patted on the ground near the King was the only difficulty was, that you never tasted an egg!\' \'I HAVE tasted.\"},{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"Alice went on eagerly. \'That\'s enough about lessons,\' the Gryphon went on. \'I do,\' Alice said nothing: she had wept when she noticed a curious dream!\' said Alice, and sighing. \'It IS a long tail.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"She did not dare to disobey, though she knew the right size for going through the glass, and she went on again:-- \'You may go,\' said the Hatter: \'let\'s all move one place on.\' He moved on as he said.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:01:49','2024-03-15 03:01:49'),(5,'[{\"img\":\"fashion\\/galleries\\/4.jpg\",\"description\":\"Eaglet, and several other curious creatures. Alice led the way, and nothing seems to be patted on the ground near the King was the only difficulty was, that you never tasted an egg!\' \'I HAVE tasted.\"},{\"img\":\"fashion\\/galleries\\/1.jpg\",\"description\":\"Alice went on eagerly. \'That\'s enough about lessons,\' the Gryphon went on. \'I do,\' Alice said nothing: she had wept when she noticed a curious dream!\' said Alice, and sighing. \'It IS a long tail.\"},{\"img\":\"fashion\\/galleries\\/2.jpg\",\"description\":\"She did not dare to disobey, though she knew the right size for going through the glass, and she went on again:-- \'You may go,\' said the Hatter: \'let\'s all move one place on.\' He moved on as he said.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','b9e4b647f57fc7e363d10afc8e8a1f9d',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','0368c0dc78bdd23c838d14331882dc6e',1,'Botble\\Menu\\Models\\MenuLocation'),(3,'en_US','9b4d12ab083732c4786d609bfacfdedb',1,'Botble\\Menu\\Models\\Menu'),(4,'en_US','7f95e808c2442bae617d4a1bb828f891',2,'Botble\\Menu\\Models\\Menu'),(5,'en_US','1d6994d2275ffb7d71ea1b29b53bdb54',3,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'404','404',2,'image/png',15820,'main/general/404.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(2,0,'about-1','about-1',2,'image/jpeg',9222,'main/general/about-1.jpg','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(3,0,'about-2','about-2',2,'image/jpeg',5105,'main/general/about-2.jpg','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(4,0,'breadcrumb','breadcrumb',2,'image/jpeg',5276,'main/general/breadcrumb.jpg','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(5,0,'cta-shape-1','cta-shape-1',2,'image/png',22860,'main/general/cta-shape-1.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(6,0,'cta-shape-2','cta-shape-2',2,'image/png',16796,'main/general/cta-shape-2.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(7,0,'cta-thumb-1','cta-thumb-1',2,'image/jpeg',6053,'main/general/cta-thumb-1.jpg','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(8,0,'favicon','favicon',2,'image/png',1831,'main/general/favicon.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(9,0,'footer-pay','footer-pay',2,'image/png',490,'main/general/footer-pay.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(10,0,'logo-white','logo-white',2,'image/png',22020,'main/general/logo-white.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(11,0,'logo','logo',2,'image/png',22398,'main/general/logo.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(12,0,'newsletter-popup','newsletter-popup',2,'image/png',17253,'main/general/newsletter-popup.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(13,0,'placeholder','placeholder',2,'image/png',2100,'main/general/placeholder.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(14,0,'preloader-icon','preloader-icon',2,'image/png',4182,'main/general/preloader-icon.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(15,0,'signature','signature',2,'image/png',2117,'main/general/signature.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(16,0,'slider-offer','slider-offer',2,'image/png',970,'main/general/slider-offer.png','[]','2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(27,0,'1','1',4,'image/jpeg',4294,'main/customers/1.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(28,0,'10','10',4,'image/jpeg',4294,'main/customers/10.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(29,0,'2','2',4,'image/jpeg',4294,'main/customers/2.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(30,0,'3','3',4,'image/jpeg',4294,'main/customers/3.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(31,0,'4','4',4,'image/jpeg',4294,'main/customers/4.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(32,0,'5','5',4,'image/jpeg',4294,'main/customers/5.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(33,0,'6','6',4,'image/jpeg',4294,'main/customers/6.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(34,0,'7','7',4,'image/jpeg',4294,'main/customers/7.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(35,0,'8','8',4,'image/jpeg',4294,'main/customers/8.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(36,0,'9','9',4,'image/jpeg',4294,'main/customers/9.jpg','[]','2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(37,0,'blog-big-1','blog-big-1',5,'image/jpeg',13885,'main/blog/blog-big-1.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(38,0,'blog-details-sm-1','blog-details-sm-1',5,'image/jpeg',8166,'main/blog/blog-details-sm-1.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(39,0,'post-1','post-1',5,'image/jpeg',6189,'main/blog/post-1.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(40,0,'post-10','post-10',5,'image/jpeg',5907,'main/blog/post-10.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(41,0,'post-11','post-11',5,'image/jpeg',5907,'main/blog/post-11.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(42,0,'post-12','post-12',5,'image/jpeg',5907,'main/blog/post-12.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(43,0,'post-2','post-2',5,'image/jpeg',6189,'main/blog/post-2.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(44,0,'post-3','post-3',5,'image/jpeg',6189,'main/blog/post-3.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(45,0,'post-4','post-4',5,'image/jpeg',6045,'main/blog/post-4.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(46,0,'post-5','post-5',5,'image/jpeg',6045,'main/blog/post-5.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(47,0,'post-6','post-6',5,'image/jpeg',6045,'main/blog/post-6.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(48,0,'post-7','post-7',5,'image/jpeg',5907,'main/blog/post-7.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(49,0,'post-8','post-8',5,'image/jpeg',5907,'main/blog/post-8.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(50,0,'post-9','post-9',5,'image/jpeg',5907,'main/blog/post-9.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(51,0,'1','1',3,'image/jpeg',4068,'main/users/1.jpg','[]','2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(52,0,'10','10',3,'image/jpeg',7599,'main/users/10.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(53,0,'2','2',3,'image/jpeg',7599,'main/users/2.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(54,0,'3','3',3,'image/jpeg',6387,'main/users/3.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(55,0,'4','4',3,'image/jpeg',7599,'main/users/4.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(56,0,'5','5',3,'image/jpeg',6387,'main/users/5.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(57,0,'6','6',3,'image/jpeg',7599,'main/users/6.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(58,0,'7','7',3,'image/jpeg',6387,'main/users/7.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(59,0,'8','8',3,'image/jpeg',7599,'main/users/8.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(60,0,'9','9',3,'image/jpeg',6387,'main/users/9.jpg','[]','2024-03-15 03:01:40','2024-03-15 03:01:40',NULL),(61,0,'1','1',6,'image/png',9133,'main/stores/1.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(62,0,'10','10',6,'image/png',4263,'main/stores/10.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(63,0,'11','11',6,'image/png',4420,'main/stores/11.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(64,0,'12','12',6,'image/png',4908,'main/stores/12.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(65,0,'13','13',6,'image/png',3441,'main/stores/13.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(66,0,'14','14',6,'image/png',4209,'main/stores/14.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(67,0,'15','15',6,'image/png',5113,'main/stores/15.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(68,0,'16','16',6,'image/png',4563,'main/stores/16.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(69,0,'17','17',6,'image/png',4896,'main/stores/17.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(70,0,'2','2',6,'image/png',9008,'main/stores/2.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(71,0,'3','3',6,'image/png',8006,'main/stores/3.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(72,0,'4','4',6,'image/png',8728,'main/stores/4.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(73,0,'5','5',6,'image/png',10689,'main/stores/5.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(74,0,'6','6',6,'image/png',10989,'main/stores/6.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(75,0,'7','7',6,'image/png',3730,'main/stores/7.png','[]','2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(76,0,'8','8',6,'image/png',4030,'main/stores/8.png','[]','2024-03-15 03:01:42','2024-03-15 03:01:42',NULL),(77,0,'9','9',6,'image/png',3810,'main/stores/9.png','[]','2024-03-15 03:01:42','2024-03-15 03:01:42',NULL),(78,0,'cover-1','cover-1',6,'image/png',4208,'main/stores/cover-1.png','[]','2024-03-15 03:01:42','2024-03-15 03:01:42',NULL),(79,0,'cover-2','cover-2',6,'image/png',8798,'main/stores/cover-2.png','[]','2024-03-15 03:01:42','2024-03-15 03:01:42',NULL),(80,0,'cover-3','cover-3',6,'image/png',3888,'main/stores/cover-3.png','[]','2024-03-15 03:01:42','2024-03-15 03:01:42',NULL),(81,0,'cover-4','cover-4',6,'image/png',11893,'main/stores/cover-4.png','[]','2024-03-15 03:01:42','2024-03-15 03:01:42',NULL),(82,0,'cover-5','cover-5',6,'image/png',8798,'main/stores/cover-5.png','[]','2024-03-15 03:01:42','2024-03-15 03:01:42',NULL),(83,0,'shape-1','shape-1',8,'image/png',1842,'fashion/sliders/shape-1.png','[]','2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(84,0,'shape-2','shape-2',8,'image/png',489,'fashion/sliders/shape-2.png','[]','2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(85,0,'shape-3','shape-3',8,'image/png',221,'fashion/sliders/shape-3.png','[]','2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(86,0,'slider-1','slider-1',8,'image/png',10444,'fashion/sliders/slider-1.png','[]','2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(87,0,'slider-2','slider-2',8,'image/png',9843,'fashion/sliders/slider-2.png','[]','2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(88,0,'slider-3','slider-3',8,'image/png',11768,'fashion/sliders/slider-3.png','[]','2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(89,0,'1','1',9,'image/jpeg',4294,'fashion/product-categories/1.jpg','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(90,0,'2','2',9,'image/jpeg',4294,'fashion/product-categories/2.jpg','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(91,0,'3','3',9,'image/jpeg',4294,'fashion/product-categories/3.jpg','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(92,0,'4','4',9,'image/jpeg',4294,'fashion/product-categories/4.jpg','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(93,0,'5','5',9,'image/jpeg',4294,'fashion/product-categories/5.jpg','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(94,0,'6','6',9,'image/jpeg',4294,'fashion/product-categories/6.jpg','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(95,0,'product-1','product-1',10,'image/png',9803,'fashion/products/product-1.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(96,0,'product-2','product-2',10,'image/png',9803,'fashion/products/product-2.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(97,0,'product-3','product-3',10,'image/png',9803,'fashion/products/product-3.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(98,0,'product-4','product-4',10,'image/png',9803,'fashion/products/product-4.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(99,0,'product-5','product-5',10,'image/png',9803,'fashion/products/product-5.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(100,0,'product-6','product-6',10,'image/png',9803,'fashion/products/product-6.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(101,0,'product-7','product-7',10,'image/png',9803,'fashion/products/product-7.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(102,0,'product-8','product-8',10,'image/png',9803,'fashion/products/product-8.png','[]','2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(103,0,'1','1',11,'image/jpeg',6309,'main/banners/1.jpg','[]','2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(104,0,'2','2',11,'image/jpeg',6275,'main/banners/2.jpg','[]','2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(105,0,'slider-1','slider-1',11,'image/png',8207,'main/banners/slider-1.png','[]','2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(106,0,'slider-2','slider-2',11,'image/png',8497,'main/banners/slider-2.png','[]','2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(107,0,'slider-3','slider-3',11,'image/png',6239,'main/banners/slider-3.png','[]','2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(108,0,'1','1',12,'image/jpeg',6287,'fashion/banners/1.jpg','[]','2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(109,0,'2','2',12,'image/jpeg',5975,'fashion/banners/2.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(110,0,'3','3',12,'image/jpeg',5975,'fashion/banners/3.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(111,0,'4','4',12,'image/jpeg',9052,'fashion/banners/4.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(112,0,'1','1',13,'image/jpeg',4294,'fashion/galleries/1.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(113,0,'2','2',13,'image/jpeg',4294,'fashion/galleries/2.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(114,0,'3','3',13,'image/jpeg',4294,'fashion/galleries/3.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(115,0,'4','4',13,'image/jpeg',4294,'fashion/galleries/4.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(116,0,'5','5',13,'image/jpeg',4294,'fashion/galleries/5.jpg','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(117,0,'icon-1','icon-1',14,'image/png',4469,'main/contact/icon-1.png','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(118,0,'icon-2','icon-2',14,'image/png',5977,'main/contact/icon-2.png','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(119,0,'icon-3','icon-3',14,'image/png',6082,'main/contact/icon-3.png','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(120,0,'line','line',15,'image/png',6152,'main/shapes/line.png','[]','2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(121,0,'quote','quote',15,'image/png',595,'main/shapes/quote.png','[]','2024-03-15 03:01:50','2024-03-15 03:01:50',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(2,0,'general',NULL,'general',1,'2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(3,0,'users',NULL,'users',1,'2024-03-15 03:01:33','2024-03-15 03:01:33',NULL),(4,0,'customers',NULL,'customers',1,'2024-03-15 03:01:35','2024-03-15 03:01:35',NULL),(5,0,'blog',NULL,'blog',1,'2024-03-15 03:01:39','2024-03-15 03:01:39',NULL),(6,0,'stores',NULL,'stores',1,'2024-03-15 03:01:41','2024-03-15 03:01:41',NULL),(7,0,'fashion',NULL,'fashion',0,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(8,0,'sliders',NULL,'sliders',7,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL),(9,0,'product-categories',NULL,'product-categories',7,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(10,0,'products',NULL,'products',7,'2024-03-15 03:01:45','2024-03-15 03:01:45',NULL),(11,0,'banners',NULL,'banners',1,'2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(12,0,'banners',NULL,'banners',7,'2024-03-15 03:01:48','2024-03-15 03:01:48',NULL),(13,0,'galleries',NULL,'galleries',7,'2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(14,0,'contact',NULL,'contact',1,'2024-03-15 03:01:49','2024-03-15 03:01:49',NULL),(15,0,'shapes',NULL,'shapes',1,'2024-03-15 03:01:49','2024-03-15 03:01:49',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,1,'Botble\\Page\\Models\\Page','/home',NULL,0,'Home',NULL,'_self',1,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(2,1,1,NULL,NULL,'https://shofy.botble.com',NULL,0,'Electronics',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(3,1,1,NULL,NULL,'https://shofy-fashion.botble.com',NULL,0,'Fashion',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(4,1,1,NULL,NULL,'https://shofy-beauty.botble.com',NULL,0,'Beauty',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(5,1,1,NULL,NULL,'https://shofy-jewelry.botble.com',NULL,0,'Jewelry',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(6,1,1,NULL,NULL,'https://shofy-grocery.botble.com',NULL,0,'Grocery',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(7,1,0,NULL,NULL,NULL,NULL,0,'Shop',NULL,'_self',1,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(8,1,7,2,'Botble\\Page\\Models\\Page','/product-categories',NULL,0,'Shop Categories',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,0,'Shop List',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(10,1,7,NULL,NULL,'/products?layout=grid',NULL,0,'Shop Grid',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(11,1,7,NULL,NULL,'/products/leather-ankle-boots',NULL,0,'Product Detail',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(12,1,7,3,'Botble\\Page\\Models\\Page','/coupons',NULL,0,'Grab Coupons',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(13,1,7,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(14,1,7,NULL,NULL,'/compare',NULL,0,'Compare',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(15,1,7,NULL,NULL,'/wishlist',NULL,0,'Wishlist',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(16,1,7,NULL,NULL,'/orders/tracking',NULL,0,'Track Your Order',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(17,1,0,NULL,NULL,'/stores',NULL,0,'Vendors',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(18,1,0,NULL,NULL,NULL,NULL,0,'Pages',NULL,'_self',1,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(19,1,18,NULL,NULL,'/login',NULL,0,'Login',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(20,1,18,NULL,NULL,'/register',NULL,0,'Register',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(21,1,18,NULL,NULL,'/password/reset',NULL,0,'Forgot Password',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(22,1,18,NULL,NULL,'/404',NULL,0,'404 Error',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(23,1,0,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',1,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(24,1,23,NULL,NULL,'/blog?layout=grid',NULL,0,'Blog Grid',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(25,1,23,NULL,NULL,'/blog?layout=list',NULL,0,'Blog List',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(26,1,23,NULL,NULL,'/blog/9-things-i-love-about-shaving-my-head',NULL,0,'Blog Detail',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(27,1,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(28,2,0,NULL,NULL,'/orders/tracking',NULL,1,'Track Orders',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(29,2,0,9,'Botble\\Page\\Models\\Page','/shipping',NULL,1,'Shipping',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(30,2,0,NULL,NULL,'/wishlist',NULL,1,'Wishlist',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(31,2,0,NULL,NULL,'/customer/overview',NULL,1,'My Account',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(32,2,0,NULL,NULL,'/customer/orders',NULL,1,'Order History',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(33,2,0,NULL,NULL,'/customer/order-returns',NULL,1,'Returns',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(34,3,0,7,'Botble\\Page\\Models\\Page','/our-story',NULL,2,'Our Story',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(35,3,0,8,'Botble\\Page\\Models\\Page','/careers',NULL,2,'Careers',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(36,3,0,6,'Botble\\Page\\Models\\Page','/cookie-policy',NULL,2,'Privacy Policy',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(37,3,0,NULL,NULL,'/blog',NULL,2,'Latest News',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49'),(38,3,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,2,'Contact Us',NULL,'_self',0,'2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(2,'My Account','my-account','published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(3,'Information','information','published','2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'background','[\"main\\/stores\\/cover-2.png\"]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(2,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(3,'background','[\"main\\/stores\\/cover-5.png\"]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(4,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(5,'background','[\"main\\/stores\\/cover-5.png\"]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(6,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(7,'background','[\"main\\/stores\\/cover-5.png\"]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(8,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(9,'background','[\"main\\/stores\\/cover-1.png\"]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(10,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(11,'background','[\"main\\/stores\\/cover-4.png\"]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(12,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(13,'background','[\"main\\/stores\\/cover-4.png\"]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(14,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(15,'background','[\"main\\/stores\\/cover-1.png\"]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(16,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:01:44','2024-03-15 03:01:44'),(17,'button_label','[\"Shop Collection\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:01:45','2024-03-15 03:01:45'),(18,'button_label','[\"Shop Collection\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:01:45','2024-03-15 03:01:45'),(19,'button_label','[\"Shop Collection\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:01:45','2024-03-15 03:01:45'),(20,'faq_ids','[[1,2,3,4,8]]',1,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(21,'faq_ids','[[3,7,8,9,10]]',2,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(22,'faq_ids','[[2,5,6,7,9]]',3,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(23,'faq_ids','[[3,4,5,8,9]]',4,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(24,'faq_ids','[[4,6,7,9,10]]',5,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(25,'faq_ids','[[3,4,5,7,9]]',6,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(26,'faq_ids','[[3,4,5,6,7]]',7,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(27,'faq_ids','[[1,4,5,7,10]]',8,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(28,'faq_ids','[[2,3,5,8,10]]',9,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(29,'faq_ids','[[3,4,5,7,8]]',10,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(30,'faq_ids','[[3,6,7,9,10]]',11,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(31,'faq_ids','[[1,2,3,6,9]]',12,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(32,'faq_ids','[[1,2,5,7,10]]',13,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(33,'faq_ids','[[3,4,5,6,7]]',14,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(34,'faq_ids','[[1,3,5,7,10]]',15,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(35,'faq_ids','[[6,7,8,9,10]]',16,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(36,'faq_ids','[[2,3,6,7,10]]',17,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(37,'faq_ids','[[2,5,6,7,10]]',18,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(38,'faq_ids','[[2,3,6,8,9]]',19,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(39,'faq_ids','[[2,3,4,5,9]]',20,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(40,'faq_ids','[[2,3,4,6,8]]',21,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(41,'faq_ids','[[1,2,3,4,9]]',22,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(42,'faq_ids','[[1,2,4,5,6]]',23,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(43,'faq_ids','[[2,4,5,7,9]]',24,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(44,'faq_ids','[[2,3,4,5,6]]',25,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(45,'faq_ids','[[2,3,5,7,8]]',26,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(46,'faq_ids','[[1,3,5,6,10]]',27,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(47,'faq_ids','[[3,4,5,8,10]]',28,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(48,'faq_ids','[[2,4,5,8,9]]',29,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(49,'faq_ids','[[2,7,8,9,10]]',30,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(50,'faq_ids','[[2,3,5,7,8]]',31,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(51,'faq_ids','[[3,5,7,8,9]]',32,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(52,'faq_ids','[[1,5,7,8,9]]',33,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(53,'faq_ids','[[2,3,5,7,9]]',34,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(54,'faq_ids','[[2,4,5,6,8]]',35,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(55,'faq_ids','[[1,4,6,7,9]]',36,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(56,'faq_ids','[[1,2,4,8,10]]',37,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(57,'faq_ids','[[4,5,7,9,10]]',38,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(58,'faq_ids','[[3,4,5,9,10]]',39,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(59,'faq_ids','[[2,4,5,8,10]]',40,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(60,'faq_ids','[[1,4,5,7,9]]',41,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(61,'faq_ids','[[1,2,5,7,9]]',42,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(62,'faq_ids','[[1,3,5,9,10]]',43,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:01:46','2024-03-15 03:01:46'),(63,'title','[\"Smartphone \\\\n BLU G91 Pro 2022\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(64,'subtitle','[\"Sale 20% off all store\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(65,'button_label','[\"Shop Now\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(66,'title','[\"HyperX Cloud II \\\\n Wireless\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(67,'subtitle','[\"Sale 35% off\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(68,'button_label','[\"Shop Now\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(69,'title','[\"T-Shirt Tunic \\n Tops Blouse\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(70,'button_label','[\"Shop Now\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(71,'title','[\"Satchel Tote \\n Crossbody Bags\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(72,'button_label','[\"Shop Now\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(73,'title','[\"Men\'s Tennis \\n Walking Shoes\"]',5,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(74,'button_label','[\"Shop Now\"]',5,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(75,'title','[\"Short Sleeve Tunic \\n Tops Casual Swing\"]',6,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(76,'button_label','[\"Explore More\"]',6,'Botble\\Ads\\Models\\Ads','2024-03-15 03:01:49','2024-03-15 03:01:49'),(77,'breadcrumb_style','[\"none\"]',1,'Botble\\Page\\Models\\Page','2024-03-15 03:01:49','2024-03-15 03:01:49'),(78,'breadcrumb_style','[\"align-start\"]',2,'Botble\\Page\\Models\\Page','2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_reset_tokens_table',1),(5,'2015_06_18_033822_create_blog_table',1),(6,'2015_06_29_025744_create_audit_history',1),(7,'2016_05_28_112028_create_system_request_logs_table',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2020_03_05_041139_create_ecommerce_tables',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',1),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',1),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',1),(34,'2021_02_16_092633_remove_default_value_for_author_type',1),(35,'2021_02_18_073505_update_table_ec_reviews',1),(36,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',1),(37,'2021_03_10_025153_change_column_tax_amount',1),(38,'2021_03_20_033103_add_column_availability_to_table_ec_products',1),(39,'2021_03_27_144913_add_customer_type_into_table_payments',1),(40,'2021_04_28_074008_ecommerce_create_product_label_table',1),(41,'2021_05_24_034720_make_column_currency_nullable',1),(42,'2021_05_31_173037_ecommerce_create_ec_products_translations',1),(43,'2021_07_06_030002_create_marketplace_table',1),(44,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(45,'2021_08_17_105016_remove_column_currency_id_in_some_tables',1),(46,'2021_08_30_142128_add_images_column_to_ec_reviews_table',1),(47,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',1),(48,'2021_10_04_030050_add_column_created_by_to_table_ec_products',1),(49,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',1),(50,'2021_10_05_122616_add_status_column_to_ec_customers_table',1),(51,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',1),(52,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',1),(53,'2021_10_19_020859_update_metadata_field',1),(54,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(55,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',1),(56,'2021_11_23_071403_correct_languages_for_product_variations',1),(57,'2021_11_28_031808_add_product_tags_translations',1),(58,'2021_12_01_031123_add_featured_image_to_ec_products',1),(59,'2021_12_02_035301_add_ads_translations_table',1),(60,'2021_12_03_030600_create_blog_translations',1),(61,'2021_12_03_075608_create_page_translations',1),(62,'2021_12_03_082134_create_faq_translations',1),(63,'2021_12_03_082953_create_gallery_translations',1),(64,'2021_12_03_083642_create_testimonials_translations',1),(65,'2021_12_03_084118_create_location_translations',1),(66,'2021_12_03_094518_migrate_old_location_data',1),(67,'2021_12_06_031304_update_table_mp_customer_revenues',1),(68,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(69,'2022_01_01_033107_update_table_ec_shipments',1),(70,'2022_01_16_085908_improve_plugin_location',1),(71,'2022_02_16_042457_improve_product_attribute_sets',1),(72,'2022_03_22_075758_correct_product_name',1),(73,'2022_04_19_113334_add_index_to_ec_products',1),(74,'2022_04_19_113923_add_index_to_table_posts',1),(75,'2022_04_20_100851_add_index_to_media_table',1),(76,'2022_04_20_101046_add_index_to_menu_table',1),(77,'2022_04_28_144405_remove_unused_table',1),(78,'2022_04_30_034048_create_gallery_meta_translations_table',1),(79,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',1),(80,'2022_05_18_143720_add_index_to_table_ec_product_categories',1),(81,'2022_06_16_095633_add_index_to_some_tables',1),(82,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(83,'2022_06_30_035148_create_order_referrals_table',1),(84,'2022_07_07_153354_update_charge_id_in_table_payments',1),(85,'2022_07_10_034813_move_lang_folder_to_root',1),(86,'2022_07_24_153815_add_completed_at_to_ec_orders_table',1),(87,'2022_08_04_051940_add_missing_column_expires_at',1),(88,'2022_08_04_052122_delete_location_backup_tables',1),(89,'2022_08_14_032836_create_ec_order_returns_table',1),(90,'2022_08_14_033554_create_ec_order_return_items_table',1),(91,'2022_08_15_040324_add_billing_address',1),(92,'2022_08_30_091114_support_digital_products_table',1),(93,'2022_09_01_000001_create_admin_notifications_tables',1),(94,'2022_09_13_095744_create_options_table',1),(95,'2022_09_13_104347_create_option_value_table',1),(96,'2022_10_05_163518_alter_table_ec_order_product',1),(97,'2022_10_12_041517_create_invoices_table',1),(98,'2022_10_12_142226_update_orders_table',1),(99,'2022_10_13_024916_update_table_order_returns',1),(100,'2022_10_14_024629_drop_column_is_featured',1),(101,'2022_10_19_152916_add_columns_to_mp_stores_table',1),(102,'2022_10_20_062849_create_mp_category_sale_commissions_table',1),(103,'2022_10_21_030830_update_columns_in_ec_shipments_table',1),(104,'2022_10_28_021046_update_columns_in_ec_shipments_table',1),(105,'2022_11_02_071413_add_more_info_for_store',1),(106,'2022_11_02_080444_add_tax_info',1),(107,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',1),(108,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(109,'2022_11_19_041643_add_ec_tax_product_table',1),(110,'2022_12_02_093615_update_slug_index_columns',1),(111,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',1),(112,'2022_12_17_041532_fix_address_in_order_invoice',1),(113,'2022_12_26_070329_create_ec_product_views_table',1),(114,'2023_01_04_033051_fix_product_categories',1),(115,'2023_01_09_050400_add_ec_global_options_translations_table',1),(116,'2023_01_10_093754_add_missing_option_value_id',1),(117,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',1),(118,'2023_01_26_021854_add_ec_customer_used_coupons_table',1),(119,'2023_01_30_024431_add_alt_to_media_table',1),(120,'2023_02_01_062030_add_store_translations',1),(121,'2023_02_08_015900_update_options_column_in_ec_order_product_table',1),(122,'2023_02_13_032133_update_fee_column_mp_customer_revenues_table',1),(123,'2023_02_16_042611_drop_table_password_resets',1),(124,'2023_02_17_023648_fix_store_prefix',1),(125,'2023_02_27_095752_remove_duplicate_reviews',1),(126,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',1),(127,'2023_04_17_062645_add_open_in_new_tab',1),(128,'2023_04_21_082427_create_ec_product_categorizables_table',1),(129,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(130,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(131,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',1),(132,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(133,'2023_05_17_025812_fix_invoice_issue',1),(134,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',1),(135,'2023_05_27_144611_fix_exchange_rate_setting',1),(136,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',1),(137,'2023_06_30_042512_create_ec_order_tax_information_table',1),(138,'2023_07_06_011444_create_slug_translations_table',1),(139,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',1),(140,'2023_07_26_041451_add_more_columns_to_location_table',1),(141,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(142,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',1),(143,'2023_08_11_060908_create_announcements_table',1),(144,'2023_08_15_064505_create_ec_tax_rules_table',1),(145,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(146,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',1),(147,'2023_08_21_090810_make_page_content_nullable',1),(148,'2023_08_22_094114_drop_unique_for_barcode',1),(149,'2023_08_29_074620_make_column_author_id_nullable',1),(150,'2023_08_29_075308_make_column_user_id_nullable',1),(151,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',1),(152,'2023_09_07_094312_add_index_to_product_sku_and_translations',1),(153,'2023_09_14_021936_update_index_for_slugs_table',1),(154,'2023_09_14_022423_add_index_for_language_table',1),(155,'2023_09_19_024955_create_discount_product_categories_table',1),(156,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',1),(157,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(158,'2023_11_07_023805_add_tablet_mobile_image',1),(159,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(160,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(161,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(162,'2023_11_22_154643_add_unique_in_table_ec_products_variations',1),(163,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',1),(164,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',1),(165,'2023_12_06_100448_change_random_hash_for_media',1),(166,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(167,'2023_12_12_105220_drop_translations_table',1),(168,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(169,'2023_12_25_040604_ec_create_review_replies_table',1),(170,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',1),(171,'2024_01_16_070706_fix_translation_tables',1),(172,'2024_01_23_075227_add_proof_file_to_ec_orders_table',1),(173,'2024_03_14_041050_migrate_lazy_load_theme_options',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,8,2,1194.00,0.00,1194.00,0.00,'USD',NULL,'2024-03-14 03:02:03','2024-03-14 03:02:03',0,'add-amount'),(2,3,5,517.00,0.00,517.00,0.00,'USD',NULL,'2024-03-13 03:02:04','2024-03-13 03:02:04',0,'add-amount'),(3,2,9,4688.00,0.00,4688.00,0.00,'USD',NULL,'2024-03-14 07:02:04','2024-03-14 07:02:04',0,'add-amount'),(4,6,13,3491.00,0.00,3491.00,0.00,'USD',NULL,'2024-03-08 03:02:05','2024-03-08 03:02:05',0,'add-amount'),(5,7,18,892.00,0.00,892.00,0.00,'USD',NULL,'2024-03-04 01:02:05','2024-03-04 01:02:05',0,'add-amount'),(6,2,21,1095.00,0.00,1095.00,4688.00,'USD',NULL,'2024-03-11 11:02:06','2024-03-11 11:02:06',0,'add-amount'),(7,5,23,7347.00,0.00,7347.00,0.00,'USD',NULL,'2024-03-11 03:02:06','2024-03-11 03:02:06',0,'add-amount'),(8,8,30,2934.00,0.00,2934.00,1194.00,'USD',NULL,'2024-03-04 19:02:07','2024-03-04 19:02:07',0,'add-amount'),(9,8,32,4401.00,0.00,4401.00,4128.00,'USD',NULL,'2024-03-12 09:02:07','2024-03-12 09:02:07',0,'add-amount'),(10,2,35,2190.00,0.00,2190.00,5783.00,'USD',NULL,'2024-03-12 03:02:08','2024-03-12 03:02:08',0,'add-amount'),(11,6,37,3144.00,0.00,3144.00,3491.00,'USD',NULL,'2024-02-12 11:02:09','2024-02-12 11:02:09',0,'add-amount'),(12,6,41,3144.00,0.00,3144.00,6635.00,'USD',NULL,'2024-02-23 03:02:09','2024-02-23 03:02:09',0,'add-amount'),(13,2,47,1258.00,0.00,1258.00,7973.00,'USD',NULL,'2024-02-16 03:02:10','2024-02-16 03:02:10',0,'add-amount'),(14,8,51,796.00,0.00,796.00,8529.00,'USD',NULL,'2024-03-06 11:02:10','2024-03-06 11:02:10',0,'add-amount');
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,2,0.00,833.00,9231.00,'USD','','{\"name\":\"Monica Sporer\",\"number\":\"+13036171960\",\"full_name\":\"Barrett Hodkiewicz\",\"description\":\"Larissa Conroy\"}',NULL,0,'processing',NULL,'2024-03-15 03:02:11','2024-03-15 03:02:11',NULL),(2,2,0.00,994.00,8398.00,'USD','','{\"name\":\"Monica Sporer\",\"number\":\"+13036171960\",\"full_name\":\"Barrett Hodkiewicz\",\"description\":\"Larissa Conroy\"}',NULL,0,'pending',NULL,'2024-03-15 03:02:11','2024-03-15 03:02:11',NULL),(3,2,0.00,1720.00,7404.00,'USD','','{\"name\":\"Monica Sporer\",\"number\":\"+13036171960\",\"full_name\":\"Barrett Hodkiewicz\",\"description\":\"Larissa Conroy\"}',NULL,0,'processing',NULL,'2024-03-15 03:02:12','2024-03-15 03:02:12',NULL),(4,3,0.00,2.00,517.00,'USD','','{\"name\":\"Libby Jacobson\",\"number\":\"+14353426577\",\"full_name\":\"Gust Pagac\",\"description\":\"Dianna Keeling\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:12','2024-03-15 03:02:12',NULL),(5,3,0.00,29.00,515.00,'USD','','{\"name\":\"Libby Jacobson\",\"number\":\"+14353426577\",\"full_name\":\"Gust Pagac\",\"description\":\"Dianna Keeling\"}',NULL,0,'pending',NULL,'2024-03-15 03:02:13','2024-03-15 03:02:13',NULL),(6,3,0.00,147.00,486.00,'USD','','{\"name\":\"Libby Jacobson\",\"number\":\"+14353426577\",\"full_name\":\"Gust Pagac\",\"description\":\"Dianna Keeling\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:13','2024-03-15 03:02:13',NULL),(7,3,0.00,17.00,339.00,'USD','','{\"name\":\"Libby Jacobson\",\"number\":\"+14353426577\",\"full_name\":\"Gust Pagac\",\"description\":\"Dianna Keeling\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:14','2024-03-15 03:02:14',NULL),(8,5,0.00,2163.00,7347.00,'USD','','{\"name\":\"Prof. Jefferey Greenfelder III\",\"number\":\"+17149999157\",\"full_name\":\"Dr. Titus Collins\",\"description\":\"Mrs. Gina Beatty\"}',NULL,0,'pending',NULL,'2024-03-15 03:02:15','2024-03-15 03:02:15',NULL),(9,5,0.00,977.00,5184.00,'USD','','{\"name\":\"Prof. Jefferey Greenfelder III\",\"number\":\"+17149999157\",\"full_name\":\"Dr. Titus Collins\",\"description\":\"Mrs. Gina Beatty\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:15','2024-03-15 03:02:15',NULL),(10,5,0.00,759.00,4207.00,'USD','','{\"name\":\"Prof. Jefferey Greenfelder III\",\"number\":\"+17149999157\",\"full_name\":\"Dr. Titus Collins\",\"description\":\"Mrs. Gina Beatty\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:16','2024-03-15 03:02:16',NULL),(11,6,0.00,470.00,9779.00,'USD','','{\"name\":\"Alvis Bechtelar\",\"number\":\"+18309063123\",\"full_name\":\"Jennyfer Johns\",\"description\":\"Bailey Bailey\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:16','2024-03-15 03:02:16',NULL),(12,6,0.00,2883.00,9309.00,'USD','','{\"name\":\"Alvis Bechtelar\",\"number\":\"+18309063123\",\"full_name\":\"Jennyfer Johns\",\"description\":\"Bailey Bailey\"}',NULL,0,'processing',NULL,'2024-03-15 03:02:17','2024-03-15 03:02:17',NULL),(13,6,0.00,844.00,6426.00,'USD','','{\"name\":\"Alvis Bechtelar\",\"number\":\"+18309063123\",\"full_name\":\"Jennyfer Johns\",\"description\":\"Bailey Bailey\"}',NULL,0,'pending',NULL,'2024-03-15 03:02:17','2024-03-15 03:02:17',NULL),(14,7,0.00,43.00,892.00,'USD','','{\"name\":\"Dr. Dora Johnston III\",\"number\":\"+15316468810\",\"full_name\":\"Waldo King\",\"description\":\"Mckenzie Corwin\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:18','2024-03-15 03:02:18',NULL),(15,7,0.00,28.00,849.00,'USD','','{\"name\":\"Dr. Dora Johnston III\",\"number\":\"+15316468810\",\"full_name\":\"Waldo King\",\"description\":\"Mckenzie Corwin\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:18','2024-03-15 03:02:18',NULL),(16,8,0.00,2850.00,9325.00,'USD','','{\"name\":\"Allan Cartwright Sr.\",\"number\":\"+13465571513\",\"full_name\":\"Javonte Kihn\",\"description\":\"Lukas Casper\"}',NULL,0,'pending',NULL,'2024-03-15 03:02:19','2024-03-15 03:02:19',NULL),(17,8,0.00,970.00,6475.00,'USD','','{\"name\":\"Allan Cartwright Sr.\",\"number\":\"+13465571513\",\"full_name\":\"Javonte Kihn\",\"description\":\"Lukas Casper\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:19','2024-03-15 03:02:19',NULL),(18,8,0.00,948.00,5505.00,'USD','','{\"name\":\"Allan Cartwright Sr.\",\"number\":\"+13465571513\",\"full_name\":\"Javonte Kihn\",\"description\":\"Lukas Casper\"}',NULL,0,'completed',NULL,'2024-03-15 03:02:20','2024-03-15 03:02:20',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','dpurdy@example.com','+13034909569','2099 Feeney Gateway','SE','Idaho','Yadirahaven',1,'main/stores/1.png','Eaque impedit nulla ut doloribus illo voluptas nisi aperiam. Voluptatem aut optio eum consequatur corporis. Cupiditate voluptatibus earum quia sunt autem labore nulla voluptate. Hic voluptatibus tenetur dicta eaque minus nihil. Natus velit sunt enim voluptatibus. Sunt rerum officiis numquam. Sit voluptatem doloremque natus et recusandae. Perferendis omnis temporibus consequatur tempora ipsam.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL),(2,'Global Office','maiya89@example.net','+17628069548','196 Audreanne Rest Suite 539','KP','Wisconsin','South Orvillemouth',2,'main/stores/2.png','Laboriosam non itaque neque in amet cumque similique. Minus qui consectetur eos labore debitis ea dolorum. Occaecati esse eveniet consequatur doloremque quasi esse qui dolorem. Tempore et et et in. Dolor harum aut harum sed quis non facere. Aut inventore vel commodi porro. Voluptatem qui voluptatem et dignissimos et sit quo. Voluptates consequatur autem dolores.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL),(3,'Young Shop','marvin.domenick@example.net','+14076264181','547 Glenda Wall','LI','Arizona','Port Myrtisbury',3,'main/stores/3.png','Similique debitis nobis repellendus possimus molestiae. Nesciunt dolorem sed modi voluptatibus ex. Quibusdam ut perferendis vitae provident eum vitae odit. Ea temporibus aut rerum illo et. Voluptas minima ratione quia neque maxime quidem qui. Earum rerum totam omnis aut dolorem magnam quia molestiae.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL),(4,'Global Store','lee.botsford@example.net','+17854302874','7321 Purdy Harbor','IR','Utah','Schuylerstad',4,'main/stores/4.png','Libero sit minima non expedita debitis velit. At pariatur impedit id consequuntur nihil ullam sunt. Autem ut illo a. Omnis rerum ea dolorem provident nam non eos. Rerum vero dolores id praesentium mollitia consectetur.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL),(5,'Robert’s Store','adolfo.bosco@example.com','+14587299410','197 Dayton Mission Suite 411','ER','Massachusetts','Chloeland',5,'main/stores/5.png','Culpa minus soluta et alias autem animi aut. Excepturi quia eius ut cum possimus. Non laborum qui neque distinctio quae in. Qui et qui veniam neque. Amet perferendis ut aut est magnam. Et adipisci accusantium vel consectetur. Velit illum velit nostrum non quidem sunt quidem.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL),(6,'Stouffer','miller.jose@example.net','+15304439504','3646 Ludwig Court Apt. 412','GN','Iowa','Port Gloria',6,'main/stores/6.png','Et perferendis dolores earum quo quisquam nisi. Eum incidunt ut veritatis necessitatibus id eos sunt. Aut totam ut vitae optio. Ex molestiae et dolore assumenda ducimus quis. Molestias voluptas nihil enim blanditiis dolorum non amet. Architecto modi est cumque repellendus. Et voluptas dolores dolorem. Tempora nesciunt molestiae non assumenda.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL),(7,'StarKist','fay54@example.net','+17475562350','64254 Shields Glens','ZW','Alabama','Margarettview',7,'main/stores/7.png','Tenetur id doloremque ducimus incidunt. Ut ipsam necessitatibus eum ex corrupti sint non facere. Nostrum ab eligendi in ut. Nam sed ipsam sunt eius consequatur tenetur et. Quia harum minus sunt rerum in iure ratione. Doloribus dicta soluta voluptatem sapiente dolorem aspernatur et. Enim aut aut quisquam minima in. Autem distinctio vero veritatis autem. Ea omnis aperiam ut quia fugit ullam.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL),(8,'Old El Paso','halie.tillman@example.com','+19253242488','7415 Corrine Brooks Suite 154','GU','Oklahoma','Sawaynburgh',8,'main/stores/8.png','Enim necessitatibus architecto omnis rerum totam totam quia repellat. Fugiat qui consequatur eligendi facilis tenetur pariatur. Eum laborum et sapiente magnam ut odit vel. Quia eveniet maiores inventore adipisci. Asperiores et molestiae dignissimos earum quis consequatur.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:01:44','2024-03-15 03:01:44',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores_translations`
--

DROP TABLE IF EXISTS `mp_stores_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mp_stores_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`mp_stores_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores_translations`
--

LOCK TABLES `mp_stores_translations` WRITE;
/*!40000 ALTER TABLE `mp_stores_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_stores_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,1,0.00,0.00,0.00,'$2y$12$qHNo9u9K2EbcTzE/PavSsuLOwu5ASkLHI7YlJWCndlA1D/YIq23Pe','{\"name\":\"Nona Moore\",\"number\":\"+16318975836\",\"full_name\":\"Stacy Ruecker\",\"description\":\"Enrico Botsford\"}','2024-03-15 03:01:42','2024-03-15 03:01:42','bank_transfer',NULL),(2,2,5684.00,0.00,9231.00,'$2y$12$Qpa8XHEWlQAeukyfCRrDm.zzxT7ZkqInyME90jjWl3Y37zR2UEEXW','{\"name\":\"Monica Sporer\",\"number\":\"+13036171960\",\"full_name\":\"Barrett Hodkiewicz\",\"description\":\"Larissa Conroy\"}','2024-03-15 03:01:42','2024-03-15 03:02:12','bank_transfer',NULL),(3,3,322.00,0.00,517.00,'$2y$12$nTl4s1kfSKXQXPpoi6o/Uen9KLhp2JmReu.aCh4M.Nms8uejAoBQq','{\"name\":\"Libby Jacobson\",\"number\":\"+14353426577\",\"full_name\":\"Gust Pagac\",\"description\":\"Dianna Keeling\"}','2024-03-15 03:01:43','2024-03-15 03:02:15','bank_transfer',NULL),(4,4,0.00,0.00,0.00,'$2y$12$HR0M/Oqt/k6l7jlpXuKxOeLu/E1kCvpzgcDO/IYPgZqGqkDaM3VtK','{\"name\":\"Louvenia Kozey\",\"number\":\"+19319297735\",\"full_name\":\"Judy Jenkins\",\"description\":\"Grace Luettgen\"}','2024-03-15 03:01:43','2024-03-15 03:01:43','bank_transfer',NULL),(5,5,3448.00,0.00,7347.00,'$2y$12$hP0gXcH6c9QQOPb4qxzgtu0Aj9gCtpSn5d9lTuMhQxWXuneb0WtIK','{\"name\":\"Prof. Jefferey Greenfelder III\",\"number\":\"+17149999157\",\"full_name\":\"Dr. Titus Collins\",\"description\":\"Mrs. Gina Beatty\"}','2024-03-15 03:01:43','2024-03-15 03:02:16','bank_transfer',NULL),(6,6,5582.00,0.00,9779.00,'$2y$12$GeGsjIc4qYhLKi0C3QeRnOTNbCMy/PLeMPSBgsukg/QRYoStEgDk6','{\"name\":\"Alvis Bechtelar\",\"number\":\"+18309063123\",\"full_name\":\"Jennyfer Johns\",\"description\":\"Bailey Bailey\"}','2024-03-15 03:01:43','2024-03-15 03:02:18','bank_transfer',NULL),(7,7,821.00,0.00,892.00,'$2y$12$/o57P0svtOmpHwNUVpcgJ.bvFmeJWJRZSpEeAUDKX7oaR1QMl/qne','{\"name\":\"Dr. Dora Johnston III\",\"number\":\"+15316468810\",\"full_name\":\"Waldo King\",\"description\":\"Mckenzie Corwin\"}','2024-03-15 03:01:44','2024-03-15 03:02:19','bank_transfer',NULL),(8,8,4557.00,0.00,9325.00,'$2y$12$VnvEIiMIzJbLpPmIxgaEBOPcIyVcfwtEmJ6KnzrOvDjhgjPvM2PdO','{\"name\":\"Allan Cartwright Sr.\",\"number\":\"+13465571513\",\"full_name\":\"Javonte Kihn\",\"description\":\"Lukas Casper\"}','2024-03-15 03:01:44','2024-03-15 03:02:20','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','[simple-slider style=\"2\" key=\"home-slider\" shape_1=\"fashion/sliders/shape-1.png\" shape_2=\"fashion/sliders/shape-2.png\" shape_3=\"fashion/sliders/shape-3.png\"][/simple-slider][ads style=\"2\" key_1=\"WXAUTIJV1QU0\" key_2=\"7Z5RXBBWV7J2\" key_3=\"JY08TDO8FG1E\" full_width=\"1\"][/ads][ecommerce-categories style=\"slider\" title=\"Popular on the Shofy store.\" description=\"Shop by Category\" category_ids=\"1,2,7,11,18,19\" background_color=\"#F3F5F7\"][/ecommerce-categories][ecommerce-product-groups title=\"Customer Favorite Style Product\" subtitle=\"All Product Shop\" limit=\"8\" tabs=\"all,featured,on-sale,trending,top-rated\"][/ecommerce-product-groups][ecommerce-products title=\"This Week\'s Featured\" subtitle=\"Shop by Category\" by=\"collection\" collection_ids=\"1\" limit=\"5\" style=\"slider-full-width\"][/ecommerce-products][ecommerce-products title=\"Trending Arrivals\" subtitle=\"More to Discover\" by=\"collection\" collection_ids=\"1\" limit=\"5\" style=\"slider-with-ads-sidebar\" ads=\"VKJNCBIBQC1O\"][/ecommerce-products][ecommerce-products title=\"This Week\'s Featured\" subtitle=\"Best Seller This Week\\’s\" by=\"specify\" product_ids=\"3,4,5,6\" limit=\"12\" style=\"slider\" button_label=\"Shop All Now\" button_url=\"/products\"][/ecommerce-products][testimonials style=\"1\" title=\"The Review Are In\" testimonial_ids=\"2,3,4\"][/testimonials][blog-posts title=\"Latest News & Articles\" subtitle=\"Our Blog & News\" type=\"recent\" limit=\"3\" button_label=\"Discover More\" button_url=\"/blog\"][/blog-posts][site-features style=\"2\" quantity=\"4\" title_1=\"Free Delivery\" description_1=\"Orders from all item\" icon_1=\"ti ti-truck-delivery\" title_2=\"Return & Refund\" description_2=\"Money back guarantee\" icon_2=\"ti ti-currency-dollar\" title_3=\"Member Discount\" description_3=\"Every order over $140.00\" icon_3=\"ti ti-discount-2\" title_4=\"Support 24/7\" description_4=\"Contact us 24 hours a day\" icon_4=\"ti ti-headset\"][/site-features][gallery style=\"2\" limit=\"5\"][/gallery]',1,NULL,'full-width',NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(2,'Product Categories','[ads style=\"2\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads][ecommerce-categories style=\"slider\" title=\"Popular on the Shofy store.\" description=\"Shop by Category\" category_ids=\"1,2,7,11,18,19\" background_color=\"#F3F5F7\"][/ecommerce-categories]',1,NULL,'full-width',NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(3,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(4,'Blog',NULL,1,NULL,'full-width',NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(5,'Contact','[contact-form show_contact_form=&quot;1&quot; title=&quot;Sent A Message&quot; quantity=&quot;2&quot; icon_1=&quot;main/contact/icon-1.png&quot; content_1=&quot;contact@shofy.com &lt;br&gt; &lt;strong&gt;+670 413 90 762&lt;/strong&gt;&quot; icon_2=&quot;main/contact/icon-2.png&quot; content_2=&quot;502 New St, Brighton VIC 3186, Australia&quot; show_social_info=&quot;1&quot; social_info_label=&quot;Find on social media&quot; social_info_icon=&quot;main/contact/icon-3.png&quot;][/contact-form][google-map]502 New Street, Brighton VIC, Australia[/google-map]',1,NULL,'full-width',NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(6,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(7,'Our Story','<h4>A passion for handcrafted coffee, brewed with love and community.</h4>\n\n<p>\n    We are a small, family-owned coffee roaster dedicated to bringing the finest, ethically sourced beans to your cup. Our story began in a cozy kitchen, fueled by a shared passion for the rich aroma and invigorating taste of freshly brewed coffee. We dreamt of creating a space where people could connect over a warm cup, share stories, and experience the joy of handcrafted coffee.\n</p>\n\n<h4>From Humble Beginnings to Roasting Success:</h4>\n\n<p>\n    Our journey started with a small coffee roaster nestled in our garage. We spent countless hours experimenting with different roasting profiles, meticulously cupping each batch to achieve the perfect balance of flavor and aroma. Driven by a desire to make a difference, we built relationships with sustainable coffee farms around the world, ensuring fair trade practices and the highest quality beans.\n</p>\n\n<h4>Milestones and More to Come:</h4>\n\n<p>\n    Our dedication to quality and community resonated with coffee lovers, and our small business quickly grew. We opened our first cafe, a warm and inviting space where people could gather, savor our freshly roasted coffee, and connect with friends and neighbors. We\'ve continued to expand, now offering a variety of handcrafted coffee beverages, alongside delicious pastries and light bites.\n</p>\n\n<h4>Values at Our Core:</h4>\n\n<p>\n    At the heart of everything we do lies our commitment to ethical sourcing, sustainable practices, and building meaningful connections. We believe in supporting the communities that cultivate our coffee beans, ensuring fair wages and responsible farming methods. Every cup you enjoy contributes to a positive impact, one sip at a time.\n</p>\n\n<h4>Join us on our journey!</h4>\n\n<p>\n    We invite you to explore our world of coffee, from the rich diversity of our bean origins to the unique flavors crafted through meticulous roasting. Visit our cafe, discover your perfect cup, and become part of our ever-growing coffee community. Let\'s connect over a cup, share stories, and celebrate the simple joy of a well-brewed coffee.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(8,'Careers','<h3>Careers: Be Part of Our Brewing Legacy</h3>\n\n<p>\n    At Shofy, we\'re not just brewing coffee, we\'re brewing a legacy. Since our humble beginnings in 2024, we\'ve grown from a small, family-owned roaster to a thriving coffee haven. But our passion for quality, community, and sustainability remains at the core of everything we do.\n</p>\n\n<h4>Why Join Our Team?</h4>\n\n<ul>\n    <li>\n        <p><strong>Become a Coffee Connoisseur</strong>: Immerse yourself in the world of coffee, learning from experienced roasters and baristas about bean origins, roasting techniques, and crafting the perfect cup.</p>\n    </li>\n    <li>\n        <p><strong>Fuel Your Passion</strong>: Contribute to our mission by sourcing ethically, promoting sustainable practices, and fostering positive relationships with coffee-growing communities around the globe.</p>\n    </li>\n    <li>\n        <p><strong>Grow with Us</strong>: We offer comprehensive training programs and opportunities for professional development, helping you refine your skills and advance your career in the coffee industry.</p>\n    </li>\n    <li>\n        <p><strong>Be Part of the Family</strong>: We cultivate a collaborative and supportive work environment where your unique talents and perspectives are valued.</p>\n    </li>\n</ul>\n\n<h4>Current Openings:</h4>\n\n<ul>\n    <li>\n        <p><strong>Coffee Roaster</strong>: Play a vital role in our roasting process, meticulously crafting unique flavor profiles and ensuring the highest quality beans reach our customers.</p>\n    </li>\n    <li>\n        <p><strong>Barista</strong>: Become a coffee ambassador, welcoming guests with a smile, crafting their perfect cup, and sharing your knowledge and passion for coffee.</p>\n    </li>\n    <li>\n        <p><strong>Cafe Manager</strong>: Lead your team in creating a warm and inviting atmosphere, overseeing daily operations, and ensuring exceptional customer service.</p>\n    </li>\n</ul>\n\n<h4>We are always looking for passionate individuals who share our values:</h4>\n\n<ul>\n    <li>\n        <p>A genuine love for coffee and a desire to learn everything there is to know about it.</p>\n    </li>\n    <li>\n        <p>A commitment to ethical sourcing, sustainability, and social responsibility.</p>\n    </li>\n    <li>\n        <p>Excellent communication and interpersonal skills to build rapport with colleagues and customers.</p>\n    </li>\n    <li>\n        <p>A positive attitude, a willingness to learn, and a collaborative spirit.</p>\n    </li>\n</ul>\n\n<p>Ready to join our brewing legacy?</p>\n\n<p>\n    Submit your resume and cover letter, telling us why you\'re a perfect fit for our team. We look forward to meeting passionate individuals who are ready to brew the future with us, one cup at a time.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49'),(9,'Shipping','<section>\n    <h2>Shipping Methods</h2>\n    <p>We offer several shipping methods to choose from:</p>\n    <ul>\n        <li>Standard Shipping - 3 to 5 business days</li>\n        <li>Express Shipping - 1 to 2 business days</li>\n        <li>International Shipping - 7 to 14 business days</li>\n    </ul>\n    <p>Please note that shipping times may vary depending on your location and other factors.</p>\n</section>\n\n<section>\n    <h2>Shipping Costs</h2>\n    <p>Shipping costs are calculated based on the weight of your order and the shipping method selected during checkout.</p>\n    <p>You can view the estimated shipping costs in your shopping cart before completing your purchase.</p>\n</section>\n\n<section>\n    <h2>Tracking Your Order</h2>\n    <p>Once your order has been shipped, you will receive a confirmation email with a tracking number.</p>\n    <p>You can use this tracking number to monitor the status of your delivery on our website or through the shipping carrier\'s website.</p>\n</section>\n\n<section>\n    <h2>Shipping Restrictions</h2>\n    <p>Some items may be subject to shipping restrictions due to size, weight, or destination.</p>\n    <p>If your order contains any restricted items, we will notify you during the checkout process.</p>\n</section>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:01:49','2024-03-15 03:01:49');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'FFYXTB72KM','cod',NULL,648.00,1,'pending','confirm',10,NULL,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'NBTXDLPIDL','paypal',NULL,1194.00,2,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'08N0WCKD0Z','paystack',NULL,1541.00,3,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'SIFR6V4JJO','bank_transfer',NULL,2516.00,4,'pending','confirm',9,NULL,NULL,'2024-03-15 03:01:50','2024-03-15 03:01:50','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'IJVDCMIRIS','stripe',NULL,517.00,5,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'KVN1XGOEJX','cod',NULL,5629.00,6,'pending','confirm',10,NULL,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'Z93EW02W83','bank_transfer',NULL,4575.00,7,'pending','confirm',9,NULL,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'R4EDARSZII','paystack',NULL,576.00,8,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'W0LIKT2FTT','stripe',NULL,4688.00,9,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:51','2024-03-15 03:01:51','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'XJIPMPBHN6','stripe',NULL,4898.00,10,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:52','2024-03-15 03:01:52','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'3MNGGIXEXA','stripe',NULL,4348.00,11,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:53','2024-03-15 03:01:53','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'N4W1VOVORP','cod',NULL,796.00,12,'pending','confirm',10,NULL,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'7MINZKLGHN','paystack',NULL,3491.00,13,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'WWQHQU2W0Q','stripe',NULL,3228.00,14,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:54','2024-03-15 03:01:54','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'O1U5WR4QKE','stripe',NULL,446.00,15,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'PEDVGNC6JV','paypal',NULL,972.00,16,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'XDXWKQQSHC','cod',NULL,4688.00,17,'pending','confirm',9,NULL,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'K17J16JV8U','stripe',NULL,892.00,18,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:55','2024-03-15 03:01:55','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'SSIRJ1EUZZ','cod',NULL,7347.00,19,'pending','confirm',9,NULL,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'1T9RU25PMO','bank_transfer',NULL,4190.00,20,'pending','confirm',9,NULL,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'CYK99DYCDF','paypal',NULL,1095.00,21,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'WO2HGLDDUU','paystack',NULL,1338.00,22,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'WJTQ8VERMQ','paypal',NULL,7347.00,23,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:56','2024-03-15 03:01:56','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'Y6TKET8D12','stripe',NULL,2471.00,24,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'LOCG29PDF8','cod',NULL,1034.00,25,'pending','confirm',10,NULL,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'NYFXTQAEI0','razorpay',NULL,752.00,26,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'VIZCZHKBQZ','paypal',NULL,6522.00,27,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'YBUAF5QICF','paystack',NULL,1152.00,28,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:57','2024-03-15 03:01:57','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'JLSE27PBXI','paypal',NULL,3276.00,29,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'VOAXMKN4AF','razorpay',NULL,2934.00,30,'completed','confirm',10,NULL,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'G92TTFFX9V','paypal',NULL,376.00,31,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'R38ZZRP7UZ','paystack',NULL,4401.00,32,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:58','2024-03-15 03:01:58','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'MICTRVBLXP','cod',NULL,2516.00,33,'pending','confirm',9,NULL,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'G6RGZCSXRO','stripe',NULL,7413.00,34,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'5FY9W7TG9C','paystack',NULL,2190.00,35,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'NKPMYDCKV3','stripe',NULL,6522.00,36,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'LZP6MQ9QNB','sslcommerz',NULL,3144.00,37,'completed','confirm',9,NULL,NULL,'2024-03-15 03:01:59','2024-03-15 03:01:59','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'CK6OTSY168','paystack',NULL,478.00,38,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'NFTQOBCTPT','cod',NULL,3392.00,39,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'D3L00DERKB','paystack',NULL,3774.00,40,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'AXBJOJOWAM','stripe',NULL,3144.00,41,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'ZTXB6SWTHC','sslcommerz',NULL,3882.00,42,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:00','2024-03-15 03:02:00','Botble\\Ecommerce\\Models\\Customer',NULL),(43,'USD',0,'I1D2BYR9Y2','stripe',NULL,3144.00,43,'completed','confirm',9,NULL,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01','Botble\\Ecommerce\\Models\\Customer',NULL),(44,'USD',0,'VEV5FITWR4','bank_transfer',NULL,347.00,44,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01','Botble\\Ecommerce\\Models\\Customer',NULL),(45,'USD',0,'SZPIHPM26L','sslcommerz',NULL,4348.00,45,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01','Botble\\Ecommerce\\Models\\Customer',NULL),(46,'USD',0,'UUJUCMBM6F','paypal',NULL,892.00,46,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01','Botble\\Ecommerce\\Models\\Customer',NULL),(47,'USD',0,'8BVDSYLFWN','sslcommerz',NULL,1258.00,47,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:01','2024-03-15 03:02:01','Botble\\Ecommerce\\Models\\Customer',NULL),(48,'USD',0,'ZY2N0FYONH','stripe',NULL,430.00,48,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02','Botble\\Ecommerce\\Models\\Customer',NULL),(49,'USD',0,'VV2PL8PKZV','bank_transfer',NULL,3498.00,49,'pending','confirm',10,NULL,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02','Botble\\Ecommerce\\Models\\Customer',NULL),(50,'USD',0,'H2UDGNMJWE','sslcommerz',NULL,4348.00,50,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02','Botble\\Ecommerce\\Models\\Customer',NULL),(51,'USD',0,'H2IDA85O7H','paystack',NULL,796.00,51,'completed','confirm',10,NULL,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02','Botble\\Ecommerce\\Models\\Customer',NULL),(52,'USD',0,'SWXFAOG1UU','cod',NULL,3570.00,52,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:02','2024-03-15 03:02:02','Botble\\Ecommerce\\Models\\Customer',NULL),(53,'USD',0,'N8VL2A5Y7K','cod',NULL,3986.00,53,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:03','2024-03-15 03:02:03','Botble\\Ecommerce\\Models\\Customer',NULL),(54,'USD',0,'KHJOBT9KXV','bank_transfer',NULL,398.00,54,'pending','confirm',9,NULL,NULL,'2024-03-15 03:02:03','2024-03-15 03:02:03','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (1,1),(2,1),(4,2),(5,2),(5,3),(6,3),(5,4),(2,5),(5,5),(3,6),(6,6),(6,7),(2,7),(2,8),(3,9),(6,9),(2,10),(3,10),(1,11),(4,12),(2,12),(6,13),(4,13),(2,14),(5,14),(1,15),(4,15),(3,16),(5,16),(1,17),(4,17),(5,18);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (6,1),(1,1),(6,2),(7,2),(1,2),(5,3),(1,3),(6,3),(7,4),(4,4),(1,4),(3,5),(2,5),(2,6),(1,6),(7,6),(1,7),(6,7),(3,7),(4,8),(2,8),(6,8),(1,9),(7,9),(4,9),(6,10),(4,10),(2,11),(5,11),(3,12),(5,12),(6,13),(7,13),(1,13),(4,14),(8,14),(5,14),(6,15),(2,15),(1,16),(4,16),(2,16),(7,17),(2,17),(4,17),(5,18),(7,18);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','So she began fancying the sort of present!\' thought Alice. One of the court. (As that is rather a handsome pig, I think.\' And she squeezed herself up on to her usual height. It was so much into the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',396,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','Alice again, in a great crowd assembled about them--all sorts of little pebbles came rattling in at once.\' However, she did not quite know what they\'re about!\' \'Read them,\' said the King: \'however.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',460,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(3,'The Top 2020 Handbag Trends to Know','And she\'s such a puzzled expression that she let the Dormouse into the sky. Alice went on in a deep sigh, \'I was a child,\' said the Duchess, it had been. But her sister sat still just as she swam.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',912,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(4,'How to Match the Color of Your Handbag With an Outfit','All this time the Queen to-day?\' \'I should think it was,\' the March Hare had just begun \'Well, of all her wonderful Adventures, till she fancied she heard her sentence three of her head on her lap.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',845,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(5,'How to Care for Leather Bags','Two, in a very decided tone: \'tell her something about the whiting!\' \'Oh, as to prevent its undoing itself,) she carried it out into the court, \'Bring me the truth: did you manage to do so. \'Shall.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-2.jpg',648,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','Alice replied, so eagerly that the pebbles were all in bed!\' On various pretexts they all spoke at once, with a soldier on each side to guard him; and near the King exclaimed, turning to Alice with.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',2089,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(7,'Essential Qualities of Highly Successful Music','In the very tones of the crowd below, and there stood the Queen merely remarking that a moment\'s delay would cost them their lives. All the time they had any dispute with the other side of WHAT?\'.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-12.jpg',2258,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(8,'9 Things I Love About Shaving My Head','King. \'Shan\'t,\' said the Dodo. Then they all cheered. Alice thought she might as well go back, and see how the Dodo suddenly called out to the door, and knocked. \'There\'s no sort of meaning in them.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',2478,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(9,'Why Teamwork Really Makes The Dream Work','Hatter. This piece of it at last, more calmly, though still sobbing a little startled by seeing the Cheshire Cat sitting on a little now and then said \'The fourth.\' \'Two days wrong!\' sighed the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',2014,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(10,'The World Caters to Average People','Duchess began in a hot tureen! Who for such a simple question,\' added the Gryphon; and then they both sat silent and looked into its eyes were looking over his shoulder as he could think of anything.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-10.jpg',1058,NULL,'2024-03-15 03:01:40','2024-03-15 03:01:40'),(11,'The litigants on the screen are not actors','The King laid his hand upon her arm, and timidly said \'Consider, my dear: she is such a very hopeful tone though), \'I won\'t have any pepper in that case I can do without lobsters, you know. Which.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-6.jpg',1940,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(12,'Hiring the Right Sales Team at the Right Time','I don\'t think,\' Alice went timidly up to Alice, they all quarrel so dreadfully one can\'t hear oneself speak--and they don\'t seem to encourage the witness at all: he kept shifting from one minute to.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',1216,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(13,'Fully Embrace the Return of 90s fashion','CHAPTER X. The Lobster Quadrille The Mock Turtle in a tone of the March Hare meekly replied. \'Yes, but I hadn\'t mentioned Dinah!\' she said to the Dormouse, who was gently brushing away some dead.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-7.jpg',1441,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(14,'Exploring the English Countryside','I believe.\' \'Boots and shoes under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you haven\'t found it very much,\' said the Duchess. \'I make you a present of everything I\'ve said as yet.\' \'A.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-7.jpg',115,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(15,'Here’s the First Valentino’s New Makeup Collection','Tortoise because he was obliged to have any pepper in my kitchen AT ALL. Soup does very well to say when I got up and walking away. \'You insult me by talking such nonsense!\' \'I didn\'t write it, and.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',1040,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(16,'Follow Your own Design process, whatever gets','Rabbit\'s little white kid gloves: she took up the fan and the poor little juror (it was Bill, I fancy--Who\'s to go down the hall. After a time there were any tears. No, there were a Duck and a long.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',597,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(17,'Freelancer Days 2024, What’s new?','And Alice was very uncomfortable, and, as the rest of my life.\' \'You are old,\' said the Hatter. \'You MUST remember,\' remarked the King, \'unless it was only sobbing,\' she thought, and rightly too.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-3.jpg',1481,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41'),(18,'Quality Foods Requirments For Every Human Body’s','Five! Always lay the blame on others!\' \'YOU\'D better not talk!\' said Five. \'I heard the King exclaimed, turning to Alice. \'What sort of present!\' thought Alice. One of the earth. Let me see: I\'ll.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-9.jpg',1061,NULL,'2024-03-15 03:01:41','2024-03-15 03:01:41');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_logs`
--

DROP TABLE IF EXISTS `request_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_code` int DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  `user_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_logs`
--

LOCK TABLES `request_logs` WRITE;
/*!40000 ALTER TABLE `request_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.manage.license\":true,\"extensions.index\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.cronjob\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"plugins.captcha\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.settings\":true,\"plugins.ecommerce\":true,\"ecommerce.settings\":true,\"ecommerce.report.index\":true,\"products.index\":true,\"products.create\":true,\"products.edit\":true,\"products.destroy\":true,\"products.duplicate\":true,\"product-categories.index\":true,\"product-categories.create\":true,\"product-categories.edit\":true,\"product-categories.destroy\":true,\"product-tag.index\":true,\"product-tag.create\":true,\"product-tag.edit\":true,\"product-tag.destroy\":true,\"brands.index\":true,\"brands.create\":true,\"brands.edit\":true,\"brands.destroy\":true,\"product-collections.index\":true,\"product-collections.create\":true,\"product-collections.edit\":true,\"product-collections.destroy\":true,\"product-attribute-sets.index\":true,\"product-attribute-sets.create\":true,\"product-attribute-sets.edit\":true,\"product-attribute-sets.destroy\":true,\"product-attributes.index\":true,\"product-attributes.create\":true,\"product-attributes.edit\":true,\"product-attributes.destroy\":true,\"tax.index\":true,\"tax.create\":true,\"tax.edit\":true,\"tax.destroy\":true,\"reviews.index\":true,\"reviews.create\":true,\"reviews.destroy\":true,\"reviews.publish\":true,\"reviews.reply\":true,\"shipping_methods.index\":true,\"ecommerce.shipping-rule-items.index\":true,\"ecommerce.shipping-rule-items.create\":true,\"ecommerce.shipping-rule-items.edit\":true,\"ecommerce.shipping-rule-items.destroy\":true,\"ecommerce.shipping-rule-items.bulk-import\":true,\"ecommerce.shipments.index\":true,\"ecommerce.shipments.create\":true,\"ecommerce.shipments.edit\":true,\"ecommerce.shipments.destroy\":true,\"orders.index\":true,\"orders.create\":true,\"orders.edit\":true,\"orders.destroy\":true,\"discounts.index\":true,\"discounts.create\":true,\"discounts.edit\":true,\"discounts.destroy\":true,\"customers.index\":true,\"customers.create\":true,\"customers.edit\":true,\"customers.destroy\":true,\"flash-sale.index\":true,\"flash-sale.create\":true,\"flash-sale.edit\":true,\"flash-sale.destroy\":true,\"product-label.index\":true,\"product-label.create\":true,\"product-label.edit\":true,\"product-label.destroy\":true,\"ecommerce.import.products.index\":true,\"ecommerce.export.products.index\":true,\"order_returns.index\":true,\"order_returns.edit\":true,\"order_returns.destroy\":true,\"global-option.index\":true,\"global-option.create\":true,\"global-option.edit\":true,\"global-option.destroy\":true,\"ecommerce.invoice.index\":true,\"ecommerce.invoice.edit\":true,\"ecommerce.invoice.destroy\":true,\"ecommerce.invoice-template.index\":true,\"ecommerce.settings.general\":true,\"ecommerce.settings.currencies\":true,\"ecommerce.settings.products\":true,\"ecommerce.settings.product-search\":true,\"ecommerce.settings.digital-products\":true,\"ecommerce.settings.store-locators\":true,\"ecommerce.settings.invoices\":true,\"ecommerce.settings.product-reviews\":true,\"ecommerce.settings.customers\":true,\"ecommerce.settings.shopping\":true,\"ecommerce.settings.taxes\":true,\"ecommerce.settings.shipping\":true,\"ecommerce.settings.tracking\":true,\"ecommerce.settings.standard-and-format\":true,\"ecommerce.settings.checkout\":true,\"ecommerce.settings.return\":true,\"ecommerce.settings.flash-sale\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"location.bulk-import.index\":true,\"location.export.index\":true,\"marketplace.index\":true,\"marketplace.store.index\":true,\"marketplace.store.create\":true,\"marketplace.store.edit\":true,\"marketplace.store.destroy\":true,\"marketplace.store.view\":true,\"marketplace.store.revenue.create\":true,\"marketplace.withdrawal.index\":true,\"marketplace.withdrawal.edit\":true,\"marketplace.withdrawal.destroy\":true,\"marketplace.vendors.index\":true,\"marketplace.unverified-vendors.index\":true,\"marketplace.unverified-vendors.edit\":true,\"marketplace.settings\":true,\"marketplace.reports\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"request-log.index\":true,\"request-log.destroy\":true,\"sale-popup.settings\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true}','Admin users role',1,1,1,'2024-03-15 03:01:34','2024-03-15 03:01:34');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','572ae00ed56c77c4d5a3c3f157e0399a',NULL,'2024-03-15 03:01:50'),(2,'api_enabled','0',NULL,'2024-03-15 03:01:50'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"ecommerce\",\"faq\",\"gallery\",\"location\",\"marketplace\",\"newsletter\",\"payment\",\"paypal\",\"paypal-payout\",\"paystack\",\"razorpay\",\"request-log\",\"sale-popup\",\"shippo\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2024-03-15 03:01:50'),(6,'theme','shofy-fashion',NULL,'2024-03-15 03:01:50'),(7,'show_admin_bar','1',NULL,'2024-03-15 03:01:50'),(8,'payment_cod_status','1',NULL,'2024-03-15 03:01:50'),(9,'payment_bank_transfer_status','1',NULL,'2024-03-15 03:01:50'),(10,'admin_favicon','main/general/favicon.png',NULL,'2024-03-15 03:01:50'),(11,'admin_logo','main/general/logo-white.png',NULL,'2024-03-15 03:01:50'),(12,'permalink-botble-blog-models-post','blog',NULL,'2024-03-15 03:01:50'),(13,'permalink-botble-blog-models-category','blog',NULL,'2024-03-15 03:01:50'),(14,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2024-03-15 03:01:50'),(15,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2024-03-15 03:01:50'),(16,'payment_stripe_payment_type','stripe_checkout',NULL,'2024-03-15 03:01:50'),(17,'plugins_ecommerce_customer_new_order_status','0',NULL,'2024-03-15 03:01:50'),(18,'plugins_ecommerce_admin_new_order_status','0',NULL,'2024-03-15 03:01:50'),(19,'ecommerce_is_enabled_support_digital_products','1',NULL,'2024-03-15 03:01:50'),(20,'ecommerce_load_countries_states_cities_from_location_plugin','0',NULL,'2024-03-15 03:01:50'),(21,'language_hide_default','1',NULL,'2024-03-15 03:01:50'),(22,'language_switcher_display','dropdown',NULL,'2024-03-15 03:01:50'),(23,'language_display','all',NULL,'2024-03-15 03:01:50'),(24,'language_hide_languages','[]',NULL,'2024-03-15 03:01:50'),(25,'ecommerce_store_name','Shofy',NULL,'2024-03-15 03:01:50'),(26,'ecommerce_store_phone','1800979769',NULL,'2024-03-15 03:01:50'),(27,'ecommerce_store_address','502 New Street',NULL,'2024-03-15 03:01:50'),(28,'ecommerce_store_state','Brighton VIC',NULL,'2024-03-15 03:01:50'),(29,'ecommerce_store_city','Brighton VIC',NULL,'2024-03-15 03:01:50'),(30,'ecommerce_store_country','AU',NULL,'2024-03-15 03:01:50'),(31,'announcement_max_width','1390',NULL,'2024-03-15 03:01:50'),(32,'announcement_text_color','#010f1c',NULL,'2024-03-15 03:01:50'),(33,'announcement_background_color','transparent',NULL,'2024-03-15 03:01:50'),(34,'announcement_placement','theme',NULL,'2024-03-15 03:01:50'),(35,'announcement_text_alignment','start',NULL,'2024-03-15 03:01:50'),(36,'announcement_dismissible','0',NULL,'2024-03-15 03:01:50'),(37,'simple_slider_using_assets','0',NULL,'2024-03-15 03:01:50'),(38,'theme-shofy-fashion-site_name','Shofy',NULL,NULL),(39,'theme-shofy-fashion-site_title','Shofy - Multipurpose eCommerce Laravel Script',NULL,NULL),(40,'theme-shofy-fashion-seo_description','Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.',NULL,NULL),(41,'theme-shofy-fashion-copyright','© %Y All Rights Reserved.',NULL,NULL),(42,'theme-shofy-fashion-primary_font','Jost',NULL,NULL),(43,'theme-shofy-fashion-primary_color','#821F40',NULL,NULL),(44,'theme-shofy-fashion-favicon','main/general/favicon.png',NULL,NULL),(45,'theme-shofy-fashion-logo','main/general/logo.png',NULL,NULL),(46,'theme-shofy-fashion-logo_light','main/general/logo-white.png',NULL,NULL),(47,'theme-shofy-fashion-header_style','2',NULL,NULL),(48,'theme-shofy-fashion-preloader_icon','main/general/preloader-icon.png',NULL,NULL),(49,'theme-shofy-fashion-address','502 New Street, Brighton VIC, Australia',NULL,NULL),(50,'theme-shofy-fashion-hotline','8 800 332 65-66',NULL,NULL),(51,'theme-shofy-fashion-email','contact@fartmart.co',NULL,NULL),(52,'theme-shofy-fashion-working_time','Mon - Fri: 07AM - 06PM',NULL,NULL),(53,'theme-shofy-fashion-homepage_id','1',NULL,NULL),(54,'theme-shofy-fashion-blog_page_id','4',NULL,NULL),(55,'theme-shofy-fashion-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(56,'theme-shofy-fashion-cookie_consent_learn_more_url','cookie-policy',NULL,NULL),(57,'theme-shofy-fashion-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(58,'theme-shofy-fashion-number_of_products_per_page','24',NULL,NULL),(59,'theme-shofy-fashion-number_of_cross_sale_product','6',NULL,NULL),(60,'theme-shofy-fashion-ecommerce_products_page_layout','left_sidebar',NULL,NULL),(61,'theme-shofy-fashion-ecommerce_product_item_style','2',NULL,NULL),(62,'theme-shofy-fashion-logo_in_the_checkout_page','main/general/logo.png',NULL,NULL),(63,'theme-shofy-fashion-logo_in_invoices','main/general/logo.png',NULL,NULL),(64,'theme-shofy-fashion-logo_vendor_dashboard','main/general/logo.png',NULL,NULL),(65,'theme-shofy-fashion-404_page_image','main/general/404.png',NULL,NULL),(66,'theme-shofy-fashion-newsletter_popup_enable','1',NULL,NULL),(67,'theme-shofy-fashion-newsletter_popup_image','main/general/newsletter-popup.png',NULL,NULL),(68,'theme-shofy-fashion-newsletter_popup_title','Subscribe Now',NULL,NULL),(69,'theme-shofy-fashion-newsletter_popup_subtitle','Newsletter',NULL,NULL),(70,'theme-shofy-fashion-newsletter_popup_description','Subscribe to our newsletter and get 10% off your first purchase',NULL,NULL),(71,'theme-shofy-fashion-lazy_load_images','1',NULL,NULL),(72,'theme-shofy-fashion-lazy_load_placeholder_image','main/general/placeholder.png',NULL,NULL),(73,'theme-shofy-fashion-breadcrumb_background_image','main/general/breadcrumb.jpg',NULL,NULL),(74,'theme-shofy-fashion-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"Youtube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'The Clothing Collection','fashion/sliders/slider-1.png','/products','New Arrivals 2023',0,'2024-03-15 03:01:45','2024-03-15 03:01:45'),(2,1,'The Summer Collection','fashion/sliders/slider-2.png','/products','Best Selling 2023',1,'2024-03-15 03:01:45','2024-03-15 03:01:45'),(3,1,'Amazing New designs','fashion/sliders/slider-3.png','/products','Winter Has Arrived',2,'2024-03-15 03:01:45','2024-03-15 03:01:45');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2024-03-15 03:01:45','2024-03-15 03:01:45');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=237 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'foodpound',1,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:01:35','2024-03-15 03:01:35'),(2,'itea-jsc',2,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:01:35','2024-03-15 03:01:35'),(3,'soda-brand',3,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:01:35','2024-03-15 03:01:35'),(4,'shofy',4,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:01:35','2024-03-15 03:01:35'),(5,'soda-brand',5,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:01:35','2024-03-15 03:01:35'),(6,'electronic',1,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:01:39','2024-03-15 03:01:39'),(7,'mobile',2,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:01:39','2024-03-15 03:01:39'),(8,'iphone',3,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:01:39','2024-03-15 03:01:39'),(9,'printer',4,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:01:39','2024-03-15 03:01:39'),(10,'office',5,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:01:39','2024-03-15 03:01:39'),(11,'it',6,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:01:39','2024-03-15 03:01:39'),(12,'crisp-bread-cake',1,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(13,'fashion',2,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(14,'electronic',3,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(15,'commercial',4,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(16,'organic-fruits',5,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(17,'ecological',6,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(18,'general',1,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(19,'design',2,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(20,'fashion',3,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(21,'branding',4,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(22,'modern',5,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(23,'nature',6,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(24,'vintage',7,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(25,'sunglasses',8,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:01:40','2024-03-15 03:01:40'),(26,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',1,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(27,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',2,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(28,'the-top-2020-handbag-trends-to-know',3,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(29,'how-to-match-the-color-of-your-handbag-with-an-outfit',4,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(30,'how-to-care-for-leather-bags',5,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(31,'were-crushing-hard-on-summers-10-biggest-bag-trends',6,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(32,'essential-qualities-of-highly-successful-music',7,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(33,'9-things-i-love-about-shaving-my-head',8,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(34,'why-teamwork-really-makes-the-dream-work',9,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:40','2024-03-15 03:01:40'),(35,'the-world-caters-to-average-people',10,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(36,'the-litigants-on-the-screen-are-not-actors',11,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(37,'hiring-the-right-sales-team-at-the-right-time',12,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(38,'fully-embrace-the-return-of-90s-fashion',13,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(39,'exploring-the-english-countryside',14,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(40,'heres-the-first-valentinos-new-makeup-collection',15,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(41,'follow-your-own-design-process-whatever-gets',16,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(42,'freelancer-days-2024-whats-new',17,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(43,'quality-foods-requirments-for-every-human-bodys',18,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:01:41','2024-03-15 03:01:41'),(44,'gopro',1,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(45,'global-office',2,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(46,'young-shop',3,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(47,'global-store',4,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(48,'roberts-store',5,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(49,'stouffer',6,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(50,'starkist',7,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(51,'old-el-paso',8,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:01:44','2024-03-15 03:01:44'),(52,'bags',1,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(53,'clothing',2,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(54,'mens-clothing',3,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(55,'t-shirts',4,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(56,'jeans',5,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(57,'suits',6,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(58,'womens-clothing',7,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(59,'dresses',8,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(60,'blouses',9,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(61,'pants',10,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(62,'footwear',11,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(63,'accessories',12,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(64,'hats',13,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(65,'scarves',14,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(66,'jewelry',15,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(67,'sportswear',16,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(68,'activewear',17,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(69,'running-shoes',18,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(70,'outerwear',19,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:01:45','2024-03-15 03:01:45'),(71,'vintage-denim-jacket',1,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(72,'floral-maxi-dress',2,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(73,'leather-ankle-boots',3,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(74,'knit-turtleneck-sweater-digital',4,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(75,'classic-aviator-sunglasses',5,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(76,'tailored-wool-blazer',6,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(77,'bohemian-fringe-handbag',7,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(78,'silk-scarf-with-geometric-print-digital',8,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(79,'high-waisted-wide-leg-trousers',9,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(80,'embroidered-boho-blouse',10,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(81,'statement-chunky-necklace',11,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(82,'chic-fedora-hat-digital',12,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(83,'strappy-block-heel-sandals',13,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(84,'velvet-evening-gown',14,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(85,'quilted-crossbody-bag',15,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(86,'distressed-skinny-jeans-digital',16,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(87,'lace-up-combat-boots',17,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(88,'cotton-striped-t-shirt-dress',18,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(89,'printed-palazzo-pants',19,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(90,'structured-satchel-bag-digital',20,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(91,'off-shoulder-ruffle-top',21,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(92,'suede-pointed-toe-pumps',22,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(93,'cropped-cable-knit-sweater',23,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(94,'athleisure-jogger-pants-digital',24,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(95,'leopard-print-midi-skirt',25,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(96,'retro-cat-eye-sunglasses',26,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(97,'faux-fur-trimmed-coat',27,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(98,'boho-fringed-kimono-digital',28,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(99,'ruffled-wrap-dress',29,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(100,'beaded-evening-clutch',30,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(101,'wide-brim-floppy-hat',31,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(102,'denim-overall-jumpsuit-digital',32,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(103,'embellished-ballet-flats',33,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(104,'pleated-midi-skirt',34,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(105,'velour-tracksuit-set',35,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(106,'geometric-patterned-cardigan-digital',36,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(107,'buckle-detail-ankle-booties',37,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(108,'embroidered-bomber-jacket',38,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(109,'cowl-neck-knit-poncho',39,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(110,'chunky-knit-infinity-scarf-digital',40,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:02:21'),(111,'retro-high-top-sneakers',41,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(112,'faux-leather-leggings',42,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(113,'metallic-pleated-maxi-skirt',43,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:01:46','2024-03-15 03:01:46'),(114,'perfect',1,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:01:49','2024-03-15 03:01:49'),(115,'new-day',2,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:01:49','2024-03-15 03:01:49'),(116,'happy-day',3,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:01:49','2024-03-15 03:01:49'),(117,'nature',4,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:01:49','2024-03-15 03:01:49'),(118,'morning',5,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:01:49','2024-03-15 03:01:49'),(119,'home',1,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(120,'product-categories',2,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(121,'coupons',3,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(122,'blog',4,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(123,'contact',5,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(124,'cookie-policy',6,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(125,'our-story',7,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(126,'careers',8,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(127,'shipping',9,'Botble\\Page\\Models\\Page','','2024-03-15 03:01:49','2024-03-15 03:01:49'),(128,'vintage-denim-jacket',44,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(129,'floral-maxi-dress',45,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(130,'floral-maxi-dress',46,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(131,'leather-ankle-boots',47,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(132,'leather-ankle-boots',48,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(133,'knit-turtleneck-sweater-digital',49,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(134,'knit-turtleneck-sweater-digital',50,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(135,'knit-turtleneck-sweater-digital',51,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(136,'knit-turtleneck-sweater-digital',52,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(137,'classic-aviator-sunglasses',53,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(138,'classic-aviator-sunglasses',54,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(139,'classic-aviator-sunglasses',55,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(140,'tailored-wool-blazer',56,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(141,'tailored-wool-blazer',57,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(142,'bohemian-fringe-handbag',58,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(143,'bohemian-fringe-handbag',59,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(144,'bohemian-fringe-handbag',60,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(145,'silk-scarf-with-geometric-print-digital',61,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(146,'silk-scarf-with-geometric-print-digital',62,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(147,'silk-scarf-with-geometric-print-digital',63,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(148,'silk-scarf-with-geometric-print-digital',64,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(149,'high-waisted-wide-leg-trousers',65,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(150,'high-waisted-wide-leg-trousers',66,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(151,'embroidered-boho-blouse',67,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(152,'embroidered-boho-blouse',68,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(153,'statement-chunky-necklace',69,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(154,'statement-chunky-necklace',70,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(155,'statement-chunky-necklace',71,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(156,'chic-fedora-hat-digital',72,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(157,'chic-fedora-hat-digital',73,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(158,'strappy-block-heel-sandals',74,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(159,'strappy-block-heel-sandals',75,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(160,'velvet-evening-gown',76,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(161,'quilted-crossbody-bag',77,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(162,'quilted-crossbody-bag',78,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(163,'quilted-crossbody-bag',79,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(164,'distressed-skinny-jeans-digital',80,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(165,'distressed-skinny-jeans-digital',81,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(166,'lace-up-combat-boots',82,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(167,'lace-up-combat-boots',83,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(168,'cotton-striped-t-shirt-dress',84,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(169,'cotton-striped-t-shirt-dress',85,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(170,'cotton-striped-t-shirt-dress',86,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(171,'printed-palazzo-pants',87,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(172,'printed-palazzo-pants',88,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(173,'structured-satchel-bag-digital',89,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(174,'structured-satchel-bag-digital',90,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(175,'structured-satchel-bag-digital',91,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(176,'off-shoulder-ruffle-top',92,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(177,'off-shoulder-ruffle-top',93,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(178,'off-shoulder-ruffle-top',94,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(179,'suede-pointed-toe-pumps',95,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(180,'suede-pointed-toe-pumps',96,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(181,'cropped-cable-knit-sweater',97,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(182,'cropped-cable-knit-sweater',98,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(183,'cropped-cable-knit-sweater',99,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(184,'cropped-cable-knit-sweater',100,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(185,'athleisure-jogger-pants-digital',101,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(186,'athleisure-jogger-pants-digital',102,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(187,'athleisure-jogger-pants-digital',103,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(188,'athleisure-jogger-pants-digital',104,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(189,'leopard-print-midi-skirt',105,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(190,'retro-cat-eye-sunglasses',106,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(191,'retro-cat-eye-sunglasses',107,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(192,'retro-cat-eye-sunglasses',108,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(193,'faux-fur-trimmed-coat',109,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(194,'boho-fringed-kimono-digital',110,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(195,'boho-fringed-kimono-digital',111,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(196,'ruffled-wrap-dress',112,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(197,'ruffled-wrap-dress',113,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(198,'beaded-evening-clutch',114,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(199,'beaded-evening-clutch',115,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(200,'wide-brim-floppy-hat',116,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(201,'wide-brim-floppy-hat',117,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(202,'wide-brim-floppy-hat',118,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(203,'wide-brim-floppy-hat',119,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(204,'denim-overall-jumpsuit-digital',120,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(205,'denim-overall-jumpsuit-digital',121,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(206,'denim-overall-jumpsuit-digital',122,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(207,'denim-overall-jumpsuit-digital',123,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(208,'embellished-ballet-flats',124,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(209,'embellished-ballet-flats',125,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(210,'embellished-ballet-flats',126,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(211,'embellished-ballet-flats',127,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(212,'embellished-ballet-flats',128,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(213,'pleated-midi-skirt',129,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(214,'velour-tracksuit-set',130,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(215,'velour-tracksuit-set',131,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(216,'velour-tracksuit-set',132,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(217,'geometric-patterned-cardigan-digital',133,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(218,'geometric-patterned-cardigan-digital',134,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(219,'buckle-detail-ankle-booties',135,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(220,'buckle-detail-ankle-booties',136,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(221,'embroidered-bomber-jacket',137,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(222,'embroidered-bomber-jacket',138,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(223,'cowl-neck-knit-poncho',139,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(224,'cowl-neck-knit-poncho',140,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(225,'cowl-neck-knit-poncho',141,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(226,'chunky-knit-infinity-scarf-digital',142,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(227,'chunky-knit-infinity-scarf-digital',143,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(228,'retro-high-top-sneakers',144,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(229,'retro-high-top-sneakers',145,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(230,'retro-high-top-sneakers',146,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(231,'faux-leather-leggings',147,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(232,'faux-leather-leggings',148,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(233,'metallic-pleated-maxi-skirt',149,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(234,'metallic-pleated-maxi-skirt',150,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(235,'metallic-pleated-maxi-skirt',151,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21'),(236,'metallic-pleated-maxi-skirt',152,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:02:21','2024-03-15 03:02:21');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'General',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40'),(2,'Design',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40'),(3,'Fashion',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40'),(4,'Branding',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40'),(5,'Modern',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40'),(6,'Nature',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40'),(7,'Vintage',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40'),(8,'Sunglasses',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:01:40','2024-03-15 03:01:40');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'James Dopli','Thanks for all your efforts and teamwork over the last several months!  Thank you so much','main/users/1.jpg','Developer','published','2024-03-15 03:01:44','2024-03-15 03:01:44'),(2,'Theodore Handle','How you use the city or town name is up to you. All results may be freely used in any work.','main/users/10.jpg','CO Founder','published','2024-03-15 03:01:44','2024-03-15 03:01:44'),(3,'Shahnewaz Sakil','Very happy with our choice to take our daughter to Brave care. The entire team was great! Thank you!','main/users/9.jpg','UI/UX Designer','published','2024-03-15 03:01:44','2024-03-15 03:01:44'),(4,'Albert Flores','Wedding day savior! 5 stars. Their bridal collection is a game-changer. Made me feel like a star.','main/users/9.jpg','Bank of America','published','2024-03-15 03:01:44','2024-03-15 03:01:44');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'connelly.julian@cassin.info',NULL,'$2y$12$zdT06oL1zt86gzXHOltEju3g6hzMW/wJzyMCWvEspJ4Wdwwo.jQ6q',NULL,'2024-03-15 03:01:34','2024-03-15 03:01:34','Shannon','Daniel','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInfoWidget','footer_primary_sidebar','shofy-fashion',1,'{\"id\":\"SiteInfoWidget\",\"logo\":\"main\\/general\\/logo.png\",\"logo_height\":50,\"about\":\"Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.\",\"show_social_links\":true}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(2,'CustomMenuWidget','footer_primary_sidebar','shofy-fashion',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"My Account\",\"menu_id\":\"my-account\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(3,'CustomMenuWidget','footer_primary_sidebar','shofy-fashion',3,'{\"id\":\"CustomMenuWidget\",\"name\":\"Information\",\"menu_id\":\"information\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(4,'SiteContactWidget','footer_primary_sidebar','shofy-fashion',4,'{\"id\":\"SiteContactWidget\",\"name\":\"Talk To Us\",\"phone_label\":\"Got Questions? Call us\",\"phone\":\"+670 413 90 762\",\"email\":\"shofy@support.com\",\"address\":\"79 Sleepy Hollow St. Jamaica, New York 1432\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(5,'ProductCategoriesWidget','footer_primary_sidebar','shofy-fashion',5,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Health & Beauty\",\"categories\":[5,6,7,8,10,11,12]}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(6,'ProductCategoriesWidget','footer_primary_sidebar','shofy-fashion',7,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Electronics\",\"categories\":[3,4,15,18,19,20]}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(7,'ProductCategoriesWidget','footer_primary_sidebar','shofy-fashion',8,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Sweet Treats\",\"categories\":[11,12,13,14,15,16,17]}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(8,'ProductCategoriesWidget','footer_primary_sidebar','shofy-fashion',9,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Fashion\",\"categories\":[1,2,3,4,5,6,7,8]}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(9,'NewsletterWidget','footer_top_sidebar','shofy-fashion',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe our Newsletter\",\"subtitle\":\"Sale 20% off all store\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(10,'SiteCopyrightWidget','footer_bottom_sidebar','shofy-fashion',1,'{\"id\":\"SiteCopyrightWidget\",\"content\":\"\\u00a9 %y% All rights Reserved.\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(11,'SiteAcceptedPaymentsWidget','footer_bottom_sidebar','shofy-fashion',2,'{\"id\":\"SiteAcceptedPaymentsWidget\",\"name\":\"Accepted Payments\",\"image\":\"main\\/general\\/footer-pay.png\",\"url\":\"#\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(12,'BlogSearchWidget','blog_sidebar','shofy-fashion',1,'{\"id\":\"BlogSearchWidget\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(13,'BlogAboutMeWidget','blog_sidebar','shofy-fashion',2,'{\"id\":\"BlogAboutMeWidget\",\"name\":\"About Me\",\"author_url\":\"\\/blog\",\"author_avatar\":\"main\\/users\\/4.jpg\",\"author_name\":\"Ravi O\'Leigh\",\"author_role\":\"Photographer & Blogger\",\"author_description\":\"Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient\",\"author_signature\":\"main\\/general\\/signature.png\"}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(14,'BlogPostsWidget','blog_sidebar','shofy-fashion',3,'{\"id\":\"BlogPostsWidget\",\"name\":\"Latest Posts\",\"limit\":3}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(15,'BlogCategoriesWidget','blog_sidebar','shofy-fashion',4,'{\"id\":\"BlogCategoriesWidget\",\"name\":\"Categories\",\"number_display\":6}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(16,'BlogTagsWidget','blog_sidebar','shofy-fashion',5,'{\"id\":\"BlogTagsWidget\",\"name\":\"Popular Tags\",\"number_display\":6}','2024-03-15 03:01:50','2024-03-15 03:01:50'),(17,'ProductDetailInfoWidget','product_details_sidebar','shofy-fashion',1,'{\"id\":\"ProductDetailInfoWidget\",\"messages\":[[{\"key\":\"message\",\"value\":\"30 days easy returns\"}],[{\"key\":\"message\",\"value\":\"Order yours before 2.30pm for same day dispatch\"}]],\"description\":\"Guaranteed safe & secure checkout\",\"image\":\"main\\/general\\/footer-pay.png\"}','2024-03-15 03:01:50','2024-03-15 03:01:50');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-15 17:02:22
