<?php

namespace App\Http\Requests\Validations;

use App\Http\Requests\Request;

class UpdateCategoryRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->route('category');

        return [
            'category_sub_group_id' => 'required',
            'name' =>  'required',
            'slug' =>  'required|alpha_dash|composite_unique:categories, ' . $id,
            'image' => 'mimes:jpg,jpeg,png',
            'active' => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            // 'attribute_type_id.required' => trans('validation.attribute_type_id_required'),
        ];
    }
}
