<p align="center"><img src="https://cdn.worldvectorlogo.com/logos/codeigniter-1.svg" width="100"></p>
<p align="center">Shopping Cart Solution - CodeIgniter and Bootstrap</p>
 
## Bootsrap Responsive Multi-Vendor, MultiLanguage Online Shop Platform

Current versions:

* Codeigniter 3.1.13 (CodeIgniter Foundation)
* Bootstrap 3.3.7

## Donate
<p>If this project help you reduce time to develop, you can give me a cup of coffee to continue its development. Thank you! :)</p>

[![Donate](https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=W5BR6K29BQX7E)

## See also
<p><a href="https://codecanyon.net/item/wp-invoices-pdf-electronic-invoicing-system/36891583" title="Electronic invoicing and warehouse management plugin which allows you to issue, send and download invoices as pdf file">WordPress PDF Invoices Plugin</a> - Create, Send, Manage and Download as PDF or CSV Invoices in Multiple Templates</p>

## Support of following features

1. Multi-Vendor
2. MultiLanguage
3. Virtual products support
4. Multi Templates support
5. API
6. Beautiful administration with high level of access
7. Ajax based shopping cart
8. Checkouts are saved to administration, email notifications for every new order
9. Quantity of products managed from orders
10. Add textual pages
11. Activate and disable pages
12. File manager in administration
13. Integrated blog
14. Email subscribe
15. Easy installation
16. Readable source
17. Complete editing of public texts
18. Receive ![PayPal Ecommerce Integration](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/github/paypalLogo.png "Paypal Integration") payments, also have option for paypal sandbox testing
19. Fast-loading templates for good seo
20. Site color change with easy to use gradient generator
21. Add multilanguage cookie notificator from silktide.com for EU Cookie Law 
22. Multiple templates.. also can easy create your own.. 
23. Bank account payments support
24. Highcharts statistics for orders
25. Discount codes
26. Available on English, Greek, Bulgarian
27. Responsive public pages, responsive administration, responsive vendor pages
28. Advanced search with treeView categories
29. Easy manage of products (new filed for every added language, subcategories are easy to manage)
30. Advanced sorting and order products
31. etc.

## Easy installation in 2 steps
1. Import database.sql to your MySQL database
2. Set <b>database</b>, <b>username</b> and <b>password</b> in application/config/database.php

## Available Languages
- ![CodeIgniter Ecommerce English](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/attachments/lang_flags/en.jpg "English Translation CodeIgniter") English
- ![CodeIgniter Ecommerce Greece](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/attachments/lang_flags/gr.png "Greece Translation CodeIgniter") Greece
- ![CodeIgniter Ecommerce Bulgarian](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/attachments/lang_flags/bg.jpg "Bulgarian Translation CodeIgniter") Bulgarian
- ![CodeIgniter Ecommerce Indonesian](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/attachments/lang_flags/id.jpg "Indonesian Translation CodeIgniter") Indonesian

## Login to administration with
- Administration url - /admin (eg. https://yourwebsite.com/admin)
- Username: admin 
- Password: admin

## Vendors support
- Login url is - /vendor/login (eg. https://yourwebsite.com/vendor/login)
- Vendors are not supported only from "onepage" template.
- Can register new vendor from url - /vendor/register.  (eg. https://yourwebsite.com/vendor/register)
- Vendors must be enabled from administration - /admin (eg. https://yourwebsite.com/admin/settings) Settings -> Multi-Vendor Support (panel).

## Users registration
<p>Users /registration/login (https://yourwebsite.com/registration/login) is added only in <b>greenlabel template</b>. (easily can be added to any other template, just copy files: login.php, signup.php, user.php to the new template directory (application/views/templates) and change your design).</p>
<b>Users can track their orders history only.</b>

## Screenshots of public pages
![MultiLanguage CodeIgniter Template Ecommerce](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/github/templates.png "Multiple Templates")

## Screenshots of vendors pages
![MultiVendor CodeIgniter Template Ecommerce](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/github/vendors_pages.jpg "Vendors Page Preview")

## Screenshot of admin panel
![CodeIgniter Administration Bootstrap](https://raw.githubusercontent.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/master/github/admin_panel4.png "Powerful Administration CodeIgniter")

### How To Write Templates
Read in our wiki - https://github.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/wiki/How-to-write-templates

### Shopping cart peculiarities
Read in our wiki - https://github.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/wiki/Shopping-cart-peculiarities

### Multi Vendor Support
Read in our wiki - https://github.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/wiki/Multi-Vendor-Support

### API Documentation
Read in our wiki - https://github.com/kirilkirkov/Shopping-Cart-Solution-CodeIgniter/wiki/API

### Server Requirements
- PHP version 5.6 or newer (up to 8.1) is recommended.
<p>It should work on 5.3.7 as well, but we strongly advise you NOT to run such old versions of PHP, because of potential security and performance issues, as well as missing features.</p>
