-- MySQL dump 10.13  Distrib 8.3.0, for macos14.2 (arm64)
--
-- Host: 127.0.0.1    Database: shofy
-- ------------------------------------------------------
-- Server version	8.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'bGSck6M5V8SGs2ZO0rxShvJ7bcj3mPxF',1,'2024-03-05 00:58:21','2024-03-05 00:58:21','2024-03-05 00:58:21');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'Ads 1','2029-03-05 00:00:00','not_set','UROL9F9ZZVAA','jewelry/banners/1.jpg','/products',0,1,'published','2024-03-05 00:58:35','2024-03-05 00:58:35',1,NULL,NULL),(2,'Ads 2','2029-03-05 00:00:00','not_set','B30VDBKO7SBF','jewelry/banners/2.jpg','/products',0,2,'published','2024-03-05 00:58:35','2024-03-05 00:58:35',1,NULL,NULL),(3,'Ads 3','2029-03-05 00:00:00','not_set','BN3ZCHLIE95I','jewelry/banners/3.jpg','/products',0,3,'published','2024-03-05 00:58:35','2024-03-05 00:58:35',1,NULL,NULL),(4,'Ads 4','2029-03-05 00:00:00','not_set','QGPRRJ2MPZYA','jewelry/banners/4.jpg','/products',0,4,'published','2024-03-05 00:58:35','2024-03-05 00:58:35',1,NULL,NULL);
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Enjoy free shipping on all orders over $99! Shop now and save on delivery costs.',0,NULL,NULL,0,1,'2024-03-05 07:58:29',NULL,1,'2024-03-05 00:58:29','2024-03-05 00:58:29'),(2,'Announcement 2','Need assistance? Our customer support is available 24/7 to help you with any questions or concerns.',0,NULL,NULL,0,1,'2024-03-05 07:58:29',NULL,1,'2024-03-05 00:58:29','2024-03-05 00:58:29'),(3,'Announcement 3','Shop with confidence! We offer a hassle-free 30 days return service for your peace of mind.',0,NULL,NULL,0,1,'2024-03-05 07:58:29',NULL,1,'2024-03-05 00:58:29','2024-03-05 00:58:29');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Crisp Bread &amp; Cake',0,'Necessitatibus temporibus voluptatem et ex aut non. Voluptatibus nobis odit officia aperiam error illum vel dolor. Non nesciunt maxime ut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(2,'Fashion',0,'Totam dolorem veniam qui ea minima nobis rerum. Dicta perferendis quo iure sunt. Voluptas sit recusandae commodi nulla. Doloremque voluptates corrupti ut animi.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(3,'Electronic',0,'Eligendi suscipit tenetur quia earum. Est voluptatem rem qui tenetur id et. Ducimus vitae ut consequatur nulla qui.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(4,'Commercial',0,'Sint et dolorum temporibus. Sed sint quis neque non quo sunt et deleniti. Expedita quibusdam nulla aut non.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(5,'Organic Fruits',0,'Inventore sequi aut ut soluta esse et. Culpa totam voluptates et illo. Blanditiis quibusdam esse cum aut occaecati ut sunt.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(6,'Ecological',0,'Iusto corrupti dolore maxime quod est. Excepturi maxime et impedit repellat blanditiis aperiam dicta laborum. Expedita ullam dignissimos dicta dolor.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-05 00:58:25','2024-03-05 00:58:25');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Milford Schinner','linnie04@example.net','(509) 657-3688','735 Daniela Curve\nSouth Thomas, IL 40697','Officiis aut sint sit.','Qui repudiandae voluptatum quos quibusdam iusto eligendi saepe. Eaque quae sunt aut qui est facere. Sunt molestiae ullam repudiandae est autem. Sed voluptas minus officia maiores. Odit possimus animi et consectetur. Expedita aspernatur quo est amet. Consequatur sint ut est nihil et et. Odit nisi quis voluptatibus voluptatem aut eos hic. Aut culpa nesciunt ea facere quae.','unread','2024-03-05 00:58:24','2024-03-05 00:58:24'),(2,'Dr. Nathanael Bayer PhD','schmitt.casper@example.com','661-369-0592','6298 Murray Lakes\nMajorberg, NY 78302','Possimus mollitia nisi et voluptatum qui ipsum.','Esse rerum enim est officia placeat et. Velit velit ut ipsum suscipit qui est. Dolor quia nulla ratione et soluta. Aut non nesciunt accusantium numquam. Temporibus sit sed et sequi. Sapiente et enim laudantium numquam minima quisquam. Qui numquam consequatur sit voluptas aspernatur qui fugiat. Dolorem laudantium quia est. Est explicabo aut dolorem sit. Et vitae consequatur nulla. Iste voluptatem recusandae aliquid atque a eius. Sapiente voluptatem non repellendus.','read','2024-03-05 00:58:24','2024-03-05 00:58:24'),(3,'Jackie Wilderman IV','angelina05@example.org','854.385.2471','3228 Palma Center Suite 298\nNorth Enochmouth, OH 15658-1008','Sed numquam aut enim.','Aut temporibus ab et rerum libero. Cupiditate tempora dolor tenetur autem dolorum. Qui illo rerum omnis voluptate. Aut atque animi fuga temporibus corrupti placeat. Et maiores optio est ad qui nam. In odio quis aut. Nisi voluptatum dolore voluptas consequuntur voluptates ipsa. Corporis dolorem animi molestias. Est ut deserunt facilis minus. Sunt omnis animi neque adipisci adipisci sit ut. Dolor voluptate rerum dolor culpa voluptas ut voluptate.','read','2024-03-05 00:58:24','2024-03-05 00:58:24'),(4,'Amparo Mann','cvon@example.net','1-520-445-8291','303 McCullough Mission\nEast Colleenshire, VT 65264-7380','Vel illo consequatur quo aut eligendi.','Consequatur consequatur itaque quibusdam sit quo. Animi sint nihil eaque rerum qui earum. Qui sint aut autem ex ut. Vero excepturi officiis corrupti et autem aspernatur. Occaecati voluptas eius porro qui distinctio aliquid voluptas. Veniam facilis occaecati ut et quos hic. Natus omnis itaque error labore sed pariatur. Rem dolores ut dolorum adipisci maiores non aut.','read','2024-03-05 00:58:24','2024-03-05 00:58:24'),(5,'Jadon Langosh DVM','jannie89@example.com','478-799-9323','39488 Walter Way\nEast Gildaberg, WA 68822-9555','Enim cumque tempora expedita eum quia.','Ducimus esse qui eligendi vel occaecati perferendis. Provident molestias tempora unde aut. Eveniet ea sed omnis qui ad ratione fuga. Labore itaque aliquid qui qui dolor earum voluptatem. Est autem corporis nam deserunt beatae minus quis modi. Velit facilis similique voluptatem quaerat. Debitis dolor voluptatem exercitationem illum odit doloremque dolor. Quaerat laborum ut delectus ut quis nihil sit.','unread','2024-03-05 00:58:24','2024-03-05 00:58:24'),(6,'Doyle Hegmann','okon.dejuan@example.net','931-348-6569','964 Domenico Inlet\nKautzerberg, PA 88774-1487','Magnam non velit dolore dolores quo ab.','Blanditiis assumenda quisquam quae nulla quia delectus accusantium. Repudiandae illo deserunt provident praesentium quibusdam perspiciatis doloribus. Qui aut quis qui. Adipisci facere et iusto. Et dolores iure repellendus id amet corrupti. Consectetur numquam blanditiis ducimus ab voluptatem. Iure est eligendi consequuntur officiis.','read','2024-03-05 00:58:24','2024-03-05 00:58:24'),(7,'Dr. Finn Parker','zula.zboncak@example.com','989.608.9012','403 O\'Reilly Fall Suite 185\nEvalynshire, MT 39656-0307','Quis dolorem culpa voluptatum repellat.','Dolorem voluptates voluptates voluptas inventore. Nostrum enim consequatur distinctio sunt. Eveniet quia mollitia autem. Et culpa maxime voluptates praesentium dolorem. Numquam molestias ullam possimus explicabo amet aut rerum. Hic eos sed est corporis quia facere. A excepturi aliquam porro provident et. Beatae fugiat et rerum.','unread','2024-03-05 00:58:24','2024-03-05 00:58:24'),(8,'Rigoberto Harber I','hgaylord@example.com','724.882.4768','690 Asa Glen Suite 740\nFayview, ID 73979','Dolorem delectus ipsam sit.','Placeat ut fugiat provident voluptate ea minus laudantium. Et quo eveniet est sit id porro. Nihil qui ab ut. Iusto esse dolorum rem quisquam cumque aperiam. Voluptates in beatae ea sunt deleniti officiis vel vero. Laboriosam veniam fuga molestias. Non consequatur molestiae repudiandae quia corrupti. Et consequatur tempore ut ut autem porro ut iste. Eligendi id dolores nostrum quia doloribus velit.','unread','2024-03-05 00:58:24','2024-03-05 00:58:24'),(9,'Mrs. Maxie Skiles IV','blanda.kyla@example.com','(956) 695-8801','10996 Fahey Wells Apt. 547\nTrompview, WA 53208','Est non itaque tenetur eius omnis eum.','Vel ab dolores et dolores sunt officia. Non est culpa id quaerat illum sit. Quas aspernatur a ut quasi velit et enim. Nostrum et distinctio quae totam quia rem ad. Unde qui veritatis beatae voluptatem. Vel doloribus eum autem qui est eveniet autem. Quaerat consequatur soluta velit unde. Ea nesciunt quo expedita odit non non. Cum natus ut atque iste provident. Nam vero facilis voluptas non mollitia.','read','2024-03-05 00:58:24','2024-03-05 00:58:24'),(10,'Dr. Tillman Bruen','meghan.strosin@example.com','1-501-575-6992','8315 Eileen Canyon\nNicolaton, AL 74156-9948','Quia eos adipisci est et aliquid.','Optio et distinctio velit. Est cupiditate ipsam aliquam est perferendis sint atque. Dolor repudiandae quis molestiae aut nam odio. Qui quod aut doloribus aut quas rerum consequuntur. Nulla nobis id repudiandae corporis. Fugiat aperiam quis voluptatibus eligendi quisquam ea. In quam non hic modi laboriosam tenetur quam voluptatum. Et sed voluptas laudantium ea itaque porro. Exercitationem distinctio quia necessitatibus laborum.','unread','2024-03-05 00:58:24','2024-03-05 00:58:24');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'FoodPound','New Snacks Release',NULL,NULL,'published',0,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(2,'iTea JSC','Happy Tea 100% Organic. From $29.9',NULL,NULL,'published',1,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(3,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',2,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(4,'Shofy','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',3,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(5,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',4,1,'2024-03-05 00:58:21','2024-03-05 00:58:21');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(2,'EUR','€',0,2,1,0,0.84,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(3,'VND','₫',0,0,2,0,23203,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(4,'NGN','₦',1,2,2,0,895.52,'2024-03-05 00:58:21','2024-03-05 00:58:21');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Chesley Rolfson','customer@botble.com','+12673951477','CU','Kentucky','Smithambury','9691 Sanford Island Apt. 724',1,1,'2024-03-05 00:58:22','2024-03-05 00:58:22','52054-7169'),(2,'Chesley Rolfson','customer@botble.com','+17346049566','MH','Virginia','Port Gerardville','919 Braun Ports',1,0,'2024-03-05 00:58:22','2024-03-05 00:58:22','23236-4792'),(3,'Hubert Hahn','vendor@botble.com','+15867920810','SX','Wisconsin','South Mateo','31176 Lucas Cove',2,1,'2024-03-05 00:58:22','2024-03-05 00:58:22','01779-7935'),(4,'Hubert Hahn','vendor@botble.com','+19496008103','US','Utah','Russview','98040 Rosenbaum Walks',2,0,'2024-03-05 00:58:22','2024-03-05 00:58:22','26517-3503'),(5,'Avis Bailey','alvis.pfeffer@example.org','+16783770325','IE','Iowa','New Keelyside','80097 Bernardo Inlet',3,1,'2024-03-05 00:58:23','2024-03-05 00:58:23','05250'),(6,'Marquise Hyatt','syble.wisozk@example.org','+16507163035','TJ','Arizona','West Samarahaven','5307 Isai Corners Apt. 695',4,1,'2024-03-05 00:58:23','2024-03-05 00:58:23','79603-7608'),(7,'Kavon Becker','bernard.feest@example.net','+13528583113','EH','Nevada','East Kolebury','9209 Tom Mission Suite 025',5,1,'2024-03-05 00:58:23','2024-03-05 00:58:23','65361-8652'),(8,'Enrique Baumbach','sdaugherty@example.net','+18723253574','NU','New York','Schummville','935 Swaniawski Parkways Suite 925',6,1,'2024-03-05 00:58:23','2024-03-05 00:58:23','34967'),(9,'Louvenia Roberts','edwardo.pagac@example.org','+16513802064','KM','Delaware','East Flaviofort','227 Mandy Road',7,1,'2024-03-05 00:58:24','2024-03-05 00:58:24','63243-2735'),(10,'Eduardo Hahn','gaetano95@example.com','+18595145915','MZ','West Virginia','Kingborough','824 Dusty Greens',8,1,'2024-03-05 00:58:24','2024-03-05 00:58:24','25986-9204'),(11,'Erica Reilly','alisa73@example.org','+16829228399','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',9,1,'2024-03-05 00:58:24','2024-03-05 00:58:24','43658'),(12,'Virgie Krajcik','nnikolaus@example.com','+19183028243','JP','Michigan','Port Jensenland','41020 Henry Junction',10,1,'2024-03-05 00:58:24','2024-03-05 00:58:24','64681-5197');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Chesley Rolfson','customer@botble.com','$2y$12$k8.dvHAOZNdciErqJ/4XQ.AABVwJixxNJcHFzOtfn9km3Ew/S/7gO','main/customers/2.jpg','1994-02-19','+12245202024',NULL,'2024-03-05 00:58:22','2024-03-05 00:58:27','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(2,'Hubert Hahn','vendor@botble.com','$2y$12$lW5rNHBXa5FhO6z2mes9e.Bs4AZEay1CIcKSPOQAHmOv1N47v4v0C','main/customers/3.jpg','1996-03-03','+19846490004',NULL,'2024-03-05 00:58:22','2024-03-05 00:58:27','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(3,'Avis Bailey','alvis.pfeffer@example.org','$2y$12$8Y.ZiyPHKQeqEenamBivPeA4YDzAJjMOPf7zgGaP5YSygHfjVEcQ2','main/customers/1.jpg','1987-03-04','+19305457005',NULL,'2024-03-05 00:58:23','2024-03-05 00:58:27','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(4,'Marquise Hyatt','syble.wisozk@example.org','$2y$12$E8Ohe0VmJAaXa/cD73tehe/2ywe9nubTnDWCIHIAKe/3oRq4L8zXW','main/customers/2.jpg','1978-02-19','+14045524742',NULL,'2024-03-05 00:58:23','2024-03-05 00:58:27','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(5,'Kavon Becker','bernard.feest@example.net','$2y$12$iPZWlKFjKlpw48TGDKlnbuu9TH/WTG4Wo9zU3PnahBz3sFh.r86W6','main/customers/3.jpg','1991-02-24','+19842720134',NULL,'2024-03-05 00:58:23','2024-03-05 00:58:28','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(6,'Enrique Baumbach','sdaugherty@example.net','$2y$12$Pz1p3C1HtIw8cuLgS/jupezgh6GjXenP8jRb3bGBuPjfgwjHRruei','main/customers/4.jpg','1979-02-27','+15342953897',NULL,'2024-03-05 00:58:23','2024-03-05 00:58:28','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(7,'Louvenia Roberts','edwardo.pagac@example.org','$2y$12$YqsrWfV8zQ9cQ4VfOYZ3out99cY7JRyaTkmQGyz17C/uGQe/F9L5i','main/customers/5.jpg','1993-02-24','+15053335278',NULL,'2024-03-05 00:58:24','2024-03-05 00:58:28','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(8,'Eduardo Hahn','gaetano95@example.com','$2y$12$1xt9mXM1DKTuj2Cq5YLIeeWFI55hDkKL.WH.pWKmDLj0pSzY6Z3RK','main/customers/6.jpg','1987-03-03','+18303713032',NULL,'2024-03-05 00:58:24','2024-03-05 00:58:28','2024-03-05 07:58:22',NULL,1,'2024-03-05 07:58:27','activated',NULL),(9,'Erica Reilly','alisa73@example.org','$2y$12$h0.sXQK9iEF519B4GuVWz.49JHFGX5b6YNSUrr2y8M0Oj6p/JeeGy','main/customers/7.jpg','1996-02-06','+14076921095',NULL,'2024-03-05 00:58:24','2024-03-05 00:58:29','2024-03-05 07:58:22',NULL,0,NULL,'activated',NULL),(10,'Virgie Krajcik','nnikolaus@example.com','$2y$12$ROrPBa9xpkmMMLXPF0cUte/3ZdXblSb2qpeJkZy4QQm71qm1sTyLS','main/customers/8.jpg','1977-02-23','+12566510923',NULL,'2024-03-05 00:58:24','2024-03-05 00:58:29','2024-03-05 07:58:22',NULL,0,NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','XGTUWU9NPOND','2024-03-04 07:58:26','2024-03-08 07:58:26',NULL,0,109,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(2,'Discount 2','EURHEECGW08K','2024-03-04 07:58:26',NULL,NULL,0,75,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(3,'Discount 3','X0TMPMGUEBKD','2024-03-04 07:58:26',NULL,NULL,0,14,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(4,'Discount 4','QR6AYACRNXKN','2024-03-04 07:58:26',NULL,NULL,0,132,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(5,'Discount 5','EKAPUEIRZV2C','2024-03-04 07:58:26',NULL,NULL,0,367,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(6,'Discount 6','RM9GCKUC6ISO','2024-03-04 07:58:26','2024-03-27 07:58:26',NULL,0,763,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(7,'Discount 7','SBNWEIWYVILK','2024-03-04 07:58:26',NULL,NULL,0,73,'coupon',0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(8,'Discount 8','QEOQZSTLLJXF','2024-03-04 07:58:26',NULL,NULL,0,222,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(9,'Discount 9','ZPPPTTDRIJCX','2024-03-04 07:58:26','2024-03-21 07:58:26',NULL,0,159,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL),(10,'Discount 10','Q4NJAPNBJGOH','2024-03-04 07:58:26',NULL,NULL,0,446,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL,NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,390,10,5),(1,2,1738.4,7,1),(1,3,1027.95,12,3),(1,4,710.6778,16,1),(1,5,503.58,12,5),(1,6,1247.94,14,4),(1,7,518.88,11,5),(1,8,194.0436,14,5),(1,9,1367.46,14,4),(1,10,850.95,7,1);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2024-03-18 00:00:00','published','2024-03-05 00:58:35','2024-03-05 00:58:35');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(1,2,'2 Year',10,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(1,3,'3 Year',20,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(2,4,'4GB',0,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(2,5,'8GB',10,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(2,6,'16GB',20,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(3,7,'Core i5',0,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(3,8,'Core i7',10,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(3,9,'Core i9',20,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(4,10,'128GB',0,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(4,11,'256GB',10,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(4,12,'512GB',20,9999,0,'2024-03-05 00:58:26','2024-03-05 00:58:26');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2024-03-05 00:58:26','2024-03-05 00:58:26');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
INSERT INTO `ec_invoice_items` VALUES (1,1,'Botble\\Ecommerce\\Models\\Product',92,'Structured Satchel Bag (Digital)',NULL,'jewelry/products/product-6.png',1,1890.00,1890.00,0.00,0.00,1890.00,'{\"sku\":\"MC-157-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-05 00:58:37','2024-03-05 00:58:37'),(2,2,'Botble\\Ecommerce\\Models\\Product',104,'Leopard Print Midi Skirt',NULL,'jewelry/products/product-3.png',1,898.00,898.00,0.00,0.00,898.00,'{\"sku\":\"WI-103-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:37','2024-03-05 00:58:37'),(3,3,'Botble\\Ecommerce\\Models\\Product',148,'Faux Leather Leggings',NULL,'jewelry/products/product-2.png',2,511.00,1022.00,0.00,0.00,1022.00,'{\"sku\":\"J7-129-A0-A2\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}','2024-03-05 00:58:37','2024-03-05 00:58:37'),(4,4,'Botble\\Ecommerce\\Models\\Product',93,'Structured Satchel Bag (Digital)',NULL,'jewelry/products/product-7.png',3,1890.00,5670.00,0.00,0.00,5670.00,'{\"sku\":\"MC-157-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-05 00:58:37','2024-03-05 00:58:37'),(5,5,'Botble\\Ecommerce\\Models\\Product',144,'Chunky Knit Infinity Scarf (Digital)',NULL,'jewelry/products/product-6.png',3,1657.00,4971.00,0.00,0.00,4971.00,'{\"sku\":\"Q9-116-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:37','2024-03-05 00:58:37'),(6,6,'Botble\\Ecommerce\\Models\\Product',44,'Vintage Denim Jacket',NULL,'jewelry/products/product-7.png',1,1300.00,1300.00,0.00,0.00,1300.00,'{\"sku\":\"9U-171-A0\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-05 00:58:38','2024-03-05 00:58:38'),(7,6,'Botble\\Ecommerce\\Models\\Product',110,'Boho Fringed Kimono (Digital)',NULL,'jewelry/products/product-4.png',1,1053.00,1053.00,0.00,0.00,1053.00,'{\"sku\":\"YT-197-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}','2024-03-05 00:58:38','2024-03-05 00:58:38'),(8,7,'Botble\\Ecommerce\\Models\\Product',84,'Lace-Up Combat Boots',NULL,'jewelry/products/product-3.png',1,373.00,373.00,0.00,0.00,373.00,'{\"sku\":\"KF-169-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:58:38','2024-03-05 00:58:38'),(9,8,'Botble\\Ecommerce\\Models\\Product',123,'Embellished Ballet Flats',NULL,'jewelry/products/product-5.png',3,2439.00,7317.00,0.00,0.00,7317.00,'{\"sku\":\"YV-175-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:38','2024-03-05 00:58:38'),(10,9,'Botble\\Ecommerce\\Models\\Product',44,'Vintage Denim Jacket',NULL,'jewelry/products/product-7.png',3,1300.00,3900.00,0.00,0.00,3900.00,'{\"sku\":\"9U-171-A0\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-05 00:58:38','2024-03-05 00:58:38'),(11,9,'Botble\\Ecommerce\\Models\\Product',113,'Ruffled Wrap Dress',NULL,'jewelry/products/product-3.png',1,2089.00,2089.00,0.00,0.00,2089.00,'{\"sku\":\"GD-168-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:38','2024-03-05 00:58:38'),(12,10,'Botble\\Ecommerce\\Models\\Product',118,'Wide Brim Floppy Hat',NULL,'jewelry/products/product-2.png',2,1359.00,2718.00,0.00,0.00,2718.00,'{\"sku\":\"8O-131-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}','2024-03-05 00:58:38','2024-03-05 00:58:38'),(13,11,'Botble\\Ecommerce\\Models\\Product',147,'Faux Leather Leggings',NULL,'jewelry/products/product-7.png',1,511.00,511.00,0.00,0.00,511.00,'{\"sku\":\"J7-129-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:39','2024-03-05 00:58:39'),(14,12,'Botble\\Ecommerce\\Models\\Product',55,'Knit Turtleneck Sweater (Digital)',NULL,'jewelry/products/product-7.png',3,2089.00,6267.00,0.00,0.00,6267.00,'{\"sku\":\"SA-154-A0-A3\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:58:39','2024-03-05 00:58:39'),(15,13,'Botble\\Ecommerce\\Models\\Product',82,'Distressed Skinny Jeans (Digital)',NULL,'jewelry/products/product-6.png',3,1019.00,3057.00,0.00,0.00,3057.00,'{\"sku\":\"JU-167-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-05 00:58:39','2024-03-05 00:58:39'),(16,14,'Botble\\Ecommerce\\Models\\Product',136,'Embroidered Bomber Jacket',NULL,'jewelry/products/product-2.png',1,425.00,425.00,0.00,0.00,425.00,'{\"sku\":\"GA-185-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:39','2024-03-05 00:58:39'),(17,15,'Botble\\Ecommerce\\Models\\Product',147,'Faux Leather Leggings',NULL,'jewelry/products/product-7.png',1,511.00,511.00,0.00,0.00,511.00,'{\"sku\":\"J7-129-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:39','2024-03-05 00:58:39'),(18,16,'Botble\\Ecommerce\\Models\\Product',58,'Tailored Wool Blazer',NULL,'jewelry/products/product-6.png',3,2311.00,6933.00,0.00,0.00,6933.00,'{\"sku\":\"G8-134-A0\",\"attributes\":\"(Color: Red, Size: XL)\"}','2024-03-05 00:58:39','2024-03-05 00:58:39'),(19,17,'Botble\\Ecommerce\\Models\\Product',77,'Velvet Evening Gown',NULL,'jewelry/products/product-6.png',1,1997.00,1997.00,0.00,0.00,1997.00,'{\"sku\":\"2D-191-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-05 00:58:40','2024-03-05 00:58:40'),(20,18,'Botble\\Ecommerce\\Models\\Product',51,'Leather Ankle Boots',NULL,'jewelry/products/product-3.png',2,1869.00,3738.00,0.00,0.00,3738.00,'{\"sku\":\"JW-187-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-05 00:58:40','2024-03-05 00:58:40'),(21,18,'Botble\\Ecommerce\\Models\\Product',73,'Strappy Block Heel Sandals',NULL,'jewelry/products/product-8.png',1,316.00,316.00,0.00,0.00,316.00,'{\"sku\":\"77-101-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}','2024-03-05 00:58:40','2024-03-05 00:58:40'),(22,19,'Botble\\Ecommerce\\Models\\Product',89,'Printed Palazzo Pants',NULL,'jewelry/products/product-5.png',3,2229.00,6687.00,0.00,0.00,6687.00,'{\"sku\":\"ZA-113-A0\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-05 00:58:40','2024-03-05 00:58:40'),(23,19,'Botble\\Ecommerce\\Models\\Product',145,'Retro High-Top Sneakers',NULL,'jewelry/products/product-1.png',1,993.00,993.00,0.00,0.00,993.00,'{\"sku\":\"XP-131-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:40','2024-03-05 00:58:40'),(24,20,'Botble\\Ecommerce\\Models\\Product',60,'Tailored Wool Blazer',NULL,'jewelry/products/product-3.png',1,2311.00,2311.00,0.00,0.00,2311.00,'{\"sku\":\"G8-134-A0-A2\",\"attributes\":\"(Color: Green, Size: XL)\"}','2024-03-05 00:58:40','2024-03-05 00:58:40'),(25,21,'Botble\\Ecommerce\\Models\\Product',65,'Silk Scarf with Geometric Print (Digital)',NULL,'jewelry/products/product-5.png',3,452.00,1356.00,0.00,0.00,1356.00,'{\"sku\":\"L2-113-A0-A1\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-05 00:58:40','2024-03-05 00:58:40'),(26,22,'Botble\\Ecommerce\\Models\\Product',68,'Embroidered Boho Blouse',NULL,'jewelry/products/product-1.png',1,1395.00,1395.00,0.00,0.00,1395.00,'{\"sku\":\"5K-135-A0\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-05 00:58:41','2024-03-05 00:58:41'),(27,23,'Botble\\Ecommerce\\Models\\Product',105,'Leopard Print Midi Skirt',NULL,'jewelry/products/product-6.png',1,898.00,898.00,0.00,0.00,898.00,'{\"sku\":\"WI-103-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:41','2024-03-05 00:58:41'),(28,24,'Botble\\Ecommerce\\Models\\Product',63,'Bohemian Fringe Handbag',NULL,'jewelry/products/product-5.png',3,1081.00,3243.00,0.00,0.00,3243.00,'{\"sku\":\"GV-115-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}','2024-03-05 00:58:41','2024-03-05 00:58:41'),(29,25,'Botble\\Ecommerce\\Models\\Product',123,'Embellished Ballet Flats',NULL,'jewelry/products/product-5.png',1,2439.00,2439.00,0.00,0.00,2439.00,'{\"sku\":\"YV-175-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:41','2024-03-05 00:58:41'),(30,26,'Botble\\Ecommerce\\Models\\Product',71,'Statement Chunky Necklace',NULL,'jewelry/products/product-3.png',1,2447.00,2447.00,0.00,0.00,2447.00,'{\"sku\":\"YC-180-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-05 00:58:41','2024-03-05 00:58:41'),(31,27,'Botble\\Ecommerce\\Models\\Product',80,'Distressed Skinny Jeans (Digital)',NULL,'jewelry/products/product-4.png',2,1019.00,2038.00,0.00,0.00,2038.00,'{\"sku\":\"JU-167-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}','2024-03-05 00:58:41','2024-03-05 00:58:41'),(32,27,'Botble\\Ecommerce\\Models\\Product',145,'Retro High-Top Sneakers',NULL,'jewelry/products/product-1.png',2,993.00,1986.00,0.00,0.00,1986.00,'{\"sku\":\"XP-131-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:41','2024-03-05 00:58:41'),(33,28,'Botble\\Ecommerce\\Models\\Product',86,'Cotton Striped T-Shirt Dress',NULL,'jewelry/products/product-5.png',1,422.00,422.00,0.00,0.00,422.00,'{\"sku\":\"UI-168-A0\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-05 00:58:42','2024-03-05 00:58:42'),(34,28,'Botble\\Ecommerce\\Models\\Product',87,'Cotton Striped T-Shirt Dress',NULL,'jewelry/products/product-4.png',3,422.00,1266.00,0.00,0.00,1266.00,'{\"sku\":\"UI-168-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-05 00:58:42','2024-03-05 00:58:42'),(35,29,'Botble\\Ecommerce\\Models\\Product',89,'Printed Palazzo Pants',NULL,'jewelry/products/product-5.png',1,2229.00,2229.00,0.00,0.00,2229.00,'{\"sku\":\"ZA-113-A0\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-05 00:58:42','2024-03-05 00:58:42'),(36,30,'Botble\\Ecommerce\\Models\\Product',134,'Buckle Detail Ankle Booties',NULL,'jewelry/products/product-1.png',3,1256.00,3768.00,0.00,0.00,3768.00,'{\"sku\":\"RR-116-A0-A3\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:42','2024-03-05 00:58:42'),(37,31,'Botble\\Ecommerce\\Models\\Product',101,'Athleisure Jogger Pants (Digital)',NULL,'jewelry/products/product-5.png',1,1369.00,1369.00,0.00,0.00,1369.00,'{\"sku\":\"OE-123-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-05 00:58:42','2024-03-05 00:58:42'),(38,31,'Botble\\Ecommerce\\Models\\Product',112,'Boho Fringed Kimono (Digital)',NULL,'jewelry/products/product-1.png',1,1053.00,1053.00,0.00,0.00,1053.00,'{\"sku\":\"YT-197-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:42','2024-03-05 00:58:42'),(39,32,'Botble\\Ecommerce\\Models\\Product',108,'Faux Fur Trimmed Coat',NULL,'jewelry/products/product-8.png',3,1201.00,3603.00,0.00,0.00,3603.00,'{\"sku\":\"2F-158-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:43','2024-03-05 00:58:43'),(40,32,'Botble\\Ecommerce\\Models\\Product',137,'Embroidered Bomber Jacket',NULL,'jewelry/products/product-4.png',1,425.00,425.00,0.00,0.00,425.00,'{\"sku\":\"GA-185-A0-A2\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:43','2024-03-05 00:58:43'),(41,33,'Botble\\Ecommerce\\Models\\Product',67,'High-Waisted Wide Leg Trousers',NULL,'jewelry/products/product-1.png',1,1926.00,1926.00,0.00,0.00,1926.00,'{\"sku\":\"NY-195-A0\",\"attributes\":\"(Color: Green, Size: M)\"}','2024-03-05 00:58:43','2024-03-05 00:58:43'),(42,34,'Botble\\Ecommerce\\Models\\Product',75,'Strappy Block Heel Sandals',NULL,'jewelry/products/product-1.png',2,316.00,632.00,0.00,0.00,632.00,'{\"sku\":\"77-101-A0-A2\",\"attributes\":\"(Color: Green, Size: S)\"}','2024-03-05 00:58:43','2024-03-05 00:58:43'),(43,35,'Botble\\Ecommerce\\Models\\Product',92,'Structured Satchel Bag (Digital)',NULL,'jewelry/products/product-6.png',2,1890.00,3780.00,0.00,0.00,3780.00,'{\"sku\":\"MC-157-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-05 00:58:43','2024-03-05 00:58:43'),(44,36,'Botble\\Ecommerce\\Models\\Product',134,'Buckle Detail Ankle Booties',NULL,'jewelry/products/product-1.png',1,1256.00,1256.00,0.00,0.00,1256.00,'{\"sku\":\"RR-116-A0-A3\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:43','2024-03-05 00:58:43'),(45,37,'Botble\\Ecommerce\\Models\\Product',95,'Off-Shoulder Ruffle Top',NULL,'jewelry/products/product-3.png',3,2097.00,6291.00,0.00,0.00,6291.00,'{\"sku\":\"ZI-199-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-05 00:58:43','2024-03-05 00:58:43'),(46,38,'Botble\\Ecommerce\\Models\\Product',105,'Leopard Print Midi Skirt',NULL,'jewelry/products/product-6.png',2,898.00,1796.00,0.00,0.00,1796.00,'{\"sku\":\"WI-103-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:44','2024-03-05 00:58:44'),(47,39,'Botble\\Ecommerce\\Models\\Product',64,'Silk Scarf with Geometric Print (Digital)',NULL,'jewelry/products/product-4.png',2,452.00,904.00,0.00,0.00,904.00,'{\"sku\":\"L2-113-A0\",\"attributes\":\"(Color: Brown, Size: XXL)\"}','2024-03-05 00:58:44','2024-03-05 00:58:44'),(48,39,'Botble\\Ecommerce\\Models\\Product',109,'Faux Fur Trimmed Coat',NULL,'jewelry/products/product-6.png',1,1201.00,1201.00,0.00,0.00,1201.00,'{\"sku\":\"2F-158-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:44','2024-03-05 00:58:44'),(49,40,'Botble\\Ecommerce\\Models\\Product',79,'Quilted Crossbody Bag',NULL,'jewelry/products/product-4.png',3,906.00,2718.00,0.00,0.00,2718.00,'{\"sku\":\"N8-103-A0\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-05 00:58:44','2024-03-05 00:58:44'),(50,41,'Botble\\Ecommerce\\Models\\Product',53,'Knit Turtleneck Sweater (Digital)',NULL,'jewelry/products/product-3.png',1,2089.00,2089.00,0.00,0.00,2089.00,'{\"sku\":\"SA-154-A0-A1\",\"attributes\":\"(Size: L, Color: Brown)\"}','2024-03-05 00:58:44','2024-03-05 00:58:44'),(51,42,'Botble\\Ecommerce\\Models\\Product',97,'Suede Pointed-Toe Pumps',NULL,'jewelry/products/product-6.png',3,1605.00,4815.00,0.00,0.00,4815.00,'{\"sku\":\"Y2-120-A0\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-05 00:58:44','2024-03-05 00:58:44'),(52,43,'Botble\\Ecommerce\\Models\\Product',123,'Embellished Ballet Flats',NULL,'jewelry/products/product-5.png',3,2439.00,7317.00,0.00,0.00,7317.00,'{\"sku\":\"YV-175-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}','2024-03-05 00:58:45','2024-03-05 00:58:45'),(53,44,'Botble\\Ecommerce\\Models\\Product',131,'Buckle Detail Ankle Booties',NULL,'jewelry/products/product-7.png',3,1256.00,3768.00,0.00,0.00,3768.00,'{\"sku\":\"RR-116-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}','2024-03-05 00:58:45','2024-03-05 00:58:45'),(54,45,'Botble\\Ecommerce\\Models\\Product',50,'Leather Ankle Boots',NULL,'jewelry/products/product-2.png',2,1869.00,3738.00,0.00,0.00,3738.00,'{\"sku\":\"JW-187-A0-A1\",\"attributes\":\"(Size: S, Color: Blue)\"}','2024-03-05 00:58:45','2024-03-05 00:58:45'),(55,46,'Botble\\Ecommerce\\Models\\Product',84,'Lace-Up Combat Boots',NULL,'jewelry/products/product-3.png',2,373.00,746.00,0.00,0.00,746.00,'{\"sku\":\"KF-169-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-05 00:58:45','2024-03-05 00:58:45'),(56,47,'Botble\\Ecommerce\\Models\\Product',117,'Wide Brim Floppy Hat',NULL,'jewelry/products/product-7.png',3,1359.00,4077.00,0.00,0.00,4077.00,'{\"sku\":\"8O-131-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-05 00:58:45','2024-03-05 00:58:45'),(57,48,'Botble\\Ecommerce\\Models\\Product',80,'Distressed Skinny Jeans (Digital)',NULL,'jewelry/products/product-4.png',2,1019.00,2038.00,0.00,0.00,2038.00,'{\"sku\":\"JU-167-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}','2024-03-05 00:58:45','2024-03-05 00:58:45'),(58,49,'Botble\\Ecommerce\\Models\\Product',93,'Structured Satchel Bag (Digital)',NULL,'jewelry/products/product-7.png',1,1890.00,1890.00,0.00,0.00,1890.00,'{\"sku\":\"MC-157-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}','2024-03-05 00:58:46','2024-03-05 00:58:46'),(59,50,'Botble\\Ecommerce\\Models\\Product',109,'Faux Fur Trimmed Coat',NULL,'jewelry/products/product-6.png',2,1201.00,2402.00,0.00,0.00,2402.00,'{\"sku\":\"2F-158-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:46','2024-03-05 00:58:46'),(60,51,'Botble\\Ecommerce\\Models\\Product',117,'Wide Brim Floppy Hat',NULL,'jewelry/products/product-7.png',2,1359.00,2718.00,0.00,0.00,2718.00,'{\"sku\":\"8O-131-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-05 00:58:46','2024-03-05 00:58:46'),(61,52,'Botble\\Ecommerce\\Models\\Product',97,'Suede Pointed-Toe Pumps',NULL,'jewelry/products/product-6.png',1,1605.00,1605.00,0.00,0.00,1605.00,'{\"sku\":\"Y2-120-A0\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-05 00:58:46','2024-03-05 00:58:46'),(62,53,'Botble\\Ecommerce\\Models\\Product',107,'Retro Cat-Eye Sunglasses',NULL,'jewelry/products/product-5.png',2,1088.00,2176.00,0.00,0.00,2176.00,'{\"sku\":\"ZP-147-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:46','2024-03-05 00:58:46'),(63,54,'Botble\\Ecommerce\\Models\\Product',147,'Faux Leather Leggings',NULL,'jewelry/products/product-7.png',3,511.00,1533.00,0.00,0.00,1533.00,'{\"sku\":\"J7-129-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-05 00:58:46','2024-03-05 00:58:46');
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
INSERT INTO `ec_invoices` VALUES (1,'Botble\\Ecommerce\\Models\\Order',1,'INV-1','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1890.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1890.00,NULL,1,'pending',NULL,'2024-02-20 16:58:37','2024-03-05 00:58:37'),(2,'Botble\\Ecommerce\\Models\\Order',2,'INV-2','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,898.00,0.00,0.00,0.00,'1','default',NULL,NULL,898.00,NULL,2,'pending',NULL,'2024-02-24 00:58:37','2024-03-05 00:58:37'),(3,'Botble\\Ecommerce\\Models\\Order',3,'INV-3','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1022.00,0.00,0.00,0.00,'1','default',NULL,NULL,1022.00,NULL,3,'completed','2024-03-05 00:58:37','2024-03-03 08:58:37','2024-03-05 00:58:37'),(4,'Botble\\Ecommerce\\Models\\Order',4,'INV-4','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,5670.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5670.00,NULL,4,'pending',NULL,'2024-02-24 12:58:37','2024-03-05 00:58:37'),(5,'Botble\\Ecommerce\\Models\\Order',5,'INV-5','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,4971.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4971.00,NULL,5,'completed','2024-03-05 00:58:37','2024-02-19 18:58:37','2024-03-05 00:58:37'),(6,'Botble\\Ecommerce\\Models\\Order',6,'INV-6','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2353.00,0.00,0.00,0.00,'1','default',NULL,NULL,2353.00,NULL,6,'completed','2024-03-05 00:58:38','2024-02-19 00:58:38','2024-03-05 00:58:38'),(7,'Botble\\Ecommerce\\Models\\Order',7,'INV-7','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,373.00,0.00,0.00,0.00,'1','default',NULL,NULL,373.00,NULL,7,'completed','2024-03-05 00:58:38','2024-02-25 12:58:38','2024-03-05 00:58:38'),(8,'Botble\\Ecommerce\\Models\\Order',8,'INV-8','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,7317.00,0.00,0.00,0.00,'1','default',NULL,NULL,7317.00,NULL,8,'completed','2024-03-05 00:58:38','2024-02-22 16:58:38','2024-03-05 00:58:38'),(9,'Botble\\Ecommerce\\Models\\Order',9,'INV-9','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,5989.00,0.00,0.00,0.00,'1','default',NULL,NULL,5989.00,NULL,9,'completed','2024-03-05 00:58:38','2024-02-23 08:58:38','2024-03-05 00:58:38'),(10,'Botble\\Ecommerce\\Models\\Order',10,'INV-10','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2718.00,0.00,0.00,0.00,'1','default',NULL,NULL,2718.00,NULL,10,'completed','2024-03-05 00:58:38','2024-02-20 16:58:38','2024-03-05 00:58:38'),(11,'Botble\\Ecommerce\\Models\\Order',11,'INV-11','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,511.00,0.00,0.00,0.00,'1','default',NULL,NULL,511.00,NULL,11,'completed','2024-03-05 00:58:39','2024-02-27 08:58:39','2024-03-05 00:58:39'),(12,'Botble\\Ecommerce\\Models\\Order',12,'INV-12','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,6267.00,0.00,0.00,0.00,NULL,'',NULL,NULL,6267.00,NULL,12,'completed','2024-03-05 00:58:39','2024-02-21 12:58:39','2024-03-05 00:58:39'),(13,'Botble\\Ecommerce\\Models\\Order',13,'INV-13','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,3057.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3057.00,NULL,13,'completed','2024-03-05 00:58:39','2024-02-27 18:58:39','2024-03-05 00:58:39'),(14,'Botble\\Ecommerce\\Models\\Order',14,'INV-14','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,425.00,0.00,0.00,0.00,'1','default',NULL,NULL,425.00,NULL,14,'completed','2024-03-05 00:58:39','2024-02-25 06:58:39','2024-03-05 00:58:39'),(15,'Botble\\Ecommerce\\Models\\Order',15,'INV-15','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,511.00,0.00,0.00,0.00,'1','default',NULL,NULL,511.00,NULL,15,'completed','2024-03-05 00:58:39','2024-03-02 12:58:39','2024-03-05 00:58:39'),(16,'Botble\\Ecommerce\\Models\\Order',16,'INV-16','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,6933.00,0.00,0.00,0.00,'1','default',NULL,NULL,6933.00,NULL,16,'completed','2024-03-05 00:58:39','2024-02-23 12:58:39','2024-03-05 00:58:39'),(17,'Botble\\Ecommerce\\Models\\Order',17,'INV-17','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1997.00,0.00,0.00,0.00,'1','default',NULL,NULL,1997.00,NULL,17,'completed','2024-03-05 00:58:40','2024-02-22 08:58:40','2024-03-05 00:58:40'),(18,'Botble\\Ecommerce\\Models\\Order',18,'INV-18','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,4054.00,0.00,0.00,0.00,'1','default',NULL,NULL,4054.00,NULL,18,'completed','2024-03-05 00:58:40','2024-02-27 12:58:40','2024-03-05 00:58:40'),(19,'Botble\\Ecommerce\\Models\\Order',19,'INV-19','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,7680.00,0.00,0.00,0.00,'1','default',NULL,NULL,7680.00,NULL,19,'completed','2024-03-05 00:58:40','2024-02-23 04:58:40','2024-03-05 00:58:40'),(20,'Botble\\Ecommerce\\Models\\Order',20,'INV-20','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2311.00,0.00,0.00,0.00,'1','default',NULL,NULL,2311.00,NULL,20,'pending',NULL,'2024-02-28 00:58:40','2024-03-05 00:58:40'),(21,'Botble\\Ecommerce\\Models\\Order',21,'INV-21','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1356.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1356.00,NULL,21,'completed','2024-03-05 00:58:40','2024-02-26 00:58:40','2024-03-05 00:58:40'),(22,'Botble\\Ecommerce\\Models\\Order',22,'INV-22','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1395.00,0.00,0.00,0.00,'1','default',NULL,NULL,1395.00,NULL,22,'completed','2024-03-05 00:58:40','2024-03-01 00:58:40','2024-03-05 00:58:41'),(23,'Botble\\Ecommerce\\Models\\Order',23,'INV-23','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,898.00,0.00,0.00,0.00,'1','default',NULL,NULL,898.00,NULL,23,'completed','2024-03-05 00:58:41','2024-02-28 00:58:41','2024-03-05 00:58:41'),(24,'Botble\\Ecommerce\\Models\\Order',24,'INV-24','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,3243.00,0.00,0.00,0.00,'1','default',NULL,NULL,3243.00,NULL,24,'completed','2024-03-05 00:58:41','2024-02-24 20:58:41','2024-03-05 00:58:41'),(25,'Botble\\Ecommerce\\Models\\Order',25,'INV-25','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2439.00,0.00,0.00,0.00,'1','default',NULL,NULL,2439.00,NULL,25,'completed','2024-03-05 00:58:41','2024-02-25 18:58:41','2024-03-05 00:58:41'),(26,'Botble\\Ecommerce\\Models\\Order',26,'INV-26','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,2447.00,0.00,0.00,0.00,'1','default',NULL,NULL,2447.00,NULL,26,'completed','2024-03-05 00:58:41','2024-03-01 16:58:41','2024-03-05 00:58:41'),(27,'Botble\\Ecommerce\\Models\\Order',27,'INV-27','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,4024.00,0.00,0.00,0.00,'1','default',NULL,NULL,4024.00,NULL,27,'completed','2024-03-05 00:58:41','2024-02-25 16:58:41','2024-03-05 00:58:41'),(28,'Botble\\Ecommerce\\Models\\Order',28,'INV-28','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,1688.00,0.00,0.00,0.00,'1','default',NULL,NULL,1688.00,NULL,28,'completed','2024-03-05 00:58:42','2024-02-26 12:58:42','2024-03-05 00:58:42'),(29,'Botble\\Ecommerce\\Models\\Order',29,'INV-29','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,2229.00,0.00,0.00,0.00,'1','default',NULL,NULL,2229.00,NULL,29,'pending',NULL,'2024-03-01 06:58:42','2024-03-05 00:58:42'),(30,'Botble\\Ecommerce\\Models\\Order',30,'INV-30','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,3768.00,0.00,0.00,0.00,'1','default',NULL,NULL,3768.00,NULL,30,'completed','2024-03-05 00:58:42','2024-02-26 12:58:42','2024-03-05 00:58:42'),(31,'Botble\\Ecommerce\\Models\\Order',31,'INV-31','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,2422.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2422.00,NULL,31,'completed','2024-03-05 00:58:42','2024-02-29 08:58:42','2024-03-05 00:58:42'),(32,'Botble\\Ecommerce\\Models\\Order',32,'INV-32','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,4028.00,0.00,0.00,0.00,'1','default',NULL,NULL,4028.00,NULL,32,'completed','2024-03-05 00:58:43','2024-03-01 16:58:42','2024-03-05 00:58:43'),(33,'Botble\\Ecommerce\\Models\\Order',33,'INV-33','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1926.00,0.00,0.00,0.00,'1','default',NULL,NULL,1926.00,NULL,33,'completed','2024-03-05 00:58:43','2024-03-02 02:58:43','2024-03-05 00:58:43'),(34,'Botble\\Ecommerce\\Models\\Order',34,'INV-34','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,632.00,0.00,0.00,0.00,'1','default',NULL,NULL,632.00,NULL,34,'completed','2024-03-05 00:58:43','2024-03-03 06:58:43','2024-03-05 00:58:43'),(35,'Botble\\Ecommerce\\Models\\Order',35,'INV-35','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,3780.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3780.00,NULL,35,'completed','2024-03-05 00:58:43','2024-03-04 10:58:43','2024-03-05 00:58:43'),(36,'Botble\\Ecommerce\\Models\\Order',36,'INV-36','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1256.00,0.00,0.00,0.00,'1','default',NULL,NULL,1256.00,NULL,36,'pending',NULL,'2024-03-03 06:58:43','2024-03-05 00:58:43'),(37,'Botble\\Ecommerce\\Models\\Order',37,'INV-37','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,6291.00,0.00,0.00,0.00,'1','default',NULL,NULL,6291.00,NULL,37,'completed','2024-03-05 00:58:43','2024-03-03 12:58:43','2024-03-05 00:58:43'),(38,'Botble\\Ecommerce\\Models\\Order',38,'INV-38','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,1796.00,0.00,0.00,0.00,'1','default',NULL,NULL,1796.00,NULL,38,'completed','2024-03-05 00:58:44','2024-03-04 12:58:44','2024-03-05 00:58:44'),(39,'Botble\\Ecommerce\\Models\\Order',39,'INV-39','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2105.00,0.00,0.00,0.00,'1','default',NULL,NULL,2105.00,NULL,39,'completed','2024-03-05 00:58:44','2024-03-01 16:58:44','2024-03-05 00:58:44'),(40,'Botble\\Ecommerce\\Models\\Order',40,'INV-40','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2718.00,0.00,0.00,0.00,'1','default',NULL,NULL,2718.00,NULL,40,'pending',NULL,'2024-03-04 04:58:44','2024-03-05 00:58:44'),(41,'Botble\\Ecommerce\\Models\\Order',41,'INV-41','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,2089.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2089.00,NULL,41,'pending',NULL,'2024-03-04 16:58:44','2024-03-05 00:58:44'),(42,'Botble\\Ecommerce\\Models\\Order',42,'INV-42','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,4815.00,0.00,0.00,0.00,'1','default',NULL,NULL,4815.00,NULL,42,'completed','2024-03-05 00:58:44','2024-03-04 08:58:44','2024-03-05 00:58:44'),(43,'Botble\\Ecommerce\\Models\\Order',43,'INV-43','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,7317.00,0.00,0.00,0.00,'1','default',NULL,NULL,7317.00,NULL,43,'completed','2024-03-05 00:58:45','2024-03-04 00:58:45','2024-03-05 00:58:45'),(44,'Botble\\Ecommerce\\Models\\Order',44,'INV-44','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,3768.00,0.00,0.00,0.00,'1','default',NULL,NULL,3768.00,NULL,44,'pending',NULL,'2024-03-04 00:58:45','2024-03-05 00:58:45'),(45,'Botble\\Ecommerce\\Models\\Order',45,'INV-45','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,3738.00,0.00,0.00,0.00,'1','default',NULL,NULL,3738.00,NULL,45,'pending',NULL,'2024-03-03 12:58:45','2024-03-05 00:58:45'),(46,'Botble\\Ecommerce\\Models\\Order',46,'INV-46','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,746.00,0.00,0.00,0.00,'1','default',NULL,NULL,746.00,NULL,46,'completed','2024-03-05 00:58:45','2024-03-04 06:58:45','2024-03-05 00:58:45'),(47,'Botble\\Ecommerce\\Models\\Order',47,'INV-47','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,4077.00,0.00,0.00,0.00,'1','default',NULL,NULL,4077.00,NULL,47,'pending',NULL,'2024-03-03 18:58:45','2024-03-05 00:58:45'),(48,'Botble\\Ecommerce\\Models\\Order',48,'INV-48','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2038.00,0.00,0.00,0.00,NULL,'',NULL,NULL,2038.00,NULL,48,'pending',NULL,'2024-03-04 04:58:45','2024-03-05 00:58:45'),(49,'Botble\\Ecommerce\\Models\\Order',49,'INV-49','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,1890.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1890.00,NULL,49,'completed','2024-03-05 00:58:46','2024-03-04 04:58:46','2024-03-05 00:58:46'),(50,'Botble\\Ecommerce\\Models\\Order',50,'INV-50','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2402.00,0.00,0.00,0.00,'1','default',NULL,NULL,2402.00,NULL,50,'completed','2024-03-05 00:58:46','2024-03-04 00:58:46','2024-03-05 00:58:46'),(51,'Botble\\Ecommerce\\Models\\Order',51,'INV-51','Erica Reilly','',NULL,'alisa73@example.org','+16829228399','8138 Chanelle Roads Suite 104, Isobelview, Arkansas, CH',NULL,2718.00,0.00,0.00,0.00,'1','default',NULL,NULL,2718.00,NULL,51,'completed','2024-03-05 00:58:46','2024-03-04 16:58:46','2024-03-05 00:58:46'),(52,'Botble\\Ecommerce\\Models\\Order',52,'INV-52','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,1605.00,0.00,0.00,0.00,'1','default',NULL,NULL,1605.00,NULL,52,'completed','2024-03-05 00:58:46','2024-03-04 14:58:46','2024-03-05 00:58:46'),(53,'Botble\\Ecommerce\\Models\\Order',53,'INV-53','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,2176.00,0.00,0.00,0.00,'1','default',NULL,NULL,2176.00,NULL,53,'completed','2024-03-05 00:58:46','2024-03-04 14:58:46','2024-03-05 00:58:46'),(54,'Botble\\Ecommerce\\Models\\Order',54,'INV-54','Virgie Krajcik','',NULL,'nnikolaus@example.com','+19183028243','41020 Henry Junction, Port Jensenland, Michigan, JP',NULL,1533.00,0.00,0.00,0.00,'1','default',NULL,NULL,1533.00,NULL,54,'completed','2024-03-05 00:58:46','2024-03-04 18:58:46','2024-03-05 00:58:46');
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',1,'43658','shipping_address'),(2,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',2,'43658','shipping_address'),(3,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',3,'43658','shipping_address'),(4,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',4,'64681-5197','shipping_address'),(5,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',5,'64681-5197','shipping_address'),(6,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',6,'43658','shipping_address'),(7,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',7,'64681-5197','shipping_address'),(8,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',8,'64681-5197','shipping_address'),(9,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',9,'43658','shipping_address'),(10,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',10,'43658','shipping_address'),(11,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',11,'43658','shipping_address'),(12,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',12,'64681-5197','shipping_address'),(13,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',13,'64681-5197','shipping_address'),(14,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',14,'64681-5197','shipping_address'),(15,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',15,'64681-5197','shipping_address'),(16,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',16,'43658','shipping_address'),(17,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',17,'43658','shipping_address'),(18,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',18,'64681-5197','shipping_address'),(19,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',19,'64681-5197','shipping_address'),(20,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',20,'43658','shipping_address'),(21,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',21,'43658','shipping_address'),(22,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',22,'43658','shipping_address'),(23,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',23,'43658','shipping_address'),(24,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',24,'43658','shipping_address'),(25,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',25,'43658','shipping_address'),(26,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',26,'64681-5197','shipping_address'),(27,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',27,'64681-5197','shipping_address'),(28,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',28,'64681-5197','shipping_address'),(29,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',29,'64681-5197','shipping_address'),(30,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',30,'64681-5197','shipping_address'),(31,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',31,'64681-5197','shipping_address'),(32,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',32,'64681-5197','shipping_address'),(33,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',33,'43658','shipping_address'),(34,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',34,'43658','shipping_address'),(35,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',35,'43658','shipping_address'),(36,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',36,'43658','shipping_address'),(37,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',37,'64681-5197','shipping_address'),(38,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',38,'64681-5197','shipping_address'),(39,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',39,'43658','shipping_address'),(40,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',40,'43658','shipping_address'),(41,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',41,'64681-5197','shipping_address'),(42,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',42,'64681-5197','shipping_address'),(43,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',43,'64681-5197','shipping_address'),(44,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',44,'64681-5197','shipping_address'),(45,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',45,'64681-5197','shipping_address'),(46,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',46,'64681-5197','shipping_address'),(47,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',47,'64681-5197','shipping_address'),(48,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',48,'43658','shipping_address'),(49,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',49,'43658','shipping_address'),(50,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',50,'43658','shipping_address'),(51,'Erica Reilly','+16829228399','alisa73@example.org','CH','Arkansas','Isobelview','8138 Chanelle Roads Suite 104',51,'43658','shipping_address'),(52,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',52,'64681-5197','shipping_address'),(53,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',53,'64681-5197','shipping_address'),(54,'Virgie Krajcik','+19183028243','nnikolaus@example.com','JP','Michigan','Port Jensenland','41020 Henry Junction',54,'64681-5197','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2024-02-20 16:58:37','2024-02-20 16:58:37'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2024-02-20 16:58:37','2024-02-20 16:58:37'),(3,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2024-02-24 00:58:37','2024-02-24 00:58:37'),(4,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2024-02-24 00:58:37','2024-02-24 00:58:37'),(5,'create_shipment','Created shipment for order',0,2,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37'),(6,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37'),(7,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2024-03-03 08:58:37','2024-03-03 08:58:37'),(8,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2024-03-03 08:58:37','2024-03-03 08:58:37'),(9,'confirm_payment','Payment was confirmed (amount $1,022.00) by %user_name%',0,3,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37'),(10,'create_shipment','Created shipment for order',0,3,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37'),(11,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37'),(12,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2024-02-24 12:58:37','2024-02-24 12:58:37'),(13,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2024-02-24 12:58:37','2024-02-24 12:58:37'),(14,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2024-02-19 18:58:37','2024-02-19 18:58:37'),(15,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2024-02-19 18:58:37','2024-02-19 18:58:37'),(16,'confirm_payment','Payment was confirmed (amount $4,971.00) by %user_name%',0,5,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37'),(17,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,5,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(18,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2024-02-19 00:58:38','2024-02-19 00:58:38'),(19,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2024-02-19 00:58:38','2024-02-19 00:58:38'),(20,'confirm_payment','Payment was confirmed (amount $2,353.00) by %user_name%',0,6,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(21,'create_shipment','Created shipment for order',0,6,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(22,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(23,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2024-02-25 12:58:38','2024-02-25 12:58:38'),(24,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2024-02-25 12:58:38','2024-02-25 12:58:38'),(25,'confirm_payment','Payment was confirmed (amount $373.00) by %user_name%',0,7,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(26,'create_shipment','Created shipment for order',0,7,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(27,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2024-02-22 16:58:38','2024-02-22 16:58:38'),(28,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2024-02-22 16:58:38','2024-02-22 16:58:38'),(29,'confirm_payment','Payment was confirmed (amount $7,317.00) by %user_name%',0,8,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(30,'create_shipment','Created shipment for order',0,8,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(31,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(32,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2024-02-23 08:58:38','2024-02-23 08:58:38'),(33,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2024-02-23 08:58:38','2024-02-23 08:58:38'),(34,'confirm_payment','Payment was confirmed (amount $5,989.00) by %user_name%',0,9,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(35,'create_shipment','Created shipment for order',0,9,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(36,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(37,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2024-02-20 16:58:38','2024-02-20 16:58:38'),(38,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2024-02-20 16:58:38','2024-02-20 16:58:38'),(39,'confirm_payment','Payment was confirmed (amount $2,718.00) by %user_name%',0,10,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38'),(40,'create_shipment','Created shipment for order',0,10,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(41,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2024-02-27 08:58:39','2024-02-27 08:58:39'),(42,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2024-02-27 08:58:39','2024-02-27 08:58:39'),(43,'confirm_payment','Payment was confirmed (amount $511.00) by %user_name%',0,11,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(44,'create_shipment','Created shipment for order',0,11,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(45,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(46,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2024-02-21 12:58:39','2024-02-21 12:58:39'),(47,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2024-02-21 12:58:39','2024-02-21 12:58:39'),(48,'confirm_payment','Payment was confirmed (amount $6,267.00) by %user_name%',0,12,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(49,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,12,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(50,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2024-02-27 18:58:39','2024-02-27 18:58:39'),(51,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2024-02-27 18:58:39','2024-02-27 18:58:39'),(52,'confirm_payment','Payment was confirmed (amount $3,057.00) by %user_name%',0,13,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(53,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,13,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(54,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2024-02-25 06:58:39','2024-02-25 06:58:39'),(55,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2024-02-25 06:58:39','2024-02-25 06:58:39'),(56,'confirm_payment','Payment was confirmed (amount $425.00) by %user_name%',0,14,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(57,'create_shipment','Created shipment for order',0,14,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(58,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2024-03-02 12:58:39','2024-03-02 12:58:39'),(59,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2024-03-02 12:58:39','2024-03-02 12:58:39'),(60,'confirm_payment','Payment was confirmed (amount $511.00) by %user_name%',0,15,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(61,'create_shipment','Created shipment for order',0,15,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(62,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2024-02-23 12:58:39','2024-02-23 12:58:39'),(63,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2024-02-23 12:58:39','2024-02-23 12:58:39'),(64,'confirm_payment','Payment was confirmed (amount $6,933.00) by %user_name%',0,16,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39'),(65,'create_shipment','Created shipment for order',0,16,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(66,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,16,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(67,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2024-02-22 08:58:40','2024-02-22 08:58:40'),(68,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2024-02-22 08:58:40','2024-02-22 08:58:40'),(69,'confirm_payment','Payment was confirmed (amount $1,997.00) by %user_name%',0,17,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(70,'create_shipment','Created shipment for order',0,17,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(71,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,17,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(72,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2024-02-27 12:58:40','2024-02-27 12:58:40'),(73,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2024-02-27 12:58:40','2024-02-27 12:58:40'),(74,'confirm_payment','Payment was confirmed (amount $4,054.00) by %user_name%',0,18,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(75,'create_shipment','Created shipment for order',0,18,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(76,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(77,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2024-02-23 04:58:40','2024-02-23 04:58:40'),(78,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2024-02-23 04:58:40','2024-02-23 04:58:40'),(79,'confirm_payment','Payment was confirmed (amount $7,680.00) by %user_name%',0,19,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(80,'create_shipment','Created shipment for order',0,19,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(81,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2024-02-28 00:58:40','2024-02-28 00:58:40'),(82,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2024-02-28 00:58:40','2024-02-28 00:58:40'),(83,'create_shipment','Created shipment for order',0,20,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(84,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,20,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(85,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2024-02-26 00:58:40','2024-02-26 00:58:40'),(86,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2024-02-26 00:58:40','2024-02-26 00:58:40'),(87,'confirm_payment','Payment was confirmed (amount $1,356.00) by %user_name%',0,21,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(88,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,21,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(89,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2024-03-01 00:58:40','2024-03-01 00:58:40'),(90,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2024-03-01 00:58:40','2024-03-01 00:58:40'),(91,'confirm_payment','Payment was confirmed (amount $1,395.00) by %user_name%',0,22,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40'),(92,'create_shipment','Created shipment for order',0,22,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(93,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,22,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(94,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2024-02-28 00:58:41','2024-02-28 00:58:41'),(95,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2024-02-28 00:58:41','2024-02-28 00:58:41'),(96,'confirm_payment','Payment was confirmed (amount $898.00) by %user_name%',0,23,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(97,'create_shipment','Created shipment for order',0,23,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(98,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(99,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2024-02-24 20:58:41','2024-02-24 20:58:41'),(100,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2024-02-24 20:58:41','2024-02-24 20:58:41'),(101,'confirm_payment','Payment was confirmed (amount $3,243.00) by %user_name%',0,24,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(102,'create_shipment','Created shipment for order',0,24,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(103,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(104,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2024-02-25 18:58:41','2024-02-25 18:58:41'),(105,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2024-02-25 18:58:41','2024-02-25 18:58:41'),(106,'confirm_payment','Payment was confirmed (amount $2,439.00) by %user_name%',0,25,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(107,'create_shipment','Created shipment for order',0,25,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(108,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,25,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(109,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2024-03-01 16:58:41','2024-03-01 16:58:41'),(110,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2024-03-01 16:58:41','2024-03-01 16:58:41'),(111,'confirm_payment','Payment was confirmed (amount $2,447.00) by %user_name%',0,26,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(112,'create_shipment','Created shipment for order',0,26,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(113,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2024-02-25 16:58:41','2024-02-25 16:58:41'),(114,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2024-02-25 16:58:41','2024-02-25 16:58:41'),(115,'confirm_payment','Payment was confirmed (amount $4,024.00) by %user_name%',0,27,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41'),(116,'create_shipment','Created shipment for order',0,27,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(117,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,27,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(118,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2024-02-26 12:58:42','2024-02-26 12:58:42'),(119,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2024-02-26 12:58:42','2024-02-26 12:58:42'),(120,'confirm_payment','Payment was confirmed (amount $1,688.00) by %user_name%',0,28,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(121,'create_shipment','Created shipment for order',0,28,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(122,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2024-03-01 06:58:42','2024-03-01 06:58:42'),(123,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2024-03-01 06:58:42','2024-03-01 06:58:42'),(124,'create_shipment','Created shipment for order',0,29,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(125,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(126,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2024-02-26 12:58:42','2024-02-26 12:58:42'),(127,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2024-02-26 12:58:42','2024-02-26 12:58:42'),(128,'confirm_payment','Payment was confirmed (amount $3,768.00) by %user_name%',0,30,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(129,'create_shipment','Created shipment for order',0,30,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(130,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(131,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2024-02-29 08:58:42','2024-02-29 08:58:42'),(132,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2024-02-29 08:58:42','2024-02-29 08:58:42'),(133,'confirm_payment','Payment was confirmed (amount $2,422.00) by %user_name%',0,31,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(134,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,31,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42'),(135,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2024-03-01 16:58:42','2024-03-01 16:58:42'),(136,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2024-03-01 16:58:42','2024-03-01 16:58:42'),(137,'confirm_payment','Payment was confirmed (amount $4,028.00) by %user_name%',0,32,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(138,'create_shipment','Created shipment for order',0,32,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(139,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(140,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2024-03-02 02:58:43','2024-03-02 02:58:43'),(141,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2024-03-02 02:58:43','2024-03-02 02:58:43'),(142,'confirm_payment','Payment was confirmed (amount $1,926.00) by %user_name%',0,33,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(143,'create_shipment','Created shipment for order',0,33,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(144,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,33,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(145,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2024-03-03 06:58:43','2024-03-03 06:58:43'),(146,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2024-03-03 06:58:43','2024-03-03 06:58:43'),(147,'confirm_payment','Payment was confirmed (amount $632.00) by %user_name%',0,34,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(148,'create_shipment','Created shipment for order',0,34,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(149,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,34,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(150,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2024-03-04 10:58:43','2024-03-04 10:58:43'),(151,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2024-03-04 10:58:43','2024-03-04 10:58:43'),(152,'confirm_payment','Payment was confirmed (amount $3,780.00) by %user_name%',0,35,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(153,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,35,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(154,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2024-03-03 06:58:43','2024-03-03 06:58:43'),(155,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2024-03-03 06:58:43','2024-03-03 06:58:43'),(156,'create_shipment','Created shipment for order',0,36,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(157,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2024-03-03 12:58:43','2024-03-03 12:58:43'),(158,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2024-03-03 12:58:43','2024-03-03 12:58:43'),(159,'confirm_payment','Payment was confirmed (amount $6,291.00) by %user_name%',0,37,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43'),(160,'create_shipment','Created shipment for order',0,37,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(161,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,37,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(162,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2024-03-04 12:58:44','2024-03-04 12:58:44'),(163,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2024-03-04 12:58:44','2024-03-04 12:58:44'),(164,'confirm_payment','Payment was confirmed (amount $1,796.00) by %user_name%',0,38,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(165,'create_shipment','Created shipment for order',0,38,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(166,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,38,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(167,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2024-03-01 16:58:44','2024-03-01 16:58:44'),(168,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2024-03-01 16:58:44','2024-03-01 16:58:44'),(169,'confirm_payment','Payment was confirmed (amount $2,105.00) by %user_name%',0,39,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(170,'create_shipment','Created shipment for order',0,39,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(171,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2024-03-04 04:58:44','2024-03-04 04:58:44'),(172,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2024-03-04 04:58:44','2024-03-04 04:58:44'),(173,'create_shipment','Created shipment for order',0,40,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(174,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(175,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2024-03-04 16:58:44','2024-03-04 16:58:44'),(176,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2024-03-04 16:58:44','2024-03-04 16:58:44'),(177,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2024-03-04 08:58:44','2024-03-04 08:58:44'),(178,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2024-03-04 08:58:44','2024-03-04 08:58:44'),(179,'confirm_payment','Payment was confirmed (amount $4,815.00) by %user_name%',0,42,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44'),(180,'create_shipment','Created shipment for order',0,42,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(181,'create_order_from_seeder','Order is created from the checkout page',NULL,43,NULL,'2024-03-04 00:58:45','2024-03-04 00:58:45'),(182,'confirm_order','Order was verified by %user_name%',0,43,NULL,'2024-03-04 00:58:45','2024-03-04 00:58:45'),(183,'confirm_payment','Payment was confirmed (amount $7,317.00) by %user_name%',0,43,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(184,'create_shipment','Created shipment for order',0,43,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(185,'create_order_from_seeder','Order is created from the checkout page',NULL,44,NULL,'2024-03-04 00:58:45','2024-03-04 00:58:45'),(186,'confirm_order','Order was verified by %user_name%',0,44,NULL,'2024-03-04 00:58:45','2024-03-04 00:58:45'),(187,'create_shipment','Created shipment for order',0,44,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(188,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,44,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(189,'create_order_from_seeder','Order is created from the checkout page',NULL,45,NULL,'2024-03-03 12:58:45','2024-03-03 12:58:45'),(190,'confirm_order','Order was verified by %user_name%',0,45,NULL,'2024-03-03 12:58:45','2024-03-03 12:58:45'),(191,'create_shipment','Created shipment for order',0,45,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(192,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,45,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(193,'create_order_from_seeder','Order is created from the checkout page',NULL,46,NULL,'2024-03-04 06:58:45','2024-03-04 06:58:45'),(194,'confirm_order','Order was verified by %user_name%',0,46,NULL,'2024-03-04 06:58:45','2024-03-04 06:58:45'),(195,'confirm_payment','Payment was confirmed (amount $746.00) by %user_name%',0,46,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(196,'create_shipment','Created shipment for order',0,46,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(197,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,46,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(198,'create_order_from_seeder','Order is created from the checkout page',NULL,47,NULL,'2024-03-03 18:58:45','2024-03-03 18:58:45'),(199,'confirm_order','Order was verified by %user_name%',0,47,NULL,'2024-03-03 18:58:45','2024-03-03 18:58:45'),(200,'create_shipment','Created shipment for order',0,47,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45'),(201,'create_order_from_seeder','Order is created from the checkout page',NULL,48,NULL,'2024-03-04 04:58:45','2024-03-04 04:58:45'),(202,'confirm_order','Order was verified by %user_name%',0,48,NULL,'2024-03-04 04:58:45','2024-03-04 04:58:45'),(203,'create_order_from_seeder','Order is created from the checkout page',NULL,49,NULL,'2024-03-04 04:58:46','2024-03-04 04:58:46'),(204,'confirm_order','Order was verified by %user_name%',0,49,NULL,'2024-03-04 04:58:46','2024-03-04 04:58:46'),(205,'confirm_payment','Payment was confirmed (amount $1,890.00) by %user_name%',0,49,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(206,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,49,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(207,'create_order_from_seeder','Order is created from the checkout page',NULL,50,NULL,'2024-03-04 00:58:46','2024-03-04 00:58:46'),(208,'confirm_order','Order was verified by %user_name%',0,50,NULL,'2024-03-04 00:58:46','2024-03-04 00:58:46'),(209,'confirm_payment','Payment was confirmed (amount $2,402.00) by %user_name%',0,50,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(210,'create_shipment','Created shipment for order',0,50,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(211,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,50,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(212,'create_order_from_seeder','Order is created from the checkout page',NULL,51,NULL,'2024-03-04 16:58:46','2024-03-04 16:58:46'),(213,'confirm_order','Order was verified by %user_name%',0,51,NULL,'2024-03-04 16:58:46','2024-03-04 16:58:46'),(214,'confirm_payment','Payment was confirmed (amount $2,718.00) by %user_name%',0,51,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(215,'create_shipment','Created shipment for order',0,51,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(216,'create_order_from_seeder','Order is created from the checkout page',NULL,52,NULL,'2024-03-04 14:58:46','2024-03-04 14:58:46'),(217,'confirm_order','Order was verified by %user_name%',0,52,NULL,'2024-03-04 14:58:46','2024-03-04 14:58:46'),(218,'confirm_payment','Payment was confirmed (amount $1,605.00) by %user_name%',0,52,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(219,'create_shipment','Created shipment for order',0,52,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(220,'create_order_from_seeder','Order is created from the checkout page',NULL,53,NULL,'2024-03-04 14:58:46','2024-03-04 14:58:46'),(221,'confirm_order','Order was verified by %user_name%',0,53,NULL,'2024-03-04 14:58:46','2024-03-04 14:58:46'),(222,'confirm_payment','Payment was confirmed (amount $2,176.00) by %user_name%',0,53,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(223,'create_shipment','Created shipment for order',0,53,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(224,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,53,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(225,'create_order_from_seeder','Order is created from the checkout page',NULL,54,NULL,'2024-03-04 18:58:46','2024-03-04 18:58:46'),(226,'confirm_order','Order was verified by %user_name%',0,54,NULL,'2024-03-04 18:58:46','2024-03-04 18:58:46'),(227,'confirm_payment','Payment was confirmed (amount $1,533.00) by %user_name%',0,54,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46'),(228,'create_shipment','Created shipment for order',0,54,NULL,'2024-03-05 00:58:47','2024-03-05 00:58:47'),(229,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,54,NULL,'2024-03-05 00:58:47','2024-03-05 00:58:47'),(230,'update_status','Order confirmed by %user_name%',0,3,NULL,'2024-03-05 00:58:47','2024-03-05 00:58:47'),(231,'update_status','Order confirmed by %user_name%',0,6,NULL,'2024-03-05 00:58:47','2024-03-05 00:58:47'),(232,'update_status','Order confirmed by %user_name%',0,8,NULL,'2024-03-05 00:58:48','2024-03-05 00:58:48'),(233,'update_status','Order confirmed by %user_name%',0,9,NULL,'2024-03-05 00:58:48','2024-03-05 00:58:48'),(234,'update_status','Order confirmed by %user_name%',0,11,NULL,'2024-03-05 00:58:49','2024-03-05 00:58:49'),(235,'update_status','Order confirmed by %user_name%',0,16,NULL,'2024-03-05 00:58:49','2024-03-05 00:58:49'),(236,'update_status','Order confirmed by %user_name%',0,17,NULL,'2024-03-05 00:58:50','2024-03-05 00:58:50'),(237,'update_status','Order confirmed by %user_name%',0,18,NULL,'2024-03-05 00:58:50','2024-03-05 00:58:50'),(238,'update_status','Order confirmed by %user_name%',0,22,NULL,'2024-03-05 00:58:51','2024-03-05 00:58:51'),(239,'update_status','Order confirmed by %user_name%',0,23,NULL,'2024-03-05 00:58:51','2024-03-05 00:58:51'),(240,'update_status','Order confirmed by %user_name%',0,24,NULL,'2024-03-05 00:58:52','2024-03-05 00:58:52'),(241,'update_status','Order confirmed by %user_name%',0,25,NULL,'2024-03-05 00:58:52','2024-03-05 00:58:52'),(242,'update_status','Order confirmed by %user_name%',0,27,NULL,'2024-03-05 00:58:53','2024-03-05 00:58:53'),(243,'update_status','Order confirmed by %user_name%',0,30,NULL,'2024-03-05 00:58:53','2024-03-05 00:58:53'),(244,'update_status','Order confirmed by %user_name%',0,32,NULL,'2024-03-05 00:58:54','2024-03-05 00:58:54'),(245,'update_status','Order confirmed by %user_name%',0,33,NULL,'2024-03-05 00:58:55','2024-03-05 00:58:55'),(246,'update_status','Order confirmed by %user_name%',0,34,NULL,'2024-03-05 00:58:55','2024-03-05 00:58:55'),(247,'update_status','Order confirmed by %user_name%',0,37,NULL,'2024-03-05 00:58:56','2024-03-05 00:58:56'),(248,'update_status','Order confirmed by %user_name%',0,38,NULL,'2024-03-05 00:58:56','2024-03-05 00:58:56'),(249,'update_status','Order confirmed by %user_name%',0,46,NULL,'2024-03-05 00:58:57','2024-03-05 00:58:57'),(250,'update_status','Order confirmed by %user_name%',0,50,NULL,'2024-03-05 00:58:57','2024-03-05 00:58:57'),(251,'update_status','Order confirmed by %user_name%',0,53,NULL,'2024-03-05 00:58:58','2024-03-05 00:58:58'),(252,'update_status','Order confirmed by %user_name%',0,54,NULL,'2024-03-05 00:58:58','2024-03-05 00:58:58');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,1,1890.00,0.00,'{\"sku\":\"MC-157-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,92,'Structured Satchel Bag (Digital)','jewelry/products/product-6.png',607.00,0,'2024-03-05 00:58:37','2024-03-05 00:58:37','digital',5,NULL),(2,2,1,898.00,0.00,'{\"sku\":\"WI-103-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,104,'Leopard Print Midi Skirt','jewelry/products/product-3.png',610.00,0,'2024-03-05 00:58:37','2024-03-05 00:58:37','physical',0,NULL),(3,3,2,511.00,0.00,'{\"sku\":\"J7-129-A0-A2\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}',NULL,148,'Faux Leather Leggings','jewelry/products/product-2.png',1056.00,0,'2024-03-05 00:58:37','2024-03-05 00:58:37','physical',0,NULL),(4,4,3,1890.00,0.00,'{\"sku\":\"MC-157-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,93,'Structured Satchel Bag (Digital)','jewelry/products/product-7.png',1821.00,0,'2024-03-05 00:58:37','2024-03-05 00:58:37','digital',6,NULL),(5,5,3,1657.00,0.00,'{\"sku\":\"Q9-116-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,144,'Chunky Knit Infinity Scarf (Digital)','jewelry/products/product-6.png',2529.00,0,'2024-03-05 00:58:37','2024-03-05 00:58:37','digital',10,NULL),(6,6,1,1300.00,0.00,'{\"sku\":\"9U-171-A0\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,44,'Vintage Denim Jacket','jewelry/products/product-7.png',727.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','physical',0,NULL),(7,6,1,1053.00,0.00,'{\"sku\":\"YT-197-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 5KG)\"}',NULL,110,'Boho Fringed Kimono (Digital)','jewelry/products/product-4.png',552.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','digital',8,NULL),(8,7,1,373.00,0.00,'{\"sku\":\"KF-169-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,84,'Lace-Up Combat Boots','jewelry/products/product-3.png',794.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','physical',0,NULL),(9,8,3,2439.00,0.00,'{\"sku\":\"YV-175-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}',NULL,123,'Embellished Ballet Flats','jewelry/products/product-5.png',2391.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','physical',0,NULL),(10,9,3,1300.00,0.00,'{\"sku\":\"9U-171-A0\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,44,'Vintage Denim Jacket','jewelry/products/product-7.png',2181.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','physical',0,NULL),(11,9,1,2089.00,0.00,'{\"sku\":\"GD-168-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,113,'Ruffled Wrap Dress','jewelry/products/product-3.png',505.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','physical',0,NULL),(12,10,2,1359.00,0.00,'{\"sku\":\"8O-131-A0-A1\",\"attributes\":\"(Boxes: 1 Box, Weight: 4KG)\"}',NULL,118,'Wide Brim Floppy Hat','jewelry/products/product-2.png',1590.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','physical',0,NULL),(13,11,1,511.00,0.00,'{\"sku\":\"J7-129-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,147,'Faux Leather Leggings','jewelry/products/product-7.png',528.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','physical',0,NULL),(14,12,3,2089.00,0.00,'{\"sku\":\"SA-154-A0-A3\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,55,'Knit Turtleneck Sweater (Digital)','jewelry/products/product-7.png',1863.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','digital',0,NULL),(15,13,3,1019.00,0.00,'{\"sku\":\"JU-167-A0-A2\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,82,'Distressed Skinny Jeans (Digital)','jewelry/products/product-6.png',1992.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','digital',9,NULL),(16,14,1,425.00,0.00,'{\"sku\":\"GA-185-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,136,'Embroidered Bomber Jacket','jewelry/products/product-2.png',854.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','physical',0,NULL),(17,15,1,511.00,0.00,'{\"sku\":\"J7-129-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,147,'Faux Leather Leggings','jewelry/products/product-7.png',528.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','physical',0,NULL),(18,16,3,2311.00,0.00,'{\"sku\":\"G8-134-A0\",\"attributes\":\"(Color: Red, Size: XL)\"}',NULL,58,'Tailored Wool Blazer','jewelry/products/product-6.png',2106.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','physical',0,NULL),(19,17,1,1997.00,0.00,'{\"sku\":\"2D-191-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,77,'Velvet Evening Gown','jewelry/products/product-6.png',798.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','physical',0,NULL),(20,18,2,1869.00,0.00,'{\"sku\":\"JW-187-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,51,'Leather Ankle Boots','jewelry/products/product-3.png',1432.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','physical',0,NULL),(21,18,1,316.00,0.00,'{\"sku\":\"77-101-A0\",\"attributes\":\"(Size: S, Color: Brown)\"}',NULL,73,'Strappy Block Heel Sandals','jewelry/products/product-8.png',773.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','physical',0,NULL),(22,19,3,2229.00,0.00,'{\"sku\":\"ZA-113-A0\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,89,'Printed Palazzo Pants','jewelry/products/product-5.png',2232.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','physical',0,NULL),(23,19,1,993.00,0.00,'{\"sku\":\"XP-131-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,145,'Retro High-Top Sneakers','jewelry/products/product-1.png',649.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','physical',0,NULL),(24,20,1,2311.00,0.00,'{\"sku\":\"G8-134-A0-A2\",\"attributes\":\"(Color: Green, Size: XL)\"}',NULL,60,'Tailored Wool Blazer','jewelry/products/product-3.png',702.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','physical',0,NULL),(25,21,3,452.00,0.00,'{\"sku\":\"L2-113-A0-A1\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,65,'Silk Scarf with Geometric Print (Digital)','jewelry/products/product-5.png',1806.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','digital',0,NULL),(26,22,1,1395.00,0.00,'{\"sku\":\"5K-135-A0\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,68,'Embroidered Boho Blouse','jewelry/products/product-1.png',610.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','physical',0,NULL),(27,23,1,898.00,0.00,'{\"sku\":\"WI-103-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,105,'Leopard Print Midi Skirt','jewelry/products/product-6.png',610.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','physical',0,NULL),(28,24,3,1081.00,0.00,'{\"sku\":\"GV-115-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}',NULL,63,'Bohemian Fringe Handbag','jewelry/products/product-5.png',2598.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','physical',0,NULL),(29,25,1,2439.00,0.00,'{\"sku\":\"YV-175-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}',NULL,123,'Embellished Ballet Flats','jewelry/products/product-5.png',797.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','physical',0,NULL),(30,26,1,2447.00,0.00,'{\"sku\":\"YC-180-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,71,'Statement Chunky Necklace','jewelry/products/product-3.png',520.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','physical',0,NULL),(31,27,2,1019.00,0.00,'{\"sku\":\"JU-167-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}',NULL,80,'Distressed Skinny Jeans (Digital)','jewelry/products/product-4.png',1328.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','digital',6,NULL),(32,27,2,993.00,0.00,'{\"sku\":\"XP-131-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,145,'Retro High-Top Sneakers','jewelry/products/product-1.png',1298.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','physical',0,NULL),(33,28,1,422.00,0.00,'{\"sku\":\"UI-168-A0\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,86,'Cotton Striped T-Shirt Dress','jewelry/products/product-5.png',533.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','physical',0,NULL),(34,28,3,422.00,0.00,'{\"sku\":\"UI-168-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,87,'Cotton Striped T-Shirt Dress','jewelry/products/product-4.png',1599.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','physical',0,NULL),(35,29,1,2229.00,0.00,'{\"sku\":\"ZA-113-A0\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,89,'Printed Palazzo Pants','jewelry/products/product-5.png',744.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','physical',0,NULL),(36,30,3,1256.00,0.00,'{\"sku\":\"RR-116-A0-A3\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,134,'Buckle Detail Ankle Booties','jewelry/products/product-1.png',1956.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','physical',0,NULL),(37,31,1,1369.00,0.00,'{\"sku\":\"OE-123-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,101,'Athleisure Jogger Pants (Digital)','jewelry/products/product-5.png',847.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','digital',5,NULL),(38,31,1,1053.00,0.00,'{\"sku\":\"YT-197-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,112,'Boho Fringed Kimono (Digital)','jewelry/products/product-1.png',552.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','digital',4,NULL),(39,32,3,1201.00,0.00,'{\"sku\":\"2F-158-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,108,'Faux Fur Trimmed Coat','jewelry/products/product-8.png',2250.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','physical',0,NULL),(40,32,1,425.00,0.00,'{\"sku\":\"GA-185-A0-A2\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,137,'Embroidered Bomber Jacket','jewelry/products/product-4.png',854.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','physical',0,NULL),(41,33,1,1926.00,0.00,'{\"sku\":\"NY-195-A0\",\"attributes\":\"(Color: Green, Size: M)\"}',NULL,67,'High-Waisted Wide Leg Trousers','jewelry/products/product-1.png',738.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','physical',0,NULL),(42,34,2,316.00,0.00,'{\"sku\":\"77-101-A0-A2\",\"attributes\":\"(Color: Green, Size: S)\"}',NULL,75,'Strappy Block Heel Sandals','jewelry/products/product-1.png',1546.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','physical',0,NULL),(43,35,2,1890.00,0.00,'{\"sku\":\"MC-157-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,92,'Structured Satchel Bag (Digital)','jewelry/products/product-6.png',1214.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','digital',0,NULL),(44,36,1,1256.00,0.00,'{\"sku\":\"RR-116-A0-A3\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,134,'Buckle Detail Ankle Booties','jewelry/products/product-1.png',652.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','physical',0,NULL),(45,37,3,2097.00,0.00,'{\"sku\":\"ZI-199-A0-A1\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,95,'Off-Shoulder Ruffle Top','jewelry/products/product-3.png',2073.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','physical',0,NULL),(46,38,2,898.00,0.00,'{\"sku\":\"WI-103-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,105,'Leopard Print Midi Skirt','jewelry/products/product-6.png',1220.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','physical',0,NULL),(47,39,2,452.00,0.00,'{\"sku\":\"L2-113-A0\",\"attributes\":\"(Color: Brown, Size: XXL)\"}',NULL,64,'Silk Scarf with Geometric Print (Digital)','jewelry/products/product-4.png',1204.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','digital',0,NULL),(48,39,1,1201.00,0.00,'{\"sku\":\"2F-158-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,109,'Faux Fur Trimmed Coat','jewelry/products/product-6.png',750.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','physical',0,NULL),(49,40,3,906.00,0.00,'{\"sku\":\"N8-103-A0\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,79,'Quilted Crossbody Bag','jewelry/products/product-4.png',1893.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','physical',0,NULL),(50,41,1,2089.00,0.00,'{\"sku\":\"SA-154-A0-A1\",\"attributes\":\"(Size: L, Color: Brown)\"}',NULL,53,'Knit Turtleneck Sweater (Digital)','jewelry/products/product-3.png',621.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','digital',4,NULL),(51,42,3,1605.00,0.00,'{\"sku\":\"Y2-120-A0\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,97,'Suede Pointed-Toe Pumps','jewelry/products/product-6.png',2172.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','physical',0,NULL),(52,43,3,2439.00,0.00,'{\"sku\":\"YV-175-A0-A1\",\"attributes\":\"(Weight: 3KG, Boxes: 3 Boxes)\"}',NULL,123,'Embellished Ballet Flats','jewelry/products/product-5.png',2391.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','physical',0,NULL),(53,44,3,1256.00,0.00,'{\"sku\":\"RR-116-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}',NULL,131,'Buckle Detail Ankle Booties','jewelry/products/product-7.png',1956.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','physical',0,NULL),(54,45,2,1869.00,0.00,'{\"sku\":\"JW-187-A0-A1\",\"attributes\":\"(Size: S, Color: Blue)\"}',NULL,50,'Leather Ankle Boots','jewelry/products/product-2.png',1432.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','physical',0,NULL),(55,46,2,373.00,0.00,'{\"sku\":\"KF-169-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,84,'Lace-Up Combat Boots','jewelry/products/product-3.png',1588.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','physical',0,NULL),(56,47,3,1359.00,0.00,'{\"sku\":\"8O-131-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,117,'Wide Brim Floppy Hat','jewelry/products/product-7.png',2385.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','physical',0,NULL),(57,48,2,1019.00,0.00,'{\"sku\":\"JU-167-A0\",\"attributes\":\"(Size: M, Color: Brown)\"}',NULL,80,'Distressed Skinny Jeans (Digital)','jewelry/products/product-4.png',1328.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','digital',8,NULL),(58,49,1,1890.00,0.00,'{\"sku\":\"MC-157-A0-A1\",\"attributes\":\"(Color: Black, Size: XL)\"}',NULL,93,'Structured Satchel Bag (Digital)','jewelry/products/product-7.png',607.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','digital',1,NULL),(59,50,2,1201.00,0.00,'{\"sku\":\"2F-158-A0-A1\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,109,'Faux Fur Trimmed Coat','jewelry/products/product-6.png',1500.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','physical',0,NULL),(60,51,2,1359.00,0.00,'{\"sku\":\"8O-131-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,117,'Wide Brim Floppy Hat','jewelry/products/product-7.png',1590.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','physical',0,NULL),(61,52,1,1605.00,0.00,'{\"sku\":\"Y2-120-A0\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,97,'Suede Pointed-Toe Pumps','jewelry/products/product-6.png',724.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','physical',0,NULL),(62,53,2,1088.00,0.00,'{\"sku\":\"ZP-147-A0\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,107,'Retro Cat-Eye Sunglasses','jewelry/products/product-5.png',1116.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','physical',0,NULL),(63,54,3,511.00,0.00,'{\"sku\":\"J7-129-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,147,'Faux Leather Leggings','jewelry/products/product-7.png',1584.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','physical',0,NULL);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `proof_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',9,NULL,'','pending',1890.00,0.00,0.00,NULL,NULL,0.00,1890.00,1,NULL,1,NULL,'6FF6BiOyrI7lSVfuy7th9xmG0VN31',1,'2024-02-20 16:58:37','2024-03-05 00:58:37',1,NULL),(2,'#10000002',9,'1','default','completed',898.00,0.00,0.00,NULL,NULL,0.00,898.00,1,NULL,1,'2024-03-05 00:58:37','jqjaJ9o6JQTAq5F0M6R9vTUFKmo4q',2,'2024-02-24 00:58:37','2024-03-05 00:58:37',4,NULL),(3,'#10000003',9,'1','default','completed',1022.00,0.00,0.00,NULL,NULL,0.00,1022.00,1,NULL,1,'2024-03-05 00:58:47','7IE5vmS9Sgua0p0w7LWR6w5uYDn2S',3,'2024-03-03 08:58:37','2024-03-05 00:58:47',8,NULL),(4,'#10000004',10,NULL,'','pending',5670.00,0.00,0.00,NULL,NULL,0.00,5670.00,1,NULL,1,NULL,'nXewNM8TkOV0RxPj9lfGwsp4S0MQa',4,'2024-02-24 12:58:37','2024-03-05 00:58:37',1,NULL),(5,'#10000005',10,NULL,'','completed',4971.00,0.00,0.00,NULL,NULL,0.00,4971.00,1,NULL,1,'2024-03-05 00:58:38','CQrkSKjzkQl3t4pgyKdBWuXWY2j8O',5,'2024-02-19 18:58:37','2024-03-05 00:58:38',6,NULL),(6,'#10000006',9,'1','default','completed',2353.00,0.00,0.00,NULL,NULL,0.00,2353.00,1,NULL,1,'2024-03-05 00:58:47','4b5FDY8dF31CBCBOmObTJt3cczd7k',6,'2024-02-19 00:58:38','2024-03-05 00:58:47',1,NULL),(7,'#10000007',10,'1','default','pending',373.00,0.00,0.00,NULL,NULL,0.00,373.00,1,NULL,1,NULL,'x4Slve11ZZsxzXQ8a80GozlIB5Ywl',7,'2024-02-25 12:58:38','2024-03-05 00:58:38',7,NULL),(8,'#10000008',10,'1','default','completed',7317.00,0.00,0.00,NULL,NULL,0.00,7317.00,1,NULL,1,'2024-03-05 00:58:48','NwEJM4pkHxO4SLWHbAvfQyVRVI8Wm',8,'2024-02-22 16:58:38','2024-03-05 00:58:48',2,NULL),(9,'#10000009',9,'1','default','completed',5989.00,0.00,0.00,NULL,NULL,0.00,5989.00,1,NULL,1,'2024-03-05 00:58:48','eE3hc92I7OiA3Dga2X0HcODckI4DC',9,'2024-02-23 08:58:38','2024-03-05 00:58:48',1,NULL),(10,'#10000010',9,'1','default','pending',2718.00,0.00,0.00,NULL,NULL,0.00,2718.00,1,NULL,1,NULL,'xdiJZHd7O8N4SS0vjCrjkoNdeVRXo',10,'2024-02-20 16:58:38','2024-03-05 00:58:38',2,NULL),(11,'#10000011',9,'1','default','completed',511.00,0.00,0.00,NULL,NULL,0.00,511.00,1,NULL,1,'2024-03-05 00:58:49','EpRqKBi5XXeht36GMb2VmUv4HK0kC',11,'2024-02-27 08:58:39','2024-03-05 00:58:49',8,NULL),(12,'#10000012',10,NULL,'','completed',6267.00,0.00,0.00,NULL,NULL,0.00,6267.00,1,NULL,1,'2024-03-05 00:58:39','29IRgbZ4m0oslhetm8oHeyVNE6Npv',12,'2024-02-21 12:58:39','2024-03-05 00:58:39',5,NULL),(13,'#10000013',10,NULL,'','completed',3057.00,0.00,0.00,NULL,NULL,0.00,3057.00,1,NULL,1,'2024-03-05 00:58:39','cLJgar8WGh3VuhYEAIbXtJjbe7Iuh',13,'2024-02-27 18:58:39','2024-03-05 00:58:39',3,NULL),(14,'#10000014',10,'1','default','pending',425.00,0.00,0.00,NULL,NULL,0.00,425.00,1,NULL,1,NULL,'HXcPu6CunxdbWRmOi4LqJ9lPcHmUF',14,'2024-02-25 06:58:39','2024-03-05 00:58:39',7,NULL),(15,'#10000015',10,'1','default','pending',511.00,0.00,0.00,NULL,NULL,0.00,511.00,1,NULL,1,NULL,'qI8r5qarC1VnjWmHsu6XOxYmREHCd',15,'2024-03-02 12:58:39','2024-03-05 00:58:39',8,NULL),(16,'#10000016',9,'1','default','completed',6933.00,0.00,0.00,NULL,NULL,0.00,6933.00,1,NULL,1,'2024-03-05 00:58:49','MrOQl0aK7JfBrHD8lqFZNkImwRCVn',16,'2024-02-23 12:58:39','2024-03-05 00:58:49',5,NULL),(17,'#10000017',9,'1','default','completed',1997.00,0.00,0.00,NULL,NULL,0.00,1997.00,1,NULL,1,'2024-03-05 00:58:50','wWDwuYfPeY9FKv4fL7wUhS19VALuN',17,'2024-02-22 08:58:40','2024-03-05 00:58:50',1,NULL),(18,'#10000018',10,'1','default','completed',4054.00,0.00,0.00,NULL,NULL,0.00,4054.00,1,NULL,1,'2024-03-05 00:58:50','sLhyx3n6RgU0NVgVpeqkDQakPVps6',18,'2024-02-27 12:58:40','2024-03-05 00:58:50',5,NULL),(19,'#10000019',10,'1','default','pending',7680.00,0.00,0.00,NULL,NULL,0.00,7680.00,1,NULL,1,NULL,'n5zgY8cQG0LRcGG5GPICn3kCZM4ps',19,'2024-02-23 04:58:40','2024-03-05 00:58:40',3,NULL),(20,'#10000020',9,'1','default','completed',2311.00,0.00,0.00,NULL,NULL,0.00,2311.00,1,NULL,1,'2024-03-05 00:58:40','6r47DNPduCKtd6tFavxsaAlkDgbwx',20,'2024-02-28 00:58:40','2024-03-05 00:58:40',5,NULL),(21,'#10000021',9,NULL,'','completed',1356.00,0.00,0.00,NULL,NULL,0.00,1356.00,1,NULL,1,'2024-03-05 00:58:40','lnusMLzKUl0CgdyG0L4R6cUhIr2sF',21,'2024-02-26 00:58:40','2024-03-05 00:58:40',7,NULL),(22,'#10000022',9,'1','default','completed',1395.00,0.00,0.00,NULL,NULL,0.00,1395.00,1,NULL,1,'2024-03-05 00:58:51','nVyEwDbhWlXtJzs4fcBbqYr1dwXk3',22,'2024-03-01 00:58:40','2024-03-05 00:58:51',3,NULL),(23,'#10000023',9,'1','default','completed',898.00,0.00,0.00,NULL,NULL,0.00,898.00,1,NULL,1,'2024-03-05 00:58:51','qf2mf8J1gndLf4h5JpjlVxIl4QKLt',23,'2024-02-28 00:58:41','2024-03-05 00:58:51',4,NULL),(24,'#10000024',9,'1','default','completed',3243.00,0.00,0.00,NULL,NULL,0.00,3243.00,1,NULL,1,'2024-03-05 00:58:52','N2WBbYgKa34Yinr1RkU3o08midPhi',24,'2024-02-24 20:58:41','2024-03-05 00:58:52',8,NULL),(25,'#10000025',9,'1','default','completed',2439.00,0.00,0.00,NULL,NULL,0.00,2439.00,1,NULL,1,'2024-03-05 00:58:52','7qemZj56tRUst4WSBM6iO7HkAYgPw',25,'2024-02-25 18:58:41','2024-03-05 00:58:52',2,NULL),(26,'#10000026',10,'1','default','pending',2447.00,0.00,0.00,NULL,NULL,0.00,2447.00,1,NULL,1,NULL,'OCeh1sj36puGXCxsTCMYZMEJNGiG8',26,'2024-03-01 16:58:41','2024-03-05 00:58:41',6,NULL),(27,'#10000027',10,'1','default','completed',4024.00,0.00,0.00,NULL,NULL,0.00,4024.00,1,NULL,1,'2024-03-05 00:58:53','WsIc8AQerRLl9PxiHZHcisks1ljww',27,'2024-02-25 16:58:41','2024-03-05 00:58:53',3,NULL),(28,'#10000028',10,'1','default','pending',1688.00,0.00,0.00,NULL,NULL,0.00,1688.00,1,NULL,1,NULL,'anQDWxMzs77o3A5ibDmLFzR4Q2xpT',28,'2024-02-26 12:58:42','2024-03-05 00:58:42',5,NULL),(29,'#10000029',10,'1','default','completed',2229.00,0.00,0.00,NULL,NULL,0.00,2229.00,1,NULL,1,'2024-03-05 00:58:42','L91dskW37btezSbssMF4z0qbWPWVC',29,'2024-03-01 06:58:42','2024-03-05 00:58:42',3,NULL),(30,'#10000030',10,'1','default','completed',3768.00,0.00,0.00,NULL,NULL,0.00,3768.00,1,NULL,1,'2024-03-05 00:58:53','xeKxsPZngoSYVexnmQyFSNZRKJbRm',30,'2024-02-26 12:58:42','2024-03-05 00:58:53',7,NULL),(31,'#10000031',10,NULL,'','completed',2422.00,0.00,0.00,NULL,NULL,0.00,2422.00,1,NULL,1,'2024-03-05 00:58:42','YMpY0EBJcZtBllX5jC6WjuC6J3JvC',31,'2024-02-29 08:58:42','2024-03-05 00:58:42',1,NULL),(32,'#10000032',10,'1','default','completed',4028.00,0.00,0.00,NULL,NULL,0.00,4028.00,1,NULL,1,'2024-03-05 00:58:54','0mt3NU8O846BqAX0KRYroqruZJQZH',32,'2024-03-01 16:58:42','2024-03-05 00:58:54',7,NULL),(33,'#10000033',9,'1','default','completed',1926.00,0.00,0.00,NULL,NULL,0.00,1926.00,1,NULL,1,'2024-03-05 00:58:55','YskwEoPiCzqXF52amrdjGgSb135W1',33,'2024-03-02 02:58:43','2024-03-05 00:58:55',6,NULL),(34,'#10000034',9,'1','default','completed',632.00,0.00,0.00,NULL,NULL,0.00,632.00,1,NULL,1,'2024-03-05 00:58:55','O7iDlQ3h6736vbWoBEFKPvRk7oAQy',34,'2024-03-03 06:58:43','2024-03-05 00:58:55',5,NULL),(35,'#10000035',9,NULL,'','completed',3780.00,0.00,0.00,NULL,NULL,0.00,3780.00,1,NULL,1,'2024-03-05 00:58:43','5XBnaATYhfatFEcL5bpwNM0AXcIvF',35,'2024-03-04 10:58:43','2024-03-05 00:58:43',1,NULL),(36,'#10000036',9,'1','default','pending',1256.00,0.00,0.00,NULL,NULL,0.00,1256.00,1,NULL,1,NULL,'yAVOhJ8COMMs8EWVMzD1ZvKi4ZLey',36,'2024-03-03 06:58:43','2024-03-05 00:58:43',7,NULL),(37,'#10000037',10,'1','default','completed',6291.00,0.00,0.00,NULL,NULL,0.00,6291.00,1,NULL,1,'2024-03-05 00:58:56','GqaryE1je8b9H1k3NdtNVI5nfmgzK',37,'2024-03-03 12:58:43','2024-03-05 00:58:56',8,NULL),(38,'#10000038',10,'1','default','completed',1796.00,0.00,0.00,NULL,NULL,0.00,1796.00,1,NULL,1,'2024-03-05 00:58:56','Br5SNtGpAGQiyDP6A35m7qATinmET',38,'2024-03-04 12:58:44','2024-03-05 00:58:56',4,NULL),(39,'#10000039',9,'1','default','pending',2105.00,0.00,0.00,NULL,NULL,0.00,2105.00,1,NULL,1,NULL,'TRPYbruNEQb6G3PV7SpuzsDDkV0qj',39,'2024-03-01 16:58:44','2024-03-05 00:58:44',7,NULL),(40,'#10000040',9,'1','default','completed',2718.00,0.00,0.00,NULL,NULL,0.00,2718.00,1,NULL,1,'2024-03-05 00:58:44','9ZyLseNp2PhElkAPCsX4Xk9dSlMCP',40,'2024-03-04 04:58:44','2024-03-05 00:58:44',1,NULL),(41,'#10000041',10,NULL,'','pending',2089.00,0.00,0.00,NULL,NULL,0.00,2089.00,1,NULL,1,NULL,'4rX7mBFskuFXd7zJko9tzhRQ8qWea',41,'2024-03-04 16:58:44','2024-03-05 00:58:44',5,NULL),(42,'#10000042',10,'1','default','pending',4815.00,0.00,0.00,NULL,NULL,0.00,4815.00,1,NULL,1,NULL,'xNmIElqNOpylCYdcFfnxbxzXpLYnq',42,'2024-03-04 08:58:44','2024-03-05 00:58:44',4,NULL),(43,'#10000043',10,'1','default','pending',7317.00,0.00,0.00,NULL,NULL,0.00,7317.00,1,NULL,1,NULL,'6do6a7L8QKceO3bivnNWQgmGblC0V',43,'2024-03-04 00:58:45','2024-03-05 00:58:45',2,NULL),(44,'#10000044',10,'1','default','completed',3768.00,0.00,0.00,NULL,NULL,0.00,3768.00,1,NULL,1,'2024-03-05 00:58:45','VTeyuRUyAd4ug2PImggD8IGvXIwCW',44,'2024-03-04 00:58:45','2024-03-05 00:58:45',7,NULL),(45,'#10000045',10,'1','default','completed',3738.00,0.00,0.00,NULL,NULL,0.00,3738.00,1,NULL,1,'2024-03-05 00:58:45','niIrzyWEAJFW0m1Nehe6zkkxlDXa0',45,'2024-03-03 12:58:45','2024-03-05 00:58:45',5,NULL),(46,'#10000046',10,'1','default','completed',746.00,0.00,0.00,NULL,NULL,0.00,746.00,1,NULL,1,'2024-03-05 00:58:57','mlYbLxhFb7p0PoLeuKaSWDkSJsTib',46,'2024-03-04 06:58:45','2024-03-05 00:58:57',7,NULL),(47,'#10000047',10,'1','default','pending',4077.00,0.00,0.00,NULL,NULL,0.00,4077.00,1,NULL,1,NULL,'KlHbmHxfnycf7oJFZlzENUgSZjq4P',47,'2024-03-03 18:58:45','2024-03-05 00:58:45',2,NULL),(48,'#10000048',9,NULL,'','pending',2038.00,0.00,0.00,NULL,NULL,0.00,2038.00,1,NULL,1,NULL,'NpQdlEJwwuRAVLDGTARaR7ah4dzJT',48,'2024-03-04 04:58:45','2024-03-05 00:58:45',3,NULL),(49,'#10000049',9,NULL,'','completed',1890.00,0.00,0.00,NULL,NULL,0.00,1890.00,1,NULL,1,'2024-03-05 00:58:46','2e8NoIJHjc03GQJIi5jtAu4jj6Cu3',49,'2024-03-04 04:58:46','2024-03-05 00:58:46',1,NULL),(50,'#10000050',9,'1','default','completed',2402.00,0.00,0.00,NULL,NULL,0.00,2402.00,1,NULL,1,'2024-03-05 00:58:57','cGYfwaWiyUR2UYl4ZQDg5AEFLiuEG',50,'2024-03-04 00:58:46','2024-03-05 00:58:57',7,NULL),(51,'#10000051',9,'1','default','pending',2718.00,0.00,0.00,NULL,NULL,0.00,2718.00,1,NULL,1,NULL,'azwpqYswW1xglUrl7BZ0c0vpBg21I',51,'2024-03-04 16:58:46','2024-03-05 00:58:46',2,NULL),(52,'#10000052',10,'1','default','pending',1605.00,0.00,0.00,NULL,NULL,0.00,1605.00,1,NULL,1,NULL,'OYbP9ARJqafaMKooailhwWZfLICVV',52,'2024-03-04 14:58:46','2024-03-05 00:58:46',4,NULL),(53,'#10000053',10,'1','default','completed',2176.00,0.00,0.00,NULL,NULL,0.00,2176.00,1,NULL,1,'2024-03-05 00:58:58','UJ4Xhb6sVl4pSgwIfEYj94Q7s2oGg',53,'2024-03-04 14:58:46','2024-03-05 00:58:58',5,NULL),(54,'#10000054',10,'1','default','completed',1533.00,0.00,0.00,NULL,NULL,0.00,1533.00,1,NULL,1,'2024-03-05 00:58:58','klcNs5UEPjSTvG63Y8FwHoMPKDNiX',54,'2024-03-04 18:58:46','2024-03-05 00:58:58',8,NULL);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2024-03-05 00:58:21','2024-03-05 00:58:21',0),(2,'Size','size','text',1,1,1,'published',1,'2024-03-05 00:58:21','2024-03-05 00:58:21',0),(3,'Weight','weight','text',1,1,1,'published',0,'2024-03-05 00:58:21','2024-03-05 00:58:21',0),(4,'Boxes','boxes','text',1,1,1,'published',1,'2024-03-05 00:58:21','2024-03-05 00:58:21',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(2,1,'Blue','blue','#333333',NULL,0,2,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(3,1,'Red','red','#DA323F',NULL,0,3,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(4,1,'Black','black','#2F366C',NULL,0,4,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(6,2,'S','s',NULL,NULL,1,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(7,2,'M','m',NULL,NULL,0,2,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(8,2,'L','l',NULL,NULL,0,3,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(9,2,'XL','xl',NULL,NULL,0,4,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(11,3,'1KG','1kg',NULL,NULL,1,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(12,3,'2KG','2kg',NULL,NULL,0,2,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(13,3,'3KG','3kg',NULL,NULL,0,3,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(14,3,'4KG','4kg',NULL,NULL,0,4,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(15,3,'5KG','5kg',NULL,NULL,0,5,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(16,4,'1 Box','1-box',NULL,NULL,1,1,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(17,4,'2 Boxes','2-boxes',NULL,NULL,0,2,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(18,4,'3 Boxes','3-boxes',NULL,NULL,0,3,'2024-03-05 00:58:21','2024-03-05 00:58:21'),(19,4,'4 Boxes','4-boxes',NULL,NULL,0,4,'2024-03-05 00:58:22','2024-03-05 00:58:22'),(20,4,'5 Boxes','5-boxes',NULL,NULL,0,5,'2024-03-05 00:58:22','2024-03-05 00:58:22');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Discover Skincare',0,NULL,'published',0,'jewelry/product-categories/1.jpg',0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(2,'Clothing',0,NULL,'published',1,'jewelry/product-categories/4.jpg',0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(3,'Men\'s Clothing',2,NULL,'published',0,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(4,'T-Shirts',3,NULL,'published',0,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(5,'Jeans',3,NULL,'published',1,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(6,'Suits',3,NULL,'published',2,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(7,'Women\'s Clothing',2,NULL,'published',1,'jewelry/product-categories/2.jpg',0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(8,'Dresses',7,NULL,'published',0,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(9,'Blouses',7,NULL,'published',1,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(10,'Pants',7,NULL,'published',2,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(11,'Accessories',0,NULL,'published',2,'jewelry/product-categories/5.jpg',0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(12,'Hats',11,NULL,'published',0,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(13,'Scarves',11,NULL,'published',1,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(14,'Jewelry',11,NULL,'published',2,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(15,'Sportswear',0,NULL,'published',3,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(16,'Activewear',15,NULL,'published',0,NULL,0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(17,'Running Shoes',15,NULL,'published',1,'jewelry/product-categories/3.jpg',0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,7),(1,9),(1,16),(1,17),(1,30),(1,39),(2,1),(2,2),(2,5),(2,12),(2,30),(2,32),(2,38),(3,7),(3,24),(3,27),(3,31),(3,34),(3,37),(3,38),(3,39),(3,41),(4,4),(4,6),(4,17),(4,25),(4,30),(4,31),(4,35),(4,40),(5,9),(5,18),(5,19),(5,20),(5,22),(5,25),(5,26),(5,27),(5,28),(5,41),(5,42),(6,4),(6,6),(6,7),(6,8),(6,14),(6,19),(6,22),(6,23),(6,32),(6,38),(6,43),(7,2),(7,9),(7,10),(7,11),(7,15),(7,17),(7,18),(7,19),(7,26),(7,27),(7,32),(7,40),(7,42),(7,43),(8,3),(8,4),(8,5),(8,11),(8,12),(8,15),(8,24),(8,26),(8,28),(8,31),(8,33),(8,34),(8,35),(8,36),(8,39),(9,4),(9,13),(9,17),(9,19),(9,20),(9,23),(9,24),(9,30),(9,34),(9,36),(10,8),(10,29),(10,33),(10,37),(10,41),(11,6),(11,7),(11,12),(11,16),(11,18),(11,20),(11,21),(11,26),(11,36),(11,38),(11,39),(11,40),(11,42),(12,1),(12,8),(12,9),(12,10),(12,13),(12,14),(12,24),(12,32),(12,33),(12,34),(12,43),(13,2),(13,3),(13,6),(13,21),(13,25),(13,27),(13,36),(13,42),(14,1),(14,5),(14,10),(14,14),(14,21),(14,22),(14,29),(14,37),(14,40),(14,43),(15,1),(15,3),(15,5),(15,11),(15,12),(15,14),(15,15),(15,16),(15,22),(15,23),(15,25),(15,28),(15,29),(15,35),(16,2),(16,3),(16,8),(16,13),(16,15),(16,18),(16,20),(16,28),(16,29),(16,31),(16,41),(17,10),(17,11),(17,13),(17,16),(17,21),(17,23),(17,33),(17,35),(17,37);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,4),(1,7),(1,8),(1,9),(1,10),(1,13),(1,17),(1,19),(1,21),(1,23),(1,27),(1,29),(1,31),(1,32),(1,34),(1,38),(2,1),(2,3),(2,5),(2,6),(2,15),(2,22),(2,26),(2,28),(2,33),(2,35),(2,36),(2,43),(3,2),(3,12),(3,16),(3,18),(3,25),(3,30),(3,37),(3,40),(3,41),(4,11),(4,14),(4,20),(4,24),(4,39),(4,42);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'Trendy Wardrobe Essentials','trendy-wardrobe-essentials',NULL,NULL,'published','2024-03-05 00:58:29','2024-03-05 00:58:29',0),(2,'Fashion Forward Finds','fashion-forward-finds',NULL,NULL,'published','2024-03-05 00:58:29','2024-03-05 00:58:29',0),(3,'Chic &amp; Stylish Collection','chic-stylish-collection',NULL,NULL,'published','2024-03-05 00:58:29','2024-03-05 00:58:29',0),(4,'Weekly Fashion Picks','weekly-fashion-picks',NULL,NULL,'published','2024-03-05 00:58:29','2024-03-05 00:58:29',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,4,0,0.00,'fixed',1),(1,8,0,0.00,'fixed',1),(1,14,0,0.00,'fixed',1),(1,18,0,0.00,'fixed',1),(1,19,0,0.00,'fixed',1),(1,20,0,0.00,'fixed',1),(2,1,0,0.00,'fixed',1),(2,3,0,0.00,'fixed',1),(2,4,0,0.00,'fixed',1),(2,10,0,0.00,'fixed',1),(2,11,0,0.00,'fixed',1),(2,18,0,0.00,'fixed',1),(2,20,0,0.00,'fixed',1),(3,11,0,0.00,'fixed',1),(3,12,0,0.00,'fixed',1),(3,15,0,0.00,'fixed',1),(3,16,0,0.00,'fixed',1),(3,17,0,0.00,'fixed',1),(3,19,0,0.00,'fixed',1),(4,10,0,0.00,'fixed',1),(4,11,0,0.00,'fixed',1),(4,12,0,0.00,'fixed',1),(4,15,0,0.00,'fixed',1),(5,1,0,0.00,'fixed',1),(5,3,0,0.00,'fixed',1),(5,4,0,0.00,'fixed',1),(5,6,0,0.00,'fixed',1),(5,10,0,0.00,'fixed',1),(5,12,0,0.00,'fixed',1),(5,13,0,0.00,'fixed',1),(6,3,0,0.00,'fixed',1),(6,5,0,0.00,'fixed',1),(6,10,0,0.00,'fixed',1),(6,12,0,0.00,'fixed',1),(6,13,0,0.00,'fixed',1),(6,15,0,0.00,'fixed',1),(6,19,0,0.00,'fixed',1),(7,3,0,0.00,'fixed',1),(7,4,0,0.00,'fixed',1),(7,5,0,0.00,'fixed',1),(7,8,0,0.00,'fixed',1),(7,10,0,0.00,'fixed',1),(7,12,0,0.00,'fixed',1),(8,2,0,0.00,'fixed',1),(8,6,0,0.00,'fixed',1),(8,9,0,0.00,'fixed',1),(8,10,0,0.00,'fixed',1),(8,11,0,0.00,'fixed',1),(9,2,0,0.00,'fixed',1),(9,5,0,0.00,'fixed',1),(9,13,0,0.00,'fixed',1),(9,14,0,0.00,'fixed',1),(9,19,0,0.00,'fixed',1),(10,5,0,0.00,'fixed',1),(10,7,0,0.00,'fixed',1),(10,11,0,0.00,'fixed',1),(10,13,0,0.00,'fixed',1),(10,14,0,0.00,'fixed',1),(10,15,0,0.00,'fixed',1),(10,17,0,0.00,'fixed',1),(11,3,0,0.00,'fixed',1),(11,4,0,0.00,'fixed',1),(11,5,0,0.00,'fixed',1),(11,7,0,0.00,'fixed',1),(11,19,0,0.00,'fixed',1),(12,1,0,0.00,'fixed',1),(12,4,0,0.00,'fixed',1),(12,6,0,0.00,'fixed',1),(12,8,0,0.00,'fixed',1),(12,13,0,0.00,'fixed',1),(12,18,0,0.00,'fixed',1),(13,1,0,0.00,'fixed',1),(13,2,0,0.00,'fixed',1),(13,5,0,0.00,'fixed',1),(13,7,0,0.00,'fixed',1),(13,14,0,0.00,'fixed',1),(13,19,0,0.00,'fixed',1),(13,20,0,0.00,'fixed',1),(14,7,0,0.00,'fixed',1),(14,11,0,0.00,'fixed',1),(14,12,0,0.00,'fixed',1),(14,13,0,0.00,'fixed',1),(14,15,0,0.00,'fixed',1),(14,19,0,0.00,'fixed',1),(14,20,0,0.00,'fixed',1),(15,2,0,0.00,'fixed',1),(15,4,0,0.00,'fixed',1),(15,12,0,0.00,'fixed',1),(15,13,0,0.00,'fixed',1),(15,16,0,0.00,'fixed',1),(15,19,0,0.00,'fixed',1),(16,3,0,0.00,'fixed',1),(16,6,0,0.00,'fixed',1),(16,12,0,0.00,'fixed',1),(16,13,0,0.00,'fixed',1),(16,14,0,0.00,'fixed',1),(16,17,0,0.00,'fixed',1),(16,20,0,0.00,'fixed',1),(17,9,0,0.00,'fixed',1),(17,10,0,0.00,'fixed',1),(17,11,0,0.00,'fixed',1),(17,16,0,0.00,'fixed',1),(17,19,0,0.00,'fixed',1),(18,2,0,0.00,'fixed',1),(18,5,0,0.00,'fixed',1),(18,7,0,0.00,'fixed',1),(18,9,0,0.00,'fixed',1),(18,12,0,0.00,'fixed',1),(18,17,0,0.00,'fixed',1),(19,3,0,0.00,'fixed',1),(19,4,0,0.00,'fixed',1),(19,5,0,0.00,'fixed',1),(19,8,0,0.00,'fixed',1),(19,17,0,0.00,'fixed',1),(19,18,0,0.00,'fixed',1),(19,20,0,0.00,'fixed',1),(20,7,0,0.00,'fixed',1),(20,8,0,0.00,'fixed',1),(20,12,0,0.00,'fixed',1),(20,19,0,0.00,'fixed',1),(21,1,0,0.00,'fixed',1),(21,4,0,0.00,'fixed',1),(21,5,0,0.00,'fixed',1),(21,15,0,0.00,'fixed',1),(21,18,0,0.00,'fixed',1),(22,5,0,0.00,'fixed',1),(22,6,0,0.00,'fixed',1),(22,9,0,0.00,'fixed',1),(22,13,0,0.00,'fixed',1),(22,14,0,0.00,'fixed',1),(22,18,0,0.00,'fixed',1),(23,2,0,0.00,'fixed',1),(23,3,0,0.00,'fixed',1),(23,4,0,0.00,'fixed',1),(23,7,0,0.00,'fixed',1),(23,12,0,0.00,'fixed',1),(24,4,0,0.00,'fixed',1),(24,5,0,0.00,'fixed',1),(24,10,0,0.00,'fixed',1),(24,13,0,0.00,'fixed',1),(24,17,0,0.00,'fixed',1),(24,19,0,0.00,'fixed',1),(25,3,0,0.00,'fixed',1),(25,6,0,0.00,'fixed',1),(25,15,0,0.00,'fixed',1),(25,18,0,0.00,'fixed',1),(26,2,0,0.00,'fixed',1),(26,3,0,0.00,'fixed',1),(26,10,0,0.00,'fixed',1),(26,15,0,0.00,'fixed',1),(26,16,0,0.00,'fixed',1),(26,17,0,0.00,'fixed',1),(27,4,0,0.00,'fixed',1),(27,5,0,0.00,'fixed',1),(27,6,0,0.00,'fixed',1),(27,13,0,0.00,'fixed',1),(27,17,0,0.00,'fixed',1),(27,19,0,0.00,'fixed',1),(28,1,0,0.00,'fixed',1),(28,2,0,0.00,'fixed',1),(28,9,0,0.00,'fixed',1),(28,14,0,0.00,'fixed',1),(28,18,0,0.00,'fixed',1),(29,2,0,0.00,'fixed',1),(29,6,0,0.00,'fixed',1),(29,9,0,0.00,'fixed',1),(29,12,0,0.00,'fixed',1),(29,16,0,0.00,'fixed',1),(29,17,0,0.00,'fixed',1),(29,19,0,0.00,'fixed',1),(30,5,0,0.00,'fixed',1),(30,8,0,0.00,'fixed',1),(30,10,0,0.00,'fixed',1),(30,11,0,0.00,'fixed',1),(30,15,0,0.00,'fixed',1),(30,17,0,0.00,'fixed',1),(30,19,0,0.00,'fixed',1),(31,1,0,0.00,'fixed',1),(31,3,0,0.00,'fixed',1),(31,5,0,0.00,'fixed',1),(31,9,0,0.00,'fixed',1),(31,13,0,0.00,'fixed',1),(31,19,0,0.00,'fixed',1),(32,3,0,0.00,'fixed',1),(32,5,0,0.00,'fixed',1),(32,7,0,0.00,'fixed',1),(32,8,0,0.00,'fixed',1),(32,11,0,0.00,'fixed',1),(32,14,0,0.00,'fixed',1),(32,18,0,0.00,'fixed',1),(33,1,0,0.00,'fixed',1),(33,2,0,0.00,'fixed',1),(33,8,0,0.00,'fixed',1),(33,10,0,0.00,'fixed',1),(33,11,0,0.00,'fixed',1),(33,13,0,0.00,'fixed',1),(34,4,0,0.00,'fixed',1),(34,6,0,0.00,'fixed',1),(34,9,0,0.00,'fixed',1),(34,12,0,0.00,'fixed',1),(34,13,0,0.00,'fixed',1),(34,14,0,0.00,'fixed',1),(34,15,0,0.00,'fixed',1),(35,4,0,0.00,'fixed',1),(35,6,0,0.00,'fixed',1),(35,14,0,0.00,'fixed',1),(35,16,0,0.00,'fixed',1),(35,17,0,0.00,'fixed',1),(35,19,0,0.00,'fixed',1),(36,1,0,0.00,'fixed',1),(36,3,0,0.00,'fixed',1),(36,11,0,0.00,'fixed',1),(36,14,0,0.00,'fixed',1),(36,15,0,0.00,'fixed',1),(36,16,0,0.00,'fixed',1),(36,18,0,0.00,'fixed',1),(37,4,0,0.00,'fixed',1),(37,12,0,0.00,'fixed',1),(37,17,0,0.00,'fixed',1),(37,18,0,0.00,'fixed',1),(37,19,0,0.00,'fixed',1),(38,5,0,0.00,'fixed',1),(38,8,0,0.00,'fixed',1),(38,11,0,0.00,'fixed',1),(38,13,0,0.00,'fixed',1),(38,18,0,0.00,'fixed',1),(38,19,0,0.00,'fixed',1),(39,4,0,0.00,'fixed',1),(39,6,0,0.00,'fixed',1),(39,10,0,0.00,'fixed',1),(39,12,0,0.00,'fixed',1),(39,18,0,0.00,'fixed',1),(39,19,0,0.00,'fixed',1),(40,1,0,0.00,'fixed',1),(40,2,0,0.00,'fixed',1),(40,6,0,0.00,'fixed',1),(40,11,0,0.00,'fixed',1),(40,13,0,0.00,'fixed',1),(40,18,0,0.00,'fixed',1),(40,19,0,0.00,'fixed',1),(41,3,0,0.00,'fixed',1),(41,6,0,0.00,'fixed',1),(41,9,0,0.00,'fixed',1),(41,10,0,0.00,'fixed',1),(41,13,0,0.00,'fixed',1),(41,17,0,0.00,'fixed',1),(42,1,0,0.00,'fixed',1),(42,3,0,0.00,'fixed',1),(42,8,0,0.00,'fixed',1),(42,12,0,0.00,'fixed',1),(42,15,0,0.00,'fixed',1),(42,17,0,0.00,'fixed',1),(43,3,0,0.00,'fixed',1),(43,7,0,0.00,'fixed',1),(43,8,0,0.00,'fixed',1),(43,10,0,0.00,'fixed',1),(43,14,0,0.00,'fixed',1),(43,16,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,52,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(2,52,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(3,52,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(4,52,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(5,53,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(6,53,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(7,53,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(8,53,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(9,54,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(10,54,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(11,54,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(12,54,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(13,55,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(14,55,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(15,55,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(16,55,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:31\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:31','2024-03-05 00:58:31'),(17,64,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(18,64,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(19,64,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(20,64,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(21,64,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(22,64,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(23,64,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(24,65,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(25,65,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(26,65,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(27,65,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(28,65,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(29,65,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(30,65,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(31,66,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(32,66,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(33,66,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(34,66,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(35,66,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(36,66,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(37,66,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(38,72,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(39,72,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(40,72,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(41,80,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(42,80,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(43,80,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(44,81,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(45,81,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(46,81,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(47,82,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(48,82,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(49,82,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(50,83,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(51,83,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(52,83,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:32','2024-03-05 00:58:32'),(53,92,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(54,92,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(55,92,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(56,93,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(57,93,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(58,93,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(59,101,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(60,101,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(61,101,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(62,101,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(63,101,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(64,101,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(65,101,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(66,102,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(67,102,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(68,102,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(69,102,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(70,102,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(71,102,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(72,102,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(73,110,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(74,110,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(75,110,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(76,110,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(77,111,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(78,111,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(79,111,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(80,111,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(81,112,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(82,112,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(83,112,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(84,112,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:33','2024-03-05 00:58:33'),(85,119,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(86,119,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(87,119,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(88,119,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(89,119,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(90,119,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(91,120,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(92,120,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(93,120,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(94,120,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(95,120,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(96,120,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(97,121,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(98,121,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(99,121,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(100,121,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(101,121,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(102,121,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(103,128,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(104,128,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(105,128,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(106,128,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(107,128,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(108,129,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(109,129,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(110,129,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(111,129,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(112,129,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(113,130,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(114,130,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(115,130,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(116,130,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(117,130,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:34\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:34','2024-03-05 00:58:34'),(118,142,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(119,142,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(120,142,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(121,142,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(122,143,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(123,143,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(124,143,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(125,143,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(126,144,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(127,144,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(128,144,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35'),(129,144,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-05 07:58:35\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-05 00:58:35','2024-03-05 00:58:35');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,9),(1,12),(1,15),(1,36),(2,6),(2,21),(2,33),(3,3),(3,18),(3,24),(3,27),(3,30),(3,39),(3,42);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#cb4321','published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(2,'New','#00c9a7','published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(3,'Sale','#ba591d','published','2024-03-05 00:58:21','2024-03-05 00:58:21');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,1),(1,2),(1,4),(2,1),(2,3),(2,6),(3,2),(3,3),(3,6),(4,1),(4,3),(4,5),(5,1),(5,2),(5,6),(6,2),(6,3),(6,4),(7,1),(7,4),(7,5),(8,2),(8,3),(8,5),(9,4),(9,5),(9,6),(10,2),(10,3),(10,5),(11,3),(11,4),(11,6),(12,1),(12,4),(12,6),(13,1),(13,2),(13,3),(14,4),(14,5),(14,6),(15,2),(15,5),(15,6),(16,1),(16,4),(16,5),(17,1),(17,5),(17,6),(18,1),(18,2),(18,6),(19,1),(19,2),(19,3),(20,1),(20,5),(20,6),(21,4),(21,5),(21,6),(22,2),(22,4),(22,6),(23,3),(23,4),(23,5),(24,1),(24,2),(24,6),(25,3),(25,5),(25,6),(26,3),(26,5),(26,6),(27,1),(27,3),(27,5),(28,1),(28,2),(28,5),(29,1),(29,2),(29,3),(30,2),(30,5),(30,6),(31,2),(31,3),(31,6),(32,2),(32,3),(32,6),(33,1),(33,2),(33,4),(34,1),(34,4),(34,6),(35,2),(35,5),(35,6),(36,2),(36,5),(36,6),(37,1),(37,3),(37,6),(38,2),(38,4),(38,6),(39,1),(39,2),(39,4),(40,1),(40,3),(40,4),(41,2),(41,3),(41,5),(42,2),(42,4),(42,5),(43,1),(43,4),(43,5);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2024-03-05 00:58:24','2024-03-05 00:58:24'),(2,'Mobile',NULL,'published','2024-03-05 00:58:24','2024-03-05 00:58:24'),(3,'Iphone',NULL,'published','2024-03-05 00:58:24','2024-03-05 00:58:24'),(4,'Printer',NULL,'published','2024-03-05 00:58:24','2024-03-05 00:58:24'),(5,'Office',NULL,'published','2024-03-05 00:58:24','2024-03-05 00:58:24'),(6,'IT',NULL,'published','2024-03-05 00:58:24','2024-03-05 00:58:24');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (3,1,2),(9,1,5),(27,1,14),(33,1,17),(45,1,23),(47,1,24),(51,1,26),(57,1,29),(63,1,32),(65,1,33),(79,1,40),(7,2,4),(13,2,7),(17,2,9),(23,2,12),(69,2,35),(75,2,38),(81,2,41),(113,2,57),(1,3,1),(5,3,3),(15,3,8),(29,3,15),(35,3,18),(61,3,31),(67,3,34),(107,3,54),(11,4,6),(25,4,13),(31,4,16),(37,4,19),(49,4,25),(55,4,28),(71,4,36),(83,4,42),(85,4,43),(87,4,44),(89,4,45),(91,4,46),(95,4,48),(99,4,50),(101,4,51),(103,4,52),(19,5,10),(21,5,11),(39,5,20),(41,5,21),(43,5,22),(53,5,27),(59,5,30),(73,5,37),(77,5,39),(93,5,47),(97,5,49),(105,5,53),(109,5,55),(111,5,56),(2,6,1),(14,6,7),(16,6,8),(18,6,9),(56,6,28),(60,6,30),(64,6,32),(72,6,36),(88,6,44),(92,6,46),(94,6,47),(96,6,48),(104,6,52),(112,6,56),(4,7,2),(12,7,6),(28,7,14),(32,7,16),(38,7,19),(48,7,24),(50,7,25),(54,7,27),(62,7,31),(74,7,37),(86,7,43),(102,7,51),(114,7,57),(6,8,3),(8,8,4),(20,8,10),(24,8,12),(40,8,20),(46,8,23),(68,8,34),(70,8,35),(80,8,40),(82,8,41),(106,8,53),(22,9,11),(26,9,13),(30,9,15),(34,9,17),(52,9,26),(66,9,33),(78,9,39),(90,9,45),(98,9,49),(100,9,50),(10,10,5),(36,10,18),(42,10,21),(44,10,22),(58,10,29),(76,10,38),(84,10,42),(108,10,54),(110,10,55),(123,11,62),(129,11,65),(135,11,68),(137,11,69),(139,11,70),(175,11,88),(183,11,92),(191,11,96),(195,11,98),(201,11,101),(121,12,61),(145,12,73),(163,12,82),(165,12,83),(173,12,87),(179,12,90),(185,12,93),(187,12,94),(189,12,95),(199,12,100),(203,12,102),(207,12,104),(117,13,59),(119,13,60),(125,13,63),(151,13,76),(155,13,78),(159,13,80),(167,13,84),(169,13,85),(177,13,89),(205,13,103),(209,13,105),(131,14,66),(141,14,71),(143,14,72),(147,14,74),(149,14,75),(153,14,77),(197,14,99),(211,14,106),(115,15,58),(127,15,64),(133,15,67),(157,15,79),(161,15,81),(171,15,86),(181,15,91),(193,15,97),(213,15,107),(120,16,60),(150,16,75),(154,16,77),(164,16,82),(170,16,85),(176,16,88),(180,16,90),(192,16,96),(116,17,58),(146,17,73),(162,17,81),(174,17,87),(184,17,92),(196,17,98),(206,17,103),(212,17,106),(124,18,62),(126,18,63),(134,18,67),(138,18,69),(140,18,70),(148,18,74),(160,18,80),(178,18,89),(194,18,97),(200,18,100),(202,18,101),(204,18,102),(136,19,68),(142,19,71),(152,19,76),(156,19,78),(158,19,79),(168,19,84),(190,19,95),(198,19,99),(210,19,105),(214,19,107),(118,20,59),(122,20,61),(128,20,64),(130,20,65),(132,20,66),(144,20,72),(166,20,83),(172,20,86),(182,20,91),(186,20,93),(188,20,94),(208,20,104);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,44,1,1),(2,45,1,0),(3,46,1,0),(4,47,2,1),(5,48,2,0),(6,49,3,1),(7,50,3,0),(8,51,3,0),(9,52,4,1),(10,53,4,0),(11,54,4,0),(12,55,4,0),(13,56,5,1),(14,57,5,0),(15,58,6,1),(16,59,6,0),(17,60,6,0),(18,61,7,1),(19,62,7,0),(20,63,7,0),(21,64,8,1),(22,65,8,0),(23,66,8,0),(24,67,9,1),(25,68,10,1),(26,69,10,0),(27,70,11,1),(28,71,11,0),(29,72,12,1),(30,73,13,1),(31,74,13,0),(32,75,13,0),(33,76,14,1),(34,77,14,0),(35,78,14,0),(36,79,15,1),(37,80,16,1),(38,81,16,0),(39,82,16,0),(40,83,16,0),(41,84,17,1),(42,85,17,0),(43,86,18,1),(44,87,18,0),(45,88,18,0),(46,89,19,1),(47,90,19,0),(48,91,19,0),(49,92,20,1),(50,93,20,0),(51,94,21,1),(52,95,21,0),(53,96,21,0),(54,97,22,1),(55,98,22,0),(56,99,22,0),(57,100,23,1),(58,101,24,1),(59,102,24,0),(60,103,25,1),(61,104,25,0),(62,105,25,0),(63,106,25,0),(64,107,26,1),(65,108,27,1),(66,109,27,0),(67,110,28,1),(68,111,28,0),(69,112,28,0),(70,113,29,1),(71,114,30,1),(72,115,30,0),(73,116,30,0),(74,117,31,1),(75,118,31,0),(76,119,32,1),(77,120,32,0),(78,121,32,0),(79,122,33,1),(80,123,33,0),(81,124,34,1),(82,125,34,0),(83,126,35,1),(84,127,35,0),(85,128,36,1),(86,129,36,0),(87,130,36,0),(88,131,37,1),(89,132,37,0),(90,133,37,0),(91,134,37,0),(92,135,38,1),(93,136,38,0),(94,137,38,0),(95,138,39,1),(96,139,39,0),(97,140,39,0),(98,141,39,0),(99,142,40,1),(100,143,40,0),(101,144,40,0),(102,145,41,1),(103,146,42,1),(104,147,42,0),(105,148,42,0),(106,149,43,1),(107,150,43,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2024-03-05',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(3,24,0),(4,24,0),(3,25,0),(4,25,0),(3,26,0),(4,26,0),(3,27,0),(4,27,0),(3,28,0),(4,28,0),(3,29,0),(4,29,0),(3,30,0),(4,30,0),(3,31,0),(4,31,0),(3,32,0),(4,32,0),(3,33,0),(4,33,0),(3,34,0),(4,34,0),(3,35,0),(4,35,0),(3,36,0),(4,36,0),(3,37,0),(4,37,0),(3,38,0),(4,38,0),(3,39,0),(4,39,0),(3,40,0),(4,40,0),(3,41,0),(4,41,0),(3,42,0),(4,42,0),(3,43,0),(4,43,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `approved_by` bigint unsigned DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Vintage Denim Jacket','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-4.png\"]','9U-171-A0',0,19,0,1,1,2,0,0,1300,NULL,NULL,NULL,20.00,18.00,15.00,727.00,NULL,187958,'2024-03-05 00:58:30','2024-03-05 00:58:31','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(2,'Floral Maxi Dress','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-6.png\"]','79-191-A0',0,12,0,1,1,2,0,0,2173,NULL,NULL,NULL,15.00,17.00,17.00,730.00,NULL,199741,'2024-03-05 00:58:30','2024-03-05 00:58:31','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(3,'Leather Ankle Boots','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-4.png\"]','JW-187-A0',0,12,0,1,0,4,0,0,1869,NULL,NULL,NULL,20.00,12.00,20.00,716.00,NULL,102032,'2024-03-05 00:58:30','2024-03-05 00:58:31','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(4,'Knit Turtleneck Sweater (Digital)','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-7.png\"]','SA-154-A0',0,19,0,1,0,5,0,0,2089,1692.09,NULL,NULL,18.00,13.00,14.00,621.00,NULL,23265,'2024-03-05 00:58:30','2024-03-05 00:58:31','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(5,'Classic Aviator Sunglasses','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-3.png\"]','VP-112-A0',0,17,0,1,0,2,0,0,763,NULL,NULL,NULL,20.00,18.00,20.00,666.00,NULL,55110,'2024-03-05 00:58:30','2024-03-05 00:58:31','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(6,'Tailored Wool Blazer','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-3.png\"]','G8-134-A0',0,17,0,1,1,4,0,0,2311,NULL,NULL,NULL,10.00,20.00,18.00,702.00,NULL,187112,'2024-03-05 00:58:30','2024-03-05 00:58:31','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(7,'Bohemian Fringe Handbag','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\"]','GV-115-A0',0,12,0,1,0,1,0,0,1081,NULL,NULL,NULL,12.00,13.00,17.00,866.00,NULL,186934,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(8,'Silk Scarf with Geometric Print (Digital)','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\"]','L2-113-A0',0,12,0,1,1,3,0,0,452,366.12,NULL,NULL,15.00,16.00,17.00,602.00,NULL,9379,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(9,'High-Waisted Wide Leg Trousers','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\"]','NY-195-A0',0,12,0,1,0,5,0,0,1926,NULL,NULL,NULL,13.00,14.00,15.00,738.00,NULL,21832,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(10,'Embroidered Boho Blouse','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\"]','5K-135-A0',0,17,0,1,1,2,0,0,1395,NULL,NULL,NULL,15.00,14.00,15.00,610.00,NULL,181207,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(11,'Statement Chunky Necklace','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-2.png\"]','YC-180-A0',0,11,0,1,1,5,0,0,2447,NULL,NULL,NULL,13.00,15.00,17.00,520.00,NULL,50083,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(12,'Chic Fedora Hat (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-8.png\"]','F2-137-A0',0,20,0,1,1,2,0,0,2137,1517.27,NULL,NULL,17.00,13.00,20.00,708.00,NULL,27793,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(13,'Strappy Block Heel Sandals','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-7.png\"]','77-101-A0',0,17,0,1,0,4,0,0,316,NULL,NULL,NULL,20.00,15.00,20.00,773.00,NULL,93274,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(14,'Velvet Evening Gown','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\"]','2D-191-A0',0,14,0,1,0,1,0,0,1997,NULL,NULL,NULL,18.00,19.00,13.00,798.00,NULL,14243,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(15,'Quilted Crossbody Bag','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\"]','N8-103-A0',0,17,0,1,0,3,0,0,906,NULL,NULL,NULL,11.00,16.00,13.00,631.00,NULL,51830,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(16,'Distressed Skinny Jeans (Digital)','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-6.png\"]','JU-167-A0',0,12,0,1,0,3,0,0,1019,896.72,NULL,NULL,20.00,17.00,10.00,664.00,NULL,169831,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(17,'Lace-Up Combat Boots','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-4.png\"]','KF-169-A0',0,17,0,1,1,5,0,0,373,NULL,NULL,NULL,18.00,18.00,17.00,794.00,NULL,81494,'2024-03-05 00:58:30','2024-03-05 00:58:32','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(18,'Cotton Striped T-Shirt Dress','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\"]','UI-168-A0',0,13,0,1,0,5,0,0,422,NULL,NULL,NULL,20.00,14.00,13.00,533.00,NULL,125884,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(19,'Printed Palazzo Pants','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\"]','ZA-113-A0',0,17,0,1,0,4,0,0,2229,NULL,NULL,NULL,13.00,17.00,17.00,744.00,NULL,163834,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(20,'Structured Satchel Bag (Digital)','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-3.png\"]','MC-157-A0',0,11,0,1,0,4,0,0,1890,1606.5,NULL,NULL,10.00,20.00,11.00,607.00,NULL,113766,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(21,'Off-Shoulder Ruffle Top','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-2.png\"]','ZI-199-A0',0,14,0,1,1,3,0,0,2097,NULL,NULL,NULL,14.00,11.00,11.00,691.00,NULL,130812,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(22,'Suede Pointed-Toe Pumps','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\"]','Y2-120-A0',0,19,0,1,0,4,0,0,1605,NULL,NULL,NULL,19.00,12.00,10.00,724.00,NULL,139476,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(23,'Cropped Cable Knit Sweater','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\"]','ZK-167-A0',0,13,0,1,1,3,0,0,495,NULL,NULL,NULL,18.00,14.00,12.00,803.00,NULL,43767,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(24,'Athleisure Jogger Pants (Digital)','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\"]','OE-123-A0',0,13,0,1,0,1,0,0,1369,1040.44,NULL,NULL,19.00,14.00,14.00,847.00,NULL,2654,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(25,'Leopard Print Midi Skirt','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-8.png\"]','WI-103-A0',0,14,0,1,0,4,0,0,898,NULL,NULL,NULL,13.00,15.00,13.00,610.00,NULL,169787,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(26,'Retro Cat-Eye Sunglasses','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-6.png\"]','ZP-147-A0',0,14,0,1,1,1,0,0,1088,NULL,NULL,NULL,10.00,10.00,19.00,558.00,NULL,138078,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(27,'Faux Fur Trimmed Coat','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-4.png\"]','2F-158-A0',0,12,0,1,0,5,0,0,1201,NULL,NULL,NULL,10.00,19.00,13.00,750.00,NULL,182832,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(28,'Boho Fringed Kimono (Digital)','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\"]','YT-197-A0',0,17,0,1,1,1,0,0,1053,937.17,NULL,NULL,16.00,17.00,17.00,552.00,NULL,194216,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(29,'Ruffled Wrap Dress','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\"]','GD-168-A0',0,17,0,1,0,4,0,0,2089,NULL,NULL,NULL,20.00,11.00,12.00,505.00,NULL,50252,'2024-03-05 00:58:30','2024-03-05 00:58:33','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(30,'Beaded Evening Clutch','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-6.png\"]','WF-155-A0',0,11,0,1,1,3,0,0,1644,NULL,NULL,NULL,10.00,11.00,15.00,517.00,NULL,162496,'2024-03-05 00:58:30','2024-03-05 00:58:34','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(31,'Wide Brim Floppy Hat','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-5.png\"]','8O-131-A0',0,18,0,1,1,3,0,0,1359,NULL,NULL,NULL,10.00,15.00,20.00,795.00,NULL,194620,'2024-03-05 00:58:30','2024-03-05 00:58:34','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(32,'Denim Overall Jumpsuit (Digital)','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\"]','6P-153-A0',0,14,0,1,1,1,0,0,2228,1693.28,NULL,NULL,18.00,11.00,10.00,739.00,NULL,155641,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(33,'Embellished Ballet Flats','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\"]','YV-175-A0',0,16,0,1,1,2,0,0,2439,NULL,NULL,NULL,10.00,19.00,19.00,797.00,NULL,8734,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(34,'Pleated Midi Skirt','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-7.png\"]','U9-166-A0',0,12,0,1,0,2,0,0,1247,NULL,NULL,NULL,20.00,16.00,17.00,777.00,NULL,161011,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(35,'Velour Tracksuit Set','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-2.png\"]','B0-112-A0',0,15,0,1,0,5,0,0,2076,NULL,NULL,NULL,20.00,12.00,14.00,743.00,NULL,127883,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(36,'Geometric Patterned Cardigan (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-6.png\"]','PG-189-A0',0,10,0,1,0,3,0,0,1005,723.6,NULL,NULL,20.00,17.00,15.00,883.00,NULL,141235,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(37,'Buckle Detail Ankle Booties','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-1.png\"]','RR-116-A0',0,11,0,1,0,5,0,0,1256,NULL,NULL,NULL,19.00,10.00,20.00,652.00,NULL,80480,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(38,'Embroidered Bomber Jacket','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-1.png\"]','GA-185-A0',0,16,0,1,1,2,0,0,425,NULL,NULL,NULL,18.00,15.00,19.00,854.00,NULL,31890,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(39,'Cowl Neck Knit Poncho','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-1.png\"]','S4-116-A0',0,14,0,1,0,1,0,0,1011,NULL,NULL,NULL,17.00,19.00,19.00,841.00,NULL,10509,'2024-03-05 00:58:31','2024-03-05 00:58:34','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(40,'Chunky Knit Infinity Scarf (Digital)','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-3.png\"]','Q9-116-A0',0,10,0,1,0,5,0,0,1657,1342.17,NULL,NULL,19.00,13.00,20.00,843.00,NULL,104098,'2024-03-05 00:58:31','2024-03-05 00:58:35','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(41,'Retro High-Top Sneakers','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-4.png\"]','XP-131-A0',0,19,0,1,1,3,0,0,993,NULL,NULL,NULL,20.00,10.00,14.00,649.00,NULL,141048,'2024-03-05 00:58:31','2024-03-05 00:58:35','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(42,'Faux Leather Leggings','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\"]','J7-129-A0',0,14,0,1,1,5,0,0,511,NULL,NULL,NULL,15.00,19.00,20.00,528.00,NULL,155208,'2024-03-05 00:58:31','2024-03-05 00:58:35','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(43,'Metallic Pleated Maxi Skirt','Stay cozy and chic in this knit turtleneck sweater, featuring a ribbed texture and a timeless design. Perfect for chilly days and nights.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\"]','8P-147-A0',0,18,0,1,1,1,0,0,1024,NULL,NULL,NULL,13.00,14.00,15.00,642.00,NULL,47565,'2024-03-05 00:58:31','2024-03-05 00:58:35','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(44,'Vintage Denim Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','9U-171-A0',0,19,0,1,0,2,1,0,1300,NULL,NULL,NULL,20.00,18.00,15.00,727.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(45,'Vintage Denim Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','9U-171-A0-A1',0,19,0,1,0,2,1,0,1300,NULL,NULL,NULL,20.00,18.00,15.00,727.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(46,'Vintage Denim Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','9U-171-A0-A2',0,19,0,1,0,2,1,0,1300,NULL,NULL,NULL,20.00,18.00,15.00,727.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(47,'Floral Maxi Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','79-191-A0',0,12,0,1,0,2,1,0,2173,NULL,NULL,NULL,15.00,17.00,17.00,730.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(48,'Floral Maxi Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','79-191-A0-A1',0,12,0,1,0,2,1,0,2173,NULL,NULL,NULL,15.00,17.00,17.00,730.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(49,'Leather Ankle Boots',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','JW-187-A0',0,12,0,1,0,4,1,0,1869,NULL,NULL,NULL,20.00,12.00,20.00,716.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(50,'Leather Ankle Boots',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','JW-187-A0-A1',0,12,0,1,0,4,1,0,1869,NULL,NULL,NULL,20.00,12.00,20.00,716.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(51,'Leather Ankle Boots',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','JW-187-A0-A2',0,12,0,1,0,4,1,0,1869,NULL,NULL,NULL,20.00,12.00,20.00,716.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(52,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','SA-154-A0',0,19,0,1,0,5,1,0,2089,1692.09,NULL,NULL,18.00,13.00,14.00,621.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(53,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','SA-154-A0-A1',0,19,0,1,0,5,1,0,2089,1650.31,NULL,NULL,18.00,13.00,14.00,621.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(54,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','SA-154-A0-A2',0,19,0,1,0,5,1,0,2089,1650.31,NULL,NULL,18.00,13.00,14.00,621.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(55,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','SA-154-A0-A3',0,19,0,1,0,5,1,0,2089,1838.32,NULL,NULL,18.00,13.00,14.00,621.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(56,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','VP-112-A0',0,17,0,1,0,2,1,0,763,NULL,NULL,NULL,20.00,18.00,20.00,666.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(57,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','VP-112-A0-A1',0,17,0,1,0,2,1,0,763,NULL,NULL,NULL,20.00,18.00,20.00,666.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(58,'Tailored Wool Blazer',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','G8-134-A0',0,17,0,1,0,4,1,0,2311,NULL,NULL,NULL,10.00,20.00,18.00,702.00,NULL,0,'2024-03-05 00:58:31','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(59,'Tailored Wool Blazer',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','G8-134-A0-A1',0,17,0,1,0,4,1,0,2311,NULL,NULL,NULL,10.00,20.00,18.00,702.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(60,'Tailored Wool Blazer',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','G8-134-A0-A2',0,17,0,1,0,4,1,0,2311,NULL,NULL,NULL,10.00,20.00,18.00,702.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(61,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','GV-115-A0',0,12,0,1,0,1,1,0,1081,NULL,NULL,NULL,12.00,13.00,17.00,866.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(62,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','GV-115-A0-A1',0,12,0,1,0,1,1,0,1081,NULL,NULL,NULL,12.00,13.00,17.00,866.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(63,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','GV-115-A0-A2',0,12,0,1,0,1,1,0,1081,NULL,NULL,NULL,12.00,13.00,17.00,866.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(64,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','L2-113-A0',0,12,0,1,0,3,1,0,452,366.12,NULL,NULL,15.00,16.00,17.00,602.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(65,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','L2-113-A0-A1',0,12,0,1,0,3,1,0,452,366.12,NULL,NULL,15.00,16.00,17.00,602.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(66,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','L2-113-A0-A2',0,12,0,1,0,3,1,0,452,357.08,NULL,NULL,15.00,16.00,17.00,602.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(67,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','NY-195-A0',0,12,0,1,0,5,1,0,1926,NULL,NULL,NULL,13.00,14.00,15.00,738.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(68,'Embroidered Boho Blouse',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','5K-135-A0',0,17,0,1,0,2,1,0,1395,NULL,NULL,NULL,15.00,14.00,15.00,610.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(69,'Embroidered Boho Blouse',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','5K-135-A0-A1',0,17,0,1,0,2,1,0,1395,NULL,NULL,NULL,15.00,14.00,15.00,610.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(70,'Statement Chunky Necklace',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','YC-180-A0',0,11,0,1,0,5,1,0,2447,NULL,NULL,NULL,13.00,15.00,17.00,520.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(71,'Statement Chunky Necklace',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','YC-180-A0-A1',0,11,0,1,0,5,1,0,2447,NULL,NULL,NULL,13.00,15.00,17.00,520.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(72,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','F2-137-A0',0,20,0,1,0,2,1,0,2137,1517.27,NULL,NULL,17.00,13.00,20.00,708.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(73,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','77-101-A0',0,17,0,1,0,4,1,0,316,NULL,NULL,NULL,20.00,15.00,20.00,773.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(74,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','77-101-A0-A1',0,17,0,1,0,4,1,0,316,NULL,NULL,NULL,20.00,15.00,20.00,773.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(75,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','77-101-A0-A2',0,17,0,1,0,4,1,0,316,NULL,NULL,NULL,20.00,15.00,20.00,773.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(76,'Velvet Evening Gown',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','2D-191-A0',0,14,0,1,0,1,1,0,1997,NULL,NULL,NULL,18.00,19.00,13.00,798.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(77,'Velvet Evening Gown',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','2D-191-A0-A1',0,14,0,1,0,1,1,0,1997,NULL,NULL,NULL,18.00,19.00,13.00,798.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(78,'Velvet Evening Gown',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','2D-191-A0-A2',0,14,0,1,0,1,1,0,1997,NULL,NULL,NULL,18.00,19.00,13.00,798.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(79,'Quilted Crossbody Bag',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','N8-103-A0',0,17,0,1,0,3,1,0,906,NULL,NULL,NULL,11.00,16.00,13.00,631.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(80,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','JU-167-A0',0,12,0,1,0,3,1,0,1019,896.72,NULL,NULL,20.00,17.00,10.00,664.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(81,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','JU-167-A0-A1',0,12,0,1,0,3,1,0,1019,855.96,NULL,NULL,20.00,17.00,10.00,664.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(82,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','JU-167-A0-A2',0,12,0,1,0,3,1,0,1019,886.53,NULL,NULL,20.00,17.00,10.00,664.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(83,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','JU-167-A0-A3',0,12,0,1,0,3,1,0,1019,733.68,NULL,NULL,20.00,17.00,10.00,664.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(84,'Lace-Up Combat Boots',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','KF-169-A0',0,17,0,1,0,5,1,0,373,NULL,NULL,NULL,18.00,18.00,17.00,794.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(85,'Lace-Up Combat Boots',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','KF-169-A0-A1',0,17,0,1,0,5,1,0,373,NULL,NULL,NULL,18.00,18.00,17.00,794.00,NULL,0,'2024-03-05 00:58:32','2024-03-05 00:58:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(86,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','UI-168-A0',0,13,0,1,0,5,1,0,422,NULL,NULL,NULL,20.00,14.00,13.00,533.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(87,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','UI-168-A0-A1',0,13,0,1,0,5,1,0,422,NULL,NULL,NULL,20.00,14.00,13.00,533.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(88,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','UI-168-A0-A2',0,13,0,1,0,5,1,0,422,NULL,NULL,NULL,20.00,14.00,13.00,533.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(89,'Printed Palazzo Pants',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','ZA-113-A0',0,17,0,1,0,4,1,0,2229,NULL,NULL,NULL,13.00,17.00,17.00,744.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(90,'Printed Palazzo Pants',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','ZA-113-A0-A1',0,17,0,1,0,4,1,0,2229,NULL,NULL,NULL,13.00,17.00,17.00,744.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(91,'Printed Palazzo Pants',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','ZA-113-A0-A2',0,17,0,1,0,4,1,0,2229,NULL,NULL,NULL,13.00,17.00,17.00,744.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(92,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','MC-157-A0',0,11,0,1,0,4,1,0,1890,1606.5,NULL,NULL,10.00,20.00,11.00,607.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(93,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','MC-157-A0-A1',0,11,0,1,0,4,1,0,1890,1682.1,NULL,NULL,10.00,20.00,11.00,607.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(94,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','ZI-199-A0',0,14,0,1,0,3,1,0,2097,NULL,NULL,NULL,14.00,11.00,11.00,691.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(95,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','ZI-199-A0-A1',0,14,0,1,0,3,1,0,2097,NULL,NULL,NULL,14.00,11.00,11.00,691.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(96,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','ZI-199-A0-A2',0,14,0,1,0,3,1,0,2097,NULL,NULL,NULL,14.00,11.00,11.00,691.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(97,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','Y2-120-A0',0,19,0,1,0,4,1,0,1605,NULL,NULL,NULL,19.00,12.00,10.00,724.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(98,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','Y2-120-A0-A1',0,19,0,1,0,4,1,0,1605,NULL,NULL,NULL,19.00,12.00,10.00,724.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(99,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','Y2-120-A0-A2',0,19,0,1,0,4,1,0,1605,NULL,NULL,NULL,19.00,12.00,10.00,724.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(100,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','ZK-167-A0',0,13,0,1,0,3,1,0,495,NULL,NULL,NULL,18.00,14.00,12.00,803.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(101,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','OE-123-A0',0,13,0,1,0,1,1,0,1369,1040.44,NULL,NULL,19.00,14.00,14.00,847.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(102,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','OE-123-A0-A1',0,13,0,1,0,1,1,0,1369,971.99,NULL,NULL,19.00,14.00,14.00,847.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(103,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','WI-103-A0',0,14,0,1,0,4,1,0,898,NULL,NULL,NULL,13.00,15.00,13.00,610.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(104,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','WI-103-A0-A1',0,14,0,1,0,4,1,0,898,NULL,NULL,NULL,13.00,15.00,13.00,610.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(105,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','WI-103-A0-A2',0,14,0,1,0,4,1,0,898,NULL,NULL,NULL,13.00,15.00,13.00,610.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(106,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','WI-103-A0-A3',0,14,0,1,0,4,1,0,898,NULL,NULL,NULL,13.00,15.00,13.00,610.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(107,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','ZP-147-A0',0,14,0,1,0,1,1,0,1088,NULL,NULL,NULL,10.00,10.00,19.00,558.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(108,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','2F-158-A0',0,12,0,1,0,5,1,0,1201,NULL,NULL,NULL,10.00,19.00,13.00,750.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(109,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','2F-158-A0-A1',0,12,0,1,0,5,1,0,1201,NULL,NULL,NULL,10.00,19.00,13.00,750.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(110,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','YT-197-A0',0,17,0,1,0,1,1,0,1053,937.17,NULL,NULL,16.00,17.00,17.00,552.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(111,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','YT-197-A0-A1',0,17,0,1,0,1,1,0,1053,747.63,NULL,NULL,16.00,17.00,17.00,552.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(112,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','YT-197-A0-A2',0,17,0,1,0,1,1,0,1053,768.69,NULL,NULL,16.00,17.00,17.00,552.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(113,'Ruffled Wrap Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','GD-168-A0',0,17,0,1,0,4,1,0,2089,NULL,NULL,NULL,20.00,11.00,12.00,505.00,NULL,0,'2024-03-05 00:58:33','2024-03-05 00:58:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(114,'Beaded Evening Clutch',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','WF-155-A0',0,11,0,1,0,3,1,0,1644,NULL,NULL,NULL,10.00,11.00,15.00,517.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(115,'Beaded Evening Clutch',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','WF-155-A0-A1',0,11,0,1,0,3,1,0,1644,NULL,NULL,NULL,10.00,11.00,15.00,517.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(116,'Beaded Evening Clutch',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','WF-155-A0-A2',0,11,0,1,0,3,1,0,1644,NULL,NULL,NULL,10.00,11.00,15.00,517.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(117,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','8O-131-A0',0,18,0,1,0,3,1,0,1359,NULL,NULL,NULL,10.00,15.00,20.00,795.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(118,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','8O-131-A0-A1',0,18,0,1,0,3,1,0,1359,NULL,NULL,NULL,10.00,15.00,20.00,795.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(119,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','6P-153-A0',0,14,0,1,0,1,1,0,2228,1693.28,NULL,NULL,18.00,11.00,10.00,739.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(120,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','6P-153-A0-A1',0,14,0,1,0,1,1,0,2228,1916.08,NULL,NULL,18.00,11.00,10.00,739.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(121,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','6P-153-A0-A2',0,14,0,1,0,1,1,0,2228,1982.92,NULL,NULL,18.00,11.00,10.00,739.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(122,'Embellished Ballet Flats',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','YV-175-A0',0,16,0,1,0,2,1,0,2439,NULL,NULL,NULL,10.00,19.00,19.00,797.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(123,'Embellished Ballet Flats',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','YV-175-A0-A1',0,16,0,1,0,2,1,0,2439,NULL,NULL,NULL,10.00,19.00,19.00,797.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(124,'Pleated Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','U9-166-A0',0,12,0,1,0,2,1,0,1247,NULL,NULL,NULL,20.00,16.00,17.00,777.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(125,'Pleated Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','U9-166-A0-A1',0,12,0,1,0,2,1,0,1247,NULL,NULL,NULL,20.00,16.00,17.00,777.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(126,'Velour Tracksuit Set',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','B0-112-A0',0,15,0,1,0,5,1,0,2076,NULL,NULL,NULL,20.00,12.00,14.00,743.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(127,'Velour Tracksuit Set',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','B0-112-A0-A1',0,15,0,1,0,5,1,0,2076,NULL,NULL,NULL,20.00,12.00,14.00,743.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(128,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','PG-189-A0',0,10,0,1,0,3,1,0,1005,723.6,NULL,NULL,20.00,17.00,15.00,883.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(129,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','PG-189-A0-A1',0,10,0,1,0,3,1,0,1005,824.1,NULL,NULL,20.00,17.00,15.00,883.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(130,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','PG-189-A0-A2',0,10,0,1,0,3,1,0,1005,884.4,NULL,NULL,20.00,17.00,15.00,883.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(131,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','RR-116-A0',0,11,0,1,0,5,1,0,1256,NULL,NULL,NULL,19.00,10.00,20.00,652.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(132,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','RR-116-A0-A1',0,11,0,1,0,5,1,0,1256,NULL,NULL,NULL,19.00,10.00,20.00,652.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(133,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','RR-116-A0-A2',0,11,0,1,0,5,1,0,1256,NULL,NULL,NULL,19.00,10.00,20.00,652.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(134,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','RR-116-A0-A3',0,11,0,1,0,5,1,0,1256,NULL,NULL,NULL,19.00,10.00,20.00,652.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(135,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','GA-185-A0',0,16,0,1,0,2,1,0,425,NULL,NULL,NULL,18.00,15.00,19.00,854.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(136,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','GA-185-A0-A1',0,16,0,1,0,2,1,0,425,NULL,NULL,NULL,18.00,15.00,19.00,854.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(137,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','GA-185-A0-A2',0,16,0,1,0,2,1,0,425,NULL,NULL,NULL,18.00,15.00,19.00,854.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(138,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','S4-116-A0',0,14,0,1,0,1,1,0,1011,NULL,NULL,NULL,17.00,19.00,19.00,841.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(139,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','S4-116-A0-A1',0,14,0,1,0,1,1,0,1011,NULL,NULL,NULL,17.00,19.00,19.00,841.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(140,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','S4-116-A0-A2',0,14,0,1,0,1,1,0,1011,NULL,NULL,NULL,17.00,19.00,19.00,841.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(141,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','S4-116-A0-A3',0,14,0,1,0,1,1,0,1011,NULL,NULL,NULL,17.00,19.00,19.00,841.00,NULL,0,'2024-03-05 00:58:34','2024-03-05 00:58:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(142,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','Q9-116-A0',0,10,0,1,0,5,1,0,1657,1342.17,NULL,NULL,19.00,13.00,20.00,843.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(143,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','Q9-116-A0-A1',0,10,0,1,0,5,1,0,1657,1491.3,NULL,NULL,19.00,13.00,20.00,843.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(144,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','Q9-116-A0-A2',0,10,0,1,0,5,1,0,1657,1259.32,NULL,NULL,19.00,13.00,20.00,843.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(145,'Retro High-Top Sneakers',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','XP-131-A0',0,19,0,1,0,3,1,0,993,NULL,NULL,NULL,20.00,10.00,14.00,649.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(146,'Faux Leather Leggings',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','J7-129-A0',0,14,0,1,0,5,1,0,511,NULL,NULL,NULL,15.00,19.00,20.00,528.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(147,'Faux Leather Leggings',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','J7-129-A0-A1',0,14,0,1,0,5,1,0,511,NULL,NULL,NULL,15.00,19.00,20.00,528.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(148,'Faux Leather Leggings',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','J7-129-A0-A2',0,14,0,1,0,5,1,0,511,NULL,NULL,NULL,15.00,19.00,20.00,528.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(149,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','8P-147-A0',0,18,0,1,0,1,1,0,1024,NULL,NULL,NULL,13.00,14.00,15.00,642.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(150,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','8P-147-A0-A1',0,18,0,1,0,1,1,0,1024,NULL,NULL,NULL,13.00,14.00,15.00,642.00,NULL,0,'2024-03-05 00:58:35','2024-03-05 00:58:35','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,10,25,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(2,8,37,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(3,2,41,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(4,8,40,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(5,7,43,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(6,7,17,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(7,6,14,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\"]'),(8,6,21,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(10,6,27,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(11,7,40,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\"]'),(12,5,37,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(13,1,14,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(14,10,26,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\"]'),(15,7,23,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(16,7,9,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(17,10,2,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\"]'),(18,6,28,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(19,8,31,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(20,3,31,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(21,9,35,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(22,8,22,1.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(23,7,15,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\"]'),(24,1,8,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(25,2,5,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(26,4,13,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\"]'),(27,7,24,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\"]'),(28,8,39,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\"]'),(29,7,6,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(30,5,17,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(31,8,42,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(32,4,9,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(33,9,40,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\"]'),(34,2,21,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\"]'),(35,2,36,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]'),(36,6,13,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(37,7,32,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(38,4,36,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(39,1,12,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(40,6,35,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(41,9,28,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\"]'),(42,8,35,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\"]'),(43,6,30,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-16.jpg\"]'),(44,8,1,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(45,10,1,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(46,5,16,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\"]'),(47,5,10,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-19.jpg\"]'),(48,3,25,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\"]'),(49,8,4,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\"]'),(50,3,23,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(51,4,2,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(52,1,15,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(53,2,10,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(54,10,3,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(56,6,15,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(57,4,32,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(58,8,36,3.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(59,3,10,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-20.jpg\"]'),(60,4,10,5.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(61,4,28,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(62,3,1,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(63,6,34,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(64,5,13,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-18.jpg\"]'),(65,6,4,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\"]'),(66,1,34,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(67,5,30,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\"]'),(68,3,24,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(69,10,40,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-19.jpg\"]'),(70,6,23,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(73,1,40,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\"]'),(74,2,33,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\"]'),(75,5,40,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\"]'),(76,6,20,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(77,10,22,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(78,5,14,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(80,5,1,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\"]'),(81,4,34,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\"]'),(82,3,38,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\"]'),(83,7,18,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(84,1,38,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\"]'),(85,10,15,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(86,10,6,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\"]'),(87,6,39,3.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\"]'),(88,5,4,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-19.jpg\"]'),(89,4,33,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(91,9,42,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-16.jpg\"]'),(92,9,43,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\"]'),(95,7,19,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(96,3,4,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\"]'),(97,6,32,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(98,5,36,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-14.jpg\"]'),(99,2,9,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(100,4,25,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(101,1,24,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(104,2,37,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\"]'),(105,9,34,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(106,4,38,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(107,1,25,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(108,4,40,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(110,1,16,3.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(111,5,11,3.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(112,4,18,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\"]'),(113,1,26,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(114,3,26,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(115,10,19,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(117,9,24,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(118,7,27,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(119,4,42,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(120,5,32,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(122,10,32,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(123,3,21,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(125,5,8,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\"]'),(126,7,20,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-12.jpg\"]'),(127,8,18,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(128,9,4,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(129,4,26,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(130,3,3,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(131,2,11,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\"]'),(132,10,12,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\"]'),(134,5,21,2.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(137,1,35,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-14.jpg\"]'),(138,6,31,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(139,9,5,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\"]'),(140,10,34,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-16.jpg\"]'),(141,2,6,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(142,10,36,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(143,8,19,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\"]'),(146,8,28,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(147,8,29,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(148,9,41,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(149,3,30,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\"]'),(151,8,27,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(152,2,38,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(153,1,20,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(154,9,14,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\"]'),(156,7,38,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(160,4,31,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(161,7,16,4.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\"]'),(163,5,34,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-17.jpg\"]'),(164,5,19,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\"]'),(166,5,3,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-20.jpg\"]'),(167,4,14,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-20.jpg\"]'),(168,10,37,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(169,7,2,2.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(170,8,15,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\"]'),(171,6,26,4.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(172,1,22,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\"]'),(173,8,3,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(174,3,35,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\"]'),(175,10,21,1.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\"]'),(176,7,39,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-16.jpg\"]'),(177,1,6,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(181,8,32,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\"]'),(182,1,21,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(183,1,19,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(184,9,23,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\"]'),(185,4,11,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(188,10,18,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(189,10,38,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(192,10,35,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\"]'),(193,4,29,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(194,8,20,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(195,6,7,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(196,4,21,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(198,5,41,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\"]'),(199,2,12,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(201,9,15,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(202,3,41,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(203,10,4,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(208,2,25,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(209,2,19,5.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(211,5,29,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-17.jpg\"]'),(212,1,37,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(213,3,17,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(214,10,43,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\"]'),(215,5,23,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(216,2,29,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(217,4,39,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(219,3,28,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(220,2,42,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(221,1,4,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(223,5,28,3.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\"]'),(225,8,16,1.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(226,8,17,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(229,10,17,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(230,7,29,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(231,6,37,5.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(232,10,16,5.00,'Best ecommerce CMS online store!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(233,9,26,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(234,2,35,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(235,2,34,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\"]'),(236,8,24,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(237,9,13,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(238,3,11,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(240,1,1,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(241,5,26,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(242,10,33,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(243,3,33,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(244,7,7,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(246,10,24,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(247,7,33,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(248,3,16,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\"]'),(250,9,11,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(255,1,31,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(260,4,24,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\"]'),(261,7,41,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\"]'),(263,3,5,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\"]'),(264,10,9,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(268,4,4,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(269,7,21,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-19.jpg\"]'),(273,5,20,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(279,10,30,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(280,3,7,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(281,1,2,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(283,6,40,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(285,1,39,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(288,4,1,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(289,6,33,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(292,2,4,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(293,8,23,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-20.jpg\"]'),(296,2,8,5.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\"]'),(298,3,2,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\"]'),(300,9,8,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\"]'),(301,2,28,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(305,9,20,3.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(306,9,36,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(307,7,26,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(308,7,36,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\"]'),(311,3,36,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(312,10,27,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(314,8,8,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\"]'),(316,6,5,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-17.jpg\"]'),(317,3,18,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-19.jpg\"]'),(320,9,37,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(322,4,43,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\"]'),(324,8,9,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\"]'),(325,6,17,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\"]'),(327,2,43,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\"]'),(330,7,10,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(331,3,29,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(332,6,2,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\"]'),(333,6,16,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\"]'),(334,6,24,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(335,1,43,5.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(338,4,22,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(340,7,12,2.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(342,3,42,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(344,10,20,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(345,8,34,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(348,10,11,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\"]'),(357,9,17,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(359,9,2,2.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\"]'),(361,3,40,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\"]'),(367,4,3,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(368,5,27,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\"]'),(370,2,7,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(371,3,22,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(372,9,32,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(375,5,5,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(378,5,39,4.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-20.jpg\"]'),(382,6,3,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(385,1,42,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(387,8,2,4.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(390,9,29,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(391,10,41,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(394,8,5,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(395,1,33,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\"]'),(398,5,38,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(400,1,13,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(402,2,16,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(404,9,16,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\"]'),(405,10,14,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\"]'),(407,5,25,1.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\"]'),(411,9,9,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\"]'),(412,10,5,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(413,3,6,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\"]'),(416,1,11,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(418,4,15,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(421,5,9,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(424,2,31,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(425,7,34,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\"]'),(426,9,3,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(428,3,15,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(430,8,7,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\"]'),(432,9,27,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\"]'),(433,6,9,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(435,2,24,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(436,3,13,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\"]'),(437,2,13,4.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(438,3,14,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\"]'),(439,5,33,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(441,10,29,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(442,7,31,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\"]'),(443,4,6,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-17.jpg\"]'),(446,7,8,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(450,9,10,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(457,1,36,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-18.jpg\"]'),(458,4,35,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\"]'),(462,3,43,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(464,2,30,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(465,6,11,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(469,5,31,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(473,5,24,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(481,9,22,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\"]'),(482,3,20,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\"]'),(489,3,19,4.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(495,4,20,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\"]'),(496,5,2,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(498,10,10,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(499,4,12,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(501,3,37,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(508,6,38,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(510,2,32,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-17.jpg\"]'),(511,5,35,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]'),(516,6,22,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(527,8,11,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(529,8,21,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(531,8,14,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(535,6,18,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(542,9,30,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\"]'),(546,2,17,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(550,1,30,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(553,7,4,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(563,1,41,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\"]'),(574,9,1,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\"]'),(580,7,22,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(586,5,7,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(594,4,23,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\"]'),(596,6,36,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\"]'),(598,9,21,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\"]'),(604,8,30,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\"]'),(607,3,39,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\"]'),(608,10,8,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(615,1,18,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(618,9,39,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(620,9,31,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\"]'),(621,2,22,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(629,10,7,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(630,4,27,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(631,7,25,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(635,3,12,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\"]'),(640,4,30,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(642,7,14,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\"]'),(646,6,12,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(660,5,6,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\"]'),(674,2,18,3.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(685,2,27,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\"]'),(686,9,12,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(693,2,23,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(699,6,6,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(701,9,7,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(712,8,12,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(718,3,32,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\"]'),(721,1,10,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(724,8,38,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(730,8,41,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\"]'),(733,1,27,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(734,6,10,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(747,10,23,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(748,1,7,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\"]'),(756,10,42,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\"]'),(774,8,26,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\"]'),(781,3,34,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-19.jpg\"]'),(782,9,33,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(784,3,9,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(786,7,42,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(798,1,32,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\"]'),(812,10,13,3.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(822,1,29,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(827,2,15,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(831,8,25,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(841,7,30,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-17.jpg\"]'),(842,4,41,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-9.jpg\"]'),(843,2,2,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(844,1,5,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\"]'),(845,1,23,2.00,'Clean & perfect source code','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-14.jpg\"]'),(848,10,39,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(854,7,28,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(892,2,40,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(897,7,1,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\"]'),(906,5,18,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]'),(912,9,6,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\"]'),(921,9,19,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\"]'),(945,6,25,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-19.jpg\"]'),(958,6,43,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(959,3,27,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(963,5,43,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(976,7,3,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\"]'),(979,4,7,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-05 00:59:09','2024-03-05 00:59:09','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,2,'2024-02-24 00:58:37','2024-02-24 00:58:37','Botble\\ACL\\Models\\User'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,2,'2024-03-03 08:58:37','2024-03-05 00:58:37','Botble\\ACL\\Models\\User'),(3,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,2,'2024-03-05 00:58:37','2024-03-05 00:58:37','Botble\\ACL\\Models\\User'),(4,'create_from_order','Shipping was created from order %order_id%',0,2,3,'2024-03-03 08:58:37','2024-03-03 08:58:37','Botble\\ACL\\Models\\User'),(5,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,3,'2024-03-03 08:58:37','2024-03-05 00:58:37','Botble\\ACL\\Models\\User'),(6,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,3,'2024-03-05 00:58:37','2024-03-05 00:58:37','Botble\\ACL\\Models\\User'),(7,'create_from_order','Shipping was created from order %order_id%',0,3,6,'2024-02-19 00:58:38','2024-02-19 00:58:38','Botble\\ACL\\Models\\User'),(8,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,6,'2024-03-03 12:58:38','2024-03-05 00:58:38','Botble\\ACL\\Models\\User'),(9,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,6,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\ACL\\Models\\User'),(10,'create_from_order','Shipping was created from order %order_id%',0,4,7,'2024-02-25 12:58:38','2024-02-25 12:58:38','Botble\\ACL\\Models\\User'),(11,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,7,'2024-03-03 14:58:38','2024-03-05 00:58:38','Botble\\ACL\\Models\\User'),(12,'create_from_order','Shipping was created from order %order_id%',0,5,8,'2024-02-22 16:58:38','2024-02-22 16:58:38','Botble\\ACL\\Models\\User'),(13,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,8,'2024-03-03 14:58:38','2024-03-05 00:58:38','Botble\\ACL\\Models\\User'),(14,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,5,8,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\ACL\\Models\\User'),(15,'create_from_order','Shipping was created from order %order_id%',0,6,9,'2024-02-23 08:58:38','2024-02-23 08:58:38','Botble\\ACL\\Models\\User'),(16,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,9,'2024-03-03 16:58:38','2024-03-05 00:58:38','Botble\\ACL\\Models\\User'),(17,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,9,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\ACL\\Models\\User'),(18,'create_from_order','Shipping was created from order %order_id%',0,7,10,'2024-02-20 16:58:38','2024-02-20 16:58:38','Botble\\ACL\\Models\\User'),(19,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,10,'2024-03-03 16:58:39','2024-03-05 00:58:39','Botble\\ACL\\Models\\User'),(20,'create_from_order','Shipping was created from order %order_id%',0,8,11,'2024-02-27 08:58:39','2024-02-27 08:58:39','Botble\\ACL\\Models\\User'),(21,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,11,'2024-03-03 16:58:39','2024-03-05 00:58:39','Botble\\ACL\\Models\\User'),(22,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,11,'2024-03-05 00:58:39','2024-03-05 00:58:39','Botble\\ACL\\Models\\User'),(23,'create_from_order','Shipping was created from order %order_id%',0,9,14,'2024-02-25 06:58:39','2024-02-25 06:58:39','Botble\\ACL\\Models\\User'),(24,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,14,'2024-03-03 18:58:39','2024-03-05 00:58:39','Botble\\ACL\\Models\\User'),(25,'create_from_order','Shipping was created from order %order_id%',0,10,15,'2024-03-02 12:58:39','2024-03-02 12:58:39','Botble\\ACL\\Models\\User'),(26,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,15,'2024-03-03 18:58:39','2024-03-05 00:58:39','Botble\\ACL\\Models\\User'),(27,'create_from_order','Shipping was created from order %order_id%',0,11,16,'2024-02-23 12:58:39','2024-02-23 12:58:39','Botble\\ACL\\Models\\User'),(28,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,16,'2024-03-03 20:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(29,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,11,16,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(30,'create_from_order','Shipping was created from order %order_id%',0,12,17,'2024-02-22 08:58:40','2024-02-22 08:58:40','Botble\\ACL\\Models\\User'),(31,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,17,'2024-03-03 20:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(32,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,12,17,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(33,'create_from_order','Shipping was created from order %order_id%',0,13,18,'2024-02-27 12:58:40','2024-02-27 12:58:40','Botble\\ACL\\Models\\User'),(34,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,18,'2024-03-03 22:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(35,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,13,18,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(36,'create_from_order','Shipping was created from order %order_id%',0,14,19,'2024-02-23 04:58:40','2024-02-23 04:58:40','Botble\\ACL\\Models\\User'),(37,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,19,'2024-03-03 22:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(38,'create_from_order','Shipping was created from order %order_id%',0,15,20,'2024-02-28 00:58:40','2024-02-28 00:58:40','Botble\\ACL\\Models\\User'),(39,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,20,'2024-03-04 00:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(40,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,15,20,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\ACL\\Models\\User'),(41,'create_from_order','Shipping was created from order %order_id%',0,16,22,'2024-03-01 00:58:40','2024-03-01 00:58:40','Botble\\ACL\\Models\\User'),(42,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,22,'2024-03-04 00:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(43,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,16,22,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(44,'create_from_order','Shipping was created from order %order_id%',0,17,23,'2024-02-28 00:58:41','2024-02-28 00:58:41','Botble\\ACL\\Models\\User'),(45,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,23,'2024-03-04 00:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(46,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,17,23,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(47,'create_from_order','Shipping was created from order %order_id%',0,18,24,'2024-02-24 20:58:41','2024-02-24 20:58:41','Botble\\ACL\\Models\\User'),(48,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,24,'2024-03-04 02:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(49,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,24,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(50,'create_from_order','Shipping was created from order %order_id%',0,19,25,'2024-02-25 18:58:41','2024-02-25 18:58:41','Botble\\ACL\\Models\\User'),(51,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,25,'2024-03-04 02:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(52,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,25,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(53,'create_from_order','Shipping was created from order %order_id%',0,20,26,'2024-03-01 16:58:41','2024-03-01 16:58:41','Botble\\ACL\\Models\\User'),(54,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,26,'2024-03-04 04:58:41','2024-03-05 00:58:41','Botble\\ACL\\Models\\User'),(55,'create_from_order','Shipping was created from order %order_id%',0,21,27,'2024-02-25 16:58:41','2024-02-25 16:58:41','Botble\\ACL\\Models\\User'),(56,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,27,'2024-03-04 04:58:42','2024-03-05 00:58:42','Botble\\ACL\\Models\\User'),(57,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,21,27,'2024-03-05 00:58:42','2024-03-05 00:58:42','Botble\\ACL\\Models\\User'),(58,'create_from_order','Shipping was created from order %order_id%',0,22,28,'2024-02-26 12:58:42','2024-02-26 12:58:42','Botble\\ACL\\Models\\User'),(59,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,28,'2024-03-04 06:58:42','2024-03-05 00:58:42','Botble\\ACL\\Models\\User'),(60,'create_from_order','Shipping was created from order %order_id%',0,23,29,'2024-03-01 06:58:42','2024-03-01 06:58:42','Botble\\ACL\\Models\\User'),(61,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,29,'2024-03-04 06:58:42','2024-03-05 00:58:42','Botble\\ACL\\Models\\User'),(62,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,29,'2024-03-05 00:58:42','2024-03-05 00:58:42','Botble\\ACL\\Models\\User'),(63,'create_from_order','Shipping was created from order %order_id%',0,24,30,'2024-02-26 12:58:42','2024-02-26 12:58:42','Botble\\ACL\\Models\\User'),(64,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,30,'2024-03-04 06:58:42','2024-03-05 00:58:42','Botble\\ACL\\Models\\User'),(65,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,30,'2024-03-05 00:58:42','2024-03-05 00:58:42','Botble\\ACL\\Models\\User'),(66,'create_from_order','Shipping was created from order %order_id%',0,25,32,'2024-03-01 16:58:42','2024-03-01 16:58:42','Botble\\ACL\\Models\\User'),(67,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,32,'2024-03-04 08:58:43','2024-03-05 00:58:43','Botble\\ACL\\Models\\User'),(68,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,25,32,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\ACL\\Models\\User'),(69,'create_from_order','Shipping was created from order %order_id%',0,26,33,'2024-03-02 02:58:43','2024-03-02 02:58:43','Botble\\ACL\\Models\\User'),(70,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,33,'2024-03-04 10:58:43','2024-03-05 00:58:43','Botble\\ACL\\Models\\User'),(71,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,26,33,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\ACL\\Models\\User'),(72,'create_from_order','Shipping was created from order %order_id%',0,27,34,'2024-03-03 06:58:43','2024-03-03 06:58:43','Botble\\ACL\\Models\\User'),(73,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,34,'2024-03-04 10:58:43','2024-03-05 00:58:43','Botble\\ACL\\Models\\User'),(74,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,27,34,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\ACL\\Models\\User'),(75,'create_from_order','Shipping was created from order %order_id%',0,28,36,'2024-03-03 06:58:43','2024-03-03 06:58:43','Botble\\ACL\\Models\\User'),(76,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,36,'2024-03-04 10:58:43','2024-03-05 00:58:43','Botble\\ACL\\Models\\User'),(77,'create_from_order','Shipping was created from order %order_id%',0,29,37,'2024-03-03 12:58:43','2024-03-03 12:58:43','Botble\\ACL\\Models\\User'),(78,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,37,'2024-03-04 12:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(79,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,37,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(80,'create_from_order','Shipping was created from order %order_id%',0,30,38,'2024-03-04 12:58:44','2024-03-04 12:58:44','Botble\\ACL\\Models\\User'),(81,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,38,'2024-03-04 12:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(82,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,38,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(83,'create_from_order','Shipping was created from order %order_id%',0,31,39,'2024-03-01 16:58:44','2024-03-01 16:58:44','Botble\\ACL\\Models\\User'),(84,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,39,'2024-03-04 14:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(85,'create_from_order','Shipping was created from order %order_id%',0,32,40,'2024-03-04 04:58:44','2024-03-04 04:58:44','Botble\\ACL\\Models\\User'),(86,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,40,'2024-03-04 14:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(87,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,32,40,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(88,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,40,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\ACL\\Models\\User'),(89,'create_from_order','Shipping was created from order %order_id%',0,33,42,'2024-03-04 08:58:44','2024-03-04 08:58:44','Botble\\ACL\\Models\\User'),(90,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,42,'2024-03-04 16:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(91,'create_from_order','Shipping was created from order %order_id%',0,34,43,'2024-03-04 00:58:45','2024-03-04 00:58:45','Botble\\ACL\\Models\\User'),(92,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,43,'2024-03-04 16:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(93,'create_from_order','Shipping was created from order %order_id%',0,35,44,'2024-03-04 00:58:45','2024-03-04 00:58:45','Botble\\ACL\\Models\\User'),(94,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,44,'2024-03-04 16:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(95,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,35,44,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(96,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,44,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(97,'create_from_order','Shipping was created from order %order_id%',0,36,45,'2024-03-03 12:58:45','2024-03-03 12:58:45','Botble\\ACL\\Models\\User'),(98,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,45,'2024-03-04 18:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(99,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,36,45,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(100,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,45,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(101,'create_from_order','Shipping was created from order %order_id%',0,37,46,'2024-03-04 06:58:45','2024-03-04 06:58:45','Botble\\ACL\\Models\\User'),(102,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,46,'2024-03-04 18:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(103,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,37,46,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(104,'create_from_order','Shipping was created from order %order_id%',0,38,47,'2024-03-03 18:58:45','2024-03-03 18:58:45','Botble\\ACL\\Models\\User'),(105,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,38,47,'2024-03-04 18:58:45','2024-03-05 00:58:45','Botble\\ACL\\Models\\User'),(106,'create_from_order','Shipping was created from order %order_id%',0,39,50,'2024-03-04 00:58:46','2024-03-04 00:58:46','Botble\\ACL\\Models\\User'),(107,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,39,50,'2024-03-04 20:58:46','2024-03-05 00:58:46','Botble\\ACL\\Models\\User'),(108,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,50,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\ACL\\Models\\User'),(109,'create_from_order','Shipping was created from order %order_id%',0,40,51,'2024-03-04 16:58:46','2024-03-04 16:58:46','Botble\\ACL\\Models\\User'),(110,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,40,51,'2024-03-04 20:58:46','2024-03-05 00:58:46','Botble\\ACL\\Models\\User'),(111,'create_from_order','Shipping was created from order %order_id%',0,41,52,'2024-03-04 14:58:46','2024-03-04 14:58:46','Botble\\ACL\\Models\\User'),(112,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,41,52,'2024-03-04 22:58:46','2024-03-05 00:58:46','Botble\\ACL\\Models\\User'),(113,'create_from_order','Shipping was created from order %order_id%',0,42,53,'2024-03-04 14:58:46','2024-03-04 14:58:46','Botble\\ACL\\Models\\User'),(114,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,42,53,'2024-03-04 22:58:46','2024-03-05 00:58:46','Botble\\ACL\\Models\\User'),(115,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,42,53,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\ACL\\Models\\User'),(116,'create_from_order','Shipping was created from order %order_id%',0,43,54,'2024-03-04 18:58:46','2024-03-04 18:58:46','Botble\\ACL\\Models\\User'),(117,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,43,54,'2024-03-04 22:58:47','2024-03-05 00:58:47','Botble\\ACL\\Models\\User'),(118,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,43,54,'2024-03-05 00:58:47','2024-03-05 00:58:47','Botble\\ACL\\Models\\User');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,2,NULL,610.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:37','2024-03-05 00:58:37','JJD0062941508','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:37','2024-03-05 07:58:37',NULL,NULL),(2,3,NULL,1056.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:37','2024-03-05 00:58:37','JJD0019409582','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:58:37','2024-03-05 07:58:37',NULL,NULL),(3,6,NULL,1279.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','JJD0058915751','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:58:38','2024-03-05 07:58:38',NULL,NULL),(4,7,NULL,794.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','JJD0039907886','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:58:38',NULL,NULL,NULL),(5,8,NULL,2391.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','JJD0059513691','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:58:38','2024-03-05 07:58:38',NULL,NULL),(6,9,NULL,2686.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','JJD0034272995','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:38','2024-03-05 07:58:38',NULL,NULL),(7,10,NULL,1590.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:38','2024-03-05 00:58:38','JJD0092683398','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:58:38',NULL,NULL,NULL),(8,11,NULL,528.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','JJD005430709','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:58:39','2024-03-05 07:58:39',NULL,NULL),(9,14,NULL,854.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','JJD0019819966','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:58:39',NULL,NULL,NULL),(10,15,NULL,528.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:39','2024-03-05 00:58:39','JJD0011395070','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:58:39',NULL,NULL,NULL),(11,16,NULL,2106.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','JJD0014719104','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:58:40','2024-03-05 07:58:40',NULL,NULL),(12,17,NULL,798.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','JJD0017569322','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:58:40','2024-03-05 07:58:40',NULL,NULL),(13,18,NULL,2205.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','JJD0073656117','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:58:40','2024-03-05 07:58:40',NULL,NULL),(14,19,NULL,2881.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','JJD0047763146','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:58:40',NULL,NULL,NULL),(15,20,NULL,702.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:40','2024-03-05 00:58:40','JJD0077998815','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:58:40','2024-03-05 07:58:40',NULL,NULL),(16,22,NULL,610.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','JJD0089689909','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:41','2024-03-05 07:58:41',NULL,NULL),(17,23,NULL,610.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','JJD0063849845','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:58:41','2024-03-05 07:58:41',NULL,NULL),(18,24,NULL,2598.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','JJD0055710812','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:41','2024-03-05 07:58:41',NULL,NULL),(19,25,NULL,797.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','JJD0086829862','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:41','2024-03-05 07:58:41',NULL,NULL),(20,26,NULL,520.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:41','2024-03-05 00:58:41','JJD0041632548','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:41',NULL,NULL,NULL),(21,27,NULL,2626.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','JJD0020061696','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:58:42','2024-03-05 07:58:42',NULL,NULL),(22,28,NULL,2132.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','JJD0046272045','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:58:42',NULL,NULL,NULL),(23,29,NULL,744.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','JJD0060514620','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-13 07:58:42','2024-03-05 07:58:42',NULL,NULL),(24,30,NULL,1956.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:42','2024-03-05 00:58:42','JJD0087393209','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-08 07:58:42','2024-03-05 07:58:42',NULL,NULL),(25,32,NULL,3104.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','JJD0094439700','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:58:43','2024-03-05 07:58:43',NULL,NULL),(26,33,NULL,738.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','JJD007784323','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-10 07:58:43','2024-03-05 07:58:43',NULL,NULL),(27,34,NULL,1546.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','JJD0061486722','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:43','2024-03-05 07:58:43',NULL,NULL),(28,36,NULL,652.00,NULL,NULL,'','approved',1256.00,'pending','pending',0.00,0,'2024-03-05 00:58:43','2024-03-05 00:58:43','JJD0018035898','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:58:43',NULL,NULL,NULL),(29,37,NULL,2073.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','JJD0043001024','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:44','2024-03-05 07:58:44',NULL,NULL),(30,38,NULL,1220.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','JJD0099366749','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:58:44','2024-03-05 07:58:44',NULL,NULL),(31,39,NULL,1954.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','JJD0028998305','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:58:44',NULL,NULL,NULL),(32,40,NULL,1893.00,NULL,NULL,'','delivered',2718.00,'completed','pending',0.00,0,'2024-03-05 00:58:44','2024-03-05 00:58:44','JJD0047617695','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:58:44','2024-03-05 07:58:44',NULL,NULL),(33,42,NULL,2172.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','JJD002332853','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:58:45',NULL,NULL,NULL),(34,43,NULL,2391.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','JJD0070519457','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-07 07:58:45',NULL,NULL,NULL),(35,44,NULL,1956.00,NULL,NULL,'','delivered',3768.00,'completed','pending',0.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','JJD0039736335','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-11 07:58:45','2024-03-05 07:58:45',NULL,NULL),(36,45,NULL,1432.00,NULL,NULL,'','delivered',3738.00,'completed','pending',0.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','JJD0046833025','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:58:45','2024-03-05 07:58:45',NULL,NULL),(37,46,NULL,1588.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','JJD002798000','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:58:45','2024-03-05 07:58:45',NULL,NULL),(38,47,NULL,2385.00,NULL,NULL,'','approved',4077.00,'pending','pending',0.00,0,'2024-03-05 00:58:45','2024-03-05 00:58:45','JJD0082207643','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-06 07:58:45',NULL,NULL,NULL),(39,50,NULL,1500.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','JJD0099285723','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-12 07:58:46','2024-03-05 07:58:46',NULL,NULL),(40,51,NULL,1590.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','JJD0017233310','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-15 07:58:46',NULL,NULL,NULL),(41,52,NULL,724.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','JJD006747416','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-09 07:58:46',NULL,NULL,NULL),(42,53,NULL,1116.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:46','2024-03-05 00:58:46','JJD0065825395','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:46','2024-03-05 07:58:46',NULL,NULL),(43,54,NULL,1584.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-05 00:58:47','2024-03-05 00:58:47','JJD0085627382','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-14 07:58:47','2024-03-05 07:58:47',NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2024-03-05 00:58:24','2024-03-05 00:58:24');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',0.00,NULL,0.00,'2024-03-05 00:58:24','2024-03-05 00:58:24');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Shofy','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2024-03-05 00:58:26','2024-03-05 00:58:26');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,1),(1,3),(1,5),(1,6),(1,7),(1,9),(1,12),(1,16),(1,17),(1,18),(1,25),(1,30),(1,32),(1,33),(1,34),(1,36),(1,40),(1,41),(1,42),(2,8),(2,10),(2,14),(2,19),(2,21),(2,24),(2,27),(2,28),(2,29),(2,31),(2,35),(2,37),(2,38),(3,2),(3,4),(3,11),(3,13),(3,15),(3,20),(3,22),(3,23),(3,26),(3,39),(3,43);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2024-03-05 00:58:24','2024-03-05 00:58:24'),(2,'None',0.000000,2,'published','2024-03-05 00:58:24','2024-03-05 00:58:24'),(3,'Import Tax',15.000000,3,'published','2024-03-05 00:58:24','2024-03-05 00:58:24');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2024-03-05 00:58:21','2024-03-05 00:58:21',NULL),(2,'PAYMENT',1,'published','2024-03-05 00:58:21','2024-03-05 00:58:21',NULL),(3,'ORDER &amp; RETURNS',2,'published','2024-03-05 00:58:21','2024-03-05 00:58:21',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2024-03-05 00:58:21','2024-03-05 00:58:21'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2024-03-05 00:58:21','2024-03-05 00:58:21');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Radiant Reflections','Rabbit\'s voice along--\'Catch him, you by the Hatter, and, just as she added, \'and the moral of that is, but I don\'t think,\' Alice went on, \'if you don\'t know what to do it! Oh dear! I wish you.',1,0,'jewelry/galleries/1.jpg',1,'published','2024-03-05 00:58:35','2024-03-05 00:58:35'),(2,'Glamour Grove','I shall remember it in time,\' said the White Rabbit hurried by--the frightened Mouse splashed his way through the neighbouring pool--she could hear him sighing as if a fish came to ME, and told me.',1,0,'jewelry/galleries/2.jpg',1,'published','2024-03-05 00:58:35','2024-03-05 00:58:35'),(3,'Serene Styles Showcase','Alice as she spoke--fancy CURTSEYING as you\'re falling through the air! Do you think you could draw treacle out of the tale was something like it,\' said Alice. \'I\'m glad they\'ve begun asking.',1,0,'jewelry/galleries/3.jpg',1,'published','2024-03-05 00:58:35','2024-03-05 00:58:35'),(4,'Allure Alcove','The Dormouse shook its head to keep herself from being broken. She hastily put down the little crocodile Improve his shining tail, And pour the waters of the jury eagerly wrote down on one knee.',1,0,'jewelry/galleries/4.jpg',1,'published','2024-03-05 00:58:35','2024-03-05 00:58:35'),(5,'Glamour Galleria','There was a most extraordinary noise going on between the executioner, the King, going up to her usual height. It was the BEST butter,\' the March Hare and his buttons, and turns out his toes.\'.',1,0,'jewelry/galleries/5.jpg',1,'published','2024-03-05 00:58:35','2024-03-05 00:58:35'),(6,'Beauty Boulevard','Dormouse began in a bit.\' \'Perhaps it hasn\'t one,\' Alice ventured to ask. \'Suppose we change the subject,\' the March Hare, \'that \"I breathe when I find a pleasure in all directions, tumbling up.',1,0,'jewelry/galleries/6.jpg',1,'published','2024-03-05 00:58:35','2024-03-05 00:58:35');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"And beat him when he pleases!\' CHORUS. \'Wow! wow! wow!\' \'Here! you may nurse it a very good height indeed!\' said the Pigeon; \'but if you\'ve seen them so shiny?\' Alice looked at them with one eye.\"},{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"She was walking by the carrier,\' she thought; \'and how funny it\'ll seem to come down the middle, wondering how she would gather about her repeating \'YOU ARE OLD, FATHER WILLIAM,\' to the other side.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"Alice. \'Exactly so,\' said Alice. \'And ever since that,\' the Hatter said, turning to Alice, flinging the baby was howling so much surprised, that for two Pennyworth only of beautiful Soup? Pennyworth.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"Shark, But, when the White Rabbit read out, at the flowers and the m--\' But here, to Alice\'s side as she could not tell whether they were lying round the hall, but they all looked puzzled.) \'He must.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"White Rabbit. She was walking by the time they had to pinch it to annoy, Because he knows it teases.\' CHORUS. (In which the wretched Hatter trembled so, that Alice quite jumped; but she knew the.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:58:35','2024-03-05 00:58:35'),(2,'[{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"And beat him when he pleases!\' CHORUS. \'Wow! wow! wow!\' \'Here! you may nurse it a very good height indeed!\' said the Pigeon; \'but if you\'ve seen them so shiny?\' Alice looked at them with one eye.\"},{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"She was walking by the carrier,\' she thought; \'and how funny it\'ll seem to come down the middle, wondering how she would gather about her repeating \'YOU ARE OLD, FATHER WILLIAM,\' to the other side.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"Alice. \'Exactly so,\' said Alice. \'And ever since that,\' the Hatter said, turning to Alice, flinging the baby was howling so much surprised, that for two Pennyworth only of beautiful Soup? Pennyworth.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"Shark, But, when the White Rabbit read out, at the flowers and the m--\' But here, to Alice\'s side as she could not tell whether they were lying round the hall, but they all looked puzzled.) \'He must.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"White Rabbit. She was walking by the time they had to pinch it to annoy, Because he knows it teases.\' CHORUS. (In which the wretched Hatter trembled so, that Alice quite jumped; but she knew the.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:58:35','2024-03-05 00:58:35'),(3,'[{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"And beat him when he pleases!\' CHORUS. \'Wow! wow! wow!\' \'Here! you may nurse it a very good height indeed!\' said the Pigeon; \'but if you\'ve seen them so shiny?\' Alice looked at them with one eye.\"},{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"She was walking by the carrier,\' she thought; \'and how funny it\'ll seem to come down the middle, wondering how she would gather about her repeating \'YOU ARE OLD, FATHER WILLIAM,\' to the other side.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"Alice. \'Exactly so,\' said Alice. \'And ever since that,\' the Hatter said, turning to Alice, flinging the baby was howling so much surprised, that for two Pennyworth only of beautiful Soup? Pennyworth.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"Shark, But, when the White Rabbit read out, at the flowers and the m--\' But here, to Alice\'s side as she could not tell whether they were lying round the hall, but they all looked puzzled.) \'He must.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"White Rabbit. She was walking by the time they had to pinch it to annoy, Because he knows it teases.\' CHORUS. (In which the wretched Hatter trembled so, that Alice quite jumped; but she knew the.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:58:35','2024-03-05 00:58:35'),(4,'[{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"And beat him when he pleases!\' CHORUS. \'Wow! wow! wow!\' \'Here! you may nurse it a very good height indeed!\' said the Pigeon; \'but if you\'ve seen them so shiny?\' Alice looked at them with one eye.\"},{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"She was walking by the carrier,\' she thought; \'and how funny it\'ll seem to come down the middle, wondering how she would gather about her repeating \'YOU ARE OLD, FATHER WILLIAM,\' to the other side.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"Alice. \'Exactly so,\' said Alice. \'And ever since that,\' the Hatter said, turning to Alice, flinging the baby was howling so much surprised, that for two Pennyworth only of beautiful Soup? Pennyworth.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"Shark, But, when the White Rabbit read out, at the flowers and the m--\' But here, to Alice\'s side as she could not tell whether they were lying round the hall, but they all looked puzzled.) \'He must.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"White Rabbit. She was walking by the time they had to pinch it to annoy, Because he knows it teases.\' CHORUS. (In which the wretched Hatter trembled so, that Alice quite jumped; but she knew the.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:58:35','2024-03-05 00:58:35'),(5,'[{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"And beat him when he pleases!\' CHORUS. \'Wow! wow! wow!\' \'Here! you may nurse it a very good height indeed!\' said the Pigeon; \'but if you\'ve seen them so shiny?\' Alice looked at them with one eye.\"},{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"She was walking by the carrier,\' she thought; \'and how funny it\'ll seem to come down the middle, wondering how she would gather about her repeating \'YOU ARE OLD, FATHER WILLIAM,\' to the other side.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"Alice. \'Exactly so,\' said Alice. \'And ever since that,\' the Hatter said, turning to Alice, flinging the baby was howling so much surprised, that for two Pennyworth only of beautiful Soup? Pennyworth.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"Shark, But, when the White Rabbit read out, at the flowers and the m--\' But here, to Alice\'s side as she could not tell whether they were lying round the hall, but they all looked puzzled.) \'He must.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"White Rabbit. She was walking by the time they had to pinch it to annoy, Because he knows it teases.\' CHORUS. (In which the wretched Hatter trembled so, that Alice quite jumped; but she knew the.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:58:35','2024-03-05 00:58:35'),(6,'[{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"And beat him when he pleases!\' CHORUS. \'Wow! wow! wow!\' \'Here! you may nurse it a very good height indeed!\' said the Pigeon; \'but if you\'ve seen them so shiny?\' Alice looked at them with one eye.\"},{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"She was walking by the carrier,\' she thought; \'and how funny it\'ll seem to come down the middle, wondering how she would gather about her repeating \'YOU ARE OLD, FATHER WILLIAM,\' to the other side.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"Alice. \'Exactly so,\' said Alice. \'And ever since that,\' the Hatter said, turning to Alice, flinging the baby was howling so much surprised, that for two Pennyworth only of beautiful Soup? Pennyworth.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"Shark, But, when the White Rabbit read out, at the flowers and the m--\' But here, to Alice\'s side as she could not tell whether they were lying round the hall, but they all looked puzzled.) \'He must.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"White Rabbit. She was walking by the time they had to pinch it to annoy, Because he knows it teases.\' CHORUS. (In which the wretched Hatter trembled so, that Alice quite jumped; but she knew the.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2024-03-05 00:58:35','2024-03-05 00:58:35');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','c8771d699a3f54dc62636d6671a6601c',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','1ce23547bfc45f7a57e8f9102f6da802',1,'Botble\\Menu\\Models\\MenuLocation'),(3,'en_US','a8e42b86f2f91441a797b4381b8ba666',1,'Botble\\Menu\\Models\\Menu'),(4,'en_US','f2c29699d1e75c26bcd1ebfc959dc302',2,'Botble\\Menu\\Models\\Menu'),(5,'en_US','611b3b3c13c2b245db9de962c76dde72',3,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'404','404',2,'image/png',15820,'main/general/404.png','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(2,0,'about-1','about-1',2,'image/jpeg',9222,'main/general/about-1.jpg','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(3,0,'about-2','about-2',2,'image/jpeg',5105,'main/general/about-2.jpg','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(4,0,'cta-shape-1','cta-shape-1',2,'image/png',22860,'main/general/cta-shape-1.png','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(5,0,'cta-shape-2','cta-shape-2',2,'image/png',16796,'main/general/cta-shape-2.png','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(6,0,'cta-thumb-1','cta-thumb-1',2,'image/jpeg',6053,'main/general/cta-thumb-1.jpg','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(7,0,'favicon','favicon',2,'image/png',1831,'main/general/favicon.png','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(8,0,'footer-pay','footer-pay',2,'image/png',490,'main/general/footer-pay.png','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(9,0,'logo-white','logo-white',2,'image/png',3793,'main/general/logo-white.png','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(10,0,'logo','logo',2,'image/png',4122,'main/general/logo.png','[]','2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(11,0,'preloader-icon','preloader-icon',2,'image/png',4182,'main/general/preloader-icon.png','[]','2024-03-05 00:58:21','2024-03-05 00:58:21',NULL),(12,0,'signature','signature',2,'image/png',2117,'main/general/signature.png','[]','2024-03-05 00:58:21','2024-03-05 00:58:21',NULL),(13,0,'slider-offer','slider-offer',2,'image/png',970,'main/general/slider-offer.png','[]','2024-03-05 00:58:21','2024-03-05 00:58:21',NULL),(24,0,'1','1',4,'image/jpeg',4294,'main/customers/1.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(25,0,'10','10',4,'image/jpeg',4294,'main/customers/10.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(26,0,'2','2',4,'image/jpeg',4294,'main/customers/2.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(27,0,'3','3',4,'image/jpeg',4294,'main/customers/3.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(28,0,'4','4',4,'image/jpeg',4294,'main/customers/4.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(29,0,'5','5',4,'image/jpeg',4294,'main/customers/5.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(30,0,'6','6',4,'image/jpeg',4294,'main/customers/6.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(31,0,'7','7',4,'image/jpeg',4294,'main/customers/7.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(32,0,'8','8',4,'image/jpeg',4294,'main/customers/8.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(33,0,'9','9',4,'image/jpeg',4294,'main/customers/9.jpg','[]','2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(34,0,'blog-big-1','blog-big-1',5,'image/jpeg',13885,'main/blog/blog-big-1.jpg','[]','2024-03-05 00:58:24','2024-03-05 00:58:24',NULL),(35,0,'blog-details-sm-1','blog-details-sm-1',5,'image/jpeg',8166,'main/blog/blog-details-sm-1.jpg','[]','2024-03-05 00:58:24','2024-03-05 00:58:24',NULL),(36,0,'post-1','post-1',5,'image/jpeg',6189,'main/blog/post-1.jpg','[]','2024-03-05 00:58:24','2024-03-05 00:58:24',NULL),(37,0,'post-10','post-10',5,'image/jpeg',5907,'main/blog/post-10.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(38,0,'post-11','post-11',5,'image/jpeg',5907,'main/blog/post-11.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(39,0,'post-12','post-12',5,'image/jpeg',5907,'main/blog/post-12.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(40,0,'post-2','post-2',5,'image/jpeg',6189,'main/blog/post-2.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(41,0,'post-3','post-3',5,'image/jpeg',6189,'main/blog/post-3.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(42,0,'post-4','post-4',5,'image/jpeg',6045,'main/blog/post-4.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(43,0,'post-5','post-5',5,'image/jpeg',6045,'main/blog/post-5.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(44,0,'post-6','post-6',5,'image/jpeg',6045,'main/blog/post-6.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(45,0,'post-7','post-7',5,'image/jpeg',5907,'main/blog/post-7.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(46,0,'post-8','post-8',5,'image/jpeg',5907,'main/blog/post-8.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(47,0,'post-9','post-9',5,'image/jpeg',5907,'main/blog/post-9.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(48,0,'1','1',3,'image/jpeg',4068,'main/users/1.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(49,0,'10','10',3,'image/jpeg',7599,'main/users/10.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(50,0,'2','2',3,'image/jpeg',7599,'main/users/2.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(51,0,'3','3',3,'image/jpeg',6387,'main/users/3.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(52,0,'4','4',3,'image/jpeg',7599,'main/users/4.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(53,0,'5','5',3,'image/jpeg',6387,'main/users/5.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(54,0,'6','6',3,'image/jpeg',7599,'main/users/6.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(55,0,'7','7',3,'image/jpeg',6387,'main/users/7.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(56,0,'8','8',3,'image/jpeg',7599,'main/users/8.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(57,0,'9','9',3,'image/jpeg',6387,'main/users/9.jpg','[]','2024-03-05 00:58:25','2024-03-05 00:58:25',NULL),(58,0,'1','1',6,'image/png',9133,'main/stores/1.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(59,0,'10','10',6,'image/png',4263,'main/stores/10.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(60,0,'11','11',6,'image/png',4420,'main/stores/11.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(61,0,'12','12',6,'image/png',4908,'main/stores/12.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(62,0,'13','13',6,'image/png',3441,'main/stores/13.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(63,0,'14','14',6,'image/png',4209,'main/stores/14.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(64,0,'15','15',6,'image/png',5113,'main/stores/15.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(65,0,'16','16',6,'image/png',4563,'main/stores/16.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(66,0,'17','17',6,'image/png',4896,'main/stores/17.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(67,0,'2','2',6,'image/png',9008,'main/stores/2.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(68,0,'3','3',6,'image/png',8006,'main/stores/3.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(69,0,'4','4',6,'image/png',8728,'main/stores/4.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(70,0,'5','5',6,'image/png',10689,'main/stores/5.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(71,0,'6','6',6,'image/png',10989,'main/stores/6.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(72,0,'7','7',6,'image/png',3730,'main/stores/7.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(73,0,'8','8',6,'image/png',4030,'main/stores/8.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(74,0,'9','9',6,'image/png',3810,'main/stores/9.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(75,0,'cover-1','cover-1',6,'image/png',4208,'main/stores/cover-1.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(76,0,'cover-2','cover-2',6,'image/png',8798,'main/stores/cover-2.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(77,0,'cover-3','cover-3',6,'image/png',3888,'main/stores/cover-3.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(78,0,'cover-4','cover-4',6,'image/png',11893,'main/stores/cover-4.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(79,0,'cover-5','cover-5',6,'image/png',8798,'main/stores/cover-5.png','[]','2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(80,0,'slider-1','slider-1',8,'image/png',14471,'jewelry/sliders/slider-1.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(81,0,'slider-2','slider-2',8,'image/png',13483,'jewelry/sliders/slider-2.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(82,0,'slider-3','slider-3',8,'image/png',16822,'jewelry/sliders/slider-3.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(83,0,'slider-4','slider-4',8,'image/png',13919,'jewelry/sliders/slider-4.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(84,0,'1','1',9,'image/jpeg',4294,'jewelry/product-categories/1.jpg','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(85,0,'2','2',9,'image/jpeg',4294,'jewelry/product-categories/2.jpg','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(86,0,'3','3',9,'image/jpeg',4294,'jewelry/product-categories/3.jpg','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(87,0,'4','4',9,'image/jpeg',4294,'jewelry/product-categories/4.jpg','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(88,0,'5','5',9,'image/jpeg',4294,'jewelry/product-categories/5.jpg','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(89,0,'product-1','product-1',10,'image/png',9803,'jewelry/products/product-1.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(90,0,'product-2','product-2',10,'image/png',9803,'jewelry/products/product-2.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(91,0,'product-3','product-3',10,'image/png',9803,'jewelry/products/product-3.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(92,0,'product-4','product-4',10,'image/png',9803,'jewelry/products/product-4.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(93,0,'product-5','product-5',10,'image/png',9803,'jewelry/products/product-5.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(94,0,'product-6','product-6',10,'image/png',9803,'jewelry/products/product-6.png','[]','2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(95,0,'product-7','product-7',10,'image/png',9803,'jewelry/products/product-7.png','[]','2024-03-05 00:58:30','2024-03-05 00:58:30',NULL),(96,0,'product-8','product-8',10,'image/png',9803,'jewelry/products/product-8.png','[]','2024-03-05 00:58:30','2024-03-05 00:58:30',NULL),(97,0,'1','1',11,'image/jpeg',5406,'jewelry/banners/1.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(98,0,'2','2',11,'image/jpeg',4233,'jewelry/banners/2.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(99,0,'3','3',11,'image/jpeg',4233,'jewelry/banners/3.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(100,0,'4','4',11,'image/jpeg',12882,'jewelry/banners/4.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(101,0,'1','1',12,'image/jpeg',4294,'jewelry/galleries/1.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(102,0,'2','2',12,'image/jpeg',4294,'jewelry/galleries/2.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(103,0,'3','3',12,'image/jpeg',4294,'jewelry/galleries/3.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(104,0,'4','4',12,'image/jpeg',4294,'jewelry/galleries/4.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(105,0,'5','5',12,'image/jpeg',4294,'jewelry/galleries/5.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(106,0,'6','6',12,'image/jpeg',4294,'jewelry/galleries/6.jpg','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(107,0,'icon-1','icon-1',13,'image/png',4469,'main/contact/icon-1.png','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(108,0,'icon-2','icon-2',13,'image/png',5977,'main/contact/icon-2.png','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(109,0,'icon-3','icon-3',13,'image/png',6082,'main/contact/icon-3.png','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(110,0,'1','1',14,'image/png',948,'main/brands/1.png','[]','2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(111,0,'2','2',14,'image/png',948,'main/brands/2.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(112,0,'3','3',14,'image/png',948,'main/brands/3.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(113,0,'4','4',14,'image/png',948,'main/brands/4.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(114,0,'5','5',14,'image/png',948,'main/brands/5.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(115,0,'logo_01','logo_01',14,'image/png',948,'main/brands/logo-01.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(116,0,'logo_02','logo_02',14,'image/png',948,'main/brands/logo-02.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(117,0,'logo_03','logo_03',14,'image/png',948,'main/brands/logo-03.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(118,0,'logo_04','logo_04',14,'image/png',948,'main/brands/logo-04.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(119,0,'logo_05','logo_05',14,'image/png',948,'main/brands/logo-05.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(120,0,'line','line',15,'image/png',6152,'main/shapes/line.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL),(121,0,'quote','quote',15,'image/png',595,'main/shapes/quote.png','[]','2024-03-05 00:58:36','2024-03-05 00:58:36',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(2,0,'general',NULL,'general',1,'2024-03-05 00:58:20','2024-03-05 00:58:20',NULL),(3,0,'users',NULL,'users',1,'2024-03-05 00:58:21','2024-03-05 00:58:21',NULL),(4,0,'customers',NULL,'customers',1,'2024-03-05 00:58:22','2024-03-05 00:58:22',NULL),(5,0,'blog',NULL,'blog',1,'2024-03-05 00:58:24','2024-03-05 00:58:24',NULL),(6,0,'stores',NULL,'stores',1,'2024-03-05 00:58:26','2024-03-05 00:58:26',NULL),(7,0,'jewelry',NULL,'jewelry',0,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(8,0,'sliders',NULL,'sliders',7,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(9,0,'product-categories',NULL,'product-categories',7,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(10,0,'products',NULL,'products',7,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL),(11,0,'banners',NULL,'banners',7,'2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(12,0,'galleries',NULL,'galleries',7,'2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(13,0,'contact',NULL,'contact',1,'2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(14,0,'brands',NULL,'brands',1,'2024-03-05 00:58:35','2024-03-05 00:58:35',NULL),(15,0,'shapes',NULL,'shapes',1,'2024-03-05 00:58:36','2024-03-05 00:58:36',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2024-03-05 00:58:36','2024-03-05 00:58:36');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,1,'Botble\\Page\\Models\\Page','/home',NULL,0,'Home',NULL,'_self',1,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(2,1,1,NULL,NULL,'https://shofy.botble.com',NULL,0,'Electronics',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(3,1,1,NULL,NULL,'https://shofy-fashion.botble.com',NULL,0,'Fashion',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(4,1,1,NULL,NULL,'https://shofy-beauty.botble.com',NULL,0,'Beauty',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(5,1,1,NULL,NULL,'https://shofy-jewelry.botble.com',NULL,0,'Jewelry',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(6,1,1,NULL,NULL,'https://shofy-grocery.botble.com',NULL,0,'Grocery',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(7,1,0,NULL,NULL,NULL,NULL,0,'Shop',NULL,'_self',1,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(8,1,7,2,'Botble\\Page\\Models\\Page','/product-categories',NULL,0,'Shop Categories',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,0,'Shop List',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(10,1,7,NULL,NULL,'/products?layout=grid',NULL,0,'Shop Grid',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(11,1,7,NULL,NULL,'/products/structured-satchel-bag',NULL,0,'Product Detail',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(12,1,7,3,'Botble\\Page\\Models\\Page','/coupons',NULL,0,'Grab Coupons',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(13,1,7,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(14,1,7,NULL,NULL,'/compare',NULL,0,'Compare',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(15,1,7,NULL,NULL,'/wishlist',NULL,0,'Wishlist',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(16,1,7,NULL,NULL,'/orders/tracking',NULL,0,'Track Your Order',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(17,1,0,NULL,NULL,'/stores',NULL,0,'Vendors',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(18,1,0,NULL,NULL,NULL,NULL,0,'Pages',NULL,'_self',1,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(19,1,18,NULL,NULL,'/login',NULL,0,'Login',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(20,1,18,NULL,NULL,'/register',NULL,0,'Register',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(21,1,18,NULL,NULL,'/password/reset',NULL,0,'Forgot Password',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(22,1,18,NULL,NULL,'/404',NULL,0,'404 Error',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(23,1,0,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',1,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(24,1,23,NULL,NULL,'/blog?layout=grid',NULL,0,'Blog Grid',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(25,1,23,NULL,NULL,'/blog?layout=list',NULL,0,'Blog List',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(26,1,23,NULL,NULL,'/blog/the-litigants-on-the-screen-are-not-actors',NULL,0,'Blog Detail',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(27,1,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(28,2,0,NULL,NULL,'/orders/tracking',NULL,1,'Track Orders',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(29,2,0,9,'Botble\\Page\\Models\\Page','/shipping',NULL,1,'Shipping',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(30,2,0,NULL,NULL,'/wishlist',NULL,1,'Wishlist',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(31,2,0,NULL,NULL,'/customer/overview',NULL,1,'My Account',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(32,2,0,NULL,NULL,'/customer/orders',NULL,1,'Order History',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(33,2,0,NULL,NULL,'/customer/order-returns',NULL,1,'Returns',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(34,3,0,7,'Botble\\Page\\Models\\Page','/our-story',NULL,2,'Our Story',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(35,3,0,8,'Botble\\Page\\Models\\Page','/careers',NULL,2,'Careers',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(36,3,0,6,'Botble\\Page\\Models\\Page','/cookie-policy',NULL,2,'Privacy Policy',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(37,3,0,NULL,NULL,'/blog',NULL,2,'Latest News',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36'),(38,3,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,2,'Contact Us',NULL,'_self',0,'2024-03-05 00:58:36','2024-03-05 00:58:36');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(2,'My Account','my-account','published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(3,'Information','information','published','2024-03-05 00:58:36','2024-03-05 00:58:36');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'background','[\"main\\/stores\\/cover-5.png\"]',1,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(2,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',1,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(3,'background','[\"main\\/stores\\/cover-4.png\"]',2,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(4,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',2,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(5,'background','[\"main\\/stores\\/cover-2.png\"]',3,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(6,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',3,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(7,'background','[\"main\\/stores\\/cover-3.png\"]',4,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(8,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',4,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(9,'background','[\"main\\/stores\\/cover-2.png\"]',5,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(10,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',5,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(11,'background','[\"main\\/stores\\/cover-4.png\"]',6,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(12,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',6,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(13,'background','[\"main\\/stores\\/cover-1.png\"]',7,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(14,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',7,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(15,'background','[\"main\\/stores\\/cover-2.png\"]',8,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(16,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',8,'Botble\\Marketplace\\Models\\Store','2024-03-05 00:58:29','2024-03-05 00:58:29'),(17,'button_label','[\"Discover Now\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:58:29','2024-03-05 00:58:29'),(18,'button_label','[\"Discover Now\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:58:29','2024-03-05 00:58:29'),(19,'button_label','[\"Discover Now\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:58:29','2024-03-05 00:58:29'),(20,'button_label','[\"Discover Now\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-05 00:58:29','2024-03-05 00:58:29'),(21,'faq_ids','[[1,6,7,8,9]]',1,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(22,'faq_ids','[[4,5,6,8,9]]',2,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(23,'faq_ids','[[1,5,7,9,10]]',3,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(24,'faq_ids','[[2,3,4,5,10]]',4,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(25,'faq_ids','[[1,2,6,8,9]]',5,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(26,'faq_ids','[[1,2,6,9,10]]',6,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(27,'faq_ids','[[1,3,5,6,9]]',7,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(28,'faq_ids','[[2,3,4,9,10]]',8,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(29,'faq_ids','[[3,5,7,8,10]]',9,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(30,'faq_ids','[[1,2,4,6,9]]',10,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(31,'faq_ids','[[1,2,3,4,10]]',11,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(32,'faq_ids','[[2,3,4,5,8]]',12,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(33,'faq_ids','[[1,5,6,8,10]]',13,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(34,'faq_ids','[[1,2,5,7,8]]',14,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(35,'faq_ids','[[1,2,3,5,9]]',15,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(36,'faq_ids','[[2,3,4,6,8]]',16,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(37,'faq_ids','[[1,4,6,7,8]]',17,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(38,'faq_ids','[[2,4,5,6,9]]',18,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(39,'faq_ids','[[3,6,8,9,10]]',19,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(40,'faq_ids','[[3,4,7,9,10]]',20,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(41,'faq_ids','[[2,5,7,8,9]]',21,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(42,'faq_ids','[[4,5,7,8,10]]',22,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(43,'faq_ids','[[1,5,8,9,10]]',23,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(44,'faq_ids','[[1,3,6,8,10]]',24,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(45,'faq_ids','[[2,5,8,9,10]]',25,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(46,'faq_ids','[[1,2,3,5,9]]',26,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(47,'faq_ids','[[1,2,4,5,10]]',27,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(48,'faq_ids','[[4,6,8,9,10]]',28,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(49,'faq_ids','[[3,5,7,8,9]]',29,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(50,'faq_ids','[[2,3,4,7,8]]',30,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:30','2024-03-05 00:58:30'),(51,'faq_ids','[[1,5,6,8,10]]',31,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(52,'faq_ids','[[2,3,4,8,10]]',32,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(53,'faq_ids','[[1,2,3,4,8]]',33,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(54,'faq_ids','[[2,3,4,6,8]]',34,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(55,'faq_ids','[[1,4,5,8,9]]',35,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(56,'faq_ids','[[1,2,6,7,10]]',36,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(57,'faq_ids','[[2,3,5,6,8]]',37,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(58,'faq_ids','[[1,3,7,8,9]]',38,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(59,'faq_ids','[[2,5,7,9,10]]',39,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(60,'faq_ids','[[1,3,7,8,9]]',40,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(61,'faq_ids','[[1,5,6,7,8]]',41,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(62,'faq_ids','[[1,2,3,7,9]]',42,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(63,'faq_ids','[[2,3,4,7,10]]',43,'Botble\\Ecommerce\\Models\\Product','2024-03-05 00:58:31','2024-03-05 00:58:31'),(64,'title','[\"Ardeco pearl \\n Rings style 2023\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(65,'subtitle','[\"Collection\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(66,'button_label','[\"Shop Now\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(67,'title','[\"Tropical Set\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(68,'subtitle','[\"Trending\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(69,'button_label','[\"Shop Now\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(70,'title','[\"Gold Jewelry\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(71,'subtitle','[\"New Arrival\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(72,'button_label','[\"Shop Now\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(73,'title','[\"Ring gold with \\n diamonds\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(74,'subtitle','[\"Collection\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(75,'button_label','[\"Shop Now\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-05 00:58:35','2024-03-05 00:58:35'),(76,'breadcrumb_style','[\"none\"]',1,'Botble\\Page\\Models\\Page','2024-03-05 00:58:36','2024-03-05 00:58:36'),(77,'breadcrumb_style','[\"align-start\"]',2,'Botble\\Page\\Models\\Page','2024-03-05 00:58:36','2024-03-05 00:58:36');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_reset_tokens_table',1),(5,'2015_06_18_033822_create_blog_table',1),(6,'2015_06_29_025744_create_audit_history',1),(7,'2016_05_28_112028_create_system_request_logs_table',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2020_03_05_041139_create_ecommerce_tables',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',1),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',1),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',1),(34,'2021_02_16_092633_remove_default_value_for_author_type',1),(35,'2021_02_18_073505_update_table_ec_reviews',1),(36,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',1),(37,'2021_03_10_025153_change_column_tax_amount',1),(38,'2021_03_20_033103_add_column_availability_to_table_ec_products',1),(39,'2021_03_27_144913_add_customer_type_into_table_payments',1),(40,'2021_04_28_074008_ecommerce_create_product_label_table',1),(41,'2021_05_24_034720_make_column_currency_nullable',1),(42,'2021_05_31_173037_ecommerce_create_ec_products_translations',1),(43,'2021_07_06_030002_create_marketplace_table',1),(44,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(45,'2021_08_17_105016_remove_column_currency_id_in_some_tables',1),(46,'2021_08_30_142128_add_images_column_to_ec_reviews_table',1),(47,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',1),(48,'2021_10_04_030050_add_column_created_by_to_table_ec_products',1),(49,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',1),(50,'2021_10_05_122616_add_status_column_to_ec_customers_table',1),(51,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',1),(52,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',1),(53,'2021_10_19_020859_update_metadata_field',1),(54,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(55,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',1),(56,'2021_11_23_071403_correct_languages_for_product_variations',1),(57,'2021_11_28_031808_add_product_tags_translations',1),(58,'2021_12_01_031123_add_featured_image_to_ec_products',1),(59,'2021_12_02_035301_add_ads_translations_table',1),(60,'2021_12_03_030600_create_blog_translations',1),(61,'2021_12_03_075608_create_page_translations',1),(62,'2021_12_03_082134_create_faq_translations',1),(63,'2021_12_03_082953_create_gallery_translations',1),(64,'2021_12_03_083642_create_testimonials_translations',1),(65,'2021_12_03_084118_create_location_translations',1),(66,'2021_12_03_094518_migrate_old_location_data',1),(67,'2021_12_06_031304_update_table_mp_customer_revenues',1),(68,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(69,'2022_01_01_033107_update_table_ec_shipments',1),(70,'2022_01_16_085908_improve_plugin_location',1),(71,'2022_02_16_042457_improve_product_attribute_sets',1),(72,'2022_03_22_075758_correct_product_name',1),(73,'2022_04_19_113334_add_index_to_ec_products',1),(74,'2022_04_19_113923_add_index_to_table_posts',1),(75,'2022_04_20_100851_add_index_to_media_table',1),(76,'2022_04_20_101046_add_index_to_menu_table',1),(77,'2022_04_28_144405_remove_unused_table',1),(78,'2022_04_30_034048_create_gallery_meta_translations_table',1),(79,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',1),(80,'2022_05_18_143720_add_index_to_table_ec_product_categories',1),(81,'2022_06_16_095633_add_index_to_some_tables',1),(82,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(83,'2022_06_30_035148_create_order_referrals_table',1),(84,'2022_07_07_153354_update_charge_id_in_table_payments',1),(85,'2022_07_10_034813_move_lang_folder_to_root',1),(86,'2022_07_24_153815_add_completed_at_to_ec_orders_table',1),(87,'2022_08_04_051940_add_missing_column_expires_at',1),(88,'2022_08_04_052122_delete_location_backup_tables',1),(89,'2022_08_14_032836_create_ec_order_returns_table',1),(90,'2022_08_14_033554_create_ec_order_return_items_table',1),(91,'2022_08_15_040324_add_billing_address',1),(92,'2022_08_30_091114_support_digital_products_table',1),(93,'2022_09_01_000001_create_admin_notifications_tables',1),(94,'2022_09_13_095744_create_options_table',1),(95,'2022_09_13_104347_create_option_value_table',1),(96,'2022_10_05_163518_alter_table_ec_order_product',1),(97,'2022_10_12_041517_create_invoices_table',1),(98,'2022_10_12_142226_update_orders_table',1),(99,'2022_10_13_024916_update_table_order_returns',1),(100,'2022_10_14_024629_drop_column_is_featured',1),(101,'2022_10_19_152916_add_columns_to_mp_stores_table',1),(102,'2022_10_20_062849_create_mp_category_sale_commissions_table',1),(103,'2022_10_21_030830_update_columns_in_ec_shipments_table',1),(104,'2022_10_28_021046_update_columns_in_ec_shipments_table',1),(105,'2022_11_02_071413_add_more_info_for_store',1),(106,'2022_11_02_080444_add_tax_info',1),(107,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',1),(108,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(109,'2022_11_19_041643_add_ec_tax_product_table',1),(110,'2022_12_02_093615_update_slug_index_columns',1),(111,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',1),(112,'2022_12_17_041532_fix_address_in_order_invoice',1),(113,'2022_12_26_070329_create_ec_product_views_table',1),(114,'2023_01_04_033051_fix_product_categories',1),(115,'2023_01_09_050400_add_ec_global_options_translations_table',1),(116,'2023_01_10_093754_add_missing_option_value_id',1),(117,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',1),(118,'2023_01_26_021854_add_ec_customer_used_coupons_table',1),(119,'2023_01_30_024431_add_alt_to_media_table',1),(120,'2023_02_01_062030_add_store_translations',1),(121,'2023_02_08_015900_update_options_column_in_ec_order_product_table',1),(122,'2023_02_13_032133_update_fee_column_mp_customer_revenues_table',1),(123,'2023_02_16_042611_drop_table_password_resets',1),(124,'2023_02_17_023648_fix_store_prefix',1),(125,'2023_02_27_095752_remove_duplicate_reviews',1),(126,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',1),(127,'2023_04_17_062645_add_open_in_new_tab',1),(128,'2023_04_21_082427_create_ec_product_categorizables_table',1),(129,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(130,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(131,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',1),(132,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(133,'2023_05_17_025812_fix_invoice_issue',1),(134,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',1),(135,'2023_05_27_144611_fix_exchange_rate_setting',1),(136,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',1),(137,'2023_06_30_042512_create_ec_order_tax_information_table',1),(138,'2023_07_06_011444_create_slug_translations_table',1),(139,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',1),(140,'2023_07_26_041451_add_more_columns_to_location_table',1),(141,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(142,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',1),(143,'2023_08_11_060908_create_announcements_table',1),(144,'2023_08_15_064505_create_ec_tax_rules_table',1),(145,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(146,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',1),(147,'2023_08_21_090810_make_page_content_nullable',1),(148,'2023_08_22_094114_drop_unique_for_barcode',1),(149,'2023_08_29_074620_make_column_author_id_nullable',1),(150,'2023_08_29_075308_make_column_user_id_nullable',1),(151,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',1),(152,'2023_09_07_094312_add_index_to_product_sku_and_translations',1),(153,'2023_09_14_021936_update_index_for_slugs_table',1),(154,'2023_09_14_022423_add_index_for_language_table',1),(155,'2023_09_19_024955_create_discount_product_categories_table',1),(156,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',1),(157,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(158,'2023_11_07_023805_add_tablet_mobile_image',1),(159,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(160,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(161,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(162,'2023_11_22_154643_add_unique_in_table_ec_products_variations',1),(163,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',1),(164,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',1),(165,'2023_12_06_100448_change_random_hash_for_media',1),(166,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(167,'2023_12_12_105220_drop_translations_table',1),(168,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(169,'2023_12_25_040604_ec_create_review_replies_table',1),(170,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',1),(171,'2024_01_16_070706_fix_translation_tables',1),(172,'2024_01_23_075227_add_proof_file_to_ec_orders_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,8,3,1022.00,0.00,1022.00,0.00,'USD',NULL,'2024-03-04 16:58:47','2024-03-04 16:58:47',0,'add-amount'),(2,1,6,2353.00,0.00,2353.00,0.00,'USD',NULL,'2024-03-03 20:58:47','2024-03-03 20:58:47',0,'add-amount'),(3,2,8,7317.00,0.00,7317.00,0.00,'USD',NULL,'2024-03-02 00:58:48','2024-03-02 00:58:48',0,'add-amount'),(4,1,9,5989.00,0.00,5989.00,2353.00,'USD',NULL,'2024-02-26 12:58:48','2024-02-26 12:58:48',0,'add-amount'),(5,8,11,511.00,0.00,511.00,1022.00,'USD',NULL,'2024-03-01 00:58:49','2024-03-01 00:58:49',0,'add-amount'),(6,5,16,6933.00,0.00,6933.00,0.00,'USD',NULL,'2024-03-02 04:58:49','2024-03-02 04:58:49',0,'add-amount'),(7,1,17,1997.00,0.00,1997.00,8342.00,'USD',NULL,'2024-02-29 12:58:50','2024-02-29 12:58:50',0,'add-amount'),(8,5,18,4054.00,0.00,4054.00,6933.00,'USD',NULL,'2024-02-24 12:58:50','2024-02-24 12:58:50',0,'add-amount'),(9,3,22,1395.00,0.00,1395.00,0.00,'USD',NULL,'2024-02-14 20:58:51','2024-02-14 20:58:51',0,'add-amount'),(10,4,23,898.00,0.00,898.00,0.00,'USD',NULL,'2024-03-03 00:58:51','2024-03-03 00:58:51',0,'add-amount'),(11,8,24,3243.00,0.00,3243.00,1533.00,'USD',NULL,'2024-02-25 16:58:52','2024-02-25 16:58:52',0,'add-amount'),(12,2,25,2439.00,0.00,2439.00,7317.00,'USD',NULL,'2024-02-21 00:58:52','2024-02-21 00:58:52',0,'add-amount'),(13,3,27,4024.00,0.00,4024.00,1395.00,'USD',NULL,'2024-02-27 00:58:53','2024-02-27 00:58:53',0,'add-amount'),(14,7,30,3768.00,0.00,3768.00,0.00,'USD',NULL,'2024-02-10 18:58:54','2024-02-10 18:58:54',0,'add-amount'),(15,7,32,4028.00,0.00,4028.00,3768.00,'USD',NULL,'2024-02-14 18:58:54','2024-02-14 18:58:54',0,'add-amount'),(16,6,33,1926.00,0.00,1926.00,0.00,'USD',NULL,'2024-03-02 04:58:55','2024-03-02 04:58:55',0,'add-amount'),(17,5,34,632.00,0.00,632.00,10987.00,'USD',NULL,'2024-02-19 10:58:55','2024-02-19 10:58:55',0,'add-amount'),(18,8,37,6291.00,0.00,6291.00,4776.00,'USD',NULL,'2024-02-08 16:58:56','2024-02-08 16:58:56',0,'add-amount'),(19,4,38,1796.00,0.00,1796.00,898.00,'USD',NULL,'2024-02-17 18:58:56','2024-02-17 18:58:56',0,'add-amount'),(20,7,46,746.00,0.00,746.00,7796.00,'USD',NULL,'2024-02-22 06:58:57','2024-02-22 06:58:57',0,'add-amount'),(21,7,50,2402.00,0.00,2402.00,8542.00,'USD',NULL,'2024-02-21 06:58:57','2024-02-21 06:58:57',0,'add-amount'),(22,5,53,2176.00,0.00,2176.00,11619.00,'USD',NULL,'2024-01-29 00:58:58','2024-01-29 00:58:58',0,'add-amount'),(23,8,54,1533.00,0.00,1533.00,11067.00,'USD',NULL,'2024-01-19 04:58:58','2024-01-19 04:58:58',0,'add-amount');
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,1,0.00,87.00,10339.00,'USD','','{\"name\":\"Claire Kassulke\",\"number\":\"+12532820849\",\"full_name\":\"Leslie Gottlieb\",\"description\":\"Callie Wilderman\"}',NULL,0,'pending',NULL,'2024-03-05 00:58:59','2024-03-05 00:58:59',NULL),(2,1,0.00,981.00,10252.00,'USD','','{\"name\":\"Claire Kassulke\",\"number\":\"+12532820849\",\"full_name\":\"Leslie Gottlieb\",\"description\":\"Callie Wilderman\"}',NULL,0,'processing',NULL,'2024-03-05 00:58:59','2024-03-05 00:58:59',NULL),(3,1,0.00,1623.00,9271.00,'USD','','{\"name\":\"Claire Kassulke\",\"number\":\"+12532820849\",\"full_name\":\"Leslie Gottlieb\",\"description\":\"Callie Wilderman\"}',NULL,0,'completed',NULL,'2024-03-05 00:59:00','2024-03-05 00:59:00',NULL),(4,2,0.00,1295.00,9756.00,'USD','','{\"name\":\"Cesar Anderson\",\"number\":\"+19713825592\",\"full_name\":\"Prof. Horace Weissnat\",\"description\":\"Prof. Charley McDermott\"}',NULL,0,'pending',NULL,'2024-03-05 00:59:00','2024-03-05 00:59:00',NULL),(5,2,0.00,2349.00,8461.00,'USD','','{\"name\":\"Cesar Anderson\",\"number\":\"+19713825592\",\"full_name\":\"Prof. Horace Weissnat\",\"description\":\"Prof. Charley McDermott\"}',NULL,0,'completed',NULL,'2024-03-05 00:59:01','2024-03-05 00:59:01',NULL),(6,3,0.00,648.00,5419.00,'USD','','{\"name\":\"Zakary Yundt\",\"number\":\"+19527472051\",\"full_name\":\"Wilford Carroll Sr.\",\"description\":\"Jeromy Kihn\"}',NULL,0,'pending',NULL,'2024-03-05 00:59:01','2024-03-05 00:59:01',NULL),(7,3,0.00,784.00,4771.00,'USD','','{\"name\":\"Zakary Yundt\",\"number\":\"+19527472051\",\"full_name\":\"Wilford Carroll Sr.\",\"description\":\"Jeromy Kihn\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:02','2024-03-05 00:59:02',NULL),(8,4,0.00,31.00,2694.00,'USD','','{\"name\":\"Prof. Kendall Cremin\",\"number\":\"+16402612482\",\"full_name\":\"Chasity Pfeffer\",\"description\":\"Vaughn Parker\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:02','2024-03-05 00:59:02',NULL),(9,4,0.00,164.00,2663.00,'USD','','{\"name\":\"Prof. Kendall Cremin\",\"number\":\"+16402612482\",\"full_name\":\"Chasity Pfeffer\",\"description\":\"Vaughn Parker\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:03','2024-03-05 00:59:03',NULL),(10,5,0.00,4347.00,13795.00,'USD','','{\"name\":\"Dr. Joshuah Gorczany Jr.\",\"number\":\"+16808504025\",\"full_name\":\"Ms. Stephanie Mraz\",\"description\":\"Noemi Steuber PhD\"}',NULL,0,'completed',NULL,'2024-03-05 00:59:03','2024-03-05 00:59:03',NULL),(11,5,0.00,1125.00,9448.00,'USD','','{\"name\":\"Dr. Joshuah Gorczany Jr.\",\"number\":\"+16808504025\",\"full_name\":\"Ms. Stephanie Mraz\",\"description\":\"Noemi Steuber PhD\"}',NULL,0,'pending',NULL,'2024-03-05 00:59:04','2024-03-05 00:59:04',NULL),(12,5,0.00,2283.00,8323.00,'USD','','{\"name\":\"Dr. Joshuah Gorczany Jr.\",\"number\":\"+16808504025\",\"full_name\":\"Ms. Stephanie Mraz\",\"description\":\"Noemi Steuber PhD\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:04','2024-03-05 00:59:04',NULL),(13,6,0.00,241.00,1926.00,'USD','','{\"name\":\"Delpha Bayer\",\"number\":\"+14709608949\",\"full_name\":\"Mr. Kim Rodriguez MD\",\"description\":\"Mckenzie Fahey\"}',NULL,0,'pending',NULL,'2024-03-05 00:59:05','2024-03-05 00:59:05',NULL),(14,6,0.00,202.00,1685.00,'USD','','{\"name\":\"Delpha Bayer\",\"number\":\"+14709608949\",\"full_name\":\"Mr. Kim Rodriguez MD\",\"description\":\"Mckenzie Fahey\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:05','2024-03-05 00:59:05',NULL),(15,7,0.00,2582.00,10944.00,'USD','','{\"name\":\"Kenya Keebler\",\"number\":\"+15623312128\",\"full_name\":\"Janie Heidenreich Jr.\",\"description\":\"Mrs. Elyssa Blanda\"}',NULL,0,'pending',NULL,'2024-03-05 00:59:06','2024-03-05 00:59:06',NULL),(16,7,0.00,2364.00,8362.00,'USD','','{\"name\":\"Kenya Keebler\",\"number\":\"+15623312128\",\"full_name\":\"Janie Heidenreich Jr.\",\"description\":\"Mrs. Elyssa Blanda\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:06','2024-03-05 00:59:06',NULL),(17,7,0.00,626.00,5998.00,'USD','','{\"name\":\"Kenya Keebler\",\"number\":\"+15623312128\",\"full_name\":\"Janie Heidenreich Jr.\",\"description\":\"Mrs. Elyssa Blanda\"}',NULL,0,'completed',NULL,'2024-03-05 00:59:07','2024-03-05 00:59:07',NULL),(18,7,0.00,113.00,5372.00,'USD','','{\"name\":\"Kenya Keebler\",\"number\":\"+15623312128\",\"full_name\":\"Janie Heidenreich Jr.\",\"description\":\"Mrs. Elyssa Blanda\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:07','2024-03-05 00:59:07',NULL),(19,8,0.00,2583.00,12600.00,'USD','','{\"name\":\"Elisabeth O\'Reilly PhD\",\"number\":\"+15597776038\",\"full_name\":\"Jazmyne Feest\",\"description\":\"Lilian Becker\"}',NULL,0,'completed',NULL,'2024-03-05 00:59:08','2024-03-05 00:59:08',NULL),(20,8,0.00,547.00,10017.00,'USD','','{\"name\":\"Elisabeth O\'Reilly PhD\",\"number\":\"+15597776038\",\"full_name\":\"Jazmyne Feest\",\"description\":\"Lilian Becker\"}',NULL,0,'processing',NULL,'2024-03-05 00:59:08','2024-03-05 00:59:08',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','dashawn.schinner@example.org','+18632666709','24636 Brooklyn Freeway Apt. 839','SY','Oregon','Kareemville',1,'main/stores/1.png','Tenetur non est temporibus voluptas ipsa. Omnis enim repellat libero minus recusandae officia. Aliquid est quis delectus eius nemo quae minus. Et illum eum corrupti et dolor. Perferendis fugiat ipsum consequatur itaque amet dicta. Dolorem repudiandae animi ut eum. Corporis repellat error similique voluptatibus consectetur nisi ad.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(2,'Global Office','hilbert.jaskolski@example.org','+14094629587','8912 White Stream Apt. 639','AT','Georgia','New Ilene',2,'main/stores/2.png','Dolores illo sit blanditiis occaecati ratione. Corporis ea voluptas adipisci rerum labore nesciunt. Ipsum fuga beatae atque tempora voluptatem ut ullam dolorem. Molestiae quasi voluptatem consequatur ea eos exercitationem quibusdam. Et consequuntur distinctio quia nostrum. Sapiente voluptatum quia quam autem amet magnam et animi.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(3,'Young Shop','freichel@example.com','+18549267814','291 Frankie Mall Suite 019','FJ','Iowa','Presleyborough',3,'main/stores/3.png','Velit est eius quibusdam totam est ullam. Enim et quia magni et. Optio repellendus veniam laboriosam illum placeat est. Corrupti rem natus dolores maxime ullam at. Sit praesentium aut dolorum cumque et est et. Et cupiditate ab perferendis nam doloremque voluptas. Magni repudiandae repellendus quia ea enim. Et deleniti quam consequatur eveniet quia aspernatur.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(4,'Global Store','linda61@example.com','+15202734518','5286 Viviane Lodge Suite 339','AO','Colorado','South Christellefurt',4,'main/stores/4.png','Ut commodi aut excepturi sed enim omnis. Impedit sapiente vel ut placeat. Enim similique rerum enim hic et iusto. Aperiam praesentium qui repudiandae soluta aliquid suscipit harum deserunt. Debitis consequatur tenetur consequatur porro. Cum ut harum optio tempore. Est et id et maiores. Est blanditiis facere voluptas doloremque voluptas. Distinctio dolorem voluptatibus saepe quia non.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(5,'Robert’s Store','jettie.armstrong@example.org','+19037254835','525 Gorczany Flats Apt. 199','BD','Missouri','East Preston',5,'main/stores/5.png','Vel aut quisquam sit exercitationem. Consequuntur maiores delectus et quo. Et autem et voluptatem voluptatem eaque nostrum. Nemo hic qui maiores voluptatum porro qui sunt. Qui magni doloribus dolore quaerat impedit. Aut eos distinctio vero fugiat. Asperiores natus est in. Et est ducimus nesciunt facilis numquam cum consequatur.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(6,'Stouffer','marvin.steve@example.com','+17865877068','5495 Pacocha Ports','BH','Indiana','Jordynland',6,'main/stores/6.png','Est nulla quis distinctio maxime esse itaque. Maxime recusandae et ut eum quisquam qui. Pariatur nulla aut quia voluptate cumque inventore ut eveniet. Provident quas necessitatibus et distinctio qui corrupti id. Omnis saepe magni nisi porro nisi ipsam. Eum dolorem dolore suscipit provident. Sunt sit eius repellat natus.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(7,'StarKist','ora00@example.org','+16622556860','4215 Forrest Circles','MM','Maine','Kassulkeburgh',7,'main/stores/7.png','Incidunt iusto incidunt suscipit architecto eos. Sed cumque distinctio labore sunt. Quis quis perferendis reiciendis repudiandae architecto sed a ipsa. Ratione est et nesciunt mollitia enim. Sunt voluptatem dolorem iste quasi. Repellendus omnis blanditiis modi. Nesciunt voluptatem adipisci nihil eos excepturi.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL),(8,'Old El Paso','kenton35@example.com','+18286428765','356 Erica Street','AM','Utah','East Mozell',8,'main/stores/8.png','Accusamus sit voluptatem voluptatem et. Amet necessitatibus temporibus quia totam ut sit laudantium fuga. Aliquid dignissimos consequuntur iure totam necessitatibus occaecati. Sequi fugiat neque laboriosam voluptates veniam asperiores.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-05 00:58:29','2024-03-05 00:58:29',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores_translations`
--

DROP TABLE IF EXISTS `mp_stores_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores_translations` (
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mp_stores_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`mp_stores_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores_translations`
--

LOCK TABLES `mp_stores_translations` WRITE;
/*!40000 ALTER TABLE `mp_stores_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_stores_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,1,7648.00,0.00,10339.00,'$2y$12$0ZdxJ153tM2gGVDmivQrC.8ZLO.unRQNzpJ1dESdxrBhhX.cwXQFW','{\"name\":\"Claire Kassulke\",\"number\":\"+12532820849\",\"full_name\":\"Leslie Gottlieb\",\"description\":\"Callie Wilderman\"}','2024-03-05 00:58:27','2024-03-05 00:59:00','bank_transfer',NULL),(2,2,6112.00,0.00,9756.00,'$2y$12$lDwZ62H7lJeLmfrjE7xKHOBErTO8l7tkVX1N8PJxYTyvisSGJ6Udu','{\"name\":\"Cesar Anderson\",\"number\":\"+19713825592\",\"full_name\":\"Prof. Horace Weissnat\",\"description\":\"Prof. Charley McDermott\"}','2024-03-05 00:58:27','2024-03-05 00:59:01','bank_transfer',NULL),(3,3,3987.00,0.00,5419.00,'$2y$12$xT1.sumjgMtCJY8rUVyjvOL8sgaCfrB5u9Yp8qqXga.b5UV4cLJe.','{\"name\":\"Zakary Yundt\",\"number\":\"+19527472051\",\"full_name\":\"Wilford Carroll Sr.\",\"description\":\"Jeromy Kihn\"}','2024-03-05 00:58:27','2024-03-05 00:59:02','bank_transfer',NULL),(4,4,2499.00,0.00,2694.00,'$2y$12$fdC2u3013Lf6bbVkM71H0Olv1M5lTQZ1v7qR1eK1ePdqYIEqSI.kS','{\"name\":\"Prof. Kendall Cremin\",\"number\":\"+16402612482\",\"full_name\":\"Chasity Pfeffer\",\"description\":\"Vaughn Parker\"}','2024-03-05 00:58:28','2024-03-05 00:59:03','bank_transfer',NULL),(5,5,6040.00,0.00,13795.00,'$2y$12$T66FIczT9tIEQ57hBMfjauAXgLQGA4DFbfkLtXCNCYh7oc5FYjG.m','{\"name\":\"Dr. Joshuah Gorczany Jr.\",\"number\":\"+16808504025\",\"full_name\":\"Ms. Stephanie Mraz\",\"description\":\"Noemi Steuber PhD\"}','2024-03-05 00:58:28','2024-03-05 00:59:05','bank_transfer',NULL),(6,6,1483.00,0.00,1926.00,'$2y$12$0S4VXQ6efv5vLf50yMtVM.tPNON28mzP3S.3YOqqjh6LbitgSEgSa','{\"name\":\"Delpha Bayer\",\"number\":\"+14709608949\",\"full_name\":\"Mr. Kim Rodriguez MD\",\"description\":\"Mckenzie Fahey\"}','2024-03-05 00:58:28','2024-03-05 00:59:06','bank_transfer',NULL),(7,7,5259.00,0.00,10944.00,'$2y$12$tvIRTezVp6WEzxJzwCiIEu77VEIqWnyOVi5Iv3s7e0keekBiazyyu','{\"name\":\"Kenya Keebler\",\"number\":\"+15623312128\",\"full_name\":\"Janie Heidenreich Jr.\",\"description\":\"Mrs. Elyssa Blanda\"}','2024-03-05 00:58:28','2024-03-05 00:59:08','bank_transfer',NULL),(8,8,9470.00,0.00,12600.00,'$2y$12$.x56ylGsXrJ64c.fcLDu6edCQnlJg1/5o3e6DC0vQcQ5blHtjUAyq','{\"name\":\"Elisabeth O\'Reilly PhD\",\"number\":\"+15597776038\",\"full_name\":\"Jazmyne Feest\",\"description\":\"Lilian Becker\"}','2024-03-05 00:58:29','2024-03-05 00:59:08','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','[simple-slider style=\"4\" key=\"home-slider\" shape_1=\"fashion/sliders/shape-1.png\" shape_2=\"fashion/sliders/shape-2.png\" shape_3=\"fashion/sliders/shape-3.png\"][/simple-slider][site-features style=\"3\" quantity=\"4\" title_1=\"Free Delivery\" description_1=\"Orders from all item\" icon_1=\"ti ti-truck-delivery\" title_2=\"Return & Refund\" description_2=\"Money back guarantee\" icon_2=\"ti ti-currency-dollar\" title_3=\"Member Discount\" description_3=\"Every order over $140.00\" icon_3=\"ti ti-discount-2\" title_4=\"Support 24/7\" description_4=\"Contact us 24 hours a day\" icon_4=\"ti ti-headset\"][/site-features][ads style=\"3\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\" key_3=\"BN3ZCHLIE95I\" key_4=\"QGPRRJ2MPZYA\"][/ads][about image_1=\"main/general/about-1.jpg\" image_2=\"main/general/about-2.jpg\" subtitle=\"Unity Collection\" title=\"Shop our limited Edition Collaborations\" description=\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vel mi quam. Fusce vehicula vitae mauris sit amet tempor. Donec consectetur lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.\" action_label=\"Contact Us\" action_url=\"/contact\"][/about][ecommerce-products style=\"slider-full-width\" title=\"This Week\'s Featured\" subtitle=\"Shop by Category\" by=\"collection\" collection_ids=\"1\" limit=\"5\"][/ecommerce-products][ecommerce-product-groups title=\"Discover our Products\" subtitle=\"Product Collection\" limit=\"8\" tabs=\"all,featured,on-sale,trending,top-rated\"][/ecommerce-product-groups][ecommerce-products style=\"slider\" title=\"Top Sellers In Dress for You\" subtitle=\"Best Seller This Week’s\" by=\"collection\" collection_ids=\"2\" limit=\"5\"][/ecommerce-products][image-slider type=\"custom\" quantity=\"4\" name_1=\"Brandit\" image_1=\"main/brands/1.png\" url_1=\"https://brandit-wear.com\" name_2=\"Vintage\" image_2=\"main/brands/2.png\" url_2=\"https://vintagebrand.com/\" name_3=\"Showtime\" image_3=\"main/brands/3.png\" url_3=\"https://www.showtime.com/\" name_4=\"Classic Design Studio\" image_4=\"main/brands/5.png\" url_4=\"http://www.classicdesignstudios.com/\"][/image-slider][gallery style=\"2\" title=\"Trends on image feed\" subtitle=\"After many months design and development of a modern online retailer\" limit=\"6\"][/gallery]',1,NULL,'full-width',NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(2,'Product Categories','[ads style=\"3\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads]<p>&nbsp;</p>[ecommerce-categories category_ids=\"11,14,17,18,21,22,23,25,38\" style=\"grid\"][/ecommerce-categories]<p>&nbsp;</p><p>&nbsp;</p>',1,NULL,'full-width',NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(3,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(4,'Blog',NULL,1,NULL,'full-width',NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(5,'Contact','[contact-form show_contact_form=&quot;0,1&quot; title=&quot;Sent A Message&quot; quantity=&quot;2&quot; icon_1=&quot;main/contact/icon-1.png&quot; content_1=&quot;contact@shofy.com &lt;br&gt; &lt;strong&gt;+670 413 90 762&lt;/strong&gt;&quot; icon_2=&quot;main/contact/icon-2.png&quot; content_2=&quot;502 New St, Brighton VIC 3186, Australia&quot; show_social_info=&quot;0,1&quot; social_info_label=&quot;Find on social media&quot; social_info_icon=&quot;main/contact/icon-3.png&quot;][/contact-form][google-map]502 New Street, Brighton VIC, Australia[/google-map]',1,NULL,'full-width',NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(6,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(7,'Our Story','<h4>A passion for handcrafted coffee, brewed with love and community.</h4>\n\n<p>\n    We are a small, family-owned coffee roaster dedicated to bringing the finest, ethically sourced beans to your cup. Our story began in a cozy kitchen, fueled by a shared passion for the rich aroma and invigorating taste of freshly brewed coffee. We dreamt of creating a space where people could connect over a warm cup, share stories, and experience the joy of handcrafted coffee.\n</p>\n\n<h4>From Humble Beginnings to Roasting Success:</h4>\n\n<p>\n    Our journey started with a small coffee roaster nestled in our garage. We spent countless hours experimenting with different roasting profiles, meticulously cupping each batch to achieve the perfect balance of flavor and aroma. Driven by a desire to make a difference, we built relationships with sustainable coffee farms around the world, ensuring fair trade practices and the highest quality beans.\n</p>\n\n<h4>Milestones and More to Come:</h4>\n\n<p>\n    Our dedication to quality and community resonated with coffee lovers, and our small business quickly grew. We opened our first cafe, a warm and inviting space where people could gather, savor our freshly roasted coffee, and connect with friends and neighbors. We\'ve continued to expand, now offering a variety of handcrafted coffee beverages, alongside delicious pastries and light bites.\n</p>\n\n<h4>Values at Our Core:</h4>\n\n<p>\n    At the heart of everything we do lies our commitment to ethical sourcing, sustainable practices, and building meaningful connections. We believe in supporting the communities that cultivate our coffee beans, ensuring fair wages and responsible farming methods. Every cup you enjoy contributes to a positive impact, one sip at a time.\n</p>\n\n<h4>Join us on our journey!</h4>\n\n<p>\n    We invite you to explore our world of coffee, from the rich diversity of our bean origins to the unique flavors crafted through meticulous roasting. Visit our cafe, discover your perfect cup, and become part of our ever-growing coffee community. Let\'s connect over a cup, share stories, and celebrate the simple joy of a well-brewed coffee.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(8,'Careers','<h3>Careers: Be Part of Our Brewing Legacy</h3>\n\n<p>\n    At Shofy, we\'re not just brewing coffee, we\'re brewing a legacy. Since our humble beginnings in 2024, we\'ve grown from a small, family-owned roaster to a thriving coffee haven. But our passion for quality, community, and sustainability remains at the core of everything we do.\n</p>\n\n<h4>Why Join Our Team?</h4>\n\n<ul>\n    <li>\n        <p><strong>Become a Coffee Connoisseur</strong>: Immerse yourself in the world of coffee, learning from experienced roasters and baristas about bean origins, roasting techniques, and crafting the perfect cup.</p>\n    </li>\n    <li>\n        <p><strong>Fuel Your Passion</strong>: Contribute to our mission by sourcing ethically, promoting sustainable practices, and fostering positive relationships with coffee-growing communities around the globe.</p>\n    </li>\n    <li>\n        <p><strong>Grow with Us</strong>: We offer comprehensive training programs and opportunities for professional development, helping you refine your skills and advance your career in the coffee industry.</p>\n    </li>\n    <li>\n        <p><strong>Be Part of the Family</strong>: We cultivate a collaborative and supportive work environment where your unique talents and perspectives are valued.</p>\n    </li>\n</ul>\n\n<h4>Current Openings:</h4>\n\n<ul>\n    <li>\n        <p><strong>Coffee Roaster</strong>: Play a vital role in our roasting process, meticulously crafting unique flavor profiles and ensuring the highest quality beans reach our customers.</p>\n    </li>\n    <li>\n        <p><strong>Barista</strong>: Become a coffee ambassador, welcoming guests with a smile, crafting their perfect cup, and sharing your knowledge and passion for coffee.</p>\n    </li>\n    <li>\n        <p><strong>Cafe Manager</strong>: Lead your team in creating a warm and inviting atmosphere, overseeing daily operations, and ensuring exceptional customer service.</p>\n    </li>\n</ul>\n\n<h4>We are always looking for passionate individuals who share our values:</h4>\n\n<ul>\n    <li>\n        <p>A genuine love for coffee and a desire to learn everything there is to know about it.</p>\n    </li>\n    <li>\n        <p>A commitment to ethical sourcing, sustainability, and social responsibility.</p>\n    </li>\n    <li>\n        <p>Excellent communication and interpersonal skills to build rapport with colleagues and customers.</p>\n    </li>\n    <li>\n        <p>A positive attitude, a willingness to learn, and a collaborative spirit.</p>\n    </li>\n</ul>\n\n<p>Ready to join our brewing legacy?</p>\n\n<p>\n    Submit your resume and cover letter, telling us why you\'re a perfect fit for our team. We look forward to meeting passionate individuals who are ready to brew the future with us, one cup at a time.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36'),(9,'Shipping','<section>\n    <h2>Shipping Methods</h2>\n    <p>We offer several shipping methods to choose from:</p>\n    <ul>\n        <li>Standard Shipping - 3 to 5 business days</li>\n        <li>Express Shipping - 1 to 2 business days</li>\n        <li>International Shipping - 7 to 14 business days</li>\n    </ul>\n    <p>Please note that shipping times may vary depending on your location and other factors.</p>\n</section>\n\n<section>\n    <h2>Shipping Costs</h2>\n    <p>Shipping costs are calculated based on the weight of your order and the shipping method selected during checkout.</p>\n    <p>You can view the estimated shipping costs in your shopping cart before completing your purchase.</p>\n</section>\n\n<section>\n    <h2>Tracking Your Order</h2>\n    <p>Once your order has been shipped, you will receive a confirmation email with a tracking number.</p>\n    <p>You can use this tracking number to monitor the status of your delivery on our website or through the shipping carrier\'s website.</p>\n</section>\n\n<section>\n    <h2>Shipping Restrictions</h2>\n    <p>Some items may be subject to shipping restrictions due to size, weight, or destination.</p>\n    <p>If your order contains any restricted items, we will notify you during the checkout process.</p>\n</section>\n',1,NULL,NULL,NULL,'published','2024-03-05 00:58:36','2024-03-05 00:58:36');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'RENBYVLVUW','bank_transfer',NULL,1890.00,1,'pending','confirm',9,NULL,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'WDA4T1MAZK','bank_transfer',NULL,898.00,2,'pending','confirm',9,NULL,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'V1OASD55RP','paypal',NULL,1022.00,3,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'TQD4N2KJJM','cod',NULL,5670.00,4,'pending','confirm',10,NULL,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'5DUSJ8ZBSC','sslcommerz',NULL,4971.00,5,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:37','2024-03-05 00:58:37','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'AA1JHDOKSN','stripe',NULL,2353.00,6,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'LILKM7CHVF','sslcommerz',NULL,373.00,7,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'OEKYTOFF9M','paypal',NULL,7317.00,8,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'RZUHU3ZK1C','stripe',NULL,5989.00,9,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'4QLUY2ZR8U','sslcommerz',NULL,2718.00,10,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:38','2024-03-05 00:58:38','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'NUSX8DKFZF','razorpay',NULL,511.00,11,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'LCI9LCNEDO','paypal',NULL,6267.00,12,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'1OEGGYM4YN','stripe',NULL,3057.00,13,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'LW5I1Y97MP','paypal',NULL,425.00,14,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'DTGIMCC3AR','paypal',NULL,511.00,15,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'YNZ2SA4ABP','paystack',NULL,6933.00,16,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:39','2024-03-05 00:58:39','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'PMBSMSPEXG','sslcommerz',NULL,1997.00,17,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'MNU3RNER9W','paystack',NULL,4054.00,18,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'9DPJBCMNEV','paypal',NULL,7680.00,19,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'OM4CXTKUFX','bank_transfer',NULL,2311.00,20,'pending','confirm',9,NULL,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'4E58HF1HEV','razorpay',NULL,1356.00,21,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'PIX8FHDJXP','paypal',NULL,1395.00,22,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:40','2024-03-05 00:58:40','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'DXNRXFCXXG','sslcommerz',NULL,898.00,23,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'QJVWPYPPMX','razorpay',NULL,3243.00,24,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'V3Z1BI3XI1','sslcommerz',NULL,2439.00,25,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'BMRNXRC42O','sslcommerz',NULL,2447.00,26,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'BXTDO75RER','razorpay',NULL,4024.00,27,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:41','2024-03-05 00:58:41','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'4SMJJQWLUZ','paystack',NULL,1688.00,28,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'WLRMC0WMEK','bank_transfer',NULL,2229.00,29,'pending','confirm',10,NULL,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'LZ4CYVJJQY','paypal',NULL,3768.00,30,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'A7HEYPYYGO','paypal',NULL,2422.00,31,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:42','2024-03-05 00:58:42','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'NTBWZVWCI2','razorpay',NULL,4028.00,32,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'DVIWTSDLTG','stripe',NULL,1926.00,33,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'O51DXXVNWO','razorpay',NULL,632.00,34,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'46T784THPC','sslcommerz',NULL,3780.00,35,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'FGLZPRXRAV','cod',NULL,1256.00,36,'pending','confirm',9,NULL,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'MOKKIWBE8N','stripe',NULL,6291.00,37,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:43','2024-03-05 00:58:43','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'BP06TPSEE2','paypal',NULL,1796.00,38,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'VOOTIR8L6I','paystack',NULL,2105.00,39,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'MCDHL8KVWD','cod',NULL,2718.00,40,'pending','confirm',9,NULL,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'1WSEDLNRI1','bank_transfer',NULL,2089.00,41,'pending','confirm',10,NULL,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'JLVAPAWFKB','paystack',NULL,4815.00,42,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:44','2024-03-05 00:58:44','Botble\\Ecommerce\\Models\\Customer',NULL),(43,'USD',0,'WNFJPQSQUA','sslcommerz',NULL,7317.00,43,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\Ecommerce\\Models\\Customer',NULL),(44,'USD',0,'DFNNVNBX9E','cod',NULL,3768.00,44,'pending','confirm',10,NULL,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\Ecommerce\\Models\\Customer',NULL),(45,'USD',0,'LQ6F8YAQPW','cod',NULL,3738.00,45,'pending','confirm',10,NULL,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\Ecommerce\\Models\\Customer',NULL),(46,'USD',0,'P4QJC6RB4S','razorpay',NULL,746.00,46,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\Ecommerce\\Models\\Customer',NULL),(47,'USD',0,'24EQOR9KTG','cod',NULL,4077.00,47,'pending','confirm',10,NULL,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\Ecommerce\\Models\\Customer',NULL),(48,'USD',0,'KLZRGYEOEQ','bank_transfer',NULL,2038.00,48,'pending','confirm',9,NULL,NULL,'2024-03-05 00:58:45','2024-03-05 00:58:45','Botble\\Ecommerce\\Models\\Customer',NULL),(49,'USD',0,'0FHZA4VMNX','paypal',NULL,1890.00,49,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\Ecommerce\\Models\\Customer',NULL),(50,'USD',0,'QCOOMT8RIL','razorpay',NULL,2402.00,50,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\Ecommerce\\Models\\Customer',NULL),(51,'USD',0,'KE3VVLW7FW','paystack',NULL,2718.00,51,'completed','confirm',9,NULL,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\Ecommerce\\Models\\Customer',NULL),(52,'USD',0,'TNXBXB4KFX','paypal',NULL,1605.00,52,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\Ecommerce\\Models\\Customer',NULL),(53,'USD',0,'1VI65B9QMM','sslcommerz',NULL,2176.00,53,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\Ecommerce\\Models\\Customer',NULL),(54,'USD',0,'S72B7FGGK9','sslcommerz',NULL,1533.00,54,'completed','confirm',10,NULL,NULL,'2024-03-05 00:58:46','2024-03-05 00:58:46','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (6,1),(5,1),(3,2),(2,2),(3,3),(4,3),(1,4),(4,4),(2,5),(3,5),(4,6),(1,6),(6,7),(2,7),(4,8),(5,9),(6,9),(3,10),(5,11),(2,11),(5,12),(3,12),(3,13),(6,13),(5,14),(1,14),(6,15),(2,15),(3,16),(2,17),(4,17),(4,18),(6,18);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (8,1),(2,1),(3,2),(8,2),(7,3),(6,3),(8,4),(2,4),(6,5),(2,5),(6,6),(4,6),(7,6),(2,7),(1,7),(6,8),(7,8),(1,8),(4,9),(1,9),(5,10),(8,10),(6,10),(8,11),(6,11),(1,11),(4,12),(1,13),(2,13),(1,14),(4,14),(2,14),(7,15),(1,15),(8,15),(8,16),(2,16),(1,16),(2,17),(5,17),(8,17),(7,18),(6,18),(8,18);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','Mock Turtle. So she set to work nibbling at the top of his pocket, and pulled out a box of comfits, (luckily the salt water had not attended to this mouse? Everything is so out-of-the-way down here.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-3.jpg',2453,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','Alice. \'Then you should say \"With what porpoise?\"\' \'Don\'t you mean by that?\' said the Cat, and vanished. Alice was so long since she had felt quite unhappy at the Caterpillar\'s making such a thing.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-9.jpg',1523,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(3,'The Top 2020 Handbag Trends to Know','Alice, and she at once took up the little passage: and THEN--she found herself at last turned sulky, and would only say, \'I am older than you, and must know better\'; and this Alice thought this must.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',904,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(4,'How to Match the Color of Your Handbag With an Outfit','King said to herself, \'Why, they\'re only a mouse that had fluttered down from the Queen of Hearts, and I had it written down: but I THINK I can find them.\' As she said to herself, rather sharply; \'I.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-11.jpg',881,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(5,'How to Care for Leather Bags','Alice whispered, \'that it\'s done by everybody minding their own business!\' \'Ah, well! It means much the most interesting, and perhaps after all it might injure the brain; But, now that I\'m perfectly.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-12.jpg',2300,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','Oh, I shouldn\'t want YOURS: I don\'t want YOU with us!\"\' \'They were learning to draw,\' the Dormouse turned out, and, by the Hatter, \'when the Queen said severely \'Who is it directed to?\' said one of.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',1083,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(7,'Essential Qualities of Highly Successful Music','Dormouse; \'VERY ill.\' Alice tried to say a word, but slowly followed her back to the Dormouse, without considering at all this grand procession, came THE KING AND QUEEN OF HEARTS. Alice was.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',2150,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(8,'9 Things I Love About Shaving My Head','Alice, so please your Majesty,\' said Alice a good deal worse off than before, as the White Rabbit: it was too late to wish that! She went in without knocking, and hurried off to other parts of the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-9.jpg',2360,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(9,'Why Teamwork Really Makes The Dream Work','English!\' said the Pigeon. \'I can tell you his history,\' As they walked off together, Alice heard it muttering to himself in an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' And then a row.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-4.jpg',1602,NULL,'2024-03-05 00:58:25','2024-03-05 00:58:25'),(10,'The World Caters to Average People','King very decidedly, and the executioner myself,\' said the Duchess: \'what a clear way you can;--but I must be off, and that makes them sour--and camomile that makes them sour--and camomile that.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',2136,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(11,'The litigants on the screen are not actors','Alice. \'Come on, then,\' said the King, \'and don\'t look at me like that!\' \'I couldn\'t help it,\' said the Rabbit\'s voice along--\'Catch him, you by the English, who wanted leaders, and had just begun.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-9.jpg',1998,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(12,'Hiring the Right Sales Team at the Right Time','And yesterday things went on again:-- \'I didn\'t mean it!\' pleaded poor Alice. \'But you\'re so easily offended!\' \'You\'ll get used up.\' \'But what did the archbishop find?\' The Mouse only shook its head.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-10.jpg',360,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(13,'Fully Embrace the Return of 90s fashion','YOUR adventures.\' \'I could tell you what year it is?\' \'Of course it was,\' said the King. (The jury all looked puzzled.) \'He must have prizes.\' \'But who has won?\' This question the Dodo suddenly.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-1.jpg',299,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(14,'Exploring the English Countryside','Majesty,\' said Two, in a soothing tone: \'don\'t be angry about it. And yet you incessantly stand on your head-- Do you think you might do something better with the tarts, you know--\' \'What did they.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-1.jpg',2439,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(15,'Here’s the First Valentino’s New Makeup Collection','Alice, in a very grave voice, \'until all the rest of my life.\' \'You are old,\' said the King, with an M?\' said Alice. \'Come on, then,\' said the Dormouse: \'not in that case I can remember feeling a.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',1024,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(16,'Follow Your own Design process, whatever gets','Alice in a low, trembling voice. \'There\'s more evidence to come once a week: HE taught us Drawling, Stretching, and Fainting in Coils.\' \'What was THAT like?\' said Alice. \'Then you may stand down,\'.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',879,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(17,'Freelancer Days 2024, What’s new?','Mock Turtle interrupted, \'if you don\'t even know what they\'re like.\' \'I believe so,\' Alice replied eagerly, for she had quite a conversation of it had no pictures or conversations?\' So she was.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-10.jpg',811,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26'),(18,'Quality Foods Requirments For Every Human Body’s','I know?\' said Alice, \'and why it is right?\' \'In my youth,\' Father William replied to his son, \'I feared it might tell her something about the same solemn tone, \'For the Duchess. An invitation from.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-11.jpg',847,NULL,'2024-03-05 00:58:26','2024-03-05 00:58:26');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_logs`
--

DROP TABLE IF EXISTS `request_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_code` int DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_logs`
--

LOCK TABLES `request_logs` WRITE;
/*!40000 ALTER TABLE `request_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.manage.license\":true,\"extensions.index\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.cronjob\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"plugins.captcha\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.settings\":true,\"plugins.ecommerce\":true,\"ecommerce.settings\":true,\"ecommerce.report.index\":true,\"products.index\":true,\"products.create\":true,\"products.edit\":true,\"products.destroy\":true,\"products.duplicate\":true,\"product-categories.index\":true,\"product-categories.create\":true,\"product-categories.edit\":true,\"product-categories.destroy\":true,\"product-tag.index\":true,\"product-tag.create\":true,\"product-tag.edit\":true,\"product-tag.destroy\":true,\"brands.index\":true,\"brands.create\":true,\"brands.edit\":true,\"brands.destroy\":true,\"product-collections.index\":true,\"product-collections.create\":true,\"product-collections.edit\":true,\"product-collections.destroy\":true,\"product-attribute-sets.index\":true,\"product-attribute-sets.create\":true,\"product-attribute-sets.edit\":true,\"product-attribute-sets.destroy\":true,\"product-attributes.index\":true,\"product-attributes.create\":true,\"product-attributes.edit\":true,\"product-attributes.destroy\":true,\"tax.index\":true,\"tax.create\":true,\"tax.edit\":true,\"tax.destroy\":true,\"reviews.index\":true,\"reviews.create\":true,\"reviews.destroy\":true,\"reviews.publish\":true,\"reviews.reply\":true,\"shipping_methods.index\":true,\"ecommerce.shipping-rule-items.index\":true,\"ecommerce.shipping-rule-items.create\":true,\"ecommerce.shipping-rule-items.edit\":true,\"ecommerce.shipping-rule-items.destroy\":true,\"ecommerce.shipping-rule-items.bulk-import\":true,\"ecommerce.shipments.index\":true,\"ecommerce.shipments.create\":true,\"ecommerce.shipments.edit\":true,\"ecommerce.shipments.destroy\":true,\"orders.index\":true,\"orders.create\":true,\"orders.edit\":true,\"orders.destroy\":true,\"discounts.index\":true,\"discounts.create\":true,\"discounts.edit\":true,\"discounts.destroy\":true,\"customers.index\":true,\"customers.create\":true,\"customers.edit\":true,\"customers.destroy\":true,\"flash-sale.index\":true,\"flash-sale.create\":true,\"flash-sale.edit\":true,\"flash-sale.destroy\":true,\"product-label.index\":true,\"product-label.create\":true,\"product-label.edit\":true,\"product-label.destroy\":true,\"ecommerce.import.products.index\":true,\"ecommerce.export.products.index\":true,\"order_returns.index\":true,\"order_returns.edit\":true,\"order_returns.destroy\":true,\"global-option.index\":true,\"global-option.create\":true,\"global-option.edit\":true,\"global-option.destroy\":true,\"ecommerce.invoice.index\":true,\"ecommerce.invoice.edit\":true,\"ecommerce.invoice.destroy\":true,\"ecommerce.invoice-template.index\":true,\"ecommerce.settings.general\":true,\"ecommerce.settings.currencies\":true,\"ecommerce.settings.products\":true,\"ecommerce.settings.product-search\":true,\"ecommerce.settings.digital-products\":true,\"ecommerce.settings.store-locators\":true,\"ecommerce.settings.invoices\":true,\"ecommerce.settings.product-reviews\":true,\"ecommerce.settings.customers\":true,\"ecommerce.settings.shopping\":true,\"ecommerce.settings.taxes\":true,\"ecommerce.settings.shipping\":true,\"ecommerce.settings.tracking\":true,\"ecommerce.settings.standard-and-format\":true,\"ecommerce.settings.checkout\":true,\"ecommerce.settings.return\":true,\"ecommerce.settings.flash-sale\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"location.bulk-import.index\":true,\"location.export.index\":true,\"marketplace.index\":true,\"marketplace.store.index\":true,\"marketplace.store.create\":true,\"marketplace.store.edit\":true,\"marketplace.store.destroy\":true,\"marketplace.store.view\":true,\"marketplace.store.revenue.create\":true,\"marketplace.withdrawal.index\":true,\"marketplace.withdrawal.edit\":true,\"marketplace.withdrawal.destroy\":true,\"marketplace.vendors.index\":true,\"marketplace.unverified-vendors.index\":true,\"marketplace.unverified-vendors.edit\":true,\"marketplace.settings\":true,\"marketplace.reports\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"request-log.index\":true,\"request-log.destroy\":true,\"sale-popup.settings\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true}','Admin users role',1,1,1,'2024-03-05 00:58:21','2024-03-05 00:58:21');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','c170d458fc118ee571d0c9bf901ab90a',NULL,'2024-03-05 00:58:36'),(2,'api_enabled','0',NULL,'2024-03-05 00:58:36'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"ecommerce\",\"faq\",\"gallery\",\"location\",\"marketplace\",\"newsletter\",\"payment\",\"paypal\",\"paypal-payout\",\"paystack\",\"razorpay\",\"request-log\",\"sale-popup\",\"shippo\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2024-03-05 00:58:36'),(6,'theme','shofy-jewelry',NULL,'2024-03-05 00:58:36'),(7,'show_admin_bar','1',NULL,'2024-03-05 00:58:36'),(8,'payment_cod_status','1',NULL,'2024-03-05 00:58:36'),(9,'payment_bank_transfer_status','1',NULL,'2024-03-05 00:58:36'),(10,'admin_favicon','main/general/favicon.png',NULL,'2024-03-05 00:58:36'),(11,'admin_logo','main/general/logo-white.png',NULL,'2024-03-05 00:58:36'),(12,'permalink-botble-blog-models-post','blog',NULL,'2024-03-05 00:58:36'),(13,'permalink-botble-blog-models-category','blog',NULL,'2024-03-05 00:58:36'),(14,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2024-03-05 00:58:36'),(15,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2024-03-05 00:58:36'),(16,'payment_stripe_payment_type','stripe_checkout',NULL,'2024-03-05 00:58:36'),(17,'plugins_ecommerce_customer_new_order_status','0',NULL,'2024-03-05 00:58:36'),(18,'plugins_ecommerce_admin_new_order_status','0',NULL,'2024-03-05 00:58:36'),(19,'ecommerce_is_enabled_support_digital_products','1',NULL,'2024-03-05 00:58:36'),(20,'ecommerce_load_countries_states_cities_from_location_plugin','0',NULL,'2024-03-05 00:58:36'),(21,'language_hide_default','1',NULL,'2024-03-05 00:58:36'),(22,'language_switcher_display','dropdown',NULL,'2024-03-05 00:58:36'),(23,'language_display','all',NULL,'2024-03-05 00:58:36'),(24,'language_hide_languages','[]',NULL,'2024-03-05 00:58:36'),(25,'ecommerce_store_name','Shofy',NULL,'2024-03-05 00:58:36'),(26,'ecommerce_store_phone','1800979769',NULL,'2024-03-05 00:58:36'),(27,'ecommerce_store_address','502 New Street',NULL,'2024-03-05 00:58:36'),(28,'ecommerce_store_state','Brighton VIC',NULL,'2024-03-05 00:58:36'),(29,'ecommerce_store_city','Brighton VIC',NULL,'2024-03-05 00:58:36'),(30,'ecommerce_store_country','AU',NULL,'2024-03-05 00:58:36'),(31,'announcement_max_width',NULL,NULL,'2024-03-05 00:58:36'),(32,'announcement_text_color','#010f1c',NULL,'2024-03-05 00:58:36'),(33,'announcement_background_color','transparent',NULL,'2024-03-05 00:58:36'),(34,'announcement_placement','theme',NULL,'2024-03-05 00:58:36'),(35,'announcement_text_alignment','start',NULL,'2024-03-05 00:58:36'),(36,'announcement_dismissible','0',NULL,'2024-03-05 00:58:36'),(37,'simple_slider_using_assets','0',NULL,'2024-03-05 00:58:36'),(38,'theme-shofy-jewelry-site_name','Shofy',NULL,NULL),(39,'theme-shofy-jewelry-site_title','Shofy - Multipurpose eCommerce Laravel Script',NULL,NULL),(40,'theme-shofy-jewelry-seo_description','Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.s',NULL,NULL),(41,'theme-shofy-jewelry-copyright','© 2024 All Rights Reserved.',NULL,NULL),(42,'theme-shofy-jewelry-primary_font','Jost',NULL,NULL),(43,'theme-shofy-jewelry-primary_color','#BD844C',NULL,NULL),(44,'theme-shofy-jewelry-favicon','main/general/favicon.png',NULL,NULL),(45,'theme-shofy-jewelry-logo','main/general/logo.png',NULL,NULL),(46,'theme-shofy-jewelry-logo_light','main/general/logo-white.png',NULL,NULL),(47,'theme-shofy-jewelry-header_style','4',NULL,NULL),(48,'theme-shofy-jewelry-preloader_icon','main/general/preloader-icon.png',NULL,NULL),(49,'theme-shofy-jewelry-address','502 New Street, Brighton VIC, Australia',NULL,NULL),(50,'theme-shofy-jewelry-hotline','8 800 332 65-66',NULL,NULL),(51,'theme-shofy-jewelry-email','contact@fartmart.co',NULL,NULL),(52,'theme-shofy-jewelry-working_time','Mon - Fri: 07AM - 06PM',NULL,NULL),(53,'theme-shofy-jewelry-homepage_id','1',NULL,NULL),(54,'theme-shofy-jewelry-blog_page_id','4',NULL,NULL),(55,'theme-shofy-jewelry-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(56,'theme-shofy-jewelry-cookie_consent_learn_more_url','cookie-policy',NULL,NULL),(57,'theme-shofy-jewelry-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(58,'theme-shofy-jewelry-number_of_products_per_page','24',NULL,NULL),(59,'theme-shofy-jewelry-number_of_cross_sale_product','6',NULL,NULL),(60,'theme-shofy-jewelry-ecommerce_products_page_layout','left_sidebar',NULL,NULL),(61,'theme-shofy-jewelry-ecommerce_product_item_style','4',NULL,NULL),(62,'theme-shofy-jewelry-logo_in_the_checkout_page','main/general/logo.png',NULL,NULL),(63,'theme-shofy-jewelry-logo_in_invoices','main/general/logo.png',NULL,NULL),(64,'theme-shofy-jewelry-logo_vendor_dashboard','main/general/logo.png',NULL,NULL),(65,'theme-shofy-jewelry-404_page_image','main/general/404.png',NULL,NULL),(66,'theme-shofy-jewelry-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"Youtube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Shine bright','jewelry/sliders/slider-1.png','/products','The original',0,'2024-03-05 00:58:29','2024-03-05 00:58:29'),(2,1,'Creative Design','jewelry/sliders/slider-2.png','/products','The original',1,'2024-03-05 00:58:29','2024-03-05 00:58:29'),(3,1,'Gold Plateted','jewelry/sliders/slider-3.png','/products','The original',2,'2024-03-05 00:58:29','2024-03-05 00:58:29'),(4,1,'Unique shapes','jewelry/sliders/slider-4.png','/products','The original',3,'2024-03-05 00:58:29','2024-03-05 00:58:29');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2024-03-05 00:58:29','2024-03-05 00:58:29');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=234 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'foodpound',1,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:58:21','2024-03-05 00:58:21'),(2,'itea-jsc',2,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:58:21','2024-03-05 00:58:21'),(3,'soda-brand',3,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:58:21','2024-03-05 00:58:21'),(4,'shofy',4,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:58:21','2024-03-05 00:58:21'),(5,'soda-brand',5,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-05 00:58:21','2024-03-05 00:58:21'),(6,'electronic',1,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:58:24','2024-03-05 00:58:24'),(7,'mobile',2,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:58:24','2024-03-05 00:58:24'),(8,'iphone',3,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:58:24','2024-03-05 00:58:24'),(9,'printer',4,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:58:24','2024-03-05 00:58:24'),(10,'office',5,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:58:24','2024-03-05 00:58:24'),(11,'it',6,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-05 00:58:24','2024-03-05 00:58:24'),(12,'crisp-bread-cake',1,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(13,'fashion',2,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(14,'electronic',3,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(15,'commercial',4,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(16,'organic-fruits',5,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(17,'ecological',6,'Botble\\Blog\\Models\\Category','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(18,'general',1,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(19,'design',2,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(20,'fashion',3,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(21,'branding',4,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(22,'modern',5,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(23,'nature',6,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(24,'vintage',7,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(25,'sunglasses',8,'Botble\\Blog\\Models\\Tag','tag','2024-03-05 00:58:25','2024-03-05 00:58:25'),(26,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',1,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(27,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',2,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(28,'the-top-2020-handbag-trends-to-know',3,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(29,'how-to-match-the-color-of-your-handbag-with-an-outfit',4,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(30,'how-to-care-for-leather-bags',5,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(31,'were-crushing-hard-on-summers-10-biggest-bag-trends',6,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(32,'essential-qualities-of-highly-successful-music',7,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(33,'9-things-i-love-about-shaving-my-head',8,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:25','2024-03-05 00:58:25'),(34,'why-teamwork-really-makes-the-dream-work',9,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(35,'the-world-caters-to-average-people',10,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(36,'the-litigants-on-the-screen-are-not-actors',11,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(37,'hiring-the-right-sales-team-at-the-right-time',12,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(38,'fully-embrace-the-return-of-90s-fashion',13,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(39,'exploring-the-english-countryside',14,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(40,'heres-the-first-valentinos-new-makeup-collection',15,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(41,'follow-your-own-design-process-whatever-gets',16,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(42,'freelancer-days-2024-whats-new',17,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(43,'quality-foods-requirments-for-every-human-bodys',18,'Botble\\Blog\\Models\\Post','blog','2024-03-05 00:58:26','2024-03-05 00:58:26'),(44,'gopro',1,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(45,'global-office',2,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(46,'young-shop',3,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(47,'global-store',4,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(48,'roberts-store',5,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(49,'stouffer',6,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(50,'starkist',7,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(51,'old-el-paso',8,'Botble\\Marketplace\\Models\\Store','stores','2024-03-05 00:58:29','2024-03-05 00:58:29'),(52,'discover-skincare',1,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(53,'clothing',2,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(54,'mens-clothing',3,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(55,'t-shirts',4,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(56,'jeans',5,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(57,'suits',6,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(58,'womens-clothing',7,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(59,'dresses',8,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(60,'blouses',9,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(61,'pants',10,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(62,'accessories',11,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(63,'hats',12,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(64,'scarves',13,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(65,'jewelry',14,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(66,'sportswear',15,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(67,'activewear',16,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(68,'running-shoes',17,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-05 00:58:29','2024-03-05 00:58:29'),(69,'vintage-denim-jacket',1,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(70,'floral-maxi-dress',2,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(71,'leather-ankle-boots',3,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(72,'knit-turtleneck-sweater-digital',4,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:59:09'),(73,'classic-aviator-sunglasses',5,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(74,'tailored-wool-blazer',6,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(75,'bohemian-fringe-handbag',7,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(76,'silk-scarf-with-geometric-print-digital',8,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:59:09'),(77,'high-waisted-wide-leg-trousers',9,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(78,'embroidered-boho-blouse',10,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(79,'statement-chunky-necklace',11,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(80,'chic-fedora-hat-digital',12,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:59:09'),(81,'strappy-block-heel-sandals',13,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(82,'velvet-evening-gown',14,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(83,'quilted-crossbody-bag',15,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(84,'distressed-skinny-jeans-digital',16,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:59:09'),(85,'lace-up-combat-boots',17,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(86,'cotton-striped-t-shirt-dress',18,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(87,'printed-palazzo-pants',19,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(88,'structured-satchel-bag-digital',20,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:59:09'),(89,'off-shoulder-ruffle-top',21,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(90,'suede-pointed-toe-pumps',22,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(91,'cropped-cable-knit-sweater',23,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(92,'athleisure-jogger-pants-digital',24,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:59:09'),(93,'leopard-print-midi-skirt',25,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(94,'retro-cat-eye-sunglasses',26,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(95,'faux-fur-trimmed-coat',27,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(96,'boho-fringed-kimono-digital',28,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:59:09'),(97,'ruffled-wrap-dress',29,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(98,'beaded-evening-clutch',30,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:30','2024-03-05 00:58:30'),(99,'wide-brim-floppy-hat',31,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(100,'denim-overall-jumpsuit-digital',32,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:59:09'),(101,'embellished-ballet-flats',33,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(102,'pleated-midi-skirt',34,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(103,'velour-tracksuit-set',35,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(104,'geometric-patterned-cardigan-digital',36,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:59:09'),(105,'buckle-detail-ankle-booties',37,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(106,'embroidered-bomber-jacket',38,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(107,'cowl-neck-knit-poncho',39,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(108,'chunky-knit-infinity-scarf-digital',40,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:59:09'),(109,'retro-high-top-sneakers',41,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(110,'faux-leather-leggings',42,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(111,'metallic-pleated-maxi-skirt',43,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:58:31','2024-03-05 00:58:31'),(112,'radiant-reflections',1,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:58:35','2024-03-05 00:58:35'),(113,'glamour-grove',2,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:58:35','2024-03-05 00:58:35'),(114,'serene-styles-showcase',3,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:58:35','2024-03-05 00:58:35'),(115,'allure-alcove',4,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:58:35','2024-03-05 00:58:35'),(116,'glamour-galleria',5,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:58:35','2024-03-05 00:58:35'),(117,'beauty-boulevard',6,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-05 00:58:35','2024-03-05 00:58:35'),(118,'home',1,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(119,'product-categories',2,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(120,'coupons',3,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(121,'blog',4,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(122,'contact',5,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(123,'cookie-policy',6,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(124,'our-story',7,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(125,'careers',8,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(126,'shipping',9,'Botble\\Page\\Models\\Page','','2024-03-05 00:58:36','2024-03-05 00:58:36'),(127,'vintage-denim-jacket',44,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(128,'vintage-denim-jacket',45,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(129,'vintage-denim-jacket',46,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(130,'floral-maxi-dress',47,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(131,'floral-maxi-dress',48,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(132,'leather-ankle-boots',49,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(133,'leather-ankle-boots',50,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(134,'leather-ankle-boots',51,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(135,'knit-turtleneck-sweater-digital',52,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(136,'knit-turtleneck-sweater-digital',53,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(137,'knit-turtleneck-sweater-digital',54,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(138,'knit-turtleneck-sweater-digital',55,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(139,'classic-aviator-sunglasses',56,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(140,'classic-aviator-sunglasses',57,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(141,'tailored-wool-blazer',58,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(142,'tailored-wool-blazer',59,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(143,'tailored-wool-blazer',60,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(144,'bohemian-fringe-handbag',61,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(145,'bohemian-fringe-handbag',62,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(146,'bohemian-fringe-handbag',63,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(147,'silk-scarf-with-geometric-print-digital',64,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(148,'silk-scarf-with-geometric-print-digital',65,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(149,'silk-scarf-with-geometric-print-digital',66,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(150,'high-waisted-wide-leg-trousers',67,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(151,'embroidered-boho-blouse',68,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(152,'embroidered-boho-blouse',69,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(153,'statement-chunky-necklace',70,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(154,'statement-chunky-necklace',71,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(155,'chic-fedora-hat-digital',72,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(156,'strappy-block-heel-sandals',73,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(157,'strappy-block-heel-sandals',74,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(158,'strappy-block-heel-sandals',75,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(159,'velvet-evening-gown',76,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(160,'velvet-evening-gown',77,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(161,'velvet-evening-gown',78,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(162,'quilted-crossbody-bag',79,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(163,'distressed-skinny-jeans-digital',80,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(164,'distressed-skinny-jeans-digital',81,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(165,'distressed-skinny-jeans-digital',82,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(166,'distressed-skinny-jeans-digital',83,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(167,'lace-up-combat-boots',84,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(168,'lace-up-combat-boots',85,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(169,'cotton-striped-t-shirt-dress',86,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(170,'cotton-striped-t-shirt-dress',87,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(171,'cotton-striped-t-shirt-dress',88,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(172,'printed-palazzo-pants',89,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(173,'printed-palazzo-pants',90,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(174,'printed-palazzo-pants',91,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(175,'structured-satchel-bag-digital',92,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(176,'structured-satchel-bag-digital',93,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(177,'off-shoulder-ruffle-top',94,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(178,'off-shoulder-ruffle-top',95,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(179,'off-shoulder-ruffle-top',96,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(180,'suede-pointed-toe-pumps',97,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(181,'suede-pointed-toe-pumps',98,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(182,'suede-pointed-toe-pumps',99,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(183,'cropped-cable-knit-sweater',100,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(184,'athleisure-jogger-pants-digital',101,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(185,'athleisure-jogger-pants-digital',102,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(186,'leopard-print-midi-skirt',103,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(187,'leopard-print-midi-skirt',104,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(188,'leopard-print-midi-skirt',105,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(189,'leopard-print-midi-skirt',106,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(190,'retro-cat-eye-sunglasses',107,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(191,'faux-fur-trimmed-coat',108,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(192,'faux-fur-trimmed-coat',109,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(193,'boho-fringed-kimono-digital',110,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(194,'boho-fringed-kimono-digital',111,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(195,'boho-fringed-kimono-digital',112,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(196,'ruffled-wrap-dress',113,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(197,'beaded-evening-clutch',114,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(198,'beaded-evening-clutch',115,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(199,'beaded-evening-clutch',116,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(200,'wide-brim-floppy-hat',117,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(201,'wide-brim-floppy-hat',118,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(202,'denim-overall-jumpsuit-digital',119,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(203,'denim-overall-jumpsuit-digital',120,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(204,'denim-overall-jumpsuit-digital',121,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(205,'embellished-ballet-flats',122,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(206,'embellished-ballet-flats',123,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(207,'pleated-midi-skirt',124,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(208,'pleated-midi-skirt',125,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(209,'velour-tracksuit-set',126,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(210,'velour-tracksuit-set',127,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(211,'geometric-patterned-cardigan-digital',128,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(212,'geometric-patterned-cardigan-digital',129,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(213,'geometric-patterned-cardigan-digital',130,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(214,'buckle-detail-ankle-booties',131,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(215,'buckle-detail-ankle-booties',132,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(216,'buckle-detail-ankle-booties',133,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(217,'buckle-detail-ankle-booties',134,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(218,'embroidered-bomber-jacket',135,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(219,'embroidered-bomber-jacket',136,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(220,'embroidered-bomber-jacket',137,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(221,'cowl-neck-knit-poncho',138,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(222,'cowl-neck-knit-poncho',139,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(223,'cowl-neck-knit-poncho',140,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(224,'cowl-neck-knit-poncho',141,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(225,'chunky-knit-infinity-scarf-digital',142,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(226,'chunky-knit-infinity-scarf-digital',143,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(227,'chunky-knit-infinity-scarf-digital',144,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(228,'retro-high-top-sneakers',145,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(229,'faux-leather-leggings',146,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(230,'faux-leather-leggings',147,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(231,'faux-leather-leggings',148,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(232,'metallic-pleated-maxi-skirt',149,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09'),(233,'metallic-pleated-maxi-skirt',150,'Botble\\Ecommerce\\Models\\Product','products','2024-03-05 00:59:09','2024-03-05 00:59:09');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'General',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25'),(2,'Design',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25'),(3,'Fashion',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25'),(4,'Branding',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25'),(5,'Modern',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25'),(6,'Nature',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25'),(7,'Vintage',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25'),(8,'Sunglasses',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-05 00:58:25','2024-03-05 00:58:25');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'James Dopli','Thanks for all your efforts and teamwork over the last several months!  Thank you so much','main/users/9.jpg','Developer','published','2024-03-05 00:58:29','2024-03-05 00:58:29'),(2,'Theodore Handle','How you use the city or town name is up to you. All results may be freely used in any work.','main/users/5.jpg','CO Founder','published','2024-03-05 00:58:29','2024-03-05 00:58:29'),(3,'Shahnewaz Sakil','Very happy with our choice to take our daughter to Brave care. The entire team was great! Thank you!','main/users/6.jpg','UI/UX Designer','published','2024-03-05 00:58:29','2024-03-05 00:58:29'),(4,'Albert Flores','Wedding day savior! 5 stars. Their bridal collection is a game-changer. Made me feel like a star.','main/users/2.jpg','Bank of America','published','2024-03-05 00:58:29','2024-03-05 00:58:29');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'qbreitenberg@corwin.com',NULL,'$2y$12$fRsVXtRVMxde5j52vy8f9uC.5klJhFtxfN5Kfb.pgOBRvZ5FX.0n.',NULL,'2024-03-05 00:58:21','2024-03-05 00:58:21','Therese','Bashirian','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInfoWidget','footer_primary_sidebar','shofy-jewelry',0,'{\"id\":\"SiteInfoWidget\",\"logo\":\"main\\/general\\/logo.png\",\"about\":\"Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.\",\"show_social_links\":true}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(2,'CustomMenuWidget','footer_primary_sidebar','shofy-jewelry',1,'{\"id\":\"CustomMenuWidget\",\"name\":\"My Account\",\"menu_id\":\"my-account\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(3,'CustomMenuWidget','footer_primary_sidebar','shofy-jewelry',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"Information\",\"menu_id\":\"information\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(4,'SiteContactWidget','footer_primary_sidebar','shofy-jewelry',4,'{\"id\":\"SiteContactWidget\",\"name\":\"Talk To Us\",\"phone_label\":\"Got Questions? Call us\",\"phone\":\"+670 413 90 762\",\"email\":\"shofy@support.com\",\"address\":\"79 Sleepy Hollow St. Jamaica, New York 1432\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(5,'NewsletterWidget','footer_top_sidebar','shofy-jewelry',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe our Newsletter\",\"subtitle\":\"Sale 20% off all store\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(6,'SiteCopyrightWidget','footer_bottom_sidebar','shofy-jewelry',1,'{\"id\":\"SiteCopyrightWidget\",\"content\":\"\\u00a9 %y% All rights Reserved.\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(7,'SiteAcceptedPaymentsWidget','footer_bottom_sidebar','shofy-jewelry',2,'{\"id\":\"SiteAcceptedPaymentsWidget\",\"name\":\"Accepted Payments\",\"image\":\"main\\/general\\/footer-pay.png\",\"url\":\"#\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(8,'BlogSearchWidget','blog_sidebar','shofy-jewelry',1,'{\"id\":\"BlogSearchWidget\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(9,'BlogAboutMeWidget','blog_sidebar','shofy-jewelry',2,'{\"id\":\"BlogAboutMeWidget\",\"name\":\"About Me\",\"author_url\":\"\\/blog\",\"author_avatar\":\"main\\/users\\/4.jpg\",\"author_name\":\"Ravi O\'Leigh\",\"author_role\":\"Photographer & Blogger\",\"author_description\":\"Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient\",\"author_signature\":\"main\\/general\\/signature.png\"}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(10,'BlogPostsWidget','blog_sidebar','shofy-jewelry',3,'{\"id\":\"BlogPostsWidget\",\"name\":\"Latest Posts\",\"limit\":3}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(11,'BlogCategoriesWidget','blog_sidebar','shofy-jewelry',4,'{\"id\":\"BlogCategoriesWidget\",\"name\":\"Categories\",\"number_display\":6}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(12,'BlogTagsWidget','blog_sidebar','shofy-jewelry',5,'{\"id\":\"BlogTagsWidget\",\"name\":\"Popular Tags\",\"number_display\":6}','2024-03-05 00:58:36','2024-03-05 00:58:36'),(13,'ProductDetailInfoWidget','product_details_sidebar','shofy-jewelry',1,'{\"id\":\"ProductDetailInfoWidget\",\"messages\":[[{\"key\":\"message\",\"value\":\"30 days easy returns\"}],[{\"key\":\"message\",\"value\":\"Order yours before 2.30pm for same day dispatch\"}]],\"description\":\"Guaranteed safe & secure checkout\",\"image\":\"main\\/general\\/footer-pay.png\"}','2024-03-05 00:58:36','2024-03-05 00:58:36');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-05 14:59:10
