-- MySQL dump 10.13  Distrib 8.3.0, for macos14.2 (arm64)
--
-- Host: 127.0.0.1    Database: shofy
-- ------------------------------------------------------
-- Server version	8.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'o51Du0CiZLmHGvgDC53J9H0GbmnwGlNL',1,'2024-03-15 03:04:20','2024-03-15 03:04:20','2024-03-15 03:04:20');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'Ads 1','2029-03-15 00:00:00','not_set','UROL9F9ZZVAA','jewelry/banners/1.jpg','/products',0,1,'published','2024-03-15 03:04:34','2024-03-15 03:04:34',1,NULL,NULL),(2,'Ads 2','2029-03-15 00:00:00','not_set','B30VDBKO7SBF','jewelry/banners/2.jpg','/products',0,2,'published','2024-03-15 03:04:34','2024-03-15 03:04:34',1,NULL,NULL),(3,'Ads 3','2029-03-15 00:00:00','not_set','BN3ZCHLIE95I','jewelry/banners/3.jpg','/products',0,3,'published','2024-03-15 03:04:34','2024-03-15 03:04:34',1,NULL,NULL),(4,'Ads 4','2029-03-15 00:00:00','not_set','QGPRRJ2MPZYA','jewelry/banners/4.jpg','/products',0,4,'published','2024-03-15 03:04:34','2024-03-15 03:04:34',1,NULL,NULL);
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Enjoy free shipping on all orders over $99! Shop now and save on delivery costs.',0,NULL,NULL,0,1,'2024-03-15 10:04:28',NULL,1,'2024-03-15 03:04:28','2024-03-15 03:04:28'),(2,'Announcement 2','Need assistance? Our customer support is available 24/7 to help you with any questions or concerns.',0,NULL,NULL,0,1,'2024-03-15 10:04:28',NULL,1,'2024-03-15 03:04:28','2024-03-15 03:04:28'),(3,'Announcement 3','Shop with confidence! We offer a hassle-free 30 days return service for your peace of mind.',0,NULL,NULL,0,1,'2024-03-15 10:04:28',NULL,1,'2024-03-15 03:04:28','2024-03-15 03:04:28');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Crisp Bread &amp; Cake',0,'Enim molestias molestiae non natus. Sit ea quasi ipsam voluptatem omnis aspernatur commodi aut. Similique est vitae est.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(2,'Fashion',0,'Qui qui consequuntur veritatis fugiat. Quia id laborum est. Maiores eos molestiae possimus ut at iste recusandae.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(3,'Electronic',0,'Omnis ex ex dolor est. Saepe illum vel minus. A magnam explicabo voluptatibus at laborum saepe nam.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(4,'Commercial',0,'Voluptatibus voluptas vel provident et. Magnam eum dolorem libero dolor quo id quam iste. Ab sed labore sed. Perspiciatis autem ducimus est atque odit maxime eaque.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(5,'Organic Fruits',0,'Ab a sit mollitia ullam quis. Voluptatibus sed quod reiciendis. Deserunt est beatae ut culpa. Est corrupti velit quo officiis ab quo.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(6,'Ecological',0,'Ut est reprehenderit rerum eum rem voluptates. Pariatur et molestias accusantium qui amet. Hic a consequuntur assumenda et dolor fuga distinctio aspernatur.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2024-03-15 03:04:24','2024-03-15 03:04:24');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Prof. Delores Mayert Sr.','norbert.bode@example.com','+1 (660) 506-0129','36602 Torphy Isle Suite 827\nSouth Moriahbury, NY 06950','Vitae eaque quas cum autem explicabo quo.','Quas aut magni illo nesciunt sed. Ea et itaque ea et est omnis velit. Aut repellat et perspiciatis sed necessitatibus ut id et. Voluptatem enim impedit cupiditate. Et ipsum dignissimos consequatur aut aut. Reiciendis consequatur quaerat eos consequuntur. Blanditiis unde voluptas et quasi. Nihil vitae in maxime aut fugiat voluptas libero. Exercitationem qui voluptatem eum libero error debitis. Cupiditate non eligendi provident fuga ut nulla maiores.','read','2024-03-15 03:04:23','2024-03-15 03:04:23'),(2,'Omari Boehm PhD','ohessel@example.net','(910) 542-3291','106 Watsica Mall\nPort Yesenia, OK 43331-4711','Mollitia commodi velit aut facilis.','Ut eum corporis tenetur qui non non incidunt. Dicta consequatur non sit quasi iste tempora ut. Qui voluptatem non laboriosam repellat quia necessitatibus iste. Quisquam repudiandae tempora sed est officia ut corporis. Quia ipsa eum officia sequi architecto molestiae. Temporibus illo porro iusto. Officiis et facilis beatae quas eos aut. Quasi modi perferendis atque quisquam. A vel non consequatur dolorum delectus. Debitis esse autem perspiciatis.','unread','2024-03-15 03:04:23','2024-03-15 03:04:23'),(3,'Mrs. Elza Kassulke II','jlind@example.com','1-810-291-3270','553 Tillman Plain Apt. 076\nNew Ashlyville, MD 84578','Quia quasi non est beatae ut odio consequatur.','Velit at eaque quidem quia quibusdam. Dicta doloribus omnis modi numquam officiis eligendi ea. Facere natus pariatur mollitia voluptas harum nulla adipisci magni. Et natus incidunt natus asperiores. Autem voluptatem commodi exercitationem praesentium tenetur. Maxime aperiam repellat voluptates. Molestiae molestias autem alias ut. Corrupti dolorum et eligendi recusandae possimus. Itaque explicabo voluptas dolorem et.','read','2024-03-15 03:04:23','2024-03-15 03:04:23'),(4,'Edmond Kassulke','ogreen@example.com','640.987.2603','133 Abshire Mountains\nConnellyton, IA 37621-3411','Ad est tempora aut occaecati qui.','Laborum iusto ipsa est suscipit ut vel doloribus. Sapiente sunt reprehenderit voluptates quae illo quia. Omnis dolores quod sit est quasi doloremque consectetur. Consectetur atque excepturi quia culpa aut. Sed quo sed ducimus quia. Dolor autem ut iusto error totam provident. Odio reiciendis error quibusdam suscipit accusamus. Nisi officiis ratione quod explicabo aliquid minus sint. Sed odio unde in porro consequuntur accusamus.','unread','2024-03-15 03:04:23','2024-03-15 03:04:23'),(5,'Prof. Ole Gibson II','reilly.pearl@example.net','863-390-0839','44850 Spencer Viaduct\nHagenesburgh, MA 69210-3744','Ipsam deleniti id sit voluptatum dolorum tenetur.','Dignissimos et consectetur et aut nam iure. Ut autem ratione excepturi aut accusamus animi autem. Rerum quis ea facilis dolores laboriosam dicta. Voluptas qui modi vel nihil officiis fuga. In placeat vitae fuga earum aut aperiam et. Qui autem saepe quia. Exercitationem voluptatem aut id inventore vel sint. Dolores in dolorum dolorem cupiditate ipsa voluptatem eos. Possimus minus vel illum illum non vel ex. Ea est consequuntur est. Neque consequuntur est ut suscipit.','read','2024-03-15 03:04:23','2024-03-15 03:04:23'),(6,'Rosetta Hyatt','louvenia.simonis@example.org','(239) 610-4434','9738 Nona Overpass\nMorarbury, LA 28065','Ea inventore velit tempore.','Quo velit consequatur velit in. In quasi maxime et deserunt expedita qui. Rem eos facilis corrupti velit. Quas quia qui placeat perspiciatis iste. Perferendis vero maiores eos et et perferendis. Est qui est enim laboriosam voluptatibus sequi. Voluptatem voluptatem maxime occaecati.','read','2024-03-15 03:04:23','2024-03-15 03:04:23'),(7,'Miss Claudia Ledner II','dillan09@example.com','253.347.4101','570 Nedra Dale\nWest Cadenborough, GA 77782-6825','Minus atque dolore voluptate ratione et.','Delectus quisquam est ipsa et consequatur itaque omnis. Vel fugit sed voluptatem sapiente. Eaque beatae asperiores dolorem dolore incidunt dolor soluta dolorem. Possimus inventore deleniti assumenda qui. Voluptas eos quia dolor delectus officiis repudiandae. Modi fugit provident quaerat pariatur. Unde sed voluptatem sed omnis sint.','unread','2024-03-15 03:04:23','2024-03-15 03:04:23'),(8,'Mary Walsh','pfay@example.org','+1.209.744.0500','89393 Mante Brooks Apt. 118\nGloverport, TN 51946-3487','Doloribus doloribus est incidunt.','Dolor modi porro provident fuga voluptate. Nesciunt nihil perspiciatis veritatis dolorum dignissimos nesciunt. Exercitationem eum et ut nihil. Perspiciatis esse ex nihil. Ut eum consequatur cupiditate quia qui. Ut adipisci quia quod quasi neque. Vel consectetur ullam voluptas magni voluptatem quasi debitis. Aut unde est dolor. Est fuga autem tempore sint et aut deleniti sed. Quo sed aliquid est repellat. Illo ut et aut quia.','read','2024-03-15 03:04:23','2024-03-15 03:04:23'),(9,'Natasha Stokes','tristin.jast@example.net','(754) 810-4880','290 Frida Oval Suite 530\nSouth Yvonne, NY 62269-8209','Eligendi aperiam sed debitis ut.','Reprehenderit soluta beatae excepturi itaque unde quia doloremque voluptas. Quia consequatur hic cum occaecati. Itaque modi exercitationem blanditiis ducimus. Molestiae dignissimos id delectus magni modi enim. Pariatur beatae est voluptas a. Vel maxime et soluta soluta. Impedit ex eveniet est aut vero explicabo quae necessitatibus.','unread','2024-03-15 03:04:23','2024-03-15 03:04:23'),(10,'Evalyn Kiehn','lolita.harvey@example.net','913-455-9829','4449 Goldner Trail Apt. 168\nEast Katrinefurt, CA 19603-1580','Quo illo occaecati sit quisquam accusantium.','Et cum cupiditate optio quasi deleniti recusandae. Non molestiae aliquam eaque velit nemo sit voluptas. Vero fugiat molestiae ea perspiciatis fugiat minus dolor. Qui tempore earum voluptatum. Impedit deserunt sapiente odit architecto id unde sequi voluptas. In minus et perferendis numquam sed cupiditate. Libero excepturi assumenda numquam tempore veniam aliquam tenetur. Fugiat placeat eius atque assumenda voluptatibus et doloremque.','unread','2024-03-15 03:04:23','2024-03-15 03:04:23');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'FoodPound','New Snacks Release',NULL,NULL,'published',0,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(2,'iTea JSC','Happy Tea 100% Organic. From $29.9',NULL,NULL,'published',1,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(3,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',2,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(4,'Shofy','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',3,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(5,'Soda Brand','Fresh Meat Sausage. BUY 2 GET 1!',NULL,NULL,'published',4,1,'2024-03-15 03:04:20','2024-03-15 03:04:20');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(2,'EUR','€',0,2,1,0,0.84,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(3,'VND','₫',0,0,2,0,23203,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(4,'NGN','₦',1,2,2,0,895.52,'2024-03-15 03:04:20','2024-03-15 03:04:20');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Anna Gleason','customer@botble.com','+16816695653','AW','Pennsylvania','Erynberg','33185 Edwardo Parks Apt. 557',1,1,'2024-03-15 03:04:21','2024-03-15 03:04:21','29198-7604'),(2,'Anna Gleason','customer@botble.com','+19496889263','PT','Pennsylvania','Port Franco','71899 Vivian Spring Apt. 852',1,0,'2024-03-15 03:04:21','2024-03-15 03:04:21','57540-5938'),(3,'Eugenia Roob','vendor@botble.com','+19157737684','SS','Texas','New Nicolasside','29181 Grant Route',2,1,'2024-03-15 03:04:21','2024-03-15 03:04:21','61296-0637'),(4,'Eugenia Roob','vendor@botble.com','+13315419419','FR','Iowa','Port Breannafurt','582 Wiza Track',2,0,'2024-03-15 03:04:21','2024-03-15 03:04:21','49002'),(5,'Frederic Hettinger','snitzsche@example.org','+18143708226','BS','Iowa','Botsfordport','729 Destany Ranch Apt. 855',3,1,'2024-03-15 03:04:21','2024-03-15 03:04:21','37293'),(6,'Dr. Norberto Marquardt','juliana33@example.com','+18319869786','HU','South Dakota','North Mercedes','8767 Emmerich Street',4,1,'2024-03-15 03:04:21','2024-03-15 03:04:21','91018'),(7,'Ms. Emilia Lesch Jr.','ethyl.little@example.net','+12629647578','AU','Utah','West Berniceburgh','221 Amelia Lakes Apt. 571',5,1,'2024-03-15 03:04:22','2024-03-15 03:04:22','57753'),(8,'Dameon Schuster Jr.','langosh.vincenza@example.net','+18208152760','JP','Florida','Lake Jonathonfort','562 Ryan Inlet Apt. 562',6,1,'2024-03-15 03:04:22','2024-03-15 03:04:22','63999-7661'),(9,'Asia Ondricka DDS','tpadberg@example.net','+15414070898','TD','Pennsylvania','Rashawnfort','22143 Williamson Stream',7,1,'2024-03-15 03:04:22','2024-03-15 03:04:22','68296'),(10,'Cydney Kohler','pmorar@example.com','+18082949530','LB','Idaho','Eusebioville','99085 Tremayne Rue Suite 386',8,1,'2024-03-15 03:04:22','2024-03-15 03:04:22','62290'),(11,'Marty Braun IV','retta51@example.net','+13012980240','TN','Georgia','Arielton','63064 Blanda Squares',9,1,'2024-03-15 03:04:23','2024-03-15 03:04:23','47919-8120'),(12,'Asha Conroy','hettinger.ofelia@example.org','+18565326084','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',10,1,'2024-03-15 03:04:23','2024-03-15 03:04:23','58152-9807');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Anna Gleason','customer@botble.com','$2y$12$pnfoPzyoq.fSnbuU7YZUr.fNjOh/Ea6wyZ6ExbNK7CZKZ49ugVYsS','main/customers/3.jpg','1985-02-22','+14426178192',NULL,'2024-03-15 03:04:21','2024-03-15 03:04:26','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(2,'Eugenia Roob','vendor@botble.com','$2y$12$7DFxO2KED03zqAZ5IJ5TNOFUGpozNQRFXjk7dswNnpHj2hAI4pxfO','main/customers/9.jpg','1978-02-19','+15175256874',NULL,'2024-03-15 03:04:21','2024-03-15 03:04:26','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(3,'Frederic Hettinger','snitzsche@example.org','$2y$12$uIAF/5aTazSQ38Gwmmhibub8xNuP6wdCnhYwbA/EgCfHCDZpgzaA6','main/customers/1.jpg','1980-03-06','+18187806009',NULL,'2024-03-15 03:04:21','2024-03-15 03:04:26','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(4,'Dr. Norberto Marquardt','juliana33@example.com','$2y$12$X3wXaBYPOcDX/iWCx8GkOuj7gox88o3T7gP8DyH0Gf6opGKmFW7re','main/customers/2.jpg','2001-02-13','+19852574637',NULL,'2024-03-15 03:04:21','2024-03-15 03:04:27','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(5,'Ms. Emilia Lesch Jr.','ethyl.little@example.net','$2y$12$OBD7JITprXAZ8rCQJv1nt.b9Qz4XGSm8MImRXjbBG1KuStNdCIHwy','main/customers/3.jpg','1987-02-13','+14235490716',NULL,'2024-03-15 03:04:22','2024-03-15 03:04:27','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(6,'Dameon Schuster Jr.','langosh.vincenza@example.net','$2y$12$YSnFbHE5C/xmO2BR6Oh9.ed/u1wJhrMtChRM/W50rS4C55jTINmJq','main/customers/4.jpg','1979-03-07','+18122179487',NULL,'2024-03-15 03:04:22','2024-03-15 03:04:27','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(7,'Asia Ondricka DDS','tpadberg@example.net','$2y$12$A8rVNfT0Tk3GL1wB80gfROn4MwS25OJO2cUQKb2jfHrKaAkSndfuy','main/customers/5.jpg','1976-03-11','+12544547460',NULL,'2024-03-15 03:04:22','2024-03-15 03:04:27','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(8,'Cydney Kohler','pmorar@example.com','$2y$12$4VCEwXqB0mXLBFo2Kah6E.Kqp1noHPXrdMRoCMDsNrV5aUPF70MBC','main/customers/6.jpg','1983-02-20','+19253291269',NULL,'2024-03-15 03:04:22','2024-03-15 03:04:28','2024-03-15 10:04:20',NULL,1,'2024-03-15 10:04:26','activated',NULL),(9,'Marty Braun IV','retta51@example.net','$2y$12$pcSFMbt0HmY96JcnOjd97.7cnUZyWt6iNQjPHnjxi3i8ZTwPuj0WC','main/customers/7.jpg','1983-02-17','+16513598762',NULL,'2024-03-15 03:04:23','2024-03-15 03:04:28','2024-03-15 10:04:20',NULL,0,NULL,'activated',NULL),(10,'Asha Conroy','hettinger.ofelia@example.org','$2y$12$zKCKcDFYoKEMo7IErgkbOu1N1ds277Hwdw0QxDGn8oSRRiAh02zyC','main/customers/8.jpg','1976-03-14','+15177174727',NULL,'2024-03-15 03:04:23','2024-03-15 03:04:28','2024-03-15 10:04:20',NULL,0,NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','Q5TDQTYMKRKL','2024-03-14 10:04:25','2024-04-02 10:04:25',NULL,0,338,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(2,'Discount 2','ZU8MPDFNRQWD','2024-03-14 10:04:25','2024-03-24 10:04:25',NULL,0,649,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(3,'Discount 3','ONDZWGXUOZC0','2024-03-14 10:04:25','2024-03-25 10:04:25',NULL,0,474,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(4,'Discount 4','G7V9AJQQDPGN','2024-03-14 10:04:25',NULL,NULL,0,28,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(5,'Discount 5','H6U6RBNYWUEP','2024-03-14 10:04:25',NULL,NULL,0,501,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(6,'Discount 6','NA6HRO2PXTJZ','2024-03-14 10:04:25',NULL,NULL,0,623,'coupon',0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(7,'Discount 7','UYALILS8ZXLV','2024-03-14 10:04:25','2024-04-06 10:04:25',NULL,0,898,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(8,'Discount 8','V7JOI6NFFTCF','2024-03-14 10:04:25','2024-03-18 10:04:25',NULL,0,797,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(9,'Discount 9','52DSHWRQFVUH','2024-03-14 10:04:25','2024-04-09 10:04:25',NULL,0,367,'coupon',0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL),(10,'Discount 10','LIBAI8IQB33M','2024-03-14 10:04:25',NULL,NULL,0,467,'coupon',0,NULL,NULL,'amount','all-orders',NULL,0,1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL,NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,622.64,11,5),(1,2,424.71,20,4),(1,3,720.8,17,4),(1,4,774.0226,10,3),(1,5,343.14,17,4),(1,6,1309.29,12,5),(1,7,1927.6,17,1),(1,8,309.2544,12,4),(1,9,869.4,19,5),(1,10,390.32,17,5);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2024-04-07 00:00:00','published','2024-03-15 03:04:34','2024-03-15 03:04:34');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(1,2,'2 Year',10,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(1,3,'3 Year',20,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(2,4,'4GB',0,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(2,5,'8GB',10,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(2,6,'16GB',20,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(3,7,'Core i5',0,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(3,8,'Core i7',10,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(3,9,'Core i9',20,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(4,10,'128GB',0,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(4,11,'256GB',10,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(4,12,'512GB',20,9999,0,'2024-03-15 03:04:25','2024-03-15 03:04:25');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2024-03-15 03:04:25','2024-03-15 03:04:25');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
INSERT INTO `ec_invoice_items` VALUES (1,1,'Botble\\Ecommerce\\Models\\Product',104,'Retro Cat-Eye Sunglasses',NULL,'jewelry/products/product-1.png',2,874.00,1748.00,0.00,0.00,1748.00,'{\"sku\":\"0V-138-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(2,2,'Botble\\Ecommerce\\Models\\Product',127,'Embellished Ballet Flats',NULL,'jewelry/products/product-2.png',1,318.00,318.00,0.00,0.00,318.00,'{\"sku\":\"TO-194-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(3,3,'Botble\\Ecommerce\\Models\\Product',150,'Metallic Pleated Maxi Skirt',NULL,'jewelry/products/product-2.png',2,795.00,1590.00,0.00,0.00,1590.00,'{\"sku\":\"LX-115-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(4,4,'Botble\\Ecommerce\\Models\\Product',47,'Knit Turtleneck Sweater (Digital)',NULL,'jewelry/products/product-2.png',3,1781.00,5343.00,0.00,0.00,5343.00,'{\"sku\":\"VV-152-A0\",\"attributes\":\"(Color: Green, Size: L)\"}','2024-03-15 03:04:37','2024-03-15 03:04:37'),(5,5,'Botble\\Ecommerce\\Models\\Product',50,'Classic Aviator Sunglasses',NULL,'jewelry/products/product-3.png',2,817.00,1634.00,0.00,0.00,1634.00,'{\"sku\":\"JA-179-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-15 03:04:37','2024-03-15 03:04:37'),(6,6,'Botble\\Ecommerce\\Models\\Product',108,'Faux Fur Trimmed Coat',NULL,'jewelry/products/product-5.png',1,579.00,579.00,0.00,0.00,579.00,'{\"sku\":\"QE-163-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:37','2024-03-15 03:04:37'),(7,7,'Botble\\Ecommerce\\Models\\Product',112,'Ruffled Wrap Dress',NULL,'jewelry/products/product-4.png',2,1378.00,2756.00,0.00,0.00,2756.00,'{\"sku\":\"7A-136-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:37','2024-03-15 03:04:37'),(8,8,'Botble\\Ecommerce\\Models\\Product',125,'Embellished Ballet Flats',NULL,'jewelry/products/product-8.png',2,318.00,636.00,0.00,0.00,636.00,'{\"sku\":\"TO-194-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}','2024-03-15 03:04:37','2024-03-15 03:04:37'),(9,9,'Botble\\Ecommerce\\Models\\Product',82,'Cotton Striped T-Shirt Dress',NULL,'jewelry/products/product-5.png',1,2306.00,2306.00,0.00,0.00,2306.00,'{\"sku\":\"NW-157-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}','2024-03-15 03:04:38','2024-03-15 03:04:38'),(10,9,'Botble\\Ecommerce\\Models\\Product',110,'Boho Fringed Kimono (Digital)',NULL,'jewelry/products/product-4.png',2,2305.00,4610.00,0.00,0.00,4610.00,'{\"sku\":\"B4-149-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}','2024-03-15 03:04:38','2024-03-15 03:04:38'),(11,10,'Botble\\Ecommerce\\Models\\Product',130,'Velour Tracksuit Set',NULL,'jewelry/products/product-5.png',3,1737.00,5211.00,0.00,0.00,5211.00,'{\"sku\":\"F5-146-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:38','2024-03-15 03:04:38'),(12,11,'Botble\\Ecommerce\\Models\\Product',136,'Embroidered Bomber Jacket',NULL,'jewelry/products/product-5.png',1,2062.00,2062.00,0.00,0.00,2062.00,'{\"sku\":\"IK-105-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-15 03:04:38','2024-03-15 03:04:38'),(13,12,'Botble\\Ecommerce\\Models\\Product',93,'Off-Shoulder Ruffle Top',NULL,'jewelry/products/product-5.png',2,1744.00,3488.00,0.00,0.00,3488.00,'{\"sku\":\"MJ-187-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}','2024-03-15 03:04:38','2024-03-15 03:04:38'),(14,12,'Botble\\Ecommerce\\Models\\Product',142,'Chunky Knit Infinity Scarf (Digital)',NULL,'jewelry/products/product-4.png',3,2418.00,7254.00,0.00,0.00,7254.00,'{\"sku\":\"Z7-188-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}','2024-03-15 03:04:38','2024-03-15 03:04:38'),(15,13,'Botble\\Ecommerce\\Models\\Product',117,'Beaded Evening Clutch',NULL,'jewelry/products/product-8.png',2,775.00,1550.00,0.00,0.00,1550.00,'{\"sku\":\"DM-189-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:38','2024-03-15 03:04:38'),(16,14,'Botble\\Ecommerce\\Models\\Product',131,'Velour Tracksuit Set',NULL,'jewelry/products/product-1.png',1,1737.00,1737.00,0.00,0.00,1737.00,'{\"sku\":\"F5-146-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-15 03:04:39','2024-03-15 03:04:39'),(17,15,'Botble\\Ecommerce\\Models\\Product',118,'Wide Brim Floppy Hat',NULL,'jewelry/products/product-3.png',1,1961.00,1961.00,0.00,0.00,1961.00,'{\"sku\":\"DA-123-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}','2024-03-15 03:04:39','2024-03-15 03:04:39'),(18,15,'Botble\\Ecommerce\\Models\\Product',119,'Wide Brim Floppy Hat',NULL,'jewelry/products/product-2.png',3,1961.00,5883.00,0.00,0.00,5883.00,'{\"sku\":\"DA-123-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:39','2024-03-15 03:04:39'),(19,16,'Botble\\Ecommerce\\Models\\Product',148,'Faux Leather Leggings',NULL,'jewelry/products/product-8.png',1,1644.00,1644.00,0.00,0.00,1644.00,'{\"sku\":\"GR-126-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:39','2024-03-15 03:04:39'),(20,17,'Botble\\Ecommerce\\Models\\Product',68,'Chic Fedora Hat (Digital)',NULL,'jewelry/products/product-7.png',2,587.00,1174.00,0.00,0.00,1174.00,'{\"sku\":\"IL-161-A0-A3\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:04:39','2024-03-15 03:04:39'),(21,18,'Botble\\Ecommerce\\Models\\Product',74,'Quilted Crossbody Bag',NULL,'jewelry/products/product-2.png',3,1821.00,5463.00,0.00,0.00,5463.00,'{\"sku\":\"VH-154-A0-A1\",\"attributes\":\"(Color: Green, Size: M)\"}','2024-03-15 03:04:39','2024-03-15 03:04:39'),(22,19,'Botble\\Ecommerce\\Models\\Product',53,'Bohemian Fringe Handbag',NULL,'jewelry/products/product-6.png',3,2440.00,7320.00,0.00,0.00,7320.00,'{\"sku\":\"2Q-144-A0\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:04:39','2024-03-15 03:04:39'),(23,20,'Botble\\Ecommerce\\Models\\Product',107,'Retro Cat-Eye Sunglasses',NULL,'jewelry/products/product-2.png',3,874.00,2622.00,0.00,0.00,2622.00,'{\"sku\":\"0V-138-A0-A4\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:40','2024-03-15 03:04:40'),(24,21,'Botble\\Ecommerce\\Models\\Product',130,'Velour Tracksuit Set',NULL,'jewelry/products/product-5.png',3,1737.00,5211.00,0.00,0.00,5211.00,'{\"sku\":\"F5-146-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:40','2024-03-15 03:04:40'),(25,22,'Botble\\Ecommerce\\Models\\Product',63,'Statement Chunky Necklace',NULL,'jewelry/products/product-3.png',2,761.00,1522.00,0.00,0.00,1522.00,'{\"sku\":\"XO-112-A0\",\"attributes\":\"(Color: Green, Size: M)\"}','2024-03-15 03:04:40','2024-03-15 03:04:40'),(26,23,'Botble\\Ecommerce\\Models\\Product',85,'Printed Palazzo Pants',NULL,'jewelry/products/product-4.png',3,1706.00,5118.00,0.00,0.00,5118.00,'{\"sku\":\"XE-152-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}','2024-03-15 03:04:40','2024-03-15 03:04:40'),(27,24,'Botble\\Ecommerce\\Models\\Product',116,'Beaded Evening Clutch',NULL,'jewelry/products/product-7.png',2,775.00,1550.00,0.00,0.00,1550.00,'{\"sku\":\"DM-189-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}','2024-03-15 03:04:40','2024-03-15 03:04:40'),(28,25,'Botble\\Ecommerce\\Models\\Product',148,'Faux Leather Leggings',NULL,'jewelry/products/product-8.png',1,1644.00,1644.00,0.00,0.00,1644.00,'{\"sku\":\"GR-126-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:41','2024-03-15 03:04:41'),(29,26,'Botble\\Ecommerce\\Models\\Product',45,'Floral Maxi Dress',NULL,'jewelry/products/product-2.png',1,1287.00,1287.00,0.00,0.00,1287.00,'{\"sku\":\"QT-132-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}','2024-03-15 03:04:41','2024-03-15 03:04:41'),(30,27,'Botble\\Ecommerce\\Models\\Product',97,'Athleisure Jogger Pants (Digital)',NULL,'jewelry/products/product-6.png',2,1555.00,3110.00,0.00,0.00,3110.00,'{\"sku\":\"GH-176-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}','2024-03-15 03:04:41','2024-03-15 03:04:41'),(31,28,'Botble\\Ecommerce\\Models\\Product',103,'Retro Cat-Eye Sunglasses',NULL,'jewelry/products/product-6.png',3,874.00,2622.00,0.00,0.00,2622.00,'{\"sku\":\"0V-138-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}','2024-03-15 03:04:41','2024-03-15 03:04:41'),(32,29,'Botble\\Ecommerce\\Models\\Product',53,'Bohemian Fringe Handbag',NULL,'jewelry/products/product-6.png',2,2440.00,4880.00,0.00,0.00,4880.00,'{\"sku\":\"2Q-144-A0\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:04:41','2024-03-15 03:04:41'),(33,30,'Botble\\Ecommerce\\Models\\Product',79,'Distressed Skinny Jeans (Digital)',NULL,'jewelry/products/product-5.png',2,1908.00,3816.00,0.00,0.00,3816.00,'{\"sku\":\"SW-162-A0-A3\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-15 03:04:42','2024-03-15 03:04:42'),(34,31,'Botble\\Ecommerce\\Models\\Product',90,'Structured Satchel Bag (Digital)',NULL,'jewelry/products/product-2.png',2,425.00,850.00,0.00,0.00,850.00,'{\"sku\":\"ON-156-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:04:42','2024-03-15 03:04:42'),(35,32,'Botble\\Ecommerce\\Models\\Product',108,'Faux Fur Trimmed Coat',NULL,'jewelry/products/product-5.png',2,579.00,1158.00,0.00,0.00,1158.00,'{\"sku\":\"QE-163-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:42','2024-03-15 03:04:42'),(36,33,'Botble\\Ecommerce\\Models\\Product',45,'Floral Maxi Dress',NULL,'jewelry/products/product-2.png',1,1287.00,1287.00,0.00,0.00,1287.00,'{\"sku\":\"QT-132-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}','2024-03-15 03:04:42','2024-03-15 03:04:42'),(37,34,'Botble\\Ecommerce\\Models\\Product',47,'Knit Turtleneck Sweater (Digital)',NULL,'jewelry/products/product-2.png',3,1781.00,5343.00,0.00,0.00,5343.00,'{\"sku\":\"VV-152-A0\",\"attributes\":\"(Color: Green, Size: L)\"}','2024-03-15 03:04:42','2024-03-15 03:04:42'),(38,35,'Botble\\Ecommerce\\Models\\Product',90,'Structured Satchel Bag (Digital)',NULL,'jewelry/products/product-2.png',1,425.00,425.00,0.00,0.00,425.00,'{\"sku\":\"ON-156-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:04:43','2024-03-15 03:04:43'),(39,36,'Botble\\Ecommerce\\Models\\Product',128,'Pleated Midi Skirt',NULL,'jewelry/products/product-8.png',1,513.00,513.00,0.00,0.00,513.00,'{\"sku\":\"LQ-100-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:43','2024-03-15 03:04:43'),(40,37,'Botble\\Ecommerce\\Models\\Product',53,'Bohemian Fringe Handbag',NULL,'jewelry/products/product-6.png',1,2440.00,2440.00,0.00,0.00,2440.00,'{\"sku\":\"2Q-144-A0\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:04:43','2024-03-15 03:04:43'),(41,38,'Botble\\Ecommerce\\Models\\Product',62,'Embroidered Boho Blouse',NULL,'jewelry/products/product-8.png',2,574.00,1148.00,0.00,0.00,1148.00,'{\"sku\":\"BH-124-A0-A3\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-15 03:04:43','2024-03-15 03:04:43'),(42,38,'Botble\\Ecommerce\\Models\\Product',98,'Athleisure Jogger Pants (Digital)',NULL,'jewelry/products/product-3.png',1,1555.00,1555.00,0.00,0.00,1555.00,'{\"sku\":\"GH-176-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}','2024-03-15 03:04:43','2024-03-15 03:04:43'),(43,39,'Botble\\Ecommerce\\Models\\Product',129,'Pleated Midi Skirt',NULL,'jewelry/products/product-4.png',3,513.00,1539.00,0.00,0.00,1539.00,'{\"sku\":\"LQ-100-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:43','2024-03-15 03:04:43'),(44,40,'Botble\\Ecommerce\\Models\\Product',60,'Embroidered Boho Blouse',NULL,'jewelry/products/product-4.png',2,574.00,1148.00,0.00,0.00,1148.00,'{\"sku\":\"BH-124-A0-A1\",\"attributes\":\"(Color: Red, Size: XXL)\"}','2024-03-15 03:04:44','2024-03-15 03:04:44'),(45,40,'Botble\\Ecommerce\\Models\\Product',113,'Ruffled Wrap Dress',NULL,'jewelry/products/product-6.png',1,1378.00,1378.00,0.00,0.00,1378.00,'{\"sku\":\"7A-136-A0-A1\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}','2024-03-15 03:04:44','2024-03-15 03:04:44'),(46,41,'Botble\\Ecommerce\\Models\\Product',89,'Structured Satchel Bag (Digital)',NULL,'jewelry/products/product-7.png',2,425.00,850.00,0.00,0.00,850.00,'{\"sku\":\"ON-156-A0-A1\",\"attributes\":\"(Size: S, Color: Red)\"}','2024-03-15 03:04:44','2024-03-15 03:04:44'),(47,42,'Botble\\Ecommerce\\Models\\Product',135,'Buckle Detail Ankle Booties',NULL,'jewelry/products/product-7.png',1,302.00,302.00,0.00,0.00,302.00,'{\"sku\":\"X8-116-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:44','2024-03-15 03:04:44'),(48,43,'Botble\\Ecommerce\\Models\\Product',115,'Ruffled Wrap Dress',NULL,'jewelry/products/product-2.png',2,1378.00,2756.00,0.00,0.00,2756.00,'{\"sku\":\"7A-136-A0-A3\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-15 03:04:44','2024-03-15 03:04:44'),(49,44,'Botble\\Ecommerce\\Models\\Product',121,'Denim Overall Jumpsuit (Digital)',NULL,'jewelry/products/product-3.png',3,441.00,1323.00,0.00,0.00,1323.00,'{\"sku\":\"ZP-152-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-15 03:04:44','2024-03-15 03:04:44'),(50,45,'Botble\\Ecommerce\\Models\\Product',131,'Velour Tracksuit Set',NULL,'jewelry/products/product-1.png',3,1737.00,5211.00,0.00,0.00,5211.00,'{\"sku\":\"F5-146-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-15 03:04:45','2024-03-15 03:04:45'),(51,46,'Botble\\Ecommerce\\Models\\Product',49,'Knit Turtleneck Sweater (Digital)',NULL,'jewelry/products/product-3.png',3,1781.00,5343.00,0.00,0.00,5343.00,'{\"sku\":\"VV-152-A0-A2\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:04:45','2024-03-15 03:04:45'),(52,47,'Botble\\Ecommerce\\Models\\Product',50,'Classic Aviator Sunglasses',NULL,'jewelry/products/product-3.png',3,817.00,2451.00,0.00,0.00,2451.00,'{\"sku\":\"JA-179-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}','2024-03-15 03:04:45','2024-03-15 03:04:45'),(53,48,'Botble\\Ecommerce\\Models\\Product',91,'Off-Shoulder Ruffle Top',NULL,'jewelry/products/product-7.png',2,1744.00,3488.00,0.00,0.00,3488.00,'{\"sku\":\"MJ-187-A0\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-15 03:04:45','2024-03-15 03:04:45'),(54,49,'Botble\\Ecommerce\\Models\\Product',101,'Leopard Print Midi Skirt',NULL,'jewelry/products/product-6.png',3,666.00,1998.00,0.00,0.00,1998.00,'{\"sku\":\"OA-178-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:45','2024-03-15 03:04:45'),(55,50,'Botble\\Ecommerce\\Models\\Product',131,'Velour Tracksuit Set',NULL,'jewelry/products/product-1.png',2,1737.00,3474.00,0.00,0.00,3474.00,'{\"sku\":\"F5-146-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-15 03:04:46','2024-03-15 03:04:46'),(56,51,'Botble\\Ecommerce\\Models\\Product',132,'Geometric Patterned Cardigan (Digital)',NULL,'jewelry/products/product-1.png',2,781.00,1562.00,0.00,0.00,1562.00,'{\"sku\":\"HN-174-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}','2024-03-15 03:04:46','2024-03-15 03:04:46'),(57,52,'Botble\\Ecommerce\\Models\\Product',150,'Metallic Pleated Maxi Skirt',NULL,'jewelry/products/product-2.png',3,795.00,2385.00,0.00,0.00,2385.00,'{\"sku\":\"LX-115-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:46','2024-03-15 03:04:46'),(58,53,'Botble\\Ecommerce\\Models\\Product',73,'Quilted Crossbody Bag',NULL,'jewelry/products/product-8.png',2,1821.00,3642.00,0.00,0.00,3642.00,'{\"sku\":\"VH-154-A0\",\"attributes\":\"(Color: Blue, Size: XL)\"}','2024-03-15 03:04:46','2024-03-15 03:04:46'),(59,54,'Botble\\Ecommerce\\Models\\Product',105,'Retro Cat-Eye Sunglasses',NULL,'jewelry/products/product-8.png',3,874.00,2622.00,0.00,0.00,2622.00,'{\"sku\":\"0V-138-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:46','2024-03-15 03:04:46'),(60,54,'Botble\\Ecommerce\\Models\\Product',117,'Beaded Evening Clutch',NULL,'jewelry/products/product-8.png',3,775.00,2325.00,0.00,0.00,2325.00,'{\"sku\":\"DM-189-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}','2024-03-15 03:04:46','2024-03-15 03:04:46'),(61,55,'Botble\\Ecommerce\\Models\\Product',143,'Chunky Knit Infinity Scarf (Digital)',NULL,'jewelry/products/product-5.png',2,2418.00,4836.00,0.00,0.00,4836.00,'{\"sku\":\"Z7-188-A0-A2\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:47','2024-03-15 03:04:47'),(62,56,'Botble\\Ecommerce\\Models\\Product',62,'Embroidered Boho Blouse',NULL,'jewelry/products/product-8.png',3,574.00,1722.00,0.00,0.00,1722.00,'{\"sku\":\"BH-124-A0-A3\",\"attributes\":\"(Size: S, Color: Black)\"}','2024-03-15 03:04:47','2024-03-15 03:04:47'),(63,57,'Botble\\Ecommerce\\Models\\Product',145,'Retro High-Top Sneakers',NULL,'jewelry/products/product-1.png',1,2005.00,2005.00,0.00,0.00,2005.00,'{\"sku\":\"LW-110-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}','2024-03-15 03:04:47','2024-03-15 03:04:47'),(64,58,'Botble\\Ecommerce\\Models\\Product',68,'Chic Fedora Hat (Digital)',NULL,'jewelry/products/product-7.png',1,587.00,587.00,0.00,0.00,587.00,'{\"sku\":\"IL-161-A0-A3\",\"attributes\":\"(Size: M, Color: Black)\"}','2024-03-15 03:04:47','2024-03-15 03:04:47'),(65,59,'Botble\\Ecommerce\\Models\\Product',147,'Faux Leather Leggings',NULL,'jewelry/products/product-7.png',3,1644.00,4932.00,0.00,0.00,4932.00,'{\"sku\":\"GR-126-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}','2024-03-15 03:04:47','2024-03-15 03:04:47');
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
INSERT INTO `ec_invoices` VALUES (1,'Botble\\Ecommerce\\Models\\Order',1,'INV-1','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1748.00,0.00,0.00,0.00,'1','default',NULL,NULL,1748.00,NULL,1,'completed','2024-03-15 03:04:36','2024-02-29 03:04:36','2024-03-15 03:04:36'),(2,'Botble\\Ecommerce\\Models\\Order',2,'INV-2','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,318.00,0.00,0.00,0.00,'1','default',NULL,NULL,318.00,NULL,2,'completed','2024-03-15 03:04:36','2024-03-13 11:04:36','2024-03-15 03:04:36'),(3,'Botble\\Ecommerce\\Models\\Order',3,'INV-3','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1590.00,0.00,0.00,0.00,'1','default',NULL,NULL,1590.00,NULL,3,'completed','2024-03-15 03:04:36','2024-02-29 03:04:36','2024-03-15 03:04:36'),(4,'Botble\\Ecommerce\\Models\\Order',4,'INV-4','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,5343.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5343.00,NULL,4,'pending',NULL,'2024-02-29 21:04:37','2024-03-15 03:04:37'),(5,'Botble\\Ecommerce\\Models\\Order',5,'INV-5','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1634.00,0.00,0.00,0.00,'1','default',NULL,NULL,1634.00,NULL,5,'completed','2024-03-15 03:04:37','2024-03-08 19:04:37','2024-03-15 03:04:37'),(6,'Botble\\Ecommerce\\Models\\Order',6,'INV-6','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,579.00,0.00,0.00,0.00,'1','default',NULL,NULL,579.00,NULL,6,'pending',NULL,'2024-03-05 15:04:37','2024-03-15 03:04:37'),(7,'Botble\\Ecommerce\\Models\\Order',7,'INV-7','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,2756.00,0.00,0.00,0.00,'1','default',NULL,NULL,2756.00,NULL,7,'completed','2024-03-15 03:04:37','2024-03-06 03:04:37','2024-03-15 03:04:37'),(8,'Botble\\Ecommerce\\Models\\Order',8,'INV-8','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,636.00,0.00,0.00,0.00,'1','default',NULL,NULL,636.00,NULL,8,'completed','2024-03-15 03:04:37','2024-03-01 15:04:37','2024-03-15 03:04:37'),(9,'Botble\\Ecommerce\\Models\\Order',9,'INV-9','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,6916.00,0.00,0.00,0.00,'1','default',NULL,NULL,6916.00,NULL,9,'pending',NULL,'2024-03-08 01:04:38','2024-03-15 03:04:38'),(10,'Botble\\Ecommerce\\Models\\Order',10,'INV-10','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,5211.00,0.00,0.00,0.00,'1','default',NULL,NULL,5211.00,NULL,10,'pending',NULL,'2024-02-29 23:04:38','2024-03-15 03:04:38'),(11,'Botble\\Ecommerce\\Models\\Order',11,'INV-11','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,2062.00,0.00,0.00,0.00,'1','default',NULL,NULL,2062.00,NULL,11,'completed','2024-03-15 03:04:38','2024-03-09 11:04:38','2024-03-15 03:04:38'),(12,'Botble\\Ecommerce\\Models\\Order',12,'INV-12','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,10742.00,0.00,0.00,0.00,'1','default',NULL,NULL,10742.00,NULL,12,'pending',NULL,'2024-03-09 19:04:38','2024-03-15 03:04:38'),(13,'Botble\\Ecommerce\\Models\\Order',13,'INV-13','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1550.00,0.00,0.00,0.00,'1','default',NULL,NULL,1550.00,NULL,13,'pending',NULL,'2024-03-03 03:04:38','2024-03-15 03:04:38'),(14,'Botble\\Ecommerce\\Models\\Order',14,'INV-14','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1737.00,0.00,0.00,0.00,'1','default',NULL,NULL,1737.00,NULL,14,'completed','2024-03-15 03:04:39','2024-03-08 11:04:38','2024-03-15 03:04:39'),(15,'Botble\\Ecommerce\\Models\\Order',15,'INV-15','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,7844.00,0.00,0.00,0.00,'1','default',NULL,NULL,7844.00,NULL,15,'completed','2024-03-15 03:04:39','2024-03-08 21:04:39','2024-03-15 03:04:39'),(16,'Botble\\Ecommerce\\Models\\Order',16,'INV-16','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1644.00,0.00,0.00,0.00,'1','default',NULL,NULL,1644.00,NULL,16,'completed','2024-03-15 03:04:39','2024-03-10 03:04:39','2024-03-15 03:04:39'),(17,'Botble\\Ecommerce\\Models\\Order',17,'INV-17','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1174.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1174.00,NULL,17,'completed','2024-03-15 03:04:39','2024-03-10 11:04:39','2024-03-15 03:04:39'),(18,'Botble\\Ecommerce\\Models\\Order',18,'INV-18','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,5463.00,0.00,0.00,0.00,'1','default',NULL,NULL,5463.00,NULL,18,'pending',NULL,'2024-03-05 19:04:39','2024-03-15 03:04:39'),(19,'Botble\\Ecommerce\\Models\\Order',19,'INV-19','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,7320.00,0.00,0.00,0.00,'1','default',NULL,NULL,7320.00,NULL,19,'completed','2024-03-15 03:04:39','2024-03-09 17:04:39','2024-03-15 03:04:39'),(20,'Botble\\Ecommerce\\Models\\Order',20,'INV-20','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,2622.00,0.00,0.00,0.00,'1','default',NULL,NULL,2622.00,NULL,20,'completed','2024-03-15 03:04:40','2024-03-11 21:04:40','2024-03-15 03:04:40'),(21,'Botble\\Ecommerce\\Models\\Order',21,'INV-21','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,5211.00,0.00,0.00,0.00,'1','default',NULL,NULL,5211.00,NULL,21,'pending',NULL,'2024-03-06 11:04:40','2024-03-15 03:04:40'),(22,'Botble\\Ecommerce\\Models\\Order',22,'INV-22','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1522.00,0.00,0.00,0.00,'1','default',NULL,NULL,1522.00,NULL,22,'pending',NULL,'2024-03-06 03:04:40','2024-03-15 03:04:40'),(23,'Botble\\Ecommerce\\Models\\Order',23,'INV-23','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,5118.00,0.00,0.00,0.00,'1','default',NULL,NULL,5118.00,NULL,23,'pending',NULL,'2024-03-13 03:04:40','2024-03-15 03:04:40'),(24,'Botble\\Ecommerce\\Models\\Order',24,'INV-24','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1550.00,0.00,0.00,0.00,'1','default',NULL,NULL,1550.00,NULL,24,'completed','2024-03-15 03:04:40','2024-03-10 03:04:40','2024-03-15 03:04:40'),(25,'Botble\\Ecommerce\\Models\\Order',25,'INV-25','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1644.00,0.00,0.00,0.00,'1','default',NULL,NULL,1644.00,NULL,25,'completed','2024-03-15 03:04:41','2024-03-14 03:04:41','2024-03-15 03:04:41'),(26,'Botble\\Ecommerce\\Models\\Order',26,'INV-26','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1287.00,0.00,0.00,0.00,'1','default',NULL,NULL,1287.00,NULL,26,'completed','2024-03-15 03:04:41','2024-03-10 13:04:41','2024-03-15 03:04:41'),(27,'Botble\\Ecommerce\\Models\\Order',27,'INV-27','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,3110.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3110.00,NULL,27,'completed','2024-03-15 03:04:41','2024-03-13 07:04:41','2024-03-15 03:04:41'),(28,'Botble\\Ecommerce\\Models\\Order',28,'INV-28','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,2622.00,0.00,0.00,0.00,'1','default',NULL,NULL,2622.00,NULL,28,'completed','2024-03-15 03:04:41','2024-03-14 05:04:41','2024-03-15 03:04:41'),(29,'Botble\\Ecommerce\\Models\\Order',29,'INV-29','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,4880.00,0.00,0.00,0.00,'1','default',NULL,NULL,4880.00,NULL,29,'completed','2024-03-15 03:04:41','2024-03-10 03:04:41','2024-03-15 03:04:41'),(30,'Botble\\Ecommerce\\Models\\Order',30,'INV-30','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,3816.00,0.00,0.00,0.00,NULL,'',NULL,NULL,3816.00,NULL,30,'completed','2024-03-15 03:04:42','2024-03-08 11:04:42','2024-03-15 03:04:42'),(31,'Botble\\Ecommerce\\Models\\Order',31,'INV-31','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,850.00,0.00,0.00,0.00,NULL,'',NULL,NULL,850.00,NULL,31,'pending',NULL,'2024-03-06 19:04:42','2024-03-15 03:04:42'),(32,'Botble\\Ecommerce\\Models\\Order',32,'INV-32','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1158.00,0.00,0.00,0.00,'1','default',NULL,NULL,1158.00,NULL,32,'pending',NULL,'2024-03-09 07:04:42','2024-03-15 03:04:42'),(33,'Botble\\Ecommerce\\Models\\Order',33,'INV-33','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,1287.00,0.00,0.00,0.00,'1','default',NULL,NULL,1287.00,NULL,33,'pending',NULL,'2024-03-14 09:04:42','2024-03-15 03:04:42'),(34,'Botble\\Ecommerce\\Models\\Order',34,'INV-34','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,5343.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5343.00,NULL,34,'completed','2024-03-15 03:04:42','2024-03-09 03:04:42','2024-03-15 03:04:42'),(35,'Botble\\Ecommerce\\Models\\Order',35,'INV-35','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,425.00,0.00,0.00,0.00,NULL,'',NULL,NULL,425.00,NULL,35,'completed','2024-03-15 03:04:43','2024-03-14 09:04:43','2024-03-15 03:04:43'),(36,'Botble\\Ecommerce\\Models\\Order',36,'INV-36','Marty Braun IV','',NULL,'retta51@example.net','+13012980240','63064 Blanda Squares, Arielton, Georgia, TN',NULL,513.00,0.00,0.00,0.00,'1','default',NULL,NULL,513.00,NULL,36,'completed','2024-03-15 03:04:43','2024-03-10 15:04:43','2024-03-15 03:04:43'),(37,'Botble\\Ecommerce\\Models\\Order',37,'INV-37','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,2440.00,0.00,0.00,0.00,'1','default',NULL,NULL,2440.00,NULL,37,'pending',NULL,'2024-03-10 11:04:43','2024-03-15 03:04:43'),(38,'Botble\\Ecommerce\\Models\\Order',38,'INV-38','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,2703.00,0.00,0.00,0.00,'1','default',NULL,NULL,2703.00,NULL,38,'completed','2024-03-15 03:04:43','2024-03-09 03:04:43','2024-03-15 03:04:43'),(39,'Botble\\Ecommerce\\Models\\Order',39,'INV-39','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1539.00,0.00,0.00,0.00,'1','default',NULL,NULL,1539.00,NULL,39,'pending',NULL,'2024-03-11 03:04:43','2024-03-15 03:04:43'),(40,'Botble\\Ecommerce\\Models\\Order',40,'INV-40','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,2526.00,0.00,0.00,0.00,'1','default',NULL,NULL,2526.00,NULL,40,'completed','2024-03-15 03:04:44','2024-03-09 21:04:44','2024-03-15 03:04:44'),(41,'Botble\\Ecommerce\\Models\\Order',41,'INV-41','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,850.00,0.00,0.00,0.00,NULL,'',NULL,NULL,850.00,NULL,41,'completed','2024-03-15 03:04:44','2024-03-11 01:04:44','2024-03-15 03:04:44'),(42,'Botble\\Ecommerce\\Models\\Order',42,'INV-42','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,302.00,0.00,0.00,0.00,'1','default',NULL,NULL,302.00,NULL,42,'completed','2024-03-15 03:04:44','2024-03-09 07:04:44','2024-03-15 03:04:44'),(43,'Botble\\Ecommerce\\Models\\Order',43,'INV-43','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,2756.00,0.00,0.00,0.00,'1','default',NULL,NULL,2756.00,NULL,43,'pending',NULL,'2024-03-13 03:04:44','2024-03-15 03:04:44'),(44,'Botble\\Ecommerce\\Models\\Order',44,'INV-44','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1323.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1323.00,NULL,44,'pending',NULL,'2024-03-10 15:04:44','2024-03-15 03:04:44'),(45,'Botble\\Ecommerce\\Models\\Order',45,'INV-45','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,5211.00,0.00,0.00,0.00,'1','default',NULL,NULL,5211.00,NULL,45,'completed','2024-03-15 03:04:45','2024-03-12 03:04:45','2024-03-15 03:04:45'),(46,'Botble\\Ecommerce\\Models\\Order',46,'INV-46','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,5343.00,0.00,0.00,0.00,NULL,'',NULL,NULL,5343.00,NULL,46,'completed','2024-03-15 03:04:45','2024-03-12 05:04:45','2024-03-15 03:04:45'),(47,'Botble\\Ecommerce\\Models\\Order',47,'INV-47','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,2451.00,0.00,0.00,0.00,'1','default',NULL,NULL,2451.00,NULL,47,'completed','2024-03-15 03:04:45','2024-03-11 09:04:45','2024-03-15 03:04:45'),(48,'Botble\\Ecommerce\\Models\\Order',48,'INV-48','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,3488.00,0.00,0.00,0.00,'1','default',NULL,NULL,3488.00,NULL,48,'completed','2024-03-15 03:04:45','2024-03-13 11:04:45','2024-03-15 03:04:45'),(49,'Botble\\Ecommerce\\Models\\Order',49,'INV-49','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1998.00,0.00,0.00,0.00,'1','default',NULL,NULL,1998.00,NULL,49,'completed','2024-03-15 03:04:45','2024-03-10 23:04:45','2024-03-15 03:04:45'),(50,'Botble\\Ecommerce\\Models\\Order',50,'INV-50','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,3474.00,0.00,0.00,0.00,'1','default',NULL,NULL,3474.00,NULL,50,'completed','2024-03-15 03:04:46','2024-03-14 03:04:46','2024-03-15 03:04:46'),(51,'Botble\\Ecommerce\\Models\\Order',51,'INV-51','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1562.00,0.00,0.00,0.00,NULL,'',NULL,NULL,1562.00,NULL,51,'completed','2024-03-15 03:04:46','2024-03-13 19:04:46','2024-03-15 03:04:46'),(52,'Botble\\Ecommerce\\Models\\Order',52,'INV-52','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,2385.00,0.00,0.00,0.00,'1','default',NULL,NULL,2385.00,NULL,52,'completed','2024-03-15 03:04:46','2024-03-12 11:04:46','2024-03-15 03:04:46'),(53,'Botble\\Ecommerce\\Models\\Order',53,'INV-53','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,3642.00,0.00,0.00,0.00,'1','default',NULL,NULL,3642.00,NULL,53,'completed','2024-03-15 03:04:46','2024-03-12 15:04:46','2024-03-15 03:04:46'),(54,'Botble\\Ecommerce\\Models\\Order',54,'INV-54','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,4947.00,0.00,0.00,0.00,'1','default',NULL,NULL,4947.00,NULL,54,'completed','2024-03-15 03:04:46','2024-03-12 15:04:46','2024-03-15 03:04:46'),(55,'Botble\\Ecommerce\\Models\\Order',55,'INV-55','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,4836.00,0.00,0.00,0.00,NULL,'',NULL,NULL,4836.00,NULL,55,'completed','2024-03-15 03:04:47','2024-03-12 15:04:46','2024-03-15 03:04:47'),(56,'Botble\\Ecommerce\\Models\\Order',56,'INV-56','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,1722.00,0.00,0.00,0.00,'1','default',NULL,NULL,1722.00,NULL,56,'completed','2024-03-15 03:04:47','2024-03-13 15:04:47','2024-03-15 03:04:47'),(57,'Botble\\Ecommerce\\Models\\Order',57,'INV-57','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,2005.00,0.00,0.00,0.00,'1','default',NULL,NULL,2005.00,NULL,57,'completed','2024-03-15 03:04:47','2024-03-14 15:04:47','2024-03-15 03:04:47'),(58,'Botble\\Ecommerce\\Models\\Order',58,'INV-58','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,587.00,0.00,0.00,0.00,NULL,'',NULL,NULL,587.00,NULL,58,'completed','2024-03-15 03:04:47','2024-03-14 19:04:47','2024-03-15 03:04:47'),(59,'Botble\\Ecommerce\\Models\\Order',59,'INV-59','Asha Conroy','',NULL,'hettinger.ofelia@example.org','+18565326084','41618 Tromp Courts, Donnellystad, Rhode Island, TJ',NULL,4932.00,0.00,0.00,0.00,'1','default',NULL,NULL,4932.00,NULL,59,'completed','2024-03-15 03:04:47','2024-03-14 13:04:47','2024-03-15 03:04:47');
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',1,'47919-8120','shipping_address'),(2,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',2,'47919-8120','shipping_address'),(3,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',3,'47919-8120','shipping_address'),(4,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',4,'58152-9807','shipping_address'),(5,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',5,'58152-9807','shipping_address'),(6,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',6,'58152-9807','shipping_address'),(7,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',7,'47919-8120','shipping_address'),(8,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',8,'47919-8120','shipping_address'),(9,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',9,'47919-8120','shipping_address'),(10,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',10,'47919-8120','shipping_address'),(11,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',11,'47919-8120','shipping_address'),(12,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',12,'47919-8120','shipping_address'),(13,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',13,'47919-8120','shipping_address'),(14,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',14,'47919-8120','shipping_address'),(15,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',15,'47919-8120','shipping_address'),(16,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',16,'47919-8120','shipping_address'),(17,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',17,'58152-9807','shipping_address'),(18,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',18,'58152-9807','shipping_address'),(19,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',19,'47919-8120','shipping_address'),(20,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',20,'47919-8120','shipping_address'),(21,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',21,'47919-8120','shipping_address'),(22,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',22,'58152-9807','shipping_address'),(23,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',23,'58152-9807','shipping_address'),(24,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',24,'58152-9807','shipping_address'),(25,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',25,'58152-9807','shipping_address'),(26,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',26,'47919-8120','shipping_address'),(27,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',27,'47919-8120','shipping_address'),(28,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',28,'47919-8120','shipping_address'),(29,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',29,'47919-8120','shipping_address'),(30,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',30,'47919-8120','shipping_address'),(31,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',31,'47919-8120','shipping_address'),(32,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',32,'47919-8120','shipping_address'),(33,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',33,'47919-8120','shipping_address'),(34,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',34,'47919-8120','shipping_address'),(35,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',35,'47919-8120','shipping_address'),(36,'Marty Braun IV','+13012980240','retta51@example.net','TN','Georgia','Arielton','63064 Blanda Squares',36,'47919-8120','shipping_address'),(37,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',37,'58152-9807','shipping_address'),(38,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',38,'58152-9807','shipping_address'),(39,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',39,'58152-9807','shipping_address'),(40,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',40,'58152-9807','shipping_address'),(41,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',41,'58152-9807','shipping_address'),(42,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',42,'58152-9807','shipping_address'),(43,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',43,'58152-9807','shipping_address'),(44,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',44,'58152-9807','shipping_address'),(45,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',45,'58152-9807','shipping_address'),(46,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',46,'58152-9807','shipping_address'),(47,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',47,'58152-9807','shipping_address'),(48,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',48,'58152-9807','shipping_address'),(49,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',49,'58152-9807','shipping_address'),(50,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',50,'58152-9807','shipping_address'),(51,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',51,'58152-9807','shipping_address'),(52,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',52,'58152-9807','shipping_address'),(53,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',53,'58152-9807','shipping_address'),(54,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',54,'58152-9807','shipping_address'),(55,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',55,'58152-9807','shipping_address'),(56,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',56,'58152-9807','shipping_address'),(57,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',57,'58152-9807','shipping_address'),(58,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',58,'58152-9807','shipping_address'),(59,'Asha Conroy','+18565326084','hettinger.ofelia@example.org','TJ','Rhode Island','Donnellystad','41618 Tromp Courts',59,'58152-9807','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2024-02-29 03:04:36','2024-02-29 03:04:36'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2024-02-29 03:04:36','2024-02-29 03:04:36'),(3,'confirm_payment','Payment was confirmed (amount $1,748.00) by %user_name%',0,1,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36'),(4,'create_shipment','Created shipment for order',0,1,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36'),(5,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36'),(6,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2024-03-13 11:04:36','2024-03-13 11:04:36'),(7,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2024-03-13 11:04:36','2024-03-13 11:04:36'),(8,'confirm_payment','Payment was confirmed (amount $318.00) by %user_name%',0,2,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36'),(9,'create_shipment','Created shipment for order',0,2,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36'),(10,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36'),(11,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2024-02-29 03:04:36','2024-02-29 03:04:36'),(12,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2024-02-29 03:04:36','2024-02-29 03:04:36'),(13,'confirm_payment','Payment was confirmed (amount $1,590.00) by %user_name%',0,3,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36'),(14,'create_shipment','Created shipment for order',0,3,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(15,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2024-02-29 21:04:37','2024-02-29 21:04:37'),(16,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2024-02-29 21:04:37','2024-02-29 21:04:37'),(17,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2024-03-08 19:04:37','2024-03-08 19:04:37'),(18,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2024-03-08 19:04:37','2024-03-08 19:04:37'),(19,'confirm_payment','Payment was confirmed (amount $1,634.00) by %user_name%',0,5,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(20,'create_shipment','Created shipment for order',0,5,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(21,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2024-03-05 15:04:37','2024-03-05 15:04:37'),(22,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2024-03-05 15:04:37','2024-03-05 15:04:37'),(23,'create_shipment','Created shipment for order',0,6,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(24,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2024-03-06 03:04:37','2024-03-06 03:04:37'),(25,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2024-03-06 03:04:37','2024-03-06 03:04:37'),(26,'confirm_payment','Payment was confirmed (amount $2,756.00) by %user_name%',0,7,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(27,'create_shipment','Created shipment for order',0,7,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(28,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,7,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(29,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2024-03-01 15:04:37','2024-03-01 15:04:37'),(30,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2024-03-01 15:04:37','2024-03-01 15:04:37'),(31,'confirm_payment','Payment was confirmed (amount $636.00) by %user_name%',0,8,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37'),(32,'create_shipment','Created shipment for order',0,8,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(33,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(34,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2024-03-08 01:04:38','2024-03-08 01:04:38'),(35,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2024-03-08 01:04:38','2024-03-08 01:04:38'),(36,'create_shipment','Created shipment for order',0,9,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(37,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,9,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(38,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2024-02-29 23:04:38','2024-02-29 23:04:38'),(39,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2024-02-29 23:04:38','2024-02-29 23:04:38'),(40,'create_shipment','Created shipment for order',0,10,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(41,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2024-03-09 11:04:38','2024-03-09 11:04:38'),(42,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2024-03-09 11:04:38','2024-03-09 11:04:38'),(43,'confirm_payment','Payment was confirmed (amount $2,062.00) by %user_name%',0,11,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(44,'create_shipment','Created shipment for order',0,11,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(45,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2024-03-09 19:04:38','2024-03-09 19:04:38'),(46,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2024-03-09 19:04:38','2024-03-09 19:04:38'),(47,'create_shipment','Created shipment for order',0,12,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(48,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2024-03-03 03:04:38','2024-03-03 03:04:38'),(49,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2024-03-03 03:04:38','2024-03-03 03:04:38'),(50,'create_shipment','Created shipment for order',0,13,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38'),(51,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2024-03-08 11:04:38','2024-03-08 11:04:38'),(52,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2024-03-08 11:04:38','2024-03-08 11:04:38'),(53,'confirm_payment','Payment was confirmed (amount $1,737.00) by %user_name%',0,14,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(54,'create_shipment','Created shipment for order',0,14,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(55,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2024-03-08 21:04:39','2024-03-08 21:04:39'),(56,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2024-03-08 21:04:39','2024-03-08 21:04:39'),(57,'confirm_payment','Payment was confirmed (amount $7,844.00) by %user_name%',0,15,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(58,'create_shipment','Created shipment for order',0,15,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(59,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2024-03-10 03:04:39','2024-03-10 03:04:39'),(60,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2024-03-10 03:04:39','2024-03-10 03:04:39'),(61,'confirm_payment','Payment was confirmed (amount $1,644.00) by %user_name%',0,16,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(62,'create_shipment','Created shipment for order',0,16,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(63,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,16,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(64,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2024-03-10 11:04:39','2024-03-10 11:04:39'),(65,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2024-03-10 11:04:39','2024-03-10 11:04:39'),(66,'confirm_payment','Payment was confirmed (amount $1,174.00) by %user_name%',0,17,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(67,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,17,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(68,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2024-03-05 19:04:39','2024-03-05 19:04:39'),(69,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2024-03-05 19:04:39','2024-03-05 19:04:39'),(70,'create_shipment','Created shipment for order',0,18,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(71,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2024-03-09 17:04:39','2024-03-09 17:04:39'),(72,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2024-03-09 17:04:39','2024-03-09 17:04:39'),(73,'confirm_payment','Payment was confirmed (amount $7,320.00) by %user_name%',0,19,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39'),(74,'create_shipment','Created shipment for order',0,19,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(75,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,19,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(76,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2024-03-11 21:04:40','2024-03-11 21:04:40'),(77,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2024-03-11 21:04:40','2024-03-11 21:04:40'),(78,'confirm_payment','Payment was confirmed (amount $2,622.00) by %user_name%',0,20,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(79,'create_shipment','Created shipment for order',0,20,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(80,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,20,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(81,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2024-03-06 11:04:40','2024-03-06 11:04:40'),(82,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2024-03-06 11:04:40','2024-03-06 11:04:40'),(83,'create_shipment','Created shipment for order',0,21,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(84,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2024-03-06 03:04:40','2024-03-06 03:04:40'),(85,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2024-03-06 03:04:40','2024-03-06 03:04:40'),(86,'create_shipment','Created shipment for order',0,22,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(87,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2024-03-13 03:04:40','2024-03-13 03:04:40'),(88,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2024-03-13 03:04:40','2024-03-13 03:04:40'),(89,'create_shipment','Created shipment for order',0,23,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(90,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(91,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2024-03-10 03:04:40','2024-03-10 03:04:40'),(92,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2024-03-10 03:04:40','2024-03-10 03:04:40'),(93,'confirm_payment','Payment was confirmed (amount $1,550.00) by %user_name%',0,24,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40'),(94,'create_shipment','Created shipment for order',0,24,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(95,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(96,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2024-03-14 03:04:41','2024-03-14 03:04:41'),(97,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2024-03-14 03:04:41','2024-03-14 03:04:41'),(98,'confirm_payment','Payment was confirmed (amount $1,644.00) by %user_name%',0,25,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(99,'create_shipment','Created shipment for order',0,25,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(100,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2024-03-10 13:04:41','2024-03-10 13:04:41'),(101,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2024-03-10 13:04:41','2024-03-10 13:04:41'),(102,'confirm_payment','Payment was confirmed (amount $1,287.00) by %user_name%',0,26,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(103,'create_shipment','Created shipment for order',0,26,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(104,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2024-03-13 07:04:41','2024-03-13 07:04:41'),(105,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2024-03-13 07:04:41','2024-03-13 07:04:41'),(106,'confirm_payment','Payment was confirmed (amount $3,110.00) by %user_name%',0,27,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(107,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,27,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(108,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2024-03-14 05:04:41','2024-03-14 05:04:41'),(109,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2024-03-14 05:04:41','2024-03-14 05:04:41'),(110,'confirm_payment','Payment was confirmed (amount $2,622.00) by %user_name%',0,28,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(111,'create_shipment','Created shipment for order',0,28,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(112,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2024-03-10 03:04:41','2024-03-10 03:04:41'),(113,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2024-03-10 03:04:41','2024-03-10 03:04:41'),(114,'confirm_payment','Payment was confirmed (amount $4,880.00) by %user_name%',0,29,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(115,'create_shipment','Created shipment for order',0,29,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41'),(116,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42'),(117,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2024-03-08 11:04:42','2024-03-08 11:04:42'),(118,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2024-03-08 11:04:42','2024-03-08 11:04:42'),(119,'confirm_payment','Payment was confirmed (amount $3,816.00) by %user_name%',0,30,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42'),(120,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,30,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42'),(121,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2024-03-06 19:04:42','2024-03-06 19:04:42'),(122,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2024-03-06 19:04:42','2024-03-06 19:04:42'),(123,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2024-03-09 07:04:42','2024-03-09 07:04:42'),(124,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2024-03-09 07:04:42','2024-03-09 07:04:42'),(125,'create_shipment','Created shipment for order',0,32,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42'),(126,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42'),(127,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2024-03-14 09:04:42','2024-03-14 09:04:42'),(128,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2024-03-14 09:04:42','2024-03-14 09:04:42'),(129,'create_shipment','Created shipment for order',0,33,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42'),(130,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2024-03-09 03:04:42','2024-03-09 03:04:42'),(131,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2024-03-09 03:04:42','2024-03-09 03:04:42'),(132,'confirm_payment','Payment was confirmed (amount $5,343.00) by %user_name%',0,34,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42'),(133,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,34,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(134,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2024-03-14 09:04:43','2024-03-14 09:04:43'),(135,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2024-03-14 09:04:43','2024-03-14 09:04:43'),(136,'confirm_payment','Payment was confirmed (amount $425.00) by %user_name%',0,35,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(137,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,35,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(138,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2024-03-10 15:04:43','2024-03-10 15:04:43'),(139,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2024-03-10 15:04:43','2024-03-10 15:04:43'),(140,'confirm_payment','Payment was confirmed (amount $513.00) by %user_name%',0,36,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(141,'create_shipment','Created shipment for order',0,36,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(142,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(143,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2024-03-10 11:04:43','2024-03-10 11:04:43'),(144,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2024-03-10 11:04:43','2024-03-10 11:04:43'),(145,'create_shipment','Created shipment for order',0,37,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(146,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2024-03-09 03:04:43','2024-03-09 03:04:43'),(147,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2024-03-09 03:04:43','2024-03-09 03:04:43'),(148,'confirm_payment','Payment was confirmed (amount $2,703.00) by %user_name%',0,38,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(149,'create_shipment','Created shipment for order',0,38,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43'),(150,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2024-03-11 03:04:43','2024-03-11 03:04:43'),(151,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2024-03-11 03:04:43','2024-03-11 03:04:43'),(152,'create_shipment','Created shipment for order',0,39,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(153,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(154,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2024-03-09 21:04:44','2024-03-09 21:04:44'),(155,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2024-03-09 21:04:44','2024-03-09 21:04:44'),(156,'confirm_payment','Payment was confirmed (amount $2,526.00) by %user_name%',0,40,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(157,'create_shipment','Created shipment for order',0,40,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(158,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(159,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2024-03-11 01:04:44','2024-03-11 01:04:44'),(160,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2024-03-11 01:04:44','2024-03-11 01:04:44'),(161,'confirm_payment','Payment was confirmed (amount $850.00) by %user_name%',0,41,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(162,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,41,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(163,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2024-03-09 07:04:44','2024-03-09 07:04:44'),(164,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2024-03-09 07:04:44','2024-03-09 07:04:44'),(165,'confirm_payment','Payment was confirmed (amount $302.00) by %user_name%',0,42,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(166,'create_shipment','Created shipment for order',0,42,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(167,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,42,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(168,'create_order_from_seeder','Order is created from the checkout page',NULL,43,NULL,'2024-03-13 03:04:44','2024-03-13 03:04:44'),(169,'confirm_order','Order was verified by %user_name%',0,43,NULL,'2024-03-13 03:04:44','2024-03-13 03:04:44'),(170,'create_shipment','Created shipment for order',0,43,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(171,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,43,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44'),(172,'create_order_from_seeder','Order is created from the checkout page',NULL,44,NULL,'2024-03-10 15:04:44','2024-03-10 15:04:44'),(173,'confirm_order','Order was verified by %user_name%',0,44,NULL,'2024-03-10 15:04:44','2024-03-10 15:04:44'),(174,'create_order_from_seeder','Order is created from the checkout page',NULL,45,NULL,'2024-03-12 03:04:45','2024-03-12 03:04:45'),(175,'confirm_order','Order was verified by %user_name%',0,45,NULL,'2024-03-12 03:04:45','2024-03-12 03:04:45'),(176,'confirm_payment','Payment was confirmed (amount $5,211.00) by %user_name%',0,45,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(177,'create_shipment','Created shipment for order',0,45,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(178,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,45,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(179,'create_order_from_seeder','Order is created from the checkout page',NULL,46,NULL,'2024-03-12 05:04:45','2024-03-12 05:04:45'),(180,'confirm_order','Order was verified by %user_name%',0,46,NULL,'2024-03-12 05:04:45','2024-03-12 05:04:45'),(181,'confirm_payment','Payment was confirmed (amount $5,343.00) by %user_name%',0,46,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(182,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,46,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(183,'create_order_from_seeder','Order is created from the checkout page',NULL,47,NULL,'2024-03-11 09:04:45','2024-03-11 09:04:45'),(184,'confirm_order','Order was verified by %user_name%',0,47,NULL,'2024-03-11 09:04:45','2024-03-11 09:04:45'),(185,'confirm_payment','Payment was confirmed (amount $2,451.00) by %user_name%',0,47,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(186,'create_shipment','Created shipment for order',0,47,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(187,'create_order_from_seeder','Order is created from the checkout page',NULL,48,NULL,'2024-03-13 11:04:45','2024-03-13 11:04:45'),(188,'confirm_order','Order was verified by %user_name%',0,48,NULL,'2024-03-13 11:04:45','2024-03-13 11:04:45'),(189,'confirm_payment','Payment was confirmed (amount $3,488.00) by %user_name%',0,48,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(190,'create_shipment','Created shipment for order',0,48,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(191,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,48,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(192,'create_order_from_seeder','Order is created from the checkout page',NULL,49,NULL,'2024-03-10 23:04:45','2024-03-10 23:04:45'),(193,'confirm_order','Order was verified by %user_name%',0,49,NULL,'2024-03-10 23:04:45','2024-03-10 23:04:45'),(194,'confirm_payment','Payment was confirmed (amount $1,998.00) by %user_name%',0,49,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45'),(195,'create_shipment','Created shipment for order',0,49,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(196,'create_order_from_seeder','Order is created from the checkout page',NULL,50,NULL,'2024-03-14 03:04:46','2024-03-14 03:04:46'),(197,'confirm_order','Order was verified by %user_name%',0,50,NULL,'2024-03-14 03:04:46','2024-03-14 03:04:46'),(198,'confirm_payment','Payment was confirmed (amount $3,474.00) by %user_name%',0,50,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(199,'create_shipment','Created shipment for order',0,50,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(200,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,50,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(201,'create_order_from_seeder','Order is created from the checkout page',NULL,51,NULL,'2024-03-13 19:04:46','2024-03-13 19:04:46'),(202,'confirm_order','Order was verified by %user_name%',0,51,NULL,'2024-03-13 19:04:46','2024-03-13 19:04:46'),(203,'confirm_payment','Payment was confirmed (amount $1,562.00) by %user_name%',0,51,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(204,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,51,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(205,'create_order_from_seeder','Order is created from the checkout page',NULL,52,NULL,'2024-03-12 11:04:46','2024-03-12 11:04:46'),(206,'confirm_order','Order was verified by %user_name%',0,52,NULL,'2024-03-12 11:04:46','2024-03-12 11:04:46'),(207,'confirm_payment','Payment was confirmed (amount $2,385.00) by %user_name%',0,52,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(208,'create_shipment','Created shipment for order',0,52,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(209,'create_order_from_seeder','Order is created from the checkout page',NULL,53,NULL,'2024-03-12 15:04:46','2024-03-12 15:04:46'),(210,'confirm_order','Order was verified by %user_name%',0,53,NULL,'2024-03-12 15:04:46','2024-03-12 15:04:46'),(211,'confirm_payment','Payment was confirmed (amount $3,642.00) by %user_name%',0,53,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(212,'create_shipment','Created shipment for order',0,53,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(213,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,53,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(214,'create_order_from_seeder','Order is created from the checkout page',NULL,54,NULL,'2024-03-12 15:04:46','2024-03-12 15:04:46'),(215,'confirm_order','Order was verified by %user_name%',0,54,NULL,'2024-03-12 15:04:46','2024-03-12 15:04:46'),(216,'confirm_payment','Payment was confirmed (amount $4,947.00) by %user_name%',0,54,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(217,'create_shipment','Created shipment for order',0,54,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46'),(218,'create_order_from_seeder','Order is created from the checkout page',NULL,55,NULL,'2024-03-12 15:04:46','2024-03-12 15:04:46'),(219,'confirm_order','Order was verified by %user_name%',0,55,NULL,'2024-03-12 15:04:46','2024-03-12 15:04:46'),(220,'confirm_payment','Payment was confirmed (amount $4,836.00) by %user_name%',0,55,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(221,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,55,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(222,'create_order_from_seeder','Order is created from the checkout page',NULL,56,NULL,'2024-03-13 15:04:47','2024-03-13 15:04:47'),(223,'confirm_order','Order was verified by %user_name%',0,56,NULL,'2024-03-13 15:04:47','2024-03-13 15:04:47'),(224,'confirm_payment','Payment was confirmed (amount $1,722.00) by %user_name%',0,56,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(225,'create_shipment','Created shipment for order',0,56,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(226,'create_order_from_seeder','Order is created from the checkout page',NULL,57,NULL,'2024-03-14 15:04:47','2024-03-14 15:04:47'),(227,'confirm_order','Order was verified by %user_name%',0,57,NULL,'2024-03-14 15:04:47','2024-03-14 15:04:47'),(228,'confirm_payment','Payment was confirmed (amount $2,005.00) by %user_name%',0,57,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(229,'create_shipment','Created shipment for order',0,57,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(230,'create_order_from_seeder','Order is created from the checkout page',NULL,58,NULL,'2024-03-14 19:04:47','2024-03-14 19:04:47'),(231,'confirm_order','Order was verified by %user_name%',0,58,NULL,'2024-03-14 19:04:47','2024-03-14 19:04:47'),(232,'confirm_payment','Payment was confirmed (amount $587.00) by %user_name%',0,58,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(233,'update_status','Changed status of shipping to: . Updated by: %user_name%',0,58,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(234,'create_order_from_seeder','Order is created from the checkout page',NULL,59,NULL,'2024-03-14 13:04:47','2024-03-14 13:04:47'),(235,'confirm_order','Order was verified by %user_name%',0,59,NULL,'2024-03-14 13:04:47','2024-03-14 13:04:47'),(236,'confirm_payment','Payment was confirmed (amount $4,932.00) by %user_name%',0,59,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47'),(237,'create_shipment','Created shipment for order',0,59,NULL,'2024-03-15 03:04:48','2024-03-15 03:04:48'),(238,'update_status','Order confirmed by %user_name%',0,1,NULL,'2024-03-15 03:04:48','2024-03-15 03:04:48'),(239,'update_status','Order confirmed by %user_name%',0,2,NULL,'2024-03-15 03:04:48','2024-03-15 03:04:48'),(240,'update_status','Order confirmed by %user_name%',0,7,NULL,'2024-03-15 03:04:49','2024-03-15 03:04:49'),(241,'update_status','Order confirmed by %user_name%',0,8,NULL,'2024-03-15 03:04:49','2024-03-15 03:04:49'),(242,'update_status','Order confirmed by %user_name%',0,16,NULL,'2024-03-15 03:04:50','2024-03-15 03:04:50'),(243,'update_status','Order confirmed by %user_name%',0,19,NULL,'2024-03-15 03:04:50','2024-03-15 03:04:50'),(244,'update_status','Order confirmed by %user_name%',0,20,NULL,'2024-03-15 03:04:51','2024-03-15 03:04:51'),(245,'update_status','Order confirmed by %user_name%',0,24,NULL,'2024-03-15 03:04:51','2024-03-15 03:04:51'),(246,'update_status','Order confirmed by %user_name%',0,29,NULL,'2024-03-15 03:04:52','2024-03-15 03:04:52'),(247,'update_status','Order confirmed by %user_name%',0,36,NULL,'2024-03-15 03:04:52','2024-03-15 03:04:52'),(248,'update_status','Order confirmed by %user_name%',0,40,NULL,'2024-03-15 03:04:53','2024-03-15 03:04:53'),(249,'update_status','Order confirmed by %user_name%',0,42,NULL,'2024-03-15 03:04:53','2024-03-15 03:04:53'),(250,'update_status','Order confirmed by %user_name%',0,45,NULL,'2024-03-15 03:04:54','2024-03-15 03:04:54'),(251,'update_status','Order confirmed by %user_name%',0,48,NULL,'2024-03-15 03:04:55','2024-03-15 03:04:55'),(252,'update_status','Order confirmed by %user_name%',0,50,NULL,'2024-03-15 03:04:55','2024-03-15 03:04:55'),(253,'update_status','Order confirmed by %user_name%',0,53,NULL,'2024-03-15 03:04:56','2024-03-15 03:04:56');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,2,874.00,0.00,'{\"sku\":\"0V-138-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 4KG)\"}',NULL,104,'Retro Cat-Eye Sunglasses','jewelry/products/product-1.png',1610.00,0,'2024-03-15 03:04:36','2024-03-15 03:04:36','physical',0,NULL),(2,2,1,318.00,0.00,'{\"sku\":\"TO-194-A0-A3\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,127,'Embellished Ballet Flats','jewelry/products/product-2.png',793.00,0,'2024-03-15 03:04:36','2024-03-15 03:04:36','physical',0,NULL),(3,3,2,795.00,0.00,'{\"sku\":\"LX-115-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}',NULL,150,'Metallic Pleated Maxi Skirt','jewelry/products/product-2.png',1304.00,0,'2024-03-15 03:04:36','2024-03-15 03:04:36','physical',0,NULL),(4,4,3,1781.00,0.00,'{\"sku\":\"VV-152-A0\",\"attributes\":\"(Color: Green, Size: L)\"}',NULL,47,'Knit Turtleneck Sweater (Digital)','jewelry/products/product-2.png',2211.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','digital',10,NULL),(5,5,2,817.00,0.00,'{\"sku\":\"JA-179-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,50,'Classic Aviator Sunglasses','jewelry/products/product-3.png',1452.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','physical',0,NULL),(6,6,1,579.00,0.00,'{\"sku\":\"QE-163-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,108,'Faux Fur Trimmed Coat','jewelry/products/product-5.png',899.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','physical',0,NULL),(7,7,2,1378.00,0.00,'{\"sku\":\"7A-136-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}',NULL,112,'Ruffled Wrap Dress','jewelry/products/product-4.png',1580.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','physical',0,NULL),(8,8,2,318.00,0.00,'{\"sku\":\"TO-194-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 2 Boxes)\"}',NULL,125,'Embellished Ballet Flats','jewelry/products/product-8.png',1586.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','physical',0,NULL),(9,9,1,2306.00,0.00,'{\"sku\":\"NW-157-A0-A1\",\"attributes\":\"(Color: Red, Size: L)\"}',NULL,82,'Cotton Striped T-Shirt Dress','jewelry/products/product-5.png',765.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','physical',0,NULL),(10,9,2,2305.00,0.00,'{\"sku\":\"B4-149-A0\",\"attributes\":\"(Boxes: 3 Boxes, Weight: 4KG)\"}',NULL,110,'Boho Fringed Kimono (Digital)','jewelry/products/product-4.png',1142.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','digital',5,NULL),(11,10,3,1737.00,0.00,'{\"sku\":\"F5-146-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,130,'Velour Tracksuit Set','jewelry/products/product-5.png',2451.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','physical',0,NULL),(12,11,1,2062.00,0.00,'{\"sku\":\"IK-105-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,136,'Embroidered Bomber Jacket','jewelry/products/product-5.png',674.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','physical',0,NULL),(13,12,2,1744.00,0.00,'{\"sku\":\"MJ-187-A0-A2\",\"attributes\":\"(Size: L, Color: Brown)\"}',NULL,93,'Off-Shoulder Ruffle Top','jewelry/products/product-5.png',1794.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','physical',0,NULL),(14,12,3,2418.00,0.00,'{\"sku\":\"Z7-188-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 3KG)\"}',NULL,142,'Chunky Knit Infinity Scarf (Digital)','jewelry/products/product-4.png',2481.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','digital',4,NULL),(15,13,2,775.00,0.00,'{\"sku\":\"DM-189-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,117,'Beaded Evening Clutch','jewelry/products/product-8.png',1400.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','physical',0,NULL),(16,14,1,1737.00,0.00,'{\"sku\":\"F5-146-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,131,'Velour Tracksuit Set','jewelry/products/product-1.png',817.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','physical',0,NULL),(17,15,1,1961.00,0.00,'{\"sku\":\"DA-123-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 2KG)\"}',NULL,118,'Wide Brim Floppy Hat','jewelry/products/product-3.png',505.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','physical',0,NULL),(18,15,3,1961.00,0.00,'{\"sku\":\"DA-123-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,119,'Wide Brim Floppy Hat','jewelry/products/product-2.png',1515.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','physical',0,NULL),(19,16,1,1644.00,0.00,'{\"sku\":\"GR-126-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,148,'Faux Leather Leggings','jewelry/products/product-8.png',546.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','physical',0,NULL),(20,17,2,587.00,0.00,'{\"sku\":\"IL-161-A0-A3\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,68,'Chic Fedora Hat (Digital)','jewelry/products/product-7.png',1230.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','digital',3,NULL),(21,18,3,1821.00,0.00,'{\"sku\":\"VH-154-A0-A1\",\"attributes\":\"(Color: Green, Size: M)\"}',NULL,74,'Quilted Crossbody Bag','jewelry/products/product-2.png',1581.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','physical',0,NULL),(22,19,3,2440.00,0.00,'{\"sku\":\"2Q-144-A0\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,53,'Bohemian Fringe Handbag','jewelry/products/product-6.png',2112.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','physical',0,NULL),(23,20,3,874.00,0.00,'{\"sku\":\"0V-138-A0-A4\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,107,'Retro Cat-Eye Sunglasses','jewelry/products/product-2.png',2415.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','physical',0,NULL),(24,21,3,1737.00,0.00,'{\"sku\":\"F5-146-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,130,'Velour Tracksuit Set','jewelry/products/product-5.png',2451.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','physical',0,NULL),(25,22,2,761.00,0.00,'{\"sku\":\"XO-112-A0\",\"attributes\":\"(Color: Green, Size: M)\"}',NULL,63,'Statement Chunky Necklace','jewelry/products/product-3.png',1756.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','physical',0,NULL),(26,23,3,1706.00,0.00,'{\"sku\":\"XE-152-A0\",\"attributes\":\"(Color: Blue, Size: L)\"}',NULL,85,'Printed Palazzo Pants','jewelry/products/product-4.png',2448.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','physical',0,NULL),(27,24,2,775.00,0.00,'{\"sku\":\"DM-189-A0\",\"attributes\":\"(Boxes: 1 Box, Weight: 5KG)\"}',NULL,116,'Beaded Evening Clutch','jewelry/products/product-7.png',1400.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','physical',0,NULL),(28,25,1,1644.00,0.00,'{\"sku\":\"GR-126-A0-A2\",\"attributes\":\"(Weight: 1KG, Boxes: 5 Boxes)\"}',NULL,148,'Faux Leather Leggings','jewelry/products/product-8.png',546.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','physical',0,NULL),(29,26,1,1287.00,0.00,'{\"sku\":\"QT-132-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}',NULL,45,'Floral Maxi Dress','jewelry/products/product-2.png',577.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','physical',0,NULL),(30,27,2,1555.00,0.00,'{\"sku\":\"GH-176-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 3 Boxes)\"}',NULL,97,'Athleisure Jogger Pants (Digital)','jewelry/products/product-6.png',1008.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','digital',10,NULL),(31,28,3,874.00,0.00,'{\"sku\":\"0V-138-A0\",\"attributes\":\"(Weight: 1KG, Boxes: 1 Box)\"}',NULL,103,'Retro Cat-Eye Sunglasses','jewelry/products/product-6.png',2415.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','physical',0,NULL),(32,29,2,2440.00,0.00,'{\"sku\":\"2Q-144-A0\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,53,'Bohemian Fringe Handbag','jewelry/products/product-6.png',1408.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','physical',0,NULL),(33,30,2,1908.00,0.00,'{\"sku\":\"SW-162-A0-A3\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,79,'Distressed Skinny Jeans (Digital)','jewelry/products/product-5.png',1572.00,0,'2024-03-15 03:04:42','2024-03-15 03:04:42','digital',4,NULL),(34,31,2,425.00,0.00,'{\"sku\":\"ON-156-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,90,'Structured Satchel Bag (Digital)','jewelry/products/product-2.png',1618.00,0,'2024-03-15 03:04:42','2024-03-15 03:04:42','digital',1,NULL),(35,32,2,579.00,0.00,'{\"sku\":\"QE-163-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 4 Boxes)\"}',NULL,108,'Faux Fur Trimmed Coat','jewelry/products/product-5.png',1798.00,0,'2024-03-15 03:04:42','2024-03-15 03:04:42','physical',0,NULL),(36,33,1,1287.00,0.00,'{\"sku\":\"QT-132-A0\",\"attributes\":\"(Size: S, Color: Blue)\"}',NULL,45,'Floral Maxi Dress','jewelry/products/product-2.png',577.00,0,'2024-03-15 03:04:42','2024-03-15 03:04:42','physical',0,NULL),(37,34,3,1781.00,0.00,'{\"sku\":\"VV-152-A0\",\"attributes\":\"(Color: Green, Size: L)\"}',NULL,47,'Knit Turtleneck Sweater (Digital)','jewelry/products/product-2.png',2211.00,0,'2024-03-15 03:04:42','2024-03-15 03:04:42','digital',3,NULL),(38,35,1,425.00,0.00,'{\"sku\":\"ON-156-A0-A2\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,90,'Structured Satchel Bag (Digital)','jewelry/products/product-2.png',809.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','digital',3,NULL),(39,36,1,513.00,0.00,'{\"sku\":\"LQ-100-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}',NULL,128,'Pleated Midi Skirt','jewelry/products/product-8.png',583.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','physical',0,NULL),(40,37,1,2440.00,0.00,'{\"sku\":\"2Q-144-A0\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,53,'Bohemian Fringe Handbag','jewelry/products/product-6.png',704.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','physical',0,NULL),(41,38,2,574.00,0.00,'{\"sku\":\"BH-124-A0-A3\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,62,'Embroidered Boho Blouse','jewelry/products/product-8.png',1054.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','physical',0,NULL),(42,38,1,1555.00,0.00,'{\"sku\":\"GH-176-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 2 Boxes)\"}',NULL,98,'Athleisure Jogger Pants (Digital)','jewelry/products/product-3.png',504.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','digital',9,NULL),(43,39,3,513.00,0.00,'{\"sku\":\"LQ-100-A0-A1\",\"attributes\":\"(Weight: 2KG, Boxes: 5 Boxes)\"}',NULL,129,'Pleated Midi Skirt','jewelry/products/product-4.png',1749.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','physical',0,NULL),(44,40,2,574.00,0.00,'{\"sku\":\"BH-124-A0-A1\",\"attributes\":\"(Color: Red, Size: XXL)\"}',NULL,60,'Embroidered Boho Blouse','jewelry/products/product-4.png',1054.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','physical',0,NULL),(45,40,1,1378.00,0.00,'{\"sku\":\"7A-136-A0-A1\",\"attributes\":\"(Boxes: 4 Boxes, Weight: 5KG)\"}',NULL,113,'Ruffled Wrap Dress','jewelry/products/product-6.png',790.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','physical',0,NULL),(46,41,2,425.00,0.00,'{\"sku\":\"ON-156-A0-A1\",\"attributes\":\"(Size: S, Color: Red)\"}',NULL,89,'Structured Satchel Bag (Digital)','jewelry/products/product-7.png',1618.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','digital',7,NULL),(47,42,1,302.00,0.00,'{\"sku\":\"X8-116-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}',NULL,135,'Buckle Detail Ankle Booties','jewelry/products/product-7.png',654.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','physical',0,NULL),(48,43,2,1378.00,0.00,'{\"sku\":\"7A-136-A0-A3\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,115,'Ruffled Wrap Dress','jewelry/products/product-2.png',1580.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','physical',0,NULL),(49,44,3,441.00,0.00,'{\"sku\":\"ZP-152-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,121,'Denim Overall Jumpsuit (Digital)','jewelry/products/product-3.png',2016.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','digital',0,NULL),(50,45,3,1737.00,0.00,'{\"sku\":\"F5-146-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,131,'Velour Tracksuit Set','jewelry/products/product-1.png',2451.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','physical',0,NULL),(51,46,3,1781.00,0.00,'{\"sku\":\"VV-152-A0-A2\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,49,'Knit Turtleneck Sweater (Digital)','jewelry/products/product-3.png',2211.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','digital',2,NULL),(52,47,3,817.00,0.00,'{\"sku\":\"JA-179-A0\",\"attributes\":\"(Size: XL, Color: Brown)\"}',NULL,50,'Classic Aviator Sunglasses','jewelry/products/product-3.png',2178.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','physical',0,NULL),(53,48,2,1744.00,0.00,'{\"sku\":\"MJ-187-A0\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,91,'Off-Shoulder Ruffle Top','jewelry/products/product-7.png',1794.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','physical',0,NULL),(54,49,3,666.00,0.00,'{\"sku\":\"OA-178-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,101,'Leopard Print Midi Skirt','jewelry/products/product-6.png',1704.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','physical',0,NULL),(55,50,2,1737.00,0.00,'{\"sku\":\"F5-146-A0-A1\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,131,'Velour Tracksuit Set','jewelry/products/product-1.png',1634.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','physical',0,NULL),(56,51,2,781.00,0.00,'{\"sku\":\"HN-174-A0\",\"attributes\":\"(Boxes: 2 Boxes, Weight: 5KG)\"}',NULL,132,'Geometric Patterned Cardigan (Digital)','jewelry/products/product-1.png',1034.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','digital',6,NULL),(57,52,3,795.00,0.00,'{\"sku\":\"LX-115-A0\",\"attributes\":\"(Weight: 3KG, Boxes: 5 Boxes)\"}',NULL,150,'Metallic Pleated Maxi Skirt','jewelry/products/product-2.png',1956.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','physical',0,NULL),(58,53,2,1821.00,0.00,'{\"sku\":\"VH-154-A0\",\"attributes\":\"(Color: Blue, Size: XL)\"}',NULL,73,'Quilted Crossbody Bag','jewelry/products/product-8.png',1054.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','physical',0,NULL),(59,54,3,874.00,0.00,'{\"sku\":\"0V-138-A0-A2\",\"attributes\":\"(Weight: 4KG, Boxes: 5 Boxes)\"}',NULL,105,'Retro Cat-Eye Sunglasses','jewelry/products/product-8.png',2415.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','physical',0,NULL),(60,54,3,775.00,0.00,'{\"sku\":\"DM-189-A0-A1\",\"attributes\":\"(Weight: 5KG, Boxes: 5 Boxes)\"}',NULL,117,'Beaded Evening Clutch','jewelry/products/product-8.png',2100.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','physical',0,NULL),(61,55,2,2418.00,0.00,'{\"sku\":\"Z7-188-A0-A2\",\"attributes\":\"(Weight: 3KG, Boxes: 4 Boxes)\"}',NULL,143,'Chunky Knit Infinity Scarf (Digital)','jewelry/products/product-5.png',1654.00,0,'2024-03-15 03:04:47','2024-03-15 03:04:47','digital',2,NULL),(62,56,3,574.00,0.00,'{\"sku\":\"BH-124-A0-A3\",\"attributes\":\"(Size: S, Color: Black)\"}',NULL,62,'Embroidered Boho Blouse','jewelry/products/product-8.png',1581.00,0,'2024-03-15 03:04:47','2024-03-15 03:04:47','physical',0,NULL),(63,57,1,2005.00,0.00,'{\"sku\":\"LW-110-A0\",\"attributes\":\"(Weight: 2KG, Boxes: 3 Boxes)\"}',NULL,145,'Retro High-Top Sneakers','jewelry/products/product-1.png',840.00,0,'2024-03-15 03:04:47','2024-03-15 03:04:47','physical',0,NULL),(64,58,1,587.00,0.00,'{\"sku\":\"IL-161-A0-A3\",\"attributes\":\"(Size: M, Color: Black)\"}',NULL,68,'Chic Fedora Hat (Digital)','jewelry/products/product-7.png',615.00,0,'2024-03-15 03:04:47','2024-03-15 03:04:47','digital',2,NULL),(65,59,3,1644.00,0.00,'{\"sku\":\"GR-126-A0-A1\",\"attributes\":\"(Weight: 1KG, Boxes: 4 Boxes)\"}',NULL,147,'Faux Leather Leggings','jewelry/products/product-7.png',1638.00,0,'2024-03-15 03:04:47','2024-03-15 03:04:47','physical',0,NULL);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` bigint unsigned DEFAULT NULL,
  `proof_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',9,'1','default','completed',1748.00,0.00,0.00,NULL,NULL,0.00,1748.00,1,NULL,1,'2024-03-15 03:04:48','3P8YXfBuxT1sjfYISF663d8f9Yvhy',1,'2024-02-29 03:04:36','2024-03-15 03:04:48',4,NULL),(2,'#10000002',9,'1','default','completed',318.00,0.00,0.00,NULL,NULL,0.00,318.00,1,NULL,1,'2024-03-15 03:04:48','7sJaSpp8YN9DwSKUqiQgpiuQXIzf7',2,'2024-03-13 11:04:36','2024-03-15 03:04:48',3,NULL),(3,'#10000003',9,'1','default','pending',1590.00,0.00,0.00,NULL,NULL,0.00,1590.00,1,NULL,1,NULL,'znNbjMzU1jQy0ccMb9HiUgA3Z1BJM',3,'2024-02-29 03:04:36','2024-03-15 03:04:36',7,NULL),(4,'#10000004',10,NULL,'','pending',5343.00,0.00,0.00,NULL,NULL,0.00,5343.00,1,NULL,1,NULL,'dGvHb8sFFuEPP0cpPvwTWeDHJO4Sf',4,'2024-02-29 21:04:37','2024-03-15 03:04:37',2,NULL),(5,'#10000005',10,'1','default','pending',1634.00,0.00,0.00,NULL,NULL,0.00,1634.00,1,NULL,1,NULL,'pqnWebX1keb9peRJHFJnEA4FOvVdR',5,'2024-03-08 19:04:37','2024-03-15 03:04:37',4,NULL),(6,'#10000006',10,'1','default','pending',579.00,0.00,0.00,NULL,NULL,0.00,579.00,1,NULL,1,NULL,'vQ3OgaFLEiaCz63UeGq2CJzFBzs9v',6,'2024-03-05 15:04:37','2024-03-15 03:04:37',3,NULL),(7,'#10000007',9,'1','default','completed',2756.00,0.00,0.00,NULL,NULL,0.00,2756.00,1,NULL,1,'2024-03-15 03:04:49','ECD32cDJamU7SH6n0srae3uI1mvLC',7,'2024-03-06 03:04:37','2024-03-15 03:04:49',6,NULL),(8,'#10000008',9,'1','default','completed',636.00,0.00,0.00,NULL,NULL,0.00,636.00,1,NULL,1,'2024-03-15 03:04:49','w3QgAlx6SGlKi1pEVo5sr3gjq39Nl',8,'2024-03-01 15:04:37','2024-03-15 03:04:49',3,NULL),(9,'#10000009',9,'1','default','completed',6916.00,0.00,0.00,NULL,NULL,0.00,6916.00,1,NULL,1,'2024-03-15 03:04:38','TGqTIrc0iEGAeM3KeJMNecfd6MApb',9,'2024-03-08 01:04:38','2024-03-15 03:04:38',4,NULL),(10,'#10000010',9,'1','default','pending',5211.00,0.00,0.00,NULL,NULL,0.00,5211.00,1,NULL,1,NULL,'s30rpsGtDx00kWIcMTNiV3ITqv4Ka',10,'2024-02-29 23:04:38','2024-03-15 03:04:38',5,NULL),(11,'#10000011',9,'1','default','pending',2062.00,0.00,0.00,NULL,NULL,0.00,2062.00,1,NULL,1,NULL,'NDEfZYKSP98EXxScTrvcOkmElA3fO',11,'2024-03-09 11:04:38','2024-03-15 03:04:38',1,NULL),(12,'#10000012',9,'1','default','pending',10742.00,0.00,0.00,NULL,NULL,0.00,10742.00,1,NULL,1,NULL,'mdRXU44AYF5bJM8v1iWb8wn3nmMGw',12,'2024-03-09 19:04:38','2024-03-15 03:04:38',1,NULL),(13,'#10000013',9,'1','default','pending',1550.00,0.00,0.00,NULL,NULL,0.00,1550.00,1,NULL,1,NULL,'D039Mbwg9dbv1fScdY2zusBTFzYwk',13,'2024-03-03 03:04:38','2024-03-15 03:04:38',4,NULL),(14,'#10000014',9,'1','default','pending',1737.00,0.00,0.00,NULL,NULL,0.00,1737.00,1,NULL,1,NULL,'bLvoHDEz0w6GM0LPdBuU7VgAq7ZkT',14,'2024-03-08 11:04:38','2024-03-15 03:04:39',5,NULL),(15,'#10000015',9,'1','default','pending',7844.00,0.00,0.00,NULL,NULL,0.00,7844.00,1,NULL,1,NULL,'pDHyG9zVGicEy9ZHbbEekd109XSSi',15,'2024-03-08 21:04:39','2024-03-15 03:04:39',6,NULL),(16,'#10000016',9,'1','default','completed',1644.00,0.00,0.00,NULL,NULL,0.00,1644.00,1,NULL,1,'2024-03-15 03:04:50','iNSnX0ZcAP6nS2J0WahnGooGjvjGu',16,'2024-03-10 03:04:39','2024-03-15 03:04:50',2,NULL),(17,'#10000017',10,NULL,'','completed',1174.00,0.00,0.00,NULL,NULL,0.00,1174.00,1,NULL,1,'2024-03-15 03:04:39','4x5utePpgcBiRJ6623JATt4zf2Q4q',17,'2024-03-10 11:04:39','2024-03-15 03:04:39',3,NULL),(18,'#10000018',10,'1','default','pending',5463.00,0.00,0.00,NULL,NULL,0.00,5463.00,1,NULL,1,NULL,'meLf1rXjJ2MBStB79xP7Q3hhGL2pf',18,'2024-03-05 19:04:39','2024-03-15 03:04:39',8,NULL),(19,'#10000019',9,'1','default','completed',7320.00,0.00,0.00,NULL,NULL,0.00,7320.00,1,NULL,1,'2024-03-15 03:04:50','aNq0IyEnZ7XP3ANDf6wmpHGvT6ETt',19,'2024-03-09 17:04:39','2024-03-15 03:04:50',1,NULL),(20,'#10000020',9,'1','default','completed',2622.00,0.00,0.00,NULL,NULL,0.00,2622.00,1,NULL,1,'2024-03-15 03:04:51','skjrgCtmbSdYZ8QltznHVrVfrBEDs',20,'2024-03-11 21:04:40','2024-03-15 03:04:51',4,NULL),(21,'#10000021',9,'1','default','pending',5211.00,0.00,0.00,NULL,NULL,0.00,5211.00,1,NULL,1,NULL,'rYfyMOu6abLRodBCw2ZVfpGKSqFET',21,'2024-03-06 11:04:40','2024-03-15 03:04:40',5,NULL),(22,'#10000022',10,'1','default','pending',1522.00,0.00,0.00,NULL,NULL,0.00,1522.00,1,NULL,1,NULL,'KzS8zFWvzcSyvhlIPDX2b9KXV2UxK',22,'2024-03-06 03:04:40','2024-03-15 03:04:40',7,NULL),(23,'#10000023',10,'1','default','completed',5118.00,0.00,0.00,NULL,NULL,0.00,5118.00,1,NULL,1,'2024-03-15 03:04:40','k34caiqez2EFkJAXdeEs3h6otq3SZ',23,'2024-03-13 03:04:40','2024-03-15 03:04:40',8,NULL),(24,'#10000024',10,'1','default','completed',1550.00,0.00,0.00,NULL,NULL,0.00,1550.00,1,NULL,1,'2024-03-15 03:04:51','AtyzDcQY6PH6DITIo4xG1QXvXAYZE',24,'2024-03-10 03:04:40','2024-03-15 03:04:51',4,NULL),(25,'#10000025',10,'1','default','pending',1644.00,0.00,0.00,NULL,NULL,0.00,1644.00,1,NULL,1,NULL,'qfID7RpQiDkmdl11lEgAC5QO3Ae2H',25,'2024-03-14 03:04:41','2024-03-15 03:04:41',2,NULL),(26,'#10000026',9,'1','default','pending',1287.00,0.00,0.00,NULL,NULL,0.00,1287.00,1,NULL,1,NULL,'O0PnKPBwOFVcOwXzSSm9ayietbtJU',26,'2024-03-10 13:04:41','2024-03-15 03:04:41',5,NULL),(27,'#10000027',9,NULL,'','completed',3110.00,0.00,0.00,NULL,NULL,0.00,3110.00,1,NULL,1,'2024-03-15 03:04:41','0bXxbEtd7xmJIlG2J9YddB1IINU4C',27,'2024-03-13 07:04:41','2024-03-15 03:04:41',6,NULL),(28,'#10000028',9,'1','default','pending',2622.00,0.00,0.00,NULL,NULL,0.00,2622.00,1,NULL,1,NULL,'fIpi2k3XQX9spnuEZiZ3rFZK5IkAZ',28,'2024-03-14 05:04:41','2024-03-15 03:04:41',4,NULL),(29,'#10000029',9,'1','default','completed',4880.00,0.00,0.00,NULL,NULL,0.00,4880.00,1,NULL,1,'2024-03-15 03:04:52','EziltJxHlOAcKxYZgrTeCYRmIYi7H',29,'2024-03-10 03:04:41','2024-03-15 03:04:52',1,NULL),(30,'#10000030',9,NULL,'','completed',3816.00,0.00,0.00,NULL,NULL,0.00,3816.00,1,NULL,1,'2024-03-15 03:04:42','l9JmCR937kU9gzk1BntlXkIOVJuPQ',30,'2024-03-08 11:04:42','2024-03-15 03:04:42',8,NULL),(31,'#10000031',9,NULL,'','pending',850.00,0.00,0.00,NULL,NULL,0.00,850.00,1,NULL,1,NULL,'ZutCvFJWJ5a5sRuQFfLBJ8kPpvN36',31,'2024-03-06 19:04:42','2024-03-15 03:04:42',4,NULL),(32,'#10000032',9,'1','default','completed',1158.00,0.00,0.00,NULL,NULL,0.00,1158.00,1,NULL,1,'2024-03-15 03:04:42','llI5NgHV4yBxfrcsGXDhUPblOgspV',32,'2024-03-09 07:04:42','2024-03-15 03:04:42',3,NULL),(33,'#10000033',9,'1','default','pending',1287.00,0.00,0.00,NULL,NULL,0.00,1287.00,1,NULL,1,NULL,'yCMl2YQ1BxNqGLJPhX2vawu5EiDQ8',33,'2024-03-14 09:04:42','2024-03-15 03:04:42',5,NULL),(34,'#10000034',9,NULL,'','completed',5343.00,0.00,0.00,NULL,NULL,0.00,5343.00,1,NULL,1,'2024-03-15 03:04:43','PRYbLea1pgWEcnD4OOfDEWwxXlznf',34,'2024-03-09 03:04:42','2024-03-15 03:04:43',2,NULL),(35,'#10000035',9,NULL,'','completed',425.00,0.00,0.00,NULL,NULL,0.00,425.00,1,NULL,1,'2024-03-15 03:04:43','MszfV5lpQlP6P6j25bn7834Cee84i',35,'2024-03-14 09:04:43','2024-03-15 03:04:43',4,NULL),(36,'#10000036',9,'1','default','completed',513.00,0.00,0.00,NULL,NULL,0.00,513.00,1,NULL,1,'2024-03-15 03:04:52','idl5pZahthNrWKqPgnIZWJBlL9wqm',36,'2024-03-10 15:04:43','2024-03-15 03:04:52',3,NULL),(37,'#10000037',10,'1','default','pending',2440.00,0.00,0.00,NULL,NULL,0.00,2440.00,1,NULL,1,NULL,'FjAyBY7zogiSmyiqgFr82RAKEVlRl',37,'2024-03-10 11:04:43','2024-03-15 03:04:43',1,NULL),(38,'#10000038',10,'1','default','pending',2703.00,0.00,0.00,NULL,NULL,0.00,2703.00,1,NULL,1,NULL,'UCU2W450sHpGBpczZnhKFfIIrDGfl',38,'2024-03-09 03:04:43','2024-03-15 03:04:43',6,NULL),(39,'#10000039',10,'1','default','completed',1539.00,0.00,0.00,NULL,NULL,0.00,1539.00,1,NULL,1,'2024-03-15 03:04:44','bh26ADRwprB7LWSw9tzNKjVvXpEMv',39,'2024-03-11 03:04:43','2024-03-15 03:04:44',3,NULL),(40,'#10000040',10,'1','default','completed',2526.00,0.00,0.00,NULL,NULL,0.00,2526.00,1,NULL,1,'2024-03-15 03:04:53','QUEST2DEENg7ekdovBeO9GtJUFnBg',40,'2024-03-09 21:04:44','2024-03-15 03:04:53',6,NULL),(41,'#10000041',10,NULL,'','completed',850.00,0.00,0.00,NULL,NULL,0.00,850.00,1,NULL,1,'2024-03-15 03:04:44','stFflrLNBBxwxn0bFQg10Wd7S10mS',41,'2024-03-11 01:04:44','2024-03-15 03:04:44',4,NULL),(42,'#10000042',10,'1','default','completed',302.00,0.00,0.00,NULL,NULL,0.00,302.00,1,NULL,1,'2024-03-15 03:04:53','o8nPWSAp4ckbagNEQ8DvnbEaM0CyM',42,'2024-03-09 07:04:44','2024-03-15 03:04:53',3,NULL),(43,'#10000043',10,'1','default','completed',2756.00,0.00,0.00,NULL,NULL,0.00,2756.00,1,NULL,1,'2024-03-15 03:04:44','F4KuC9XuTeruroBlL5b785SdtrMf2',43,'2024-03-13 03:04:44','2024-03-15 03:04:44',6,NULL),(44,'#10000044',10,NULL,'','pending',1323.00,0.00,0.00,NULL,NULL,0.00,1323.00,1,NULL,1,NULL,'yx1cuq0r9NJFIJQTdM7el2pIbix06',44,'2024-03-10 15:04:44','2024-03-15 03:04:44',8,NULL),(45,'#10000045',10,'1','default','completed',5211.00,0.00,0.00,NULL,NULL,0.00,5211.00,1,NULL,1,'2024-03-15 03:04:54','XdteBqM7YHPp5D5roiLifY8cUhGFO',45,'2024-03-12 03:04:45','2024-03-15 03:04:54',5,NULL),(46,'#10000046',10,NULL,'','completed',5343.00,0.00,0.00,NULL,NULL,0.00,5343.00,1,NULL,1,'2024-03-15 03:04:45','5tZDn4nd33SDlPbo4QmbY4bPTAjNH',46,'2024-03-12 05:04:45','2024-03-15 03:04:45',2,NULL),(47,'#10000047',10,'1','default','pending',2451.00,0.00,0.00,NULL,NULL,0.00,2451.00,1,NULL,1,NULL,'g6e0bZPbX0oTVjqdmLEmqef0xbI9Q',47,'2024-03-11 09:04:45','2024-03-15 03:04:45',4,NULL),(48,'#10000048',10,'1','default','completed',3488.00,0.00,0.00,NULL,NULL,0.00,3488.00,1,NULL,1,'2024-03-15 03:04:55','snxmq2jfa6n3FLX2PqC0o6FToIgXo',48,'2024-03-13 11:04:45','2024-03-15 03:04:55',1,NULL),(49,'#10000049',10,'1','default','pending',1998.00,0.00,0.00,NULL,NULL,0.00,1998.00,1,NULL,1,NULL,'jyWKYSFLAZcKkAiFfMJkfNgIT8F9S',49,'2024-03-10 23:04:45','2024-03-15 03:04:45',8,NULL),(50,'#10000050',10,'1','default','completed',3474.00,0.00,0.00,NULL,NULL,0.00,3474.00,1,NULL,1,'2024-03-15 03:04:55','Yu7WJk82oUU5oH2kncV3pbfLZFUNU',50,'2024-03-14 03:04:46','2024-03-15 03:04:55',5,NULL),(51,'#10000051',10,NULL,'','completed',1562.00,0.00,0.00,NULL,NULL,0.00,1562.00,1,NULL,1,'2024-03-15 03:04:46','4MkLJtzFldMLB01IdCb0ACNXmCd8R',51,'2024-03-13 19:04:46','2024-03-15 03:04:46',4,NULL),(52,'#10000052',10,'1','default','pending',2385.00,0.00,0.00,NULL,NULL,0.00,2385.00,1,NULL,1,NULL,'ItZmaoTvm6m4KGQYTqe8c0tsToest',52,'2024-03-12 11:04:46','2024-03-15 03:04:46',7,NULL),(53,'#10000053',10,'1','default','completed',3642.00,0.00,0.00,NULL,NULL,0.00,3642.00,1,NULL,1,'2024-03-15 03:04:56','elCfuygyeKxFczzZYKX8030akh1mG',53,'2024-03-12 15:04:46','2024-03-15 03:04:56',8,NULL),(54,'#10000054',10,'1','default','pending',4947.00,0.00,0.00,NULL,NULL,0.00,4947.00,1,NULL,1,NULL,'uzQ5Nl3EZclPDK7JxvnBNWrtHINQy',54,'2024-03-12 15:04:46','2024-03-15 03:04:46',4,NULL),(55,'#10000055',10,NULL,'','completed',4836.00,0.00,0.00,NULL,NULL,0.00,4836.00,1,NULL,1,'2024-03-15 03:04:47','Q0zFfUr1s2CuyRgSVKDoP5SzC6nyM',55,'2024-03-12 15:04:46','2024-03-15 03:04:47',1,NULL),(56,'#10000056',10,'1','default','pending',1722.00,0.00,0.00,NULL,NULL,0.00,1722.00,1,NULL,1,NULL,'4cP7Y9bZjLdkMRRtcn21Gct9WvWUr',56,'2024-03-13 15:04:47','2024-03-15 03:04:47',6,NULL),(57,'#10000057',10,'1','default','pending',2005.00,0.00,0.00,NULL,NULL,0.00,2005.00,1,NULL,1,NULL,'00jnOPmgeusfuEEnz4hl9SnY4RZqv',57,'2024-03-14 15:04:47','2024-03-15 03:04:47',2,NULL),(58,'#10000058',10,NULL,'','completed',587.00,0.00,0.00,NULL,NULL,0.00,587.00,1,NULL,1,'2024-03-15 03:04:47','v11bmEblbSDqv8osPdj0InejLBMJw',58,'2024-03-14 19:04:47','2024-03-15 03:04:47',3,NULL),(59,'#10000059',10,'1','default','pending',4932.00,0.00,0.00,NULL,NULL,0.00,4932.00,1,NULL,1,NULL,'rldgrVBpRxKeLaamJLZs1WsEQgArq',59,'2024-03-14 13:04:47','2024-03-15 03:04:47',2,NULL);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2024-03-15 03:04:20','2024-03-15 03:04:20',0),(2,'Size','size','text',1,1,1,'published',1,'2024-03-15 03:04:20','2024-03-15 03:04:20',0),(3,'Weight','weight','text',1,1,1,'published',0,'2024-03-15 03:04:20','2024-03-15 03:04:20',0),(4,'Boxes','boxes','text',1,1,1,'published',1,'2024-03-15 03:04:20','2024-03-15 03:04:20',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(2,1,'Blue','blue','#333333',NULL,0,2,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(3,1,'Red','red','#DA323F',NULL,0,3,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(4,1,'Black','black','#2F366C',NULL,0,4,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(6,2,'S','s',NULL,NULL,1,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(7,2,'M','m',NULL,NULL,0,2,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(8,2,'L','l',NULL,NULL,0,3,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(9,2,'XL','xl',NULL,NULL,0,4,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(11,3,'1KG','1kg',NULL,NULL,1,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(12,3,'2KG','2kg',NULL,NULL,0,2,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(13,3,'3KG','3kg',NULL,NULL,0,3,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(14,3,'4KG','4kg',NULL,NULL,0,4,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(15,3,'5KG','5kg',NULL,NULL,0,5,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(16,4,'1 Box','1-box',NULL,NULL,1,1,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(17,4,'2 Boxes','2-boxes',NULL,NULL,0,2,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(18,4,'3 Boxes','3-boxes',NULL,NULL,0,3,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(19,4,'4 Boxes','4-boxes',NULL,NULL,0,4,'2024-03-15 03:04:20','2024-03-15 03:04:20'),(20,4,'5 Boxes','5-boxes',NULL,NULL,0,5,'2024-03-15 03:04:20','2024-03-15 03:04:20');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Discover Skincare',0,NULL,'published',0,'jewelry/product-categories/1.jpg',0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(2,'Clothing',0,NULL,'published',1,'jewelry/product-categories/4.jpg',0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(3,'Men\'s Clothing',2,NULL,'published',0,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(4,'T-Shirts',3,NULL,'published',0,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(5,'Jeans',3,NULL,'published',1,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(6,'Suits',3,NULL,'published',2,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(7,'Women\'s Clothing',2,NULL,'published',1,'jewelry/product-categories/2.jpg',0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(8,'Dresses',7,NULL,'published',0,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(9,'Blouses',7,NULL,'published',1,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(10,'Pants',7,NULL,'published',2,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(11,'Accessories',0,NULL,'published',2,'jewelry/product-categories/5.jpg',0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(12,'Hats',11,NULL,'published',0,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(13,'Scarves',11,NULL,'published',1,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(14,'Jewelry',11,NULL,'published',2,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(15,'Sportswear',0,NULL,'published',3,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(16,'Activewear',15,NULL,'published',0,NULL,0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL),(17,'Running Shoes',15,NULL,'published',1,'jewelry/product-categories/3.jpg',0,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,7),(1,9),(1,10),(1,13),(1,14),(1,16),(1,28),(1,30),(1,34),(1,35),(1,37),(1,41),(2,4),(2,10),(2,15),(2,18),(2,19),(2,25),(2,29),(2,31),(2,32),(2,34),(2,36),(2,43),(3,6),(3,9),(3,21),(3,27),(3,39),(3,42),(3,43),(4,3),(4,7),(4,14),(4,16),(4,29),(4,30),(5,1),(5,2),(5,5),(5,7),(5,12),(5,14),(5,18),(5,20),(5,23),(5,26),(5,36),(5,39),(5,40),(6,10),(6,15),(6,22),(6,25),(6,33),(7,1),(7,14),(7,19),(7,22),(7,23),(7,24),(7,30),(7,31),(8,4),(8,17),(8,21),(8,28),(8,29),(8,31),(8,35),(8,36),(8,37),(8,40),(8,42),(9,2),(9,3),(9,4),(9,6),(9,8),(9,11),(9,15),(9,24),(9,26),(9,27),(9,34),(9,39),(9,42),(10,2),(10,3),(10,5),(10,8),(10,11),(10,18),(10,27),(10,28),(10,30),(10,35),(10,38),(10,41),(10,42),(11,1),(11,2),(11,4),(11,5),(11,9),(11,12),(11,19),(11,20),(11,21),(11,23),(11,24),(11,26),(11,27),(11,28),(11,37),(11,38),(12,3),(12,5),(12,12),(12,25),(12,32),(12,38),(12,41),(13,6),(13,7),(13,13),(13,16),(13,31),(13,33),(13,35),(13,39),(14,11),(14,17),(14,23),(14,29),(14,32),(14,41),(15,1),(15,6),(15,8),(15,10),(15,13),(15,17),(15,19),(15,20),(15,21),(15,22),(15,32),(15,33),(16,9),(16,11),(16,16),(16,18),(16,24),(16,26),(16,34),(16,36),(16,40),(16,43),(17,8),(17,12),(17,13),(17,15),(17,17),(17,20),(17,22),(17,25),(17,33),(17,37),(17,38),(17,40),(17,43);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,2),(1,9),(1,13),(1,14),(1,15),(1,25),(1,33),(1,38),(1,41),(2,4),(2,8),(2,16),(2,17),(2,18),(2,20),(2,22),(2,26),(2,36),(2,37),(2,39),(2,40),(2,42),(2,43),(3,1),(3,5),(3,7),(3,19),(3,24),(3,27),(3,28),(3,30),(3,31),(3,35),(4,3),(4,6),(4,10),(4,11),(4,12),(4,21),(4,23),(4,29),(4,32),(4,34);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'Trendy Wardrobe Essentials','trendy-wardrobe-essentials',NULL,NULL,'published','2024-03-15 03:04:29','2024-03-15 03:04:29',0),(2,'Fashion Forward Finds','fashion-forward-finds',NULL,NULL,'published','2024-03-15 03:04:29','2024-03-15 03:04:29',0),(3,'Chic &amp; Stylish Collection','chic-stylish-collection',NULL,NULL,'published','2024-03-15 03:04:29','2024-03-15 03:04:29',0),(4,'Weekly Fashion Picks','weekly-fashion-picks',NULL,NULL,'published','2024-03-15 03:04:29','2024-03-15 03:04:29',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,2,0,0.00,'fixed',1),(1,4,0,0.00,'fixed',1),(1,5,0,0.00,'fixed',1),(1,13,0,0.00,'fixed',1),(1,19,0,0.00,'fixed',1),(2,6,0,0.00,'fixed',1),(2,8,0,0.00,'fixed',1),(2,10,0,0.00,'fixed',1),(2,14,0,0.00,'fixed',1),(2,15,0,0.00,'fixed',1),(2,18,0,0.00,'fixed',1),(2,19,0,0.00,'fixed',1),(3,1,0,0.00,'fixed',1),(3,4,0,0.00,'fixed',1),(3,5,0,0.00,'fixed',1),(3,7,0,0.00,'fixed',1),(3,10,0,0.00,'fixed',1),(3,20,0,0.00,'fixed',1),(4,3,0,0.00,'fixed',1),(4,9,0,0.00,'fixed',1),(4,14,0,0.00,'fixed',1),(4,16,0,0.00,'fixed',1),(4,17,0,0.00,'fixed',1),(4,20,0,0.00,'fixed',1),(5,2,0,0.00,'fixed',1),(5,8,0,0.00,'fixed',1),(5,10,0,0.00,'fixed',1),(5,12,0,0.00,'fixed',1),(5,15,0,0.00,'fixed',1),(5,19,0,0.00,'fixed',1),(6,1,0,0.00,'fixed',1),(6,10,0,0.00,'fixed',1),(6,11,0,0.00,'fixed',1),(6,18,0,0.00,'fixed',1),(6,20,0,0.00,'fixed',1),(7,1,0,0.00,'fixed',1),(7,4,0,0.00,'fixed',1),(7,12,0,0.00,'fixed',1),(7,14,0,0.00,'fixed',1),(7,17,0,0.00,'fixed',1),(7,18,0,0.00,'fixed',1),(7,19,0,0.00,'fixed',1),(8,4,0,0.00,'fixed',1),(8,11,0,0.00,'fixed',1),(8,12,0,0.00,'fixed',1),(8,17,0,0.00,'fixed',1),(8,18,0,0.00,'fixed',1),(8,19,0,0.00,'fixed',1),(8,20,0,0.00,'fixed',1),(9,1,0,0.00,'fixed',1),(9,2,0,0.00,'fixed',1),(9,5,0,0.00,'fixed',1),(9,8,0,0.00,'fixed',1),(9,10,0,0.00,'fixed',1),(9,12,0,0.00,'fixed',1),(10,1,0,0.00,'fixed',1),(10,12,0,0.00,'fixed',1),(10,14,0,0.00,'fixed',1),(10,15,0,0.00,'fixed',1),(10,18,0,0.00,'fixed',1),(10,19,0,0.00,'fixed',1),(11,1,0,0.00,'fixed',1),(11,4,0,0.00,'fixed',1),(11,9,0,0.00,'fixed',1),(11,10,0,0.00,'fixed',1),(11,14,0,0.00,'fixed',1),(11,16,0,0.00,'fixed',1),(11,17,0,0.00,'fixed',1),(12,2,0,0.00,'fixed',1),(12,4,0,0.00,'fixed',1),(12,10,0,0.00,'fixed',1),(12,13,0,0.00,'fixed',1),(12,16,0,0.00,'fixed',1),(13,1,0,0.00,'fixed',1),(13,2,0,0.00,'fixed',1),(13,10,0,0.00,'fixed',1),(13,12,0,0.00,'fixed',1),(13,15,0,0.00,'fixed',1),(13,19,0,0.00,'fixed',1),(14,2,0,0.00,'fixed',1),(14,3,0,0.00,'fixed',1),(14,6,0,0.00,'fixed',1),(14,8,0,0.00,'fixed',1),(14,15,0,0.00,'fixed',1),(15,3,0,0.00,'fixed',1),(15,4,0,0.00,'fixed',1),(15,7,0,0.00,'fixed',1),(15,9,0,0.00,'fixed',1),(15,13,0,0.00,'fixed',1),(15,20,0,0.00,'fixed',1),(16,2,0,0.00,'fixed',1),(16,6,0,0.00,'fixed',1),(16,13,0,0.00,'fixed',1),(16,15,0,0.00,'fixed',1),(16,20,0,0.00,'fixed',1),(17,1,0,0.00,'fixed',1),(17,2,0,0.00,'fixed',1),(17,5,0,0.00,'fixed',1),(17,6,0,0.00,'fixed',1),(17,14,0,0.00,'fixed',1),(17,15,0,0.00,'fixed',1),(18,2,0,0.00,'fixed',1),(18,5,0,0.00,'fixed',1),(18,6,0,0.00,'fixed',1),(18,8,0,0.00,'fixed',1),(18,9,0,0.00,'fixed',1),(18,14,0,0.00,'fixed',1),(19,6,0,0.00,'fixed',1),(19,8,0,0.00,'fixed',1),(19,9,0,0.00,'fixed',1),(19,11,0,0.00,'fixed',1),(19,12,0,0.00,'fixed',1),(19,20,0,0.00,'fixed',1),(20,2,0,0.00,'fixed',1),(20,5,0,0.00,'fixed',1),(20,10,0,0.00,'fixed',1),(20,15,0,0.00,'fixed',1),(20,18,0,0.00,'fixed',1),(21,5,0,0.00,'fixed',1),(21,6,0,0.00,'fixed',1),(21,8,0,0.00,'fixed',1),(21,11,0,0.00,'fixed',1),(21,18,0,0.00,'fixed',1),(21,19,0,0.00,'fixed',1),(22,2,0,0.00,'fixed',1),(22,3,0,0.00,'fixed',1),(22,4,0,0.00,'fixed',1),(22,9,0,0.00,'fixed',1),(22,15,0,0.00,'fixed',1),(23,2,0,0.00,'fixed',1),(23,6,0,0.00,'fixed',1),(23,11,0,0.00,'fixed',1),(23,15,0,0.00,'fixed',1),(23,17,0,0.00,'fixed',1),(23,19,0,0.00,'fixed',1),(24,2,0,0.00,'fixed',1),(24,9,0,0.00,'fixed',1),(24,12,0,0.00,'fixed',1),(24,14,0,0.00,'fixed',1),(24,15,0,0.00,'fixed',1),(24,18,0,0.00,'fixed',1),(25,6,0,0.00,'fixed',1),(25,7,0,0.00,'fixed',1),(25,9,0,0.00,'fixed',1),(25,10,0,0.00,'fixed',1),(25,15,0,0.00,'fixed',1),(26,3,0,0.00,'fixed',1),(26,4,0,0.00,'fixed',1),(26,5,0,0.00,'fixed',1),(26,6,0,0.00,'fixed',1),(26,13,0,0.00,'fixed',1),(26,15,0,0.00,'fixed',1),(27,1,0,0.00,'fixed',1),(27,10,0,0.00,'fixed',1),(27,13,0,0.00,'fixed',1),(27,15,0,0.00,'fixed',1),(28,2,0,0.00,'fixed',1),(28,4,0,0.00,'fixed',1),(28,13,0,0.00,'fixed',1),(28,14,0,0.00,'fixed',1),(28,19,0,0.00,'fixed',1),(29,3,0,0.00,'fixed',1),(29,5,0,0.00,'fixed',1),(29,10,0,0.00,'fixed',1),(29,14,0,0.00,'fixed',1),(29,15,0,0.00,'fixed',1),(29,19,0,0.00,'fixed',1),(30,4,0,0.00,'fixed',1),(30,11,0,0.00,'fixed',1),(30,14,0,0.00,'fixed',1),(30,18,0,0.00,'fixed',1),(31,2,0,0.00,'fixed',1),(31,6,0,0.00,'fixed',1),(31,8,0,0.00,'fixed',1),(31,11,0,0.00,'fixed',1),(31,13,0,0.00,'fixed',1),(31,15,0,0.00,'fixed',1),(31,18,0,0.00,'fixed',1),(32,1,0,0.00,'fixed',1),(32,2,0,0.00,'fixed',1),(32,4,0,0.00,'fixed',1),(32,5,0,0.00,'fixed',1),(32,14,0,0.00,'fixed',1),(33,2,0,0.00,'fixed',1),(33,8,0,0.00,'fixed',1),(33,9,0,0.00,'fixed',1),(33,13,0,0.00,'fixed',1),(33,16,0,0.00,'fixed',1),(33,18,0,0.00,'fixed',1),(34,3,0,0.00,'fixed',1),(34,5,0,0.00,'fixed',1),(34,6,0,0.00,'fixed',1),(34,13,0,0.00,'fixed',1),(34,14,0,0.00,'fixed',1),(34,15,0,0.00,'fixed',1),(34,17,0,0.00,'fixed',1),(35,3,0,0.00,'fixed',1),(35,4,0,0.00,'fixed',1),(35,5,0,0.00,'fixed',1),(35,12,0,0.00,'fixed',1),(35,16,0,0.00,'fixed',1),(35,18,0,0.00,'fixed',1),(36,5,0,0.00,'fixed',1),(36,7,0,0.00,'fixed',1),(36,10,0,0.00,'fixed',1),(36,11,0,0.00,'fixed',1),(36,13,0,0.00,'fixed',1),(36,15,0,0.00,'fixed',1),(37,5,0,0.00,'fixed',1),(37,9,0,0.00,'fixed',1),(37,13,0,0.00,'fixed',1),(37,14,0,0.00,'fixed',1),(37,16,0,0.00,'fixed',1),(37,19,0,0.00,'fixed',1),(38,3,0,0.00,'fixed',1),(38,6,0,0.00,'fixed',1),(38,7,0,0.00,'fixed',1),(38,11,0,0.00,'fixed',1),(38,12,0,0.00,'fixed',1),(38,17,0,0.00,'fixed',1),(39,8,0,0.00,'fixed',1),(39,11,0,0.00,'fixed',1),(39,12,0,0.00,'fixed',1),(39,13,0,0.00,'fixed',1),(39,14,0,0.00,'fixed',1),(39,17,0,0.00,'fixed',1),(39,19,0,0.00,'fixed',1),(40,4,0,0.00,'fixed',1),(40,8,0,0.00,'fixed',1),(40,9,0,0.00,'fixed',1),(40,11,0,0.00,'fixed',1),(40,14,0,0.00,'fixed',1),(40,15,0,0.00,'fixed',1),(41,3,0,0.00,'fixed',1),(41,13,0,0.00,'fixed',1),(41,15,0,0.00,'fixed',1),(41,16,0,0.00,'fixed',1),(41,18,0,0.00,'fixed',1),(42,7,0,0.00,'fixed',1),(42,9,0,0.00,'fixed',1),(42,12,0,0.00,'fixed',1),(42,14,0,0.00,'fixed',1),(42,17,0,0.00,'fixed',1),(42,18,0,0.00,'fixed',1),(43,2,0,0.00,'fixed',1),(43,8,0,0.00,'fixed',1),(43,10,0,0.00,'fixed',1),(43,11,0,0.00,'fixed',1),(43,12,0,0.00,'fixed',1),(43,19,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,47,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(2,47,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(3,47,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(4,47,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(5,47,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(6,47,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(7,47,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(8,47,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(9,48,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(10,48,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(11,48,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(12,48,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(13,48,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(14,48,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(15,48,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(16,48,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(17,49,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(18,49,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(19,49,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(20,49,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(21,49,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(22,49,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(23,49,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(24,49,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(25,56,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(26,56,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(27,56,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(28,56,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(29,56,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(30,56,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(31,57,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(32,57,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(33,57,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(34,57,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(35,57,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(36,57,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:31\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:31','2024-03-15 03:04:31'),(37,65,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(38,65,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(39,65,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(40,65,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(41,65,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(42,66,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(43,66,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(44,66,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(45,66,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(46,66,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(47,67,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(48,67,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(49,67,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(50,67,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(51,67,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(52,68,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(53,68,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(54,68,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(55,68,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(56,68,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(57,76,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(58,76,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(59,76,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(60,76,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(61,76,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(62,77,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(63,77,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(64,77,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(65,77,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(66,77,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(67,78,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(68,78,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(69,78,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(70,78,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(71,78,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(72,79,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(73,79,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(74,79,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(75,79,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(76,79,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(77,88,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(78,88,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(79,88,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(80,88,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(81,88,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(82,88,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(83,89,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(84,89,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(85,89,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(86,89,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(87,89,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(88,89,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(89,90,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(90,90,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(91,90,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(92,90,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(93,90,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(94,90,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(95,97,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(96,97,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(97,97,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(98,97,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(99,97,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(100,98,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(101,98,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(102,98,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(103,98,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(104,98,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(105,99,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(106,99,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(107,99,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(108,99,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(109,99,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:32\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:32','2024-03-15 03:04:32'),(110,110,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(111,110,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(112,110,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(113,110,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(114,110,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(115,111,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(116,111,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(117,111,'product-files/product-8.png','{\"filename\":\"product-8.png\",\"url\":\"product-files\\/product-8.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-8\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(118,111,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(119,111,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(120,121,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(121,121,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(122,121,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(123,121,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(124,121,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(125,122,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(126,122,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(127,122,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(128,122,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(129,122,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(130,123,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(131,123,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(132,123,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(133,123,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(134,123,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(135,132,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(136,132,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(137,132,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(138,132,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(139,132,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(140,132,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(141,132,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(142,133,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(143,133,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(144,133,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(145,133,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(146,133,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(147,133,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(148,133,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(149,134,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(150,134,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(151,134,'product-files/product-2.png','{\"filename\":\"product-2.png\",\"url\":\"product-files\\/product-2.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-2\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(152,134,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(153,134,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(154,134,'product-files/product-7.png','{\"filename\":\"product-7.png\",\"url\":\"product-files\\/product-7.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-7\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(155,134,'product-files/product-6.png','{\"filename\":\"product-6.png\",\"url\":\"product-files\\/product-6.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:33\",\"name\":\"product-6\",\"extension\":\"png\"}','2024-03-15 03:04:33','2024-03-15 03:04:33'),(156,141,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(157,141,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(158,141,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(159,141,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(160,142,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(161,142,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(162,142,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(163,142,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(164,143,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(165,143,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(166,143,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(167,143,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(168,144,'product-files/product-1.png','{\"filename\":\"product-1.png\",\"url\":\"product-files\\/product-1.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-1\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(169,144,'product-files/product-4.png','{\"filename\":\"product-4.png\",\"url\":\"product-files\\/product-4.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-4\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(170,144,'product-files/product-5.png','{\"filename\":\"product-5.png\",\"url\":\"product-files\\/product-5.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-5\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34'),(171,144,'product-files/product-3.png','{\"filename\":\"product-3.png\",\"url\":\"product-files\\/product-3.png\",\"mime_type\":\"image\\/png\",\"size\":9730,\"modified\":\"2024-03-15 10:04:34\",\"name\":\"product-3\",\"extension\":\"png\"}','2024-03-15 03:04:34','2024-03-15 03:04:34');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,3),(1,6),(1,9),(1,21),(1,33),(1,36),(1,39),(2,12),(2,18),(2,24),(2,27),(2,30),(2,42),(3,15);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#cb4321','published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(2,'New','#00c9a7','published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(3,'Sale','#ba591d','published','2024-03-15 03:04:20','2024-03-15 03:04:20');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,2),(1,3),(1,6),(2,4),(2,5),(2,6),(3,1),(3,2),(3,4),(4,1),(4,2),(4,6),(5,4),(5,5),(5,6),(6,2),(6,5),(6,6),(7,4),(7,5),(7,6),(8,2),(8,4),(8,5),(9,3),(9,4),(9,5),(10,1),(10,2),(10,6),(11,1),(11,4),(11,5),(12,3),(12,4),(12,5),(13,1),(13,3),(13,5),(14,2),(14,4),(14,6),(15,1),(15,2),(15,3),(16,1),(16,3),(16,4),(17,1),(17,2),(17,3),(18,1),(18,2),(18,4),(19,3),(19,5),(19,6),(20,2),(20,3),(20,6),(21,2),(21,5),(21,6),(22,2),(22,3),(22,6),(23,2),(23,5),(23,6),(24,1),(24,2),(24,6),(25,3),(25,5),(25,6),(26,2),(26,4),(26,5),(27,2),(27,4),(27,6),(28,1),(28,5),(28,6),(29,3),(29,5),(29,6),(30,2),(30,5),(30,6),(31,2),(31,4),(31,5),(32,2),(32,4),(32,6),(33,1),(33,2),(33,6),(34,1),(34,3),(34,6),(35,1),(35,4),(35,6),(36,4),(36,5),(36,6),(37,2),(37,3),(37,5),(38,1),(38,5),(38,6),(39,2),(39,5),(39,6),(40,1),(40,2),(40,6),(41,2),(41,4),(41,6),(42,3),(42,4),(42,5),(43,3),(43,4),(43,6);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2024-03-15 03:04:23','2024-03-15 03:04:23'),(2,'Mobile',NULL,'published','2024-03-15 03:04:23','2024-03-15 03:04:23'),(3,'Iphone',NULL,'published','2024-03-15 03:04:23','2024-03-15 03:04:23'),(4,'Printer',NULL,'published','2024-03-15 03:04:23','2024-03-15 03:04:23'),(5,'Office',NULL,'published','2024-03-15 03:04:23','2024-03-15 03:04:23'),(6,'IT',NULL,'published','2024-03-15 03:04:23','2024-03-15 03:04:23');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (7,1,4),(17,1,9),(35,1,18),(39,1,20),(51,1,26),(61,1,31),(69,1,35),(73,1,37),(87,1,44),(97,1,49),(101,1,51),(3,2,2),(15,2,8),(21,2,11),(27,2,14),(29,2,15),(59,2,30),(83,2,42),(5,3,3),(9,3,5),(33,3,17),(53,3,27),(55,3,28),(67,3,34),(77,3,39),(79,3,40),(89,3,45),(91,3,46),(93,3,47),(105,3,53),(1,4,1),(11,4,6),(19,4,10),(23,4,12),(25,4,13),(31,4,16),(37,4,19),(49,4,25),(57,4,29),(63,4,32),(65,4,33),(75,4,38),(95,4,48),(103,4,52),(13,5,7),(41,5,21),(43,5,22),(45,5,23),(47,5,24),(71,5,36),(81,5,41),(85,5,43),(99,5,50),(4,6,2),(26,6,13),(30,6,15),(38,6,19),(54,6,27),(66,6,33),(82,6,41),(92,6,46),(94,6,47),(96,6,48),(12,7,6),(20,7,10),(24,7,12),(28,7,14),(40,7,20),(50,7,25),(56,7,28),(62,7,31),(70,7,35),(86,7,43),(90,7,45),(102,7,51),(8,8,4),(16,8,8),(44,8,22),(46,8,23),(48,8,24),(68,8,34),(76,8,38),(78,8,39),(80,8,40),(84,8,42),(88,8,44),(98,8,49),(100,8,50),(104,8,52),(2,9,1),(6,9,3),(10,9,5),(14,9,7),(18,9,9),(42,9,21),(60,9,30),(64,9,32),(72,9,36),(22,10,11),(32,10,16),(34,10,17),(36,10,18),(52,10,26),(58,10,29),(74,10,37),(106,10,53),(107,11,54),(109,11,55),(113,11,57),(115,11,58),(119,11,60),(141,11,71),(151,11,76),(167,11,84),(181,11,91),(189,11,95),(193,11,97),(207,11,104),(209,11,105),(111,12,56),(117,12,59),(127,12,64),(129,12,65),(143,12,72),(149,12,75),(163,12,82),(171,12,86),(173,12,87),(187,12,94),(195,12,98),(203,12,102),(211,12,106),(131,13,66),(135,13,68),(137,13,69),(157,13,79),(165,13,83),(169,13,85),(183,13,92),(197,13,99),(199,13,100),(213,13,107),(121,14,61),(123,14,62),(133,14,67),(153,14,77),(159,14,80),(201,14,101),(205,14,103),(125,15,63),(139,15,70),(145,15,73),(147,15,74),(155,15,78),(161,15,81),(175,15,88),(177,15,89),(179,15,90),(185,15,93),(191,15,96),(120,16,60),(136,16,68),(142,16,71),(146,16,73),(150,16,75),(158,16,79),(180,16,90),(194,16,97),(212,16,106),(110,17,55),(122,17,61),(126,17,63),(154,17,77),(156,17,78),(164,17,82),(176,17,88),(178,17,89),(186,17,93),(188,17,94),(198,17,99),(206,17,103),(108,18,54),(114,18,57),(132,18,66),(134,18,67),(144,18,72),(166,18,83),(196,18,98),(204,18,102),(116,19,58),(130,19,65),(138,19,69),(140,19,70),(160,19,80),(162,19,81),(168,19,84),(182,19,91),(184,19,92),(190,19,95),(192,19,96),(200,19,100),(208,19,104),(112,20,56),(118,20,59),(124,20,62),(128,20,64),(148,20,74),(152,20,76),(170,20,85),(172,20,86),(174,20,87),(202,20,101),(210,20,105),(214,20,107);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,44,1,1),(2,45,2,1),(3,46,3,1),(4,47,4,1),(5,48,4,0),(6,49,4,0),(7,50,5,1),(8,51,5,0),(9,52,6,1),(10,53,7,1),(11,54,7,0),(12,55,7,0),(13,56,8,1),(14,57,8,0),(15,58,9,1),(16,59,10,1),(17,60,10,0),(18,61,10,0),(19,62,10,0),(20,63,11,1),(21,64,11,0),(22,65,12,1),(23,66,12,0),(24,67,12,0),(25,68,12,0),(26,69,13,1),(27,70,14,1),(28,71,14,0),(29,72,14,0),(30,73,15,1),(31,74,15,0),(32,75,15,0),(33,76,16,1),(34,77,16,0),(35,78,16,0),(36,79,16,0),(37,80,17,1),(38,81,18,1),(39,82,18,0),(40,83,18,0),(41,84,18,0),(42,85,19,1),(43,86,19,0),(44,87,19,0),(45,88,20,1),(46,89,20,0),(47,90,20,0),(48,91,21,1),(49,92,21,0),(50,93,21,0),(51,94,22,1),(52,95,23,1),(53,96,23,0),(54,97,24,1),(55,98,24,0),(56,99,24,0),(57,100,25,1),(58,101,25,0),(59,102,25,0),(60,103,26,1),(61,104,26,0),(62,105,26,0),(63,106,26,0),(64,107,26,0),(65,108,27,1),(66,109,27,0),(67,110,28,1),(68,111,28,0),(69,112,29,1),(70,113,29,0),(71,114,29,0),(72,115,29,0),(73,116,30,1),(74,117,30,0),(75,118,31,1),(76,119,31,0),(77,120,31,0),(78,121,32,1),(79,122,32,0),(80,123,32,0),(81,124,33,1),(82,125,33,0),(83,126,33,0),(84,127,33,0),(85,128,34,1),(86,129,34,0),(87,130,35,1),(88,131,35,0),(89,132,36,1),(90,133,36,0),(91,134,36,0),(92,135,37,1),(93,136,38,1),(94,137,38,0),(95,138,38,0),(96,139,38,0),(97,140,39,1),(98,141,40,1),(99,142,40,0),(100,143,40,0),(101,144,40,0),(102,145,41,1),(103,146,42,1),(104,147,42,0),(105,148,42,0),(106,149,42,0),(107,150,43,1);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2024-03-15',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(3,24,0),(4,24,0),(3,25,0),(4,25,0),(3,26,0),(4,26,0),(3,27,0),(4,27,0),(3,28,0),(4,28,0),(3,29,0),(4,29,0),(3,30,0),(4,30,0),(3,31,0),(4,31,0),(3,32,0),(4,32,0),(3,33,0),(4,33,0),(3,34,0),(4,34,0),(3,35,0),(4,35,0),(3,36,0),(4,36,0),(3,37,0),(4,37,0),(3,38,0),(4,38,0),(3,39,0),(4,39,0),(3,40,0),(4,40,0),(3,41,0),(4,41,0),(3,42,0),(4,42,0),(3,43,0),(4,43,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `approved_by` bigint unsigned DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Vintage Denim Jacket','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\"]','YB-147-A0',0,15,0,1,1,3,0,0,724,NULL,NULL,NULL,18.00,14.00,16.00,575.00,NULL,125891,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(2,'Floral Maxi Dress','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-8.png\"]','QT-132-A0',0,10,0,1,1,2,0,0,1287,NULL,NULL,NULL,16.00,13.00,14.00,577.00,NULL,50092,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(3,'Leather Ankle Boots','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-8.png\"]','PB-123-A0',0,13,0,1,0,5,0,0,1060,NULL,NULL,NULL,12.00,16.00,13.00,861.00,NULL,162325,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(4,'Knit Turtleneck Sweater (Digital)','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\"]','VV-152-A0',0,16,0,1,0,2,0,0,1781,1460.42,NULL,NULL,16.00,18.00,10.00,737.00,NULL,136410,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(5,'Classic Aviator Sunglasses','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\"]','JA-179-A0',0,20,0,1,1,1,0,0,817,NULL,NULL,NULL,13.00,12.00,15.00,726.00,NULL,146121,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(6,'Tailored Wool Blazer','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-2.png\"]','YS-157-A0',0,10,0,1,0,4,0,0,2297,NULL,NULL,NULL,16.00,13.00,19.00,617.00,NULL,162771,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(7,'Bohemian Fringe Handbag','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-7.png\"]','2Q-144-A0',0,14,0,1,1,4,0,0,2440,NULL,NULL,NULL,10.00,14.00,17.00,704.00,NULL,8673,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(8,'Silk Scarf with Geometric Print (Digital)','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-5.png\"]','M5-139-A0',0,14,0,1,1,2,0,0,944,792.96,NULL,NULL,10.00,17.00,20.00,860.00,NULL,7033,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(9,'High-Waisted Wide Leg Trousers','Make a statement in this floral maxi dress, perfect for summer events or a casual day out. The flowy silhouette and vibrant print will turn heads wherever you go.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-6.png\"]','8H-108-A0',0,12,0,1,1,5,0,0,1035,NULL,NULL,NULL,14.00,13.00,17.00,705.00,NULL,27925,'2024-03-15 03:04:30','2024-03-15 03:04:31','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(10,'Embroidered Boho Blouse','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\"]','BH-124-A0',0,14,0,1,1,3,0,0,574,NULL,NULL,NULL,15.00,14.00,15.00,527.00,NULL,188754,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(11,'Statement Chunky Necklace','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-1.png\"]','XO-112-A0',0,10,0,1,0,5,0,0,761,NULL,NULL,NULL,20.00,18.00,11.00,878.00,NULL,166118,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(12,'Chic Fedora Hat (Digital)','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-5.png\"]','IL-161-A0',0,15,0,1,0,3,0,0,587,516.56,NULL,NULL,11.00,18.00,19.00,615.00,NULL,147613,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(13,'Strappy Block Heel Sandals','Elevate your street style with this vintage denim jacket, featuring distressed detailing and a relaxed fit for a laid-back vibe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-4.png\"]','QP-144-A0',0,20,0,1,0,4,0,0,1140,NULL,NULL,NULL,17.00,10.00,15.00,591.00,NULL,41073,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(14,'Velvet Evening Gown','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-7.png\"]','SF-106-A0',0,13,0,1,0,1,0,0,452,NULL,NULL,NULL,17.00,10.00,20.00,638.00,NULL,127193,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(15,'Quilted Crossbody Bag','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-7.png\"]','VH-154-A0',0,17,0,1,0,4,0,0,1821,NULL,NULL,NULL,15.00,15.00,17.00,527.00,NULL,71020,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(16,'Distressed Skinny Jeans (Digital)','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\"]','SW-162-A0',0,19,0,1,1,4,0,0,1908,1450.08,NULL,NULL,20.00,12.00,17.00,786.00,NULL,98806,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(17,'Lace-Up Combat Boots','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-7.png\"]','DO-170-A0',0,15,0,1,1,1,0,0,424,NULL,NULL,NULL,14.00,10.00,12.00,807.00,NULL,159124,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(18,'Cotton Striped T-Shirt Dress','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-3.png\"]','NW-157-A0',0,12,0,1,0,2,0,0,2306,NULL,NULL,NULL,12.00,15.00,17.00,765.00,NULL,137189,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(19,'Printed Palazzo Pants','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-1.png\"]','XE-152-A0',0,16,0,1,1,4,0,0,1706,NULL,NULL,NULL,16.00,18.00,14.00,816.00,NULL,15663,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(20,'Structured Satchel Bag (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\"]','ON-156-A0',0,11,0,1,0,5,0,0,425,378.25,NULL,NULL,17.00,10.00,17.00,809.00,NULL,196936,'2024-03-15 03:04:30','2024-03-15 03:04:32','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(21,'Off-Shoulder Ruffle Top','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-6.png\"]','MJ-187-A0',0,16,0,1,0,5,0,0,1744,NULL,NULL,NULL,12.00,11.00,11.00,897.00,NULL,2900,'2024-03-15 03:04:31','2024-03-15 03:04:32','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(22,'Suede Pointed-Toe Pumps','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-1.png\"]','4V-126-A0',0,19,0,1,0,5,0,0,1829,NULL,NULL,NULL,14.00,15.00,18.00,684.00,NULL,61681,'2024-03-15 03:04:31','2024-03-15 03:04:32','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(23,'Cropped Cable Knit Sweater','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-3.png\"]','0Y-146-A0',0,18,0,1,0,3,0,0,2243,NULL,NULL,NULL,17.00,10.00,20.00,716.00,NULL,131909,'2024-03-15 03:04:31','2024-03-15 03:04:32','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(24,'Athleisure Jogger Pants (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-8.png\"]','GH-176-A0',0,18,0,1,0,5,0,0,1555,1166.25,NULL,NULL,19.00,20.00,17.00,504.00,NULL,28518,'2024-03-15 03:04:31','2024-03-15 03:04:32','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(25,'Leopard Print Midi Skirt','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\"]','OA-178-A0',0,10,0,1,1,3,0,0,666,NULL,NULL,NULL,12.00,19.00,15.00,568.00,NULL,145653,'2024-03-15 03:04:31','2024-03-15 03:04:32','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(26,'Retro Cat-Eye Sunglasses','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-2.png\"]','0V-138-A0',0,10,0,1,1,2,0,0,874,NULL,NULL,NULL,13.00,14.00,15.00,805.00,NULL,106271,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(27,'Faux Fur Trimmed Coat','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-8.png\"]','QE-163-A0',0,11,0,1,0,2,0,0,579,NULL,NULL,NULL,12.00,14.00,17.00,899.00,NULL,65479,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(28,'Boho Fringed Kimono (Digital)','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-7.png\"]','B4-149-A0',0,15,0,1,0,4,0,0,2305,1844,NULL,NULL,16.00,16.00,12.00,571.00,NULL,76322,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(29,'Ruffled Wrap Dress','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-2.png\"]','7A-136-A0',0,10,0,1,1,4,0,0,1378,NULL,NULL,NULL,19.00,19.00,19.00,790.00,NULL,148854,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(30,'Beaded Evening Clutch','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-2.png\"]','DM-189-A0',0,12,0,1,1,4,0,0,775,NULL,NULL,NULL,15.00,11.00,16.00,700.00,NULL,173619,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(31,'Wide Brim Floppy Hat','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\"]','DA-123-A0',0,17,0,1,1,1,0,0,1961,NULL,NULL,NULL,19.00,10.00,12.00,505.00,NULL,184159,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',6,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(32,'Denim Overall Jumpsuit (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-5.png\"]','ZP-152-A0',0,15,0,1,1,5,0,0,441,361.62,NULL,NULL,14.00,11.00,13.00,672.00,NULL,198182,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',8,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(33,'Embellished Ballet Flats','Add a pop of color to your outfit with this silk scarf adorned with a geometric print. Wrap it around your neck or tie it to your handbag for a stylish touch.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-2.png\"]','TO-194-A0',0,17,0,1,1,1,0,0,318,NULL,NULL,NULL,12.00,20.00,18.00,793.00,NULL,38811,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(34,'Pleated Midi Skirt','Embrace bohemian vibes with this embroidered boho blouse, featuring intricate stitching and a relaxed fit. Perfect for a casual day with a touch of style.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-6.png\"]','LQ-100-A0',0,17,0,1,0,1,0,0,513,NULL,NULL,NULL,17.00,19.00,17.00,583.00,NULL,109479,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(35,'Velour Tracksuit Set','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-6.png\"]','F5-146-A0',0,15,0,1,1,5,0,0,1737,NULL,NULL,NULL,18.00,19.00,17.00,817.00,NULL,184308,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',5,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(36,'Geometric Patterned Cardigan (Digital)','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-6.png\"]','HN-174-A0',0,16,0,1,0,2,0,0,781,577.94,NULL,NULL,16.00,17.00,15.00,517.00,NULL,73192,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',4,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(37,'Buckle Detail Ankle Booties','Achieve a polished look with this tailored wool blazer, designed for a flattering fit and versatile enough for both work and casual outings.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\"]','X8-116-A0',0,19,0,1,1,2,0,0,302,NULL,NULL,NULL,20.00,11.00,10.00,654.00,NULL,68216,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',3,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(38,'Embroidered Bomber Jacket','Accessorize with this bohemian fringe handbag, featuring intricate details and enough space for your essentials. The perfect boho-chic addition to your collection.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-1.png\"]','IK-105-A0',0,13,0,1,1,1,0,0,2062,NULL,NULL,NULL,20.00,13.00,10.00,674.00,NULL,157789,'2024-03-15 03:04:31','2024-03-15 03:04:33','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(39,'Cowl Neck Knit Poncho','Complete your look with these classic aviator sunglasses, offering a touch of timeless glamour and UV protection for your eyes.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-3.png\"]','A7-196-A0',0,16,0,1,0,3,0,0,1757,NULL,NULL,NULL,17.00,11.00,17.00,665.00,NULL,53050,'2024-03-15 03:04:31','2024-03-15 03:04:34','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(40,'Chunky Knit Infinity Scarf (Digital)','Stay on trend with these high-waisted wide-leg trousers, combining comfort and sophistication. Pair them with heels for a refined look.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-3.png\"]','Z7-188-A0',0,17,0,1,1,3,0,0,2418,2103.66,NULL,NULL,11.00,17.00,16.00,827.00,NULL,187044,'2024-03-15 03:04:31','2024-03-15 03:04:34','in_stock',1,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(41,'Retro High-Top Sneakers','Step out in style with these leather ankle boots, crafted with a sleek design and comfortable block heel. Versatile enough to pair with both dresses and jeans.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-4.png\",\"jewelry\\/products\\/product-3.png\"]','LW-110-A0',0,11,0,1,0,5,0,0,2005,NULL,NULL,NULL,12.00,17.00,15.00,840.00,NULL,74671,'2024-03-15 03:04:31','2024-03-15 03:04:34','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(42,'Faux Leather Leggings','Make a bold statement with this chunky necklace, designed to add a touch of glamour to any outfit. The perfect accessory for a night out.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-5.png\"]','GR-126-A0',0,20,0,1,1,3,0,0,1644,NULL,NULL,NULL,16.00,17.00,18.00,546.00,NULL,150164,'2024-03-15 03:04:31','2024-03-15 03:04:34','in_stock',2,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(43,'Metallic Pleated Maxi Skirt','Top off your look with this chic fedora hat, crafted with a classic silhouette and a timeless appeal. A must-have accessory for any fashion-forward wardrobe.','<div class=\"row justify-content-center\">\n    <div class=\"col-xl-10\">\n        <div class=\"tp-product-details-desc-item pb-105\">\n            <div class=\"row\">\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-content pt-25\">\n                        <span>Galaxy A8 tablet</span>\n                        <h3 class=\"tp-product-details-desc-title\">Your world at a glance</h3>\n                        <p>\n                            With a slim design, a vibrant entertainment system, and <br>\n                            outstanding performance, the new Galaxy Tab A7 is a stylish new <br>\n                            companion for your life.Dive head-first into the things you love, <br>\n                            and easily share your favorite moments. Learn, explore, connect <br>\n                            and be inspired.\n                        </p>\n                    </div>\n                    <div class=\"tp-product-details-desc-content\">\n                        <h3 class=\"tp-product-details-desc-title\">Draw inspiration with S Pen</h3>\n                        <p>\n                            S Pen is a bundle of writing instruments in one. Its natural grip, <br>\n                            low latency and impressive pressure sensitivity will make it your go-to for everything from drawing to editing documents. And S Pen won\'t get misplaced thanks.\n                        </p>\n                    </div>\n                </div>\n                <div class=\"col-lg-6\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-1.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item pb-75\">\n            <div class=\"row\">\n                <div class=\"col-lg-7\">\n                    <div class=\"tp-product-details-desc-thumb\">\n                        <img src=\"/storage/main/products/product-details-desc-2.jpg\" alt=\"\">\n                    </div>\n                </div>\n\n                <div class=\"col-lg-5 order-first order-lg-last\">\n                    <div class=\"tp-product-details-desc-content des-content-2 pl-40\">\n                        <h3 class=\"tp-product-details-desc-title\">\n                            Carry with <br>\n                            Confidence and style\n                        </h3>\n                        <p>\n                            Wrap your tablet in a sleek case that\'s as stylish as it is convenient. Galaxy Tab S6 Lite Book Cover folds around and clings magnetically, so you can easily gear up as you\'re headed out the door. There\'s even a\n                            compartment for S pen, so you can be sure it doesn\'t get left behind.\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"tp-product-details-desc-item\">\n            <div class=\"row\">\n                <div class=\"col-xl-12\">\n                    <div class=\"tp-product-details-desc-banner text-center m-img\">\n                        <h3 class=\"tp-product-details-desc-banner-title tp-product-details-desc-title\">Speed Memory Power = Epic Races</h3>\n                        <img src=\"/storage/main/products/product-details-desc-3.jpg\" alt=\"\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n','published','[\"jewelry\\/products\\/product-2.png\",\"jewelry\\/products\\/product-3.png\",\"jewelry\\/products\\/product-5.png\",\"jewelry\\/products\\/product-7.png\",\"jewelry\\/products\\/product-8.png\",\"jewelry\\/products\\/product-6.png\",\"jewelry\\/products\\/product-1.png\",\"jewelry\\/products\\/product-4.png\"]','LX-115-A0',0,17,0,1,0,2,0,0,795,NULL,NULL,NULL,11.00,15.00,19.00,652.00,NULL,193392,'2024-03-15 03:04:31','2024-03-15 03:04:34','in_stock',7,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(44,'Vintage Denim Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','YB-147-A0',0,15,0,1,0,3,1,0,724,NULL,NULL,NULL,18.00,14.00,16.00,575.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(45,'Floral Maxi Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','QT-132-A0',0,10,0,1,0,2,1,0,1287,NULL,NULL,NULL,16.00,13.00,14.00,577.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(46,'Leather Ankle Boots',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','PB-123-A0',0,13,0,1,0,5,1,0,1060,NULL,NULL,NULL,12.00,16.00,13.00,861.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(47,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','VV-152-A0',0,16,0,1,0,2,1,0,1781,1460.42,NULL,NULL,16.00,18.00,10.00,737.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(48,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','VV-152-A0-A1',0,16,0,1,0,2,1,0,1781,1602.9,NULL,NULL,16.00,18.00,10.00,737.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(49,'Knit Turtleneck Sweater (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','VV-152-A0-A2',0,16,0,1,0,2,1,0,1781,1602.9,NULL,NULL,16.00,18.00,10.00,737.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(50,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','JA-179-A0',0,20,0,1,0,1,1,0,817,NULL,NULL,NULL,13.00,12.00,15.00,726.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(51,'Classic Aviator Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','JA-179-A0-A1',0,20,0,1,0,1,1,0,817,NULL,NULL,NULL,13.00,12.00,15.00,726.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(52,'Tailored Wool Blazer',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','YS-157-A0',0,10,0,1,0,4,1,0,2297,NULL,NULL,NULL,16.00,13.00,19.00,617.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(53,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','2Q-144-A0',0,14,0,1,0,4,1,0,2440,NULL,NULL,NULL,10.00,14.00,17.00,704.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(54,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','2Q-144-A0-A1',0,14,0,1,0,4,1,0,2440,NULL,NULL,NULL,10.00,14.00,17.00,704.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(55,'Bohemian Fringe Handbag',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','2Q-144-A0-A2',0,14,0,1,0,4,1,0,2440,NULL,NULL,NULL,10.00,14.00,17.00,704.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(56,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','M5-139-A0',0,14,0,1,0,2,1,0,944,792.96,NULL,NULL,10.00,17.00,20.00,860.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(57,'Silk Scarf with Geometric Print (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','M5-139-A0-A1',0,14,0,1,0,2,1,0,944,802.4,NULL,NULL,10.00,17.00,20.00,860.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:31','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(58,'High-Waisted Wide Leg Trousers',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','8H-108-A0',0,12,0,1,0,5,1,0,1035,NULL,NULL,NULL,14.00,13.00,17.00,705.00,NULL,0,'2024-03-15 03:04:31','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(59,'Embroidered Boho Blouse',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','BH-124-A0',0,14,0,1,0,3,1,0,574,NULL,NULL,NULL,15.00,14.00,15.00,527.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(60,'Embroidered Boho Blouse',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','BH-124-A0-A1',0,14,0,1,0,3,1,0,574,NULL,NULL,NULL,15.00,14.00,15.00,527.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(61,'Embroidered Boho Blouse',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','BH-124-A0-A2',0,14,0,1,0,3,1,0,574,NULL,NULL,NULL,15.00,14.00,15.00,527.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(62,'Embroidered Boho Blouse',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','BH-124-A0-A3',0,14,0,1,0,3,1,0,574,NULL,NULL,NULL,15.00,14.00,15.00,527.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(63,'Statement Chunky Necklace',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','XO-112-A0',0,10,0,1,0,5,1,0,761,NULL,NULL,NULL,20.00,18.00,11.00,878.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(64,'Statement Chunky Necklace',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','XO-112-A0-A1',0,10,0,1,0,5,1,0,761,NULL,NULL,NULL,20.00,18.00,11.00,878.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(65,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','IL-161-A0',0,15,0,1,0,3,1,0,587,516.56,NULL,NULL,11.00,18.00,19.00,615.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(66,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','IL-161-A0-A1',0,15,0,1,0,3,1,0,587,510.69,NULL,NULL,11.00,18.00,19.00,615.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(67,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','IL-161-A0-A2',0,15,0,1,0,3,1,0,587,422.64,NULL,NULL,11.00,18.00,19.00,615.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(68,'Chic Fedora Hat (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','IL-161-A0-A3',0,15,0,1,0,3,1,0,587,469.6,NULL,NULL,11.00,18.00,19.00,615.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(69,'Strappy Block Heel Sandals',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','QP-144-A0',0,20,0,1,0,4,1,0,1140,NULL,NULL,NULL,17.00,10.00,15.00,591.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(70,'Velvet Evening Gown',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','SF-106-A0',0,13,0,1,0,1,1,0,452,NULL,NULL,NULL,17.00,10.00,20.00,638.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(71,'Velvet Evening Gown',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','SF-106-A0-A1',0,13,0,1,0,1,1,0,452,NULL,NULL,NULL,17.00,10.00,20.00,638.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(72,'Velvet Evening Gown',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','SF-106-A0-A2',0,13,0,1,0,1,1,0,452,NULL,NULL,NULL,17.00,10.00,20.00,638.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(73,'Quilted Crossbody Bag',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','VH-154-A0',0,17,0,1,0,4,1,0,1821,NULL,NULL,NULL,15.00,15.00,17.00,527.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(74,'Quilted Crossbody Bag',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','VH-154-A0-A1',0,17,0,1,0,4,1,0,1821,NULL,NULL,NULL,15.00,15.00,17.00,527.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(75,'Quilted Crossbody Bag',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','VH-154-A0-A2',0,17,0,1,0,4,1,0,1821,NULL,NULL,NULL,15.00,15.00,17.00,527.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(76,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','SW-162-A0',0,19,0,1,0,4,1,0,1908,1450.08,NULL,NULL,20.00,12.00,17.00,786.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(77,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','SW-162-A0-A1',0,19,0,1,0,4,1,0,1908,1450.08,NULL,NULL,20.00,12.00,17.00,786.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(78,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','SW-162-A0-A2',0,19,0,1,0,4,1,0,1908,1507.32,NULL,NULL,20.00,12.00,17.00,786.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(79,'Distressed Skinny Jeans (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','SW-162-A0-A3',0,19,0,1,0,4,1,0,1908,1373.76,NULL,NULL,20.00,12.00,17.00,786.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(80,'Lace-Up Combat Boots',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','DO-170-A0',0,15,0,1,0,1,1,0,424,NULL,NULL,NULL,14.00,10.00,12.00,807.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(81,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','NW-157-A0',0,12,0,1,0,2,1,0,2306,NULL,NULL,NULL,12.00,15.00,17.00,765.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(82,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','NW-157-A0-A1',0,12,0,1,0,2,1,0,2306,NULL,NULL,NULL,12.00,15.00,17.00,765.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(83,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','NW-157-A0-A2',0,12,0,1,0,2,1,0,2306,NULL,NULL,NULL,12.00,15.00,17.00,765.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(84,'Cotton Striped T-Shirt Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','NW-157-A0-A3',0,12,0,1,0,2,1,0,2306,NULL,NULL,NULL,12.00,15.00,17.00,765.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(85,'Printed Palazzo Pants',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','XE-152-A0',0,16,0,1,0,4,1,0,1706,NULL,NULL,NULL,16.00,18.00,14.00,816.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(86,'Printed Palazzo Pants',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','XE-152-A0-A1',0,16,0,1,0,4,1,0,1706,NULL,NULL,NULL,16.00,18.00,14.00,816.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(87,'Printed Palazzo Pants',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','XE-152-A0-A2',0,16,0,1,0,4,1,0,1706,NULL,NULL,NULL,16.00,18.00,14.00,816.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(88,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','ON-156-A0',0,11,0,1,0,5,1,0,425,378.25,NULL,NULL,17.00,10.00,17.00,809.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(89,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','ON-156-A0-A1',0,11,0,1,0,5,1,0,425,327.25,NULL,NULL,17.00,10.00,17.00,809.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(90,'Structured Satchel Bag (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','ON-156-A0-A2',0,11,0,1,0,5,1,0,425,327.25,NULL,NULL,17.00,10.00,17.00,809.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(91,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','MJ-187-A0',0,16,0,1,0,5,1,0,1744,NULL,NULL,NULL,12.00,11.00,11.00,897.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(92,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','MJ-187-A0-A1',0,16,0,1,0,5,1,0,1744,NULL,NULL,NULL,12.00,11.00,11.00,897.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(93,'Off-Shoulder Ruffle Top',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','MJ-187-A0-A2',0,16,0,1,0,5,1,0,1744,NULL,NULL,NULL,12.00,11.00,11.00,897.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(94,'Suede Pointed-Toe Pumps',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','4V-126-A0',0,19,0,1,0,5,1,0,1829,NULL,NULL,NULL,14.00,15.00,18.00,684.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(95,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','0Y-146-A0',0,18,0,1,0,3,1,0,2243,NULL,NULL,NULL,17.00,10.00,20.00,716.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(96,'Cropped Cable Knit Sweater',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','0Y-146-A0-A1',0,18,0,1,0,3,1,0,2243,NULL,NULL,NULL,17.00,10.00,20.00,716.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(97,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','GH-176-A0',0,18,0,1,0,5,1,0,1555,1166.25,NULL,NULL,19.00,20.00,17.00,504.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(98,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','GH-176-A0-A1',0,18,0,1,0,5,1,0,1555,1290.65,NULL,NULL,19.00,20.00,17.00,504.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(99,'Athleisure Jogger Pants (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','GH-176-A0-A2',0,18,0,1,0,5,1,0,1555,1306.2,NULL,NULL,19.00,20.00,17.00,504.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(100,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','OA-178-A0',0,10,0,1,0,3,1,0,666,NULL,NULL,NULL,12.00,19.00,15.00,568.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(101,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','OA-178-A0-A1',0,10,0,1,0,3,1,0,666,NULL,NULL,NULL,12.00,19.00,15.00,568.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(102,'Leopard Print Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','OA-178-A0-A2',0,10,0,1,0,3,1,0,666,NULL,NULL,NULL,12.00,19.00,15.00,568.00,NULL,0,'2024-03-15 03:04:32','2024-03-15 03:04:32','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(103,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','0V-138-A0',0,10,0,1,0,2,1,0,874,NULL,NULL,NULL,13.00,14.00,15.00,805.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(104,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','0V-138-A0-A1',0,10,0,1,0,2,1,0,874,NULL,NULL,NULL,13.00,14.00,15.00,805.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(105,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','0V-138-A0-A2',0,10,0,1,0,2,1,0,874,NULL,NULL,NULL,13.00,14.00,15.00,805.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(106,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','0V-138-A0-A3',0,10,0,1,0,2,1,0,874,NULL,NULL,NULL,13.00,14.00,15.00,805.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(107,'Retro Cat-Eye Sunglasses',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','0V-138-A0-A4',0,10,0,1,0,2,1,0,874,NULL,NULL,NULL,13.00,14.00,15.00,805.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(108,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','QE-163-A0',0,11,0,1,0,2,1,0,579,NULL,NULL,NULL,12.00,14.00,17.00,899.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(109,'Faux Fur Trimmed Coat',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','QE-163-A0-A1',0,11,0,1,0,2,1,0,579,NULL,NULL,NULL,12.00,14.00,17.00,899.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(110,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','B4-149-A0',0,15,0,1,0,4,1,0,2305,1844,NULL,NULL,16.00,16.00,12.00,571.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(111,'Boho Fringed Kimono (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','B4-149-A0-A1',0,15,0,1,0,4,1,0,2305,1844,NULL,NULL,16.00,16.00,12.00,571.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(112,'Ruffled Wrap Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','7A-136-A0',0,10,0,1,0,4,1,0,1378,NULL,NULL,NULL,19.00,19.00,19.00,790.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(113,'Ruffled Wrap Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','7A-136-A0-A1',0,10,0,1,0,4,1,0,1378,NULL,NULL,NULL,19.00,19.00,19.00,790.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(114,'Ruffled Wrap Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','7A-136-A0-A2',0,10,0,1,0,4,1,0,1378,NULL,NULL,NULL,19.00,19.00,19.00,790.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(115,'Ruffled Wrap Dress',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','7A-136-A0-A3',0,10,0,1,0,4,1,0,1378,NULL,NULL,NULL,19.00,19.00,19.00,790.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(116,'Beaded Evening Clutch',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','DM-189-A0',0,12,0,1,0,4,1,0,775,NULL,NULL,NULL,15.00,11.00,16.00,700.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(117,'Beaded Evening Clutch',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','DM-189-A0-A1',0,12,0,1,0,4,1,0,775,NULL,NULL,NULL,15.00,11.00,16.00,700.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(118,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','DA-123-A0',0,17,0,1,0,1,1,0,1961,NULL,NULL,NULL,19.00,10.00,12.00,505.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(119,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','DA-123-A0-A1',0,17,0,1,0,1,1,0,1961,NULL,NULL,NULL,19.00,10.00,12.00,505.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(120,'Wide Brim Floppy Hat',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','DA-123-A0-A2',0,17,0,1,0,1,1,0,1961,NULL,NULL,NULL,19.00,10.00,12.00,505.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(121,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','ZP-152-A0',0,15,0,1,0,5,1,0,441,361.62,NULL,NULL,14.00,11.00,13.00,672.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(122,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','ZP-152-A0-A1',0,15,0,1,0,5,1,0,441,326.34,NULL,NULL,14.00,11.00,13.00,672.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(123,'Denim Overall Jumpsuit (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','ZP-152-A0-A2',0,15,0,1,0,5,1,0,441,370.44,NULL,NULL,14.00,11.00,13.00,672.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(124,'Embellished Ballet Flats',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','TO-194-A0',0,17,0,1,0,1,1,0,318,NULL,NULL,NULL,12.00,20.00,18.00,793.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(125,'Embellished Ballet Flats',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','TO-194-A0-A1',0,17,0,1,0,1,1,0,318,NULL,NULL,NULL,12.00,20.00,18.00,793.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(126,'Embellished Ballet Flats',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','TO-194-A0-A2',0,17,0,1,0,1,1,0,318,NULL,NULL,NULL,12.00,20.00,18.00,793.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(127,'Embellished Ballet Flats',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','TO-194-A0-A3',0,17,0,1,0,1,1,0,318,NULL,NULL,NULL,12.00,20.00,18.00,793.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(128,'Pleated Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','LQ-100-A0',0,17,0,1,0,1,1,0,513,NULL,NULL,NULL,17.00,19.00,17.00,583.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(129,'Pleated Midi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','LQ-100-A0-A1',0,17,0,1,0,1,1,0,513,NULL,NULL,NULL,17.00,19.00,17.00,583.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(130,'Velour Tracksuit Set',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','F5-146-A0',0,15,0,1,0,5,1,0,1737,NULL,NULL,NULL,18.00,19.00,17.00,817.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(131,'Velour Tracksuit Set',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','F5-146-A0-A1',0,15,0,1,0,5,1,0,1737,NULL,NULL,NULL,18.00,19.00,17.00,817.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(132,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','HN-174-A0',0,16,0,1,0,2,1,0,781,577.94,NULL,NULL,16.00,17.00,15.00,517.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(133,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','HN-174-A0-A1',0,16,0,1,0,2,1,0,781,687.28,NULL,NULL,16.00,17.00,15.00,517.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(134,'Geometric Patterned Cardigan (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','HN-174-A0-A2',0,16,0,1,0,2,1,0,781,562.32,NULL,NULL,16.00,17.00,15.00,517.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(135,'Buckle Detail Ankle Booties',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','X8-116-A0',0,19,0,1,0,2,1,0,302,NULL,NULL,NULL,20.00,11.00,10.00,654.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(136,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','IK-105-A0',0,13,0,1,0,1,1,0,2062,NULL,NULL,NULL,20.00,13.00,10.00,674.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(137,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','IK-105-A0-A1',0,13,0,1,0,1,1,0,2062,NULL,NULL,NULL,20.00,13.00,10.00,674.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(138,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','IK-105-A0-A2',0,13,0,1,0,1,1,0,2062,NULL,NULL,NULL,20.00,13.00,10.00,674.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(139,'Embroidered Bomber Jacket',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','IK-105-A0-A3',0,13,0,1,0,1,1,0,2062,NULL,NULL,NULL,20.00,13.00,10.00,674.00,NULL,0,'2024-03-15 03:04:33','2024-03-15 03:04:33','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(140,'Cowl Neck Knit Poncho',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','A7-196-A0',0,16,0,1,0,3,1,0,1757,NULL,NULL,NULL,17.00,11.00,17.00,665.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(141,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','Z7-188-A0',0,17,0,1,0,3,1,0,2418,2103.66,NULL,NULL,11.00,17.00,16.00,827.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(142,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-4.png\"]','Z7-188-A0-A1',0,17,0,1,0,3,1,0,2418,1886.04,NULL,NULL,11.00,17.00,16.00,827.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(143,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-5.png\"]','Z7-188-A0-A2',0,17,0,1,0,3,1,0,2418,1813.5,NULL,NULL,11.00,17.00,16.00,827.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(144,'Chunky Knit Infinity Scarf (Digital)',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','Z7-188-A0-A3',0,17,0,1,0,3,1,0,2418,2055.3,NULL,NULL,11.00,17.00,16.00,827.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'digital',NULL,NULL,0),(145,'Retro High-Top Sneakers',NULL,NULL,'published','[\"jewelry\\/products\\/product-1.png\"]','LW-110-A0',0,11,0,1,0,5,1,0,2005,NULL,NULL,NULL,12.00,17.00,15.00,840.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(146,'Faux Leather Leggings',NULL,NULL,'published','[\"jewelry\\/products\\/product-3.png\"]','GR-126-A0',0,20,0,1,0,3,1,0,1644,NULL,NULL,NULL,16.00,17.00,18.00,546.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(147,'Faux Leather Leggings',NULL,NULL,'published','[\"jewelry\\/products\\/product-7.png\"]','GR-126-A0-A1',0,20,0,1,0,3,1,0,1644,NULL,NULL,NULL,16.00,17.00,18.00,546.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(148,'Faux Leather Leggings',NULL,NULL,'published','[\"jewelry\\/products\\/product-8.png\"]','GR-126-A0-A2',0,20,0,1,0,3,1,0,1644,NULL,NULL,NULL,16.00,17.00,18.00,546.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(149,'Faux Leather Leggings',NULL,NULL,'published','[\"jewelry\\/products\\/product-6.png\"]','GR-126-A0-A3',0,20,0,1,0,3,1,0,1644,NULL,NULL,NULL,16.00,17.00,18.00,546.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0),(150,'Metallic Pleated Maxi Skirt',NULL,NULL,'published','[\"jewelry\\/products\\/product-2.png\"]','LX-115-A0',0,17,0,1,0,2,1,0,795,NULL,NULL,NULL,11.00,15.00,19.00,652.00,NULL,0,'2024-03-15 03:04:34','2024-03-15 03:04:34','in_stock',NULL,0,'Botble\\ACL\\Models\\User',0,NULL,'physical',NULL,NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,4,42,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\"]'),(2,10,43,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(3,4,43,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(4,6,30,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(5,7,41,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(6,10,14,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-10.jpg\"]'),(7,9,7,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(8,10,42,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(9,10,1,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(10,9,24,1.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\"]'),(11,7,7,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(12,10,12,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(13,2,8,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(14,10,2,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(15,7,19,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-19.jpg\"]'),(16,5,8,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\"]'),(17,4,24,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(18,8,9,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\"]'),(19,1,43,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\"]'),(20,4,7,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\"]'),(21,2,19,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(22,2,25,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(23,10,21,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(24,3,41,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\"]'),(25,10,39,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-19.jpg\"]'),(26,2,41,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(27,1,14,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\"]'),(28,10,36,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-16.jpg\"]'),(29,6,7,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\"]'),(30,6,10,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(31,3,8,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\"]'),(32,6,17,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(33,7,17,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(34,7,28,3.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-20.jpg\"]'),(35,2,28,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(36,6,39,1.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(37,10,19,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(38,4,30,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\"]'),(39,5,30,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(40,2,3,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\"]'),(41,8,19,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(42,5,21,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-16.jpg\"]'),(43,9,28,4.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(45,5,25,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(46,5,13,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-16.jpg\"]'),(49,4,25,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(50,9,16,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\"]'),(52,9,23,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(53,6,29,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-16.jpg\"]'),(54,1,11,4.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\"]'),(55,5,40,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\"]'),(56,3,16,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\"]'),(57,2,36,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(58,2,42,1.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\"]'),(59,4,19,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\"]'),(60,4,4,1.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\"]'),(61,7,40,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(62,7,8,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\"]'),(63,6,31,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(64,4,35,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(65,7,14,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\"]'),(67,6,35,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\"]'),(68,2,16,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(69,1,32,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(70,5,43,3.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\"]'),(71,6,2,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(72,10,30,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(75,1,15,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\"]'),(76,6,23,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\"]'),(78,8,5,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(79,8,38,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(80,4,36,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(81,2,17,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-17.jpg\"]'),(83,9,25,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(84,1,4,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(85,2,13,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\"]'),(87,6,6,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\"]'),(89,5,16,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\"]'),(90,2,30,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\"]'),(91,1,5,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(92,10,7,5.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(93,6,26,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(94,9,12,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(96,9,21,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\"]'),(97,2,26,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(98,10,18,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(99,1,12,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\"]'),(100,3,27,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(101,3,6,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\"]'),(102,7,36,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\"]'),(103,5,41,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\"]'),(104,8,35,3.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(105,6,40,2.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\"]'),(106,6,34,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(107,10,41,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(108,6,13,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(109,2,40,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(111,2,5,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\"]'),(112,10,15,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\"]'),(113,8,36,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(114,3,5,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\"]'),(115,10,28,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-20.jpg\"]'),(116,7,27,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\"]'),(117,3,33,1.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-13.jpg\"]'),(118,10,20,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(119,1,8,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(120,3,37,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-18.jpg\"]'),(127,7,29,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\"]'),(129,7,3,3.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\"]'),(130,3,30,2.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(131,5,26,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\"]'),(132,9,36,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(133,6,43,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-20.jpg\"]'),(135,10,32,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\"]'),(137,8,34,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\"]'),(138,6,33,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(139,5,1,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(140,6,41,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(142,4,13,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\"]'),(143,10,29,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(144,2,31,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(146,8,14,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\"]'),(147,9,43,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-17.jpg\"]'),(148,3,38,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(151,9,29,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(152,7,24,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(154,8,16,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-17.jpg\"]'),(156,3,3,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(157,4,6,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(158,4,15,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(159,10,4,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(161,3,22,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(163,2,37,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\"]'),(165,3,34,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\"]'),(166,2,22,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(167,3,9,5.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\"]'),(168,2,18,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(169,5,2,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-18.jpg\"]'),(170,1,34,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\"]'),(171,3,12,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\"]'),(172,5,33,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(176,1,42,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(182,10,16,4.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(185,9,34,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(187,4,37,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(189,3,25,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-11.jpg\"]'),(190,3,42,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(191,7,11,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(192,4,9,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-19.jpg\"]'),(193,9,8,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(197,5,38,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(198,1,41,4.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(202,8,27,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-19.jpg\"]'),(206,8,39,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\"]'),(207,2,23,4.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\"]'),(208,10,24,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-20.jpg\"]'),(210,7,9,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(211,3,14,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(212,6,21,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\"]'),(213,7,22,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\"]'),(216,1,3,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-14.jpg\"]'),(217,2,35,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(218,7,34,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\"]'),(219,5,3,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(221,7,31,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-18.jpg\"]'),(222,10,22,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\"]'),(223,9,3,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(224,9,10,3.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\"]'),(225,4,28,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\"]'),(227,5,23,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\"]'),(231,6,12,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-14.jpg\"]'),(233,5,29,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(234,1,16,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\"]'),(236,8,20,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(237,8,3,4.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(241,2,15,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(244,9,1,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(250,2,27,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(251,3,21,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(252,4,17,4.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(253,10,25,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(257,9,2,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(258,5,34,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\"]'),(261,9,14,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(262,8,21,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\"]'),(265,8,17,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(266,9,33,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\"]'),(267,6,15,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\"]'),(268,8,30,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(270,7,18,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\"]'),(272,5,32,5.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-19.jpg\"]'),(273,5,18,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(275,1,33,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\"]'),(276,7,10,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(278,8,15,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\"]'),(279,5,15,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(281,2,24,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(283,2,9,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(288,1,20,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(289,8,28,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\"]'),(292,7,12,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-18.jpg\"]'),(295,9,37,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(296,2,39,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(298,1,26,2.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(301,10,26,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\"]'),(302,3,39,4.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(303,9,20,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\"]'),(305,10,6,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\"]'),(306,10,23,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(308,6,14,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(311,1,7,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(312,4,8,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(315,4,39,4.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\"]'),(318,5,10,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-20.jpg\"]'),(321,4,18,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(322,4,27,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(323,3,10,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(324,9,18,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(326,5,7,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(327,8,2,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-15.jpg\"]'),(335,2,1,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(336,6,18,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(337,10,40,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(338,1,25,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\"]'),(341,2,32,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-17.jpg\"]'),(343,4,3,5.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(344,2,29,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-18.jpg\"]'),(345,1,23,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\"]'),(347,10,27,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\"]'),(348,1,37,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\"]'),(349,4,20,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-20.jpg\"]'),(352,1,6,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\"]'),(353,7,21,3.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\"]'),(355,5,24,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\"]'),(356,9,39,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-15.jpg\"]'),(360,5,37,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(361,5,5,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-18.jpg\"]'),(363,3,11,1.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-19.jpg\"]'),(366,9,31,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(367,3,31,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\"]'),(368,1,38,4.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\"]'),(369,3,36,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(370,10,34,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\"]'),(372,2,14,2.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(373,10,38,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(374,6,24,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\"]'),(375,4,31,3.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\"]'),(377,8,8,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(378,10,35,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(386,8,43,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(390,1,31,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-2.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(391,7,20,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\"]'),(392,9,42,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\"]'),(396,10,11,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(398,8,1,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\"]'),(399,8,6,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\"]'),(400,8,23,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\"]'),(401,4,26,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(406,7,39,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(409,3,24,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(412,5,14,3.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(414,5,22,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(415,6,28,1.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(416,7,23,3.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-20.jpg\"]'),(419,3,32,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\"]'),(421,9,19,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(424,8,42,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-20.jpg\"]'),(428,6,1,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(431,1,13,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\"]'),(441,8,41,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(442,2,4,3.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-16.jpg\"]'),(443,10,10,5.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(444,3,26,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\"]'),(446,3,43,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(449,6,19,1.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(451,10,9,1.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(453,3,4,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(455,9,35,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\"]'),(457,9,30,3.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(461,2,34,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-18.jpg\"]'),(463,9,22,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(464,6,5,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(468,4,32,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(469,3,29,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-19.jpg\"]'),(473,5,12,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(475,4,22,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(476,1,36,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(477,8,4,3.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(479,3,18,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-20.jpg\"]'),(483,5,36,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(487,8,25,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-18.jpg\"]'),(488,7,16,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\"]'),(489,7,2,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-13.jpg\"]'),(495,8,7,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(497,1,24,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(499,3,40,4.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(504,8,31,1.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(508,3,2,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\"]'),(511,3,23,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(514,2,6,5.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\"]'),(516,2,11,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(520,4,5,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\"]'),(522,7,26,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\"]'),(525,1,18,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\"]'),(541,4,1,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\"]'),(543,3,19,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]'),(546,4,29,5.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-3.jpg\"]'),(554,1,10,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(562,3,20,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\"]'),(563,7,38,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(569,5,9,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-14.jpg\"]'),(572,1,19,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\"]'),(575,8,29,3.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-14.jpg\"]'),(578,4,34,4.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-12.jpg\"]'),(583,6,27,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-19.jpg\"]'),(587,1,22,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(589,3,17,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(591,5,6,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(597,7,4,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-19.jpg\"]'),(602,5,28,4.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(603,6,25,5.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\"]'),(607,9,4,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(608,4,21,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\"]'),(611,7,32,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\"]'),(613,7,5,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(616,7,15,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\"]'),(620,5,19,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-20.jpg\"]'),(621,8,24,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-16.jpg\"]'),(622,1,1,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(623,6,9,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-16.jpg\"]'),(628,8,33,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(629,1,40,3.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\"]'),(630,5,31,2.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\"]'),(634,6,16,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-17.jpg\"]'),(636,6,8,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\"]'),(637,2,21,3.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]'),(639,1,21,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-16.jpg\"]'),(644,3,7,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-19.jpg\"]'),(647,9,13,4.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(652,10,3,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-19.jpg\"]'),(653,3,1,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-19.jpg\"]'),(656,6,3,1.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-16.jpg\"]'),(668,6,4,1.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-13.jpg\"]'),(676,5,42,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-12.jpg\"]'),(687,6,22,1.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-18.jpg\"]'),(691,8,40,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-19.jpg\"]'),(695,7,42,3.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-18.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(696,3,35,5.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\"]'),(700,6,37,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\"]'),(702,4,16,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\"]'),(705,9,17,4.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(708,5,17,2.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\"]'),(711,8,37,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-12.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(715,8,13,4.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-12.jpg\"]'),(716,4,2,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(728,2,33,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\"]'),(733,7,43,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-16.jpg\"]'),(738,2,12,4.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(740,2,2,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\"]'),(742,2,38,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(744,7,35,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\"]'),(749,7,33,2.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-17.jpg\"]'),(750,4,38,2.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(754,4,23,2.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-12.jpg\"]'),(756,4,40,1.00,'Good app, good backup service and support. Good documentation.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-19.jpg\"]'),(759,4,11,1.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(761,9,41,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-9.jpg\"]'),(774,3,13,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-18.jpg\"]'),(775,6,32,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(777,5,35,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-20.jpg\"]'),(779,1,2,4.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(781,4,14,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-18.jpg\"]'),(784,5,39,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-2.jpg\"]'),(788,7,1,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-13.jpg\"]'),(789,3,28,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-7.jpg\"]'),(793,10,8,1.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(795,4,10,1.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(803,1,35,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(819,2,20,2.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-12.jpg\"]'),(820,5,20,5.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\",\"main\\/products\\/product-19.jpg\"]'),(829,8,18,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-19.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(837,10,5,2.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-19.jpg\"]'),(840,6,11,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\"]'),(842,6,36,5.00,'Clean & perfect source code','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-4.jpg\",\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-17.jpg\"]'),(862,9,15,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-17.jpg\"]'),(866,8,32,5.00,'Best ecommerce CMS online store!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-13.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-18.jpg\"]'),(877,8,22,2.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-details-desc-1.jpg\"]'),(879,5,11,3.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-16.jpg\"]'),(899,9,5,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-6.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(926,1,30,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-details-desc-1.jpg\"]'),(930,4,41,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(931,2,10,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\"]'),(933,10,13,5.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-19.jpg\"]'),(946,5,4,4.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-7.jpg\",\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-9.jpg\",\"main\\/products\\/product-15.jpg\"]'),(952,2,7,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-3.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-20.jpg\"]'),(955,10,33,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-1.jpg\",\"main\\/products\\/product-8.jpg\"]'),(965,9,32,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-2.jpg\",\"main\\/products\\/product-details-desc-2.jpg\"]'),(973,8,12,1.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-17.jpg\",\"main\\/products\\/product-20.jpg\",\"main\\/products\\/product-details-desc-1.jpg\",\"main\\/products\\/product-details-desc-3.jpg\"]'),(988,8,11,4.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-5.jpg\",\"main\\/products\\/product-13.jpg\"]'),(991,9,26,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-10.jpg\",\"main\\/products\\/product-15.jpg\",\"main\\/products\\/product-16.jpg\"]'),(992,9,27,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2024-03-15 03:05:07','2024-03-15 03:05:07','[\"main\\/products\\/product-8.jpg\",\"main\\/products\\/product-11.jpg\",\"main\\/products\\/product-14.jpg\",\"main\\/products\\/product-18.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,1,'2024-02-29 03:04:36','2024-02-29 03:04:36','Botble\\ACL\\Models\\User'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,1,'2024-03-13 11:04:36','2024-03-15 03:04:36','Botble\\ACL\\Models\\User'),(3,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,1,'2024-03-15 03:04:36','2024-03-15 03:04:36','Botble\\ACL\\Models\\User'),(4,'create_from_order','Shipping was created from order %order_id%',0,2,2,'2024-03-13 11:04:36','2024-03-13 11:04:36','Botble\\ACL\\Models\\User'),(5,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,2,'2024-03-13 11:04:36','2024-03-15 03:04:36','Botble\\ACL\\Models\\User'),(6,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,2,2,'2024-03-15 03:04:36','2024-03-15 03:04:36','Botble\\ACL\\Models\\User'),(7,'create_from_order','Shipping was created from order %order_id%',0,3,3,'2024-02-29 03:04:36','2024-02-29 03:04:36','Botble\\ACL\\Models\\User'),(8,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,3,'2024-03-13 11:04:37','2024-03-15 03:04:37','Botble\\ACL\\Models\\User'),(9,'create_from_order','Shipping was created from order %order_id%',0,4,5,'2024-03-08 19:04:37','2024-03-08 19:04:37','Botble\\ACL\\Models\\User'),(10,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,5,'2024-03-13 13:04:37','2024-03-15 03:04:37','Botble\\ACL\\Models\\User'),(11,'create_from_order','Shipping was created from order %order_id%',0,5,6,'2024-03-05 15:04:37','2024-03-05 15:04:37','Botble\\ACL\\Models\\User'),(12,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,6,'2024-03-13 13:04:37','2024-03-15 03:04:37','Botble\\ACL\\Models\\User'),(13,'create_from_order','Shipping was created from order %order_id%',0,6,7,'2024-03-06 03:04:37','2024-03-06 03:04:37','Botble\\ACL\\Models\\User'),(14,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,7,'2024-03-13 15:04:37','2024-03-15 03:04:37','Botble\\ACL\\Models\\User'),(15,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,7,'2024-03-15 03:04:37','2024-03-15 03:04:37','Botble\\ACL\\Models\\User'),(16,'create_from_order','Shipping was created from order %order_id%',0,7,8,'2024-03-01 15:04:37','2024-03-01 15:04:37','Botble\\ACL\\Models\\User'),(17,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,8,'2024-03-13 15:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(18,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,7,8,'2024-03-15 03:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(19,'create_from_order','Shipping was created from order %order_id%',0,8,9,'2024-03-08 01:04:38','2024-03-08 01:04:38','Botble\\ACL\\Models\\User'),(20,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,9,'2024-03-13 17:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(21,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,8,9,'2024-03-15 03:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(22,'create_from_order','Shipping was created from order %order_id%',0,9,10,'2024-02-29 23:04:38','2024-02-29 23:04:38','Botble\\ACL\\Models\\User'),(23,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,10,'2024-03-13 17:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(24,'create_from_order','Shipping was created from order %order_id%',0,10,11,'2024-03-09 11:04:38','2024-03-09 11:04:38','Botble\\ACL\\Models\\User'),(25,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,11,'2024-03-13 17:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(26,'create_from_order','Shipping was created from order %order_id%',0,11,12,'2024-03-09 19:04:38','2024-03-09 19:04:38','Botble\\ACL\\Models\\User'),(27,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,12,'2024-03-13 19:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(28,'create_from_order','Shipping was created from order %order_id%',0,12,13,'2024-03-03 03:04:38','2024-03-03 03:04:38','Botble\\ACL\\Models\\User'),(29,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,13,'2024-03-13 19:04:38','2024-03-15 03:04:38','Botble\\ACL\\Models\\User'),(30,'create_from_order','Shipping was created from order %order_id%',0,13,14,'2024-03-08 11:04:38','2024-03-08 11:04:38','Botble\\ACL\\Models\\User'),(31,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,14,'2024-03-13 19:04:39','2024-03-15 03:04:39','Botble\\ACL\\Models\\User'),(32,'create_from_order','Shipping was created from order %order_id%',0,14,15,'2024-03-08 21:04:39','2024-03-08 21:04:39','Botble\\ACL\\Models\\User'),(33,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,15,'2024-03-13 21:04:39','2024-03-15 03:04:39','Botble\\ACL\\Models\\User'),(34,'create_from_order','Shipping was created from order %order_id%',0,15,16,'2024-03-10 03:04:39','2024-03-10 03:04:39','Botble\\ACL\\Models\\User'),(35,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,16,'2024-03-13 21:04:39','2024-03-15 03:04:39','Botble\\ACL\\Models\\User'),(36,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,15,16,'2024-03-15 03:04:39','2024-03-15 03:04:39','Botble\\ACL\\Models\\User'),(37,'create_from_order','Shipping was created from order %order_id%',0,16,18,'2024-03-05 19:04:39','2024-03-05 19:04:39','Botble\\ACL\\Models\\User'),(38,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,18,'2024-03-13 23:04:39','2024-03-15 03:04:39','Botble\\ACL\\Models\\User'),(39,'create_from_order','Shipping was created from order %order_id%',0,17,19,'2024-03-09 17:04:39','2024-03-09 17:04:39','Botble\\ACL\\Models\\User'),(40,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,19,'2024-03-14 01:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(41,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,17,19,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(42,'create_from_order','Shipping was created from order %order_id%',0,18,20,'2024-03-11 21:04:40','2024-03-11 21:04:40','Botble\\ACL\\Models\\User'),(43,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,20,'2024-03-14 01:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(44,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,20,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(45,'create_from_order','Shipping was created from order %order_id%',0,19,21,'2024-03-06 11:04:40','2024-03-06 11:04:40','Botble\\ACL\\Models\\User'),(46,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,21,'2024-03-14 01:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(47,'create_from_order','Shipping was created from order %order_id%',0,20,22,'2024-03-06 03:04:40','2024-03-06 03:04:40','Botble\\ACL\\Models\\User'),(48,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,22,'2024-03-14 03:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(49,'create_from_order','Shipping was created from order %order_id%',0,21,23,'2024-03-13 03:04:40','2024-03-13 03:04:40','Botble\\ACL\\Models\\User'),(50,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,23,'2024-03-14 03:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(51,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,21,23,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(52,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,21,23,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\ACL\\Models\\User'),(53,'create_from_order','Shipping was created from order %order_id%',0,22,24,'2024-03-10 03:04:40','2024-03-10 03:04:40','Botble\\ACL\\Models\\User'),(54,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,24,'2024-03-14 03:04:41','2024-03-15 03:04:41','Botble\\ACL\\Models\\User'),(55,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,22,24,'2024-03-15 03:04:41','2024-03-15 03:04:41','Botble\\ACL\\Models\\User'),(56,'create_from_order','Shipping was created from order %order_id%',0,23,25,'2024-03-14 03:04:41','2024-03-14 03:04:41','Botble\\ACL\\Models\\User'),(57,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,25,'2024-03-14 03:04:41','2024-03-15 03:04:41','Botble\\ACL\\Models\\User'),(58,'create_from_order','Shipping was created from order %order_id%',0,24,26,'2024-03-10 13:04:41','2024-03-10 13:04:41','Botble\\ACL\\Models\\User'),(59,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,26,'2024-03-14 05:04:41','2024-03-15 03:04:41','Botble\\ACL\\Models\\User'),(60,'create_from_order','Shipping was created from order %order_id%',0,25,28,'2024-03-14 05:04:41','2024-03-14 05:04:41','Botble\\ACL\\Models\\User'),(61,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,28,'2024-03-14 05:04:41','2024-03-15 03:04:41','Botble\\ACL\\Models\\User'),(62,'create_from_order','Shipping was created from order %order_id%',0,26,29,'2024-03-10 03:04:41','2024-03-10 03:04:41','Botble\\ACL\\Models\\User'),(63,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,29,'2024-03-14 07:04:42','2024-03-15 03:04:42','Botble\\ACL\\Models\\User'),(64,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,26,29,'2024-03-15 03:04:42','2024-03-15 03:04:42','Botble\\ACL\\Models\\User'),(65,'create_from_order','Shipping was created from order %order_id%',0,27,32,'2024-03-09 07:04:42','2024-03-09 07:04:42','Botble\\ACL\\Models\\User'),(66,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,32,'2024-03-14 07:04:42','2024-03-15 03:04:42','Botble\\ACL\\Models\\User'),(67,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,27,32,'2024-03-15 03:04:42','2024-03-15 03:04:42','Botble\\ACL\\Models\\User'),(68,'create_from_order','Shipping was created from order %order_id%',0,28,33,'2024-03-14 09:04:42','2024-03-14 09:04:42','Botble\\ACL\\Models\\User'),(69,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,33,'2024-03-14 09:04:42','2024-03-15 03:04:42','Botble\\ACL\\Models\\User'),(70,'create_from_order','Shipping was created from order %order_id%',0,29,36,'2024-03-10 15:04:43','2024-03-10 15:04:43','Botble\\ACL\\Models\\User'),(71,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,36,'2024-03-14 09:04:43','2024-03-15 03:04:43','Botble\\ACL\\Models\\User'),(72,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,29,36,'2024-03-15 03:04:43','2024-03-15 03:04:43','Botble\\ACL\\Models\\User'),(73,'create_from_order','Shipping was created from order %order_id%',0,30,37,'2024-03-10 11:04:43','2024-03-10 11:04:43','Botble\\ACL\\Models\\User'),(74,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,37,'2024-03-14 11:04:43','2024-03-15 03:04:43','Botble\\ACL\\Models\\User'),(75,'create_from_order','Shipping was created from order %order_id%',0,31,38,'2024-03-09 03:04:43','2024-03-09 03:04:43','Botble\\ACL\\Models\\User'),(76,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,38,'2024-03-14 11:04:43','2024-03-15 03:04:43','Botble\\ACL\\Models\\User'),(77,'create_from_order','Shipping was created from order %order_id%',0,32,39,'2024-03-11 03:04:43','2024-03-11 03:04:43','Botble\\ACL\\Models\\User'),(78,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,39,'2024-03-14 11:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(79,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,32,39,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(80,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,39,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(81,'create_from_order','Shipping was created from order %order_id%',0,33,40,'2024-03-09 21:04:44','2024-03-09 21:04:44','Botble\\ACL\\Models\\User'),(82,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,40,'2024-03-14 13:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(83,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,33,40,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(84,'create_from_order','Shipping was created from order %order_id%',0,34,42,'2024-03-09 07:04:44','2024-03-09 07:04:44','Botble\\ACL\\Models\\User'),(85,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,42,'2024-03-14 13:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(86,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,34,42,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(87,'create_from_order','Shipping was created from order %order_id%',0,35,43,'2024-03-13 03:04:44','2024-03-13 03:04:44','Botble\\ACL\\Models\\User'),(88,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,43,'2024-03-14 15:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(89,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,35,43,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\ACL\\Models\\User'),(90,'create_from_order','Shipping was created from order %order_id%',0,36,45,'2024-03-12 03:04:45','2024-03-12 03:04:45','Botble\\ACL\\Models\\User'),(91,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,45,'2024-03-14 15:04:45','2024-03-15 03:04:45','Botble\\ACL\\Models\\User'),(92,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,36,45,'2024-03-15 03:04:45','2024-03-15 03:04:45','Botble\\ACL\\Models\\User'),(93,'create_from_order','Shipping was created from order %order_id%',0,37,47,'2024-03-11 09:04:45','2024-03-11 09:04:45','Botble\\ACL\\Models\\User'),(94,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,47,'2024-03-14 17:04:45','2024-03-15 03:04:45','Botble\\ACL\\Models\\User'),(95,'create_from_order','Shipping was created from order %order_id%',0,38,48,'2024-03-13 11:04:45','2024-03-13 11:04:45','Botble\\ACL\\Models\\User'),(96,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,38,48,'2024-03-14 17:04:45','2024-03-15 03:04:45','Botble\\ACL\\Models\\User'),(97,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,38,48,'2024-03-15 03:04:45','2024-03-15 03:04:45','Botble\\ACL\\Models\\User'),(98,'create_from_order','Shipping was created from order %order_id%',0,39,49,'2024-03-10 23:04:45','2024-03-10 23:04:45','Botble\\ACL\\Models\\User'),(99,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,39,49,'2024-03-14 17:04:46','2024-03-15 03:04:46','Botble\\ACL\\Models\\User'),(100,'create_from_order','Shipping was created from order %order_id%',0,40,50,'2024-03-14 03:04:46','2024-03-14 03:04:46','Botble\\ACL\\Models\\User'),(101,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,40,50,'2024-03-14 19:04:46','2024-03-15 03:04:46','Botble\\ACL\\Models\\User'),(102,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,50,'2024-03-15 03:04:46','2024-03-15 03:04:46','Botble\\ACL\\Models\\User'),(103,'create_from_order','Shipping was created from order %order_id%',0,41,52,'2024-03-12 11:04:46','2024-03-12 11:04:46','Botble\\ACL\\Models\\User'),(104,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,41,52,'2024-03-14 19:04:46','2024-03-15 03:04:46','Botble\\ACL\\Models\\User'),(105,'create_from_order','Shipping was created from order %order_id%',0,42,53,'2024-03-12 15:04:46','2024-03-12 15:04:46','Botble\\ACL\\Models\\User'),(106,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,42,53,'2024-03-14 21:04:46','2024-03-15 03:04:46','Botble\\ACL\\Models\\User'),(107,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,42,53,'2024-03-15 03:04:46','2024-03-15 03:04:46','Botble\\ACL\\Models\\User'),(108,'create_from_order','Shipping was created from order %order_id%',0,43,54,'2024-03-12 15:04:46','2024-03-12 15:04:46','Botble\\ACL\\Models\\User'),(109,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,43,54,'2024-03-14 21:04:46','2024-03-15 03:04:46','Botble\\ACL\\Models\\User'),(110,'create_from_order','Shipping was created from order %order_id%',0,44,56,'2024-03-13 15:04:47','2024-03-13 15:04:47','Botble\\ACL\\Models\\User'),(111,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,44,56,'2024-03-14 23:04:47','2024-03-15 03:04:47','Botble\\ACL\\Models\\User'),(112,'create_from_order','Shipping was created from order %order_id%',0,45,57,'2024-03-14 15:04:47','2024-03-14 15:04:47','Botble\\ACL\\Models\\User'),(113,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,45,57,'2024-03-14 23:04:47','2024-03-15 03:04:47','Botble\\ACL\\Models\\User'),(114,'create_from_order','Shipping was created from order %order_id%',0,46,59,'2024-03-14 13:04:47','2024-03-14 13:04:47','Botble\\ACL\\Models\\User'),(115,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,46,59,'2024-03-15 01:04:48','2024-03-15 03:04:48','Botble\\ACL\\Models\\User');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,1,NULL,1610.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:36','2024-03-15 03:04:36','JJD0041970099','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:04:36','2024-03-15 10:04:36',NULL,NULL),(2,2,NULL,793.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:36','2024-03-15 03:04:36','JJD0014601779','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:04:36','2024-03-15 10:04:36',NULL,NULL),(3,3,NULL,1304.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','JJD0084800094','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:04:37',NULL,NULL,NULL),(4,5,NULL,1452.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','JJD0035972331','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:04:37',NULL,NULL,NULL),(5,6,NULL,899.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','JJD0097049061','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:04:37',NULL,NULL,NULL),(6,7,NULL,1580.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:37','2024-03-15 03:04:37','JJD0062783710','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:04:37','2024-03-15 10:04:37',NULL,NULL),(7,8,NULL,1586.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','JJD0021725385','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:04:38','2024-03-15 10:04:38',NULL,NULL),(8,9,NULL,1907.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','JJD0051496054','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:04:38','2024-03-15 10:04:38',NULL,NULL),(9,10,NULL,2451.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','JJD0050778730','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:04:38',NULL,NULL,NULL),(10,11,NULL,674.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','JJD0050086433','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:04:38',NULL,NULL,NULL),(11,12,NULL,4275.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','JJD0068263593','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:04:38',NULL,NULL,NULL),(12,13,NULL,1400.00,NULL,NULL,'','approved',1550.00,'pending','pending',0.00,0,'2024-03-15 03:04:38','2024-03-15 03:04:38','JJD0063189001','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:04:38',NULL,NULL,NULL),(13,14,NULL,817.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','JJD0071463237','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-19 10:04:39',NULL,NULL,NULL),(14,15,NULL,2020.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','JJD0097239546','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:04:39',NULL,NULL,NULL),(15,16,NULL,546.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','JJD0019765325','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:04:39','2024-03-15 10:04:39',NULL,NULL),(16,18,NULL,1581.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:39','2024-03-15 03:04:39','JJD0033673167','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:04:39',NULL,NULL,NULL),(17,19,NULL,2112.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','JJD0063661273','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:04:40','2024-03-15 10:04:40',NULL,NULL),(18,20,NULL,2415.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','JJD0071547060','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:04:40','2024-03-15 10:04:40',NULL,NULL),(19,21,NULL,2451.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','JJD0010769054','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-21 10:04:40',NULL,NULL,NULL),(20,22,NULL,1756.00,NULL,NULL,'','approved',1522.00,'pending','pending',0.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','JJD0015236690','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:04:40',NULL,NULL,NULL),(21,23,NULL,2448.00,NULL,NULL,'','delivered',5118.00,'completed','pending',0.00,0,'2024-03-15 03:04:40','2024-03-15 03:04:40','JJD0017606931','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:04:40','2024-03-15 10:04:40',NULL,NULL),(22,24,NULL,1400.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','JJD008512579','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:04:41','2024-03-15 10:04:41',NULL,NULL),(23,25,NULL,546.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','JJD0012563072','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:04:41',NULL,NULL,NULL),(24,26,NULL,577.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','JJD0064581683','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:04:41',NULL,NULL,NULL),(25,28,NULL,2415.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','JJD0056808759','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:04:41',NULL,NULL,NULL),(26,29,NULL,1408.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:41','2024-03-15 03:04:41','JJD0098981891','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:04:41','2024-03-15 10:04:41',NULL,NULL),(27,32,NULL,1798.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:42','2024-03-15 03:04:42','JJD0081182129','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:04:42','2024-03-15 10:04:42',NULL,NULL),(28,33,NULL,577.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:42','2024-03-15 03:04:42','JJD0060378890','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:04:42',NULL,NULL,NULL),(29,36,NULL,583.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','JJD0017158367','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:04:43','2024-03-15 10:04:43',NULL,NULL),(30,37,NULL,704.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','JJD007312195','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:04:43',NULL,NULL,NULL),(31,38,NULL,1558.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:43','2024-03-15 03:04:43','JJD0069317159','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:04:43',NULL,NULL,NULL),(32,39,NULL,1749.00,NULL,NULL,'','delivered',1539.00,'completed','pending',0.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','JJD0093705459','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:04:44','2024-03-15 10:04:44',NULL,NULL),(33,40,NULL,1844.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','JJD0089491599','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:04:44','2024-03-15 10:04:44',NULL,NULL),(34,42,NULL,654.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','JJD0034721895','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:04:44','2024-03-15 10:04:44',NULL,NULL),(35,43,NULL,1580.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:44','2024-03-15 03:04:44','JJD0056698058','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-17 10:04:44','2024-03-15 10:04:44',NULL,NULL),(36,45,NULL,2451.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','JJD0096775077','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:04:45','2024-03-15 10:04:45',NULL,NULL),(37,47,NULL,2178.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','JJD0072776349','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-18 10:04:45',NULL,NULL,NULL),(38,48,NULL,1794.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:45','2024-03-15 03:04:45','JJD0058117684','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-23 10:04:45','2024-03-15 10:04:45',NULL,NULL),(39,49,NULL,1704.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','JJD0020975969','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:04:46',NULL,NULL,NULL),(40,50,NULL,1634.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','JJD0054349469','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:04:46','2024-03-15 10:04:46',NULL,NULL),(41,52,NULL,1956.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','JJD0088390659','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-24 10:04:46',NULL,NULL,NULL),(42,53,NULL,1054.00,NULL,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','JJD0021487262','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:04:46','2024-03-15 10:04:46',NULL,NULL),(43,54,NULL,4515.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:46','2024-03-15 03:04:46','JJD0050955923','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-22 10:04:46',NULL,NULL,NULL),(44,56,NULL,1581.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:47','2024-03-15 03:04:47','JJD0068583285','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-25 10:04:47',NULL,NULL,NULL),(45,57,NULL,840.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:47','2024-03-15 03:04:47','JJD0072315851','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-16 10:04:47',NULL,NULL,NULL),(46,59,NULL,1638.00,NULL,NULL,'','approved',0.00,'completed','pending',0.00,0,'2024-03-15 03:04:48','2024-03-15 03:04:48','JJD0094253258','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2024-03-20 10:04:48',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2024-03-15 03:04:23','2024-03-15 03:04:23');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',0.00,NULL,0.00,'2024-03-15 03:04:23','2024-03-15 03:04:23');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Shofy','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2024-03-15 03:04:25','2024-03-15 03:04:25');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,4),(1,7),(1,8),(1,14),(1,16),(1,18),(1,22),(1,23),(1,24),(1,28),(1,29),(1,33),(2,1),(2,11),(2,12),(2,20),(2,25),(2,26),(2,31),(2,32),(2,34),(2,37),(2,39),(2,40),(2,41),(2,42),(3,2),(3,3),(3,5),(3,6),(3,9),(3,10),(3,13),(3,15),(3,17),(3,19),(3,21),(3,27),(3,30),(3,35),(3,36),(3,38),(3,43);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2024-03-15 03:04:23','2024-03-15 03:04:23'),(2,'None',0.000000,2,'published','2024-03-15 03:04:23','2024-03-15 03:04:23'),(3,'Import Tax',15.000000,3,'published','2024-03-15 03:04:23','2024-03-15 03:04:23');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(2,'PAYMENT',1,'published','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(3,'ORDER &amp; RETURNS',2,'published','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2024-03-15 03:04:20','2024-03-15 03:04:20'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2024-03-15 03:04:20','2024-03-15 03:04:20');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Radiant Reflections','No, there were no arches left, and all that,\' said Alice. The King and the cool fountains. CHAPTER VIII. The Queen\'s argument was, that if you could manage it?) \'And what an ignorant little girl or.',1,0,'jewelry/galleries/1.jpg',1,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(2,'Glamour Grove','And the executioner ran wildly up and saying, \'Thank you, sir, for your walk!\" \"Coming in a minute, nurse! But I\'ve got to the fifth bend, I think?\' he said to the shore, and then raised himself.',1,0,'jewelry/galleries/2.jpg',1,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(3,'Serene Styles Showcase','Alice began to feel a little while, however, she waited for some way, and the turtles all advance! They are waiting on the floor, and a large fan in the same words as before, \'and things are \"much.',1,0,'jewelry/galleries/3.jpg',1,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(4,'Allure Alcove','How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure I\'m not used to say it over) \'--yes, that\'s about the reason of that?\' \'In my youth,\' said the Cat. \'I.',1,0,'jewelry/galleries/4.jpg',1,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(5,'Glamour Galleria','The Mouse only shook its head impatiently, and said, very gravely, \'I think, you ought to be executed for having cheated herself in a very difficult game indeed. The players all played at once took.',1,0,'jewelry/galleries/5.jpg',1,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(6,'Beauty Boulevard','I do hope it\'ll make me grow large again, for really I\'m quite tired of sitting by her sister kissed her, and the beak-- Pray how did you call him Tortoise, if he doesn\'t begin.\' But she did not.',1,0,'jewelry/galleries/6.jpg',1,'published','2024-03-15 03:04:35','2024-03-15 03:04:35');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"I think?\' \'I had NOT!\' cried the Mouse, who seemed too much frightened to say \'creatures,\' you see, Miss, we\'re doing our best, afore she comes, to--\' At this moment the King, rubbing his hands; \'so.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"She took down a very deep well. Either the well was very like a candle. I wonder who will put on his spectacles. \'Where shall I begin, please your Majesty,\' said the King: \'however, it may kiss my.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"There seemed to be no chance of getting her hands on her lap as if a dish or kettle had been to the jury. They were indeed a queer-looking party that assembled on the second thing is to do with this.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"King, the Queen, who was trembling down to nine inches high. CHAPTER VI. Pig and Pepper For a minute or two she walked up towards it rather timidly, saying to herself \'This is Bill,\' she gave her.\"},{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"Five. \'I heard the King exclaimed, turning to Alice. \'What sort of mixed flavour of cherry-tart, custard, pine-apple, roast turkey, toffee, and hot buttered toast,) she very seldom followed it), and.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:04:35','2024-03-15 03:04:35'),(2,'[{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"I think?\' \'I had NOT!\' cried the Mouse, who seemed too much frightened to say \'creatures,\' you see, Miss, we\'re doing our best, afore she comes, to--\' At this moment the King, rubbing his hands; \'so.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"She took down a very deep well. Either the well was very like a candle. I wonder who will put on his spectacles. \'Where shall I begin, please your Majesty,\' said the King: \'however, it may kiss my.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"There seemed to be no chance of getting her hands on her lap as if a dish or kettle had been to the jury. They were indeed a queer-looking party that assembled on the second thing is to do with this.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"King, the Queen, who was trembling down to nine inches high. CHAPTER VI. Pig and Pepper For a minute or two she walked up towards it rather timidly, saying to herself \'This is Bill,\' she gave her.\"},{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"Five. \'I heard the King exclaimed, turning to Alice. \'What sort of mixed flavour of cherry-tart, custard, pine-apple, roast turkey, toffee, and hot buttered toast,) she very seldom followed it), and.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:04:35','2024-03-15 03:04:35'),(3,'[{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"I think?\' \'I had NOT!\' cried the Mouse, who seemed too much frightened to say \'creatures,\' you see, Miss, we\'re doing our best, afore she comes, to--\' At this moment the King, rubbing his hands; \'so.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"She took down a very deep well. Either the well was very like a candle. I wonder who will put on his spectacles. \'Where shall I begin, please your Majesty,\' said the King: \'however, it may kiss my.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"There seemed to be no chance of getting her hands on her lap as if a dish or kettle had been to the jury. They were indeed a queer-looking party that assembled on the second thing is to do with this.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"King, the Queen, who was trembling down to nine inches high. CHAPTER VI. Pig and Pepper For a minute or two she walked up towards it rather timidly, saying to herself \'This is Bill,\' she gave her.\"},{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"Five. \'I heard the King exclaimed, turning to Alice. \'What sort of mixed flavour of cherry-tart, custard, pine-apple, roast turkey, toffee, and hot buttered toast,) she very seldom followed it), and.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:04:35','2024-03-15 03:04:35'),(4,'[{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"I think?\' \'I had NOT!\' cried the Mouse, who seemed too much frightened to say \'creatures,\' you see, Miss, we\'re doing our best, afore she comes, to--\' At this moment the King, rubbing his hands; \'so.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"She took down a very deep well. Either the well was very like a candle. I wonder who will put on his spectacles. \'Where shall I begin, please your Majesty,\' said the King: \'however, it may kiss my.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"There seemed to be no chance of getting her hands on her lap as if a dish or kettle had been to the jury. They were indeed a queer-looking party that assembled on the second thing is to do with this.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"King, the Queen, who was trembling down to nine inches high. CHAPTER VI. Pig and Pepper For a minute or two she walked up towards it rather timidly, saying to herself \'This is Bill,\' she gave her.\"},{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"Five. \'I heard the King exclaimed, turning to Alice. \'What sort of mixed flavour of cherry-tart, custard, pine-apple, roast turkey, toffee, and hot buttered toast,) she very seldom followed it), and.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:04:35','2024-03-15 03:04:35'),(5,'[{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"I think?\' \'I had NOT!\' cried the Mouse, who seemed too much frightened to say \'creatures,\' you see, Miss, we\'re doing our best, afore she comes, to--\' At this moment the King, rubbing his hands; \'so.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"She took down a very deep well. Either the well was very like a candle. I wonder who will put on his spectacles. \'Where shall I begin, please your Majesty,\' said the King: \'however, it may kiss my.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"There seemed to be no chance of getting her hands on her lap as if a dish or kettle had been to the jury. They were indeed a queer-looking party that assembled on the second thing is to do with this.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"King, the Queen, who was trembling down to nine inches high. CHAPTER VI. Pig and Pepper For a minute or two she walked up towards it rather timidly, saying to herself \'This is Bill,\' she gave her.\"},{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"Five. \'I heard the King exclaimed, turning to Alice. \'What sort of mixed flavour of cherry-tart, custard, pine-apple, roast turkey, toffee, and hot buttered toast,) she very seldom followed it), and.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:04:35','2024-03-15 03:04:35'),(6,'[{\"img\":\"jewelry\\/galleries\\/5.jpg\",\"description\":\"I think?\' \'I had NOT!\' cried the Mouse, who seemed too much frightened to say \'creatures,\' you see, Miss, we\'re doing our best, afore she comes, to--\' At this moment the King, rubbing his hands; \'so.\"},{\"img\":\"jewelry\\/galleries\\/2.jpg\",\"description\":\"She took down a very deep well. Either the well was very like a candle. I wonder who will put on his spectacles. \'Where shall I begin, please your Majesty,\' said the King: \'however, it may kiss my.\"},{\"img\":\"jewelry\\/galleries\\/4.jpg\",\"description\":\"There seemed to be no chance of getting her hands on her lap as if a dish or kettle had been to the jury. They were indeed a queer-looking party that assembled on the second thing is to do with this.\"},{\"img\":\"jewelry\\/galleries\\/1.jpg\",\"description\":\"King, the Queen, who was trembling down to nine inches high. CHAPTER VI. Pig and Pepper For a minute or two she walked up towards it rather timidly, saying to herself \'This is Bill,\' she gave her.\"},{\"img\":\"jewelry\\/galleries\\/3.jpg\",\"description\":\"Five. \'I heard the King exclaimed, turning to Alice. \'What sort of mixed flavour of cherry-tart, custard, pine-apple, roast turkey, toffee, and hot buttered toast,) she very seldom followed it), and.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2024-03-15 03:04:35','2024-03-15 03:04:35');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','3da51ebb6e31323278bbd841d397b5f9',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','c53603456d008436e9119f4fa5db3ad1',1,'Botble\\Menu\\Models\\MenuLocation'),(3,'en_US','4baca5702c45de7dc79fcbc460500ea1',1,'Botble\\Menu\\Models\\Menu'),(4,'en_US','8a69a0d5219457bf5c0ee4311bbf05b5',2,'Botble\\Menu\\Models\\Menu'),(5,'en_US','49bb89ea5d795ccfbf3c7ac9d788a52b',3,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'404','404',2,'image/png',15820,'main/general/404.png','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(2,0,'about-1','about-1',2,'image/jpeg',9222,'main/general/about-1.jpg','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(3,0,'about-2','about-2',2,'image/jpeg',5105,'main/general/about-2.jpg','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(4,0,'breadcrumb','breadcrumb',2,'image/jpeg',5276,'main/general/breadcrumb.jpg','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(5,0,'cta-shape-1','cta-shape-1',2,'image/png',22860,'main/general/cta-shape-1.png','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(6,0,'cta-shape-2','cta-shape-2',2,'image/png',16796,'main/general/cta-shape-2.png','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(7,0,'cta-thumb-1','cta-thumb-1',2,'image/jpeg',6053,'main/general/cta-thumb-1.jpg','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(8,0,'favicon','favicon',2,'image/png',1831,'main/general/favicon.png','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(9,0,'footer-pay','footer-pay',2,'image/png',490,'main/general/footer-pay.png','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(10,0,'logo-white','logo-white',2,'image/png',22020,'main/general/logo-white.png','[]','2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(11,0,'logo','logo',2,'image/png',22398,'main/general/logo.png','[]','2024-03-15 03:04:19','2024-03-15 03:04:19',NULL),(12,0,'newsletter-popup','newsletter-popup',2,'image/png',17253,'main/general/newsletter-popup.png','[]','2024-03-15 03:04:19','2024-03-15 03:04:19',NULL),(13,0,'placeholder','placeholder',2,'image/png',2100,'main/general/placeholder.png','[]','2024-03-15 03:04:19','2024-03-15 03:04:19',NULL),(14,0,'preloader-icon','preloader-icon',2,'image/png',4182,'main/general/preloader-icon.png','[]','2024-03-15 03:04:19','2024-03-15 03:04:19',NULL),(15,0,'signature','signature',2,'image/png',2117,'main/general/signature.png','[]','2024-03-15 03:04:19','2024-03-15 03:04:19',NULL),(16,0,'slider-offer','slider-offer',2,'image/png',970,'main/general/slider-offer.png','[]','2024-03-15 03:04:19','2024-03-15 03:04:19',NULL),(27,0,'1','1',4,'image/jpeg',4294,'main/customers/1.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(28,0,'10','10',4,'image/jpeg',4294,'main/customers/10.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(29,0,'2','2',4,'image/jpeg',4294,'main/customers/2.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(30,0,'3','3',4,'image/jpeg',4294,'main/customers/3.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(31,0,'4','4',4,'image/jpeg',4294,'main/customers/4.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(32,0,'5','5',4,'image/jpeg',4294,'main/customers/5.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(33,0,'6','6',4,'image/jpeg',4294,'main/customers/6.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(34,0,'7','7',4,'image/jpeg',4294,'main/customers/7.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(35,0,'8','8',4,'image/jpeg',4294,'main/customers/8.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(36,0,'9','9',4,'image/jpeg',4294,'main/customers/9.jpg','[]','2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(37,0,'blog-big-1','blog-big-1',5,'image/jpeg',13885,'main/blog/blog-big-1.jpg','[]','2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(38,0,'blog-details-sm-1','blog-details-sm-1',5,'image/jpeg',8166,'main/blog/blog-details-sm-1.jpg','[]','2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(39,0,'post-1','post-1',5,'image/jpeg',6189,'main/blog/post-1.jpg','[]','2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(40,0,'post-10','post-10',5,'image/jpeg',5907,'main/blog/post-10.jpg','[]','2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(41,0,'post-11','post-11',5,'image/jpeg',5907,'main/blog/post-11.jpg','[]','2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(42,0,'post-12','post-12',5,'image/jpeg',5907,'main/blog/post-12.jpg','[]','2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(43,0,'post-2','post-2',5,'image/jpeg',6189,'main/blog/post-2.jpg','[]','2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(44,0,'post-3','post-3',5,'image/jpeg',6189,'main/blog/post-3.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(45,0,'post-4','post-4',5,'image/jpeg',6045,'main/blog/post-4.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(46,0,'post-5','post-5',5,'image/jpeg',6045,'main/blog/post-5.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(47,0,'post-6','post-6',5,'image/jpeg',6045,'main/blog/post-6.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(48,0,'post-7','post-7',5,'image/jpeg',5907,'main/blog/post-7.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(49,0,'post-8','post-8',5,'image/jpeg',5907,'main/blog/post-8.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(50,0,'post-9','post-9',5,'image/jpeg',5907,'main/blog/post-9.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(51,0,'1','1',3,'image/jpeg',4068,'main/users/1.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(52,0,'10','10',3,'image/jpeg',7599,'main/users/10.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(53,0,'2','2',3,'image/jpeg',7599,'main/users/2.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(54,0,'3','3',3,'image/jpeg',6387,'main/users/3.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(55,0,'4','4',3,'image/jpeg',7599,'main/users/4.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(56,0,'5','5',3,'image/jpeg',6387,'main/users/5.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(57,0,'6','6',3,'image/jpeg',7599,'main/users/6.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(58,0,'7','7',3,'image/jpeg',6387,'main/users/7.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(59,0,'8','8',3,'image/jpeg',7599,'main/users/8.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(60,0,'9','9',3,'image/jpeg',6387,'main/users/9.jpg','[]','2024-03-15 03:04:24','2024-03-15 03:04:24',NULL),(61,0,'1','1',6,'image/png',9133,'main/stores/1.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(62,0,'10','10',6,'image/png',4263,'main/stores/10.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(63,0,'11','11',6,'image/png',4420,'main/stores/11.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(64,0,'12','12',6,'image/png',4908,'main/stores/12.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(65,0,'13','13',6,'image/png',3441,'main/stores/13.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(66,0,'14','14',6,'image/png',4209,'main/stores/14.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(67,0,'15','15',6,'image/png',5113,'main/stores/15.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(68,0,'16','16',6,'image/png',4563,'main/stores/16.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(69,0,'17','17',6,'image/png',4896,'main/stores/17.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(70,0,'2','2',6,'image/png',9008,'main/stores/2.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(71,0,'3','3',6,'image/png',8006,'main/stores/3.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(72,0,'4','4',6,'image/png',8728,'main/stores/4.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(73,0,'5','5',6,'image/png',10689,'main/stores/5.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(74,0,'6','6',6,'image/png',10989,'main/stores/6.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(75,0,'7','7',6,'image/png',3730,'main/stores/7.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(76,0,'8','8',6,'image/png',4030,'main/stores/8.png','[]','2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(77,0,'9','9',6,'image/png',3810,'main/stores/9.png','[]','2024-03-15 03:04:26','2024-03-15 03:04:26',NULL),(78,0,'cover-1','cover-1',6,'image/png',4208,'main/stores/cover-1.png','[]','2024-03-15 03:04:26','2024-03-15 03:04:26',NULL),(79,0,'cover-2','cover-2',6,'image/png',8798,'main/stores/cover-2.png','[]','2024-03-15 03:04:26','2024-03-15 03:04:26',NULL),(80,0,'cover-3','cover-3',6,'image/png',3888,'main/stores/cover-3.png','[]','2024-03-15 03:04:26','2024-03-15 03:04:26',NULL),(81,0,'cover-4','cover-4',6,'image/png',11893,'main/stores/cover-4.png','[]','2024-03-15 03:04:26','2024-03-15 03:04:26',NULL),(82,0,'cover-5','cover-5',6,'image/png',8798,'main/stores/cover-5.png','[]','2024-03-15 03:04:26','2024-03-15 03:04:26',NULL),(83,0,'slider-1','slider-1',8,'image/png',14471,'jewelry/sliders/slider-1.png','[]','2024-03-15 03:04:28','2024-03-15 03:04:28',NULL),(84,0,'slider-2','slider-2',8,'image/png',13483,'jewelry/sliders/slider-2.png','[]','2024-03-15 03:04:28','2024-03-15 03:04:28',NULL),(85,0,'slider-3','slider-3',8,'image/png',16822,'jewelry/sliders/slider-3.png','[]','2024-03-15 03:04:28','2024-03-15 03:04:28',NULL),(86,0,'slider-4','slider-4',8,'image/png',13919,'jewelry/sliders/slider-4.png','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(87,0,'1','1',9,'image/jpeg',4294,'jewelry/product-categories/1.jpg','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(88,0,'2','2',9,'image/jpeg',4294,'jewelry/product-categories/2.jpg','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(89,0,'3','3',9,'image/jpeg',4294,'jewelry/product-categories/3.jpg','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(90,0,'4','4',9,'image/jpeg',4294,'jewelry/product-categories/4.jpg','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(91,0,'5','5',9,'image/jpeg',4294,'jewelry/product-categories/5.jpg','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(92,0,'product-1','product-1',10,'image/png',9803,'jewelry/products/product-1.png','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(93,0,'product-2','product-2',10,'image/png',9803,'jewelry/products/product-2.png','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(94,0,'product-3','product-3',10,'image/png',9803,'jewelry/products/product-3.png','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(95,0,'product-4','product-4',10,'image/png',9803,'jewelry/products/product-4.png','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(96,0,'product-5','product-5',10,'image/png',9803,'jewelry/products/product-5.png','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(97,0,'product-6','product-6',10,'image/png',9803,'jewelry/products/product-6.png','[]','2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(98,0,'product-7','product-7',10,'image/png',9803,'jewelry/products/product-7.png','[]','2024-03-15 03:04:30','2024-03-15 03:04:30',NULL),(99,0,'product-8','product-8',10,'image/png',9803,'jewelry/products/product-8.png','[]','2024-03-15 03:04:30','2024-03-15 03:04:30',NULL),(100,0,'1','1',11,'image/jpeg',5406,'jewelry/banners/1.jpg','[]','2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(101,0,'2','2',11,'image/jpeg',4233,'jewelry/banners/2.jpg','[]','2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(102,0,'3','3',11,'image/jpeg',4233,'jewelry/banners/3.jpg','[]','2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(103,0,'4','4',11,'image/jpeg',12882,'jewelry/banners/4.jpg','[]','2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(104,0,'1','1',12,'image/jpeg',4294,'jewelry/galleries/1.jpg','[]','2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(105,0,'2','2',12,'image/jpeg',4294,'jewelry/galleries/2.jpg','[]','2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(106,0,'3','3',12,'image/jpeg',4294,'jewelry/galleries/3.jpg','[]','2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(107,0,'4','4',12,'image/jpeg',4294,'jewelry/galleries/4.jpg','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(108,0,'5','5',12,'image/jpeg',4294,'jewelry/galleries/5.jpg','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(109,0,'6','6',12,'image/jpeg',4294,'jewelry/galleries/6.jpg','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(110,0,'icon-1','icon-1',13,'image/png',4469,'main/contact/icon-1.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(111,0,'icon-2','icon-2',13,'image/png',5977,'main/contact/icon-2.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(112,0,'icon-3','icon-3',13,'image/png',6082,'main/contact/icon-3.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(113,0,'1','1',14,'image/png',948,'main/brands/1.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(114,0,'2','2',14,'image/png',948,'main/brands/2.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(115,0,'3','3',14,'image/png',948,'main/brands/3.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(116,0,'4','4',14,'image/png',948,'main/brands/4.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(117,0,'5','5',14,'image/png',948,'main/brands/5.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(118,0,'logo_01','logo_01',14,'image/png',948,'main/brands/logo-01.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(119,0,'logo_02','logo_02',14,'image/png',948,'main/brands/logo-02.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(120,0,'logo_03','logo_03',14,'image/png',948,'main/brands/logo-03.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(121,0,'logo_04','logo_04',14,'image/png',948,'main/brands/logo-04.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(122,0,'logo_05','logo_05',14,'image/png',948,'main/brands/logo-05.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(123,0,'line','line',15,'image/png',6152,'main/shapes/line.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(124,0,'quote','quote',15,'image/png',595,'main/shapes/quote.png','[]','2024-03-15 03:04:35','2024-03-15 03:04:35',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(2,0,'general',NULL,'general',1,'2024-03-15 03:04:18','2024-03-15 03:04:18',NULL),(3,0,'users',NULL,'users',1,'2024-03-15 03:04:19','2024-03-15 03:04:19',NULL),(4,0,'customers',NULL,'customers',1,'2024-03-15 03:04:20','2024-03-15 03:04:20',NULL),(5,0,'blog',NULL,'blog',1,'2024-03-15 03:04:23','2024-03-15 03:04:23',NULL),(6,0,'stores',NULL,'stores',1,'2024-03-15 03:04:25','2024-03-15 03:04:25',NULL),(7,0,'jewelry',NULL,'jewelry',0,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL),(8,0,'sliders',NULL,'sliders',7,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL),(9,0,'product-categories',NULL,'product-categories',7,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(10,0,'products',NULL,'products',7,'2024-03-15 03:04:29','2024-03-15 03:04:29',NULL),(11,0,'banners',NULL,'banners',7,'2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(12,0,'galleries',NULL,'galleries',7,'2024-03-15 03:04:34','2024-03-15 03:04:34',NULL),(13,0,'contact',NULL,'contact',1,'2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(14,0,'brands',NULL,'brands',1,'2024-03-15 03:04:35','2024-03-15 03:04:35',NULL),(15,0,'shapes',NULL,'shapes',1,'2024-03-15 03:04:35','2024-03-15 03:04:35',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2024-03-15 03:04:35','2024-03-15 03:04:35');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,1,'Botble\\Page\\Models\\Page','/home',NULL,0,'Home',NULL,'_self',1,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(2,1,1,NULL,NULL,'https://shofy.botble.com',NULL,0,'Electronics',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(3,1,1,NULL,NULL,'https://shofy-fashion.botble.com',NULL,0,'Fashion',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(4,1,1,NULL,NULL,'https://shofy-beauty.botble.com',NULL,0,'Beauty',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(5,1,1,NULL,NULL,'https://shofy-jewelry.botble.com',NULL,0,'Jewelry',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(6,1,1,NULL,NULL,'https://shofy-grocery.botble.com',NULL,0,'Grocery',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(7,1,0,NULL,NULL,NULL,NULL,0,'Shop',NULL,'_self',1,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(8,1,7,2,'Botble\\Page\\Models\\Page','/product-categories',NULL,0,'Shop Categories',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,0,'Shop List',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(10,1,7,NULL,NULL,'/products?layout=grid',NULL,0,'Shop Grid',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(11,1,7,NULL,NULL,'/products/quilted-crossbody-bag',NULL,0,'Product Detail',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(12,1,7,3,'Botble\\Page\\Models\\Page','/coupons',NULL,0,'Grab Coupons',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(13,1,7,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(14,1,7,NULL,NULL,'/compare',NULL,0,'Compare',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(15,1,7,NULL,NULL,'/wishlist',NULL,0,'Wishlist',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(16,1,7,NULL,NULL,'/orders/tracking',NULL,0,'Track Your Order',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(17,1,0,NULL,NULL,'/stores',NULL,0,'Vendors',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(18,1,0,NULL,NULL,NULL,NULL,0,'Pages',NULL,'_self',1,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(19,1,18,NULL,NULL,'/login',NULL,0,'Login',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(20,1,18,NULL,NULL,'/register',NULL,0,'Register',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(21,1,18,NULL,NULL,'/password/reset',NULL,0,'Forgot Password',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(22,1,18,NULL,NULL,'/404',NULL,0,'404 Error',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(23,1,0,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',1,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(24,1,23,NULL,NULL,'/blog?layout=grid',NULL,0,'Blog Grid',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(25,1,23,NULL,NULL,'/blog?layout=list',NULL,0,'Blog List',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(26,1,23,NULL,NULL,'/blog/heres-the-first-valentinos-new-makeup-collection',NULL,0,'Blog Detail',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(27,1,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(28,2,0,NULL,NULL,'/orders/tracking',NULL,1,'Track Orders',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(29,2,0,9,'Botble\\Page\\Models\\Page','/shipping',NULL,1,'Shipping',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(30,2,0,NULL,NULL,'/wishlist',NULL,1,'Wishlist',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(31,2,0,NULL,NULL,'/customer/overview',NULL,1,'My Account',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(32,2,0,NULL,NULL,'/customer/orders',NULL,1,'Order History',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(33,2,0,NULL,NULL,'/customer/order-returns',NULL,1,'Returns',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(34,3,0,7,'Botble\\Page\\Models\\Page','/our-story',NULL,2,'Our Story',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(35,3,0,8,'Botble\\Page\\Models\\Page','/careers',NULL,2,'Careers',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(36,3,0,6,'Botble\\Page\\Models\\Page','/cookie-policy',NULL,2,'Privacy Policy',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(37,3,0,NULL,NULL,'/blog',NULL,2,'Latest News',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35'),(38,3,0,5,'Botble\\Page\\Models\\Page','/contact',NULL,2,'Contact Us',NULL,'_self',0,'2024-03-15 03:04:35','2024-03-15 03:04:35');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(2,'My Account','my-account','published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(3,'Information','information','published','2024-03-15 03:04:35','2024-03-15 03:04:35');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'background','[\"main\\/stores\\/cover-2.png\"]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(2,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',1,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(3,'background','[\"main\\/stores\\/cover-3.png\"]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(4,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',2,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(5,'background','[\"main\\/stores\\/cover-4.png\"]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(6,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',3,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(7,'background','[\"main\\/stores\\/cover-5.png\"]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(8,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',4,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(9,'background','[\"main\\/stores\\/cover-1.png\"]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(10,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',5,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(11,'background','[\"main\\/stores\\/cover-2.png\"]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(12,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',6,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(13,'background','[\"main\\/stores\\/cover-4.png\"]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(14,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',7,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(15,'background','[\"main\\/stores\\/cover-3.png\"]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(16,'socials','[{\"facebook\":\"https:\\/\\/www.facebook.com\\/\",\"x\":\"https:\\/\\/x.com\\/\",\"youtube\":\"https:\\/\\/www.youtube.com\\/\",\"linkedin\":\"https:\\/\\/www.linkedin.com\\/\"}]',8,'Botble\\Marketplace\\Models\\Store','2024-03-15 03:04:28','2024-03-15 03:04:28'),(17,'button_label','[\"Discover Now\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:04:29','2024-03-15 03:04:29'),(18,'button_label','[\"Discover Now\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:04:29','2024-03-15 03:04:29'),(19,'button_label','[\"Discover Now\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:04:29','2024-03-15 03:04:29'),(20,'button_label','[\"Discover Now\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2024-03-15 03:04:29','2024-03-15 03:04:29'),(21,'faq_ids','[[2,3,6,7,8]]',1,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(22,'faq_ids','[[1,3,4,7,8]]',2,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(23,'faq_ids','[[1,5,8,9,10]]',3,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(24,'faq_ids','[[1,3,5,7,8]]',4,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(25,'faq_ids','[[2,4,6,9,10]]',5,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(26,'faq_ids','[[1,3,4,5,6]]',6,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(27,'faq_ids','[[3,4,6,9,10]]',7,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(28,'faq_ids','[[3,6,8,9,10]]',8,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(29,'faq_ids','[[1,4,5,7,8]]',9,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(30,'faq_ids','[[4,7,8,9,10]]',10,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(31,'faq_ids','[[3,4,5,9,10]]',11,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(32,'faq_ids','[[1,4,5,9,10]]',12,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(33,'faq_ids','[[3,4,5,6,7]]',13,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(34,'faq_ids','[[1,3,4,5,7]]',14,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(35,'faq_ids','[[4,6,7,8,9]]',15,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(36,'faq_ids','[[4,5,7,8,9]]',16,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(37,'faq_ids','[[2,5,6,8,9]]',17,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(38,'faq_ids','[[1,4,5,6,8]]',18,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(39,'faq_ids','[[2,3,7,8,9]]',19,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:30','2024-03-15 03:04:30'),(40,'faq_ids','[[4,5,7,8,9]]',20,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(41,'faq_ids','[[2,3,4,7,9]]',21,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(42,'faq_ids','[[4,6,7,8,10]]',22,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(43,'faq_ids','[[1,2,5,9,10]]',23,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(44,'faq_ids','[[1,4,5,8,10]]',24,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(45,'faq_ids','[[2,3,5,6,8]]',25,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(46,'faq_ids','[[1,3,6,8,9]]',26,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(47,'faq_ids','[[3,4,5,7,8]]',27,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(48,'faq_ids','[[1,3,4,8,9]]',28,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(49,'faq_ids','[[2,3,7,8,9]]',29,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(50,'faq_ids','[[1,3,6,7,9]]',30,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(51,'faq_ids','[[1,4,6,8,9]]',31,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(52,'faq_ids','[[3,6,7,8,9]]',32,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(53,'faq_ids','[[1,4,5,7,9]]',33,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(54,'faq_ids','[[1,2,3,7,8]]',34,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(55,'faq_ids','[[1,2,4,5,6]]',35,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(56,'faq_ids','[[1,2,7,9,10]]',36,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(57,'faq_ids','[[1,2,4,6,10]]',37,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(58,'faq_ids','[[2,3,5,7,9]]',38,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(59,'faq_ids','[[4,5,7,8,10]]',39,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(60,'faq_ids','[[4,5,6,8,10]]',40,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(61,'faq_ids','[[3,5,6,8,9]]',41,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(62,'faq_ids','[[2,3,5,7,9]]',42,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(63,'faq_ids','[[4,5,6,9,10]]',43,'Botble\\Ecommerce\\Models\\Product','2024-03-15 03:04:31','2024-03-15 03:04:31'),(64,'title','[\"Ardeco pearl \\n Rings style 2023\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(65,'subtitle','[\"Collection\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(66,'button_label','[\"Shop Now\"]',1,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(67,'title','[\"Tropical Set\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(68,'subtitle','[\"Trending\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(69,'button_label','[\"Shop Now\"]',2,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(70,'title','[\"Gold Jewelry\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(71,'subtitle','[\"New Arrival\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(72,'button_label','[\"Shop Now\"]',3,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(73,'title','[\"Ring gold with \\n diamonds\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(74,'subtitle','[\"Collection\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(75,'button_label','[\"Shop Now\"]',4,'Botble\\Ads\\Models\\Ads','2024-03-15 03:04:34','2024-03-15 03:04:34'),(76,'breadcrumb_style','[\"none\"]',1,'Botble\\Page\\Models\\Page','2024-03-15 03:04:35','2024-03-15 03:04:35'),(77,'breadcrumb_style','[\"align-start\"]',2,'Botble\\Page\\Models\\Page','2024-03-15 03:04:35','2024-03-15 03:04:35');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_reset_tokens_table',1),(5,'2015_06_18_033822_create_blog_table',1),(6,'2015_06_29_025744_create_audit_history',1),(7,'2016_05_28_112028_create_system_request_logs_table',1),(8,'2016_06_10_230148_create_acl_tables',1),(9,'2016_06_14_230857_create_menus_table',1),(10,'2016_06_17_091537_create_contacts_table',1),(11,'2016_06_28_221418_create_pages_table',1),(12,'2016_10_03_032336_create_languages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_10_07_193005_create_translations_table',1),(15,'2016_10_13_150201_create_galleries_table',1),(16,'2016_11_28_032840_create_dashboard_widget_tables',1),(17,'2016_12_16_084601_create_widgets_table',1),(18,'2017_05_09_070343_create_media_tables',1),(19,'2017_05_18_080441_create_payment_tables',1),(20,'2017_07_11_140018_create_simple_slider_table',1),(21,'2017_10_24_154832_create_newsletter_table',1),(22,'2017_11_03_070450_create_slug_table',1),(23,'2018_07_09_214610_create_testimonial_table',1),(24,'2018_07_09_221238_create_faq_table',1),(25,'2019_01_05_053554_create_jobs_table',1),(26,'2019_08_19_000000_create_failed_jobs_table',1),(27,'2019_11_18_061011_create_country_table',1),(28,'2019_12_14_000001_create_personal_access_tokens_table',1),(29,'2020_03_05_041139_create_ecommerce_tables',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',1),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',1),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',1),(34,'2021_02_16_092633_remove_default_value_for_author_type',1),(35,'2021_02_18_073505_update_table_ec_reviews',1),(36,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',1),(37,'2021_03_10_025153_change_column_tax_amount',1),(38,'2021_03_20_033103_add_column_availability_to_table_ec_products',1),(39,'2021_03_27_144913_add_customer_type_into_table_payments',1),(40,'2021_04_28_074008_ecommerce_create_product_label_table',1),(41,'2021_05_24_034720_make_column_currency_nullable',1),(42,'2021_05_31_173037_ecommerce_create_ec_products_translations',1),(43,'2021_07_06_030002_create_marketplace_table',1),(44,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(45,'2021_08_17_105016_remove_column_currency_id_in_some_tables',1),(46,'2021_08_30_142128_add_images_column_to_ec_reviews_table',1),(47,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',1),(48,'2021_10_04_030050_add_column_created_by_to_table_ec_products',1),(49,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',1),(50,'2021_10_05_122616_add_status_column_to_ec_customers_table',1),(51,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',1),(52,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',1),(53,'2021_10_19_020859_update_metadata_field',1),(54,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(55,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',1),(56,'2021_11_23_071403_correct_languages_for_product_variations',1),(57,'2021_11_28_031808_add_product_tags_translations',1),(58,'2021_12_01_031123_add_featured_image_to_ec_products',1),(59,'2021_12_02_035301_add_ads_translations_table',1),(60,'2021_12_03_030600_create_blog_translations',1),(61,'2021_12_03_075608_create_page_translations',1),(62,'2021_12_03_082134_create_faq_translations',1),(63,'2021_12_03_082953_create_gallery_translations',1),(64,'2021_12_03_083642_create_testimonials_translations',1),(65,'2021_12_03_084118_create_location_translations',1),(66,'2021_12_03_094518_migrate_old_location_data',1),(67,'2021_12_06_031304_update_table_mp_customer_revenues',1),(68,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(69,'2022_01_01_033107_update_table_ec_shipments',1),(70,'2022_01_16_085908_improve_plugin_location',1),(71,'2022_02_16_042457_improve_product_attribute_sets',1),(72,'2022_03_22_075758_correct_product_name',1),(73,'2022_04_19_113334_add_index_to_ec_products',1),(74,'2022_04_19_113923_add_index_to_table_posts',1),(75,'2022_04_20_100851_add_index_to_media_table',1),(76,'2022_04_20_101046_add_index_to_menu_table',1),(77,'2022_04_28_144405_remove_unused_table',1),(78,'2022_04_30_034048_create_gallery_meta_translations_table',1),(79,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',1),(80,'2022_05_18_143720_add_index_to_table_ec_product_categories',1),(81,'2022_06_16_095633_add_index_to_some_tables',1),(82,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(83,'2022_06_30_035148_create_order_referrals_table',1),(84,'2022_07_07_153354_update_charge_id_in_table_payments',1),(85,'2022_07_10_034813_move_lang_folder_to_root',1),(86,'2022_07_24_153815_add_completed_at_to_ec_orders_table',1),(87,'2022_08_04_051940_add_missing_column_expires_at',1),(88,'2022_08_04_052122_delete_location_backup_tables',1),(89,'2022_08_14_032836_create_ec_order_returns_table',1),(90,'2022_08_14_033554_create_ec_order_return_items_table',1),(91,'2022_08_15_040324_add_billing_address',1),(92,'2022_08_30_091114_support_digital_products_table',1),(93,'2022_09_01_000001_create_admin_notifications_tables',1),(94,'2022_09_13_095744_create_options_table',1),(95,'2022_09_13_104347_create_option_value_table',1),(96,'2022_10_05_163518_alter_table_ec_order_product',1),(97,'2022_10_12_041517_create_invoices_table',1),(98,'2022_10_12_142226_update_orders_table',1),(99,'2022_10_13_024916_update_table_order_returns',1),(100,'2022_10_14_024629_drop_column_is_featured',1),(101,'2022_10_19_152916_add_columns_to_mp_stores_table',1),(102,'2022_10_20_062849_create_mp_category_sale_commissions_table',1),(103,'2022_10_21_030830_update_columns_in_ec_shipments_table',1),(104,'2022_10_28_021046_update_columns_in_ec_shipments_table',1),(105,'2022_11_02_071413_add_more_info_for_store',1),(106,'2022_11_02_080444_add_tax_info',1),(107,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',1),(108,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(109,'2022_11_19_041643_add_ec_tax_product_table',1),(110,'2022_12_02_093615_update_slug_index_columns',1),(111,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',1),(112,'2022_12_17_041532_fix_address_in_order_invoice',1),(113,'2022_12_26_070329_create_ec_product_views_table',1),(114,'2023_01_04_033051_fix_product_categories',1),(115,'2023_01_09_050400_add_ec_global_options_translations_table',1),(116,'2023_01_10_093754_add_missing_option_value_id',1),(117,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',1),(118,'2023_01_26_021854_add_ec_customer_used_coupons_table',1),(119,'2023_01_30_024431_add_alt_to_media_table',1),(120,'2023_02_01_062030_add_store_translations',1),(121,'2023_02_08_015900_update_options_column_in_ec_order_product_table',1),(122,'2023_02_13_032133_update_fee_column_mp_customer_revenues_table',1),(123,'2023_02_16_042611_drop_table_password_resets',1),(124,'2023_02_17_023648_fix_store_prefix',1),(125,'2023_02_27_095752_remove_duplicate_reviews',1),(126,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',1),(127,'2023_04_17_062645_add_open_in_new_tab',1),(128,'2023_04_21_082427_create_ec_product_categorizables_table',1),(129,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(130,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(131,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',1),(132,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(133,'2023_05_17_025812_fix_invoice_issue',1),(134,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',1),(135,'2023_05_27_144611_fix_exchange_rate_setting',1),(136,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',1),(137,'2023_06_30_042512_create_ec_order_tax_information_table',1),(138,'2023_07_06_011444_create_slug_translations_table',1),(139,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',1),(140,'2023_07_26_041451_add_more_columns_to_location_table',1),(141,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(142,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',1),(143,'2023_08_11_060908_create_announcements_table',1),(144,'2023_08_15_064505_create_ec_tax_rules_table',1),(145,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(146,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',1),(147,'2023_08_21_090810_make_page_content_nullable',1),(148,'2023_08_22_094114_drop_unique_for_barcode',1),(149,'2023_08_29_074620_make_column_author_id_nullable',1),(150,'2023_08_29_075308_make_column_user_id_nullable',1),(151,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',1),(152,'2023_09_07_094312_add_index_to_product_sku_and_translations',1),(153,'2023_09_14_021936_update_index_for_slugs_table',1),(154,'2023_09_14_022423_add_index_for_language_table',1),(155,'2023_09_19_024955_create_discount_product_categories_table',1),(156,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',1),(157,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(158,'2023_11_07_023805_add_tablet_mobile_image',1),(159,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(160,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(161,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(162,'2023_11_22_154643_add_unique_in_table_ec_products_variations',1),(163,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',1),(164,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',1),(165,'2023_12_06_100448_change_random_hash_for_media',1),(166,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(167,'2023_12_12_105220_drop_translations_table',1),(168,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(169,'2023_12_25_040604_ec_create_review_replies_table',1),(170,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',1),(171,'2024_01_16_070706_fix_translation_tables',1),(172,'2024_01_23_075227_add_proof_file_to_ec_orders_table',1),(173,'2024_03_14_041050_migrate_lazy_load_theme_options',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` bigint unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,4,1,1748.00,0.00,1748.00,0.00,'USD',NULL,'2024-03-14 03:04:48','2024-03-14 03:04:48',0,'add-amount'),(2,3,2,318.00,0.00,318.00,0.00,'USD',NULL,'2024-03-12 21:04:48','2024-03-12 21:04:48',0,'add-amount'),(3,6,7,2756.00,0.00,2756.00,0.00,'USD',NULL,'2024-03-08 11:04:49','2024-03-08 11:04:49',0,'add-amount'),(4,3,8,636.00,0.00,636.00,318.00,'USD',NULL,'2024-03-09 21:04:49','2024-03-09 21:04:49',0,'add-amount'),(5,2,16,1644.00,0.00,1644.00,0.00,'USD',NULL,'2024-03-02 09:04:50','2024-03-02 09:04:50',0,'add-amount'),(6,1,19,7320.00,0.00,7320.00,0.00,'USD',NULL,'2024-02-29 03:04:50','2024-02-29 03:04:50',0,'add-amount'),(7,4,20,2622.00,0.00,2622.00,1748.00,'USD',NULL,'2024-03-06 09:04:51','2024-03-06 09:04:51',0,'add-amount'),(8,4,24,1550.00,0.00,1550.00,4370.00,'USD',NULL,'2024-02-27 11:04:51','2024-02-27 11:04:51',0,'add-amount'),(9,1,29,4880.00,0.00,4880.00,7320.00,'USD',NULL,'2024-02-26 15:04:52','2024-02-26 15:04:52',0,'add-amount'),(10,3,36,513.00,0.00,513.00,954.00,'USD',NULL,'2024-03-05 21:04:52','2024-03-05 21:04:52',0,'add-amount'),(11,6,40,2526.00,0.00,2526.00,2756.00,'USD',NULL,'2024-03-04 21:04:53','2024-03-04 21:04:53',0,'add-amount'),(12,3,42,302.00,0.00,302.00,1467.00,'USD',NULL,'2024-02-15 11:04:53','2024-02-15 11:04:53',0,'add-amount'),(13,5,45,5211.00,0.00,5211.00,0.00,'USD',NULL,'2024-02-09 15:04:54','2024-02-09 15:04:54',0,'add-amount'),(14,1,48,3488.00,0.00,3488.00,12200.00,'USD',NULL,'2024-02-23 17:04:55','2024-02-23 17:04:55',0,'add-amount'),(15,5,50,3474.00,0.00,3474.00,5211.00,'USD',NULL,'2024-02-22 21:04:55','2024-02-22 21:04:55',0,'add-amount'),(16,8,53,3642.00,0.00,3642.00,0.00,'USD',NULL,'2024-02-03 15:04:56','2024-02-03 15:04:56',0,'add-amount');
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,1,0.00,3152.00,15688.00,'USD','','{\"name\":\"Joy Becker\",\"number\":\"+13164822729\",\"full_name\":\"Freda Schmeler\",\"description\":\"Liana Muller\"}',NULL,0,'pending',NULL,'2024-03-15 03:04:56','2024-03-15 03:04:56',NULL),(2,1,0.00,3754.00,12536.00,'USD','','{\"name\":\"Joy Becker\",\"number\":\"+13164822729\",\"full_name\":\"Freda Schmeler\",\"description\":\"Liana Muller\"}',NULL,0,'completed',NULL,'2024-03-15 03:04:57','2024-03-15 03:04:57',NULL),(3,1,0.00,1837.00,8782.00,'USD','','{\"name\":\"Joy Becker\",\"number\":\"+13164822729\",\"full_name\":\"Freda Schmeler\",\"description\":\"Liana Muller\"}',NULL,0,'processing',NULL,'2024-03-15 03:04:57','2024-03-15 03:04:57',NULL),(4,2,0.00,102.00,1644.00,'USD','','{\"name\":\"Jovan Koss\",\"number\":\"+15203223873\",\"full_name\":\"Maeve Kuhic\",\"description\":\"Shane Daugherty\"}',NULL,0,'processing',NULL,'2024-03-15 03:04:58','2024-03-15 03:04:58',NULL),(5,2,0.00,48.00,1542.00,'USD','','{\"name\":\"Jovan Koss\",\"number\":\"+15203223873\",\"full_name\":\"Maeve Kuhic\",\"description\":\"Shane Daugherty\"}',NULL,0,'completed',NULL,'2024-03-15 03:04:59','2024-03-15 03:04:59',NULL),(6,3,0.00,507.00,1769.00,'USD','','{\"name\":\"Enrico Feest\",\"number\":\"+16616164700\",\"full_name\":\"Claudia Schneider\",\"description\":\"Tanya Hauck\"}',NULL,0,'completed',NULL,'2024-03-15 03:04:59','2024-03-15 03:04:59',NULL),(7,3,0.00,329.00,1262.00,'USD','','{\"name\":\"Enrico Feest\",\"number\":\"+16616164700\",\"full_name\":\"Claudia Schneider\",\"description\":\"Tanya Hauck\"}',NULL,0,'processing',NULL,'2024-03-15 03:05:00','2024-03-15 03:05:00',NULL),(8,3,0.00,293.00,933.00,'USD','','{\"name\":\"Enrico Feest\",\"number\":\"+16616164700\",\"full_name\":\"Claudia Schneider\",\"description\":\"Tanya Hauck\"}',NULL,0,'pending',NULL,'2024-03-15 03:05:00','2024-03-15 03:05:00',NULL),(9,3,0.00,52.00,640.00,'USD','','{\"name\":\"Enrico Feest\",\"number\":\"+16616164700\",\"full_name\":\"Claudia Schneider\",\"description\":\"Tanya Hauck\"}',NULL,0,'pending',NULL,'2024-03-15 03:05:01','2024-03-15 03:05:01',NULL),(10,4,0.00,1797.00,5920.00,'USD','','{\"name\":\"Golden Fay IV\",\"number\":\"+19517571578\",\"full_name\":\"Jamel Farrell\",\"description\":\"Elmira Heaney\"}',NULL,0,'processing',NULL,'2024-03-15 03:05:01','2024-03-15 03:05:01',NULL),(11,4,0.00,100.00,4123.00,'USD','','{\"name\":\"Golden Fay IV\",\"number\":\"+19517571578\",\"full_name\":\"Jamel Farrell\",\"description\":\"Elmira Heaney\"}',NULL,0,'processing',NULL,'2024-03-15 03:05:02','2024-03-15 03:05:02',NULL),(12,5,0.00,675.00,8685.00,'USD','','{\"name\":\"Tom Collier\",\"number\":\"+14153400725\",\"full_name\":\"Prof. Wilhelmine D\'Amore IV\",\"description\":\"Henri Johnson\"}',NULL,0,'completed',NULL,'2024-03-15 03:05:02','2024-03-15 03:05:02',NULL),(13,5,0.00,487.00,8010.00,'USD','','{\"name\":\"Tom Collier\",\"number\":\"+14153400725\",\"full_name\":\"Prof. Wilhelmine D\'Amore IV\",\"description\":\"Henri Johnson\"}',NULL,0,'completed',NULL,'2024-03-15 03:05:03','2024-03-15 03:05:03',NULL),(14,6,0.00,172.00,5282.00,'USD','','{\"name\":\"Prof. Wendy Bayer IV\",\"number\":\"+13806190550\",\"full_name\":\"Valentin Simonis\",\"description\":\"Tom Wisozk\"}',NULL,0,'processing',NULL,'2024-03-15 03:05:04','2024-03-15 03:05:04',NULL),(15,6,0.00,714.00,5110.00,'USD','','{\"name\":\"Prof. Wendy Bayer IV\",\"number\":\"+13806190550\",\"full_name\":\"Valentin Simonis\",\"description\":\"Tom Wisozk\"}',NULL,0,'pending',NULL,'2024-03-15 03:05:04','2024-03-15 03:05:04',NULL),(16,6,0.00,1409.00,4396.00,'USD','','{\"name\":\"Prof. Wendy Bayer IV\",\"number\":\"+13806190550\",\"full_name\":\"Valentin Simonis\",\"description\":\"Tom Wisozk\"}',NULL,0,'completed',NULL,'2024-03-15 03:05:05','2024-03-15 03:05:05',NULL),(17,6,0.00,463.00,2987.00,'USD','','{\"name\":\"Prof. Wendy Bayer IV\",\"number\":\"+13806190550\",\"full_name\":\"Valentin Simonis\",\"description\":\"Tom Wisozk\"}',NULL,0,'pending',NULL,'2024-03-15 03:05:05','2024-03-15 03:05:05',NULL),(18,8,0.00,190.00,3642.00,'USD','','{\"name\":\"Hershel Marvin\",\"number\":\"+19293319913\",\"full_name\":\"Yoshiko Gutmann\",\"description\":\"Miss Dina Champlin\"}',NULL,0,'pending',NULL,'2024-03-15 03:05:06','2024-03-15 03:05:06',NULL),(19,8,0.00,913.00,3452.00,'USD','','{\"name\":\"Hershel Marvin\",\"number\":\"+19293319913\",\"full_name\":\"Yoshiko Gutmann\",\"description\":\"Miss Dina Champlin\"}',NULL,0,'processing',NULL,'2024-03-15 03:05:06','2024-03-15 03:05:06',NULL),(20,8,0.00,522.00,2539.00,'USD','','{\"name\":\"Hershel Marvin\",\"number\":\"+19293319913\",\"full_name\":\"Yoshiko Gutmann\",\"description\":\"Miss Dina Champlin\"}',NULL,0,'completed',NULL,'2024-03-15 03:05:07','2024-03-15 03:05:07',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','cristopher96@example.net','+19316336430','23927 Gerhold Unions Apt. 768','BH','Georgia','Cummerataburgh',1,'main/stores/1.png','Ut eos fugit praesentium et et. Omnis in alias dolorem dolorem. Praesentium ipsa laudantium est incidunt sunt velit culpa. Id facere consequuntur omnis sit sed. Minus dignissimos voluptas sint. Consequatur nulla rerum fuga. Sequi sint corrupti qui dignissimos qui rerum. Ut ut in et dolorem ut. Velit sed maiores quia asperiores unde fugiat aut.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL),(2,'Global Office','wgrant@example.net','+19849865638','120 Kertzmann Cliff Suite 666','PF','Ohio','North Ardella',2,'main/stores/2.png','Ut et quibusdam sed voluptas laborum nam. Error fuga deleniti maiores quidem fuga magni. Enim voluptatum voluptatem quae sunt numquam. Odio in laborum in. Inventore debitis accusamus accusamus temporibus doloribus magni error. Qui inventore libero est. Qui fugit debitis impedit neque dolore accusamus.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL),(3,'Young Shop','predovic.minerva@example.com','+16898108077','25455 Jordon Groves','PG','Oklahoma','New Jaydenfort',3,'main/stores/3.png','Blanditiis doloribus sint tempore quisquam esse sit rerum quis. Quibusdam ad esse odit nihil. Et nulla sunt qui id delectus est deserunt delectus. Placeat sed omnis omnis doloremque nihil magni. Nostrum ut libero et sapiente dolorem deleniti. Pariatur quia commodi voluptatem quod voluptates. Consequuntur quasi eos quo qui. Perferendis iusto eveniet est earum quas vel dolorem.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL),(4,'Global Store','dietrich.jaylin@example.net','+12403882415','18433 Nona Centers','TL','Ohio','West Katlynbury',4,'main/stores/4.png','Qui odio ut autem aut. Rerum et et repellendus impedit delectus molestiae fugiat quisquam. Molestiae et qui quasi consequatur similique. Officia quaerat eligendi blanditiis aut quidem saepe. Sed quia harum quas sit tempore eius. Consequatur iusto enim provident voluptas. Sit dicta et cum rem vel blanditiis quos. Qui voluptas suscipit accusamus vel et.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL),(5,'Robert’s Store','rosenbaum.salvador@example.net','+15596720942','97459 Jazmyne Mall Suite 956','GQ','Colorado','East Blaze',5,'main/stores/5.png','Inventore et illo illum sit. Dolores ea quam officia occaecati veritatis ut id esse. Libero dolorem incidunt occaecati. Fugiat accusamus molestiae laborum consectetur provident dolor. Deserunt harum harum minima. Nobis nemo molestiae esse beatae. Molestias perferendis enim ad beatae est mollitia atque. Inventore ut reiciendis velit architecto itaque cupiditate ex.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL),(6,'Stouffer','king.rosendo@example.com','+18705379349','650 Koelpin Green','UM','Colorado','South Eriberto',6,'main/stores/6.png','Id optio facilis beatae laborum. Enim officiis maiores voluptatum nesciunt numquam voluptas. Quia adipisci necessitatibus rerum ratione. Maiores nisi est sapiente et sint. Voluptatem minima doloribus dolorum esse tempora aut. Fugit cum praesentium eos sed iure tenetur officiis. Blanditiis odio dolor dolorem magni provident doloribus et harum. Voluptatem dolorem veritatis ea minima cumque.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL),(7,'StarKist','hfadel@example.com','+14246661146','476 Jenkins Falls Suite 903','ET','Massachusetts','Muellerstad',7,'main/stores/7.png','Id harum sit tenetur quia labore saepe. Nam dolores explicabo qui asperiores. Est nobis optio suscipit autem reprehenderit odio dignissimos. Voluptas explicabo sint accusantium occaecati. Pariatur maiores hic sit nisi soluta sint perferendis. Alias harum voluptatem esse ab minima ipsum id sequi. Voluptatem quis repellendus aperiam dignissimos cum.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL),(8,'Old El Paso','kayley.schinner@example.com','+18127727000','510 Bednar Key Suite 421','SA','Nevada','Lake Amya',8,'main/stores/8.png','Recusandae omnis nobis nemo fuga sit. Dolorem tempore dicta eum optio ratione maiores. Ut aut qui tempora. Non quia nulla doloribus. Et dolorum consequatur sed a minus ea. Mollitia exercitationem provident nihil sunt accusantium dolorum a. Odit quibusdam maxime fugiat est numquam et rerum. Ratione qui vero vel earum.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n                <p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f4\" src=\"/storage/news/1.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men’s wallet for you:</em></strong></p>\n\n                <h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n                <p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even <strong>minimalist style</strong> is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n                <p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don’t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f5\" src=\"/storage/news/2.jpg\"></p>\n\n                <p><br>\n                 </p>\n                <hr>\n                <h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n                <p>You should avoid having an over-sized wallet. Don’t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers’ pocket. In addition, it will create a bulge and ruin your look.</p>\n\n                <p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don’t need anymore.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f1\" src=\"/storage/news/3.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 3: Don’t Limit Your Options Of Materials</strong></h4>\n\n                <p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n                <p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f6\" src=\"/storage/news/4.jpg\"></p>\n\n                <p><br>\n                 </p>\n\n                <hr>\n                <h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n                <p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n                <p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n                <p style=\"text-align:center;\"><img alt=\"f2\" src=\"/storage/news/5.jpg\"></p>\n\n                <p> </p>\n                ','published',NULL,'2024-03-15 03:04:28','2024-03-15 03:04:28',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores_translations`
--

DROP TABLE IF EXISTS `mp_stores_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mp_stores_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`mp_stores_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores_translations`
--

LOCK TABLES `mp_stores_translations` WRITE;
/*!40000 ALTER TABLE `mp_stores_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_stores_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,1,6945.00,0.00,15688.00,'$2y$12$9Zn.oY1hQy5mAE5JVAzpuukjkLC2MbcjAJ1sS.mCVdPURmA1R2Gp2','{\"name\":\"Joy Becker\",\"number\":\"+13164822729\",\"full_name\":\"Freda Schmeler\",\"description\":\"Liana Muller\"}','2024-03-15 03:04:26','2024-03-15 03:04:58','bank_transfer',NULL),(2,2,1494.00,0.00,1644.00,'$2y$12$bOkoZQ1S3uf9.Fhg45IDsOzfYAKINA2wJr/z4vPB/Ne5yPt6o.cjC','{\"name\":\"Jovan Koss\",\"number\":\"+15203223873\",\"full_name\":\"Maeve Kuhic\",\"description\":\"Shane Daugherty\"}','2024-03-15 03:04:26','2024-03-15 03:04:59','bank_transfer',NULL),(3,3,588.00,0.00,1769.00,'$2y$12$wIadCklZ0WCxOIDGJPTosOGHTiALKpUNjgxhRT2yKhYlxidlj1Nxa','{\"name\":\"Enrico Feest\",\"number\":\"+16616164700\",\"full_name\":\"Claudia Schneider\",\"description\":\"Tanya Hauck\"}','2024-03-15 03:04:27','2024-03-15 03:05:01','bank_transfer',NULL),(4,4,4023.00,0.00,5920.00,'$2y$12$r4ibXVPp8fCeU0KRB.5tEOzRS7Tt5z7jToz88wzCJV8T0qbPS.wYi','{\"name\":\"Golden Fay IV\",\"number\":\"+19517571578\",\"full_name\":\"Jamel Farrell\",\"description\":\"Elmira Heaney\"}','2024-03-15 03:04:27','2024-03-15 03:05:02','bank_transfer',NULL),(5,5,7523.00,0.00,8685.00,'$2y$12$09JY1zSflAJpb2NtH2yvsOtKnSpprNPN7eczgNHgbmJA3CLGHUqcG','{\"name\":\"Tom Collier\",\"number\":\"+14153400725\",\"full_name\":\"Prof. Wilhelmine D\'Amore IV\",\"description\":\"Henri Johnson\"}','2024-03-15 03:04:27','2024-03-15 03:05:04','bank_transfer',NULL),(6,6,2524.00,0.00,5282.00,'$2y$12$knHoJcqKoTfZR6A98ayZ/eXWogOy6jOIaVz5jQd8I6jUiIStLjYJ.','{\"name\":\"Prof. Wendy Bayer IV\",\"number\":\"+13806190550\",\"full_name\":\"Valentin Simonis\",\"description\":\"Tom Wisozk\"}','2024-03-15 03:04:27','2024-03-15 03:05:06','bank_transfer',NULL),(7,7,0.00,0.00,0.00,'$2y$12$Gp3piaCOkNMGxEx50IDdTOFCk3qnPL1P9VjcBavsTBIEVhgH8ZPMe','{\"name\":\"Dr. Destiny Conroy Jr.\",\"number\":\"+17167817508\",\"full_name\":\"Pascale Klein\",\"description\":\"Cassidy Schiller\"}','2024-03-15 03:04:28','2024-03-15 03:04:28','bank_transfer',NULL),(8,8,2017.00,0.00,3642.00,'$2y$12$L6hzG4jTwWNX1wgV10Ixg.HZpfXymlm5TfscWxqOp05CUzlUPEpEy','{\"name\":\"Hershel Marvin\",\"number\":\"+19293319913\",\"full_name\":\"Yoshiko Gutmann\",\"description\":\"Miss Dina Champlin\"}','2024-03-15 03:04:28','2024-03-15 03:05:07','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','[simple-slider style=\"4\" key=\"home-slider\" shape_1=\"fashion/sliders/shape-1.png\" shape_2=\"fashion/sliders/shape-2.png\" shape_3=\"fashion/sliders/shape-3.png\"][/simple-slider][site-features style=\"3\" quantity=\"4\" title_1=\"Free Delivery\" description_1=\"Orders from all item\" icon_1=\"ti ti-truck-delivery\" title_2=\"Return & Refund\" description_2=\"Money back guarantee\" icon_2=\"ti ti-currency-dollar\" title_3=\"Member Discount\" description_3=\"Every order over $140.00\" icon_3=\"ti ti-discount-2\" title_4=\"Support 24/7\" description_4=\"Contact us 24 hours a day\" icon_4=\"ti ti-headset\"][/site-features][ads style=\"3\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\" key_3=\"BN3ZCHLIE95I\" key_4=\"QGPRRJ2MPZYA\"][/ads][about image_1=\"main/general/about-1.jpg\" image_2=\"main/general/about-2.jpg\" subtitle=\"Unity Collection\" title=\"Shop our limited Edition Collaborations\" description=\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vel mi quam. Fusce vehicula vitae mauris sit amet tempor. Donec consectetur lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.\" action_label=\"Contact Us\" action_url=\"/contact\"][/about][ecommerce-products style=\"slider-full-width\" title=\"This Week\'s Featured\" subtitle=\"Shop by Category\" by=\"collection\" collection_ids=\"1\" limit=\"5\"][/ecommerce-products][ecommerce-product-groups title=\"Discover our Products\" subtitle=\"Product Collection\" limit=\"8\" tabs=\"all,featured,on-sale,trending,top-rated\"][/ecommerce-product-groups][ecommerce-products style=\"slider\" title=\"Top Sellers In Dress for You\" subtitle=\"Best Seller This Week’s\" by=\"collection\" collection_ids=\"2\" limit=\"5\"][/ecommerce-products][image-slider type=\"custom\" quantity=\"4\" name_1=\"Brandit\" image_1=\"main/brands/1.png\" url_1=\"https://brandit-wear.com\" name_2=\"Vintage\" image_2=\"main/brands/2.png\" url_2=\"https://vintagebrand.com/\" name_3=\"Showtime\" image_3=\"main/brands/3.png\" url_3=\"https://www.showtime.com/\" name_4=\"Classic Design Studio\" image_4=\"main/brands/5.png\" url_4=\"http://www.classicdesignstudios.com/\"][/image-slider][gallery style=\"2\" title=\"Trends on image feed\" subtitle=\"After many months design and development of a modern online retailer\" limit=\"6\"][/gallery]',1,NULL,'full-width',NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(2,'Product Categories','[ads style=\"3\" key_1=\"UROL9F9ZZVAA\" key_2=\"B30VDBKO7SBF\"][/ads]<p>&nbsp;</p>[ecommerce-categories category_ids=\"11,14,17,18,21,22,23,25,38\" style=\"grid\"][/ecommerce-categories]<p>&nbsp;</p><p>&nbsp;</p>',1,NULL,'full-width',NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(3,'Coupons','[ecommerce-coupons coupon_ids=\"1,2,3,4,5,6\"][/ecommerce-coupons]',1,NULL,'full-width',NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(4,'Blog',NULL,1,NULL,'full-width',NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(5,'Contact','[contact-form show_contact_form=&quot;1&quot; title=&quot;Sent A Message&quot; quantity=&quot;2&quot; icon_1=&quot;main/contact/icon-1.png&quot; content_1=&quot;contact@shofy.com &lt;br&gt; &lt;strong&gt;+670 413 90 762&lt;/strong&gt;&quot; icon_2=&quot;main/contact/icon-2.png&quot; content_2=&quot;502 New St, Brighton VIC 3186, Australia&quot; show_social_info=&quot;1&quot; social_info_label=&quot;Find on social media&quot; social_info_icon=&quot;main/contact/icon-3.png&quot;][/contact-form][google-map]502 New Street, Brighton VIC, Australia[/google-map]',1,NULL,'full-width',NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(6,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(7,'Our Story','<h4>A passion for handcrafted coffee, brewed with love and community.</h4>\n\n<p>\n    We are a small, family-owned coffee roaster dedicated to bringing the finest, ethically sourced beans to your cup. Our story began in a cozy kitchen, fueled by a shared passion for the rich aroma and invigorating taste of freshly brewed coffee. We dreamt of creating a space where people could connect over a warm cup, share stories, and experience the joy of handcrafted coffee.\n</p>\n\n<h4>From Humble Beginnings to Roasting Success:</h4>\n\n<p>\n    Our journey started with a small coffee roaster nestled in our garage. We spent countless hours experimenting with different roasting profiles, meticulously cupping each batch to achieve the perfect balance of flavor and aroma. Driven by a desire to make a difference, we built relationships with sustainable coffee farms around the world, ensuring fair trade practices and the highest quality beans.\n</p>\n\n<h4>Milestones and More to Come:</h4>\n\n<p>\n    Our dedication to quality and community resonated with coffee lovers, and our small business quickly grew. We opened our first cafe, a warm and inviting space where people could gather, savor our freshly roasted coffee, and connect with friends and neighbors. We\'ve continued to expand, now offering a variety of handcrafted coffee beverages, alongside delicious pastries and light bites.\n</p>\n\n<h4>Values at Our Core:</h4>\n\n<p>\n    At the heart of everything we do lies our commitment to ethical sourcing, sustainable practices, and building meaningful connections. We believe in supporting the communities that cultivate our coffee beans, ensuring fair wages and responsible farming methods. Every cup you enjoy contributes to a positive impact, one sip at a time.\n</p>\n\n<h4>Join us on our journey!</h4>\n\n<p>\n    We invite you to explore our world of coffee, from the rich diversity of our bean origins to the unique flavors crafted through meticulous roasting. Visit our cafe, discover your perfect cup, and become part of our ever-growing coffee community. Let\'s connect over a cup, share stories, and celebrate the simple joy of a well-brewed coffee.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(8,'Careers','<h3>Careers: Be Part of Our Brewing Legacy</h3>\n\n<p>\n    At Shofy, we\'re not just brewing coffee, we\'re brewing a legacy. Since our humble beginnings in 2024, we\'ve grown from a small, family-owned roaster to a thriving coffee haven. But our passion for quality, community, and sustainability remains at the core of everything we do.\n</p>\n\n<h4>Why Join Our Team?</h4>\n\n<ul>\n    <li>\n        <p><strong>Become a Coffee Connoisseur</strong>: Immerse yourself in the world of coffee, learning from experienced roasters and baristas about bean origins, roasting techniques, and crafting the perfect cup.</p>\n    </li>\n    <li>\n        <p><strong>Fuel Your Passion</strong>: Contribute to our mission by sourcing ethically, promoting sustainable practices, and fostering positive relationships with coffee-growing communities around the globe.</p>\n    </li>\n    <li>\n        <p><strong>Grow with Us</strong>: We offer comprehensive training programs and opportunities for professional development, helping you refine your skills and advance your career in the coffee industry.</p>\n    </li>\n    <li>\n        <p><strong>Be Part of the Family</strong>: We cultivate a collaborative and supportive work environment where your unique talents and perspectives are valued.</p>\n    </li>\n</ul>\n\n<h4>Current Openings:</h4>\n\n<ul>\n    <li>\n        <p><strong>Coffee Roaster</strong>: Play a vital role in our roasting process, meticulously crafting unique flavor profiles and ensuring the highest quality beans reach our customers.</p>\n    </li>\n    <li>\n        <p><strong>Barista</strong>: Become a coffee ambassador, welcoming guests with a smile, crafting their perfect cup, and sharing your knowledge and passion for coffee.</p>\n    </li>\n    <li>\n        <p><strong>Cafe Manager</strong>: Lead your team in creating a warm and inviting atmosphere, overseeing daily operations, and ensuring exceptional customer service.</p>\n    </li>\n</ul>\n\n<h4>We are always looking for passionate individuals who share our values:</h4>\n\n<ul>\n    <li>\n        <p>A genuine love for coffee and a desire to learn everything there is to know about it.</p>\n    </li>\n    <li>\n        <p>A commitment to ethical sourcing, sustainability, and social responsibility.</p>\n    </li>\n    <li>\n        <p>Excellent communication and interpersonal skills to build rapport with colleagues and customers.</p>\n    </li>\n    <li>\n        <p>A positive attitude, a willingness to learn, and a collaborative spirit.</p>\n    </li>\n</ul>\n\n<p>Ready to join our brewing legacy?</p>\n\n<p>\n    Submit your resume and cover letter, telling us why you\'re a perfect fit for our team. We look forward to meeting passionate individuals who are ready to brew the future with us, one cup at a time.\n</p>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35'),(9,'Shipping','<section>\n    <h2>Shipping Methods</h2>\n    <p>We offer several shipping methods to choose from:</p>\n    <ul>\n        <li>Standard Shipping - 3 to 5 business days</li>\n        <li>Express Shipping - 1 to 2 business days</li>\n        <li>International Shipping - 7 to 14 business days</li>\n    </ul>\n    <p>Please note that shipping times may vary depending on your location and other factors.</p>\n</section>\n\n<section>\n    <h2>Shipping Costs</h2>\n    <p>Shipping costs are calculated based on the weight of your order and the shipping method selected during checkout.</p>\n    <p>You can view the estimated shipping costs in your shopping cart before completing your purchase.</p>\n</section>\n\n<section>\n    <h2>Tracking Your Order</h2>\n    <p>Once your order has been shipped, you will receive a confirmation email with a tracking number.</p>\n    <p>You can use this tracking number to monitor the status of your delivery on our website or through the shipping carrier\'s website.</p>\n</section>\n\n<section>\n    <h2>Shipping Restrictions</h2>\n    <p>Some items may be subject to shipping restrictions due to size, weight, or destination.</p>\n    <p>If your order contains any restricted items, we will notify you during the checkout process.</p>\n</section>\n',1,NULL,NULL,NULL,'published','2024-03-15 03:04:35','2024-03-15 03:04:35');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'K8ZZNEUTDZ','razorpay',NULL,1748.00,1,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'LISFMHQZS3','paystack',NULL,318.00,2,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'AJDHYHQC9X','sslcommerz',NULL,1590.00,3,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:36','2024-03-15 03:04:36','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'NGQYLOOUFN','cod',NULL,5343.00,4,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'V0E5KFDOKX','razorpay',NULL,1634.00,5,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'A7VFWGG2VC','bank_transfer',NULL,579.00,6,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'SZDPXZ0F8U','sslcommerz',NULL,2756.00,7,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'CPVRCHNHYJ','sslcommerz',NULL,636.00,8,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:37','2024-03-15 03:04:37','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'DEIRQXAY8F','bank_transfer',NULL,6916.00,9,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'OZHGMGSEBB','bank_transfer',NULL,5211.00,10,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'EQJVU0IIBZ','razorpay',NULL,2062.00,11,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'MAGWKOMZSO','bank_transfer',NULL,10742.00,12,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'JBXYFPNRXI','cod',NULL,1550.00,13,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:38','2024-03-15 03:04:38','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'3VJOWCBOXH','sslcommerz',NULL,1737.00,14,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'PQLVBEKYLE','razorpay',NULL,7844.00,15,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'DSNMZ92IHS','razorpay',NULL,1644.00,16,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'URUQOHXB0I','razorpay',NULL,1174.00,17,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'ZUY2IN8MOK','bank_transfer',NULL,5463.00,18,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'VOP5PB2WLG','paypal',NULL,7320.00,19,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:39','2024-03-15 03:04:39','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'7P9OCR1IQU','stripe',NULL,2622.00,20,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'FOV4BMFSSU','bank_transfer',NULL,5211.00,21,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'MIOZNNMBXF','cod',NULL,1522.00,22,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'6PCFXTTVBL','cod',NULL,5118.00,23,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'PVXY6ZKEE5','paypal',NULL,1550.00,24,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:40','2024-03-15 03:04:40','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'H7COKA2HEL','stripe',NULL,1644.00,25,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'OPNXD2QV7J','paypal',NULL,1287.00,26,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'6VUHWZBNGL','paystack',NULL,3110.00,27,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'CTGSTIFX03','paypal',NULL,2622.00,28,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'UDR4TLYCPN','paystack',NULL,4880.00,29,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:41','2024-03-15 03:04:41','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'AKD8YTAUZA','paystack',NULL,3816.00,30,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'AC55XDNVDU','cod',NULL,850.00,31,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'MLWYYZPNVL','bank_transfer',NULL,1158.00,32,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'WPGP3Y45MH','bank_transfer',NULL,1287.00,33,'pending','confirm',9,NULL,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'3JX47M3ZTF','stripe',NULL,5343.00,34,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:42','2024-03-15 03:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'0FMVZ5YXDZ','paystack',NULL,425.00,35,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'LXQZF5Y4Q8','sslcommerz',NULL,513.00,36,'completed','confirm',9,NULL,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'IIHUYYVM0A','bank_transfer',NULL,2440.00,37,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'MQJIYPMS0G','stripe',NULL,2703.00,38,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'22ZPFBJ5Z3','cod',NULL,1539.00,39,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:43','2024-03-15 03:04:43','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'T9HKDNF5XX','stripe',NULL,2526.00,40,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'YHSHIS3PGZ','paystack',NULL,850.00,41,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'2XLXALE57O','stripe',NULL,302.00,42,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\Ecommerce\\Models\\Customer',NULL),(43,'USD',0,'CMRJQMDNDR','bank_transfer',NULL,2756.00,43,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\Ecommerce\\Models\\Customer',NULL),(44,'USD',0,'QX9W36EEGF','cod',NULL,1323.00,44,'pending','confirm',10,NULL,NULL,'2024-03-15 03:04:44','2024-03-15 03:04:44','Botble\\Ecommerce\\Models\\Customer',NULL),(45,'USD',0,'4T0YNQOKVV','sslcommerz',NULL,5211.00,45,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45','Botble\\Ecommerce\\Models\\Customer',NULL),(46,'USD',0,'0LIYKEHUOS','sslcommerz',NULL,5343.00,46,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45','Botble\\Ecommerce\\Models\\Customer',NULL),(47,'USD',0,'SNKTGUZANB','sslcommerz',NULL,2451.00,47,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45','Botble\\Ecommerce\\Models\\Customer',NULL),(48,'USD',0,'7232KD2EZU','stripe',NULL,3488.00,48,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45','Botble\\Ecommerce\\Models\\Customer',NULL),(49,'USD',0,'GDTAFNUE9C','paystack',NULL,1998.00,49,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:45','2024-03-15 03:04:45','Botble\\Ecommerce\\Models\\Customer',NULL),(50,'USD',0,'F3M5FPEO4M','sslcommerz',NULL,3474.00,50,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46','Botble\\Ecommerce\\Models\\Customer',NULL),(51,'USD',0,'S1FF0GXQ8F','paystack',NULL,1562.00,51,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46','Botble\\Ecommerce\\Models\\Customer',NULL),(52,'USD',0,'JQ3B2EWIXF','stripe',NULL,2385.00,52,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46','Botble\\Ecommerce\\Models\\Customer',NULL),(53,'USD',0,'JWN42NDTTY','paypal',NULL,3642.00,53,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46','Botble\\Ecommerce\\Models\\Customer',NULL),(54,'USD',0,'F7XU4CIGYU','razorpay',NULL,4947.00,54,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:46','2024-03-15 03:04:46','Botble\\Ecommerce\\Models\\Customer',NULL),(55,'USD',0,'C4PXJUZFWL','razorpay',NULL,4836.00,55,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47','Botble\\Ecommerce\\Models\\Customer',NULL),(56,'USD',0,'RJDTOCNPKV','paypal',NULL,1722.00,56,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47','Botble\\Ecommerce\\Models\\Customer',NULL),(57,'USD',0,'OB0PWWBPPZ','sslcommerz',NULL,2005.00,57,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47','Botble\\Ecommerce\\Models\\Customer',NULL),(58,'USD',0,'EKFH8KBOS7','stripe',NULL,587.00,58,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47','Botble\\Ecommerce\\Models\\Customer',NULL),(59,'USD',0,'FLO5QSJRTY','razorpay',NULL,4932.00,59,'completed','confirm',10,NULL,NULL,'2024-03-15 03:04:47','2024-03-15 03:04:47','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (3,1),(5,1),(6,2),(1,2),(6,3),(4,3),(1,4),(5,4),(1,5),(3,5),(5,6),(2,6),(3,7),(6,8),(2,8),(6,9),(4,9),(5,10),(1,10),(6,11),(2,11),(1,12),(4,12),(3,13),(4,13),(4,14),(6,14),(1,15),(6,16),(3,16),(6,17),(4,17),(4,18),(2,18);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (7,1),(8,1),(2,1),(5,2),(1,2),(8,2),(3,3),(5,3),(6,4),(3,4),(4,4),(5,5),(1,5),(5,6),(3,6),(7,6),(8,7),(3,7),(5,7),(2,8),(1,8),(7,8),(6,9),(4,9),(5,10),(3,10),(7,10),(7,11),(5,11),(3,11),(2,12),(7,12),(1,12),(6,13),(3,13),(8,14),(4,14),(8,15),(1,15),(6,15),(2,16),(5,16),(7,16),(1,17),(3,17),(1,18),(4,18);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','Duchess to play croquet.\' The Frog-Footman repeated, in the morning, just time to begin with.\' \'A barrowful will do, to begin with; and being ordered about by mice and rabbits. I almost wish I.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-6.jpg',959,NULL,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','I BEG your pardon!\' said the March Hare meekly replied. \'Yes, but I THINK I can listen all day about it!\' Last came a rumbling of little Alice and all of them didn\'t know that cats COULD grin.\'.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-2.jpg',1080,NULL,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(3,'The Top 2020 Handbag Trends to Know','Queen, and Alice was just possible it had come back in a very grave voice, \'until all the while, till at last the Mouse, getting up and said, \'So you did, old fellow!\' said the Mock Turtle: \'crumbs.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-1.jpg',1905,NULL,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(4,'How to Match the Color of Your Handbag With an Outfit','Alice, \'it\'ll never do to come before that!\' \'Call the next thing is, to get very tired of this. I vote the young lady tells us a story!\' said the Queen, stamping on the stairs. Alice knew it was.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-1.jpg',2463,NULL,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(5,'How to Care for Leather Bags','I\'ll never go THERE again!\' said Alice to herself. Imagine her surprise, when the Rabbit began. Alice gave a sudden leap out of its voice. \'Back to land again, and went down on one side, to look for.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-3.jpg',2363,NULL,'2024-03-15 03:04:24','2024-03-15 03:04:24'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','Pigeon had finished. \'As if I must, I must,\' the King sharply. \'Do you mean that you think I must sugar my hair.\" As a duck with its wings. \'Serpent!\' screamed the Gryphon. \'Well, I shan\'t grow any.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-5.jpg',157,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(7,'Essential Qualities of Highly Successful Music','I then? Tell me that first, and then, and holding it to be lost: away went Alice after it, never once considering how in the same year for such dainties would not open any of them. However, on the.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-10.jpg',896,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(8,'9 Things I Love About Shaving My Head','But do cats eat bats?\' and sometimes, \'Do bats eat cats?\' for, you see, as they were playing the Queen said--\' \'Get to your places!\' shouted the Queen. \'I haven\'t opened it yet,\' said the Duchess.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',268,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(9,'Why Teamwork Really Makes The Dream Work','Now, if you cut your finger VERY deeply with a large one, but it did not dare to laugh; and, as the Rabbit, and had to be two people. \'But it\'s no use now,\' thought poor Alice, that she began.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-1.jpg',2071,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(10,'The World Caters to Average People','March Hare went on. \'We had the best of educations--in fact, we went to school in the last few minutes that she was a very fine day!\' said a timid voice at her for a minute or two the Caterpillar.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-8.jpg',689,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(11,'The litigants on the screen are not actors','Gryphon: and Alice was not a mile high,\' said Alice. \'Well, I should think you\'ll feel it a bit, if you like!\' the Duchess sang the second time round, she came up to Alice, she went on. Her.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-3.jpg',998,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(12,'Hiring the Right Sales Team at the Right Time','It\'s high time to begin lessons: you\'d only have to turn round on its axis--\' \'Talking of axes,\' said the sage, as he shook his grey locks, \'I kept all my life, never!\' They had not noticed before.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-1.jpg',919,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(13,'Fully Embrace the Return of 90s fashion','Gryphon. \'It all came different!\' Alice replied very solemnly. Alice was thoroughly puzzled. \'Does the boots and shoes!\' she repeated in a very truthful child; \'but little girls in my size; and as.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',1359,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(14,'Exploring the English Countryside','But I\'ve got to the other queer noises, would change (she knew) to the door, and the baby--the fire-irons came first; then followed a shower of little animals and birds waiting outside. The poor.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-6.jpg',230,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(15,'Here’s the First Valentino’s New Makeup Collection','Dormouse indignantly. However, he consented to go on with the edge with each hand. \'And now which is which?\' she said to herself. \'Shy, they seem to come before that!\' \'Call the next witness.\' And.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',1495,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(16,'Follow Your own Design process, whatever gets','Alice, \'and if it makes rather a handsome pig, I think.\' And she tried hard to whistle to it; but she remembered the number of bathing machines in the air, mixed up with the Mouse to Alice again.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-11.jpg',145,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(17,'Freelancer Days 2024, What’s new?','YOU manage?\' Alice asked. \'We called him a fish)--and rapped loudly at the March Hare interrupted in a very interesting dance to watch,\' said Alice, who felt very curious to see what this bottle.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blog/post-6.jpg',1130,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25'),(18,'Quality Foods Requirments For Every Human Body’s','They all sat down and cried. \'Come, there\'s half my plan done now! How puzzling all these changes are! I\'m never sure what I\'m going to begin with; and being ordered about in the back. However, it.','<p class=\"tp-dropcap\">sales process is critically important to the success of your reps and your business. If you\'ve never seen a really skilled salesperson work, it seems almost effortless. They ask great questions, craftt perfect proposal, answer questions, address concerns and seamlessly seal the Underneath the surface of all of that, the salesperson has probably dedicated hours honing their craft and ensuring the process moves smoothly.</p>\n\n<p>One of the challenges that often surfaces when  working with a remote sales team is a lack of transparency over what is happening, and where in the process things are taking place. We’re going to peel back the curtain and show you how to create the best sales.</p>\n\n<h4 class=\"tp-postbox-details-heading\">Breaking Up With Fast Fashion Has Been Easier</h4>\n<p>Lommodo ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient montes lorem, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium, sem. Nulla onsequat massa quis enim. donec pede justo fringilla vel aliquet.</p>\n\n<div class=\"tp-postbox-details-desc-thumb text-center\">\n   <img src=\"/storage/main/blog/blog-details-sm-1.jpg\" alt=\"\">\n   <span class=\"tp-postbox-details-desc-thumb-caption\">Gucci’s Women’s Cruise Collection 2023 Lookbook Has Arrived</span>\n</div>\n<p>“We’re so glad we’ll be working with you to get your new marketing strategy up and running. I\'ve attached the details of your package. Next you’ll get an email from Jen to schedule your kick-off meeting and be assigned your account rep. During your kick-off meeting, we will introduce your project team, let you know what access we need to start.” </p>\n\n<div class=\"tp-postbox-details-quote\">\n   <blockquote>\n      <div class=\"tp-postbox-details-quote-shape\">\n         <img class=\"tp-postbox-details-quote-shape-1\" src=\"/storage/main/shapes/line.png\" alt=\"\">\n         <img class=\"tp-postbox-details-quote-shape-2\" src=\"/storage/main/shapes/quote.png\" alt=\"\">\n      </div>\n      <p>There is a way out of every box, a solution to every puzzle its just a matter of finding it.</p>\n      <span style=\"color: #fff\">Shahnewaz Sakil</span>\n   </blockquote>\n</div>\n\n<h4 class=\"tp-postbox-details-heading\">Exploring the English Countryside</h4>\n<p>Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus et magnis dis parturient montes lorem,nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque euro, pretium quis, sem. Nulla onsequat massa quis enim.</p>\n\n<div class=\"tp-postbox-details-list\">\n   <ul>\n      <li>Lorem ipsum dolor sit amet.</li>\n      <li>At vero eos et accusamus et iusto odio.</li>\n      <li>Excepteur sint occaecat cupidatat non proident.</li>\n   </ul>\n</div>\n<p>Rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer cidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae lorem.</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blog/post-4.jpg',497,NULL,'2024-03-15 03:04:25','2024-03-15 03:04:25');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_logs`
--

DROP TABLE IF EXISTS `request_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_code` int DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  `user_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_logs`
--

LOCK TABLES `request_logs` WRITE;
/*!40000 ALTER TABLE `request_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.manage.license\":true,\"extensions.index\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.cronjob\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"plugins.captcha\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.settings\":true,\"plugins.ecommerce\":true,\"ecommerce.settings\":true,\"ecommerce.report.index\":true,\"products.index\":true,\"products.create\":true,\"products.edit\":true,\"products.destroy\":true,\"products.duplicate\":true,\"product-categories.index\":true,\"product-categories.create\":true,\"product-categories.edit\":true,\"product-categories.destroy\":true,\"product-tag.index\":true,\"product-tag.create\":true,\"product-tag.edit\":true,\"product-tag.destroy\":true,\"brands.index\":true,\"brands.create\":true,\"brands.edit\":true,\"brands.destroy\":true,\"product-collections.index\":true,\"product-collections.create\":true,\"product-collections.edit\":true,\"product-collections.destroy\":true,\"product-attribute-sets.index\":true,\"product-attribute-sets.create\":true,\"product-attribute-sets.edit\":true,\"product-attribute-sets.destroy\":true,\"product-attributes.index\":true,\"product-attributes.create\":true,\"product-attributes.edit\":true,\"product-attributes.destroy\":true,\"tax.index\":true,\"tax.create\":true,\"tax.edit\":true,\"tax.destroy\":true,\"reviews.index\":true,\"reviews.create\":true,\"reviews.destroy\":true,\"reviews.publish\":true,\"reviews.reply\":true,\"shipping_methods.index\":true,\"ecommerce.shipping-rule-items.index\":true,\"ecommerce.shipping-rule-items.create\":true,\"ecommerce.shipping-rule-items.edit\":true,\"ecommerce.shipping-rule-items.destroy\":true,\"ecommerce.shipping-rule-items.bulk-import\":true,\"ecommerce.shipments.index\":true,\"ecommerce.shipments.create\":true,\"ecommerce.shipments.edit\":true,\"ecommerce.shipments.destroy\":true,\"orders.index\":true,\"orders.create\":true,\"orders.edit\":true,\"orders.destroy\":true,\"discounts.index\":true,\"discounts.create\":true,\"discounts.edit\":true,\"discounts.destroy\":true,\"customers.index\":true,\"customers.create\":true,\"customers.edit\":true,\"customers.destroy\":true,\"flash-sale.index\":true,\"flash-sale.create\":true,\"flash-sale.edit\":true,\"flash-sale.destroy\":true,\"product-label.index\":true,\"product-label.create\":true,\"product-label.edit\":true,\"product-label.destroy\":true,\"ecommerce.import.products.index\":true,\"ecommerce.export.products.index\":true,\"order_returns.index\":true,\"order_returns.edit\":true,\"order_returns.destroy\":true,\"global-option.index\":true,\"global-option.create\":true,\"global-option.edit\":true,\"global-option.destroy\":true,\"ecommerce.invoice.index\":true,\"ecommerce.invoice.edit\":true,\"ecommerce.invoice.destroy\":true,\"ecommerce.invoice-template.index\":true,\"ecommerce.settings.general\":true,\"ecommerce.settings.currencies\":true,\"ecommerce.settings.products\":true,\"ecommerce.settings.product-search\":true,\"ecommerce.settings.digital-products\":true,\"ecommerce.settings.store-locators\":true,\"ecommerce.settings.invoices\":true,\"ecommerce.settings.product-reviews\":true,\"ecommerce.settings.customers\":true,\"ecommerce.settings.shopping\":true,\"ecommerce.settings.taxes\":true,\"ecommerce.settings.shipping\":true,\"ecommerce.settings.tracking\":true,\"ecommerce.settings.standard-and-format\":true,\"ecommerce.settings.checkout\":true,\"ecommerce.settings.return\":true,\"ecommerce.settings.flash-sale\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"location.bulk-import.index\":true,\"location.export.index\":true,\"marketplace.index\":true,\"marketplace.store.index\":true,\"marketplace.store.create\":true,\"marketplace.store.edit\":true,\"marketplace.store.destroy\":true,\"marketplace.store.view\":true,\"marketplace.store.revenue.create\":true,\"marketplace.withdrawal.index\":true,\"marketplace.withdrawal.edit\":true,\"marketplace.withdrawal.destroy\":true,\"marketplace.vendors.index\":true,\"marketplace.unverified-vendors.index\":true,\"marketplace.unverified-vendors.edit\":true,\"marketplace.settings\":true,\"marketplace.reports\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"request-log.index\":true,\"request-log.destroy\":true,\"sale-popup.settings\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true}','Admin users role',1,1,1,'2024-03-15 03:04:20','2024-03-15 03:04:20');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','9138af60a26ec195bc55118ba1c3db1e',NULL,'2024-03-15 03:04:35'),(2,'api_enabled','0',NULL,'2024-03-15 03:04:35'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"ecommerce\",\"faq\",\"gallery\",\"location\",\"marketplace\",\"newsletter\",\"payment\",\"paypal\",\"paypal-payout\",\"paystack\",\"razorpay\",\"request-log\",\"sale-popup\",\"shippo\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2024-03-15 03:04:35'),(6,'theme','shofy-jewelry',NULL,'2024-03-15 03:04:35'),(7,'show_admin_bar','1',NULL,'2024-03-15 03:04:35'),(8,'payment_cod_status','1',NULL,'2024-03-15 03:04:35'),(9,'payment_bank_transfer_status','1',NULL,'2024-03-15 03:04:35'),(10,'admin_favicon','main/general/favicon.png',NULL,'2024-03-15 03:04:35'),(11,'admin_logo','main/general/logo-white.png',NULL,'2024-03-15 03:04:35'),(12,'permalink-botble-blog-models-post','blog',NULL,'2024-03-15 03:04:35'),(13,'permalink-botble-blog-models-category','blog',NULL,'2024-03-15 03:04:35'),(14,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2024-03-15 03:04:35'),(15,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2024-03-15 03:04:35'),(16,'payment_stripe_payment_type','stripe_checkout',NULL,'2024-03-15 03:04:35'),(17,'plugins_ecommerce_customer_new_order_status','0',NULL,'2024-03-15 03:04:35'),(18,'plugins_ecommerce_admin_new_order_status','0',NULL,'2024-03-15 03:04:35'),(19,'ecommerce_is_enabled_support_digital_products','1',NULL,'2024-03-15 03:04:35'),(20,'ecommerce_load_countries_states_cities_from_location_plugin','0',NULL,'2024-03-15 03:04:35'),(21,'language_hide_default','1',NULL,'2024-03-15 03:04:35'),(22,'language_switcher_display','dropdown',NULL,'2024-03-15 03:04:35'),(23,'language_display','all',NULL,'2024-03-15 03:04:35'),(24,'language_hide_languages','[]',NULL,'2024-03-15 03:04:35'),(25,'ecommerce_store_name','Shofy',NULL,'2024-03-15 03:04:35'),(26,'ecommerce_store_phone','1800979769',NULL,'2024-03-15 03:04:35'),(27,'ecommerce_store_address','502 New Street',NULL,'2024-03-15 03:04:35'),(28,'ecommerce_store_state','Brighton VIC',NULL,'2024-03-15 03:04:35'),(29,'ecommerce_store_city','Brighton VIC',NULL,'2024-03-15 03:04:35'),(30,'ecommerce_store_country','AU',NULL,'2024-03-15 03:04:35'),(31,'announcement_max_width',NULL,NULL,'2024-03-15 03:04:35'),(32,'announcement_text_color','#010f1c',NULL,'2024-03-15 03:04:36'),(33,'announcement_background_color','transparent',NULL,'2024-03-15 03:04:36'),(34,'announcement_placement','theme',NULL,'2024-03-15 03:04:36'),(35,'announcement_text_alignment','start',NULL,'2024-03-15 03:04:36'),(36,'announcement_dismissible','0',NULL,'2024-03-15 03:04:36'),(37,'simple_slider_using_assets','0',NULL,'2024-03-15 03:04:36'),(38,'theme-shofy-jewelry-site_name','Shofy',NULL,NULL),(39,'theme-shofy-jewelry-site_title','Shofy - Multipurpose eCommerce Laravel Script',NULL,NULL),(40,'theme-shofy-jewelry-seo_description','Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.',NULL,NULL),(41,'theme-shofy-jewelry-copyright','© %Y All Rights Reserved.',NULL,NULL),(42,'theme-shofy-jewelry-primary_font','Jost',NULL,NULL),(43,'theme-shofy-jewelry-primary_color','#BD844C',NULL,NULL),(44,'theme-shofy-jewelry-favicon','main/general/favicon.png',NULL,NULL),(45,'theme-shofy-jewelry-logo','main/general/logo.png',NULL,NULL),(46,'theme-shofy-jewelry-logo_light','main/general/logo-white.png',NULL,NULL),(47,'theme-shofy-jewelry-header_style','4',NULL,NULL),(48,'theme-shofy-jewelry-preloader_icon','main/general/preloader-icon.png',NULL,NULL),(49,'theme-shofy-jewelry-address','502 New Street, Brighton VIC, Australia',NULL,NULL),(50,'theme-shofy-jewelry-hotline','8 800 332 65-66',NULL,NULL),(51,'theme-shofy-jewelry-email','contact@fartmart.co',NULL,NULL),(52,'theme-shofy-jewelry-working_time','Mon - Fri: 07AM - 06PM',NULL,NULL),(53,'theme-shofy-jewelry-homepage_id','1',NULL,NULL),(54,'theme-shofy-jewelry-blog_page_id','4',NULL,NULL),(55,'theme-shofy-jewelry-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(56,'theme-shofy-jewelry-cookie_consent_learn_more_url','cookie-policy',NULL,NULL),(57,'theme-shofy-jewelry-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(58,'theme-shofy-jewelry-number_of_products_per_page','24',NULL,NULL),(59,'theme-shofy-jewelry-number_of_cross_sale_product','6',NULL,NULL),(60,'theme-shofy-jewelry-ecommerce_products_page_layout','left_sidebar',NULL,NULL),(61,'theme-shofy-jewelry-ecommerce_product_item_style','4',NULL,NULL),(62,'theme-shofy-jewelry-logo_in_the_checkout_page','main/general/logo.png',NULL,NULL),(63,'theme-shofy-jewelry-logo_in_invoices','main/general/logo.png',NULL,NULL),(64,'theme-shofy-jewelry-logo_vendor_dashboard','main/general/logo.png',NULL,NULL),(65,'theme-shofy-jewelry-404_page_image','main/general/404.png',NULL,NULL),(66,'theme-shofy-jewelry-newsletter_popup_enable','1',NULL,NULL),(67,'theme-shofy-jewelry-newsletter_popup_image','main/general/newsletter-popup.png',NULL,NULL),(68,'theme-shofy-jewelry-newsletter_popup_title','Subscribe Now',NULL,NULL),(69,'theme-shofy-jewelry-newsletter_popup_subtitle','Newsletter',NULL,NULL),(70,'theme-shofy-jewelry-newsletter_popup_description','Subscribe to our newsletter and get 10% off your first purchase',NULL,NULL),(71,'theme-shofy-jewelry-lazy_load_images','1',NULL,NULL),(72,'theme-shofy-jewelry-lazy_load_placeholder_image','main/general/placeholder.png',NULL,NULL),(73,'theme-shofy-jewelry-breadcrumb_background_image','main/general/breadcrumb.jpg',NULL,NULL),(74,'theme-shofy-jewelry-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"Youtube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Shine bright','jewelry/sliders/slider-1.png','/products','The original',0,'2024-03-15 03:04:29','2024-03-15 03:04:29'),(2,1,'Creative Design','jewelry/sliders/slider-2.png','/products','The original',1,'2024-03-15 03:04:29','2024-03-15 03:04:29'),(3,1,'Gold Plateted','jewelry/sliders/slider-3.png','/products','The original',2,'2024-03-15 03:04:29','2024-03-15 03:04:29'),(4,1,'Unique shapes','jewelry/sliders/slider-4.png','/products','The original',3,'2024-03-15 03:04:29','2024-03-15 03:04:29');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2024-03-15 03:04:29','2024-03-15 03:04:29');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=234 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'foodpound',1,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:04:20','2024-03-15 03:04:20'),(2,'itea-jsc',2,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:04:20','2024-03-15 03:04:20'),(3,'soda-brand',3,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:04:20','2024-03-15 03:04:20'),(4,'shofy',4,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:04:20','2024-03-15 03:04:20'),(5,'soda-brand',5,'Botble\\Ecommerce\\Models\\Brand','brands','2024-03-15 03:04:20','2024-03-15 03:04:20'),(6,'electronic',1,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:04:23','2024-03-15 03:04:23'),(7,'mobile',2,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:04:23','2024-03-15 03:04:23'),(8,'iphone',3,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:04:23','2024-03-15 03:04:23'),(9,'printer',4,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:04:23','2024-03-15 03:04:23'),(10,'office',5,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:04:23','2024-03-15 03:04:23'),(11,'it',6,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2024-03-15 03:04:23','2024-03-15 03:04:23'),(12,'crisp-bread-cake',1,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(13,'fashion',2,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(14,'electronic',3,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(15,'commercial',4,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(16,'organic-fruits',5,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(17,'ecological',6,'Botble\\Blog\\Models\\Category','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(18,'general',1,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(19,'design',2,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(20,'fashion',3,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(21,'branding',4,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(22,'modern',5,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(23,'nature',6,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(24,'vintage',7,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(25,'sunglasses',8,'Botble\\Blog\\Models\\Tag','tag','2024-03-15 03:04:24','2024-03-15 03:04:24'),(26,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',1,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(27,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',2,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(28,'the-top-2020-handbag-trends-to-know',3,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(29,'how-to-match-the-color-of-your-handbag-with-an-outfit',4,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:24','2024-03-15 03:04:24'),(30,'how-to-care-for-leather-bags',5,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(31,'were-crushing-hard-on-summers-10-biggest-bag-trends',6,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(32,'essential-qualities-of-highly-successful-music',7,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(33,'9-things-i-love-about-shaving-my-head',8,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(34,'why-teamwork-really-makes-the-dream-work',9,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(35,'the-world-caters-to-average-people',10,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(36,'the-litigants-on-the-screen-are-not-actors',11,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(37,'hiring-the-right-sales-team-at-the-right-time',12,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(38,'fully-embrace-the-return-of-90s-fashion',13,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(39,'exploring-the-english-countryside',14,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(40,'heres-the-first-valentinos-new-makeup-collection',15,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(41,'follow-your-own-design-process-whatever-gets',16,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(42,'freelancer-days-2024-whats-new',17,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(43,'quality-foods-requirments-for-every-human-bodys',18,'Botble\\Blog\\Models\\Post','blog','2024-03-15 03:04:25','2024-03-15 03:04:25'),(44,'gopro',1,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(45,'global-office',2,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(46,'young-shop',3,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(47,'global-store',4,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(48,'roberts-store',5,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(49,'stouffer',6,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(50,'starkist',7,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(51,'old-el-paso',8,'Botble\\Marketplace\\Models\\Store','stores','2024-03-15 03:04:28','2024-03-15 03:04:28'),(52,'discover-skincare',1,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(53,'clothing',2,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(54,'mens-clothing',3,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(55,'t-shirts',4,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(56,'jeans',5,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(57,'suits',6,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(58,'womens-clothing',7,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(59,'dresses',8,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(60,'blouses',9,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(61,'pants',10,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(62,'accessories',11,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(63,'hats',12,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(64,'scarves',13,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(65,'jewelry',14,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(66,'sportswear',15,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(67,'activewear',16,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(68,'running-shoes',17,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2024-03-15 03:04:29','2024-03-15 03:04:29'),(69,'vintage-denim-jacket',1,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(70,'floral-maxi-dress',2,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(71,'leather-ankle-boots',3,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(72,'knit-turtleneck-sweater-digital',4,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:05:08'),(73,'classic-aviator-sunglasses',5,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(74,'tailored-wool-blazer',6,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(75,'bohemian-fringe-handbag',7,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(76,'silk-scarf-with-geometric-print-digital',8,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:05:08'),(77,'high-waisted-wide-leg-trousers',9,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(78,'embroidered-boho-blouse',10,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(79,'statement-chunky-necklace',11,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(80,'chic-fedora-hat-digital',12,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:05:08'),(81,'strappy-block-heel-sandals',13,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(82,'velvet-evening-gown',14,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(83,'quilted-crossbody-bag',15,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(84,'distressed-skinny-jeans-digital',16,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:05:08'),(85,'lace-up-combat-boots',17,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(86,'cotton-striped-t-shirt-dress',18,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(87,'printed-palazzo-pants',19,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:04:30'),(88,'structured-satchel-bag-digital',20,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:30','2024-03-15 03:05:08'),(89,'off-shoulder-ruffle-top',21,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(90,'suede-pointed-toe-pumps',22,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(91,'cropped-cable-knit-sweater',23,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(92,'athleisure-jogger-pants-digital',24,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:05:08'),(93,'leopard-print-midi-skirt',25,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(94,'retro-cat-eye-sunglasses',26,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(95,'faux-fur-trimmed-coat',27,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(96,'boho-fringed-kimono-digital',28,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:05:08'),(97,'ruffled-wrap-dress',29,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(98,'beaded-evening-clutch',30,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(99,'wide-brim-floppy-hat',31,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(100,'denim-overall-jumpsuit-digital',32,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:05:08'),(101,'embellished-ballet-flats',33,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(102,'pleated-midi-skirt',34,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(103,'velour-tracksuit-set',35,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(104,'geometric-patterned-cardigan-digital',36,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:05:08'),(105,'buckle-detail-ankle-booties',37,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(106,'embroidered-bomber-jacket',38,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(107,'cowl-neck-knit-poncho',39,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(108,'chunky-knit-infinity-scarf-digital',40,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:05:08'),(109,'retro-high-top-sneakers',41,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(110,'faux-leather-leggings',42,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(111,'metallic-pleated-maxi-skirt',43,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:04:31','2024-03-15 03:04:31'),(112,'radiant-reflections',1,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:04:35','2024-03-15 03:04:35'),(113,'glamour-grove',2,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:04:35','2024-03-15 03:04:35'),(114,'serene-styles-showcase',3,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:04:35','2024-03-15 03:04:35'),(115,'allure-alcove',4,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:04:35','2024-03-15 03:04:35'),(116,'glamour-galleria',5,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:04:35','2024-03-15 03:04:35'),(117,'beauty-boulevard',6,'Botble\\Gallery\\Models\\Gallery','galleries','2024-03-15 03:04:35','2024-03-15 03:04:35'),(118,'home',1,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(119,'product-categories',2,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(120,'coupons',3,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(121,'blog',4,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(122,'contact',5,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(123,'cookie-policy',6,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(124,'our-story',7,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(125,'careers',8,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(126,'shipping',9,'Botble\\Page\\Models\\Page','','2024-03-15 03:04:35','2024-03-15 03:04:35'),(127,'vintage-denim-jacket',44,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(128,'floral-maxi-dress',45,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(129,'leather-ankle-boots',46,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(130,'knit-turtleneck-sweater-digital',47,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(131,'knit-turtleneck-sweater-digital',48,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(132,'knit-turtleneck-sweater-digital',49,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(133,'classic-aviator-sunglasses',50,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(134,'classic-aviator-sunglasses',51,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(135,'tailored-wool-blazer',52,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(136,'bohemian-fringe-handbag',53,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(137,'bohemian-fringe-handbag',54,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(138,'bohemian-fringe-handbag',55,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(139,'silk-scarf-with-geometric-print-digital',56,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(140,'silk-scarf-with-geometric-print-digital',57,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(141,'high-waisted-wide-leg-trousers',58,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(142,'embroidered-boho-blouse',59,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(143,'embroidered-boho-blouse',60,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(144,'embroidered-boho-blouse',61,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(145,'embroidered-boho-blouse',62,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(146,'statement-chunky-necklace',63,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(147,'statement-chunky-necklace',64,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(148,'chic-fedora-hat-digital',65,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(149,'chic-fedora-hat-digital',66,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(150,'chic-fedora-hat-digital',67,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(151,'chic-fedora-hat-digital',68,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(152,'strappy-block-heel-sandals',69,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(153,'velvet-evening-gown',70,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(154,'velvet-evening-gown',71,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(155,'velvet-evening-gown',72,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(156,'quilted-crossbody-bag',73,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(157,'quilted-crossbody-bag',74,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(158,'quilted-crossbody-bag',75,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(159,'distressed-skinny-jeans-digital',76,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(160,'distressed-skinny-jeans-digital',77,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(161,'distressed-skinny-jeans-digital',78,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(162,'distressed-skinny-jeans-digital',79,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(163,'lace-up-combat-boots',80,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(164,'cotton-striped-t-shirt-dress',81,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(165,'cotton-striped-t-shirt-dress',82,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(166,'cotton-striped-t-shirt-dress',83,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(167,'cotton-striped-t-shirt-dress',84,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(168,'printed-palazzo-pants',85,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(169,'printed-palazzo-pants',86,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(170,'printed-palazzo-pants',87,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(171,'structured-satchel-bag-digital',88,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(172,'structured-satchel-bag-digital',89,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(173,'structured-satchel-bag-digital',90,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(174,'off-shoulder-ruffle-top',91,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(175,'off-shoulder-ruffle-top',92,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(176,'off-shoulder-ruffle-top',93,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(177,'suede-pointed-toe-pumps',94,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(178,'cropped-cable-knit-sweater',95,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(179,'cropped-cable-knit-sweater',96,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(180,'athleisure-jogger-pants-digital',97,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(181,'athleisure-jogger-pants-digital',98,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(182,'athleisure-jogger-pants-digital',99,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(183,'leopard-print-midi-skirt',100,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(184,'leopard-print-midi-skirt',101,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(185,'leopard-print-midi-skirt',102,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(186,'retro-cat-eye-sunglasses',103,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(187,'retro-cat-eye-sunglasses',104,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(188,'retro-cat-eye-sunglasses',105,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(189,'retro-cat-eye-sunglasses',106,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(190,'retro-cat-eye-sunglasses',107,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(191,'faux-fur-trimmed-coat',108,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(192,'faux-fur-trimmed-coat',109,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(193,'boho-fringed-kimono-digital',110,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(194,'boho-fringed-kimono-digital',111,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(195,'ruffled-wrap-dress',112,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(196,'ruffled-wrap-dress',113,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(197,'ruffled-wrap-dress',114,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(198,'ruffled-wrap-dress',115,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(199,'beaded-evening-clutch',116,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(200,'beaded-evening-clutch',117,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(201,'wide-brim-floppy-hat',118,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(202,'wide-brim-floppy-hat',119,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(203,'wide-brim-floppy-hat',120,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(204,'denim-overall-jumpsuit-digital',121,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(205,'denim-overall-jumpsuit-digital',122,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(206,'denim-overall-jumpsuit-digital',123,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(207,'embellished-ballet-flats',124,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(208,'embellished-ballet-flats',125,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(209,'embellished-ballet-flats',126,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(210,'embellished-ballet-flats',127,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(211,'pleated-midi-skirt',128,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(212,'pleated-midi-skirt',129,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(213,'velour-tracksuit-set',130,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(214,'velour-tracksuit-set',131,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(215,'geometric-patterned-cardigan-digital',132,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(216,'geometric-patterned-cardigan-digital',133,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(217,'geometric-patterned-cardigan-digital',134,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(218,'buckle-detail-ankle-booties',135,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(219,'embroidered-bomber-jacket',136,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(220,'embroidered-bomber-jacket',137,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(221,'embroidered-bomber-jacket',138,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(222,'embroidered-bomber-jacket',139,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(223,'cowl-neck-knit-poncho',140,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(224,'chunky-knit-infinity-scarf-digital',141,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(225,'chunky-knit-infinity-scarf-digital',142,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(226,'chunky-knit-infinity-scarf-digital',143,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(227,'chunky-knit-infinity-scarf-digital',144,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(228,'retro-high-top-sneakers',145,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(229,'faux-leather-leggings',146,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(230,'faux-leather-leggings',147,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(231,'faux-leather-leggings',148,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(232,'faux-leather-leggings',149,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08'),(233,'metallic-pleated-maxi-skirt',150,'Botble\\Ecommerce\\Models\\Product','products','2024-03-15 03:05:08','2024-03-15 03:05:08');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'General',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24'),(2,'Design',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24'),(3,'Fashion',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24'),(4,'Branding',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24'),(5,'Modern',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24'),(6,'Nature',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24'),(7,'Vintage',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24'),(8,'Sunglasses',NULL,'Botble\\ACL\\Models\\User',NULL,'published','2024-03-15 03:04:24','2024-03-15 03:04:24');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'James Dopli','Thanks for all your efforts and teamwork over the last several months!  Thank you so much','main/users/7.jpg','Developer','published','2024-03-15 03:04:28','2024-03-15 03:04:28'),(2,'Theodore Handle','How you use the city or town name is up to you. All results may be freely used in any work.','main/users/7.jpg','CO Founder','published','2024-03-15 03:04:28','2024-03-15 03:04:28'),(3,'Shahnewaz Sakil','Very happy with our choice to take our daughter to Brave care. The entire team was great! Thank you!','main/users/7.jpg','UI/UX Designer','published','2024-03-15 03:04:28','2024-03-15 03:04:28'),(4,'Albert Flores','Wedding day savior! 5 stars. Their bridal collection is a game-changer. Made me feel like a star.','main/users/3.jpg','Bank of America','published','2024-03-15 03:04:28','2024-03-15 03:04:28');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'dcruickshank@roob.com',NULL,'$2y$12$sxz/Zp5DeCpHbjdzJQND3Ovzz1QYEzkk1UEMjcKzdrsaDpIVcL8.a',NULL,'2024-03-15 03:04:20','2024-03-15 03:04:20','Yasmine','Daugherty','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SiteInfoWidget','footer_primary_sidebar','shofy-jewelry',1,'{\"id\":\"SiteInfoWidget\",\"logo\":\"main\\/general\\/logo.png\",\"logo_height\":50,\"about\":\"Shofy is a powerful tool eCommerce Laravel script for creating a professional and visually appealing online store.\",\"show_social_links\":true}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(2,'CustomMenuWidget','footer_primary_sidebar','shofy-jewelry',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"My Account\",\"menu_id\":\"my-account\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(3,'CustomMenuWidget','footer_primary_sidebar','shofy-jewelry',3,'{\"id\":\"CustomMenuWidget\",\"name\":\"Information\",\"menu_id\":\"information\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(4,'SiteContactWidget','footer_primary_sidebar','shofy-jewelry',4,'{\"id\":\"SiteContactWidget\",\"name\":\"Talk To Us\",\"phone_label\":\"Got Questions? Call us\",\"phone\":\"+670 413 90 762\",\"email\":\"shofy@support.com\",\"address\":\"79 Sleepy Hollow St. Jamaica, New York 1432\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(5,'ProductCategoriesWidget','footer_primary_sidebar','shofy-jewelry',5,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Health & Beauty\",\"categories\":[5,6,7,8,10,11,12]}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(6,'ProductCategoriesWidget','footer_primary_sidebar','shofy-jewelry',7,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Electronics\",\"categories\":[3,4,15,18,19,20]}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(7,'ProductCategoriesWidget','footer_primary_sidebar','shofy-jewelry',8,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Sweet Treats\",\"categories\":[11,12,13,14,15,16,17]}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(8,'ProductCategoriesWidget','footer_primary_sidebar','shofy-jewelry',9,'{\"id\":\"ProductCategoriesWidget\",\"name\":\"Fashion\",\"categories\":[1,2,3,4,5,6,7,8]}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(9,'NewsletterWidget','footer_top_sidebar','shofy-jewelry',1,'{\"id\":\"NewsletterWidget\",\"title\":\"Subscribe our Newsletter\",\"subtitle\":\"Sale 20% off all store\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(10,'SiteCopyrightWidget','footer_bottom_sidebar','shofy-jewelry',1,'{\"id\":\"SiteCopyrightWidget\",\"content\":\"\\u00a9 %y% All rights Reserved.\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(11,'SiteAcceptedPaymentsWidget','footer_bottom_sidebar','shofy-jewelry',2,'{\"id\":\"SiteAcceptedPaymentsWidget\",\"name\":\"Accepted Payments\",\"image\":\"main\\/general\\/footer-pay.png\",\"url\":\"#\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(12,'BlogSearchWidget','blog_sidebar','shofy-jewelry',1,'{\"id\":\"BlogSearchWidget\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(13,'BlogAboutMeWidget','blog_sidebar','shofy-jewelry',2,'{\"id\":\"BlogAboutMeWidget\",\"name\":\"About Me\",\"author_url\":\"\\/blog\",\"author_avatar\":\"main\\/users\\/6.jpg\",\"author_name\":\"Ravi O\'Leigh\",\"author_role\":\"Photographer & Blogger\",\"author_description\":\"Lorem ligula eget dolor. Aenean massa. Cum sociis que penatibus magnis dis parturient\",\"author_signature\":\"main\\/general\\/signature.png\"}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(14,'BlogPostsWidget','blog_sidebar','shofy-jewelry',3,'{\"id\":\"BlogPostsWidget\",\"name\":\"Latest Posts\",\"limit\":3}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(15,'BlogCategoriesWidget','blog_sidebar','shofy-jewelry',4,'{\"id\":\"BlogCategoriesWidget\",\"name\":\"Categories\",\"number_display\":6}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(16,'BlogTagsWidget','blog_sidebar','shofy-jewelry',5,'{\"id\":\"BlogTagsWidget\",\"name\":\"Popular Tags\",\"number_display\":6}','2024-03-15 03:04:36','2024-03-15 03:04:36'),(17,'ProductDetailInfoWidget','product_details_sidebar','shofy-jewelry',1,'{\"id\":\"ProductDetailInfoWidget\",\"messages\":[[{\"key\":\"message\",\"value\":\"30 days easy returns\"}],[{\"key\":\"message\",\"value\":\"Order yours before 2.30pm for same day dispatch\"}]],\"description\":\"Guaranteed safe & secure checkout\",\"image\":\"main\\/general\\/footer-pay.png\"}','2024-03-15 03:04:36','2024-03-15 03:04:36');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-15 17:05:09
